import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppEngineApplicationConfig extends cdktf.TerraformMetaArguments {
    /**
     * The domain to authenticate users with when using App Engine's User API.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application#auth_domain AppEngineApplication#auth_domain}
     *
     * @stability stable
     */
    readonly authDomain?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application#database_type AppEngineApplication#database_type}.
     *
     * @stability stable
     */
    readonly databaseType?: string;
    /**
     * The location to serve the app from.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application#location_id AppEngineApplication#location_id}
     *
     * @stability stable
     */
    readonly locationId: string;
    /**
     * The project ID to create the application under.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application#project AppEngineApplication#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The serving status of the app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application#serving_status AppEngineApplication#serving_status}
     *
     * @stability stable
     */
    readonly servingStatus?: string;
    /**
     * feature_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application#feature_settings AppEngineApplication#feature_settings}
     *
     * @stability stable
     */
    readonly featureSettings?: AppEngineApplicationFeatureSettings;
    /**
     * iap block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application#iap AppEngineApplication#iap}
     *
     * @stability stable
     */
    readonly iap?: AppEngineApplicationIap;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application#timeouts AppEngineApplication#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AppEngineApplicationTimeouts;
}
/**
 * @stability stable
 */
export declare class AppEngineApplicationUrlDispatchRule extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get domain(): string;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    get service(): string;
}
/**
 * @stability stable
 */
export interface AppEngineApplicationFeatureSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application#split_health_checks AppEngineApplication#split_health_checks}.
     *
     * @stability stable
     */
    readonly splitHealthChecks: boolean | cdktf.IResolvable;
}
export declare function appEngineApplicationFeatureSettingsToTerraform(struct?: AppEngineApplicationFeatureSettingsOutputReference | AppEngineApplicationFeatureSettings): any;
/**
 * @stability stable
 */
export declare class AppEngineApplicationFeatureSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineApplicationFeatureSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineApplicationFeatureSettings | undefined);
    private _splitHealthChecks?;
    /**
     * @stability stable
     */
    get splitHealthChecks(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set splitHealthChecks(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get splitHealthChecksInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface AppEngineApplicationIap {
    /**
     * Adapted for use with the app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application#enabled AppEngineApplication#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * OAuth2 client ID to use for the authentication flow.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application#oauth2_client_id AppEngineApplication#oauth2_client_id}
     *
     * @stability stable
     */
    readonly oauth2ClientId: string;
    /**
     * OAuth2 client secret to use for the authentication flow.
     *
     * The SHA-256 hash of the value is returned in the oauth2ClientSecretSha256 field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application#oauth2_client_secret AppEngineApplication#oauth2_client_secret}
     *
     * @stability stable
     */
    readonly oauth2ClientSecret: string;
}
export declare function appEngineApplicationIapToTerraform(struct?: AppEngineApplicationIapOutputReference | AppEngineApplicationIap): any;
/**
 * @stability stable
 */
export declare class AppEngineApplicationIapOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineApplicationIap | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineApplicationIap | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _oauth2ClientId?;
    /**
     * @stability stable
     */
    get oauth2ClientId(): string;
    /**
     * @stability stable
     */
    set oauth2ClientId(value: string);
    /**
     * @stability stable
     */
    get oauth2ClientIdInput(): string | undefined;
    private _oauth2ClientSecret?;
    /**
     * @stability stable
     */
    get oauth2ClientSecret(): string;
    /**
     * @stability stable
     */
    set oauth2ClientSecret(value: string);
    /**
     * @stability stable
     */
    get oauth2ClientSecretInput(): string | undefined;
    /**
     * @stability stable
     */
    get oauth2ClientSecretSha256(): string;
}
/**
 * @stability stable
 */
export interface AppEngineApplicationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application#create AppEngineApplication#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application#update AppEngineApplication#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function appEngineApplicationTimeoutsToTerraform(struct?: AppEngineApplicationTimeoutsOutputReference | AppEngineApplicationTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class AppEngineApplicationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineApplicationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineApplicationTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/app_engine_application google_app_engine_application}.
 *
 * @stability stable
 */
export declare class AppEngineApplication extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/app_engine_application google_app_engine_application} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppEngineApplicationConfig);
    /**
     * @stability stable
     */
    get appId(): string;
    private _authDomain?;
    /**
     * @stability stable
     */
    get authDomain(): string;
    /**
     * @stability stable
     */
    set authDomain(value: string);
    /**
     * @stability stable
     */
    resetAuthDomain(): void;
    /**
     * @stability stable
     */
    get authDomainInput(): string | undefined;
    /**
     * @stability stable
     */
    get codeBucket(): string;
    private _databaseType?;
    /**
     * @stability stable
     */
    get databaseType(): string;
    /**
     * @stability stable
     */
    set databaseType(value: string);
    /**
     * @stability stable
     */
    resetDatabaseType(): void;
    /**
     * @stability stable
     */
    get databaseTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get defaultBucket(): string;
    /**
     * @stability stable
     */
    get defaultHostname(): string;
    /**
     * @stability stable
     */
    get gcrDomain(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _locationId?;
    /**
     * @stability stable
     */
    get locationId(): string;
    /**
     * @stability stable
     */
    set locationId(value: string);
    /**
     * @stability stable
     */
    get locationIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _servingStatus?;
    /**
     * @stability stable
     */
    get servingStatus(): string;
    /**
     * @stability stable
     */
    set servingStatus(value: string);
    /**
     * @stability stable
     */
    resetServingStatus(): void;
    /**
     * @stability stable
     */
    get servingStatusInput(): string | undefined;
    /**
     * @stability stable
     */
    urlDispatchRule(index: string): AppEngineApplicationUrlDispatchRule;
    private _featureSettings;
    /**
     * @stability stable
     */
    get featureSettings(): AppEngineApplicationFeatureSettingsOutputReference;
    /**
     * @stability stable
     */
    putFeatureSettings(value: AppEngineApplicationFeatureSettings): void;
    /**
     * @stability stable
     */
    resetFeatureSettings(): void;
    /**
     * @stability stable
     */
    get featureSettingsInput(): AppEngineApplicationFeatureSettings | undefined;
    private _iap;
    /**
     * @stability stable
     */
    get iap(): AppEngineApplicationIapOutputReference;
    /**
     * @stability stable
     */
    putIap(value: AppEngineApplicationIap): void;
    /**
     * @stability stable
     */
    resetIap(): void;
    /**
     * @stability stable
     */
    get iapInput(): AppEngineApplicationIap | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AppEngineApplicationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AppEngineApplicationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AppEngineApplicationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
