import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppEngineServiceSplitTrafficConfig extends cdktf.TerraformMetaArguments {
    /**
     * If set to true traffic will be migrated to this version.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic#migrate_traffic AppEngineServiceSplitTraffic#migrate_traffic}
     *
     * @stability stable
     */
    readonly migrateTraffic?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic#project AppEngineServiceSplitTraffic#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The name of the service these settings apply to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic#service AppEngineServiceSplitTraffic#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * split block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic#split AppEngineServiceSplitTraffic#split}
     *
     * @stability stable
     */
    readonly split: AppEngineServiceSplitTrafficSplit;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic#timeouts AppEngineServiceSplitTraffic#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AppEngineServiceSplitTrafficTimeouts;
}
/**
 * @stability stable
 */
export interface AppEngineServiceSplitTrafficSplit {
    /**
     * Mapping from version IDs within the service to fractional (0.000, 1] allocations of traffic for that version. Each version can be specified only once, but some versions in the service may not have any traffic allocation. Services that have traffic allocated cannot be deleted until either the service is deleted or their traffic allocation is removed. Allocations must sum to 1. Up to two decimal place precision is supported for IP-based splits and up to three decimal places is supported for cookie-based splits.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic#allocations AppEngineServiceSplitTraffic#allocations}
     *
     * @stability stable
     */
    readonly allocations: {
        [key: string]: string;
    };
    /**
     * Mechanism used to determine which version a request is sent to.
     *
     * The traffic selection algorithm will be stable for either type until allocations are changed. Possible values: ["UNSPECIFIED", "COOKIE", "IP", "RANDOM"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic#shard_by AppEngineServiceSplitTraffic#shard_by}
     *
     * @stability stable
     */
    readonly shardBy?: string;
}
export declare function appEngineServiceSplitTrafficSplitToTerraform(struct?: AppEngineServiceSplitTrafficSplitOutputReference | AppEngineServiceSplitTrafficSplit): any;
/**
 * @stability stable
 */
export declare class AppEngineServiceSplitTrafficSplitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineServiceSplitTrafficSplit | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineServiceSplitTrafficSplit | undefined);
    private _allocations?;
    /**
     * @stability stable
     */
    get allocations(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set allocations(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    get allocationsInput(): {
        [key: string]: string;
    } | undefined;
    private _shardBy?;
    /**
     * @stability stable
     */
    get shardBy(): string;
    /**
     * @stability stable
     */
    set shardBy(value: string);
    /**
     * @stability stable
     */
    resetShardBy(): void;
    /**
     * @stability stable
     */
    get shardByInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppEngineServiceSplitTrafficTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic#create AppEngineServiceSplitTraffic#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic#delete AppEngineServiceSplitTraffic#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic#update AppEngineServiceSplitTraffic#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function appEngineServiceSplitTrafficTimeoutsToTerraform(struct?: AppEngineServiceSplitTrafficTimeoutsOutputReference | AppEngineServiceSplitTrafficTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class AppEngineServiceSplitTrafficTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineServiceSplitTrafficTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineServiceSplitTrafficTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic google_app_engine_service_split_traffic}.
 *
 * @stability stable
 */
export declare class AppEngineServiceSplitTraffic extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_split_traffic google_app_engine_service_split_traffic} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppEngineServiceSplitTrafficConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _migrateTraffic?;
    /**
     * @stability stable
     */
    get migrateTraffic(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set migrateTraffic(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMigrateTraffic(): void;
    /**
     * @stability stable
     */
    get migrateTrafficInput(): boolean | cdktf.IResolvable | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _split;
    /**
     * @stability stable
     */
    get split(): AppEngineServiceSplitTrafficSplitOutputReference;
    /**
     * @stability stable
     */
    putSplit(value: AppEngineServiceSplitTrafficSplit): void;
    /**
     * @stability stable
     */
    get splitInput(): AppEngineServiceSplitTrafficSplit | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AppEngineServiceSplitTrafficTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AppEngineServiceSplitTrafficTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AppEngineServiceSplitTrafficTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
