import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeNetworkConfig extends cdktf.TerraformMetaArguments {
    /**
     * When set to 'true', the network is created in "auto subnet mode" and it will create a subnet for each region automatically across the '10.128.0.0/9' address range.
     *
     * When set to 'false', the network is created in "custom subnet mode" so
     * the user can explicitly connect subnetwork resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#auto_create_subnetworks ComputeNetwork#auto_create_subnetworks}
     *
     * @stability stable
     */
    readonly autoCreateSubnetworks?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#delete_default_routes_on_create ComputeNetwork#delete_default_routes_on_create}.
     *
     * @stability stable
     */
    readonly deleteDefaultRoutesOnCreate?: boolean | cdktf.IResolvable;
    /**
     * An optional description of this resource. The resource must be recreated to modify this field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#description ComputeNetwork#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Maximum Transmission Unit in bytes. The minimum value for this field is 1460 and the maximum value is 1500 bytes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#mtu ComputeNetwork#mtu}
     *
     * @stability stable
     */
    readonly mtu?: number;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#name ComputeNetwork#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#project ComputeNetwork#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The network-wide routing mode to use.
     *
     * If set to 'REGIONAL', this
     * network's cloud routers will only advertise routes with subnetworks
     * of this network in the same region as the router. If set to 'GLOBAL',
     * this network's cloud routers will advertise routes with all
     * subnetworks of this network, across regions. Possible values: ["REGIONAL", "GLOBAL"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#routing_mode ComputeNetwork#routing_mode}
     *
     * @stability stable
     */
    readonly routingMode?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#timeouts ComputeNetwork#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeNetworkTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeNetworkTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#create ComputeNetwork#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#delete ComputeNetwork#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#update ComputeNetwork#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computeNetworkTimeoutsToTerraform(struct?: ComputeNetworkTimeoutsOutputReference | ComputeNetworkTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ComputeNetworkTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeNetworkTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeNetworkTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_network google_compute_network}.
 *
 * @stability stable
 */
export declare class ComputeNetwork extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_network google_compute_network} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeNetworkConfig);
    private _autoCreateSubnetworks?;
    /**
     * @stability stable
     */
    get autoCreateSubnetworks(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoCreateSubnetworks(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoCreateSubnetworks(): void;
    /**
     * @stability stable
     */
    get autoCreateSubnetworksInput(): boolean | cdktf.IResolvable | undefined;
    private _deleteDefaultRoutesOnCreate?;
    /**
     * @stability stable
     */
    get deleteDefaultRoutesOnCreate(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set deleteDefaultRoutesOnCreate(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDeleteDefaultRoutesOnCreate(): void;
    /**
     * @stability stable
     */
    get deleteDefaultRoutesOnCreateInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get gatewayIpv4(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _mtu?;
    /**
     * @stability stable
     */
    get mtu(): number;
    /**
     * @stability stable
     */
    set mtu(value: number);
    /**
     * @stability stable
     */
    resetMtu(): void;
    /**
     * @stability stable
     */
    get mtuInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _routingMode?;
    /**
     * @stability stable
     */
    get routingMode(): string;
    /**
     * @stability stable
     */
    set routingMode(value: string);
    /**
     * @stability stable
     */
    resetRoutingMode(): void;
    /**
     * @stability stable
     */
    get routingModeInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeNetworkTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeNetworkTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeNetworkTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
