import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeSharedVpcServiceProjectConfig extends cdktf.TerraformMetaArguments {
    /**
     * The ID of a host project to associate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_service_project#host_project ComputeSharedVpcServiceProject#host_project}
     *
     * @stability stable
     */
    readonly hostProject: string;
    /**
     * The ID of the project that will serve as a Shared VPC service project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_service_project#service_project ComputeSharedVpcServiceProject#service_project}
     *
     * @stability stable
     */
    readonly serviceProject: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_service_project#timeouts ComputeSharedVpcServiceProject#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeSharedVpcServiceProjectTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeSharedVpcServiceProjectTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_service_project#create ComputeSharedVpcServiceProject#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_service_project#delete ComputeSharedVpcServiceProject#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
export declare function computeSharedVpcServiceProjectTimeoutsToTerraform(struct?: ComputeSharedVpcServiceProjectTimeoutsOutputReference | ComputeSharedVpcServiceProjectTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ComputeSharedVpcServiceProjectTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeSharedVpcServiceProjectTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeSharedVpcServiceProjectTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_service_project google_compute_shared_vpc_service_project}.
 *
 * @stability stable
 */
export declare class ComputeSharedVpcServiceProject extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_service_project google_compute_shared_vpc_service_project} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeSharedVpcServiceProjectConfig);
    private _hostProject?;
    /**
     * @stability stable
     */
    get hostProject(): string;
    /**
     * @stability stable
     */
    set hostProject(value: string);
    /**
     * @stability stable
     */
    get hostProjectInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _serviceProject?;
    /**
     * @stability stable
     */
    get serviceProject(): string;
    /**
     * @stability stable
     */
    set serviceProject(value: string);
    /**
     * @stability stable
     */
    get serviceProjectInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeSharedVpcServiceProjectTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeSharedVpcServiceProjectTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeSharedVpcServiceProjectTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
