import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeTargetPoolConfig extends cdktf.TerraformMetaArguments {
    /**
     * URL to the backup target pool. Must also set failover_ratio.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_pool#backup_pool ComputeTargetPool#backup_pool}
     *
     * @stability stable
     */
    readonly backupPool?: string;
    /**
     * Textual description field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_pool#description ComputeTargetPool#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Ratio (0 to 1) of failed nodes before using the backup pool (which must also be set).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_pool#failover_ratio ComputeTargetPool#failover_ratio}
     *
     * @stability stable
     */
    readonly failoverRatio?: number;
    /**
     * List of zero or one health check name or self_link. Only legacy google_compute_http_health_check is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_pool#health_checks ComputeTargetPool#health_checks}
     *
     * @stability stable
     */
    readonly healthChecks?: string[];
    /**
     * List of instances in the pool.
     *
     * They can be given as URLs, or in the form of "zone/name". Note that the instances need not exist at the time of target pool creation, so there is no need to use the Terraform interpolators to create a dependency on the instances from the target pool.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_pool#instances ComputeTargetPool#instances}
     *
     * @stability stable
     */
    readonly instances?: string[];
    /**
     * A unique name for the resource, required by GCE. Changing this forces a new resource to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_pool#name ComputeTargetPool#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_pool#project ComputeTargetPool#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Where the target pool resides. Defaults to project region.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_pool#region ComputeTargetPool#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * How to distribute load.
     *
     * Options are "NONE" (no affinity). "CLIENT_IP" (hash of the source/dest addresses / ports), and "CLIENT_IP_PROTO" also includes the protocol (default "NONE").
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_pool#session_affinity ComputeTargetPool#session_affinity}
     *
     * @stability stable
     */
    readonly sessionAffinity?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_pool#timeouts ComputeTargetPool#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeTargetPoolTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeTargetPoolTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_pool#create ComputeTargetPool#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_pool#delete ComputeTargetPool#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_pool#update ComputeTargetPool#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computeTargetPoolTimeoutsToTerraform(struct?: ComputeTargetPoolTimeoutsOutputReference | ComputeTargetPoolTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ComputeTargetPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeTargetPoolTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeTargetPoolTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_target_pool google_compute_target_pool}.
 *
 * @stability stable
 */
export declare class ComputeTargetPool extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_target_pool google_compute_target_pool} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeTargetPoolConfig);
    private _backupPool?;
    /**
     * @stability stable
     */
    get backupPool(): string;
    /**
     * @stability stable
     */
    set backupPool(value: string);
    /**
     * @stability stable
     */
    resetBackupPool(): void;
    /**
     * @stability stable
     */
    get backupPoolInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _failoverRatio?;
    /**
     * @stability stable
     */
    get failoverRatio(): number;
    /**
     * @stability stable
     */
    set failoverRatio(value: number);
    /**
     * @stability stable
     */
    resetFailoverRatio(): void;
    /**
     * @stability stable
     */
    get failoverRatioInput(): number | undefined;
    private _healthChecks?;
    /**
     * @stability stable
     */
    get healthChecks(): string[];
    /**
     * @stability stable
     */
    set healthChecks(value: string[]);
    /**
     * @stability stable
     */
    resetHealthChecks(): void;
    /**
     * @stability stable
     */
    get healthChecksInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _instances?;
    /**
     * @stability stable
     */
    get instances(): string[];
    /**
     * @stability stable
     */
    set instances(value: string[]);
    /**
     * @stability stable
     */
    resetInstances(): void;
    /**
     * @stability stable
     */
    get instancesInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _sessionAffinity?;
    /**
     * @stability stable
     */
    get sessionAffinity(): string;
    /**
     * @stability stable
     */
    set sessionAffinity(value: string);
    /**
     * @stability stable
     */
    resetSessionAffinity(): void;
    /**
     * @stability stable
     */
    get sessionAffinityInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeTargetPoolTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeTargetPoolTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeTargetPoolTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
