import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DeploymentManagerDeploymentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Set the policy to use for creating new resources.
     *
     * Only used on
     * create and update. Valid values are 'CREATE_OR_ACQUIRE' (default) or
     * 'ACQUIRE'. If set to 'ACQUIRE' and resources do not already exist,
     * the deployment will fail. Note that updating this field does not
     * actually affect the deployment, just how it is updated. Default value: "CREATE_OR_ACQUIRE" Possible values: ["ACQUIRE", "CREATE_OR_ACQUIRE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#create_policy DeploymentManagerDeployment#create_policy}
     *
     * @stability stable
     */
    readonly createPolicy?: string;
    /**
     * Set the policy to use for deleting new resources on update/delete.
     *
     * Valid values are 'DELETE' (default) or 'ABANDON'. If 'DELETE',
     * resource is deleted after removal from Deployment Manager. If
     * 'ABANDON', the resource is only removed from Deployment Manager
     * and is not actually deleted. Note that updating this field does not
     * actually change the deployment, just how it is updated. Default value: "DELETE" Possible values: ["ABANDON", "DELETE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#delete_policy DeploymentManagerDeployment#delete_policy}
     *
     * @stability stable
     */
    readonly deletePolicy?: string;
    /**
     * Optional user-provided description of deployment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#description DeploymentManagerDeployment#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Unique name for the deployment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#name DeploymentManagerDeployment#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * If set to true, a deployment is created with "shell" resources that are not actually instantiated.
     *
     * This allows you to preview a
     * deployment. It can be updated to false to actually deploy
     * with real resources.
     * ~>**NOTE:** Deployment Manager does not allow update
     * of a deployment in preview (unless updating to preview=false). Thus,
     * Terraform will force-recreate deployments if either preview is updated
     * to true or if other fields are updated while preview is true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#preview DeploymentManagerDeployment#preview}
     *
     * @stability stable
     */
    readonly preview?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#project DeploymentManagerDeployment#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * labels block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#labels DeploymentManagerDeployment#labels}
     *
     * @stability stable
     */
    readonly labels?: DeploymentManagerDeploymentLabels[] | cdktf.IResolvable;
    /**
     * target block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#target DeploymentManagerDeployment#target}
     *
     * @stability stable
     */
    readonly target: DeploymentManagerDeploymentTarget;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#timeouts DeploymentManagerDeployment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DeploymentManagerDeploymentTimeouts;
}
/**
 * @stability stable
 */
export interface DeploymentManagerDeploymentLabels {
    /**
     * Key for label.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#key DeploymentManagerDeployment#key}
     *
     * @stability stable
     */
    readonly key?: string;
    /**
     * Value of label.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#value DeploymentManagerDeployment#value}
     *
     * @stability stable
     */
    readonly value?: string;
}
export declare function deploymentManagerDeploymentLabelsToTerraform(struct?: DeploymentManagerDeploymentLabels | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DeploymentManagerDeploymentTargetConfig {
    /**
     * The full YAML contents of your configuration file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#content DeploymentManagerDeployment#content}
     *
     * @stability stable
     */
    readonly content: string;
}
export declare function deploymentManagerDeploymentTargetConfigToTerraform(struct?: DeploymentManagerDeploymentTargetConfigOutputReference | DeploymentManagerDeploymentTargetConfig): any;
/**
 * @stability stable
 */
export declare class DeploymentManagerDeploymentTargetConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DeploymentManagerDeploymentTargetConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DeploymentManagerDeploymentTargetConfig | undefined);
    private _content?;
    /**
     * @stability stable
     */
    get content(): string;
    /**
     * @stability stable
     */
    set content(value: string);
    /**
     * @stability stable
     */
    get contentInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DeploymentManagerDeploymentTargetImports {
    /**
     * The full contents of the template that you want to import.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#content DeploymentManagerDeployment#content}
     *
     * @stability stable
     */
    readonly content?: string;
    /**
     * The name of the template to import, as declared in the YAML configuration.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#name DeploymentManagerDeployment#name}
     *
     * @stability stable
     */
    readonly name?: string;
}
export declare function deploymentManagerDeploymentTargetImportsToTerraform(struct?: DeploymentManagerDeploymentTargetImports | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DeploymentManagerDeploymentTarget {
    /**
     * config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#config DeploymentManagerDeployment#config}
     *
     * @stability stable
     */
    readonly config: DeploymentManagerDeploymentTargetConfig;
    /**
     * imports block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#imports DeploymentManagerDeployment#imports}
     *
     * @stability stable
     */
    readonly imports?: DeploymentManagerDeploymentTargetImports[] | cdktf.IResolvable;
}
export declare function deploymentManagerDeploymentTargetToTerraform(struct?: DeploymentManagerDeploymentTargetOutputReference | DeploymentManagerDeploymentTarget): any;
/**
 * @stability stable
 */
export declare class DeploymentManagerDeploymentTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DeploymentManagerDeploymentTarget | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DeploymentManagerDeploymentTarget | undefined);
    private _config;
    /**
     * @stability stable
     */
    get config(): DeploymentManagerDeploymentTargetConfigOutputReference;
    /**
     * @stability stable
     */
    putConfig(value: DeploymentManagerDeploymentTargetConfig): void;
    /**
     * @stability stable
     */
    get configInput(): DeploymentManagerDeploymentTargetConfig | undefined;
    private _imports?;
    /**
     * @stability stable
     */
    get imports(): DeploymentManagerDeploymentTargetImports[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set imports(value: DeploymentManagerDeploymentTargetImports[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetImports(): void;
    /**
     * @stability stable
     */
    get importsInput(): cdktf.IResolvable | DeploymentManagerDeploymentTargetImports[] | undefined;
}
/**
 * @stability stable
 */
export interface DeploymentManagerDeploymentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#create DeploymentManagerDeployment#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#delete DeploymentManagerDeployment#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment#update DeploymentManagerDeployment#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function deploymentManagerDeploymentTimeoutsToTerraform(struct?: DeploymentManagerDeploymentTimeoutsOutputReference | DeploymentManagerDeploymentTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DeploymentManagerDeploymentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DeploymentManagerDeploymentTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DeploymentManagerDeploymentTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment google_deployment_manager_deployment}.
 *
 * @stability stable
 */
export declare class DeploymentManagerDeployment extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment google_deployment_manager_deployment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DeploymentManagerDeploymentConfig);
    private _createPolicy?;
    /**
     * @stability stable
     */
    get createPolicy(): string;
    /**
     * @stability stable
     */
    set createPolicy(value: string);
    /**
     * @stability stable
     */
    resetCreatePolicy(): void;
    /**
     * @stability stable
     */
    get createPolicyInput(): string | undefined;
    private _deletePolicy?;
    /**
     * @stability stable
     */
    get deletePolicy(): string;
    /**
     * @stability stable
     */
    set deletePolicy(value: string);
    /**
     * @stability stable
     */
    resetDeletePolicy(): void;
    /**
     * @stability stable
     */
    get deletePolicyInput(): string | undefined;
    /**
     * @stability stable
     */
    get deploymentId(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get manifest(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _preview?;
    /**
     * @stability stable
     */
    get preview(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set preview(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPreview(): void;
    /**
     * @stability stable
     */
    get previewInput(): boolean | cdktf.IResolvable | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): DeploymentManagerDeploymentLabels[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: DeploymentManagerDeploymentLabels[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | DeploymentManagerDeploymentLabels[] | undefined;
    private _target;
    /**
     * @stability stable
     */
    get target(): DeploymentManagerDeploymentTargetOutputReference;
    /**
     * @stability stable
     */
    putTarget(value: DeploymentManagerDeploymentTarget): void;
    /**
     * @stability stable
     */
    get targetInput(): DeploymentManagerDeploymentTarget | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DeploymentManagerDeploymentTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DeploymentManagerDeploymentTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DeploymentManagerDeploymentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
