import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DialogflowCxFlowConfig extends cdktf.TerraformMetaArguments {
    /**
     * The description of the flow. The maximum length is 500 characters. If exceeded, the request is rejected.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#description DialogflowCxFlow#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The human-readable name of the flow.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#display_name DialogflowCxFlow#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * The language of the following fields in flow: Flow.event_handlers.trigger_fulfillment.messages Flow.event_handlers.trigger_fulfillment.conditional_cases Flow.transition_routes.trigger_fulfillment.messages Flow.transition_routes.trigger_fulfillment.conditional_cases If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#language_code DialogflowCxFlow#language_code}
     *
     * @stability stable
     */
    readonly languageCode?: string;
    /**
     * The agent to create a flow for.  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#parent DialogflowCxFlow#parent}
     *
     * @stability stable
     */
    readonly parent?: string;
    /**
     * A flow's transition route group serve two purposes: They are responsible for matching the user's first utterances in the flow.
     *
     * They are inherited by every page's [transition route groups][Page.transition_route_groups]. Transition route groups defined in the page have higher priority than those defined in the flow.
     * Format:projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#transition_route_groups DialogflowCxFlow#transition_route_groups}
     *
     * @stability stable
     */
    readonly transitionRouteGroups?: string[];
    /**
     * event_handlers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#event_handlers DialogflowCxFlow#event_handlers}
     *
     * @stability stable
     */
    readonly eventHandlers?: DialogflowCxFlowEventHandlers[] | cdktf.IResolvable;
    /**
     * nlu_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#nlu_settings DialogflowCxFlow#nlu_settings}
     *
     * @stability stable
     */
    readonly nluSettings?: DialogflowCxFlowNluSettings;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#timeouts DialogflowCxFlow#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DialogflowCxFlowTimeouts;
    /**
     * transition_routes block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#transition_routes DialogflowCxFlow#transition_routes}
     *
     * @stability stable
     */
    readonly transitionRoutes?: DialogflowCxFlowTransitionRoutes[] | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface DialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText {
    /**
     * A collection of text responses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#text DialogflowCxFlow#text}
     *
     * @stability stable
     */
    readonly text?: string[];
}
export declare function dialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTextToTerraform(struct?: DialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTextOutputReference | DialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText): any;
/**
 * @stability stable
 */
export declare class DialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText | undefined);
    /**
     * @stability stable
     */
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _text?;
    /**
     * @stability stable
     */
    get text(): string[];
    /**
     * @stability stable
     */
    set text(value: string[]);
    /**
     * @stability stable
     */
    resetText(): void;
    /**
     * @stability stable
     */
    get textInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface DialogflowCxFlowEventHandlersTriggerFulfillmentMessages {
    /**
     * text block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#text DialogflowCxFlow#text}
     *
     * @stability stable
     */
    readonly text?: DialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText;
}
export declare function dialogflowCxFlowEventHandlersTriggerFulfillmentMessagesToTerraform(struct?: DialogflowCxFlowEventHandlersTriggerFulfillmentMessages | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DialogflowCxFlowEventHandlersTriggerFulfillment {
    /**
     * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs.
     *
     * If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#return_partial_responses DialogflowCxFlow#return_partial_responses}
     *
     * @stability stable
     */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
     * The tag used by the webhook to identify which fulfillment is being called.
     *
     * This field is required if webhook is specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#tag DialogflowCxFlow#tag}
     *
     * @stability stable
     */
    readonly tag?: string;
    /**
     * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#webhook DialogflowCxFlow#webhook}
     *
     * @stability stable
     */
    readonly webhook?: string;
    /**
     * messages block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#messages DialogflowCxFlow#messages}
     *
     * @stability stable
     */
    readonly messages?: DialogflowCxFlowEventHandlersTriggerFulfillmentMessages[] | cdktf.IResolvable;
}
export declare function dialogflowCxFlowEventHandlersTriggerFulfillmentToTerraform(struct?: DialogflowCxFlowEventHandlersTriggerFulfillmentOutputReference | DialogflowCxFlowEventHandlersTriggerFulfillment): any;
/**
 * @stability stable
 */
export declare class DialogflowCxFlowEventHandlersTriggerFulfillmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DialogflowCxFlowEventHandlersTriggerFulfillment | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DialogflowCxFlowEventHandlersTriggerFulfillment | undefined);
    private _returnPartialResponses?;
    /**
     * @stability stable
     */
    get returnPartialResponses(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set returnPartialResponses(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetReturnPartialResponses(): void;
    /**
     * @stability stable
     */
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    /**
     * @stability stable
     */
    get tag(): string;
    /**
     * @stability stable
     */
    set tag(value: string);
    /**
     * @stability stable
     */
    resetTag(): void;
    /**
     * @stability stable
     */
    get tagInput(): string | undefined;
    private _webhook?;
    /**
     * @stability stable
     */
    get webhook(): string;
    /**
     * @stability stable
     */
    set webhook(value: string);
    /**
     * @stability stable
     */
    resetWebhook(): void;
    /**
     * @stability stable
     */
    get webhookInput(): string | undefined;
    private _messages?;
    /**
     * @stability stable
     */
    get messages(): DialogflowCxFlowEventHandlersTriggerFulfillmentMessages[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set messages(value: DialogflowCxFlowEventHandlersTriggerFulfillmentMessages[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMessages(): void;
    /**
     * @stability stable
     */
    get messagesInput(): cdktf.IResolvable | DialogflowCxFlowEventHandlersTriggerFulfillmentMessages[] | undefined;
}
/**
 * @stability stable
 */
export interface DialogflowCxFlowEventHandlers {
    /**
     * The name of the event to handle.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#event DialogflowCxFlow#event}
     *
     * @stability stable
     */
    readonly event?: string;
    /**
     * The target flow to transition to.  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#target_flow DialogflowCxFlow#target_flow}
     *
     * @stability stable
     */
    readonly targetFlow?: string;
    /**
     * The target page to transition to.  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#target_page DialogflowCxFlow#target_page}
     *
     * @stability stable
     */
    readonly targetPage?: string;
    /**
     * trigger_fulfillment block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#trigger_fulfillment DialogflowCxFlow#trigger_fulfillment}
     *
     * @stability stable
     */
    readonly triggerFulfillment?: DialogflowCxFlowEventHandlersTriggerFulfillment;
}
export declare function dialogflowCxFlowEventHandlersToTerraform(struct?: DialogflowCxFlowEventHandlers | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DialogflowCxFlowNluSettings {
    /**
     * To filter out false positive results and still get variety in matched natural language inputs for your agent, you can tune the machine learning classification threshold.
     *
     * If the returned score value is less than the threshold value, then a no-match event will be triggered. The score values range from 0.0 (completely uncertain) to 1.0 (completely certain). If set to 0.0, the default of 0.3 is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#classification_threshold DialogflowCxFlow#classification_threshold}
     *
     * @stability stable
     */
    readonly classificationThreshold?: number;
    /**
     * Indicates NLU model training mode.
     *
     * MODEL_TRAINING_MODE_AUTOMATIC: NLU model training is automatically triggered when a flow gets modified. User can also manually trigger model training in this mode.
     * MODEL_TRAINING_MODE_MANUAL: User needs to manually trigger NLU model training. Best for large flows whose models take long time to train. Possible values: ["MODEL_TRAINING_MODE_AUTOMATIC", "MODEL_TRAINING_MODE_MANUAL"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#model_training_mode DialogflowCxFlow#model_training_mode}
     *
     * @stability stable
     */
    readonly modelTrainingMode?: string;
    /**
     * Indicates the type of NLU model. MODEL_TYPE_STANDARD: Use standard NLU model. MODEL_TYPE_ADVANCED: Use advanced NLU model. Possible values: ["MODEL_TYPE_STANDARD", "MODEL_TYPE_ADVANCED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#model_type DialogflowCxFlow#model_type}
     *
     * @stability stable
     */
    readonly modelType?: string;
}
export declare function dialogflowCxFlowNluSettingsToTerraform(struct?: DialogflowCxFlowNluSettingsOutputReference | DialogflowCxFlowNluSettings): any;
/**
 * @stability stable
 */
export declare class DialogflowCxFlowNluSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DialogflowCxFlowNluSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DialogflowCxFlowNluSettings | undefined);
    private _classificationThreshold?;
    /**
     * @stability stable
     */
    get classificationThreshold(): number;
    /**
     * @stability stable
     */
    set classificationThreshold(value: number);
    /**
     * @stability stable
     */
    resetClassificationThreshold(): void;
    /**
     * @stability stable
     */
    get classificationThresholdInput(): number | undefined;
    private _modelTrainingMode?;
    /**
     * @stability stable
     */
    get modelTrainingMode(): string;
    /**
     * @stability stable
     */
    set modelTrainingMode(value: string);
    /**
     * @stability stable
     */
    resetModelTrainingMode(): void;
    /**
     * @stability stable
     */
    get modelTrainingModeInput(): string | undefined;
    private _modelType?;
    /**
     * @stability stable
     */
    get modelType(): string;
    /**
     * @stability stable
     */
    set modelType(value: string);
    /**
     * @stability stable
     */
    resetModelType(): void;
    /**
     * @stability stable
     */
    get modelTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DialogflowCxFlowTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#create DialogflowCxFlow#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#delete DialogflowCxFlow#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#update DialogflowCxFlow#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dialogflowCxFlowTimeoutsToTerraform(struct?: DialogflowCxFlowTimeoutsOutputReference | DialogflowCxFlowTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DialogflowCxFlowTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DialogflowCxFlowTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DialogflowCxFlowTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText {
    /**
     * A collection of text responses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#text DialogflowCxFlow#text}
     *
     * @stability stable
     */
    readonly text?: string[];
}
export declare function dialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTextToTerraform(struct?: DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTextOutputReference | DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText): any;
/**
 * @stability stable
 */
export declare class DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText | undefined);
    /**
     * @stability stable
     */
    get allowPlaybackInterruption(): cdktf.IResolvable;
    private _text?;
    /**
     * @stability stable
     */
    get text(): string[];
    /**
     * @stability stable
     */
    set text(value: string[]);
    /**
     * @stability stable
     */
    resetText(): void;
    /**
     * @stability stable
     */
    get textInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages {
    /**
     * text block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#text DialogflowCxFlow#text}
     *
     * @stability stable
     */
    readonly text?: DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText;
}
export declare function dialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesToTerraform(struct?: DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DialogflowCxFlowTransitionRoutesTriggerFulfillment {
    /**
     * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs.
     *
     * If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#return_partial_responses DialogflowCxFlow#return_partial_responses}
     *
     * @stability stable
     */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
     * The tag used by the webhook to identify which fulfillment is being called.
     *
     * This field is required if webhook is specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#tag DialogflowCxFlow#tag}
     *
     * @stability stable
     */
    readonly tag?: string;
    /**
     * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#webhook DialogflowCxFlow#webhook}
     *
     * @stability stable
     */
    readonly webhook?: string;
    /**
     * messages block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#messages DialogflowCxFlow#messages}
     *
     * @stability stable
     */
    readonly messages?: DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages[] | cdktf.IResolvable;
}
export declare function dialogflowCxFlowTransitionRoutesTriggerFulfillmentToTerraform(struct?: DialogflowCxFlowTransitionRoutesTriggerFulfillmentOutputReference | DialogflowCxFlowTransitionRoutesTriggerFulfillment): any;
/**
 * @stability stable
 */
export declare class DialogflowCxFlowTransitionRoutesTriggerFulfillmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DialogflowCxFlowTransitionRoutesTriggerFulfillment | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DialogflowCxFlowTransitionRoutesTriggerFulfillment | undefined);
    private _returnPartialResponses?;
    /**
     * @stability stable
     */
    get returnPartialResponses(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set returnPartialResponses(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetReturnPartialResponses(): void;
    /**
     * @stability stable
     */
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    /**
     * @stability stable
     */
    get tag(): string;
    /**
     * @stability stable
     */
    set tag(value: string);
    /**
     * @stability stable
     */
    resetTag(): void;
    /**
     * @stability stable
     */
    get tagInput(): string | undefined;
    private _webhook?;
    /**
     * @stability stable
     */
    get webhook(): string;
    /**
     * @stability stable
     */
    set webhook(value: string);
    /**
     * @stability stable
     */
    resetWebhook(): void;
    /**
     * @stability stable
     */
    get webhookInput(): string | undefined;
    private _messages?;
    /**
     * @stability stable
     */
    get messages(): DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set messages(value: DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMessages(): void;
    /**
     * @stability stable
     */
    get messagesInput(): cdktf.IResolvable | DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages[] | undefined;
}
/**
 * @stability stable
 */
export interface DialogflowCxFlowTransitionRoutes {
    /**
     * The condition to evaluate against form parameters or session parameters.
     *
     * At least one of intent or condition must be specified. When both intent and condition are specified, the transition can only happen when both are fulfilled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#condition DialogflowCxFlow#condition}
     *
     * @stability stable
     */
    readonly condition?: string;
    /**
     * The unique identifier of an Intent.
     *
     * Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/intents/<Intent ID>. Indicates that the transition can only happen when the given intent is matched. At least one of intent or condition must be specified. When both intent and condition are specified, the transition can only happen when both are fulfilled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#intent DialogflowCxFlow#intent}
     *
     * @stability stable
     */
    readonly intent?: string;
    /**
     * The target flow to transition to.  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#target_flow DialogflowCxFlow#target_flow}
     *
     * @stability stable
     */
    readonly targetFlow?: string;
    /**
     * The target page to transition to.  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#target_page DialogflowCxFlow#target_page}
     *
     * @stability stable
     */
    readonly targetPage?: string;
    /**
     * trigger_fulfillment block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow#trigger_fulfillment DialogflowCxFlow#trigger_fulfillment}
     *
     * @stability stable
     */
    readonly triggerFulfillment?: DialogflowCxFlowTransitionRoutesTriggerFulfillment;
}
export declare function dialogflowCxFlowTransitionRoutesToTerraform(struct?: DialogflowCxFlowTransitionRoutes | cdktf.IResolvable): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow google_dialogflow_cx_flow}.
 *
 * @stability stable
 */
export declare class DialogflowCxFlow extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow google_dialogflow_cx_flow} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DialogflowCxFlowConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _languageCode?;
    /**
     * @stability stable
     */
    get languageCode(): string;
    /**
     * @stability stable
     */
    set languageCode(value: string);
    /**
     * @stability stable
     */
    resetLanguageCode(): void;
    /**
     * @stability stable
     */
    get languageCodeInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _parent?;
    /**
     * @stability stable
     */
    get parent(): string;
    /**
     * @stability stable
     */
    set parent(value: string);
    /**
     * @stability stable
     */
    resetParent(): void;
    /**
     * @stability stable
     */
    get parentInput(): string | undefined;
    private _transitionRouteGroups?;
    /**
     * @stability stable
     */
    get transitionRouteGroups(): string[];
    /**
     * @stability stable
     */
    set transitionRouteGroups(value: string[]);
    /**
     * @stability stable
     */
    resetTransitionRouteGroups(): void;
    /**
     * @stability stable
     */
    get transitionRouteGroupsInput(): string[] | undefined;
    private _eventHandlers?;
    /**
     * @stability stable
     */
    get eventHandlers(): DialogflowCxFlowEventHandlers[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set eventHandlers(value: DialogflowCxFlowEventHandlers[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEventHandlers(): void;
    /**
     * @stability stable
     */
    get eventHandlersInput(): cdktf.IResolvable | DialogflowCxFlowEventHandlers[] | undefined;
    private _nluSettings;
    /**
     * @stability stable
     */
    get nluSettings(): DialogflowCxFlowNluSettingsOutputReference;
    /**
     * @stability stable
     */
    putNluSettings(value: DialogflowCxFlowNluSettings): void;
    /**
     * @stability stable
     */
    resetNluSettings(): void;
    /**
     * @stability stable
     */
    get nluSettingsInput(): DialogflowCxFlowNluSettings | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DialogflowCxFlowTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DialogflowCxFlowTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DialogflowCxFlowTimeouts | undefined;
    private _transitionRoutes?;
    /**
     * @stability stable
     */
    get transitionRoutes(): DialogflowCxFlowTransitionRoutes[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set transitionRoutes(value: DialogflowCxFlowTransitionRoutes[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTransitionRoutes(): void;
    /**
     * @stability stable
     */
    get transitionRoutesInput(): cdktf.IResolvable | DialogflowCxFlowTransitionRoutes[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
