import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface GameServicesGameServerClusterConfig extends cdktf.TerraformMetaArguments {
    /**
     * Required. The resource name of the game server cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster#cluster_id GameServicesGameServerCluster#cluster_id}
     *
     * @stability stable
     */
    readonly clusterId: string;
    /**
     * Human readable description of the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster#description GameServicesGameServerCluster#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The labels associated with this game server cluster. Each label is a key-value pair.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster#labels GameServicesGameServerCluster#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * Location of the Cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster#location GameServicesGameServerCluster#location}
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster#project GameServicesGameServerCluster#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The realm id of the game server realm.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster#realm_id GameServicesGameServerCluster#realm_id}
     *
     * @stability stable
     */
    readonly realmId: string;
    /**
     * connection_info block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster#connection_info GameServicesGameServerCluster#connection_info}
     *
     * @stability stable
     */
    readonly connectionInfo: GameServicesGameServerClusterConnectionInfo;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster#timeouts GameServicesGameServerCluster#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: GameServicesGameServerClusterTimeouts;
}
/**
 * @stability stable
 */
export interface GameServicesGameServerClusterConnectionInfoGkeClusterReference {
    /**
     * The full or partial name of a GKE cluster, using one of the following forms:.
     *
     * 'projects/{project_id}/locations/{location}/clusters/{cluster_id}'
     * 'locations/{location}/clusters/{cluster_id}'
     * '{cluster_id}'
     *
     * If project and location are not specified, the project and location of the
     * GameServerCluster resource are used to generate the full name of the
     * GKE cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster#cluster GameServicesGameServerCluster#cluster}
     *
     * @stability stable
     */
    readonly cluster: string;
}
export declare function gameServicesGameServerClusterConnectionInfoGkeClusterReferenceToTerraform(struct?: GameServicesGameServerClusterConnectionInfoGkeClusterReferenceOutputReference | GameServicesGameServerClusterConnectionInfoGkeClusterReference): any;
/**
 * @stability stable
 */
export declare class GameServicesGameServerClusterConnectionInfoGkeClusterReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): GameServicesGameServerClusterConnectionInfoGkeClusterReference | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: GameServicesGameServerClusterConnectionInfoGkeClusterReference | undefined);
    private _cluster?;
    /**
     * @stability stable
     */
    get cluster(): string;
    /**
     * @stability stable
     */
    set cluster(value: string);
    /**
     * @stability stable
     */
    get clusterInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface GameServicesGameServerClusterConnectionInfo {
    /**
     * Namespace designated on the game server cluster where the game server instances will be created.
     *
     * The namespace existence will be validated
     * during creation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster#namespace GameServicesGameServerCluster#namespace}
     *
     * @stability stable
     */
    readonly namespace: string;
    /**
     * gke_cluster_reference block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster#gke_cluster_reference GameServicesGameServerCluster#gke_cluster_reference}
     *
     * @stability stable
     */
    readonly gkeClusterReference: GameServicesGameServerClusterConnectionInfoGkeClusterReference;
}
export declare function gameServicesGameServerClusterConnectionInfoToTerraform(struct?: GameServicesGameServerClusterConnectionInfoOutputReference | GameServicesGameServerClusterConnectionInfo): any;
/**
 * @stability stable
 */
export declare class GameServicesGameServerClusterConnectionInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): GameServicesGameServerClusterConnectionInfo | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: GameServicesGameServerClusterConnectionInfo | undefined);
    private _namespace?;
    /**
     * @stability stable
     */
    get namespace(): string;
    /**
     * @stability stable
     */
    set namespace(value: string);
    /**
     * @stability stable
     */
    get namespaceInput(): string | undefined;
    private _gkeClusterReference;
    /**
     * @stability stable
     */
    get gkeClusterReference(): GameServicesGameServerClusterConnectionInfoGkeClusterReferenceOutputReference;
    /**
     * @stability stable
     */
    putGkeClusterReference(value: GameServicesGameServerClusterConnectionInfoGkeClusterReference): void;
    /**
     * @stability stable
     */
    get gkeClusterReferenceInput(): GameServicesGameServerClusterConnectionInfoGkeClusterReference | undefined;
}
/**
 * @stability stable
 */
export interface GameServicesGameServerClusterTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster#create GameServicesGameServerCluster#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster#delete GameServicesGameServerCluster#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster#update GameServicesGameServerCluster#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function gameServicesGameServerClusterTimeoutsToTerraform(struct?: GameServicesGameServerClusterTimeoutsOutputReference | GameServicesGameServerClusterTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class GameServicesGameServerClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): GameServicesGameServerClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: GameServicesGameServerClusterTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster google_game_services_game_server_cluster}.
 *
 * @stability stable
 */
export declare class GameServicesGameServerCluster extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_cluster google_game_services_game_server_cluster} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: GameServicesGameServerClusterConfig);
    private _clusterId?;
    /**
     * @stability stable
     */
    get clusterId(): string;
    /**
     * @stability stable
     */
    set clusterId(value: string);
    /**
     * @stability stable
     */
    get clusterIdInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _realmId?;
    /**
     * @stability stable
     */
    get realmId(): string;
    /**
     * @stability stable
     */
    set realmId(value: string);
    /**
     * @stability stable
     */
    get realmIdInput(): string | undefined;
    private _connectionInfo;
    /**
     * @stability stable
     */
    get connectionInfo(): GameServicesGameServerClusterConnectionInfoOutputReference;
    /**
     * @stability stable
     */
    putConnectionInfo(value: GameServicesGameServerClusterConnectionInfo): void;
    /**
     * @stability stable
     */
    get connectionInfoInput(): GameServicesGameServerClusterConnectionInfo | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): GameServicesGameServerClusterTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: GameServicesGameServerClusterTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): GameServicesGameServerClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
