import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface HealthcareHl7V2StoreIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store_iam_binding#hl7_v2_store_id HealthcareHl7V2StoreIamBinding#hl7_v2_store_id}.
     *
     * @stability stable
     */
    readonly hl7V2StoreId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store_iam_binding#members HealthcareHl7V2StoreIamBinding#members}.
     *
     * @stability stable
     */
    readonly members: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store_iam_binding#role HealthcareHl7V2StoreIamBinding#role}.
     *
     * @stability stable
     */
    readonly role: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store_iam_binding#condition HealthcareHl7V2StoreIamBinding#condition}
     *
     * @stability stable
     */
    readonly condition?: HealthcareHl7V2StoreIamBindingCondition;
}
/**
 * @stability stable
 */
export interface HealthcareHl7V2StoreIamBindingCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store_iam_binding#description HealthcareHl7V2StoreIamBinding#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store_iam_binding#expression HealthcareHl7V2StoreIamBinding#expression}.
     *
     * @stability stable
     */
    readonly expression: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store_iam_binding#title HealthcareHl7V2StoreIamBinding#title}.
     *
     * @stability stable
     */
    readonly title: string;
}
export declare function healthcareHl7V2StoreIamBindingConditionToTerraform(struct?: HealthcareHl7V2StoreIamBindingConditionOutputReference | HealthcareHl7V2StoreIamBindingCondition): any;
/**
 * @stability stable
 */
export declare class HealthcareHl7V2StoreIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HealthcareHl7V2StoreIamBindingCondition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HealthcareHl7V2StoreIamBindingCondition | undefined);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _expression?;
    /**
     * @stability stable
     */
    get expression(): string;
    /**
     * @stability stable
     */
    set expression(value: string);
    /**
     * @stability stable
     */
    get expressionInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store_iam_binding google_healthcare_hl7_v2_store_iam_binding}.
 *
 * @stability stable
 */
export declare class HealthcareHl7V2StoreIamBinding extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store_iam_binding google_healthcare_hl7_v2_store_iam_binding} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: HealthcareHl7V2StoreIamBindingConfig);
    /**
     * @stability stable
     */
    get etag(): string;
    private _hl7V2StoreId?;
    /**
     * @stability stable
     */
    get hl7V2StoreId(): string;
    /**
     * @stability stable
     */
    set hl7V2StoreId(value: string);
    /**
     * @stability stable
     */
    get hl7V2StoreIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _members?;
    /**
     * @stability stable
     */
    get members(): string[];
    /**
     * @stability stable
     */
    set members(value: string[]);
    /**
     * @stability stable
     */
    get membersInput(): string[] | undefined;
    private _role?;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    set role(value: string);
    /**
     * @stability stable
     */
    get roleInput(): string | undefined;
    private _condition;
    /**
     * @stability stable
     */
    get condition(): HealthcareHl7V2StoreIamBindingConditionOutputReference;
    /**
     * @stability stable
     */
    putCondition(value: HealthcareHl7V2StoreIamBindingCondition): void;
    /**
     * @stability stable
     */
    resetCondition(): void;
    /**
     * @stability stable
     */
    get conditionInput(): HealthcareHl7V2StoreIamBindingCondition | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
