import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IdentityPlatformInboundSamlConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * Human friendly display name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#display_name IdentityPlatformInboundSamlConfig#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * If this config allows users to sign in with the provider.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#enabled IdentityPlatformInboundSamlConfig#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * The name of the InboundSamlConfig resource.
     *
     * Must start with 'saml.' and can only have alphanumeric characters,
     * hyphens, underscores or periods. The part after 'saml.' must also start with a lowercase letter, end with an
     * alphanumeric character, and have at least 2 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#name IdentityPlatformInboundSamlConfig#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#project IdentityPlatformInboundSamlConfig#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * idp_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#idp_config IdentityPlatformInboundSamlConfig#idp_config}
     *
     * @stability stable
     */
    readonly idpConfig: IdentityPlatformInboundSamlConfigIdpConfig;
    /**
     * sp_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#sp_config IdentityPlatformInboundSamlConfig#sp_config}
     *
     * @stability stable
     */
    readonly spConfig: IdentityPlatformInboundSamlConfigSpConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#timeouts IdentityPlatformInboundSamlConfig#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: IdentityPlatformInboundSamlConfigTimeouts;
}
/**
 * @stability stable
 */
export interface IdentityPlatformInboundSamlConfigIdpConfigIdpCertificates {
    /**
     * The IdP's x509 certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#x509_certificate IdentityPlatformInboundSamlConfig#x509_certificate}
     *
     * @stability stable
     */
    readonly x509Certificate?: string;
}
export declare function identityPlatformInboundSamlConfigIdpConfigIdpCertificatesToTerraform(struct?: IdentityPlatformInboundSamlConfigIdpConfigIdpCertificates | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface IdentityPlatformInboundSamlConfigIdpConfig {
    /**
     * Unique identifier for all SAML entities.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#idp_entity_id IdentityPlatformInboundSamlConfig#idp_entity_id}
     *
     * @stability stable
     */
    readonly idpEntityId: string;
    /**
     * Indicates if outbounding SAMLRequest should be signed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#sign_request IdentityPlatformInboundSamlConfig#sign_request}
     *
     * @stability stable
     */
    readonly signRequest?: boolean | cdktf.IResolvable;
    /**
     * URL to send Authentication request to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#sso_url IdentityPlatformInboundSamlConfig#sso_url}
     *
     * @stability stable
     */
    readonly ssoUrl: string;
    /**
     * idp_certificates block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#idp_certificates IdentityPlatformInboundSamlConfig#idp_certificates}
     *
     * @stability stable
     */
    readonly idpCertificates: IdentityPlatformInboundSamlConfigIdpConfigIdpCertificates[] | cdktf.IResolvable;
}
export declare function identityPlatformInboundSamlConfigIdpConfigToTerraform(struct?: IdentityPlatformInboundSamlConfigIdpConfigOutputReference | IdentityPlatformInboundSamlConfigIdpConfig): any;
/**
 * @stability stable
 */
export declare class IdentityPlatformInboundSamlConfigIdpConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): IdentityPlatformInboundSamlConfigIdpConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: IdentityPlatformInboundSamlConfigIdpConfig | undefined);
    private _idpEntityId?;
    /**
     * @stability stable
     */
    get idpEntityId(): string;
    /**
     * @stability stable
     */
    set idpEntityId(value: string);
    /**
     * @stability stable
     */
    get idpEntityIdInput(): string | undefined;
    private _signRequest?;
    /**
     * @stability stable
     */
    get signRequest(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set signRequest(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSignRequest(): void;
    /**
     * @stability stable
     */
    get signRequestInput(): boolean | cdktf.IResolvable | undefined;
    private _ssoUrl?;
    /**
     * @stability stable
     */
    get ssoUrl(): string;
    /**
     * @stability stable
     */
    set ssoUrl(value: string);
    /**
     * @stability stable
     */
    get ssoUrlInput(): string | undefined;
    private _idpCertificates?;
    /**
     * @stability stable
     */
    get idpCertificates(): IdentityPlatformInboundSamlConfigIdpConfigIdpCertificates[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set idpCertificates(value: IdentityPlatformInboundSamlConfigIdpConfigIdpCertificates[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get idpCertificatesInput(): cdktf.IResolvable | IdentityPlatformInboundSamlConfigIdpConfigIdpCertificates[] | undefined;
}
/**
 * @stability stable
 */
export declare class IdentityPlatformInboundSamlConfigSpConfigSpCertificates extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get x509Certificate(): string;
}
/**
 * @stability stable
 */
export interface IdentityPlatformInboundSamlConfigSpConfig {
    /**
     * Callback URI where responses from IDP are handled. Must start with 'https://'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#callback_uri IdentityPlatformInboundSamlConfig#callback_uri}
     *
     * @stability stable
     */
    readonly callbackUri?: string;
    /**
     * Unique identifier for all SAML entities.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#sp_entity_id IdentityPlatformInboundSamlConfig#sp_entity_id}
     *
     * @stability stable
     */
    readonly spEntityId?: string;
}
export declare function identityPlatformInboundSamlConfigSpConfigToTerraform(struct?: IdentityPlatformInboundSamlConfigSpConfigOutputReference | IdentityPlatformInboundSamlConfigSpConfig): any;
/**
 * @stability stable
 */
export declare class IdentityPlatformInboundSamlConfigSpConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): IdentityPlatformInboundSamlConfigSpConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: IdentityPlatformInboundSamlConfigSpConfig | undefined);
    private _callbackUri?;
    /**
     * @stability stable
     */
    get callbackUri(): string;
    /**
     * @stability stable
     */
    set callbackUri(value: string);
    /**
     * @stability stable
     */
    resetCallbackUri(): void;
    /**
     * @stability stable
     */
    get callbackUriInput(): string | undefined;
    /**
     * @stability stable
     */
    spCertificates(index: string): IdentityPlatformInboundSamlConfigSpConfigSpCertificates;
    private _spEntityId?;
    /**
     * @stability stable
     */
    get spEntityId(): string;
    /**
     * @stability stable
     */
    set spEntityId(value: string);
    /**
     * @stability stable
     */
    resetSpEntityId(): void;
    /**
     * @stability stable
     */
    get spEntityIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface IdentityPlatformInboundSamlConfigTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#create IdentityPlatformInboundSamlConfig#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#delete IdentityPlatformInboundSamlConfig#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config#update IdentityPlatformInboundSamlConfig#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function identityPlatformInboundSamlConfigTimeoutsToTerraform(struct?: IdentityPlatformInboundSamlConfigTimeoutsOutputReference | IdentityPlatformInboundSamlConfigTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class IdentityPlatformInboundSamlConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): IdentityPlatformInboundSamlConfigTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: IdentityPlatformInboundSamlConfigTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config google_identity_platform_inbound_saml_config}.
 *
 * @stability stable
 */
export declare class IdentityPlatformInboundSamlConfig extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/identity_platform_inbound_saml_config google_identity_platform_inbound_saml_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IdentityPlatformInboundSamlConfigConfig);
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _idpConfig;
    /**
     * @stability stable
     */
    get idpConfig(): IdentityPlatformInboundSamlConfigIdpConfigOutputReference;
    /**
     * @stability stable
     */
    putIdpConfig(value: IdentityPlatformInboundSamlConfigIdpConfig): void;
    /**
     * @stability stable
     */
    get idpConfigInput(): IdentityPlatformInboundSamlConfigIdpConfig | undefined;
    private _spConfig;
    /**
     * @stability stable
     */
    get spConfig(): IdentityPlatformInboundSamlConfigSpConfigOutputReference;
    /**
     * @stability stable
     */
    putSpConfig(value: IdentityPlatformInboundSamlConfigSpConfig): void;
    /**
     * @stability stable
     */
    get spConfigInput(): IdentityPlatformInboundSamlConfigSpConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): IdentityPlatformInboundSamlConfigTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: IdentityPlatformInboundSamlConfigTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): IdentityPlatformInboundSamlConfigTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
