import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LoggingMetricConfig extends cdktf.TerraformMetaArguments {
    /**
     * A description of this metric, which is used in documentation. The maximum length of the description is 8000 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#description LoggingMetric#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * An advanced logs filter (https://cloud.google.com/logging/docs/view/advanced-filters) which is used to match log entries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#filter LoggingMetric#filter}
     *
     * @stability stable
     */
    readonly filter: string;
    /**
     * A map from a label key string to an extractor expression which is used to extract data from a log entry field and assign as the label value.
     *
     * Each label key specified in the LabelDescriptor must
     * have an associated extractor expression in this map. The syntax of the extractor expression is
     * the same as for the valueExtractor field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#label_extractors LoggingMetric#label_extractors}
     *
     * @stability stable
     */
    readonly labelExtractors?: {
        [key: string]: string;
    };
    /**
     * The client-assigned metric identifier.
     *
     * Examples - "error_count", "nginx/requests".
     * Metric identifiers are limited to 100 characters and can include only the following
     * characters A-Z, a-z, 0-9, and the special characters _-.,+!*',()%/. The forward-slash
     * character (/) denotes a hierarchy of name pieces, and it cannot be the first character
     * of the name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#name LoggingMetric#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#project LoggingMetric#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * A valueExtractor is required when using a distribution logs-based metric to extract the values to record from a log entry.
     *
     * Two functions are supported for value extraction - EXTRACT(field) or
     * REGEXP_EXTRACT(field, regex). The argument are 1. field - The name of the log entry field from which
     * the value is to be extracted. 2. regex - A regular expression using the Google RE2 syntax
     * (https://github.com/google/re2/wiki/Syntax) with a single capture group to extract data from the specified
     * log entry field. The value of the field is converted to a string before applying the regex. It is an
     * error to specify a regex that does not include exactly one capture group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#value_extractor LoggingMetric#value_extractor}
     *
     * @stability stable
     */
    readonly valueExtractor?: string;
    /**
     * bucket_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#bucket_options LoggingMetric#bucket_options}
     *
     * @stability stable
     */
    readonly bucketOptions?: LoggingMetricBucketOptions;
    /**
     * metric_descriptor block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#metric_descriptor LoggingMetric#metric_descriptor}
     *
     * @stability stable
     */
    readonly metricDescriptor: LoggingMetricMetricDescriptor;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#timeouts LoggingMetric#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: LoggingMetricTimeouts;
}
/**
 * @stability stable
 */
export interface LoggingMetricBucketOptionsExplicitBuckets {
    /**
     * The values must be monotonically increasing.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#bounds LoggingMetric#bounds}
     *
     * @stability stable
     */
    readonly bounds: number[];
}
export declare function loggingMetricBucketOptionsExplicitBucketsToTerraform(struct?: LoggingMetricBucketOptionsExplicitBucketsOutputReference | LoggingMetricBucketOptionsExplicitBuckets): any;
/**
 * @stability stable
 */
export declare class LoggingMetricBucketOptionsExplicitBucketsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LoggingMetricBucketOptionsExplicitBuckets | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LoggingMetricBucketOptionsExplicitBuckets | undefined);
    private _bounds?;
    /**
     * @stability stable
     */
    get bounds(): number[];
    /**
     * @stability stable
     */
    set bounds(value: number[]);
    /**
     * @stability stable
     */
    get boundsInput(): number[] | undefined;
}
/**
 * @stability stable
 */
export interface LoggingMetricBucketOptionsExponentialBuckets {
    /**
     * Must be greater than 1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#growth_factor LoggingMetric#growth_factor}
     *
     * @stability stable
     */
    readonly growthFactor?: number;
    /**
     * Must be greater than 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#num_finite_buckets LoggingMetric#num_finite_buckets}
     *
     * @stability stable
     */
    readonly numFiniteBuckets?: number;
    /**
     * Must be greater than 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#scale LoggingMetric#scale}
     *
     * @stability stable
     */
    readonly scale?: number;
}
export declare function loggingMetricBucketOptionsExponentialBucketsToTerraform(struct?: LoggingMetricBucketOptionsExponentialBucketsOutputReference | LoggingMetricBucketOptionsExponentialBuckets): any;
/**
 * @stability stable
 */
export declare class LoggingMetricBucketOptionsExponentialBucketsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LoggingMetricBucketOptionsExponentialBuckets | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LoggingMetricBucketOptionsExponentialBuckets | undefined);
    private _growthFactor?;
    /**
     * @stability stable
     */
    get growthFactor(): number;
    /**
     * @stability stable
     */
    set growthFactor(value: number);
    /**
     * @stability stable
     */
    resetGrowthFactor(): void;
    /**
     * @stability stable
     */
    get growthFactorInput(): number | undefined;
    private _numFiniteBuckets?;
    /**
     * @stability stable
     */
    get numFiniteBuckets(): number;
    /**
     * @stability stable
     */
    set numFiniteBuckets(value: number);
    /**
     * @stability stable
     */
    resetNumFiniteBuckets(): void;
    /**
     * @stability stable
     */
    get numFiniteBucketsInput(): number | undefined;
    private _scale?;
    /**
     * @stability stable
     */
    get scale(): number;
    /**
     * @stability stable
     */
    set scale(value: number);
    /**
     * @stability stable
     */
    resetScale(): void;
    /**
     * @stability stable
     */
    get scaleInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface LoggingMetricBucketOptionsLinearBuckets {
    /**
     * Must be greater than 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#num_finite_buckets LoggingMetric#num_finite_buckets}
     *
     * @stability stable
     */
    readonly numFiniteBuckets?: number;
    /**
     * Lower bound of the first bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#offset LoggingMetric#offset}
     *
     * @stability stable
     */
    readonly offset?: number;
    /**
     * Must be greater than 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#width LoggingMetric#width}
     *
     * @stability stable
     */
    readonly width?: number;
}
export declare function loggingMetricBucketOptionsLinearBucketsToTerraform(struct?: LoggingMetricBucketOptionsLinearBucketsOutputReference | LoggingMetricBucketOptionsLinearBuckets): any;
/**
 * @stability stable
 */
export declare class LoggingMetricBucketOptionsLinearBucketsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LoggingMetricBucketOptionsLinearBuckets | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LoggingMetricBucketOptionsLinearBuckets | undefined);
    private _numFiniteBuckets?;
    /**
     * @stability stable
     */
    get numFiniteBuckets(): number;
    /**
     * @stability stable
     */
    set numFiniteBuckets(value: number);
    /**
     * @stability stable
     */
    resetNumFiniteBuckets(): void;
    /**
     * @stability stable
     */
    get numFiniteBucketsInput(): number | undefined;
    private _offset?;
    /**
     * @stability stable
     */
    get offset(): number;
    /**
     * @stability stable
     */
    set offset(value: number);
    /**
     * @stability stable
     */
    resetOffset(): void;
    /**
     * @stability stable
     */
    get offsetInput(): number | undefined;
    private _width?;
    /**
     * @stability stable
     */
    get width(): number;
    /**
     * @stability stable
     */
    set width(value: number);
    /**
     * @stability stable
     */
    resetWidth(): void;
    /**
     * @stability stable
     */
    get widthInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface LoggingMetricBucketOptions {
    /**
     * explicit_buckets block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#explicit_buckets LoggingMetric#explicit_buckets}
     *
     * @stability stable
     */
    readonly explicitBuckets?: LoggingMetricBucketOptionsExplicitBuckets;
    /**
     * exponential_buckets block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#exponential_buckets LoggingMetric#exponential_buckets}
     *
     * @stability stable
     */
    readonly exponentialBuckets?: LoggingMetricBucketOptionsExponentialBuckets;
    /**
     * linear_buckets block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#linear_buckets LoggingMetric#linear_buckets}
     *
     * @stability stable
     */
    readonly linearBuckets?: LoggingMetricBucketOptionsLinearBuckets;
}
export declare function loggingMetricBucketOptionsToTerraform(struct?: LoggingMetricBucketOptionsOutputReference | LoggingMetricBucketOptions): any;
/**
 * @stability stable
 */
export declare class LoggingMetricBucketOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LoggingMetricBucketOptions | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LoggingMetricBucketOptions | undefined);
    private _explicitBuckets;
    /**
     * @stability stable
     */
    get explicitBuckets(): LoggingMetricBucketOptionsExplicitBucketsOutputReference;
    /**
     * @stability stable
     */
    putExplicitBuckets(value: LoggingMetricBucketOptionsExplicitBuckets): void;
    /**
     * @stability stable
     */
    resetExplicitBuckets(): void;
    /**
     * @stability stable
     */
    get explicitBucketsInput(): LoggingMetricBucketOptionsExplicitBuckets | undefined;
    private _exponentialBuckets;
    /**
     * @stability stable
     */
    get exponentialBuckets(): LoggingMetricBucketOptionsExponentialBucketsOutputReference;
    /**
     * @stability stable
     */
    putExponentialBuckets(value: LoggingMetricBucketOptionsExponentialBuckets): void;
    /**
     * @stability stable
     */
    resetExponentialBuckets(): void;
    /**
     * @stability stable
     */
    get exponentialBucketsInput(): LoggingMetricBucketOptionsExponentialBuckets | undefined;
    private _linearBuckets;
    /**
     * @stability stable
     */
    get linearBuckets(): LoggingMetricBucketOptionsLinearBucketsOutputReference;
    /**
     * @stability stable
     */
    putLinearBuckets(value: LoggingMetricBucketOptionsLinearBuckets): void;
    /**
     * @stability stable
     */
    resetLinearBuckets(): void;
    /**
     * @stability stable
     */
    get linearBucketsInput(): LoggingMetricBucketOptionsLinearBuckets | undefined;
}
/**
 * @stability stable
 */
export interface LoggingMetricMetricDescriptorLabels {
    /**
     * A human-readable description for the label.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#description LoggingMetric#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The label key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#key LoggingMetric#key}
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * The type of data that can be assigned to the label. Default value: "STRING" Possible values: ["BOOL", "INT64", "STRING"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#value_type LoggingMetric#value_type}
     *
     * @stability stable
     */
    readonly valueType?: string;
}
export declare function loggingMetricMetricDescriptorLabelsToTerraform(struct?: LoggingMetricMetricDescriptorLabels | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface LoggingMetricMetricDescriptor {
    /**
     * A concise name for the metric, which can be displayed in user interfaces.
     *
     * Use sentence case
     * without an ending period, for example "Request count". This field is optional but it is
     * recommended to be set for any metrics associated with user-visible concepts, such as Quota.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#display_name LoggingMetric#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * Whether the metric records instantaneous values, changes to a value, etc.
     *
     * Some combinations of metricKind and valueType might not be supported.
     * For counter metrics, set this to DELTA. Possible values: ["DELTA", "GAUGE", "CUMULATIVE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#metric_kind LoggingMetric#metric_kind}
     *
     * @stability stable
     */
    readonly metricKind: string;
    /**
     * The unit in which the metric value is reported.
     *
     * It is only applicable if the valueType is
     * 'INT64', 'DOUBLE', or 'DISTRIBUTION'. The supported units are a subset of
     * [The Unified Code for Units of Measure](http://unitsofmeasure.org/ucum.html) standard
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#unit LoggingMetric#unit}
     *
     * @stability stable
     */
    readonly unit?: string;
    /**
     * Whether the measurement is an integer, a floating-point number, etc.
     *
     * Some combinations of metricKind and valueType might not be supported.
     * For counter metrics, set this to INT64. Possible values: ["BOOL", "INT64", "DOUBLE", "STRING", "DISTRIBUTION", "MONEY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#value_type LoggingMetric#value_type}
     *
     * @stability stable
     */
    readonly valueType: string;
    /**
     * labels block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#labels LoggingMetric#labels}
     *
     * @stability stable
     */
    readonly labels?: LoggingMetricMetricDescriptorLabels[] | cdktf.IResolvable;
}
export declare function loggingMetricMetricDescriptorToTerraform(struct?: LoggingMetricMetricDescriptorOutputReference | LoggingMetricMetricDescriptor): any;
/**
 * @stability stable
 */
export declare class LoggingMetricMetricDescriptorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LoggingMetricMetricDescriptor | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LoggingMetricMetricDescriptor | undefined);
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _metricKind?;
    /**
     * @stability stable
     */
    get metricKind(): string;
    /**
     * @stability stable
     */
    set metricKind(value: string);
    /**
     * @stability stable
     */
    get metricKindInput(): string | undefined;
    private _unit?;
    /**
     * @stability stable
     */
    get unit(): string;
    /**
     * @stability stable
     */
    set unit(value: string);
    /**
     * @stability stable
     */
    resetUnit(): void;
    /**
     * @stability stable
     */
    get unitInput(): string | undefined;
    private _valueType?;
    /**
     * @stability stable
     */
    get valueType(): string;
    /**
     * @stability stable
     */
    set valueType(value: string);
    /**
     * @stability stable
     */
    get valueTypeInput(): string | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): LoggingMetricMetricDescriptorLabels[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: LoggingMetricMetricDescriptorLabels[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | LoggingMetricMetricDescriptorLabels[] | undefined;
}
/**
 * @stability stable
 */
export interface LoggingMetricTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#create LoggingMetric#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#delete LoggingMetric#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_metric#update LoggingMetric#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function loggingMetricTimeoutsToTerraform(struct?: LoggingMetricTimeoutsOutputReference | LoggingMetricTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class LoggingMetricTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LoggingMetricTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LoggingMetricTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/logging_metric google_logging_metric}.
 *
 * @stability stable
 */
export declare class LoggingMetric extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/logging_metric google_logging_metric} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LoggingMetricConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _filter?;
    /**
     * @stability stable
     */
    get filter(): string;
    /**
     * @stability stable
     */
    set filter(value: string);
    /**
     * @stability stable
     */
    get filterInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labelExtractors?;
    /**
     * @stability stable
     */
    get labelExtractors(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set labelExtractors(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetLabelExtractors(): void;
    /**
     * @stability stable
     */
    get labelExtractorsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _valueExtractor?;
    /**
     * @stability stable
     */
    get valueExtractor(): string;
    /**
     * @stability stable
     */
    set valueExtractor(value: string);
    /**
     * @stability stable
     */
    resetValueExtractor(): void;
    /**
     * @stability stable
     */
    get valueExtractorInput(): string | undefined;
    private _bucketOptions;
    /**
     * @stability stable
     */
    get bucketOptions(): LoggingMetricBucketOptionsOutputReference;
    /**
     * @stability stable
     */
    putBucketOptions(value: LoggingMetricBucketOptions): void;
    /**
     * @stability stable
     */
    resetBucketOptions(): void;
    /**
     * @stability stable
     */
    get bucketOptionsInput(): LoggingMetricBucketOptions | undefined;
    private _metricDescriptor;
    /**
     * @stability stable
     */
    get metricDescriptor(): LoggingMetricMetricDescriptorOutputReference;
    /**
     * @stability stable
     */
    putMetricDescriptor(value: LoggingMetricMetricDescriptor): void;
    /**
     * @stability stable
     */
    get metricDescriptorInput(): LoggingMetricMetricDescriptor | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): LoggingMetricTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: LoggingMetricTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): LoggingMetricTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
