import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MonitoringCustomServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name used for UI elements listing this Service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service#display_name MonitoringCustomService#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service#project MonitoringCustomService#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * An optional service ID to use. If not given, the server will generate a service ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service#service_id MonitoringCustomService#service_id}
     *
     * @stability stable
     */
    readonly serviceId?: string;
    /**
     * telemetry block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service#telemetry MonitoringCustomService#telemetry}
     *
     * @stability stable
     */
    readonly telemetry?: MonitoringCustomServiceTelemetry;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service#timeouts MonitoringCustomService#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MonitoringCustomServiceTimeouts;
}
/**
 * @stability stable
 */
export interface MonitoringCustomServiceTelemetry {
    /**
     * The full name of the resource that defines this service. Formatted as described in https://cloud.google.com/apis/design/resource_names.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service#resource_name MonitoringCustomService#resource_name}
     *
     * @stability stable
     */
    readonly resourceName?: string;
}
export declare function monitoringCustomServiceTelemetryToTerraform(struct?: MonitoringCustomServiceTelemetryOutputReference | MonitoringCustomServiceTelemetry): any;
/**
 * @stability stable
 */
export declare class MonitoringCustomServiceTelemetryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringCustomServiceTelemetry | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringCustomServiceTelemetry | undefined);
    private _resourceName?;
    /**
     * @stability stable
     */
    get resourceName(): string;
    /**
     * @stability stable
     */
    set resourceName(value: string);
    /**
     * @stability stable
     */
    resetResourceName(): void;
    /**
     * @stability stable
     */
    get resourceNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringCustomServiceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service#create MonitoringCustomService#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service#delete MonitoringCustomService#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service#update MonitoringCustomService#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function monitoringCustomServiceTimeoutsToTerraform(struct?: MonitoringCustomServiceTimeoutsOutputReference | MonitoringCustomServiceTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class MonitoringCustomServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringCustomServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringCustomServiceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service google_monitoring_custom_service}.
 *
 * @stability stable
 */
export declare class MonitoringCustomService extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service google_monitoring_custom_service} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: MonitoringCustomServiceConfig);
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _serviceId?;
    /**
     * @stability stable
     */
    get serviceId(): string;
    /**
     * @stability stable
     */
    set serviceId(value: string);
    /**
     * @stability stable
     */
    resetServiceId(): void;
    /**
     * @stability stable
     */
    get serviceIdInput(): string | undefined;
    private _telemetry;
    /**
     * @stability stable
     */
    get telemetry(): MonitoringCustomServiceTelemetryOutputReference;
    /**
     * @stability stable
     */
    putTelemetry(value: MonitoringCustomServiceTelemetry): void;
    /**
     * @stability stable
     */
    resetTelemetry(): void;
    /**
     * @stability stable
     */
    get telemetryInput(): MonitoringCustomServiceTelemetry | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MonitoringCustomServiceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MonitoringCustomServiceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MonitoringCustomServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
