import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PrivatecaCaPoolConfig extends cdktf.TerraformMetaArguments {
    /**
     * Labels with user-defined metadata.
     *
     * An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass":
     * "1.3kg", "count": "3" }.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#labels PrivatecaCaPool#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * Location of the CaPool. A full list of valid locations can be found by running 'gcloud privateca locations list'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#location PrivatecaCaPool#location}
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * The name for this CaPool.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#name PrivatecaCaPool#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#project PrivatecaCaPool#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The Tier of this CaPool. Possible values: ["ENTERPRISE", "DEVOPS"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#tier PrivatecaCaPool#tier}
     *
     * @stability stable
     */
    readonly tier: string;
    /**
     * issuance_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#issuance_policy PrivatecaCaPool#issuance_policy}
     *
     * @stability stable
     */
    readonly issuancePolicy?: PrivatecaCaPoolIssuancePolicy;
    /**
     * publishing_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#publishing_options PrivatecaCaPool#publishing_options}
     *
     * @stability stable
     */
    readonly publishingOptions?: PrivatecaCaPoolPublishingOptions;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#timeouts PrivatecaCaPool#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: PrivatecaCaPoolTimeouts;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyAllowedIssuanceModes {
    /**
     * When true, allows callers to create Certificates by specifying a CertificateConfig.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#allow_config_based_issuance PrivatecaCaPool#allow_config_based_issuance}
     *
     * @stability stable
     */
    readonly allowConfigBasedIssuance: boolean | cdktf.IResolvable;
    /**
     * When true, allows callers to create Certificates by specifying a CSR.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#allow_csr_based_issuance PrivatecaCaPool#allow_csr_based_issuance}
     *
     * @stability stable
     */
    readonly allowCsrBasedIssuance: boolean | cdktf.IResolvable;
}
export declare function privatecaCaPoolIssuancePolicyAllowedIssuanceModesToTerraform(struct?: PrivatecaCaPoolIssuancePolicyAllowedIssuanceModesOutputReference | PrivatecaCaPoolIssuancePolicyAllowedIssuanceModes): any;
/**
 * @stability stable
 */
export declare class PrivatecaCaPoolIssuancePolicyAllowedIssuanceModesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCaPoolIssuancePolicyAllowedIssuanceModes | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCaPoolIssuancePolicyAllowedIssuanceModes | undefined);
    private _allowConfigBasedIssuance?;
    /**
     * @stability stable
     */
    get allowConfigBasedIssuance(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowConfigBasedIssuance(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get allowConfigBasedIssuanceInput(): boolean | cdktf.IResolvable | undefined;
    private _allowCsrBasedIssuance?;
    /**
     * @stability stable
     */
    get allowCsrBasedIssuance(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowCsrBasedIssuance(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get allowCsrBasedIssuanceInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurve {
    /**
     * The algorithm used. Possible values: ["ECDSA_P256", "ECDSA_P384", "EDDSA_25519"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#signature_algorithm PrivatecaCaPool#signature_algorithm}
     *
     * @stability stable
     */
    readonly signatureAlgorithm: string;
}
export declare function privatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurveToTerraform(struct?: PrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurveOutputReference | PrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurve): any;
/**
 * @stability stable
 */
export declare class PrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurve | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurve | undefined);
    private _signatureAlgorithm?;
    /**
     * @stability stable
     */
    get signatureAlgorithm(): string;
    /**
     * @stability stable
     */
    set signatureAlgorithm(value: string);
    /**
     * @stability stable
     */
    get signatureAlgorithmInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsa {
    /**
     * The maximum allowed RSA modulus size, in bits.
     *
     * If this is not set, or if set to zero, the
     * service will not enforce an explicit upper bound on RSA modulus sizes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#max_modulus_size PrivatecaCaPool#max_modulus_size}
     *
     * @stability stable
     */
    readonly maxModulusSize?: string;
    /**
     * The minimum allowed RSA modulus size, in bits.
     *
     * If this is not set, or if set to zero, the
     * service-level min RSA modulus size will continue to apply.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#min_modulus_size PrivatecaCaPool#min_modulus_size}
     *
     * @stability stable
     */
    readonly minModulusSize?: string;
}
export declare function privatecaCaPoolIssuancePolicyAllowedKeyTypesRsaToTerraform(struct?: PrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsaOutputReference | PrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsa): any;
/**
 * @stability stable
 */
export declare class PrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsa | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsa | undefined);
    private _maxModulusSize?;
    /**
     * @stability stable
     */
    get maxModulusSize(): string;
    /**
     * @stability stable
     */
    set maxModulusSize(value: string);
    /**
     * @stability stable
     */
    resetMaxModulusSize(): void;
    /**
     * @stability stable
     */
    get maxModulusSizeInput(): string | undefined;
    private _minModulusSize?;
    /**
     * @stability stable
     */
    get minModulusSize(): string;
    /**
     * @stability stable
     */
    set minModulusSize(value: string);
    /**
     * @stability stable
     */
    resetMinModulusSize(): void;
    /**
     * @stability stable
     */
    get minModulusSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyAllowedKeyTypes {
    /**
     * elliptic_curve block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#elliptic_curve PrivatecaCaPool#elliptic_curve}
     *
     * @stability stable
     */
    readonly ellipticCurve?: PrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurve;
    /**
     * rsa block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#rsa PrivatecaCaPool#rsa}
     *
     * @stability stable
     */
    readonly rsa?: PrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsa;
}
export declare function privatecaCaPoolIssuancePolicyAllowedKeyTypesToTerraform(struct?: PrivatecaCaPoolIssuancePolicyAllowedKeyTypes | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectId {
    /**
     * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#object_id_path PrivatecaCaPool#object_id_path}
     *
     * @stability stable
     */
    readonly objectIdPath: number[];
}
export declare function privatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectIdToTerraform(struct?: PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectIdOutputReference | PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectId): any;
/**
 * @stability stable
 */
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectIdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectId | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectId | undefined);
    private _objectIdPath?;
    /**
     * @stability stable
     */
    get objectIdPath(): number[];
    /**
     * @stability stable
     */
    set objectIdPath(value: number[]);
    /**
     * @stability stable
     */
    get objectIdPathInput(): number[] | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions {
    /**
     * Indicates whether or not this extension is critical (i.e., if the client does not know how to handle this extension, the client should consider this to be an error).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#critical PrivatecaCaPool#critical}
     *
     * @stability stable
     */
    readonly critical: boolean | cdktf.IResolvable;
    /**
     * The value of this X.509 extension. A base64-encoded string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#value PrivatecaCaPool#value}
     *
     * @stability stable
     */
    readonly value: string;
    /**
     * object_id block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#object_id PrivatecaCaPool#object_id}
     *
     * @stability stable
     */
    readonly objectId: PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectId;
}
export declare function privatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsToTerraform(struct?: PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptions {
    /**
     * Refers to the "CA" X.509 extension, which is a boolean value. When this value is missing, the extension will be omitted from the CA certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#is_ca PrivatecaCaPool#is_ca}
     *
     * @stability stable
     */
    readonly isCa?: boolean | cdktf.IResolvable;
    /**
     * Refers to the path length restriction X.509 extension. For a CA certificate, this value describes the depth of subordinate CA certificates that are allowed. If this value is less than 0, the request will fail. If this value is missing, the max path length will be omitted from the CA certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#max_issuer_path_length PrivatecaCaPool#max_issuer_path_length}
     *
     * @stability stable
     */
    readonly maxIssuerPathLength?: number;
}
export declare function privatecaCaPoolIssuancePolicyBaselineValuesCaOptionsToTerraform(struct?: PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptionsOutputReference | PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptions): any;
/**
 * @stability stable
 */
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptions | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptions | undefined);
    private _isCa?;
    /**
     * @stability stable
     */
    get isCa(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isCa(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsCa(): void;
    /**
     * @stability stable
     */
    get isCaInput(): boolean | cdktf.IResolvable | undefined;
    private _maxIssuerPathLength?;
    /**
     * @stability stable
     */
    get maxIssuerPathLength(): number;
    /**
     * @stability stable
     */
    set maxIssuerPathLength(value: number);
    /**
     * @stability stable
     */
    resetMaxIssuerPathLength(): void;
    /**
     * @stability stable
     */
    get maxIssuerPathLengthInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage {
    /**
     * The key may be used to sign certificates.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#cert_sign PrivatecaCaPool#cert_sign}
     *
     * @stability stable
     */
    readonly certSign?: boolean | cdktf.IResolvable;
    /**
     * The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#content_commitment PrivatecaCaPool#content_commitment}
     *
     * @stability stable
     */
    readonly contentCommitment?: boolean | cdktf.IResolvable;
    /**
     * The key may be used sign certificate revocation lists.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#crl_sign PrivatecaCaPool#crl_sign}
     *
     * @stability stable
     */
    readonly crlSign?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to encipher data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#data_encipherment PrivatecaCaPool#data_encipherment}
     *
     * @stability stable
     */
    readonly dataEncipherment?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to decipher only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#decipher_only PrivatecaCaPool#decipher_only}
     *
     * @stability stable
     */
    readonly decipherOnly?: boolean | cdktf.IResolvable;
    /**
     * The key may be used for digital signatures.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#digital_signature PrivatecaCaPool#digital_signature}
     *
     * @stability stable
     */
    readonly digitalSignature?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to encipher only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#encipher_only PrivatecaCaPool#encipher_only}
     *
     * @stability stable
     */
    readonly encipherOnly?: boolean | cdktf.IResolvable;
    /**
     * The key may be used in a key agreement protocol.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#key_agreement PrivatecaCaPool#key_agreement}
     *
     * @stability stable
     */
    readonly keyAgreement?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to encipher other keys.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#key_encipherment PrivatecaCaPool#key_encipherment}
     *
     * @stability stable
     */
    readonly keyEncipherment?: boolean | cdktf.IResolvable;
}
export declare function privatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsageToTerraform(struct?: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsageOutputReference | PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage): any;
/**
 * @stability stable
 */
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage | undefined);
    private _certSign?;
    /**
     * @stability stable
     */
    get certSign(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set certSign(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCertSign(): void;
    /**
     * @stability stable
     */
    get certSignInput(): boolean | cdktf.IResolvable | undefined;
    private _contentCommitment?;
    /**
     * @stability stable
     */
    get contentCommitment(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set contentCommitment(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetContentCommitment(): void;
    /**
     * @stability stable
     */
    get contentCommitmentInput(): boolean | cdktf.IResolvable | undefined;
    private _crlSign?;
    /**
     * @stability stable
     */
    get crlSign(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set crlSign(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCrlSign(): void;
    /**
     * @stability stable
     */
    get crlSignInput(): boolean | cdktf.IResolvable | undefined;
    private _dataEncipherment?;
    /**
     * @stability stable
     */
    get dataEncipherment(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dataEncipherment(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDataEncipherment(): void;
    /**
     * @stability stable
     */
    get dataEnciphermentInput(): boolean | cdktf.IResolvable | undefined;
    private _decipherOnly?;
    /**
     * @stability stable
     */
    get decipherOnly(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set decipherOnly(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDecipherOnly(): void;
    /**
     * @stability stable
     */
    get decipherOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _digitalSignature?;
    /**
     * @stability stable
     */
    get digitalSignature(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set digitalSignature(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDigitalSignature(): void;
    /**
     * @stability stable
     */
    get digitalSignatureInput(): boolean | cdktf.IResolvable | undefined;
    private _encipherOnly?;
    /**
     * @stability stable
     */
    get encipherOnly(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set encipherOnly(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEncipherOnly(): void;
    /**
     * @stability stable
     */
    get encipherOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _keyAgreement?;
    /**
     * @stability stable
     */
    get keyAgreement(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set keyAgreement(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetKeyAgreement(): void;
    /**
     * @stability stable
     */
    get keyAgreementInput(): boolean | cdktf.IResolvable | undefined;
    private _keyEncipherment?;
    /**
     * @stability stable
     */
    get keyEncipherment(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set keyEncipherment(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetKeyEncipherment(): void;
    /**
     * @stability stable
     */
    get keyEnciphermentInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage {
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#client_auth PrivatecaCaPool#client_auth}
     *
     * @stability stable
     */
    readonly clientAuth?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#code_signing PrivatecaCaPool#code_signing}
     *
     * @stability stable
     */
    readonly codeSigning?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#email_protection PrivatecaCaPool#email_protection}
     *
     * @stability stable
     */
    readonly emailProtection?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#ocsp_signing PrivatecaCaPool#ocsp_signing}
     *
     * @stability stable
     */
    readonly ocspSigning?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#server_auth PrivatecaCaPool#server_auth}
     *
     * @stability stable
     */
    readonly serverAuth?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#time_stamping PrivatecaCaPool#time_stamping}
     *
     * @stability stable
     */
    readonly timeStamping?: boolean | cdktf.IResolvable;
}
export declare function privatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsageToTerraform(struct?: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsageOutputReference | PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage): any;
/**
 * @stability stable
 */
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage | undefined);
    private _clientAuth?;
    /**
     * @stability stable
     */
    get clientAuth(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set clientAuth(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetClientAuth(): void;
    /**
     * @stability stable
     */
    get clientAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _codeSigning?;
    /**
     * @stability stable
     */
    get codeSigning(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set codeSigning(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCodeSigning(): void;
    /**
     * @stability stable
     */
    get codeSigningInput(): boolean | cdktf.IResolvable | undefined;
    private _emailProtection?;
    /**
     * @stability stable
     */
    get emailProtection(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set emailProtection(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEmailProtection(): void;
    /**
     * @stability stable
     */
    get emailProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _ocspSigning?;
    /**
     * @stability stable
     */
    get ocspSigning(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ocspSigning(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOcspSigning(): void;
    /**
     * @stability stable
     */
    get ocspSigningInput(): boolean | cdktf.IResolvable | undefined;
    private _serverAuth?;
    /**
     * @stability stable
     */
    get serverAuth(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set serverAuth(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetServerAuth(): void;
    /**
     * @stability stable
     */
    get serverAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _timeStamping?;
    /**
     * @stability stable
     */
    get timeStamping(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set timeStamping(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTimeStamping(): void;
    /**
     * @stability stable
     */
    get timeStampingInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages {
    /**
     * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#object_id_path PrivatecaCaPool#object_id_path}
     *
     * @stability stable
     */
    readonly objectIdPath: number[];
}
export declare function privatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsagesToTerraform(struct?: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsage {
    /**
     * base_key_usage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#base_key_usage PrivatecaCaPool#base_key_usage}
     *
     * @stability stable
     */
    readonly baseKeyUsage: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage;
    /**
     * extended_key_usage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#extended_key_usage PrivatecaCaPool#extended_key_usage}
     *
     * @stability stable
     */
    readonly extendedKeyUsage: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage;
    /**
     * unknown_extended_key_usages block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#unknown_extended_key_usages PrivatecaCaPool#unknown_extended_key_usages}
     *
     * @stability stable
     */
    readonly unknownExtendedKeyUsages?: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages[] | cdktf.IResolvable;
}
export declare function privatecaCaPoolIssuancePolicyBaselineValuesKeyUsageToTerraform(struct?: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageOutputReference | PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsage): any;
/**
 * @stability stable
 */
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsage | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsage | undefined);
    private _baseKeyUsage;
    /**
     * @stability stable
     */
    get baseKeyUsage(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsageOutputReference;
    /**
     * @stability stable
     */
    putBaseKeyUsage(value: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage): void;
    /**
     * @stability stable
     */
    get baseKeyUsageInput(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage | undefined;
    private _extendedKeyUsage;
    /**
     * @stability stable
     */
    get extendedKeyUsage(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsageOutputReference;
    /**
     * @stability stable
     */
    putExtendedKeyUsage(value: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage): void;
    /**
     * @stability stable
     */
    get extendedKeyUsageInput(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage | undefined;
    private _unknownExtendedKeyUsages?;
    /**
     * @stability stable
     */
    get unknownExtendedKeyUsages(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set unknownExtendedKeyUsages(value: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUnknownExtendedKeyUsages(): void;
    /**
     * @stability stable
     */
    get unknownExtendedKeyUsagesInput(): cdktf.IResolvable | PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages[] | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds {
    /**
     * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#object_id_path PrivatecaCaPool#object_id_path}
     *
     * @stability stable
     */
    readonly objectIdPath: number[];
}
export declare function privatecaCaPoolIssuancePolicyBaselineValuesPolicyIdsToTerraform(struct?: PrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyBaselineValues {
    /**
     * Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the "Authority Information Access" extension in the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#aia_ocsp_servers PrivatecaCaPool#aia_ocsp_servers}
     *
     * @stability stable
     */
    readonly aiaOcspServers?: string[];
    /**
     * additional_extensions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#additional_extensions PrivatecaCaPool#additional_extensions}
     *
     * @stability stable
     */
    readonly additionalExtensions?: PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions[] | cdktf.IResolvable;
    /**
     * ca_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#ca_options PrivatecaCaPool#ca_options}
     *
     * @stability stable
     */
    readonly caOptions: PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptions;
    /**
     * key_usage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#key_usage PrivatecaCaPool#key_usage}
     *
     * @stability stable
     */
    readonly keyUsage: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsage;
    /**
     * policy_ids block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#policy_ids PrivatecaCaPool#policy_ids}
     *
     * @stability stable
     */
    readonly policyIds?: PrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds[] | cdktf.IResolvable;
}
export declare function privatecaCaPoolIssuancePolicyBaselineValuesToTerraform(struct?: PrivatecaCaPoolIssuancePolicyBaselineValuesOutputReference | PrivatecaCaPoolIssuancePolicyBaselineValues): any;
/**
 * @stability stable
 */
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCaPoolIssuancePolicyBaselineValues | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCaPoolIssuancePolicyBaselineValues | undefined);
    private _aiaOcspServers?;
    /**
     * @stability stable
     */
    get aiaOcspServers(): string[];
    /**
     * @stability stable
     */
    set aiaOcspServers(value: string[]);
    /**
     * @stability stable
     */
    resetAiaOcspServers(): void;
    /**
     * @stability stable
     */
    get aiaOcspServersInput(): string[] | undefined;
    private _additionalExtensions?;
    /**
     * @stability stable
     */
    get additionalExtensions(): PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set additionalExtensions(value: PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAdditionalExtensions(): void;
    /**
     * @stability stable
     */
    get additionalExtensionsInput(): cdktf.IResolvable | PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions[] | undefined;
    private _caOptions;
    /**
     * @stability stable
     */
    get caOptions(): PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptionsOutputReference;
    /**
     * @stability stable
     */
    putCaOptions(value: PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptions): void;
    /**
     * @stability stable
     */
    get caOptionsInput(): PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptions | undefined;
    private _keyUsage;
    /**
     * @stability stable
     */
    get keyUsage(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageOutputReference;
    /**
     * @stability stable
     */
    putKeyUsage(value: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsage): void;
    /**
     * @stability stable
     */
    get keyUsageInput(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsage | undefined;
    private _policyIds?;
    /**
     * @stability stable
     */
    get policyIds(): PrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set policyIds(value: PrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPolicyIds(): void;
    /**
     * @stability stable
     */
    get policyIdsInput(): cdktf.IResolvable | PrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds[] | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression {
    /**
     * Description of the expression.
     *
     * This is a longer text which describes the expression, e.g. when hovered over it in a UI.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#description PrivatecaCaPool#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Textual representation of an expression in Common Expression Language syntax.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#expression PrivatecaCaPool#expression}
     *
     * @stability stable
     */
    readonly expression: string;
    /**
     * String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#location PrivatecaCaPool#location}
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#title PrivatecaCaPool#title}
     *
     * @stability stable
     */
    readonly title?: string;
}
export declare function privatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionToTerraform(struct?: PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionOutputReference | PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression): any;
/**
 * @stability stable
 */
export declare class PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression | undefined);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _expression?;
    /**
     * @stability stable
     */
    get expression(): string;
    /**
     * @stability stable
     */
    set expression(value: string);
    /**
     * @stability stable
     */
    get expressionInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyIdentityConstraints {
    /**
     * If this is set, the SubjectAltNames extension may be copied from a certificate request into the signed certificate.
     *
     * Otherwise, the requested SubjectAltNames will be discarded.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#allow_subject_alt_names_passthrough PrivatecaCaPool#allow_subject_alt_names_passthrough}
     *
     * @stability stable
     */
    readonly allowSubjectAltNamesPassthrough: boolean | cdktf.IResolvable;
    /**
     * If this is set, the Subject field may be copied from a certificate request into the signed certificate.
     *
     * Otherwise, the requested Subject will be discarded.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#allow_subject_passthrough PrivatecaCaPool#allow_subject_passthrough}
     *
     * @stability stable
     */
    readonly allowSubjectPassthrough: boolean | cdktf.IResolvable;
    /**
     * cel_expression block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#cel_expression PrivatecaCaPool#cel_expression}
     *
     * @stability stable
     */
    readonly celExpression?: PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression;
}
export declare function privatecaCaPoolIssuancePolicyIdentityConstraintsToTerraform(struct?: PrivatecaCaPoolIssuancePolicyIdentityConstraintsOutputReference | PrivatecaCaPoolIssuancePolicyIdentityConstraints): any;
/**
 * @stability stable
 */
export declare class PrivatecaCaPoolIssuancePolicyIdentityConstraintsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCaPoolIssuancePolicyIdentityConstraints | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCaPoolIssuancePolicyIdentityConstraints | undefined);
    private _allowSubjectAltNamesPassthrough?;
    /**
     * @stability stable
     */
    get allowSubjectAltNamesPassthrough(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowSubjectAltNamesPassthrough(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get allowSubjectAltNamesPassthroughInput(): boolean | cdktf.IResolvable | undefined;
    private _allowSubjectPassthrough?;
    /**
     * @stability stable
     */
    get allowSubjectPassthrough(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowSubjectPassthrough(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get allowSubjectPassthroughInput(): boolean | cdktf.IResolvable | undefined;
    private _celExpression;
    /**
     * @stability stable
     */
    get celExpression(): PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionOutputReference;
    /**
     * @stability stable
     */
    putCelExpression(value: PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression): void;
    /**
     * @stability stable
     */
    resetCelExpression(): void;
    /**
     * @stability stable
     */
    get celExpressionInput(): PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicy {
    /**
     * The maximum lifetime allowed for issued Certificates.
     *
     * Note that if the issuing CertificateAuthority
     * expires before a Certificate's requested maximumLifetime, the effective lifetime will be explicitly truncated to match it.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#maximum_lifetime PrivatecaCaPool#maximum_lifetime}
     *
     * @stability stable
     */
    readonly maximumLifetime?: string;
    /**
     * allowed_issuance_modes block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#allowed_issuance_modes PrivatecaCaPool#allowed_issuance_modes}
     *
     * @stability stable
     */
    readonly allowedIssuanceModes?: PrivatecaCaPoolIssuancePolicyAllowedIssuanceModes;
    /**
     * allowed_key_types block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#allowed_key_types PrivatecaCaPool#allowed_key_types}
     *
     * @stability stable
     */
    readonly allowedKeyTypes?: PrivatecaCaPoolIssuancePolicyAllowedKeyTypes[] | cdktf.IResolvable;
    /**
     * baseline_values block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#baseline_values PrivatecaCaPool#baseline_values}
     *
     * @stability stable
     */
    readonly baselineValues?: PrivatecaCaPoolIssuancePolicyBaselineValues;
    /**
     * identity_constraints block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#identity_constraints PrivatecaCaPool#identity_constraints}
     *
     * @stability stable
     */
    readonly identityConstraints?: PrivatecaCaPoolIssuancePolicyIdentityConstraints;
}
export declare function privatecaCaPoolIssuancePolicyToTerraform(struct?: PrivatecaCaPoolIssuancePolicyOutputReference | PrivatecaCaPoolIssuancePolicy): any;
/**
 * @stability stable
 */
export declare class PrivatecaCaPoolIssuancePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCaPoolIssuancePolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCaPoolIssuancePolicy | undefined);
    private _maximumLifetime?;
    /**
     * @stability stable
     */
    get maximumLifetime(): string;
    /**
     * @stability stable
     */
    set maximumLifetime(value: string);
    /**
     * @stability stable
     */
    resetMaximumLifetime(): void;
    /**
     * @stability stable
     */
    get maximumLifetimeInput(): string | undefined;
    private _allowedIssuanceModes;
    /**
     * @stability stable
     */
    get allowedIssuanceModes(): PrivatecaCaPoolIssuancePolicyAllowedIssuanceModesOutputReference;
    /**
     * @stability stable
     */
    putAllowedIssuanceModes(value: PrivatecaCaPoolIssuancePolicyAllowedIssuanceModes): void;
    /**
     * @stability stable
     */
    resetAllowedIssuanceModes(): void;
    /**
     * @stability stable
     */
    get allowedIssuanceModesInput(): PrivatecaCaPoolIssuancePolicyAllowedIssuanceModes | undefined;
    private _allowedKeyTypes?;
    /**
     * @stability stable
     */
    get allowedKeyTypes(): PrivatecaCaPoolIssuancePolicyAllowedKeyTypes[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowedKeyTypes(value: PrivatecaCaPoolIssuancePolicyAllowedKeyTypes[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAllowedKeyTypes(): void;
    /**
     * @stability stable
     */
    get allowedKeyTypesInput(): cdktf.IResolvable | PrivatecaCaPoolIssuancePolicyAllowedKeyTypes[] | undefined;
    private _baselineValues;
    /**
     * @stability stable
     */
    get baselineValues(): PrivatecaCaPoolIssuancePolicyBaselineValuesOutputReference;
    /**
     * @stability stable
     */
    putBaselineValues(value: PrivatecaCaPoolIssuancePolicyBaselineValues): void;
    /**
     * @stability stable
     */
    resetBaselineValues(): void;
    /**
     * @stability stable
     */
    get baselineValuesInput(): PrivatecaCaPoolIssuancePolicyBaselineValues | undefined;
    private _identityConstraints;
    /**
     * @stability stable
     */
    get identityConstraints(): PrivatecaCaPoolIssuancePolicyIdentityConstraintsOutputReference;
    /**
     * @stability stable
     */
    putIdentityConstraints(value: PrivatecaCaPoolIssuancePolicyIdentityConstraints): void;
    /**
     * @stability stable
     */
    resetIdentityConstraints(): void;
    /**
     * @stability stable
     */
    get identityConstraintsInput(): PrivatecaCaPoolIssuancePolicyIdentityConstraints | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolPublishingOptions {
    /**
     * When true, publishes each CertificateAuthority's CA certificate and includes its URL in the "Authority Information Access" X.509 extension in all issued Certificates. If this is false, the CA certificate will not be published and the corresponding X.509 extension will not be written in issued certificates.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#publish_ca_cert PrivatecaCaPool#publish_ca_cert}
     *
     * @stability stable
     */
    readonly publishCaCert: boolean | cdktf.IResolvable;
    /**
     * When true, publishes each CertificateAuthority's CRL and includes its URL in the "CRL Distribution Points" X.509 extension in all issued Certificates. If this is false, CRLs will not be published and the corresponding X.509 extension will not be written in issued certificates. CRLs will expire 7 days from their creation. However, we will rebuild daily. CRLs are also rebuilt shortly after a certificate is revoked.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#publish_crl PrivatecaCaPool#publish_crl}
     *
     * @stability stable
     */
    readonly publishCrl: boolean | cdktf.IResolvable;
}
export declare function privatecaCaPoolPublishingOptionsToTerraform(struct?: PrivatecaCaPoolPublishingOptionsOutputReference | PrivatecaCaPoolPublishingOptions): any;
/**
 * @stability stable
 */
export declare class PrivatecaCaPoolPublishingOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCaPoolPublishingOptions | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCaPoolPublishingOptions | undefined);
    private _publishCaCert?;
    /**
     * @stability stable
     */
    get publishCaCert(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set publishCaCert(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get publishCaCertInput(): boolean | cdktf.IResolvable | undefined;
    private _publishCrl?;
    /**
     * @stability stable
     */
    get publishCrl(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set publishCrl(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get publishCrlInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#create PrivatecaCaPool#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#delete PrivatecaCaPool#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool#update PrivatecaCaPool#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function privatecaCaPoolTimeoutsToTerraform(struct?: PrivatecaCaPoolTimeoutsOutputReference | PrivatecaCaPoolTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class PrivatecaCaPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivatecaCaPoolTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivatecaCaPoolTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool google_privateca_ca_pool}.
 *
 * @stability stable
 */
export declare class PrivatecaCaPool extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool google_privateca_ca_pool} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PrivatecaCaPoolConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _tier?;
    /**
     * @stability stable
     */
    get tier(): string;
    /**
     * @stability stable
     */
    set tier(value: string);
    /**
     * @stability stable
     */
    get tierInput(): string | undefined;
    private _issuancePolicy;
    /**
     * @stability stable
     */
    get issuancePolicy(): PrivatecaCaPoolIssuancePolicyOutputReference;
    /**
     * @stability stable
     */
    putIssuancePolicy(value: PrivatecaCaPoolIssuancePolicy): void;
    /**
     * @stability stable
     */
    resetIssuancePolicy(): void;
    /**
     * @stability stable
     */
    get issuancePolicyInput(): PrivatecaCaPoolIssuancePolicy | undefined;
    private _publishingOptions;
    /**
     * @stability stable
     */
    get publishingOptions(): PrivatecaCaPoolPublishingOptionsOutputReference;
    /**
     * @stability stable
     */
    putPublishingOptions(value: PrivatecaCaPoolPublishingOptions): void;
    /**
     * @stability stable
     */
    resetPublishingOptions(): void;
    /**
     * @stability stable
     */
    get publishingOptionsInput(): PrivatecaCaPoolPublishingOptions | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): PrivatecaCaPoolTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: PrivatecaCaPoolTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): PrivatecaCaPoolTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
