import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ProjectOrganizationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the Constraint the Policy is configuring, for example, serviceuser.services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy#constraint ProjectOrganizationPolicy#constraint}
     *
     * @stability stable
     */
    readonly constraint: string;
    /**
     * The project ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy#project ProjectOrganizationPolicy#project}
     *
     * @stability stable
     */
    readonly project: string;
    /**
     * Version of the Policy. Default version is 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy#version ProjectOrganizationPolicy#version}
     *
     * @stability stable
     */
    readonly version?: number;
    /**
     * boolean_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy#boolean_policy ProjectOrganizationPolicy#boolean_policy}
     *
     * @stability stable
     */
    readonly booleanPolicy?: ProjectOrganizationPolicyBooleanPolicy;
    /**
     * list_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy#list_policy ProjectOrganizationPolicy#list_policy}
     *
     * @stability stable
     */
    readonly listPolicy?: ProjectOrganizationPolicyListPolicy;
    /**
     * restore_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy#restore_policy ProjectOrganizationPolicy#restore_policy}
     *
     * @stability stable
     */
    readonly restorePolicy?: ProjectOrganizationPolicyRestorePolicy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy#timeouts ProjectOrganizationPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ProjectOrganizationPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface ProjectOrganizationPolicyBooleanPolicy {
    /**
     * If true, then the Policy is enforced. If false, then any configuration is acceptable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy#enforced ProjectOrganizationPolicy#enforced}
     *
     * @stability stable
     */
    readonly enforced: boolean | cdktf.IResolvable;
}
export declare function projectOrganizationPolicyBooleanPolicyToTerraform(struct?: ProjectOrganizationPolicyBooleanPolicyOutputReference | ProjectOrganizationPolicyBooleanPolicy): any;
/**
 * @stability stable
 */
export declare class ProjectOrganizationPolicyBooleanPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ProjectOrganizationPolicyBooleanPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ProjectOrganizationPolicyBooleanPolicy | undefined);
    private _enforced?;
    /**
     * @stability stable
     */
    get enforced(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enforced(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enforcedInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ProjectOrganizationPolicyListPolicyAllow {
    /**
     * The policy allows or denies all values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy#all ProjectOrganizationPolicy#all}
     *
     * @stability stable
     */
    readonly all?: boolean | cdktf.IResolvable;
    /**
     * The policy can define specific values that are allowed or denied.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy#values ProjectOrganizationPolicy#values}
     *
     * @stability stable
     */
    readonly values?: string[];
}
export declare function projectOrganizationPolicyListPolicyAllowToTerraform(struct?: ProjectOrganizationPolicyListPolicyAllowOutputReference | ProjectOrganizationPolicyListPolicyAllow): any;
/**
 * @stability stable
 */
export declare class ProjectOrganizationPolicyListPolicyAllowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ProjectOrganizationPolicyListPolicyAllow | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ProjectOrganizationPolicyListPolicyAllow | undefined);
    private _all?;
    /**
     * @stability stable
     */
    get all(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set all(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAll(): void;
    /**
     * @stability stable
     */
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    resetValues(): void;
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ProjectOrganizationPolicyListPolicyDeny {
    /**
     * The policy allows or denies all values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy#all ProjectOrganizationPolicy#all}
     *
     * @stability stable
     */
    readonly all?: boolean | cdktf.IResolvable;
    /**
     * The policy can define specific values that are allowed or denied.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy#values ProjectOrganizationPolicy#values}
     *
     * @stability stable
     */
    readonly values?: string[];
}
export declare function projectOrganizationPolicyListPolicyDenyToTerraform(struct?: ProjectOrganizationPolicyListPolicyDenyOutputReference | ProjectOrganizationPolicyListPolicyDeny): any;
/**
 * @stability stable
 */
export declare class ProjectOrganizationPolicyListPolicyDenyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ProjectOrganizationPolicyListPolicyDeny | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ProjectOrganizationPolicyListPolicyDeny | undefined);
    private _all?;
    /**
     * @stability stable
     */
    get all(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set all(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAll(): void;
    /**
     * @stability stable
     */
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    resetValues(): void;
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ProjectOrganizationPolicyListPolicy {
    /**
     * If set to true, the values from the effective Policy of the parent resource are inherited, meaning the values set in this Policy are added to the values inherited up the hierarchy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy#inherit_from_parent ProjectOrganizationPolicy#inherit_from_parent}
     *
     * @stability stable
     */
    readonly inheritFromParent?: boolean | cdktf.IResolvable;
    /**
     * The Google Cloud Console will try to default to a configuration that matches the value specified in this field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy#suggested_value ProjectOrganizationPolicy#suggested_value}
     *
     * @stability stable
     */
    readonly suggestedValue?: string;
    /**
     * allow block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy#allow ProjectOrganizationPolicy#allow}
     *
     * @stability stable
     */
    readonly allow?: ProjectOrganizationPolicyListPolicyAllow;
    /**
     * deny block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy#deny ProjectOrganizationPolicy#deny}
     *
     * @stability stable
     */
    readonly deny?: ProjectOrganizationPolicyListPolicyDeny;
}
export declare function projectOrganizationPolicyListPolicyToTerraform(struct?: ProjectOrganizationPolicyListPolicyOutputReference | ProjectOrganizationPolicyListPolicy): any;
/**
 * @stability stable
 */
export declare class ProjectOrganizationPolicyListPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ProjectOrganizationPolicyListPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ProjectOrganizationPolicyListPolicy | undefined);
    private _inheritFromParent?;
    /**
     * @stability stable
     */
    get inheritFromParent(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set inheritFromParent(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetInheritFromParent(): void;
    /**
     * @stability stable
     */
    get inheritFromParentInput(): boolean | cdktf.IResolvable | undefined;
    private _suggestedValue?;
    /**
     * @stability stable
     */
    get suggestedValue(): string;
    /**
     * @stability stable
     */
    set suggestedValue(value: string);
    /**
     * @stability stable
     */
    resetSuggestedValue(): void;
    /**
     * @stability stable
     */
    get suggestedValueInput(): string | undefined;
    private _allow;
    /**
     * @stability stable
     */
    get allow(): ProjectOrganizationPolicyListPolicyAllowOutputReference;
    /**
     * @stability stable
     */
    putAllow(value: ProjectOrganizationPolicyListPolicyAllow): void;
    /**
     * @stability stable
     */
    resetAllow(): void;
    /**
     * @stability stable
     */
    get allowInput(): ProjectOrganizationPolicyListPolicyAllow | undefined;
    private _deny;
    /**
     * @stability stable
     */
    get deny(): ProjectOrganizationPolicyListPolicyDenyOutputReference;
    /**
     * @stability stable
     */
    putDeny(value: ProjectOrganizationPolicyListPolicyDeny): void;
    /**
     * @stability stable
     */
    resetDeny(): void;
    /**
     * @stability stable
     */
    get denyInput(): ProjectOrganizationPolicyListPolicyDeny | undefined;
}
/**
 * @stability stable
 */
export interface ProjectOrganizationPolicyRestorePolicy {
    /**
     * May only be set to true. If set, then the default Policy is restored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy#default ProjectOrganizationPolicy#default}
     *
     * @stability stable
     */
    readonly default: boolean | cdktf.IResolvable;
}
export declare function projectOrganizationPolicyRestorePolicyToTerraform(struct?: ProjectOrganizationPolicyRestorePolicyOutputReference | ProjectOrganizationPolicyRestorePolicy): any;
/**
 * @stability stable
 */
export declare class ProjectOrganizationPolicyRestorePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ProjectOrganizationPolicyRestorePolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ProjectOrganizationPolicyRestorePolicy | undefined);
    private _default?;
    /**
     * @stability stable
     */
    get default(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set default(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get defaultInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ProjectOrganizationPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy#create ProjectOrganizationPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy#delete ProjectOrganizationPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy#read ProjectOrganizationPolicy#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy#update ProjectOrganizationPolicy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function projectOrganizationPolicyTimeoutsToTerraform(struct?: ProjectOrganizationPolicyTimeoutsOutputReference | ProjectOrganizationPolicyTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ProjectOrganizationPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ProjectOrganizationPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ProjectOrganizationPolicyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy google_project_organization_policy}.
 *
 * @stability stable
 */
export declare class ProjectOrganizationPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy google_project_organization_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ProjectOrganizationPolicyConfig);
    private _constraint?;
    /**
     * @stability stable
     */
    get constraint(): string;
    /**
     * @stability stable
     */
    set constraint(value: string);
    /**
     * @stability stable
     */
    get constraintInput(): string | undefined;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get updateTime(): string;
    private _version?;
    /**
     * @stability stable
     */
    get version(): number;
    /**
     * @stability stable
     */
    set version(value: number);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): number | undefined;
    private _booleanPolicy;
    /**
     * @stability stable
     */
    get booleanPolicy(): ProjectOrganizationPolicyBooleanPolicyOutputReference;
    /**
     * @stability stable
     */
    putBooleanPolicy(value: ProjectOrganizationPolicyBooleanPolicy): void;
    /**
     * @stability stable
     */
    resetBooleanPolicy(): void;
    /**
     * @stability stable
     */
    get booleanPolicyInput(): ProjectOrganizationPolicyBooleanPolicy | undefined;
    private _listPolicy;
    /**
     * @stability stable
     */
    get listPolicy(): ProjectOrganizationPolicyListPolicyOutputReference;
    /**
     * @stability stable
     */
    putListPolicy(value: ProjectOrganizationPolicyListPolicy): void;
    /**
     * @stability stable
     */
    resetListPolicy(): void;
    /**
     * @stability stable
     */
    get listPolicyInput(): ProjectOrganizationPolicyListPolicy | undefined;
    private _restorePolicy;
    /**
     * @stability stable
     */
    get restorePolicy(): ProjectOrganizationPolicyRestorePolicyOutputReference;
    /**
     * @stability stable
     */
    putRestorePolicy(value: ProjectOrganizationPolicyRestorePolicy): void;
    /**
     * @stability stable
     */
    resetRestorePolicy(): void;
    /**
     * @stability stable
     */
    get restorePolicyInput(): ProjectOrganizationPolicyRestorePolicy | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ProjectOrganizationPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ProjectOrganizationPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ProjectOrganizationPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
