# -*- coding: utf-8 -*
""" wenxin global const """

# command id
CMD_BASE_START = 1000

CMD_DO_TRAIN = CMD_BASE_START + 1  # start a train task
CMD_DO_DEPLOY = CMD_BASE_START + 2  # start a deployment task
CMD_DO_INFERENCE = CMD_BASE_START + 3  # start an inference task

CMD_QUERY_TASK = CMD_BASE_START + 5  # get task status
CMD_STOP_TASK = CMD_BASE_START + 6  # stop a task

CMD_QUERY_MODEL = CMD_BASE_START + 9  # get model status
CMD_DELETE_MODEL = CMD_BASE_START + 11  # delete a model

CMD_UPLOAD_DATA = CMD_BASE_START + 12  # upload a dataset to bos
CMD_DELETE_DATA = CMD_BASE_START + 14  # delete a dataset
CMD_QUERY_DATA = CMD_BASE_START + 15  # get dataset status
CMD_STOP_SERVER = CMD_BASE_START + 16 # kill a deploy server

# task type
TRAIN_TASK=1
INFERENCE_TASK=2

# error code in general, from 4000 to 4999
ERR_CODE_BASE = 4000

ERR_CODE_REQUEST_LOAD = ERR_CODE_BASE + 1
ERR_MSG_REQUEST_LOAD = "request load fail, it must be json."
ERR_CODE_PARAMS_PARSER = ERR_CODE_BASE + 2
ERR_MSG_PARAMS_PARSER = "params is not needed, please check."
ERR_CODE_DATA_FORMAT = ERR_CODE_BASE + 3
ERR_MSG_DATA_FORMAT = "invalid data format, plase check."
ERR_CODE_JSON_FORMAT = ERR_CODE_BASE + 4
ERR_MSG_JSON_FORMAT = "dumps to json format string failed"
ERR_CODE_LOAD_DATA = ERR_CODE_BASE + 5
ERR_MSG_LOAD_DATA = "error in upload file, please check."
# tba

# erro code in training module, from 5000 to 5999
ERR_CODE_BASE_TRAIN = 5000

ERR_CODE_SUBMIT_PDC = ERR_CODE_BASE_TRAIN + 1
ERR_MSG_SUBMIT_PDC = "error when submitting to paddlecloud platform"
# tba


# erro code in deployment module, from 6000 to 6999
ERR_CODE_BASE_INFER = 6000

ERR_CODE_SUBMIT_XVISION = ERR_CODE_BASE_INFER + 1
ERR_MSG_SUBMIT_XVISION = "error when submitting to xvision platform"
ERR_CODE_WENXIN_INFER = ERR_CODE_BASE_INFER + 2
ERR_MSG_WENXIN_INFER = "internal error in model"
# tba


# task type
TASK_TYPE_COMMON = 0
TASK_TYPE_TRAIN = 1
TASK_TYPE_DEPLOY = 2
TASK_TYPE_INFER = 3

# base model
ERNIE_100B_MODEL = 1
ERNIE_10B_MODEL = 2
ERNIE_1P5B_MODEL = 3

# model status
MODEL_STATE_ERROR = 0
MODEL_STATE_SUCCESS = 1
MODEL_STATE_ON_SERVICE = 2

# task status
# create task, from 100 to 199
TASK_STATE_CREATE_BASE = 100
TASK_STATE_CREATE_SUCCESS = TASK_STATE_CREATE_BASE + 1
TASK_STATE_CREATE_FAILED = TASK_STATE_CREATE_BASE + 2

# training task, from 200 to 299
TASK_STATE_TRAIN_BASE = 200
TASK_STATE_TRAIN_SUBMIT = TASK_STATE_TRAIN_BASE + 1
TASK_STATE_TRAIN_IN_QUEUE = TASK_STATE_TRAIN_BASE + 2
TASK_STATE_TRAIN_RUNNING = TASK_STATE_TRAIN_BASE + 3
TASK_STATE_TRAIN_SUCCESS = TASK_STATE_TRAIN_BASE + 4
TASK_STATE_TRAIN_FAILED = TASK_STATE_TRAIN_BASE + 5
TASK_STATE_TRAIN_KILLED = TASK_STATE_TRAIN_BASE + 6


# deployment task, from 300 to 399
TASK_STATE_DEPLOY_BASE = 300
TASK_STATE_DEPLOY_SUBMIT = TASK_STATE_DEPLOY_BASE + 1
TASK_STATE_DEPLOY_IN_QUEUE = TASK_STATE_DEPLOY_BASE + 2
TASK_STATE_DEPLOY_RUNNING = TASK_STATE_DEPLOY_BASE + 3
TASK_STATE_DEPLOY_SUCCESS = TASK_STATE_DEPLOY_BASE + 4
TASK_STATE_DEPLOY_FAILED = TASK_STATE_DEPLOY_BASE + 5

# inference task, from 400 to 499
TASK_STATE_INFER_BASE = 400
TASK_STATE_INFER_IN_QUEUE = TASK_STATE_INFER_BASE + 1
TASK_STATE_INFER_RUNNING = TASK_STATE_INFER_BASE + 2
TASK_STATE_INFER_END = TASK_STATE_INFER_BASE + 3

# file
FILE_LINE_UPPER_BOUND = 1000
