# coding: utf-8

"""
    AssistedInstall

    Assisted installation  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from jgreenepack.api_client import ApiClient


class EventsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def list_events(self, cluster_id, **kwargs):  # noqa: E501
        """list_events  # noqa: E501

        Lists events for a cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_events(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to return events for. (required)
        :param str host_id: A host in the specified cluster to return events for.
        :param list[str] categories: A comma-separated list of event categories.
        :return: EventList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_events_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_events_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def list_events_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """list_events  # noqa: E501

        Lists events for a cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_events_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to return events for. (required)
        :param str host_id: A host in the specified cluster to return events for.
        :param list[str] categories: A comma-separated list of event categories.
        :return: EventList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'host_id', 'categories']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_events" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if self.api_client.client_side_validation and ('cluster_id' not in params or
                                                       params['cluster_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `cluster_id` when calling `list_events`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []
        if 'host_id' in params:
            query_params.append(('host_id', params['host_id']))  # noqa: E501
        if 'categories' in params:
            query_params.append(('categories', params['categories']))  # noqa: E501
            collection_formats['categories'] = 'csv'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['urlAuth', 'userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/events', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
