# coding: utf-8

"""
    AssistedInstall

    Assisted installation  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class ClusterNetwork(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'cluster_id': 'str',
        'cidr': 'Subnet',
        'host_prefix': 'int'
    }

    attribute_map = {
        'cluster_id': 'cluster_id',
        'cidr': 'cidr',
        'host_prefix': 'host_prefix'
    }

    def __init__(self, cluster_id=None, cidr=None, host_prefix=None, _configuration=None):  # noqa: E501
        """ClusterNetwork - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._cluster_id = None
        self._cidr = None
        self._host_prefix = None
        self.discriminator = None

        if cluster_id is not None:
            self.cluster_id = cluster_id
        if cidr is not None:
            self.cidr = cidr
        if host_prefix is not None:
            self.host_prefix = host_prefix

    @property
    def cluster_id(self):
        """Gets the cluster_id of this ClusterNetwork.  # noqa: E501

        The cluster that this network is associated with.  # noqa: E501

        :return: The cluster_id of this ClusterNetwork.  # noqa: E501
        :rtype: str
        """
        return self._cluster_id

    @cluster_id.setter
    def cluster_id(self, cluster_id):
        """Sets the cluster_id of this ClusterNetwork.

        The cluster that this network is associated with.  # noqa: E501

        :param cluster_id: The cluster_id of this ClusterNetwork.  # noqa: E501
        :type: str
        """

        self._cluster_id = cluster_id

    @property
    def cidr(self):
        """Gets the cidr of this ClusterNetwork.  # noqa: E501

        The IP block address pool.  # noqa: E501

        :return: The cidr of this ClusterNetwork.  # noqa: E501
        :rtype: Subnet
        """
        return self._cidr

    @cidr.setter
    def cidr(self, cidr):
        """Sets the cidr of this ClusterNetwork.

        The IP block address pool.  # noqa: E501

        :param cidr: The cidr of this ClusterNetwork.  # noqa: E501
        :type: Subnet
        """

        self._cidr = cidr

    @property
    def host_prefix(self):
        """Gets the host_prefix of this ClusterNetwork.  # noqa: E501

        The prefix size to allocate to each node from the CIDR. For example, 24 would allocate 2^8=256 adresses to each node.  # noqa: E501

        :return: The host_prefix of this ClusterNetwork.  # noqa: E501
        :rtype: int
        """
        return self._host_prefix

    @host_prefix.setter
    def host_prefix(self, host_prefix):
        """Sets the host_prefix of this ClusterNetwork.

        The prefix size to allocate to each node from the CIDR. For example, 24 would allocate 2^8=256 adresses to each node.  # noqa: E501

        :param host_prefix: The host_prefix of this ClusterNetwork.  # noqa: E501
        :type: int
        """
        if (self._configuration.client_side_validation and
                host_prefix is not None and host_prefix > 128):  # noqa: E501
            raise ValueError("Invalid value for `host_prefix`, must be a value less than or equal to `128`")  # noqa: E501
        if (self._configuration.client_side_validation and
                host_prefix is not None and host_prefix < 1):  # noqa: E501
            raise ValueError("Invalid value for `host_prefix`, must be a value greater than or equal to `1`")  # noqa: E501

        self._host_prefix = host_prefix

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ClusterNetwork, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ClusterNetwork):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ClusterNetwork):
            return True

        return self.to_dict() != other.to_dict()
