# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ComplianceFrameworkArgs', 'ComplianceFramework']

@pulumi.input_type
class ComplianceFrameworkArgs:
    def __init__(__self__, *,
                 color: pulumi.Input[str],
                 description: pulumi.Input[str],
                 namespace_path: pulumi.Input[str],
                 default: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pipeline_configuration_full_path: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ComplianceFramework resource.
        :param pulumi.Input[str] color: New color representation of the compliance framework in hex format. e.g. #FCA121.
        :param pulumi.Input[str] description: Description for the compliance framework.
        :param pulumi.Input[str] namespace_path: Full path of the namespace to add the compliance framework to.
        :param pulumi.Input[bool] default: Set this compliance framework as the default framework for the group. Default: `false`
        :param pulumi.Input[str] name: Name for the compliance framework.
        :param pulumi.Input[str] pipeline_configuration_full_path: Full path of the compliance pipeline configuration stored in a project repository, such as `.gitlab/.compliance-gitlab-ci.yml@compliance/hipaa`. Required format: `path/file.y[a]ml@group-name/project-name` **Note**: Ultimate license required.
        """
        pulumi.set(__self__, "color", color)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "namespace_path", namespace_path)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pipeline_configuration_full_path is not None:
            pulumi.set(__self__, "pipeline_configuration_full_path", pipeline_configuration_full_path)

    @property
    @pulumi.getter
    def color(self) -> pulumi.Input[str]:
        """
        New color representation of the compliance framework in hex format. e.g. #FCA121.
        """
        return pulumi.get(self, "color")

    @color.setter
    def color(self, value: pulumi.Input[str]):
        pulumi.set(self, "color", value)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        Description for the compliance framework.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="namespacePath")
    def namespace_path(self) -> pulumi.Input[str]:
        """
        Full path of the namespace to add the compliance framework to.
        """
        return pulumi.get(self, "namespace_path")

    @namespace_path.setter
    def namespace_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace_path", value)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[bool]]:
        """
        Set this compliance framework as the default framework for the group. Default: `false`
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for the compliance framework.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pipelineConfigurationFullPath")
    def pipeline_configuration_full_path(self) -> Optional[pulumi.Input[str]]:
        """
        Full path of the compliance pipeline configuration stored in a project repository, such as `.gitlab/.compliance-gitlab-ci.yml@compliance/hipaa`. Required format: `path/file.y[a]ml@group-name/project-name` **Note**: Ultimate license required.
        """
        return pulumi.get(self, "pipeline_configuration_full_path")

    @pipeline_configuration_full_path.setter
    def pipeline_configuration_full_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pipeline_configuration_full_path", value)


@pulumi.input_type
class _ComplianceFrameworkState:
    def __init__(__self__, *,
                 color: Optional[pulumi.Input[str]] = None,
                 default: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 framework_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace_path: Optional[pulumi.Input[str]] = None,
                 pipeline_configuration_full_path: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ComplianceFramework resources.
        :param pulumi.Input[str] color: New color representation of the compliance framework in hex format. e.g. #FCA121.
        :param pulumi.Input[bool] default: Set this compliance framework as the default framework for the group. Default: `false`
        :param pulumi.Input[str] description: Description for the compliance framework.
        :param pulumi.Input[str] framework_id: Globally unique ID of the compliance framework.
        :param pulumi.Input[str] name: Name for the compliance framework.
        :param pulumi.Input[str] namespace_path: Full path of the namespace to add the compliance framework to.
        :param pulumi.Input[str] pipeline_configuration_full_path: Full path of the compliance pipeline configuration stored in a project repository, such as `.gitlab/.compliance-gitlab-ci.yml@compliance/hipaa`. Required format: `path/file.y[a]ml@group-name/project-name` **Note**: Ultimate license required.
        """
        if color is not None:
            pulumi.set(__self__, "color", color)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if framework_id is not None:
            pulumi.set(__self__, "framework_id", framework_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace_path is not None:
            pulumi.set(__self__, "namespace_path", namespace_path)
        if pipeline_configuration_full_path is not None:
            pulumi.set(__self__, "pipeline_configuration_full_path", pipeline_configuration_full_path)

    @property
    @pulumi.getter
    def color(self) -> Optional[pulumi.Input[str]]:
        """
        New color representation of the compliance framework in hex format. e.g. #FCA121.
        """
        return pulumi.get(self, "color")

    @color.setter
    def color(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "color", value)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[bool]]:
        """
        Set this compliance framework as the default framework for the group. Default: `false`
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description for the compliance framework.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="frameworkId")
    def framework_id(self) -> Optional[pulumi.Input[str]]:
        """
        Globally unique ID of the compliance framework.
        """
        return pulumi.get(self, "framework_id")

    @framework_id.setter
    def framework_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "framework_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for the compliance framework.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namespacePath")
    def namespace_path(self) -> Optional[pulumi.Input[str]]:
        """
        Full path of the namespace to add the compliance framework to.
        """
        return pulumi.get(self, "namespace_path")

    @namespace_path.setter
    def namespace_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace_path", value)

    @property
    @pulumi.getter(name="pipelineConfigurationFullPath")
    def pipeline_configuration_full_path(self) -> Optional[pulumi.Input[str]]:
        """
        Full path of the compliance pipeline configuration stored in a project repository, such as `.gitlab/.compliance-gitlab-ci.yml@compliance/hipaa`. Required format: `path/file.y[a]ml@group-name/project-name` **Note**: Ultimate license required.
        """
        return pulumi.get(self, "pipeline_configuration_full_path")

    @pipeline_configuration_full_path.setter
    def pipeline_configuration_full_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pipeline_configuration_full_path", value)


class ComplianceFramework(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 color: Optional[pulumi.Input[str]] = None,
                 default: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace_path: Optional[pulumi.Input[str]] = None,
                 pipeline_configuration_full_path: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The `ComplianceFramework` resource allows to manage the lifecycle of a compliance framework on top-level groups.

        There can be only one `default` compliance framework. Of all the configured compliance frameworks marked as default, the last one applied will be the default compliance framework.

        > This resource requires a GitLab Enterprise instance with a Premium license to create the compliance framework.

        > This resource requires a GitLab Enterprise instance with an Ultimate license to specify a compliance pipeline configuration in the compliance framework.

        **Upstream API**: [GitLab GraphQL API docs](https://docs.gitlab.com/ee/api/graphql/reference/#mutationcreatecomplianceframework)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        sample = gitlab.ComplianceFramework("sample",
            namespace_path="top-level-group",
            name="HIPAA",
            description="A HIPAA Compliance Framework",
            color="#87BEEF",
            default=False,
            pipeline_configuration_full_path=".hipaa.yml@top-level-group/compliance-frameworks")
        ```

        ## Import

        Starting in Terraform v1.5.0 you can use an import block to import `gitlab_compliance_framework`. For example:

        terraform

        import {

          to = gitlab_compliance_framework.example

          id = "see CLI command below for ID"

        }

        Import using the CLI is supported using the following syntax:

        Gitlab compliance frameworks can be imported with a key composed of `<namespace_path>:<framework_id>`, e.g.

        ```sh
        $ pulumi import gitlab:index/complianceFramework:ComplianceFramework sample "top-level-group:gid://gitlab/ComplianceManagement::Framework/12345"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] color: New color representation of the compliance framework in hex format. e.g. #FCA121.
        :param pulumi.Input[bool] default: Set this compliance framework as the default framework for the group. Default: `false`
        :param pulumi.Input[str] description: Description for the compliance framework.
        :param pulumi.Input[str] name: Name for the compliance framework.
        :param pulumi.Input[str] namespace_path: Full path of the namespace to add the compliance framework to.
        :param pulumi.Input[str] pipeline_configuration_full_path: Full path of the compliance pipeline configuration stored in a project repository, such as `.gitlab/.compliance-gitlab-ci.yml@compliance/hipaa`. Required format: `path/file.y[a]ml@group-name/project-name` **Note**: Ultimate license required.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ComplianceFrameworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `ComplianceFramework` resource allows to manage the lifecycle of a compliance framework on top-level groups.

        There can be only one `default` compliance framework. Of all the configured compliance frameworks marked as default, the last one applied will be the default compliance framework.

        > This resource requires a GitLab Enterprise instance with a Premium license to create the compliance framework.

        > This resource requires a GitLab Enterprise instance with an Ultimate license to specify a compliance pipeline configuration in the compliance framework.

        **Upstream API**: [GitLab GraphQL API docs](https://docs.gitlab.com/ee/api/graphql/reference/#mutationcreatecomplianceframework)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        sample = gitlab.ComplianceFramework("sample",
            namespace_path="top-level-group",
            name="HIPAA",
            description="A HIPAA Compliance Framework",
            color="#87BEEF",
            default=False,
            pipeline_configuration_full_path=".hipaa.yml@top-level-group/compliance-frameworks")
        ```

        ## Import

        Starting in Terraform v1.5.0 you can use an import block to import `gitlab_compliance_framework`. For example:

        terraform

        import {

          to = gitlab_compliance_framework.example

          id = "see CLI command below for ID"

        }

        Import using the CLI is supported using the following syntax:

        Gitlab compliance frameworks can be imported with a key composed of `<namespace_path>:<framework_id>`, e.g.

        ```sh
        $ pulumi import gitlab:index/complianceFramework:ComplianceFramework sample "top-level-group:gid://gitlab/ComplianceManagement::Framework/12345"
        ```

        :param str resource_name: The name of the resource.
        :param ComplianceFrameworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComplianceFrameworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 color: Optional[pulumi.Input[str]] = None,
                 default: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace_path: Optional[pulumi.Input[str]] = None,
                 pipeline_configuration_full_path: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComplianceFrameworkArgs.__new__(ComplianceFrameworkArgs)

            if color is None and not opts.urn:
                raise TypeError("Missing required property 'color'")
            __props__.__dict__["color"] = color
            __props__.__dict__["default"] = default
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if namespace_path is None and not opts.urn:
                raise TypeError("Missing required property 'namespace_path'")
            __props__.__dict__["namespace_path"] = namespace_path
            __props__.__dict__["pipeline_configuration_full_path"] = pipeline_configuration_full_path
            __props__.__dict__["framework_id"] = None
        super(ComplianceFramework, __self__).__init__(
            'gitlab:index/complianceFramework:ComplianceFramework',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            color: Optional[pulumi.Input[str]] = None,
            default: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            framework_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            namespace_path: Optional[pulumi.Input[str]] = None,
            pipeline_configuration_full_path: Optional[pulumi.Input[str]] = None) -> 'ComplianceFramework':
        """
        Get an existing ComplianceFramework resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] color: New color representation of the compliance framework in hex format. e.g. #FCA121.
        :param pulumi.Input[bool] default: Set this compliance framework as the default framework for the group. Default: `false`
        :param pulumi.Input[str] description: Description for the compliance framework.
        :param pulumi.Input[str] framework_id: Globally unique ID of the compliance framework.
        :param pulumi.Input[str] name: Name for the compliance framework.
        :param pulumi.Input[str] namespace_path: Full path of the namespace to add the compliance framework to.
        :param pulumi.Input[str] pipeline_configuration_full_path: Full path of the compliance pipeline configuration stored in a project repository, such as `.gitlab/.compliance-gitlab-ci.yml@compliance/hipaa`. Required format: `path/file.y[a]ml@group-name/project-name` **Note**: Ultimate license required.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ComplianceFrameworkState.__new__(_ComplianceFrameworkState)

        __props__.__dict__["color"] = color
        __props__.__dict__["default"] = default
        __props__.__dict__["description"] = description
        __props__.__dict__["framework_id"] = framework_id
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace_path"] = namespace_path
        __props__.__dict__["pipeline_configuration_full_path"] = pipeline_configuration_full_path
        return ComplianceFramework(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def color(self) -> pulumi.Output[str]:
        """
        New color representation of the compliance framework in hex format. e.g. #FCA121.
        """
        return pulumi.get(self, "color")

    @property
    @pulumi.getter
    def default(self) -> pulumi.Output[bool]:
        """
        Set this compliance framework as the default framework for the group. Default: `false`
        """
        return pulumi.get(self, "default")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Description for the compliance framework.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="frameworkId")
    def framework_id(self) -> pulumi.Output[str]:
        """
        Globally unique ID of the compliance framework.
        """
        return pulumi.get(self, "framework_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name for the compliance framework.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namespacePath")
    def namespace_path(self) -> pulumi.Output[str]:
        """
        Full path of the namespace to add the compliance framework to.
        """
        return pulumi.get(self, "namespace_path")

    @property
    @pulumi.getter(name="pipelineConfigurationFullPath")
    def pipeline_configuration_full_path(self) -> pulumi.Output[Optional[str]]:
        """
        Full path of the compliance pipeline configuration stored in a project repository, such as `.gitlab/.compliance-gitlab-ci.yml@compliance/hipaa`. Required format: `path/file.y[a]ml@group-name/project-name` **Note**: Ultimate license required.
        """
        return pulumi.get(self, "pipeline_configuration_full_path")

