# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetComplianceFrameworkResult',
    'AwaitableGetComplianceFrameworkResult',
    'get_compliance_framework',
    'get_compliance_framework_output',
]

@pulumi.output_type
class GetComplianceFrameworkResult:
    """
    A collection of values returned by getComplianceFramework.
    """
    def __init__(__self__, color=None, default=None, description=None, framework_id=None, id=None, name=None, namespace_path=None, pipeline_configuration_full_path=None):
        if color and not isinstance(color, str):
            raise TypeError("Expected argument 'color' to be a str")
        pulumi.set(__self__, "color", color)
        if default and not isinstance(default, bool):
            raise TypeError("Expected argument 'default' to be a bool")
        pulumi.set(__self__, "default", default)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if framework_id and not isinstance(framework_id, str):
            raise TypeError("Expected argument 'framework_id' to be a str")
        pulumi.set(__self__, "framework_id", framework_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace_path and not isinstance(namespace_path, str):
            raise TypeError("Expected argument 'namespace_path' to be a str")
        pulumi.set(__self__, "namespace_path", namespace_path)
        if pipeline_configuration_full_path and not isinstance(pipeline_configuration_full_path, str):
            raise TypeError("Expected argument 'pipeline_configuration_full_path' to be a str")
        pulumi.set(__self__, "pipeline_configuration_full_path", pipeline_configuration_full_path)

    @property
    @pulumi.getter
    def color(self) -> str:
        """
        Color representation of the compliance framework in hex format. e.g. #FCA121.
        """
        return pulumi.get(self, "color")

    @property
    @pulumi.getter
    def default(self) -> bool:
        """
        Is the compliance framework the default framework for the group.
        """
        return pulumi.get(self, "default")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description for the compliance framework.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="frameworkId")
    def framework_id(self) -> str:
        """
        Globally unique ID of the compliance framework.
        """
        return pulumi.get(self, "framework_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name for the compliance framework.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namespacePath")
    def namespace_path(self) -> str:
        """
        Full path of the namespace to where the compliance framework is.
        """
        return pulumi.get(self, "namespace_path")

    @property
    @pulumi.getter(name="pipelineConfigurationFullPath")
    def pipeline_configuration_full_path(self) -> str:
        """
        Full path of the compliance pipeline configuration stored in a project repository, such as `.gitlab/.compliance-gitlab-ci.yml@compliance/hipaa`. Format: `path/file.y[a]ml@group-name/project-name` **Note**: Ultimate license required.
        """
        return pulumi.get(self, "pipeline_configuration_full_path")


class AwaitableGetComplianceFrameworkResult(GetComplianceFrameworkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetComplianceFrameworkResult(
            color=self.color,
            default=self.default,
            description=self.description,
            framework_id=self.framework_id,
            id=self.id,
            name=self.name,
            namespace_path=self.namespace_path,
            pipeline_configuration_full_path=self.pipeline_configuration_full_path)


def get_compliance_framework(name: Optional[str] = None,
                             namespace_path: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetComplianceFrameworkResult:
    """
    The `ComplianceFramework` data source allows details of a compliance framework to be retrieved by its name and the namespace it belongs to.

    **Upstream API**: [GitLab GraphQL API docs](https://docs.gitlab.com/ee/api/graphql/reference/#querynamespace)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    example = gitlab.get_compliance_framework(namespace_path="top-level-group",
        name="HIPAA")
    ```


    :param str name: Name for the compliance framework.
    :param str namespace_path: Full path of the namespace to where the compliance framework is.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['namespacePath'] = namespace_path
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gitlab:index/getComplianceFramework:getComplianceFramework', __args__, opts=opts, typ=GetComplianceFrameworkResult).value

    return AwaitableGetComplianceFrameworkResult(
        color=pulumi.get(__ret__, 'color'),
        default=pulumi.get(__ret__, 'default'),
        description=pulumi.get(__ret__, 'description'),
        framework_id=pulumi.get(__ret__, 'framework_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        namespace_path=pulumi.get(__ret__, 'namespace_path'),
        pipeline_configuration_full_path=pulumi.get(__ret__, 'pipeline_configuration_full_path'))
def get_compliance_framework_output(name: Optional[pulumi.Input[str]] = None,
                                    namespace_path: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetComplianceFrameworkResult]:
    """
    The `ComplianceFramework` data source allows details of a compliance framework to be retrieved by its name and the namespace it belongs to.

    **Upstream API**: [GitLab GraphQL API docs](https://docs.gitlab.com/ee/api/graphql/reference/#querynamespace)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    example = gitlab.get_compliance_framework(namespace_path="top-level-group",
        name="HIPAA")
    ```


    :param str name: Name for the compliance framework.
    :param str namespace_path: Full path of the namespace to where the compliance framework is.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['namespacePath'] = namespace_path
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gitlab:index/getComplianceFramework:getComplianceFramework', __args__, opts=opts, typ=GetComplianceFrameworkResult)
    return __ret__.apply(lambda __response__: GetComplianceFrameworkResult(
        color=pulumi.get(__response__, 'color'),
        default=pulumi.get(__response__, 'default'),
        description=pulumi.get(__response__, 'description'),
        framework_id=pulumi.get(__response__, 'framework_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        namespace_path=pulumi.get(__response__, 'namespace_path'),
        pipeline_configuration_full_path=pulumi.get(__response__, 'pipeline_configuration_full_path')))
