# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetGroupIdsResult',
    'AwaitableGetGroupIdsResult',
    'get_group_ids',
    'get_group_ids_output',
]

@pulumi.output_type
class GetGroupIdsResult:
    """
    A collection of values returned by getGroupIds.
    """
    def __init__(__self__, group=None, group_full_path=None, group_graphql_id=None, group_id=None, id=None):
        if group and not isinstance(group, str):
            raise TypeError("Expected argument 'group' to be a str")
        pulumi.set(__self__, "group", group)
        if group_full_path and not isinstance(group_full_path, str):
            raise TypeError("Expected argument 'group_full_path' to be a str")
        pulumi.set(__self__, "group_full_path", group_full_path)
        if group_graphql_id and not isinstance(group_graphql_id, str):
            raise TypeError("Expected argument 'group_graphql_id' to be a str")
        pulumi.set(__self__, "group_graphql_id", group_graphql_id)
        if group_id and not isinstance(group_id, str):
            raise TypeError("Expected argument 'group_id' to be a str")
        pulumi.set(__self__, "group_id", group_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def group(self) -> str:
        """
        The ID or URL-encoded path of the group.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter(name="groupFullPath")
    def group_full_path(self) -> str:
        """
        The full path of the group.
        """
        return pulumi.get(self, "group_full_path")

    @property
    @pulumi.getter(name="groupGraphqlId")
    def group_graphql_id(self) -> str:
        """
        The GraphQL ID of the group.
        """
        return pulumi.get(self, "group_graphql_id")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        """
        The ID of the group.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")


class AwaitableGetGroupIdsResult(GetGroupIdsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGroupIdsResult(
            group=self.group,
            group_full_path=self.group_full_path,
            group_graphql_id=self.group_graphql_id,
            group_id=self.group_id,
            id=self.id)


def get_group_ids(group: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGroupIdsResult:
    """
    The `get_group_ids` data source identification information for a given group, allowing a user to translate a full path or ID into the GraphQL ID of the group.

    **Upstream API**: [GitLab GraphQL API docs](https://docs.gitlab.com/ee/api/graphql/reference/#querygroup)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    new_group = gitlab.Group("new_group")
    # use group IDs to get additional information, such as the GraphQL ID
    # for other resources
    foo = gitlab.get_group_ids(group="gitlab_group.new_group.id")
    pulumi.export("graphQLId", foo.group_graphql_id)
    ```


    :param str group: The ID or URL-encoded path of the group.
    """
    __args__ = dict()
    __args__['group'] = group
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gitlab:index/getGroupIds:getGroupIds', __args__, opts=opts, typ=GetGroupIdsResult).value

    return AwaitableGetGroupIdsResult(
        group=pulumi.get(__ret__, 'group'),
        group_full_path=pulumi.get(__ret__, 'group_full_path'),
        group_graphql_id=pulumi.get(__ret__, 'group_graphql_id'),
        group_id=pulumi.get(__ret__, 'group_id'),
        id=pulumi.get(__ret__, 'id'))
def get_group_ids_output(group: Optional[pulumi.Input[str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGroupIdsResult]:
    """
    The `get_group_ids` data source identification information for a given group, allowing a user to translate a full path or ID into the GraphQL ID of the group.

    **Upstream API**: [GitLab GraphQL API docs](https://docs.gitlab.com/ee/api/graphql/reference/#querygroup)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    new_group = gitlab.Group("new_group")
    # use group IDs to get additional information, such as the GraphQL ID
    # for other resources
    foo = gitlab.get_group_ids(group="gitlab_group.new_group.id")
    pulumi.export("graphQLId", foo.group_graphql_id)
    ```


    :param str group: The ID or URL-encoded path of the group.
    """
    __args__ = dict()
    __args__['group'] = group
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gitlab:index/getGroupIds:getGroupIds', __args__, opts=opts, typ=GetGroupIdsResult)
    return __ret__.apply(lambda __response__: GetGroupIdsResult(
        group=pulumi.get(__response__, 'group'),
        group_full_path=pulumi.get(__response__, 'group_full_path'),
        group_graphql_id=pulumi.get(__response__, 'group_graphql_id'),
        group_id=pulumi.get(__response__, 'group_id'),
        id=pulumi.get(__response__, 'id')))
