# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetProjectProtectedTagResult',
    'AwaitableGetProjectProtectedTagResult',
    'get_project_protected_tag',
    'get_project_protected_tag_output',
]

@pulumi.output_type
class GetProjectProtectedTagResult:
    """
    A collection of values returned by getProjectProtectedTag.
    """
    def __init__(__self__, create_access_levels=None, id=None, project=None, tag=None):
        if create_access_levels and not isinstance(create_access_levels, list):
            raise TypeError("Expected argument 'create_access_levels' to be a list")
        pulumi.set(__self__, "create_access_levels", create_access_levels)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if tag and not isinstance(tag, str):
            raise TypeError("Expected argument 'tag' to be a str")
        pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="createAccessLevels")
    def create_access_levels(self) -> Sequence['outputs.GetProjectProtectedTagCreateAccessLevelResult']:
        """
        Array of access levels/user(s)/group(s) allowed to create protected tags.
        """
        return pulumi.get(self, "create_access_levels")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of this resource. In the format of `<tag>`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The integer or path with namespace that uniquely identifies the project.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def tag(self) -> str:
        """
        The name of the protected tag.
        """
        return pulumi.get(self, "tag")


class AwaitableGetProjectProtectedTagResult(GetProjectProtectedTagResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectProtectedTagResult(
            create_access_levels=self.create_access_levels,
            id=self.id,
            project=self.project,
            tag=self.tag)


def get_project_protected_tag(project: Optional[str] = None,
                              tag: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectProtectedTagResult:
    """
    The `get_project_protected_tag` data source allows details of a protected tag to be retrieved by its name and the project it belongs to.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/protected_tags.html#get-a-single-protected-tag-or-wildcard-protected-tag)


    :param str project: The integer or path with namespace that uniquely identifies the project.
    :param str tag: The name of the protected tag.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['tag'] = tag
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gitlab:index/getProjectProtectedTag:getProjectProtectedTag', __args__, opts=opts, typ=GetProjectProtectedTagResult).value

    return AwaitableGetProjectProtectedTagResult(
        create_access_levels=pulumi.get(__ret__, 'create_access_levels'),
        id=pulumi.get(__ret__, 'id'),
        project=pulumi.get(__ret__, 'project'),
        tag=pulumi.get(__ret__, 'tag'))
def get_project_protected_tag_output(project: Optional[pulumi.Input[str]] = None,
                                     tag: Optional[pulumi.Input[str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProjectProtectedTagResult]:
    """
    The `get_project_protected_tag` data source allows details of a protected tag to be retrieved by its name and the project it belongs to.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/protected_tags.html#get-a-single-protected-tag-or-wildcard-protected-tag)


    :param str project: The integer or path with namespace that uniquely identifies the project.
    :param str tag: The name of the protected tag.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['tag'] = tag
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gitlab:index/getProjectProtectedTag:getProjectProtectedTag', __args__, opts=opts, typ=GetProjectProtectedTagResult)
    return __ret__.apply(lambda __response__: GetProjectProtectedTagResult(
        create_access_levels=pulumi.get(__response__, 'create_access_levels'),
        id=pulumi.get(__response__, 'id'),
        project=pulumi.get(__response__, 'project'),
        tag=pulumi.get(__response__, 'tag')))
