# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetRunnersResult',
    'AwaitableGetRunnersResult',
    'get_runners',
    'get_runners_output',
]

@pulumi.output_type
class GetRunnersResult:
    """
    A collection of values returned by getRunners.
    """
    def __init__(__self__, id=None, paused=None, runners=None, status=None, tag_lists=None, type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if paused and not isinstance(paused, bool):
            raise TypeError("Expected argument 'paused' to be a bool")
        pulumi.set(__self__, "paused", paused)
        if runners and not isinstance(runners, list):
            raise TypeError("Expected argument 'runners' to be a list")
        pulumi.set(__self__, "runners", runners)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tag_lists and not isinstance(tag_lists, list):
            raise TypeError("Expected argument 'tag_lists' to be a list")
        pulumi.set(__self__, "tag_lists", tag_lists)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def paused(self) -> Optional[bool]:
        """
        Filters for runners with the given paused value
        """
        return pulumi.get(self, "paused")

    @property
    @pulumi.getter
    def runners(self) -> Sequence['outputs.GetRunnersRunnerResult']:
        """
        The list of runners.
        """
        return pulumi.get(self, "runners")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Filters for runners with the given status. Valid Values are `online`, `offline`, `stale`, and `never_contacted`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tagLists")
    def tag_lists(self) -> Optional[Sequence[str]]:
        """
        Filters for runners with all of the given tags
        """
        return pulumi.get(self, "tag_lists")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of runner to return. Valid values are `instance_type`, `group_type` and `project_type`
        """
        return pulumi.get(self, "type")


class AwaitableGetRunnersResult(GetRunnersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRunnersResult(
            id=self.id,
            paused=self.paused,
            runners=self.runners,
            status=self.status,
            tag_lists=self.tag_lists,
            type=self.type)


def get_runners(paused: Optional[bool] = None,
                status: Optional[str] = None,
                tag_lists: Optional[Sequence[str]] = None,
                type: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRunnersResult:
    """
    The `get_runners` data source retrieves information about all gitlab runners.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/runners.html#list-all-runners)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    this_user_runner = gitlab.UserRunner("this",
        runner_type="instance_type",
        tag_lists=[
            "tag1",
            "tag2",
        ])
    this = gitlab.get_runners(paused=False,
        status="online",
        tag_lists=[
            "tag1",
            "tag2",
        ],
        type="instance_type")
    ```


    :param bool paused: Filters for runners with the given paused value
    :param str status: Filters for runners with the given status. Valid Values are `online`, `offline`, `stale`, and `never_contacted`.
    :param Sequence[str] tag_lists: Filters for runners with all of the given tags
    :param str type: The type of runner to return. Valid values are `instance_type`, `group_type` and `project_type`
    """
    __args__ = dict()
    __args__['paused'] = paused
    __args__['status'] = status
    __args__['tagLists'] = tag_lists
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gitlab:index/getRunners:getRunners', __args__, opts=opts, typ=GetRunnersResult).value

    return AwaitableGetRunnersResult(
        id=pulumi.get(__ret__, 'id'),
        paused=pulumi.get(__ret__, 'paused'),
        runners=pulumi.get(__ret__, 'runners'),
        status=pulumi.get(__ret__, 'status'),
        tag_lists=pulumi.get(__ret__, 'tag_lists'),
        type=pulumi.get(__ret__, 'type'))
def get_runners_output(paused: Optional[pulumi.Input[Optional[bool]]] = None,
                       status: Optional[pulumi.Input[Optional[str]]] = None,
                       tag_lists: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                       type: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRunnersResult]:
    """
    The `get_runners` data source retrieves information about all gitlab runners.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/runners.html#list-all-runners)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    this_user_runner = gitlab.UserRunner("this",
        runner_type="instance_type",
        tag_lists=[
            "tag1",
            "tag2",
        ])
    this = gitlab.get_runners(paused=False,
        status="online",
        tag_lists=[
            "tag1",
            "tag2",
        ],
        type="instance_type")
    ```


    :param bool paused: Filters for runners with the given paused value
    :param str status: Filters for runners with the given status. Valid Values are `online`, `offline`, `stale`, and `never_contacted`.
    :param Sequence[str] tag_lists: Filters for runners with all of the given tags
    :param str type: The type of runner to return. Valid values are `instance_type`, `group_type` and `project_type`
    """
    __args__ = dict()
    __args__['paused'] = paused
    __args__['status'] = status
    __args__['tagLists'] = tag_lists
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gitlab:index/getRunners:getRunners', __args__, opts=opts, typ=GetRunnersResult)
    return __ret__.apply(lambda __response__: GetRunnersResult(
        id=pulumi.get(__response__, 'id'),
        paused=pulumi.get(__response__, 'paused'),
        runners=pulumi.get(__response__, 'runners'),
        status=pulumi.get(__response__, 'status'),
        tag_lists=pulumi.get(__response__, 'tag_lists'),
        type=pulumi.get(__response__, 'type')))
