# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProjectComplianceFrameworksArgs', 'ProjectComplianceFrameworks']

@pulumi.input_type
class ProjectComplianceFrameworksArgs:
    def __init__(__self__, *,
                 compliance_framework_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 project: pulumi.Input[str]):
        """
        The set of arguments for constructing a ProjectComplianceFrameworks resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] compliance_framework_ids: Globally unique IDs of the compliance frameworks to assign to the project.
        :param pulumi.Input[str] project: The ID or full path of the project to change the compliance frameworks of.
        """
        pulumi.set(__self__, "compliance_framework_ids", compliance_framework_ids)
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="complianceFrameworkIds")
    def compliance_framework_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Globally unique IDs of the compliance frameworks to assign to the project.
        """
        return pulumi.get(self, "compliance_framework_ids")

    @compliance_framework_ids.setter
    def compliance_framework_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "compliance_framework_ids", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        The ID or full path of the project to change the compliance frameworks of.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _ProjectComplianceFrameworksState:
    def __init__(__self__, *,
                 compliance_framework_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ProjectComplianceFrameworks resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] compliance_framework_ids: Globally unique IDs of the compliance frameworks to assign to the project.
        :param pulumi.Input[str] project: The ID or full path of the project to change the compliance frameworks of.
        """
        if compliance_framework_ids is not None:
            pulumi.set(__self__, "compliance_framework_ids", compliance_framework_ids)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="complianceFrameworkIds")
    def compliance_framework_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Globally unique IDs of the compliance frameworks to assign to the project.
        """
        return pulumi.get(self, "compliance_framework_ids")

    @compliance_framework_ids.setter
    def compliance_framework_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "compliance_framework_ids", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID or full path of the project to change the compliance frameworks of.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


class ProjectComplianceFrameworks(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compliance_framework_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The `ProjectComplianceFrameworks` resource allows to manage the lifecycle of compliance frameworks on a project.

        > This resource requires a GitLab Enterprise instance with a Premium license to set the compliance frameworks on a project.

        **Upstream API**: [GitLab GraphQL API docs](https://docs.gitlab.com/ee/api/graphql/reference/#mutationprojectupdatecomplianceframeworks)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        alpha = gitlab.ComplianceFramework("alpha",
            namespace_path="top-level-group",
            name="HIPAA",
            description="A HIPAA Compliance Framework",
            color="#87BEEF",
            default=False)
        beta = gitlab.ComplianceFramework("beta",
            namespace_path="top-level-group",
            name="SOC",
            description="A SOC Compliance Framework",
            color="#223344",
            default=False)
        sample = gitlab.ProjectComplianceFrameworks("sample",
            compliance_framework_ids=[
                alpha.framework_id,
                beta.framework_id,
            ],
            project="12345678")
        ```

        ## Import

        Starting in Terraform v1.5.0 you can use an import block to import `gitlab_project_compliance_frameworks`. For example:

        terraform

        import {

          to = gitlab_project_compliance_frameworks.example

          id = "see CLI command below for ID"

        }

        Import using the CLI is supported using the following syntax:

        Gitlab project compliance frameworks can be imported with a key composed of `<project_id>`, e.g.

        ```sh
        $ pulumi import gitlab:index/projectComplianceFrameworks:ProjectComplianceFrameworks sample "42"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] compliance_framework_ids: Globally unique IDs of the compliance frameworks to assign to the project.
        :param pulumi.Input[str] project: The ID or full path of the project to change the compliance frameworks of.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectComplianceFrameworksArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `ProjectComplianceFrameworks` resource allows to manage the lifecycle of compliance frameworks on a project.

        > This resource requires a GitLab Enterprise instance with a Premium license to set the compliance frameworks on a project.

        **Upstream API**: [GitLab GraphQL API docs](https://docs.gitlab.com/ee/api/graphql/reference/#mutationprojectupdatecomplianceframeworks)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        alpha = gitlab.ComplianceFramework("alpha",
            namespace_path="top-level-group",
            name="HIPAA",
            description="A HIPAA Compliance Framework",
            color="#87BEEF",
            default=False)
        beta = gitlab.ComplianceFramework("beta",
            namespace_path="top-level-group",
            name="SOC",
            description="A SOC Compliance Framework",
            color="#223344",
            default=False)
        sample = gitlab.ProjectComplianceFrameworks("sample",
            compliance_framework_ids=[
                alpha.framework_id,
                beta.framework_id,
            ],
            project="12345678")
        ```

        ## Import

        Starting in Terraform v1.5.0 you can use an import block to import `gitlab_project_compliance_frameworks`. For example:

        terraform

        import {

          to = gitlab_project_compliance_frameworks.example

          id = "see CLI command below for ID"

        }

        Import using the CLI is supported using the following syntax:

        Gitlab project compliance frameworks can be imported with a key composed of `<project_id>`, e.g.

        ```sh
        $ pulumi import gitlab:index/projectComplianceFrameworks:ProjectComplianceFrameworks sample "42"
        ```

        :param str resource_name: The name of the resource.
        :param ProjectComplianceFrameworksArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectComplianceFrameworksArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compliance_framework_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectComplianceFrameworksArgs.__new__(ProjectComplianceFrameworksArgs)

            if compliance_framework_ids is None and not opts.urn:
                raise TypeError("Missing required property 'compliance_framework_ids'")
            __props__.__dict__["compliance_framework_ids"] = compliance_framework_ids
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
        super(ProjectComplianceFrameworks, __self__).__init__(
            'gitlab:index/projectComplianceFrameworks:ProjectComplianceFrameworks',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compliance_framework_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            project: Optional[pulumi.Input[str]] = None) -> 'ProjectComplianceFrameworks':
        """
        Get an existing ProjectComplianceFrameworks resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] compliance_framework_ids: Globally unique IDs of the compliance frameworks to assign to the project.
        :param pulumi.Input[str] project: The ID or full path of the project to change the compliance frameworks of.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectComplianceFrameworksState.__new__(_ProjectComplianceFrameworksState)

        __props__.__dict__["compliance_framework_ids"] = compliance_framework_ids
        __props__.__dict__["project"] = project
        return ProjectComplianceFrameworks(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="complianceFrameworkIds")
    def compliance_framework_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        Globally unique IDs of the compliance frameworks to assign to the project.
        """
        return pulumi.get(self, "compliance_framework_ids")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID or full path of the project to change the compliance frameworks of.
        """
        return pulumi.get(self, "project")

