# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ValueStreamAnalyticsArgs', 'ValueStreamAnalytics']

@pulumi.input_type
class ValueStreamAnalyticsArgs:
    def __init__(__self__, *,
                 stages: pulumi.Input[Sequence[pulumi.Input['ValueStreamAnalyticsStageArgs']]],
                 group_full_path: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_full_path: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ValueStreamAnalytics resource.
        :param pulumi.Input[Sequence[pulumi.Input['ValueStreamAnalyticsStageArgs']]] stages: Stages of the value stream
        :param pulumi.Input[str] group_full_path: Full path of the group the value stream is created in. **One of `group_full_path` OR `project_full_path` is required.**
        :param pulumi.Input[str] name: The name of the value stream
        :param pulumi.Input[str] project_full_path: Full path of the project the value stream is created in. **One of `group_full_path` OR `project_full_path` is required.**
        """
        pulumi.set(__self__, "stages", stages)
        if group_full_path is not None:
            pulumi.set(__self__, "group_full_path", group_full_path)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_full_path is not None:
            pulumi.set(__self__, "project_full_path", project_full_path)

    @property
    @pulumi.getter
    def stages(self) -> pulumi.Input[Sequence[pulumi.Input['ValueStreamAnalyticsStageArgs']]]:
        """
        Stages of the value stream
        """
        return pulumi.get(self, "stages")

    @stages.setter
    def stages(self, value: pulumi.Input[Sequence[pulumi.Input['ValueStreamAnalyticsStageArgs']]]):
        pulumi.set(self, "stages", value)

    @property
    @pulumi.getter(name="groupFullPath")
    def group_full_path(self) -> Optional[pulumi.Input[str]]:
        """
        Full path of the group the value stream is created in. **One of `group_full_path` OR `project_full_path` is required.**
        """
        return pulumi.get(self, "group_full_path")

    @group_full_path.setter
    def group_full_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_full_path", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the value stream
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectFullPath")
    def project_full_path(self) -> Optional[pulumi.Input[str]]:
        """
        Full path of the project the value stream is created in. **One of `group_full_path` OR `project_full_path` is required.**
        """
        return pulumi.get(self, "project_full_path")

    @project_full_path.setter
    def project_full_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_full_path", value)


@pulumi.input_type
class _ValueStreamAnalyticsState:
    def __init__(__self__, *,
                 group_full_path: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_full_path: Optional[pulumi.Input[str]] = None,
                 stages: Optional[pulumi.Input[Sequence[pulumi.Input['ValueStreamAnalyticsStageArgs']]]] = None):
        """
        Input properties used for looking up and filtering ValueStreamAnalytics resources.
        :param pulumi.Input[str] group_full_path: Full path of the group the value stream is created in. **One of `group_full_path` OR `project_full_path` is required.**
        :param pulumi.Input[str] name: The name of the value stream
        :param pulumi.Input[str] project_full_path: Full path of the project the value stream is created in. **One of `group_full_path` OR `project_full_path` is required.**
        :param pulumi.Input[Sequence[pulumi.Input['ValueStreamAnalyticsStageArgs']]] stages: Stages of the value stream
        """
        if group_full_path is not None:
            pulumi.set(__self__, "group_full_path", group_full_path)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_full_path is not None:
            pulumi.set(__self__, "project_full_path", project_full_path)
        if stages is not None:
            pulumi.set(__self__, "stages", stages)

    @property
    @pulumi.getter(name="groupFullPath")
    def group_full_path(self) -> Optional[pulumi.Input[str]]:
        """
        Full path of the group the value stream is created in. **One of `group_full_path` OR `project_full_path` is required.**
        """
        return pulumi.get(self, "group_full_path")

    @group_full_path.setter
    def group_full_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_full_path", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the value stream
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectFullPath")
    def project_full_path(self) -> Optional[pulumi.Input[str]]:
        """
        Full path of the project the value stream is created in. **One of `group_full_path` OR `project_full_path` is required.**
        """
        return pulumi.get(self, "project_full_path")

    @project_full_path.setter
    def project_full_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_full_path", value)

    @property
    @pulumi.getter
    def stages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ValueStreamAnalyticsStageArgs']]]]:
        """
        Stages of the value stream
        """
        return pulumi.get(self, "stages")

    @stages.setter
    def stages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ValueStreamAnalyticsStageArgs']]]]):
        pulumi.set(self, "stages", value)


class ValueStreamAnalytics(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_full_path: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_full_path: Optional[pulumi.Input[str]] = None,
                 stages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ValueStreamAnalyticsStageArgs', 'ValueStreamAnalyticsStageArgsDict']]]]] = None,
                 __props__=None):
        """
        The `ValueStreamAnalytics` resource allows to manage the lifecycle of value stream analytics.

        > This resource requires a GitLab Enterprise instance with a Premium license to create custom value stream analytics.

        **Upstream API**: [GitLab GraphQL API docs](https://docs.gitlab.com/ee/api/graphql/reference/#mutationvaluestreamcreate)

        ## Import

        Starting in Terraform v1.5.0 you can use an import block to import `gitlab_value_stream_analytics`. For example:

        terraform

        import {

          to = gitlab_value_stream_analytics.example

          id = "see CLI command below for ID"

        }

        Import using the CLI is supported using the following syntax:

        Gitlab value stream analytics can be imported with a key composed of `<full_path_type>:<full_path>:<value_stream_id>`, e.g.

        ```sh
        $ pulumi import gitlab:index/valueStreamAnalytics:ValueStreamAnalytics group "group:people/engineers:42"
        ```

        ```sh
        $ pulumi import gitlab:index/valueStreamAnalytics:ValueStreamAnalytics project "project:projects/sample:43"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] group_full_path: Full path of the group the value stream is created in. **One of `group_full_path` OR `project_full_path` is required.**
        :param pulumi.Input[str] name: The name of the value stream
        :param pulumi.Input[str] project_full_path: Full path of the project the value stream is created in. **One of `group_full_path` OR `project_full_path` is required.**
        :param pulumi.Input[Sequence[pulumi.Input[Union['ValueStreamAnalyticsStageArgs', 'ValueStreamAnalyticsStageArgsDict']]]] stages: Stages of the value stream
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ValueStreamAnalyticsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `ValueStreamAnalytics` resource allows to manage the lifecycle of value stream analytics.

        > This resource requires a GitLab Enterprise instance with a Premium license to create custom value stream analytics.

        **Upstream API**: [GitLab GraphQL API docs](https://docs.gitlab.com/ee/api/graphql/reference/#mutationvaluestreamcreate)

        ## Import

        Starting in Terraform v1.5.0 you can use an import block to import `gitlab_value_stream_analytics`. For example:

        terraform

        import {

          to = gitlab_value_stream_analytics.example

          id = "see CLI command below for ID"

        }

        Import using the CLI is supported using the following syntax:

        Gitlab value stream analytics can be imported with a key composed of `<full_path_type>:<full_path>:<value_stream_id>`, e.g.

        ```sh
        $ pulumi import gitlab:index/valueStreamAnalytics:ValueStreamAnalytics group "group:people/engineers:42"
        ```

        ```sh
        $ pulumi import gitlab:index/valueStreamAnalytics:ValueStreamAnalytics project "project:projects/sample:43"
        ```

        :param str resource_name: The name of the resource.
        :param ValueStreamAnalyticsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ValueStreamAnalyticsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_full_path: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_full_path: Optional[pulumi.Input[str]] = None,
                 stages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ValueStreamAnalyticsStageArgs', 'ValueStreamAnalyticsStageArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ValueStreamAnalyticsArgs.__new__(ValueStreamAnalyticsArgs)

            __props__.__dict__["group_full_path"] = group_full_path
            __props__.__dict__["name"] = name
            __props__.__dict__["project_full_path"] = project_full_path
            if stages is None and not opts.urn:
                raise TypeError("Missing required property 'stages'")
            __props__.__dict__["stages"] = stages
        super(ValueStreamAnalytics, __self__).__init__(
            'gitlab:index/valueStreamAnalytics:ValueStreamAnalytics',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group_full_path: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project_full_path: Optional[pulumi.Input[str]] = None,
            stages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ValueStreamAnalyticsStageArgs', 'ValueStreamAnalyticsStageArgsDict']]]]] = None) -> 'ValueStreamAnalytics':
        """
        Get an existing ValueStreamAnalytics resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] group_full_path: Full path of the group the value stream is created in. **One of `group_full_path` OR `project_full_path` is required.**
        :param pulumi.Input[str] name: The name of the value stream
        :param pulumi.Input[str] project_full_path: Full path of the project the value stream is created in. **One of `group_full_path` OR `project_full_path` is required.**
        :param pulumi.Input[Sequence[pulumi.Input[Union['ValueStreamAnalyticsStageArgs', 'ValueStreamAnalyticsStageArgsDict']]]] stages: Stages of the value stream
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ValueStreamAnalyticsState.__new__(_ValueStreamAnalyticsState)

        __props__.__dict__["group_full_path"] = group_full_path
        __props__.__dict__["name"] = name
        __props__.__dict__["project_full_path"] = project_full_path
        __props__.__dict__["stages"] = stages
        return ValueStreamAnalytics(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="groupFullPath")
    def group_full_path(self) -> pulumi.Output[Optional[str]]:
        """
        Full path of the group the value stream is created in. **One of `group_full_path` OR `project_full_path` is required.**
        """
        return pulumi.get(self, "group_full_path")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the value stream
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectFullPath")
    def project_full_path(self) -> pulumi.Output[Optional[str]]:
        """
        Full path of the project the value stream is created in. **One of `group_full_path` OR `project_full_path` is required.**
        """
        return pulumi.get(self, "project_full_path")

    @property
    @pulumi.getter
    def stages(self) -> pulumi.Output[Sequence['outputs.ValueStreamAnalyticsStage']]:
        """
        Stages of the value stream
        """
        return pulumi.get(self, "stages")

