# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['edfi_google_classroom_extractor',
 'edfi_google_classroom_extractor.api',
 'edfi_google_classroom_extractor.helpers',
 'edfi_google_classroom_extractor.mapping']

package_data = \
{'': ['*']}

install_requires = \
['ConfigArgParse>=1.2.3,<2.0.0',
 'SQLAlchemy>=1.3.19,<2.0.0',
 'edfi-lms-extractor-lib==1.0.0a6',
 'edfi-lms-file-utils==1.0.0b16',
 'errorhandler>=2.0.1,<3.0.0',
 'google-api-python-client>=1.11.0,<2.0.0',
 'google-auth-oauthlib>=0.4.1,<0.5.0',
 'numpy==1.19.3',
 'opnieuw>=1.1.0,<2.0.0',
 'pandas>=1.1.1,<2.0.0',
 'pytest>=6.0,<7.0',
 'python-dotenv>=0.15.0,<0.16.0',
 'tail-recursive>=2.0.0,<3.0.0',
 'xxhash>=2.0.0,<3.0.0']

setup_kwargs = {
    'name': 'edfi-google-classroom-extractor',
    'version': '1.0.0b1',
    'description': 'Extract tool for retrieving student data from Google Classroom',
    'long_description': '# Google Classroom Extractor\n\nThis tool retrieves and writes out to CSV students, active sections,\nassignments, and submissions by querying the Google Classroom API. For more\ninformation on the this tool and its output files, please see the main\nrepository [readme](https://github.com/Ed-Fi-Exchange-OSS/LMS-Toolkit).\n\n## Getting Started\n\n1. Download the latest code from [the project\n   homepage](https://github.com/Ed-Fi-Exchange-OSS/LMS-Toolkit) by clicking on\n   the green "CODE" button and choosing an appropriate option. If choosing the\n   Zip option, extract the file contents using your favorite zip tool.\n1. Open a command prompt\\* and change to this file\'s directory (\\* e.g. cmd.exe,\n   PowerShell, bash).\n1. Ensure you have [Python 3.9+ and\n   Poetry](https://github.com/Ed-Fi-Exchange-OSS/LMS-Toolkit#getting-started).\n1. At a command prompt, install all required dependencies:\n\n   ```bash\n   poetry install\n   ```\n\n1. Optional: make a copy of the `.env.example` file, named simply `.env`, and\n   customize the settings as described in the Configuration section below.\n1. Place the service-account.json file described below into\n   the root directory of this project.\n1. Run the extractor one of two ways:\n   * Execute the extractor with minimum command line arguments:\n\n      ```bash\n      poetry run python edfi_google_classroom_extractor -a [admin account email] -f assignments\n      ```\n\n   * Alternately, run with environment variables or `.env` file:\n\n     ```bash\n     poetry run python edfi_google_classroom_extractor\n     ```\n\n   * For detailed help, execute `poetry run python canvas_extractor -h`.\n\n## Configuration\n\n### Module Configuration\n\nApplication configuration is provided through environment variables or command\nline interface (CLI) arguments. CLI arguments take precedence over environment\nvariables. Environment variables can be set the normal way, or by using a\ndedicated [`.env` file](https://pypi.org/project/python-dotenv/) like:\n\n```none\nCLASSROOM_ACCOUNT[<email address of the Google Classroom admin account, required]\nLOG_LEVEL=[Log level, optional]\nOUTPUT_PATH=[The output directory for the csv files, optional]\nSTART_DATE=[start date for usage data pull in yyyy-mm-dd format, optional]\nEND_DATE=[end date for usage data pull in yyyy-mm-dd format, optional]\n```\n\nSupported parameters:\n\n| Description | Required | Command Line Argument | Environment Variable |\n| ----------- | -------- | --------------------- | -------------------- |\n| The email address of the Google Classroom admin account. | yes | `-a` or `--classroom-account` | CLASSROOM_ACCOUNT |\n| The log level for the tool. ** | no (default: INFO) | `-l` or `--log-level` | LOG_LEVEL |\n| The output directory for the generated csv files. | no (default: [working directory]/data) | `-o` or `--output-directory` | OUTPUT_PATH |\n| Sync database directory | no (default: [working directory]/data) | `-d` or `--sync-database-directory` | SYNC_DATABASE_DIRECTORY |\n| Start date*, yyyy-mm-dd format | no (default: today) | `-s` or `--usage-start-date` | START_DATE |\n| End date*, yyyy-mm-dd format | no (default: today) | `-e` or `--usage-end-date` | END_DATE |\n| Number of retry attempts for failed API calls | no (default: 4) | none | REQUEST_RETRY_COUNT |\n| Timeout window for retry attempts, in seconds | no (default: 60 seconds) | none | REQUEST_RETRY_TIMEOUT_SECONDS |\n| Feature*** | no (default: core, not removable) | `-f` or `--feature` | FEATURE |\n\n\\* _Start Date_ and _End Date_ are used in pulling system activity (usage)\ndata and could span any relevant date range.\n\n\\** Valid values for the optional _log level_:\n\n* DEBUG\n* INFO(default)\n* WARNING\n* ERROR\n* CRITICAL\n\n\\*** When there\'s no specified feature, the extractor will always process Users,\nSections, and Section Associations, which are considered the core feature. Other\nfeatures (can combine two or more):\n\n* assignments (Enables the extraction of assignments and submissions)\n* activities (Enables the extraction of section activities and system\n  activities) - **EXPERIMENTAL**, subject to breaking changes\n* grades (Enables the extraction of grades) - **COMING SOON**\n\nWhen setting features via `.env` file or through environment variable, combine\nfeatures by using a bracketed comma-separate list, e.g. `FEATURE=[activities,\nattendance, assignments, grades]`. To combine features at the command line,\nsimply list them together: `--feature activities, attendance, assignments,\ngrades]`.\n\nNote: in order to make the extractor work, you still need to configure your\n`service-account.json` file. To do so, read the next section `API Permissions`\n\n### API Permissions\n\nIn order to extract data, the Google Classroom APIs must be\nenabled, and the application must be granted permission.\n\nA Google Classroom administrator will need to enable both the\nGoogle Classroom API and the Admin SDK.  This can be done\n[here](https://console.developers.google.com/apis/library).\n\nNext, the administrator will need to create a Service Account\nand API key.  This is the account the application will use for\naccess.  This can be done\n[here](https://console.cloud.google.com/iam-admin/serviceaccounts/create).\n\n1. Give the new service account a name like "Ed-Fi Extractor"\n   and click Create.\n1. Grant the service account the "Viewer" role and click `Continue` then\n   Done, skipping step 3: "Grant users access to this service account".\n1. The new service account will be displayed in a table.\n   Click on the three dots for the account and select Manage Keys.\n1. On the next page, click the `Add Key` button, then choose JSON and click\n   `Create` in the dialog box.\n1. A JSON file will be downloaded from your browser, which is the API key.\n   Rename it to `service-account.json`. Save this into the project directory.\n1. Finally, click on the service account to view details and\n   copy the Unique ID field for the next step.\n\nFinally, the administrator will need to specify the scope of\naccess for the service account.  This can be done\n[here](https://admin.google.com/ac/owl/domainwidedelegation).\n\n1. Add a new API client and provide the service account Unique\n   ID (`client_id` in the json file) in the `Client ID` field.\n1. Paste the following scopes into the OAuth scopes field and\n   click `Authorize`:\n\n`https://www.googleapis.com/auth/admin.directory.orgunit,\nhttps://www.googleapis.com/auth/admin.reports.usage.readonly,\nhttps://www.googleapis.com/auth/classroom.courses,\nhttps://www.googleapis.com/auth/classroom.coursework.students,\nhttps://www.googleapis.com/auth/classroom.profile.emails,\nhttps://www.googleapis.com/auth/classroom.rosters,\nhttps://www.googleapis.com/auth/classroom.student-submissions.students.readonly,\nhttps://www.googleapis.com/auth/admin.reports.audit.readonly`\n\n### Generate LMS UDM CSV Files\n\nTo pull data from Google Classroom and generate csv files, run\n`poetry run python edfi_google_classroom_extractor` from the root\ndirectory of this project. CSV files are output into the\n`data/ed-fi-udm-lms` directory.\n\n### TLS/SSL proxying\n\nUsers on a corporate network that intercepts TLS/SSL traffic will need to have a\ncopy of the corporate root certificate on file, and then add an environment\nvariable pointing to this file: `HTTPLIB2_CA_CERTS=[absolute path to\ncertificate]`. NOTE: this does not load properly through the `.env` file, and\nmust be set as an actual environment variable.\n\n### Logging and Exit Codes\n\nLog statements are written to the standard output. If you wish to capture log\ndetails, then be sure to redirect the output to a file. For example:\n\n```bash\npoetry run python google_classroom_extractor > 2020-12-07-15-43.log\n```\n\nIf any errors occurred during the script run, then there will be a final print\nmessage to the standard error handler as an additional mechanism for calling\nattention to the error: `"A fatal error occurred, please review the log output\nfor more information."`\n\nThe application will exit with status code `1` if there were any log messages at\nthe ERROR or CRITICAL level, otherwise it will exit with status code `0`.\n\n## Developer Operations\n\n1. Style check: `poetry run flake8`\n1. Static typing check: `poetry run mypy .`\n1. Run unit tests: `poetry run pytest`\n1. Run unit tests with code coverage: `poetry run coverage run -m pytest`\n1. View code coverage: `poetry run coverage report`\n\n_Also see\n[build.py](https://github.com/Ed-Fi-Exchange-OSS/LMS-Toolkit/blob/main/docs/build.md)_\nfor use of the build script.\n\n### Visual Studio Code (Optional)\n\nTo work in Visual Studio Code install the Python Extension.\nThen type `Ctrl-Shift-P`, then choose `Python:Select Interpreter`,\nthen choose the environment that includes `.venv` in the name.\n\n## Legal Information\n\nCopyright (c) 2021 Ed-Fi Alliance, LLC and contributors.\n\nLicensed under the [Apache License, Version\n2.0](https://github.com/Ed-Fi-Exchange-OSS/LMS-Toolkit/blob/main/LICENSE) (the\n"License").\n\nUnless required by applicable law or agreed to in writing, software distributed\nunder the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR\nCONDITIONS OF ANY KIND, either express or implied. See the License for the\nspecific language governing permissions and limitations under the License.\n\nSee\n[NOTICES](https://github.com/Ed-Fi-Exchange-OSS/LMS-Toolkit/blob/main/NOTICES.md)\nfor additional copyright and license notifications.\n',
    'author': 'Ed-Fi Alliance, LLC, and contributors',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://techdocs.ed-fi.org/display/EDFITOOLS/LMS+Toolkit',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
