import * as cloudwatch from 'aws-cdk-lib/aws-cloudwatch';
import * as iot from '@aws-cdk/aws-iot-alpha';
import { CommonActionProps } from './common-action-props';
/**
 * (experimental) Configuration properties of an action for CloudWatch alarm.
 *
 * @experimental
 */
export interface CloudWatchSetAlarmStateActionProps extends CommonActionProps {
    /**
     * (experimental) The reason for the alarm change.
     *
     * @default None
     * @experimental
     */
    readonly reason?: string;
    /**
     * (experimental) The value of the alarm state to set.
     *
     * @experimental
     */
    readonly alarmStateToSet: cloudwatch.AlarmState;
}
/**
 * (experimental) The action to change the state of an Amazon CloudWatch alarm.
 *
 * @experimental
 */
export declare class CloudWatchSetAlarmStateAction implements iot.IAction {
    private readonly alarm;
    private readonly props;
    /**
     * @experimental
     */
    constructor(alarm: cloudwatch.IAlarm, props: CloudWatchSetAlarmStateActionProps);
    /**
     * (experimental) (experimental) Returns the topic rule action specification.
     *
     * @experimental
     */
    bind(topicRule: iot.ITopicRule): iot.ActionConfig;
}
