"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudWatchSetAlarmStateAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const role_1 = require("./private/role");
/**
 * (experimental) The action to change the state of an Amazon CloudWatch alarm.
 *
 * @experimental
 */
class CloudWatchSetAlarmStateAction {
    /**
     * @experimental
     */
    constructor(alarm, props) {
        this.alarm = alarm;
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_CloudWatchSetAlarmStateActionProps(props);
    }
    /**
     * (experimental) (experimental) Returns the topic rule action specification.
     *
     * @experimental
     */
    bind(topicRule) {
        var _b, _c;
        const role = (_b = this.props.role) !== null && _b !== void 0 ? _b : role_1.singletonActionRole(topicRule);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['cloudwatch:SetAlarmState'],
            resources: [this.alarm.alarmArn],
        }));
        return {
            configuration: {
                cloudwatchAlarm: {
                    alarmName: this.alarm.alarmName,
                    roleArn: role.roleArn,
                    stateReason: (_c = this.props.reason) !== null && _c !== void 0 ? _c : `Set state of '${this.alarm.alarmName}' to '${this.props.alarmStateToSet}'`,
                    stateValue: this.props.alarmStateToSet,
                },
            },
        };
    }
}
exports.CloudWatchSetAlarmStateAction = CloudWatchSetAlarmStateAction;
_a = JSII_RTTI_SYMBOL_1;
CloudWatchSetAlarmStateAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.CloudWatchSetAlarmStateAction", version: "2.10.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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