# Generated by Django 5.1.1 on 2024-10-01 02:10

import abid_utils.models
import charidfield.fields
import django.core.validators
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("core", "0074_alter_snapshot_downloaded_at"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Crawl",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=None,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                        unique=True,
                        verbose_name="ID",
                    ),
                ),
                (
                    "abid",
                    charidfield.fields.CharIDField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="ABID-format identifier for this entity (e.g. snp_01BJQMF54D093DXEAWZ6JYRPAQ)",
                        max_length=30,
                        null=True,
                        prefix="crl_",
                        unique=True,
                    ),
                ),
                (
                    "created_at",
                    abid_utils.models.AutoDateTimeField(db_index=True, default=None),
                ),
                ("modified_at", models.DateTimeField(auto_now=True)),
                ("urls", models.TextField()),
                (
                    "depth",
                    models.PositiveSmallIntegerField(
                        default=1,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(2),
                        ],
                    ),
                ),
                (
                    "parser",
                    models.CharField(
                        choices=[
                            ("auto", "auto"),
                            ("pocket_api", "Pocket API"),
                            ("readwise_reader_api", "Readwise Reader API"),
                            ("wallabag_atom", "Wallabag Atom"),
                            ("pocket_html", "Pocket HTML"),
                            ("pinboard_rss", "Pinboard RSS"),
                            ("shaarli_rss", "Shaarli RSS"),
                            ("medium_rss", "Medium RSS"),
                            ("netscape_html", "Netscape HTML"),
                            ("rss", "Generic RSS"),
                            ("json", "Generic JSON"),
                            ("jsonl", "Generic JSONL"),
                            ("html", "Generic HTML"),
                            ("txt", "Generic TXT"),
                            ("url_list", "URL List"),
                        ],
                        default="auto",
                        max_length=32,
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        default=None,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="crawl_set",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "Crawl",
                "verbose_name_plural": "Crawls",
            },
        ),
    ]
