from collections.abc import Mapping, Sequence
from typing import Literal, TypeAlias, overload, Any

from django.http.request import HttpRequest
from django.template.exceptions import TemplateDoesNotExist as TemplateDoesNotExist
from django.utils.safestring import SafeString

from .backends.base import _EngineTemplate
DjangoTemplates: TypeAlias = Literal["public_index.html", "base.html", "add.html", "minimal_index.html", "snapshot.html", "index_row.html", "static_index.html", "snapshot_live.html", "progressbar.html", "navigation.html", "actions_as_select.html", "app_index.html", "private_index.html", "login.html", "snapshots_grid.html", "private_index_grid.html", ".DS_Store", "core/public_index.html", "core/base.html", "core/add.html", "core/minimal_index.html", "core/snapshot.html", "core/index_row.html", "core/static_index.html", "core/snapshot_live.html", "core/progressbar.html", "core/navigation.html", "admin/actions_as_select.html", "admin/base.html", "admin/app_index.html", "admin/private_index.html", "admin/login.html", "admin/snapshots_grid.html", "admin/private_index_grid.html", "static/bootstrap.min.css", "static/external.png", "static/favicon.ico", "static/archive.png", "static/add.css", "static/spinner.gif", "static/jquery.min.js", "static/sort_both.png", "static/jquery.dataTables.min.js", "static/admin.css", "static/sort_desc.png", "static/robots.txt", "static/sort_asc.png", "static/jquery.dataTables.min.css", "registration/password_reset_subject.txt", "auth/widgets/read_only_password_hash.html", "registration/password_reset_done.html", "registration/password_change_form.html", "registration/password_reset_email.html", "registration/password_reset_confirm.html", "registration/password_reset_form.html", "registration/logged_out.html", "registration/password_reset_complete.html", "registration/password_change_done.html", "admin/delete_selected_confirmation.html", "admin/change_list_object_tools.html", "admin/delete_confirmation.html", "admin/actions.html", "admin/color_theme_toggle.html", "admin/change_list_results.html", "admin/index.html", "admin/pagination.html", "admin/date_hierarchy.html", "admin/invalid_setup.html", "admin/500.html", "admin/object_history.html", "admin/404.html", "admin/change_list.html", "admin/popup_response.html", "admin/change_form_object_tools.html", "admin/app_list.html", "admin/submit_line.html", "admin/search_form.html", "admin/prepopulated_fields_js.html", "admin/change_form.html", "admin/nav_sidebar.html", "admin/base_site.html", "admin/filter.html", "admin/auth/user/change_password.html", "admin/auth/user/add_form.html", "admin/includes/object_delete_summary.html", "admin/includes/fieldset.html", "admin/edit_inline/stacked.html", "admin/edit_inline/tabular.html", "admin/widgets/many_to_many_raw_id.html", "admin/widgets/radio.html", "admin/widgets/url.html", "admin/widgets/foreign_key_raw_id.html", "admin/widgets/time.html", "admin/widgets/clearable_file_input.html", "admin/widgets/split_datetime.html", "admin/widgets/date.html", "admin/widgets/related_widget_wrapper.html", "django_jsonform/editor.html", "django_jsonform/attrs.html", "admin_data_views/dict_item.html", "admin_data_views/list_item.html", "admin_data_views/admin_data_item_page.html", "admin_data_views/admin_data_table_page.html", "admin_data_views/item.html", "django_extensions/graph_models/original/label.dot", "django_extensions/graph_models/original/relation.dot", "django_extensions/graph_models/original/digraph.dot", "django_extensions/graph_models/django2018/label.dot", "django_extensions/graph_models/django2018/relation.dot", "django_extensions/graph_models/django2018/digraph.dot", "django_extensions/widgets/foreignkey_searchinput.html"]

def get_template(template_name: DjangoTemplates, using: Literal["django"] | None = ...) -> _EngineTemplate: ...
def select_template(template_name_list: list[DjangoTemplates], using: Literal["django"] | None = ...) -> Any: ...
def render_to_string(
    template_name: DjangoTemplates,
    context: Mapping[str, Any] | None = ...,
    request: HttpRequest | None = ...,
    using: Literal["django"] | None = ...,
) -> SafeString: ...
