# do not import all endpoints into this module because that uses a lot of memory and stack frames
# if you need the ability to import all endpoints from this module, import them with
# from papermerge_restapi_client.apis.path_to_api import path_to_api

import enum


class PathValues(str, enum.Enum):
    API_AUTH_LOGIN_ = "/api/auth/login/"
    API_AUTH_LOGOUT_ = "/api/auth/logout/"
    API_AUTH_LOGOUTALL_ = "/api/auth/logoutall/"
    API_DOCUMENTVERSIONS_ID_ = "/api/document-versions/{id}/"
    API_DOCUMENTVERSIONS_ID_DOWNLOAD_ = "/api/document-versions/{id}/download/"
    API_DOCUMENTS_ = "/api/documents/"
    API_DOCUMENTS_DOCUMENT_ID_UPLOAD_FILE_NAME = "/api/documents/{document_id}/upload/{file_name}"
    API_DOCUMENTS_ID_ = "/api/documents/{id}/"
    API_DOCUMENTS_ID_OCRTEXT = "/api/documents/{id}/ocr-text"
    API_DOCUMENTS_MERGE_ = "/api/documents/merge/"
    API_FOLDERS_ = "/api/folders/"
    API_FOLDERS_ID_ = "/api/folders/{id}/"
    API_GROUPS_ = "/api/groups/"
    API_GROUPS_ID_ = "/api/groups/{id}/"
    API_NODES_ = "/api/nodes/"
    API_NODES_ID_ = "/api/nodes/{id}/"
    API_NODES_ID_TAGS_ = "/api/nodes/{id}/tags/"
    API_NODES_DOWNLOAD_ = "/api/nodes/download/"
    API_NODES_INBOXCOUNT_ = "/api/nodes/inboxcount/"
    API_NODES_MOVE_ = "/api/nodes/move/"
    API_OCR_ = "/api/ocr/"
    API_PAGES_ = "/api/pages/"
    API_PAGES_ID_ = "/api/pages/{id}/"
    API_PAGES_MOVETODOCUMENT_ = "/api/pages/move-to-document/"
    API_PAGES_MOVETOFOLDER_ = "/api/pages/move-to-folder/"
    API_PAGES_REORDER_ = "/api/pages/reorder/"
    API_PAGES_ROTATE_ = "/api/pages/rotate/"
    API_PERMISSIONS_ = "/api/permissions/"
    API_PREFERENCES_ = "/api/preferences/"
    API_PREFERENCES_ID_ = "/api/preferences/{id}/"
    API_PREFERENCES_BULK_ = "/api/preferences/bulk/"
    API_SCHEMA_ = "/api/schema/"
    API_SEARCH_ = "/api/search/"
    API_TAGS_ = "/api/tags/"
    API_TAGS_ID_ = "/api/tags/{id}/"
    API_TOKENS_ = "/api/tokens/"
    API_TOKENS_DIGEST_ = "/api/tokens/{digest}/"
    API_USERS_ = "/api/users/"
    API_USERS_ID_ = "/api/users/{id}/"
    API_USERS_ID_CHANGEPASSWORD_ = "/api/users/{id}/change-password/"
    API_USERS_ME_ = "/api/users/me/"
    API_VERSION_ = "/api/version/"
