# Copyright 2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License").
# You may not use this file except in compliance with the License.
# A copy of the License is located at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# or in the "license" file accompanying this file. This file is distributed
# on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
# express or implied. See the License for the specific language governing
# permissions and limitations under the License.


class FieldName:
    """
    A bundle of default field names to be used by clients when instantiating
    transformer instances.
    """

    ITEM_ID = "item_id"

    START = "start"
    TARGET = "target"

    FEAT_STATIC_CAT = "feat_static_cat"
    FEAT_STATIC_REAL = "feat_static_real"
    FEAT_DYNAMIC_CAT = "feat_dynamic_cat"
    FEAT_DYNAMIC_REAL = "feat_dynamic_real"
    PAST_FEAT_DYNAMIC_REAL = "past_feat_dynamic_real"
    FEAT_DYNAMIC_REAL_LEGACY = "dynamic_feat"

    FEAT_DYNAMIC = "feat_dynamic"
    PAST_FEAT_DYNAMIC = "past_feat_dynamic"

    FEAT_DYNAMIC = "feat_dynamic"

    FEAT_TIME = "time_feat"
    FEAT_CONST = "feat_dynamic_const"
    FEAT_AGE = "feat_dynamic_age"

    OBSERVED_VALUES = "observed_values"
    IS_PAD = "is_pad"
    FORECAST_START = "forecast_start"

    TARGET_DIM_INDICATOR = "target_dimension_indicator"
