'''
# AWS Elemental MediaLive Construct Library

<!--BEGIN STABILITY BANNER-->---


![cfn-resources: Stable](https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge)

> All classes with the `Cfn` prefix in this module ([CFN Resources](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib)) are always stable and safe to use.

---
<!--END STABILITY BANNER-->

This module is part of the [AWS Cloud Development Kit](https://github.com/aws/aws-cdk) project.

```python
import aws_cdk.aws_medialive as medialive
```

<!--BEGIN CFNONLY DISCLAIMER-->

There are no official hand-written ([L2](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib)) constructs for this service yet. Here are some suggestions on how to proceed:

* Search [Construct Hub for MediaLive construct libraries](https://constructs.dev/search?q=medialive)
* Use the automatically generated [L1](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_l1_using) constructs, in the same way you would use [the CloudFormation AWS::MediaLive resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/AWS_MediaLive.html) directly.

<!--BEGIN CFNONLY DISCLAIMER-->

There are no hand-written ([L2](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib)) constructs for this service yet.
However, you can still use the automatically generated [L1](https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_l1_using) constructs, and use this service exactly as you would using CloudFormation directly.

For more information on the resources and properties available for this service, see the [CloudFormation documentation for AWS::MediaLive](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/AWS_MediaLive.html).

(Read the [CDK Contributing Guide](https://github.com/aws/aws-cdk/blob/master/CONTRIBUTING.md) and submit an RFC if you are interested in contributing to this construct library.)

<!--END CFNONLY DISCLAIMER-->
'''
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from ._jsii import *

import aws_cdk.core


@jsii.implements(aws_cdk.core.IInspectable)
class CfnChannel(
    aws_cdk.core.CfnResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@aws-cdk/aws-medialive.CfnChannel",
):
    '''A CloudFormation ``AWS::MediaLive::Channel``.

    The AWS::MediaLive::Channel resource is a MediaLive resource type that creates a channel.

    A MediaLive channel ingests and transcodes (decodes and encodes) source content from the inputs that are attached to that channel, and packages the new content into outputs.

    :cloudformationResource: AWS::MediaLive::Channel
    :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
    :exampleMetadata: fixture=_generated

    Example::

        # The code below shows an example of how to instantiate this type.
        # The values are placeholders you should change.
        import aws_cdk.aws_medialive as medialive
        
        # tags: Any
        
        cfn_channel = medialive.CfnChannel(self, "MyCfnChannel",
            cdi_input_specification=medialive.CfnChannel.CdiInputSpecificationProperty(
                resolution="resolution"
            ),
            channel_class="channelClass",
            destinations=[medialive.CfnChannel.OutputDestinationProperty(
                id="id",
                media_package_settings=[medialive.CfnChannel.MediaPackageOutputDestinationSettingsProperty(
                    channel_id="channelId"
                )],
                multiplex_settings=medialive.CfnChannel.MultiplexProgramChannelDestinationSettingsProperty(
                    multiplex_id="multiplexId",
                    program_name="programName"
                ),
                settings=[medialive.CfnChannel.OutputDestinationSettingsProperty(
                    password_param="passwordParam",
                    stream_name="streamName",
                    url="url",
                    username="username"
                )]
            )],
            encoder_settings=medialive.CfnChannel.EncoderSettingsProperty(
                audio_descriptions=[medialive.CfnChannel.AudioDescriptionProperty(
                    audio_normalization_settings=medialive.CfnChannel.AudioNormalizationSettingsProperty(
                        algorithm="algorithm",
                        algorithm_control="algorithmControl",
                        target_lkfs=123
                    ),
                    audio_selector_name="audioSelectorName",
                    audio_type="audioType",
                    audio_type_control="audioTypeControl",
                    audio_watermarking_settings=medialive.CfnChannel.AudioWatermarkSettingsProperty(
                        nielsen_watermarks_settings=medialive.CfnChannel.NielsenWatermarksSettingsProperty(
                            nielsen_cbet_settings=medialive.CfnChannel.NielsenCBETProperty(
                                cbet_check_digit_string="cbetCheckDigitString",
                                cbet_stepaside="cbetStepaside",
                                csid="csid"
                            ),
                            nielsen_distribution_type="nielsenDistributionType",
                            nielsen_naes_ii_nw_settings=medialive.CfnChannel.NielsenNaesIiNwProperty(
                                check_digit_string="checkDigitString",
                                sid=123
                            )
                        )
                    ),
                    codec_settings=medialive.CfnChannel.AudioCodecSettingsProperty(
                        aac_settings=medialive.CfnChannel.AacSettingsProperty(
                            bitrate=123,
                            coding_mode="codingMode",
                            input_type="inputType",
                            profile="profile",
                            rate_control_mode="rateControlMode",
                            raw_format="rawFormat",
                            sample_rate=123,
                            spec="spec",
                            vbr_quality="vbrQuality"
                        ),
                        ac3_settings=medialive.CfnChannel.Ac3SettingsProperty(
                            bitrate=123,
                            bitstream_mode="bitstreamMode",
                            coding_mode="codingMode",
                            dialnorm=123,
                            drc_profile="drcProfile",
                            lfe_filter="lfeFilter",
                            metadata_control="metadataControl"
                        ),
                        eac3_settings=medialive.CfnChannel.Eac3SettingsProperty(
                            attenuation_control="attenuationControl",
                            bitrate=123,
                            bitstream_mode="bitstreamMode",
                            coding_mode="codingMode",
                            dc_filter="dcFilter",
                            dialnorm=123,
                            drc_line="drcLine",
                            drc_rf="drcRf",
                            lfe_control="lfeControl",
                            lfe_filter="lfeFilter",
                            lo_ro_center_mix_level=123,
                            lo_ro_surround_mix_level=123,
                            lt_rt_center_mix_level=123,
                            lt_rt_surround_mix_level=123,
                            metadata_control="metadataControl",
                            passthrough_control="passthroughControl",
                            phase_control="phaseControl",
                            stereo_downmix="stereoDownmix",
                            surround_ex_mode="surroundExMode",
                            surround_mode="surroundMode"
                        ),
                        mp2_settings=medialive.CfnChannel.Mp2SettingsProperty(
                            bitrate=123,
                            coding_mode="codingMode",
                            sample_rate=123
                        ),
                        pass_through_settings=medialive.CfnChannel.PassThroughSettingsProperty(),
                        wav_settings=medialive.CfnChannel.WavSettingsProperty(
                            bit_depth=123,
                            coding_mode="codingMode",
                            sample_rate=123
                        )
                    ),
                    language_code="languageCode",
                    language_code_control="languageCodeControl",
                    name="name",
                    remix_settings=medialive.CfnChannel.RemixSettingsProperty(
                        channel_mappings=[medialive.CfnChannel.AudioChannelMappingProperty(
                            input_channel_levels=[medialive.CfnChannel.InputChannelLevelProperty(
                                gain=123,
                                input_channel=123
                            )],
                            output_channel=123
                        )],
                        channels_in=123,
                        channels_out=123
                    ),
                    stream_name="streamName"
                )],
                avail_blanking=medialive.CfnChannel.AvailBlankingProperty(
                    avail_blanking_image=medialive.CfnChannel.InputLocationProperty(
                        password_param="passwordParam",
                        uri="uri",
                        username="username"
                    ),
                    state="state"
                ),
                avail_configuration=medialive.CfnChannel.AvailConfigurationProperty(
                    avail_settings=medialive.CfnChannel.AvailSettingsProperty(
                        scte35_splice_insert=medialive.CfnChannel.Scte35SpliceInsertProperty(
                            ad_avail_offset=123,
                            no_regional_blackout_flag="noRegionalBlackoutFlag",
                            web_delivery_allowed_flag="webDeliveryAllowedFlag"
                        ),
                        scte35_time_signal_apos=medialive.CfnChannel.Scte35TimeSignalAposProperty(
                            ad_avail_offset=123,
                            no_regional_blackout_flag="noRegionalBlackoutFlag",
                            web_delivery_allowed_flag="webDeliveryAllowedFlag"
                        )
                    )
                ),
                blackout_slate=medialive.CfnChannel.BlackoutSlateProperty(
                    blackout_slate_image=medialive.CfnChannel.InputLocationProperty(
                        password_param="passwordParam",
                        uri="uri",
                        username="username"
                    ),
                    network_end_blackout="networkEndBlackout",
                    network_end_blackout_image=medialive.CfnChannel.InputLocationProperty(
                        password_param="passwordParam",
                        uri="uri",
                        username="username"
                    ),
                    network_id="networkId",
                    state="state"
                ),
                caption_descriptions=[medialive.CfnChannel.CaptionDescriptionProperty(
                    caption_selector_name="captionSelectorName",
                    destination_settings=medialive.CfnChannel.CaptionDestinationSettingsProperty(
                        arib_destination_settings=medialive.CfnChannel.AribDestinationSettingsProperty(),
                        burn_in_destination_settings=medialive.CfnChannel.BurnInDestinationSettingsProperty(
                            alignment="alignment",
                            background_color="backgroundColor",
                            background_opacity=123,
                            font=medialive.CfnChannel.InputLocationProperty(
                                password_param="passwordParam",
                                uri="uri",
                                username="username"
                            ),
                            font_color="fontColor",
                            font_opacity=123,
                            font_resolution=123,
                            font_size="fontSize",
                            outline_color="outlineColor",
                            outline_size=123,
                            shadow_color="shadowColor",
                            shadow_opacity=123,
                            shadow_xOffset=123,
                            shadow_yOffset=123,
                            teletext_grid_control="teletextGridControl",
                            x_position=123,
                            y_position=123
                        ),
                        dvb_sub_destination_settings=medialive.CfnChannel.DvbSubDestinationSettingsProperty(
                            alignment="alignment",
                            background_color="backgroundColor",
                            background_opacity=123,
                            font=medialive.CfnChannel.InputLocationProperty(
                                password_param="passwordParam",
                                uri="uri",
                                username="username"
                            ),
                            font_color="fontColor",
                            font_opacity=123,
                            font_resolution=123,
                            font_size="fontSize",
                            outline_color="outlineColor",
                            outline_size=123,
                            shadow_color="shadowColor",
                            shadow_opacity=123,
                            shadow_xOffset=123,
                            shadow_yOffset=123,
                            teletext_grid_control="teletextGridControl",
                            x_position=123,
                            y_position=123
                        ),
                        ebu_tt_dDestination_settings=medialive.CfnChannel.EbuTtDDestinationSettingsProperty(
                            copyright_holder="copyrightHolder",
                            fill_line_gap="fillLineGap",
                            font_family="fontFamily",
                            style_control="styleControl"
                        ),
                        embedded_destination_settings=medialive.CfnChannel.EmbeddedDestinationSettingsProperty(),
                        embedded_plus_scte20_destination_settings=medialive.CfnChannel.EmbeddedPlusScte20DestinationSettingsProperty(),
                        rtmp_caption_info_destination_settings=medialive.CfnChannel.RtmpCaptionInfoDestinationSettingsProperty(),
                        scte20_plus_embedded_destination_settings=medialive.CfnChannel.Scte20PlusEmbeddedDestinationSettingsProperty(),
                        scte27_destination_settings=medialive.CfnChannel.Scte27DestinationSettingsProperty(),
                        smpte_tt_destination_settings=medialive.CfnChannel.SmpteTtDestinationSettingsProperty(),
                        teletext_destination_settings=medialive.CfnChannel.TeletextDestinationSettingsProperty(),
                        ttml_destination_settings=medialive.CfnChannel.TtmlDestinationSettingsProperty(
                            style_control="styleControl"
                        ),
                        webvtt_destination_settings=medialive.CfnChannel.WebvttDestinationSettingsProperty(
                            style_control="styleControl"
                        )
                    ),
                    language_code="languageCode",
                    language_description="languageDescription",
                    name="name"
                )],
                feature_activations=medialive.CfnChannel.FeatureActivationsProperty(
                    input_prepare_schedule_actions="inputPrepareScheduleActions"
                ),
                global_configuration=medialive.CfnChannel.GlobalConfigurationProperty(
                    initial_audio_gain=123,
                    input_end_action="inputEndAction",
                    input_loss_behavior=medialive.CfnChannel.InputLossBehaviorProperty(
                        black_frame_msec=123,
                        input_loss_image_color="inputLossImageColor",
                        input_loss_image_slate=medialive.CfnChannel.InputLocationProperty(
                            password_param="passwordParam",
                            uri="uri",
                            username="username"
                        ),
                        input_loss_image_type="inputLossImageType",
                        repeat_frame_msec=123
                    ),
                    output_locking_mode="outputLockingMode",
                    output_timing_source="outputTimingSource",
                    support_low_framerate_inputs="supportLowFramerateInputs"
                ),
                motion_graphics_configuration=medialive.CfnChannel.MotionGraphicsConfigurationProperty(
                    motion_graphics_insertion="motionGraphicsInsertion",
                    motion_graphics_settings=medialive.CfnChannel.MotionGraphicsSettingsProperty(
                        html_motion_graphics_settings=medialive.CfnChannel.HtmlMotionGraphicsSettingsProperty()
                    )
                ),
                nielsen_configuration=medialive.CfnChannel.NielsenConfigurationProperty(
                    distributor_id="distributorId",
                    nielsen_pcm_to_id3_tagging="nielsenPcmToId3Tagging"
                ),
                output_groups=[medialive.CfnChannel.OutputGroupProperty(
                    name="name",
                    output_group_settings=medialive.CfnChannel.OutputGroupSettingsProperty(
                        archive_group_settings=medialive.CfnChannel.ArchiveGroupSettingsProperty(
                            archive_cdn_settings=medialive.CfnChannel.ArchiveCdnSettingsProperty(
                                archive_s3_settings=medialive.CfnChannel.ArchiveS3SettingsProperty(
                                    canned_acl="cannedAcl"
                                )
                            ),
                            destination=medialive.CfnChannel.OutputLocationRefProperty(
                                destination_ref_id="destinationRefId"
                            ),
                            rollover_interval=123
                        ),
                        frame_capture_group_settings=medialive.CfnChannel.FrameCaptureGroupSettingsProperty(
                            destination=medialive.CfnChannel.OutputLocationRefProperty(
                                destination_ref_id="destinationRefId"
                            ),
                            frame_capture_cdn_settings=medialive.CfnChannel.FrameCaptureCdnSettingsProperty(
                                frame_capture_s3_settings=medialive.CfnChannel.FrameCaptureS3SettingsProperty(
                                    canned_acl="cannedAcl"
                                )
                            )
                        ),
                        hls_group_settings=medialive.CfnChannel.HlsGroupSettingsProperty(
                            ad_markers=["adMarkers"],
                            base_url_content="baseUrlContent",
                            base_url_content1="baseUrlContent1",
                            base_url_manifest="baseUrlManifest",
                            base_url_manifest1="baseUrlManifest1",
                            caption_language_mappings=[medialive.CfnChannel.CaptionLanguageMappingProperty(
                                caption_channel=123,
                                language_code="languageCode",
                                language_description="languageDescription"
                            )],
                            caption_language_setting="captionLanguageSetting",
                            client_cache="clientCache",
                            codec_specification="codecSpecification",
                            constant_iv="constantIv",
                            destination=medialive.CfnChannel.OutputLocationRefProperty(
                                destination_ref_id="destinationRefId"
                            ),
                            directory_structure="directoryStructure",
                            discontinuity_tags="discontinuityTags",
                            encryption_type="encryptionType",
                            hls_cdn_settings=medialive.CfnChannel.HlsCdnSettingsProperty(
                                hls_akamai_settings=medialive.CfnChannel.HlsAkamaiSettingsProperty(
                                    connection_retry_interval=123,
                                    filecache_duration=123,
                                    http_transfer_mode="httpTransferMode",
                                    num_retries=123,
                                    restart_delay=123,
                                    salt="salt",
                                    token="token"
                                ),
                                hls_basic_put_settings=medialive.CfnChannel.HlsBasicPutSettingsProperty(
                                    connection_retry_interval=123,
                                    filecache_duration=123,
                                    num_retries=123,
                                    restart_delay=123
                                ),
                                hls_media_store_settings=medialive.CfnChannel.HlsMediaStoreSettingsProperty(
                                    connection_retry_interval=123,
                                    filecache_duration=123,
                                    media_store_storage_class="mediaStoreStorageClass",
                                    num_retries=123,
                                    restart_delay=123
                                ),
                                hls_s3_settings=medialive.CfnChannel.HlsS3SettingsProperty(
                                    canned_acl="cannedAcl"
                                ),
                                hls_webdav_settings=medialive.CfnChannel.HlsWebdavSettingsProperty(
                                    connection_retry_interval=123,
                                    filecache_duration=123,
                                    http_transfer_mode="httpTransferMode",
                                    num_retries=123,
                                    restart_delay=123
                                )
                            ),
                            hls_id3_segment_tagging="hlsId3SegmentTagging",
                            i_frame_only_playlists="iFrameOnlyPlaylists",
                            incomplete_segment_behavior="incompleteSegmentBehavior",
                            index_nSegments=123,
                            input_loss_action="inputLossAction",
                            iv_in_manifest="ivInManifest",
                            iv_source="ivSource",
                            keep_segments=123,
                            key_format="keyFormat",
                            key_format_versions="keyFormatVersions",
                            key_provider_settings=medialive.CfnChannel.KeyProviderSettingsProperty(
                                static_key_settings=medialive.CfnChannel.StaticKeySettingsProperty(
                                    key_provider_server=medialive.CfnChannel.InputLocationProperty(
                                        password_param="passwordParam",
                                        uri="uri",
                                        username="username"
                                    ),
                                    static_key_value="staticKeyValue"
                                )
                            ),
                            manifest_compression="manifestCompression",
                            manifest_duration_format="manifestDurationFormat",
                            min_segment_length=123,
                            mode="mode",
                            output_selection="outputSelection",
                            program_date_time="programDateTime",
                            program_date_time_clock="programDateTimeClock",
                            program_date_time_period=123,
                            redundant_manifest="redundantManifest",
                            segmentation_mode="segmentationMode",
                            segment_length=123,
                            segments_per_subdirectory=123,
                            stream_inf_resolution="streamInfResolution",
                            timed_metadata_id3_frame="timedMetadataId3Frame",
                            timed_metadata_id3_period=123,
                            timestamp_delta_milliseconds=123,
                            ts_file_mode="tsFileMode"
                        ),
                        media_package_group_settings=medialive.CfnChannel.MediaPackageGroupSettingsProperty(
                            destination=medialive.CfnChannel.OutputLocationRefProperty(
                                destination_ref_id="destinationRefId"
                            )
                        ),
                        ms_smooth_group_settings=medialive.CfnChannel.MsSmoothGroupSettingsProperty(
                            acquisition_point_id="acquisitionPointId",
                            audio_only_timecode_control="audioOnlyTimecodeControl",
                            certificate_mode="certificateMode",
                            connection_retry_interval=123,
                            destination=medialive.CfnChannel.OutputLocationRefProperty(
                                destination_ref_id="destinationRefId"
                            ),
                            event_id="eventId",
                            event_id_mode="eventIdMode",
                            event_stop_behavior="eventStopBehavior",
                            filecache_duration=123,
                            fragment_length=123,
                            input_loss_action="inputLossAction",
                            num_retries=123,
                            restart_delay=123,
                            segmentation_mode="segmentationMode",
                            send_delay_ms=123,
                            sparse_track_type="sparseTrackType",
                            stream_manifest_behavior="streamManifestBehavior",
                            timestamp_offset="timestampOffset",
                            timestamp_offset_mode="timestampOffsetMode"
                        ),
                        multiplex_group_settings=medialive.CfnChannel.MultiplexGroupSettingsProperty(),
                        rtmp_group_settings=medialive.CfnChannel.RtmpGroupSettingsProperty(
                            ad_markers=["adMarkers"],
                            authentication_scheme="authenticationScheme",
                            cache_full_behavior="cacheFullBehavior",
                            cache_length=123,
                            caption_data="captionData",
                            input_loss_action="inputLossAction",
                            restart_delay=123
                        ),
                        udp_group_settings=medialive.CfnChannel.UdpGroupSettingsProperty(
                            input_loss_action="inputLossAction",
                            timed_metadata_id3_frame="timedMetadataId3Frame",
                            timed_metadata_id3_period=123
                        )
                    ),
                    outputs=[medialive.CfnChannel.OutputProperty(
                        audio_description_names=["audioDescriptionNames"],
                        caption_description_names=["captionDescriptionNames"],
                        output_name="outputName",
                        output_settings=medialive.CfnChannel.OutputSettingsProperty(
                            archive_output_settings=medialive.CfnChannel.ArchiveOutputSettingsProperty(
                                container_settings=medialive.CfnChannel.ArchiveContainerSettingsProperty(
                                    m2_ts_settings=medialive.CfnChannel.M2tsSettingsProperty(
                                        absent_input_audio_behavior="absentInputAudioBehavior",
                                        arib="arib",
                                        arib_captions_pid="aribCaptionsPid",
                                        arib_captions_pid_control="aribCaptionsPidControl",
                                        audio_buffer_model="audioBufferModel",
                                        audio_frames_per_pes=123,
                                        audio_pids="audioPids",
                                        audio_stream_type="audioStreamType",
                                        bitrate=123,
                                        buffer_model="bufferModel",
                                        cc_descriptor="ccDescriptor",
                                        dvb_nit_settings=medialive.CfnChannel.DvbNitSettingsProperty(
                                            network_id=123,
                                            network_name="networkName",
                                            rep_interval=123
                                        ),
                                        dvb_sdt_settings=medialive.CfnChannel.DvbSdtSettingsProperty(
                                            output_sdt="outputSdt",
                                            rep_interval=123,
                                            service_name="serviceName",
                                            service_provider_name="serviceProviderName"
                                        ),
                                        dvb_sub_pids="dvbSubPids",
                                        dvb_tdt_settings=medialive.CfnChannel.DvbTdtSettingsProperty(
                                            rep_interval=123
                                        ),
                                        dvb_teletext_pid="dvbTeletextPid",
                                        ebif="ebif",
                                        ebp_audio_interval="ebpAudioInterval",
                                        ebp_lookahead_ms=123,
                                        ebp_placement="ebpPlacement",
                                        ecm_pid="ecmPid",
                                        es_rate_in_pes="esRateInPes",
                                        etv_platform_pid="etvPlatformPid",
                                        etv_signal_pid="etvSignalPid",
                                        fragment_time=123,
                                        klv="klv",
                                        klv_data_pids="klvDataPids",
                                        nielsen_id3_behavior="nielsenId3Behavior",
                                        null_packet_bitrate=123,
                                        pat_interval=123,
                                        pcr_control="pcrControl",
                                        pcr_period=123,
                                        pcr_pid="pcrPid",
                                        pmt_interval=123,
                                        pmt_pid="pmtPid",
                                        program_num=123,
                                        rate_mode="rateMode",
                                        scte27_pids="scte27Pids",
                                        scte35_control="scte35Control",
                                        scte35_pid="scte35Pid",
                                        segmentation_markers="segmentationMarkers",
                                        segmentation_style="segmentationStyle",
                                        segmentation_time=123,
                                        timed_metadata_behavior="timedMetadataBehavior",
                                        timed_metadata_pid="timedMetadataPid",
                                        transport_stream_id=123,
                                        video_pid="videoPid"
                                    ),
                                    raw_settings=medialive.CfnChannel.RawSettingsProperty()
                                ),
                                extension="extension",
                                name_modifier="nameModifier"
                            ),
                            frame_capture_output_settings=medialive.CfnChannel.FrameCaptureOutputSettingsProperty(
                                name_modifier="nameModifier"
                            ),
                            hls_output_settings=medialive.CfnChannel.HlsOutputSettingsProperty(
                                h265_packaging_type="h265PackagingType",
                                hls_settings=medialive.CfnChannel.HlsSettingsProperty(
                                    audio_only_hls_settings=medialive.CfnChannel.AudioOnlyHlsSettingsProperty(
                                        audio_group_id="audioGroupId",
                                        audio_only_image=medialive.CfnChannel.InputLocationProperty(
                                            password_param="passwordParam",
                                            uri="uri",
                                            username="username"
                                        ),
                                        audio_track_type="audioTrackType",
                                        segment_type="segmentType"
                                    ),
                                    fmp4_hls_settings=medialive.CfnChannel.Fmp4HlsSettingsProperty(
                                        audio_rendition_sets="audioRenditionSets",
                                        nielsen_id3_behavior="nielsenId3Behavior",
                                        timed_metadata_behavior="timedMetadataBehavior"
                                    ),
                                    frame_capture_hls_settings=medialive.CfnChannel.FrameCaptureHlsSettingsProperty(),
                                    standard_hls_settings=medialive.CfnChannel.StandardHlsSettingsProperty(
                                        audio_rendition_sets="audioRenditionSets",
                                        m3_u8_settings=medialive.CfnChannel.M3u8SettingsProperty(
                                            audio_frames_per_pes=123,
                                            audio_pids="audioPids",
                                            ecm_pid="ecmPid",
                                            nielsen_id3_behavior="nielsenId3Behavior",
                                            pat_interval=123,
                                            pcr_control="pcrControl",
                                            pcr_period=123,
                                            pcr_pid="pcrPid",
                                            pmt_interval=123,
                                            pmt_pid="pmtPid",
                                            program_num=123,
                                            scte35_behavior="scte35Behavior",
                                            scte35_pid="scte35Pid",
                                            timed_metadata_behavior="timedMetadataBehavior",
                                            timed_metadata_pid="timedMetadataPid",
                                            transport_stream_id=123,
                                            video_pid="videoPid"
                                        )
                                    )
                                ),
                                name_modifier="nameModifier",
                                segment_modifier="segmentModifier"
                            ),
                            media_package_output_settings=medialive.CfnChannel.MediaPackageOutputSettingsProperty(),
                            ms_smooth_output_settings=medialive.CfnChannel.MsSmoothOutputSettingsProperty(
                                h265_packaging_type="h265PackagingType",
                                name_modifier="nameModifier"
                            ),
                            multiplex_output_settings=medialive.CfnChannel.MultiplexOutputSettingsProperty(
                                destination=medialive.CfnChannel.OutputLocationRefProperty(
                                    destination_ref_id="destinationRefId"
                                )
                            ),
                            rtmp_output_settings=medialive.CfnChannel.RtmpOutputSettingsProperty(
                                certificate_mode="certificateMode",
                                connection_retry_interval=123,
                                destination=medialive.CfnChannel.OutputLocationRefProperty(
                                    destination_ref_id="destinationRefId"
                                ),
                                num_retries=123
                            ),
                            udp_output_settings=medialive.CfnChannel.UdpOutputSettingsProperty(
                                buffer_msec=123,
                                container_settings=medialive.CfnChannel.UdpContainerSettingsProperty(
                                    m2_ts_settings=medialive.CfnChannel.M2tsSettingsProperty(
                                        absent_input_audio_behavior="absentInputAudioBehavior",
                                        arib="arib",
                                        arib_captions_pid="aribCaptionsPid",
                                        arib_captions_pid_control="aribCaptionsPidControl",
                                        audio_buffer_model="audioBufferModel",
                                        audio_frames_per_pes=123,
                                        audio_pids="audioPids",
                                        audio_stream_type="audioStreamType",
                                        bitrate=123,
                                        buffer_model="bufferModel",
                                        cc_descriptor="ccDescriptor",
                                        dvb_nit_settings=medialive.CfnChannel.DvbNitSettingsProperty(
                                            network_id=123,
                                            network_name="networkName",
                                            rep_interval=123
                                        ),
                                        dvb_sdt_settings=medialive.CfnChannel.DvbSdtSettingsProperty(
                                            output_sdt="outputSdt",
                                            rep_interval=123,
                                            service_name="serviceName",
                                            service_provider_name="serviceProviderName"
                                        ),
                                        dvb_sub_pids="dvbSubPids",
                                        dvb_tdt_settings=medialive.CfnChannel.DvbTdtSettingsProperty(
                                            rep_interval=123
                                        ),
                                        dvb_teletext_pid="dvbTeletextPid",
                                        ebif="ebif",
                                        ebp_audio_interval="ebpAudioInterval",
                                        ebp_lookahead_ms=123,
                                        ebp_placement="ebpPlacement",
                                        ecm_pid="ecmPid",
                                        es_rate_in_pes="esRateInPes",
                                        etv_platform_pid="etvPlatformPid",
                                        etv_signal_pid="etvSignalPid",
                                        fragment_time=123,
                                        klv="klv",
                                        klv_data_pids="klvDataPids",
                                        nielsen_id3_behavior="nielsenId3Behavior",
                                        null_packet_bitrate=123,
                                        pat_interval=123,
                                        pcr_control="pcrControl",
                                        pcr_period=123,
                                        pcr_pid="pcrPid",
                                        pmt_interval=123,
                                        pmt_pid="pmtPid",
                                        program_num=123,
                                        rate_mode="rateMode",
                                        scte27_pids="scte27Pids",
                                        scte35_control="scte35Control",
                                        scte35_pid="scte35Pid",
                                        segmentation_markers="segmentationMarkers",
                                        segmentation_style="segmentationStyle",
                                        segmentation_time=123,
                                        timed_metadata_behavior="timedMetadataBehavior",
                                        timed_metadata_pid="timedMetadataPid",
                                        transport_stream_id=123,
                                        video_pid="videoPid"
                                    )
                                ),
                                destination=medialive.CfnChannel.OutputLocationRefProperty(
                                    destination_ref_id="destinationRefId"
                                ),
                                fec_output_settings=medialive.CfnChannel.FecOutputSettingsProperty(
                                    column_depth=123,
                                    include_fec="includeFec",
                                    row_length=123
                                )
                            )
                        ),
                        video_description_name="videoDescriptionName"
                    )]
                )],
                timecode_config=medialive.CfnChannel.TimecodeConfigProperty(
                    source="source",
                    sync_threshold=123
                ),
                video_descriptions=[medialive.CfnChannel.VideoDescriptionProperty(
                    codec_settings=medialive.CfnChannel.VideoCodecSettingsProperty(
                        frame_capture_settings=medialive.CfnChannel.FrameCaptureSettingsProperty(
                            capture_interval=123,
                            capture_interval_units="captureIntervalUnits"
                        ),
                        h264_settings=medialive.CfnChannel.H264SettingsProperty(
                            adaptive_quantization="adaptiveQuantization",
                            afd_signaling="afdSignaling",
                            bitrate=123,
                            buf_fill_pct=123,
                            buf_size=123,
                            color_metadata="colorMetadata",
                            color_space_settings=medialive.CfnChannel.H264ColorSpaceSettingsProperty(
                                color_space_passthrough_settings=medialive.CfnChannel.ColorSpacePassthroughSettingsProperty(),
                                rec601_settings=medialive.CfnChannel.Rec601SettingsProperty(),
                                rec709_settings=medialive.CfnChannel.Rec709SettingsProperty()
                            ),
                            entropy_encoding="entropyEncoding",
                            filter_settings=medialive.CfnChannel.H264FilterSettingsProperty(
                                temporal_filter_settings=medialive.CfnChannel.TemporalFilterSettingsProperty(
                                    post_filter_sharpening="postFilterSharpening",
                                    strength="strength"
                                )
                            ),
                            fixed_afd="fixedAfd",
                            flicker_aq="flickerAq",
                            force_field_pictures="forceFieldPictures",
                            framerate_control="framerateControl",
                            framerate_denominator=123,
                            framerate_numerator=123,
                            gop_bReference="gopBReference",
                            gop_closed_cadence=123,
                            gop_num_bFrames=123,
                            gop_size=123,
                            gop_size_units="gopSizeUnits",
                            level="level",
                            look_ahead_rate_control="lookAheadRateControl",
                            max_bitrate=123,
                            min_iInterval=123,
                            num_ref_frames=123,
                            par_control="parControl",
                            par_denominator=123,
                            par_numerator=123,
                            profile="profile",
                            quality_level="qualityLevel",
                            qvbr_quality_level=123,
                            rate_control_mode="rateControlMode",
                            scan_type="scanType",
                            scene_change_detect="sceneChangeDetect",
                            slices=123,
                            softness=123,
                            spatial_aq="spatialAq",
                            subgop_length="subgopLength",
                            syntax="syntax",
                            temporal_aq="temporalAq",
                            timecode_insertion="timecodeInsertion"
                        ),
                        h265_settings=medialive.CfnChannel.H265SettingsProperty(
                            adaptive_quantization="adaptiveQuantization",
                            afd_signaling="afdSignaling",
                            alternative_transfer_function="alternativeTransferFunction",
                            bitrate=123,
                            buf_size=123,
                            color_metadata="colorMetadata",
                            color_space_settings=medialive.CfnChannel.H265ColorSpaceSettingsProperty(
                                color_space_passthrough_settings=medialive.CfnChannel.ColorSpacePassthroughSettingsProperty(),
                                hdr10_settings=medialive.CfnChannel.Hdr10SettingsProperty(
                                    max_cll=123,
                                    max_fall=123
                                ),
                                rec601_settings=medialive.CfnChannel.Rec601SettingsProperty(),
                                rec709_settings=medialive.CfnChannel.Rec709SettingsProperty()
                            ),
                            filter_settings=medialive.CfnChannel.H265FilterSettingsProperty(
                                temporal_filter_settings=medialive.CfnChannel.TemporalFilterSettingsProperty(
                                    post_filter_sharpening="postFilterSharpening",
                                    strength="strength"
                                )
                            ),
                            fixed_afd="fixedAfd",
                            flicker_aq="flickerAq",
                            framerate_denominator=123,
                            framerate_numerator=123,
                            gop_closed_cadence=123,
                            gop_size=123,
                            gop_size_units="gopSizeUnits",
                            level="level",
                            look_ahead_rate_control="lookAheadRateControl",
                            max_bitrate=123,
                            min_iInterval=123,
                            par_denominator=123,
                            par_numerator=123,
                            profile="profile",
                            qvbr_quality_level=123,
                            rate_control_mode="rateControlMode",
                            scan_type="scanType",
                            scene_change_detect="sceneChangeDetect",
                            slices=123,
                            tier="tier",
                            timecode_insertion="timecodeInsertion"
                        ),
                        mpeg2_settings=medialive.CfnChannel.Mpeg2SettingsProperty(
                            adaptive_quantization="adaptiveQuantization",
                            afd_signaling="afdSignaling",
                            color_metadata="colorMetadata",
                            color_space="colorSpace",
                            display_aspect_ratio="displayAspectRatio",
                            filter_settings=medialive.CfnChannel.Mpeg2FilterSettingsProperty(
                                temporal_filter_settings=medialive.CfnChannel.TemporalFilterSettingsProperty(
                                    post_filter_sharpening="postFilterSharpening",
                                    strength="strength"
                                )
                            ),
                            fixed_afd="fixedAfd",
                            framerate_denominator=123,
                            framerate_numerator=123,
                            gop_closed_cadence=123,
                            gop_num_bFrames=123,
                            gop_size=123,
                            gop_size_units="gopSizeUnits",
                            scan_type="scanType",
                            subgop_length="subgopLength",
                            timecode_insertion="timecodeInsertion"
                        )
                    ),
                    height=123,
                    name="name",
                    respond_to_afd="respondToAfd",
                    scaling_behavior="scalingBehavior",
                    sharpness=123,
                    width=123
                )]
            ),
            input_attachments=[medialive.CfnChannel.InputAttachmentProperty(
                automatic_input_failover_settings=medialive.CfnChannel.AutomaticInputFailoverSettingsProperty(
                    error_clear_time_msec=123,
                    failover_conditions=[medialive.CfnChannel.FailoverConditionProperty(
                        failover_condition_settings=medialive.CfnChannel.FailoverConditionSettingsProperty(
                            audio_silence_settings=medialive.CfnChannel.AudioSilenceFailoverSettingsProperty(
                                audio_selector_name="audioSelectorName",
                                audio_silence_threshold_msec=123
                            ),
                            input_loss_settings=medialive.CfnChannel.InputLossFailoverSettingsProperty(
                                input_loss_threshold_msec=123
                            ),
                            video_black_settings=medialive.CfnChannel.VideoBlackFailoverSettingsProperty(
                                black_detect_threshold=123,
                                video_black_threshold_msec=123
                            )
                        )
                    )],
                    input_preference="inputPreference",
                    secondary_input_id="secondaryInputId"
                ),
                input_attachment_name="inputAttachmentName",
                input_id="inputId",
                input_settings=medialive.CfnChannel.InputSettingsProperty(
                    audio_selectors=[medialive.CfnChannel.AudioSelectorProperty(
                        name="name",
                        selector_settings=medialive.CfnChannel.AudioSelectorSettingsProperty(
                            audio_hls_rendition_selection=medialive.CfnChannel.AudioHlsRenditionSelectionProperty(
                                group_id="groupId",
                                name="name"
                            ),
                            audio_language_selection=medialive.CfnChannel.AudioLanguageSelectionProperty(
                                language_code="languageCode",
                                language_selection_policy="languageSelectionPolicy"
                            ),
                            audio_pid_selection=medialive.CfnChannel.AudioPidSelectionProperty(
                                pid=123
                            ),
                            audio_track_selection=medialive.CfnChannel.AudioTrackSelectionProperty(
                                tracks=[medialive.CfnChannel.AudioTrackProperty(
                                    track=123
                                )]
                            )
                        )
                    )],
                    caption_selectors=[medialive.CfnChannel.CaptionSelectorProperty(
                        language_code="languageCode",
                        name="name",
                        selector_settings=medialive.CfnChannel.CaptionSelectorSettingsProperty(
                            ancillary_source_settings=medialive.CfnChannel.AncillarySourceSettingsProperty(
                                source_ancillary_channel_number=123
                            ),
                            arib_source_settings=medialive.CfnChannel.AribSourceSettingsProperty(),
                            dvb_sub_source_settings=medialive.CfnChannel.DvbSubSourceSettingsProperty(
                                ocr_language="ocrLanguage",
                                pid=123
                            ),
                            embedded_source_settings=medialive.CfnChannel.EmbeddedSourceSettingsProperty(
                                convert608_to708="convert608To708",
                                scte20_detection="scte20Detection",
                                source608_channel_number=123,
                                source608_track_number=123
                            ),
                            scte20_source_settings=medialive.CfnChannel.Scte20SourceSettingsProperty(
                                convert608_to708="convert608To708",
                                source608_channel_number=123
                            ),
                            scte27_source_settings=medialive.CfnChannel.Scte27SourceSettingsProperty(
                                ocr_language="ocrLanguage",
                                pid=123
                            ),
                            teletext_source_settings=medialive.CfnChannel.TeletextSourceSettingsProperty(
                                output_rectangle=medialive.CfnChannel.CaptionRectangleProperty(
                                    height=123,
                                    left_offset=123,
                                    top_offset=123,
                                    width=123
                                ),
                                page_number="pageNumber"
                            )
                        )
                    )],
                    deblock_filter="deblockFilter",
                    denoise_filter="denoiseFilter",
                    filter_strength=123,
                    input_filter="inputFilter",
                    network_input_settings=medialive.CfnChannel.NetworkInputSettingsProperty(
                        hls_input_settings=medialive.CfnChannel.HlsInputSettingsProperty(
                            bandwidth=123,
                            buffer_segments=123,
                            retries=123,
                            retry_interval=123,
                            scte35_source="scte35Source"
                        ),
                        server_validation="serverValidation"
                    ),
                    scte35_pid=123,
                    smpte2038_data_preference="smpte2038DataPreference",
                    source_end_behavior="sourceEndBehavior",
                    video_selector=medialive.CfnChannel.VideoSelectorProperty(
                        color_space="colorSpace",
                        color_space_settings=medialive.CfnChannel.VideoSelectorColorSpaceSettingsProperty(
                            hdr10_settings=medialive.CfnChannel.Hdr10SettingsProperty(
                                max_cll=123,
                                max_fall=123
                            )
                        ),
                        color_space_usage="colorSpaceUsage",
                        selector_settings=medialive.CfnChannel.VideoSelectorSettingsProperty(
                            video_selector_pid=medialive.CfnChannel.VideoSelectorPidProperty(
                                pid=123
                            ),
                            video_selector_program_id=medialive.CfnChannel.VideoSelectorProgramIdProperty(
                                program_id=123
                            )
                        )
                    )
                )
            )],
            input_specification=medialive.CfnChannel.InputSpecificationProperty(
                codec="codec",
                maximum_bitrate="maximumBitrate",
                resolution="resolution"
            ),
            log_level="logLevel",
            name="name",
            role_arn="roleArn",
            tags=tags,
            vpc=medialive.CfnChannel.VpcOutputSettingsProperty(
                public_address_allocation_ids=["publicAddressAllocationIds"],
                security_group_ids=["securityGroupIds"],
                subnet_ids=["subnetIds"]
            )
        )
    '''

    def __init__(
        self,
        scope: aws_cdk.core.Construct,
        id: builtins.str,
        *,
        cdi_input_specification: typing.Optional[typing.Union["CfnChannel.CdiInputSpecificationProperty", aws_cdk.core.IResolvable]] = None,
        channel_class: typing.Optional[builtins.str] = None,
        destinations: typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.Sequence[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputDestinationProperty"]]]] = None,
        encoder_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.EncoderSettingsProperty"]] = None,
        input_attachments: typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.Sequence[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputAttachmentProperty"]]]] = None,
        input_specification: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputSpecificationProperty"]] = None,
        log_level: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        role_arn: typing.Optional[builtins.str] = None,
        tags: typing.Any = None,
        vpc: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.VpcOutputSettingsProperty"]] = None,
    ) -> None:
        '''Create a new ``AWS::MediaLive::Channel``.

        :param scope: - scope in which this resource is defined.
        :param id: - scoped id of the resource.
        :param cdi_input_specification: Specification of CDI inputs for this channel.
        :param channel_class: The class for this channel. For a channel with two pipelines, the class is STANDARD. For a channel with one pipeline, the class is SINGLE_PIPELINE.
        :param destinations: The settings that identify the destination for the outputs in this MediaLive output package.
        :param encoder_settings: The encoding configuration for the output content.
        :param input_attachments: The list of input attachments for the channel.
        :param input_specification: The input specification for this channel. It specifies the key characteristics of the inputs for this channel: the maximum bitrate, the resolution, and the codec.
        :param log_level: The verbosity for logging activity for this channel. Charges for logging (which are generated through Amazon CloudWatch Logging) are higher for higher verbosities.
        :param name: A name for this audio selector. The AudioDescription (in an output) references this name in order to identify a specific input audio to include in that output.
        :param role_arn: The IAM role for MediaLive to assume when running this channel. The role is identified by its ARN.
        :param tags: A collection of tags for this channel. Each tag is a key-value pair.
        :param vpc: Settings to enable VPC mode in the channel, so that the endpoints for all outputs are in your VPC.
        '''
        props = CfnChannelProps(
            cdi_input_specification=cdi_input_specification,
            channel_class=channel_class,
            destinations=destinations,
            encoder_settings=encoder_settings,
            input_attachments=input_attachments,
            input_specification=input_specification,
            log_level=log_level,
            name=name,
            role_arn=role_arn,
            tags=tags,
            vpc=vpc,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="inspect")
    def inspect(self, inspector: aws_cdk.core.TreeInspector) -> None:
        '''Examines the CloudFormation resource and discloses attributes.

        :param inspector: - tree inspector to collect and process attributes.
        '''
        return typing.cast(None, jsii.invoke(self, "inspect", [inspector]))

    @jsii.member(jsii_name="renderProperties")
    def _render_properties(
        self,
        props: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param props: -
        '''
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "renderProperties", [props]))

    @jsii.python.classproperty # type: ignore[misc]
    @jsii.member(jsii_name="CFN_RESOURCE_TYPE_NAME")
    def CFN_RESOURCE_TYPE_NAME(cls) -> builtins.str:
        '''The CloudFormation resource type name for this resource class.'''
        return typing.cast(builtins.str, jsii.sget(cls, "CFN_RESOURCE_TYPE_NAME"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="attrArn")
    def attr_arn(self) -> builtins.str:
        '''The ARN of the MediaLive channel.

        For example: arn:aws:medialive:us-west-1:111122223333:medialive:channel:1234567

        :cloudformationAttribute: Arn
        '''
        return typing.cast(builtins.str, jsii.get(self, "attrArn"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="attrInputs")
    def attr_inputs(self) -> typing.List[builtins.str]:
        '''The inputs that are attached to this channel.

        The inputs are identified by their IDs (not by their names or their ARNs).

        :cloudformationAttribute: Inputs
        '''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "attrInputs"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="cfnProperties")
    def _cfn_properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "cfnProperties"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="tags")
    def tags(self) -> aws_cdk.core.TagManager:
        '''A collection of tags for this channel.

        Each tag is a key-value pair.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-tags
        '''
        return typing.cast(aws_cdk.core.TagManager, jsii.get(self, "tags"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="cdiInputSpecification")
    def cdi_input_specification(
        self,
    ) -> typing.Optional[typing.Union["CfnChannel.CdiInputSpecificationProperty", aws_cdk.core.IResolvable]]:
        '''Specification of CDI inputs for this channel.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-cdiinputspecification
        '''
        return typing.cast(typing.Optional[typing.Union["CfnChannel.CdiInputSpecificationProperty", aws_cdk.core.IResolvable]], jsii.get(self, "cdiInputSpecification"))

    @cdi_input_specification.setter
    def cdi_input_specification(
        self,
        value: typing.Optional[typing.Union["CfnChannel.CdiInputSpecificationProperty", aws_cdk.core.IResolvable]],
    ) -> None:
        jsii.set(self, "cdiInputSpecification", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="channelClass")
    def channel_class(self) -> typing.Optional[builtins.str]:
        '''The class for this channel.

        For a channel with two pipelines, the class is STANDARD. For a channel with one pipeline, the class is SINGLE_PIPELINE.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-channelclass
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "channelClass"))

    @channel_class.setter
    def channel_class(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "channelClass", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="destinations")
    def destinations(
        self,
    ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputDestinationProperty"]]]]:
        '''The settings that identify the destination for the outputs in this MediaLive output package.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-destinations
        '''
        return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputDestinationProperty"]]]], jsii.get(self, "destinations"))

    @destinations.setter
    def destinations(
        self,
        value: typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputDestinationProperty"]]]],
    ) -> None:
        jsii.set(self, "destinations", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="encoderSettings")
    def encoder_settings(
        self,
    ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.EncoderSettingsProperty"]]:
        '''The encoding configuration for the output content.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-encodersettings
        '''
        return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.EncoderSettingsProperty"]], jsii.get(self, "encoderSettings"))

    @encoder_settings.setter
    def encoder_settings(
        self,
        value: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.EncoderSettingsProperty"]],
    ) -> None:
        jsii.set(self, "encoderSettings", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="inputAttachments")
    def input_attachments(
        self,
    ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputAttachmentProperty"]]]]:
        '''The list of input attachments for the channel.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-inputattachments
        '''
        return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputAttachmentProperty"]]]], jsii.get(self, "inputAttachments"))

    @input_attachments.setter
    def input_attachments(
        self,
        value: typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputAttachmentProperty"]]]],
    ) -> None:
        jsii.set(self, "inputAttachments", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="inputSpecification")
    def input_specification(
        self,
    ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputSpecificationProperty"]]:
        '''The input specification for this channel.

        It specifies the key characteristics of the inputs for this channel: the maximum bitrate, the resolution, and the codec.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-inputspecification
        '''
        return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputSpecificationProperty"]], jsii.get(self, "inputSpecification"))

    @input_specification.setter
    def input_specification(
        self,
        value: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputSpecificationProperty"]],
    ) -> None:
        jsii.set(self, "inputSpecification", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="logLevel")
    def log_level(self) -> typing.Optional[builtins.str]:
        '''The verbosity for logging activity for this channel.

        Charges for logging (which are generated through Amazon CloudWatch Logging) are higher for higher verbosities.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-loglevel
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "logLevel"))

    @log_level.setter
    def log_level(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "logLevel", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="name")
    def name(self) -> typing.Optional[builtins.str]:
        '''A name for this audio selector.

        The AudioDescription (in an output) references this name in order to identify a specific input audio to include in that output.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-name
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "name"))

    @name.setter
    def name(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "name", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="roleArn")
    def role_arn(self) -> typing.Optional[builtins.str]:
        '''The IAM role for MediaLive to assume when running this channel.

        The role is identified by its ARN.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-rolearn
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "roleArn"))

    @role_arn.setter
    def role_arn(self, value: typing.Optional[builtins.str]) -> None:
        jsii.set(self, "roleArn", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="vpc")
    def vpc(
        self,
    ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.VpcOutputSettingsProperty"]]:
        '''Settings to enable VPC mode in the channel, so that the endpoints for all outputs are in your VPC.

        :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-vpc
        '''
        return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.VpcOutputSettingsProperty"]], jsii.get(self, "vpc"))

    @vpc.setter
    def vpc(
        self,
        value: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.VpcOutputSettingsProperty"]],
    ) -> None:
        jsii.set(self, "vpc", value)

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.AacSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "bitrate": "bitrate",
            "coding_mode": "codingMode",
            "input_type": "inputType",
            "profile": "profile",
            "rate_control_mode": "rateControlMode",
            "raw_format": "rawFormat",
            "sample_rate": "sampleRate",
            "spec": "spec",
            "vbr_quality": "vbrQuality",
        },
    )
    class AacSettingsProperty:
        def __init__(
            self,
            *,
            bitrate: typing.Optional[jsii.Number] = None,
            coding_mode: typing.Optional[builtins.str] = None,
            input_type: typing.Optional[builtins.str] = None,
            profile: typing.Optional[builtins.str] = None,
            rate_control_mode: typing.Optional[builtins.str] = None,
            raw_format: typing.Optional[builtins.str] = None,
            sample_rate: typing.Optional[jsii.Number] = None,
            spec: typing.Optional[builtins.str] = None,
            vbr_quality: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The settings for an AAC audio encode in the output.

            The parent of this entity is AudioCodecSettings.

            :param bitrate: The average bitrate in bits/second. Valid values depend on the rate control mode and profile.
            :param coding_mode: Mono, stereo, or 5.1 channel layout. Valid values depend on the rate control mode and profile. The adReceiverMix setting receives a stereo description plus control track, and emits a mono AAC encode of the description track, with control data emitted in the PES header as per ETSI TS 101 154 Annex E.
            :param input_type: Set to broadcasterMixedAd when the input contains pre-mixed main audio + AD (narration) as a stereo pair. The Audio Type field (audioType) will be set to 3, which signals to downstream systems that this stream contains broadcaster mixed AD. Note that the input received by the encoder must contain pre-mixed audio; MediaLive does not perform the mixing. The values in audioTypeControl and audioType (in AudioDescription) are ignored when set to broadcasterMixedAd. Leave this set to normal when the input does not contain pre-mixed audio + AD.
            :param profile: The AAC profile.
            :param rate_control_mode: The rate control mode.
            :param raw_format: Sets the LATM/LOAS AAC output for raw containers.
            :param sample_rate: The sample rate in Hz. Valid values depend on the rate control mode and profile.
            :param spec: Uses MPEG-2 AAC audio instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.
            :param vbr_quality: The VBR quality level. This is used only if rateControlMode is VBR.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                aac_settings_property = medialive.CfnChannel.AacSettingsProperty(
                    bitrate=123,
                    coding_mode="codingMode",
                    input_type="inputType",
                    profile="profile",
                    rate_control_mode="rateControlMode",
                    raw_format="rawFormat",
                    sample_rate=123,
                    spec="spec",
                    vbr_quality="vbrQuality"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if bitrate is not None:
                self._values["bitrate"] = bitrate
            if coding_mode is not None:
                self._values["coding_mode"] = coding_mode
            if input_type is not None:
                self._values["input_type"] = input_type
            if profile is not None:
                self._values["profile"] = profile
            if rate_control_mode is not None:
                self._values["rate_control_mode"] = rate_control_mode
            if raw_format is not None:
                self._values["raw_format"] = raw_format
            if sample_rate is not None:
                self._values["sample_rate"] = sample_rate
            if spec is not None:
                self._values["spec"] = spec
            if vbr_quality is not None:
                self._values["vbr_quality"] = vbr_quality

        @builtins.property
        def bitrate(self) -> typing.Optional[jsii.Number]:
            '''The average bitrate in bits/second.

            Valid values depend on the rate control mode and profile.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-bitrate
            '''
            result = self._values.get("bitrate")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def coding_mode(self) -> typing.Optional[builtins.str]:
            '''Mono, stereo, or 5.1 channel layout. Valid values depend on the rate control mode and profile. The adReceiverMix setting receives a stereo description plus control track, and emits a mono AAC encode of the description track, with control data emitted in the PES header as per ETSI TS 101 154 Annex E.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-codingmode
            '''
            result = self._values.get("coding_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def input_type(self) -> typing.Optional[builtins.str]:
            '''Set to broadcasterMixedAd when the input contains pre-mixed main audio + AD (narration) as a stereo pair.

            The Audio Type field (audioType) will be set to 3, which signals to downstream systems that this stream contains broadcaster mixed AD. Note that the input received by the encoder must contain pre-mixed audio; MediaLive does not perform the mixing. The values in audioTypeControl and audioType (in AudioDescription) are ignored when set to broadcasterMixedAd. Leave this set to normal when the input does not contain pre-mixed audio + AD.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-inputtype
            '''
            result = self._values.get("input_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def profile(self) -> typing.Optional[builtins.str]:
            '''The AAC profile.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-profile
            '''
            result = self._values.get("profile")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def rate_control_mode(self) -> typing.Optional[builtins.str]:
            '''The rate control mode.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-ratecontrolmode
            '''
            result = self._values.get("rate_control_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def raw_format(self) -> typing.Optional[builtins.str]:
            '''Sets the LATM/LOAS AAC output for raw containers.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-rawformat
            '''
            result = self._values.get("raw_format")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def sample_rate(self) -> typing.Optional[jsii.Number]:
            '''The sample rate in Hz.

            Valid values depend on the rate control mode and profile.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-samplerate
            '''
            result = self._values.get("sample_rate")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def spec(self) -> typing.Optional[builtins.str]:
            '''Uses MPEG-2 AAC audio instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-spec
            '''
            result = self._values.get("spec")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def vbr_quality(self) -> typing.Optional[builtins.str]:
            '''The VBR quality level.

            This is used only if rateControlMode is VBR.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-vbrquality
            '''
            result = self._values.get("vbr_quality")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AacSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.Ac3SettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "bitrate": "bitrate",
            "bitstream_mode": "bitstreamMode",
            "coding_mode": "codingMode",
            "dialnorm": "dialnorm",
            "drc_profile": "drcProfile",
            "lfe_filter": "lfeFilter",
            "metadata_control": "metadataControl",
        },
    )
    class Ac3SettingsProperty:
        def __init__(
            self,
            *,
            bitrate: typing.Optional[jsii.Number] = None,
            bitstream_mode: typing.Optional[builtins.str] = None,
            coding_mode: typing.Optional[builtins.str] = None,
            dialnorm: typing.Optional[jsii.Number] = None,
            drc_profile: typing.Optional[builtins.str] = None,
            lfe_filter: typing.Optional[builtins.str] = None,
            metadata_control: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The settings for an AC3 audio encode in the output.

            The parent of this entity is AudioCodecSettings.

            :param bitrate: The average bitrate in bits/second. Valid bitrates depend on the coding mode.
            :param bitstream_mode: Specifies the bitstream mode (bsmod) for the emitted AC-3 stream. For more information about these values, see ATSC A/52-2012.
            :param coding_mode: The Dolby Digital coding mode. This determines the number of channels.
            :param dialnorm: Sets the dialnorm for the output. If excluded and the input audio is Dolby Digital, dialnorm is passed through.
            :param drc_profile: If set to filmStandard, adds dynamic range compression signaling to the output bitstream as defined in the Dolby Digital specification.
            :param lfe_filter: When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding. This is valid only in codingMode32Lfe mode.
            :param metadata_control: When set to followInput, encoder metadata is sourced from the DD, DD+, or DolbyE decoder that supplies this audio data. If the audio is supplied from one of these streams, the static metadata settings are used.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                ac3_settings_property = medialive.CfnChannel.Ac3SettingsProperty(
                    bitrate=123,
                    bitstream_mode="bitstreamMode",
                    coding_mode="codingMode",
                    dialnorm=123,
                    drc_profile="drcProfile",
                    lfe_filter="lfeFilter",
                    metadata_control="metadataControl"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if bitrate is not None:
                self._values["bitrate"] = bitrate
            if bitstream_mode is not None:
                self._values["bitstream_mode"] = bitstream_mode
            if coding_mode is not None:
                self._values["coding_mode"] = coding_mode
            if dialnorm is not None:
                self._values["dialnorm"] = dialnorm
            if drc_profile is not None:
                self._values["drc_profile"] = drc_profile
            if lfe_filter is not None:
                self._values["lfe_filter"] = lfe_filter
            if metadata_control is not None:
                self._values["metadata_control"] = metadata_control

        @builtins.property
        def bitrate(self) -> typing.Optional[jsii.Number]:
            '''The average bitrate in bits/second.

            Valid bitrates depend on the coding mode.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-bitrate
            '''
            result = self._values.get("bitrate")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def bitstream_mode(self) -> typing.Optional[builtins.str]:
            '''Specifies the bitstream mode (bsmod) for the emitted AC-3 stream.

            For more information about these values, see ATSC A/52-2012.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-bitstreammode
            '''
            result = self._values.get("bitstream_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def coding_mode(self) -> typing.Optional[builtins.str]:
            '''The Dolby Digital coding mode.

            This determines the number of channels.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-codingmode
            '''
            result = self._values.get("coding_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def dialnorm(self) -> typing.Optional[jsii.Number]:
            '''Sets the dialnorm for the output.

            If excluded and the input audio is Dolby Digital, dialnorm is passed through.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-dialnorm
            '''
            result = self._values.get("dialnorm")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def drc_profile(self) -> typing.Optional[builtins.str]:
            '''If set to filmStandard, adds dynamic range compression signaling to the output bitstream as defined in the Dolby Digital specification.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-drcprofile
            '''
            result = self._values.get("drc_profile")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def lfe_filter(self) -> typing.Optional[builtins.str]:
            '''When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding.

            This is valid only in codingMode32Lfe mode.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-lfefilter
            '''
            result = self._values.get("lfe_filter")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def metadata_control(self) -> typing.Optional[builtins.str]:
            '''When set to followInput, encoder metadata is sourced from the DD, DD+, or DolbyE decoder that supplies this audio data.

            If the audio is supplied from one of these streams, the static metadata settings are used.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-metadatacontrol
            '''
            result = self._values.get("metadata_control")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "Ac3SettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.AncillarySourceSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "source_ancillary_channel_number": "sourceAncillaryChannelNumber",
        },
    )
    class AncillarySourceSettingsProperty:
        def __init__(
            self,
            *,
            source_ancillary_channel_number: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''Information about the ancillary captions to extract from the input.

            The parent of this entity is CaptionSelectorSettings.

            :param source_ancillary_channel_number: Specifies the number (1 to 4) of the captions channel you want to extract from the ancillary captions. If you plan to convert the ancillary captions to another format, complete this field. If you plan to choose Embedded as the captions destination in the output (to pass through all the channels in the ancillary captions), leave this field blank because MediaLive ignores the field.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ancillarysourcesettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                ancillary_source_settings_property = medialive.CfnChannel.AncillarySourceSettingsProperty(
                    source_ancillary_channel_number=123
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if source_ancillary_channel_number is not None:
                self._values["source_ancillary_channel_number"] = source_ancillary_channel_number

        @builtins.property
        def source_ancillary_channel_number(self) -> typing.Optional[jsii.Number]:
            '''Specifies the number (1 to 4) of the captions channel you want to extract from the ancillary captions.

            If you plan to convert the ancillary captions to another format, complete this field. If you plan to choose Embedded as the captions destination in the output (to pass through all the channels in the ancillary captions), leave this field blank because MediaLive ignores the field.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ancillarysourcesettings.html#cfn-medialive-channel-ancillarysourcesettings-sourceancillarychannelnumber
            '''
            result = self._values.get("source_ancillary_channel_number")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AncillarySourceSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.ArchiveCdnSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"archive_s3_settings": "archiveS3Settings"},
    )
    class ArchiveCdnSettingsProperty:
        def __init__(
            self,
            *,
            archive_s3_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.ArchiveS3SettingsProperty"]] = None,
        ) -> None:
            '''Settings to configure the destination of an Archive output.

            The parent of this entity is ArchiveGroupSettings.

            :param archive_s3_settings: Sets up Amazon S3 as the destination for this Archive output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivecdnsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                archive_cdn_settings_property = medialive.CfnChannel.ArchiveCdnSettingsProperty(
                    archive_s3_settings=medialive.CfnChannel.ArchiveS3SettingsProperty(
                        canned_acl="cannedAcl"
                    )
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if archive_s3_settings is not None:
                self._values["archive_s3_settings"] = archive_s3_settings

        @builtins.property
        def archive_s3_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.ArchiveS3SettingsProperty"]]:
            '''Sets up Amazon S3 as the destination for this Archive output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivecdnsettings.html#cfn-medialive-channel-archivecdnsettings-archives3settings
            '''
            result = self._values.get("archive_s3_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.ArchiveS3SettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ArchiveCdnSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.ArchiveContainerSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"m2_ts_settings": "m2TsSettings", "raw_settings": "rawSettings"},
    )
    class ArchiveContainerSettingsProperty:
        def __init__(
            self,
            *,
            m2_ts_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.M2tsSettingsProperty"]] = None,
            raw_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.RawSettingsProperty"]] = None,
        ) -> None:
            '''The archive container settings.

            The parent of this entity is ArchiveOutputSettings.

            :param m2_ts_settings: The settings for the M2TS in the archive output.
            :param raw_settings: The settings for Raw archive output type.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivecontainersettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                archive_container_settings_property = medialive.CfnChannel.ArchiveContainerSettingsProperty(
                    m2_ts_settings=medialive.CfnChannel.M2tsSettingsProperty(
                        absent_input_audio_behavior="absentInputAudioBehavior",
                        arib="arib",
                        arib_captions_pid="aribCaptionsPid",
                        arib_captions_pid_control="aribCaptionsPidControl",
                        audio_buffer_model="audioBufferModel",
                        audio_frames_per_pes=123,
                        audio_pids="audioPids",
                        audio_stream_type="audioStreamType",
                        bitrate=123,
                        buffer_model="bufferModel",
                        cc_descriptor="ccDescriptor",
                        dvb_nit_settings=medialive.CfnChannel.DvbNitSettingsProperty(
                            network_id=123,
                            network_name="networkName",
                            rep_interval=123
                        ),
                        dvb_sdt_settings=medialive.CfnChannel.DvbSdtSettingsProperty(
                            output_sdt="outputSdt",
                            rep_interval=123,
                            service_name="serviceName",
                            service_provider_name="serviceProviderName"
                        ),
                        dvb_sub_pids="dvbSubPids",
                        dvb_tdt_settings=medialive.CfnChannel.DvbTdtSettingsProperty(
                            rep_interval=123
                        ),
                        dvb_teletext_pid="dvbTeletextPid",
                        ebif="ebif",
                        ebp_audio_interval="ebpAudioInterval",
                        ebp_lookahead_ms=123,
                        ebp_placement="ebpPlacement",
                        ecm_pid="ecmPid",
                        es_rate_in_pes="esRateInPes",
                        etv_platform_pid="etvPlatformPid",
                        etv_signal_pid="etvSignalPid",
                        fragment_time=123,
                        klv="klv",
                        klv_data_pids="klvDataPids",
                        nielsen_id3_behavior="nielsenId3Behavior",
                        null_packet_bitrate=123,
                        pat_interval=123,
                        pcr_control="pcrControl",
                        pcr_period=123,
                        pcr_pid="pcrPid",
                        pmt_interval=123,
                        pmt_pid="pmtPid",
                        program_num=123,
                        rate_mode="rateMode",
                        scte27_pids="scte27Pids",
                        scte35_control="scte35Control",
                        scte35_pid="scte35Pid",
                        segmentation_markers="segmentationMarkers",
                        segmentation_style="segmentationStyle",
                        segmentation_time=123,
                        timed_metadata_behavior="timedMetadataBehavior",
                        timed_metadata_pid="timedMetadataPid",
                        transport_stream_id=123,
                        video_pid="videoPid"
                    ),
                    raw_settings=medialive.CfnChannel.RawSettingsProperty()
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if m2_ts_settings is not None:
                self._values["m2_ts_settings"] = m2_ts_settings
            if raw_settings is not None:
                self._values["raw_settings"] = raw_settings

        @builtins.property
        def m2_ts_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.M2tsSettingsProperty"]]:
            '''The settings for the M2TS in the archive output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivecontainersettings.html#cfn-medialive-channel-archivecontainersettings-m2tssettings
            '''
            result = self._values.get("m2_ts_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.M2tsSettingsProperty"]], result)

        @builtins.property
        def raw_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.RawSettingsProperty"]]:
            '''The settings for Raw archive output type.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivecontainersettings.html#cfn-medialive-channel-archivecontainersettings-rawsettings
            '''
            result = self._values.get("raw_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.RawSettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ArchiveContainerSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.ArchiveGroupSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "archive_cdn_settings": "archiveCdnSettings",
            "destination": "destination",
            "rollover_interval": "rolloverInterval",
        },
    )
    class ArchiveGroupSettingsProperty:
        def __init__(
            self,
            *,
            archive_cdn_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.ArchiveCdnSettingsProperty"]] = None,
            destination: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputLocationRefProperty"]] = None,
            rollover_interval: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''The settings for an archive output group.

            The parent of this entity is OutputGroupSettings.

            :param archive_cdn_settings: Settings to configure the destination of an Archive output.
            :param destination: A directory and base file name where archive files should be written.
            :param rollover_interval: The number of seconds to write to an archive file before closing and starting a new one.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivegroupsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                archive_group_settings_property = medialive.CfnChannel.ArchiveGroupSettingsProperty(
                    archive_cdn_settings=medialive.CfnChannel.ArchiveCdnSettingsProperty(
                        archive_s3_settings=medialive.CfnChannel.ArchiveS3SettingsProperty(
                            canned_acl="cannedAcl"
                        )
                    ),
                    destination=medialive.CfnChannel.OutputLocationRefProperty(
                        destination_ref_id="destinationRefId"
                    ),
                    rollover_interval=123
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if archive_cdn_settings is not None:
                self._values["archive_cdn_settings"] = archive_cdn_settings
            if destination is not None:
                self._values["destination"] = destination
            if rollover_interval is not None:
                self._values["rollover_interval"] = rollover_interval

        @builtins.property
        def archive_cdn_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.ArchiveCdnSettingsProperty"]]:
            '''Settings to configure the destination of an Archive output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivegroupsettings.html#cfn-medialive-channel-archivegroupsettings-archivecdnsettings
            '''
            result = self._values.get("archive_cdn_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.ArchiveCdnSettingsProperty"]], result)

        @builtins.property
        def destination(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputLocationRefProperty"]]:
            '''A directory and base file name where archive files should be written.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivegroupsettings.html#cfn-medialive-channel-archivegroupsettings-destination
            '''
            result = self._values.get("destination")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputLocationRefProperty"]], result)

        @builtins.property
        def rollover_interval(self) -> typing.Optional[jsii.Number]:
            '''The number of seconds to write to an archive file before closing and starting a new one.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivegroupsettings.html#cfn-medialive-channel-archivegroupsettings-rolloverinterval
            '''
            result = self._values.get("rollover_interval")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ArchiveGroupSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.ArchiveOutputSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "container_settings": "containerSettings",
            "extension": "extension",
            "name_modifier": "nameModifier",
        },
    )
    class ArchiveOutputSettingsProperty:
        def __init__(
            self,
            *,
            container_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.ArchiveContainerSettingsProperty"]] = None,
            extension: typing.Optional[builtins.str] = None,
            name_modifier: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The archive output settings.

            The parent of this entity is OutputSettings.

            :param container_settings: The settings that are specific to the container type of the file.
            :param extension: The output file extension. If excluded, this is auto-selected from the container type.
            :param name_modifier: A string that is concatenated to the end of the destination file name. The string is required for multiple outputs of the same type.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archiveoutputsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                archive_output_settings_property = medialive.CfnChannel.ArchiveOutputSettingsProperty(
                    container_settings=medialive.CfnChannel.ArchiveContainerSettingsProperty(
                        m2_ts_settings=medialive.CfnChannel.M2tsSettingsProperty(
                            absent_input_audio_behavior="absentInputAudioBehavior",
                            arib="arib",
                            arib_captions_pid="aribCaptionsPid",
                            arib_captions_pid_control="aribCaptionsPidControl",
                            audio_buffer_model="audioBufferModel",
                            audio_frames_per_pes=123,
                            audio_pids="audioPids",
                            audio_stream_type="audioStreamType",
                            bitrate=123,
                            buffer_model="bufferModel",
                            cc_descriptor="ccDescriptor",
                            dvb_nit_settings=medialive.CfnChannel.DvbNitSettingsProperty(
                                network_id=123,
                                network_name="networkName",
                                rep_interval=123
                            ),
                            dvb_sdt_settings=medialive.CfnChannel.DvbSdtSettingsProperty(
                                output_sdt="outputSdt",
                                rep_interval=123,
                                service_name="serviceName",
                                service_provider_name="serviceProviderName"
                            ),
                            dvb_sub_pids="dvbSubPids",
                            dvb_tdt_settings=medialive.CfnChannel.DvbTdtSettingsProperty(
                                rep_interval=123
                            ),
                            dvb_teletext_pid="dvbTeletextPid",
                            ebif="ebif",
                            ebp_audio_interval="ebpAudioInterval",
                            ebp_lookahead_ms=123,
                            ebp_placement="ebpPlacement",
                            ecm_pid="ecmPid",
                            es_rate_in_pes="esRateInPes",
                            etv_platform_pid="etvPlatformPid",
                            etv_signal_pid="etvSignalPid",
                            fragment_time=123,
                            klv="klv",
                            klv_data_pids="klvDataPids",
                            nielsen_id3_behavior="nielsenId3Behavior",
                            null_packet_bitrate=123,
                            pat_interval=123,
                            pcr_control="pcrControl",
                            pcr_period=123,
                            pcr_pid="pcrPid",
                            pmt_interval=123,
                            pmt_pid="pmtPid",
                            program_num=123,
                            rate_mode="rateMode",
                            scte27_pids="scte27Pids",
                            scte35_control="scte35Control",
                            scte35_pid="scte35Pid",
                            segmentation_markers="segmentationMarkers",
                            segmentation_style="segmentationStyle",
                            segmentation_time=123,
                            timed_metadata_behavior="timedMetadataBehavior",
                            timed_metadata_pid="timedMetadataPid",
                            transport_stream_id=123,
                            video_pid="videoPid"
                        ),
                        raw_settings=medialive.CfnChannel.RawSettingsProperty()
                    ),
                    extension="extension",
                    name_modifier="nameModifier"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if container_settings is not None:
                self._values["container_settings"] = container_settings
            if extension is not None:
                self._values["extension"] = extension
            if name_modifier is not None:
                self._values["name_modifier"] = name_modifier

        @builtins.property
        def container_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.ArchiveContainerSettingsProperty"]]:
            '''The settings that are specific to the container type of the file.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archiveoutputsettings.html#cfn-medialive-channel-archiveoutputsettings-containersettings
            '''
            result = self._values.get("container_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.ArchiveContainerSettingsProperty"]], result)

        @builtins.property
        def extension(self) -> typing.Optional[builtins.str]:
            '''The output file extension.

            If excluded, this is auto-selected from the container type.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archiveoutputsettings.html#cfn-medialive-channel-archiveoutputsettings-extension
            '''
            result = self._values.get("extension")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def name_modifier(self) -> typing.Optional[builtins.str]:
            '''A string that is concatenated to the end of the destination file name.

            The string is required for multiple outputs of the same type.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archiveoutputsettings.html#cfn-medialive-channel-archiveoutputsettings-namemodifier
            '''
            result = self._values.get("name_modifier")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ArchiveOutputSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.ArchiveS3SettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"canned_acl": "cannedAcl"},
    )
    class ArchiveS3SettingsProperty:
        def __init__(self, *, canned_acl: typing.Optional[builtins.str] = None) -> None:
            '''Sets up Amazon S3 as the destination for this Archive output.

            The parent of this entity is ArchiveCdnSettings.

            :param canned_acl: Specify the canned ACL to apply to each S3 request. Defaults to none.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archives3settings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                archive_s3_settings_property = medialive.CfnChannel.ArchiveS3SettingsProperty(
                    canned_acl="cannedAcl"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if canned_acl is not None:
                self._values["canned_acl"] = canned_acl

        @builtins.property
        def canned_acl(self) -> typing.Optional[builtins.str]:
            '''Specify the canned ACL to apply to each S3 request.

            Defaults to none.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archives3settings.html#cfn-medialive-channel-archives3settings-cannedacl
            '''
            result = self._values.get("canned_acl")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ArchiveS3SettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.AribDestinationSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={},
    )
    class AribDestinationSettingsProperty:
        def __init__(self) -> None:
            '''The configuration of ARIB captions in the output.

            The parent of this entity is CaptionDestinationSettings.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aribdestinationsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                arib_destination_settings_property = medialive.CfnChannel.AribDestinationSettingsProperty()
            '''
            self._values: typing.Dict[str, typing.Any] = {}

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AribDestinationSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.AribSourceSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={},
    )
    class AribSourceSettingsProperty:
        def __init__(self) -> None:
            '''Information about the ARIB captions to extract from the input.

            The parent of this entity is CaptionSelectorSettings.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aribsourcesettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                arib_source_settings_property = medialive.CfnChannel.AribSourceSettingsProperty()
            '''
            self._values: typing.Dict[str, typing.Any] = {}

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AribSourceSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.AudioChannelMappingProperty",
        jsii_struct_bases=[],
        name_mapping={
            "input_channel_levels": "inputChannelLevels",
            "output_channel": "outputChannel",
        },
    )
    class AudioChannelMappingProperty:
        def __init__(
            self,
            *,
            input_channel_levels: typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.Sequence[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputChannelLevelProperty"]]]] = None,
            output_channel: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''The settings for remixing audio.

            The parent of this entity is RemixSettings.

            :param input_channel_levels: The indices and gain values for each input channel that should be remixed into this output channel.
            :param output_channel: The index of the output channel that is being produced.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiochannelmapping.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                audio_channel_mapping_property = medialive.CfnChannel.AudioChannelMappingProperty(
                    input_channel_levels=[medialive.CfnChannel.InputChannelLevelProperty(
                        gain=123,
                        input_channel=123
                    )],
                    output_channel=123
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if input_channel_levels is not None:
                self._values["input_channel_levels"] = input_channel_levels
            if output_channel is not None:
                self._values["output_channel"] = output_channel

        @builtins.property
        def input_channel_levels(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputChannelLevelProperty"]]]]:
            '''The indices and gain values for each input channel that should be remixed into this output channel.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiochannelmapping.html#cfn-medialive-channel-audiochannelmapping-inputchannellevels
            '''
            result = self._values.get("input_channel_levels")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputChannelLevelProperty"]]]], result)

        @builtins.property
        def output_channel(self) -> typing.Optional[jsii.Number]:
            '''The index of the output channel that is being produced.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiochannelmapping.html#cfn-medialive-channel-audiochannelmapping-outputchannel
            '''
            result = self._values.get("output_channel")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AudioChannelMappingProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.AudioCodecSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "aac_settings": "aacSettings",
            "ac3_settings": "ac3Settings",
            "eac3_settings": "eac3Settings",
            "mp2_settings": "mp2Settings",
            "pass_through_settings": "passThroughSettings",
            "wav_settings": "wavSettings",
        },
    )
    class AudioCodecSettingsProperty:
        def __init__(
            self,
            *,
            aac_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AacSettingsProperty"]] = None,
            ac3_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Ac3SettingsProperty"]] = None,
            eac3_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Eac3SettingsProperty"]] = None,
            mp2_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Mp2SettingsProperty"]] = None,
            pass_through_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.PassThroughSettingsProperty"]] = None,
            wav_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.WavSettingsProperty"]] = None,
        ) -> None:
            '''The configuration of the audio codec in the audio output.

            The parent of this entity is AudioDescription.

            :param aac_settings: The setup of the AAC audio codec in the output.
            :param ac3_settings: The setup of an AC3 audio codec in the output.
            :param eac3_settings: The setup of an EAC3 audio codec in the output.
            :param mp2_settings: The setup of an MP2 audio codec in the output.
            :param pass_through_settings: The setup to pass through the Dolby audio codec to the output.
            :param wav_settings: Settings for audio encoded with the WAV codec.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                audio_codec_settings_property = medialive.CfnChannel.AudioCodecSettingsProperty(
                    aac_settings=medialive.CfnChannel.AacSettingsProperty(
                        bitrate=123,
                        coding_mode="codingMode",
                        input_type="inputType",
                        profile="profile",
                        rate_control_mode="rateControlMode",
                        raw_format="rawFormat",
                        sample_rate=123,
                        spec="spec",
                        vbr_quality="vbrQuality"
                    ),
                    ac3_settings=medialive.CfnChannel.Ac3SettingsProperty(
                        bitrate=123,
                        bitstream_mode="bitstreamMode",
                        coding_mode="codingMode",
                        dialnorm=123,
                        drc_profile="drcProfile",
                        lfe_filter="lfeFilter",
                        metadata_control="metadataControl"
                    ),
                    eac3_settings=medialive.CfnChannel.Eac3SettingsProperty(
                        attenuation_control="attenuationControl",
                        bitrate=123,
                        bitstream_mode="bitstreamMode",
                        coding_mode="codingMode",
                        dc_filter="dcFilter",
                        dialnorm=123,
                        drc_line="drcLine",
                        drc_rf="drcRf",
                        lfe_control="lfeControl",
                        lfe_filter="lfeFilter",
                        lo_ro_center_mix_level=123,
                        lo_ro_surround_mix_level=123,
                        lt_rt_center_mix_level=123,
                        lt_rt_surround_mix_level=123,
                        metadata_control="metadataControl",
                        passthrough_control="passthroughControl",
                        phase_control="phaseControl",
                        stereo_downmix="stereoDownmix",
                        surround_ex_mode="surroundExMode",
                        surround_mode="surroundMode"
                    ),
                    mp2_settings=medialive.CfnChannel.Mp2SettingsProperty(
                        bitrate=123,
                        coding_mode="codingMode",
                        sample_rate=123
                    ),
                    pass_through_settings=medialive.CfnChannel.PassThroughSettingsProperty(),
                    wav_settings=medialive.CfnChannel.WavSettingsProperty(
                        bit_depth=123,
                        coding_mode="codingMode",
                        sample_rate=123
                    )
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if aac_settings is not None:
                self._values["aac_settings"] = aac_settings
            if ac3_settings is not None:
                self._values["ac3_settings"] = ac3_settings
            if eac3_settings is not None:
                self._values["eac3_settings"] = eac3_settings
            if mp2_settings is not None:
                self._values["mp2_settings"] = mp2_settings
            if pass_through_settings is not None:
                self._values["pass_through_settings"] = pass_through_settings
            if wav_settings is not None:
                self._values["wav_settings"] = wav_settings

        @builtins.property
        def aac_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AacSettingsProperty"]]:
            '''The setup of the AAC audio codec in the output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-aacsettings
            '''
            result = self._values.get("aac_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AacSettingsProperty"]], result)

        @builtins.property
        def ac3_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Ac3SettingsProperty"]]:
            '''The setup of an AC3 audio codec in the output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-ac3settings
            '''
            result = self._values.get("ac3_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Ac3SettingsProperty"]], result)

        @builtins.property
        def eac3_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Eac3SettingsProperty"]]:
            '''The setup of an EAC3 audio codec in the output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-eac3settings
            '''
            result = self._values.get("eac3_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Eac3SettingsProperty"]], result)

        @builtins.property
        def mp2_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Mp2SettingsProperty"]]:
            '''The setup of an MP2 audio codec in the output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-mp2settings
            '''
            result = self._values.get("mp2_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Mp2SettingsProperty"]], result)

        @builtins.property
        def pass_through_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.PassThroughSettingsProperty"]]:
            '''The setup to pass through the Dolby audio codec to the output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-passthroughsettings
            '''
            result = self._values.get("pass_through_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.PassThroughSettingsProperty"]], result)

        @builtins.property
        def wav_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.WavSettingsProperty"]]:
            '''Settings for audio encoded with the WAV codec.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-wavsettings
            '''
            result = self._values.get("wav_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.WavSettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AudioCodecSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.AudioDescriptionProperty",
        jsii_struct_bases=[],
        name_mapping={
            "audio_normalization_settings": "audioNormalizationSettings",
            "audio_selector_name": "audioSelectorName",
            "audio_type": "audioType",
            "audio_type_control": "audioTypeControl",
            "audio_watermarking_settings": "audioWatermarkingSettings",
            "codec_settings": "codecSettings",
            "language_code": "languageCode",
            "language_code_control": "languageCodeControl",
            "name": "name",
            "remix_settings": "remixSettings",
            "stream_name": "streamName",
        },
    )
    class AudioDescriptionProperty:
        def __init__(
            self,
            *,
            audio_normalization_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioNormalizationSettingsProperty"]] = None,
            audio_selector_name: typing.Optional[builtins.str] = None,
            audio_type: typing.Optional[builtins.str] = None,
            audio_type_control: typing.Optional[builtins.str] = None,
            audio_watermarking_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioWatermarkSettingsProperty"]] = None,
            codec_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioCodecSettingsProperty"]] = None,
            language_code: typing.Optional[builtins.str] = None,
            language_code_control: typing.Optional[builtins.str] = None,
            name: typing.Optional[builtins.str] = None,
            remix_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.RemixSettingsProperty"]] = None,
            stream_name: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The encoding information for one output audio.

            The parent of this entity is EncoderSettings.

            :param audio_normalization_settings: The advanced audio normalization settings.
            :param audio_selector_name: The name of the AudioSelector that is used as the source for this AudioDescription.
            :param audio_type: Applies only if audioTypeControl is useConfigured. The values for audioType are defined in ISO-IEC 13818-1.
            :param audio_type_control: Determines how audio type is determined. followInput: If the input contains an ISO 639 audioType, then that value is passed through to the output. If the input contains no ISO 639 audioType, the value in Audio Type is included in the output. useConfigured: The value in Audio Type is included in the output. Note that this field and audioType are both ignored if inputType is broadcasterMixedAd.
            :param audio_watermarking_settings: Settings to configure one or more solutions that insert audio watermarks in the audio encode.
            :param codec_settings: The audio codec settings.
            :param language_code: Indicates the language of the audio output track. Used only if languageControlMode is useConfigured, or there is no ISO 639 language code specified in the input.
            :param language_code_control: Choosing followInput causes the ISO 639 language code of the output to follow the ISO 639 language code of the input. The languageCode setting is used when useConfigured is set, or when followInput is selected but there is no ISO 639 language code specified by the input.
            :param name: The name of this AudioDescription. Outputs use this name to uniquely identify this AudioDescription. Description names should be unique within this channel.
            :param remix_settings: The settings that control how input audio channels are remixed into the output audio channels.
            :param stream_name: Used for Microsoft Smooth and Apple HLS outputs. Indicates the name displayed by the player (for example, English or Director Commentary).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                audio_description_property = medialive.CfnChannel.AudioDescriptionProperty(
                    audio_normalization_settings=medialive.CfnChannel.AudioNormalizationSettingsProperty(
                        algorithm="algorithm",
                        algorithm_control="algorithmControl",
                        target_lkfs=123
                    ),
                    audio_selector_name="audioSelectorName",
                    audio_type="audioType",
                    audio_type_control="audioTypeControl",
                    audio_watermarking_settings=medialive.CfnChannel.AudioWatermarkSettingsProperty(
                        nielsen_watermarks_settings=medialive.CfnChannel.NielsenWatermarksSettingsProperty(
                            nielsen_cbet_settings=medialive.CfnChannel.NielsenCBETProperty(
                                cbet_check_digit_string="cbetCheckDigitString",
                                cbet_stepaside="cbetStepaside",
                                csid="csid"
                            ),
                            nielsen_distribution_type="nielsenDistributionType",
                            nielsen_naes_ii_nw_settings=medialive.CfnChannel.NielsenNaesIiNwProperty(
                                check_digit_string="checkDigitString",
                                sid=123
                            )
                        )
                    ),
                    codec_settings=medialive.CfnChannel.AudioCodecSettingsProperty(
                        aac_settings=medialive.CfnChannel.AacSettingsProperty(
                            bitrate=123,
                            coding_mode="codingMode",
                            input_type="inputType",
                            profile="profile",
                            rate_control_mode="rateControlMode",
                            raw_format="rawFormat",
                            sample_rate=123,
                            spec="spec",
                            vbr_quality="vbrQuality"
                        ),
                        ac3_settings=medialive.CfnChannel.Ac3SettingsProperty(
                            bitrate=123,
                            bitstream_mode="bitstreamMode",
                            coding_mode="codingMode",
                            dialnorm=123,
                            drc_profile="drcProfile",
                            lfe_filter="lfeFilter",
                            metadata_control="metadataControl"
                        ),
                        eac3_settings=medialive.CfnChannel.Eac3SettingsProperty(
                            attenuation_control="attenuationControl",
                            bitrate=123,
                            bitstream_mode="bitstreamMode",
                            coding_mode="codingMode",
                            dc_filter="dcFilter",
                            dialnorm=123,
                            drc_line="drcLine",
                            drc_rf="drcRf",
                            lfe_control="lfeControl",
                            lfe_filter="lfeFilter",
                            lo_ro_center_mix_level=123,
                            lo_ro_surround_mix_level=123,
                            lt_rt_center_mix_level=123,
                            lt_rt_surround_mix_level=123,
                            metadata_control="metadataControl",
                            passthrough_control="passthroughControl",
                            phase_control="phaseControl",
                            stereo_downmix="stereoDownmix",
                            surround_ex_mode="surroundExMode",
                            surround_mode="surroundMode"
                        ),
                        mp2_settings=medialive.CfnChannel.Mp2SettingsProperty(
                            bitrate=123,
                            coding_mode="codingMode",
                            sample_rate=123
                        ),
                        pass_through_settings=medialive.CfnChannel.PassThroughSettingsProperty(),
                        wav_settings=medialive.CfnChannel.WavSettingsProperty(
                            bit_depth=123,
                            coding_mode="codingMode",
                            sample_rate=123
                        )
                    ),
                    language_code="languageCode",
                    language_code_control="languageCodeControl",
                    name="name",
                    remix_settings=medialive.CfnChannel.RemixSettingsProperty(
                        channel_mappings=[medialive.CfnChannel.AudioChannelMappingProperty(
                            input_channel_levels=[medialive.CfnChannel.InputChannelLevelProperty(
                                gain=123,
                                input_channel=123
                            )],
                            output_channel=123
                        )],
                        channels_in=123,
                        channels_out=123
                    ),
                    stream_name="streamName"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if audio_normalization_settings is not None:
                self._values["audio_normalization_settings"] = audio_normalization_settings
            if audio_selector_name is not None:
                self._values["audio_selector_name"] = audio_selector_name
            if audio_type is not None:
                self._values["audio_type"] = audio_type
            if audio_type_control is not None:
                self._values["audio_type_control"] = audio_type_control
            if audio_watermarking_settings is not None:
                self._values["audio_watermarking_settings"] = audio_watermarking_settings
            if codec_settings is not None:
                self._values["codec_settings"] = codec_settings
            if language_code is not None:
                self._values["language_code"] = language_code
            if language_code_control is not None:
                self._values["language_code_control"] = language_code_control
            if name is not None:
                self._values["name"] = name
            if remix_settings is not None:
                self._values["remix_settings"] = remix_settings
            if stream_name is not None:
                self._values["stream_name"] = stream_name

        @builtins.property
        def audio_normalization_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioNormalizationSettingsProperty"]]:
            '''The advanced audio normalization settings.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-audionormalizationsettings
            '''
            result = self._values.get("audio_normalization_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioNormalizationSettingsProperty"]], result)

        @builtins.property
        def audio_selector_name(self) -> typing.Optional[builtins.str]:
            '''The name of the AudioSelector that is used as the source for this AudioDescription.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-audioselectorname
            '''
            result = self._values.get("audio_selector_name")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def audio_type(self) -> typing.Optional[builtins.str]:
            '''Applies only if audioTypeControl is useConfigured.

            The values for audioType are defined in ISO-IEC 13818-1.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-audiotype
            '''
            result = self._values.get("audio_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def audio_type_control(self) -> typing.Optional[builtins.str]:
            '''Determines how audio type is determined.

            followInput: If the input contains an ISO 639 audioType, then that value is passed through to the output. If the input contains no ISO 639 audioType, the value in Audio Type is included in the output. useConfigured: The value in Audio Type is included in the output. Note that this field and audioType are both ignored if inputType is broadcasterMixedAd.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-audiotypecontrol
            '''
            result = self._values.get("audio_type_control")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def audio_watermarking_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioWatermarkSettingsProperty"]]:
            '''Settings to configure one or more solutions that insert audio watermarks in the audio encode.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-audiowatermarkingsettings
            '''
            result = self._values.get("audio_watermarking_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioWatermarkSettingsProperty"]], result)

        @builtins.property
        def codec_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioCodecSettingsProperty"]]:
            '''The audio codec settings.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-codecsettings
            '''
            result = self._values.get("codec_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioCodecSettingsProperty"]], result)

        @builtins.property
        def language_code(self) -> typing.Optional[builtins.str]:
            '''Indicates the language of the audio output track.

            Used only if languageControlMode is useConfigured, or there is no ISO 639 language code specified in the input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-languagecode
            '''
            result = self._values.get("language_code")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def language_code_control(self) -> typing.Optional[builtins.str]:
            '''Choosing followInput causes the ISO 639 language code of the output to follow the ISO 639 language code of the input.

            The languageCode setting is used when useConfigured is set, or when followInput is selected but there is no ISO 639 language code specified by the input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-languagecodecontrol
            '''
            result = self._values.get("language_code_control")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def name(self) -> typing.Optional[builtins.str]:
            '''The name of this AudioDescription.

            Outputs use this name to uniquely identify this AudioDescription. Description names should be unique within this channel.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-name
            '''
            result = self._values.get("name")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def remix_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.RemixSettingsProperty"]]:
            '''The settings that control how input audio channels are remixed into the output audio channels.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-remixsettings
            '''
            result = self._values.get("remix_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.RemixSettingsProperty"]], result)

        @builtins.property
        def stream_name(self) -> typing.Optional[builtins.str]:
            '''Used for Microsoft Smooth and Apple HLS outputs.

            Indicates the name displayed by the player (for example, English or Director Commentary).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-streamname
            '''
            result = self._values.get("stream_name")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AudioDescriptionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.AudioHlsRenditionSelectionProperty",
        jsii_struct_bases=[],
        name_mapping={"group_id": "groupId", "name": "name"},
    )
    class AudioHlsRenditionSelectionProperty:
        def __init__(
            self,
            *,
            group_id: typing.Optional[builtins.str] = None,
            name: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Selector for HLS audio rendition.

            The parent of this entity is AudioSelectorSettings.

            :param group_id: Specifies the GROUP-ID in the #EXT-X-MEDIA tag of the target HLS audio rendition.
            :param name: Specifies the NAME in the #EXT-X-MEDIA tag of the target HLS audio rendition.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiohlsrenditionselection.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                audio_hls_rendition_selection_property = medialive.CfnChannel.AudioHlsRenditionSelectionProperty(
                    group_id="groupId",
                    name="name"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if group_id is not None:
                self._values["group_id"] = group_id
            if name is not None:
                self._values["name"] = name

        @builtins.property
        def group_id(self) -> typing.Optional[builtins.str]:
            '''Specifies the GROUP-ID in the #EXT-X-MEDIA tag of the target HLS audio rendition.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiohlsrenditionselection.html#cfn-medialive-channel-audiohlsrenditionselection-groupid
            '''
            result = self._values.get("group_id")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def name(self) -> typing.Optional[builtins.str]:
            '''Specifies the NAME in the #EXT-X-MEDIA tag of the target HLS audio rendition.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiohlsrenditionselection.html#cfn-medialive-channel-audiohlsrenditionselection-name
            '''
            result = self._values.get("name")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AudioHlsRenditionSelectionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.AudioLanguageSelectionProperty",
        jsii_struct_bases=[],
        name_mapping={
            "language_code": "languageCode",
            "language_selection_policy": "languageSelectionPolicy",
        },
    )
    class AudioLanguageSelectionProperty:
        def __init__(
            self,
            *,
            language_code: typing.Optional[builtins.str] = None,
            language_selection_policy: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Information about the audio language to extract.

            The parent of this entity is AudioSelectorSettings.

            :param language_code: Selects a specific three-letter language code from within an audio source.
            :param language_selection_policy: When set to "strict," the transport stream demux strictly identifies audio streams by their language descriptor. If a PMT update occurs such that an audio stream matching the initially selected language is no longer present, then mute is encoded until the language returns. If set to "loose," then on a PMT update the demux chooses another audio stream in the program with the same stream type if it can't find one with the same language.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiolanguageselection.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                audio_language_selection_property = medialive.CfnChannel.AudioLanguageSelectionProperty(
                    language_code="languageCode",
                    language_selection_policy="languageSelectionPolicy"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if language_code is not None:
                self._values["language_code"] = language_code
            if language_selection_policy is not None:
                self._values["language_selection_policy"] = language_selection_policy

        @builtins.property
        def language_code(self) -> typing.Optional[builtins.str]:
            '''Selects a specific three-letter language code from within an audio source.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiolanguageselection.html#cfn-medialive-channel-audiolanguageselection-languagecode
            '''
            result = self._values.get("language_code")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def language_selection_policy(self) -> typing.Optional[builtins.str]:
            '''When set to "strict," the transport stream demux strictly identifies audio streams by their language descriptor.

            If a PMT update occurs such that an audio stream matching the initially selected language is no longer present, then mute is encoded until the language returns. If set to "loose," then on a PMT update the demux chooses another audio stream in the program with the same stream type if it can't find one with the same language.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiolanguageselection.html#cfn-medialive-channel-audiolanguageselection-languageselectionpolicy
            '''
            result = self._values.get("language_selection_policy")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AudioLanguageSelectionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.AudioNormalizationSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "algorithm": "algorithm",
            "algorithm_control": "algorithmControl",
            "target_lkfs": "targetLkfs",
        },
    )
    class AudioNormalizationSettingsProperty:
        def __init__(
            self,
            *,
            algorithm: typing.Optional[builtins.str] = None,
            algorithm_control: typing.Optional[builtins.str] = None,
            target_lkfs: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''The settings for normalizing video.

            The parent of this entity is AudioDescription.

            :param algorithm: The audio normalization algorithm to use. itu17701 conforms to the CALM Act specification. itu17702 conforms to the EBU R-128 specification.
            :param algorithm_control: When set to correctAudio, the output audio is corrected using the chosen algorithm. If set to measureOnly, the audio is measured but not adjusted.
            :param target_lkfs: The Target LKFS(loudness) to adjust volume to. If no value is entered, a default value is used according to the chosen algorithm. The CALM Act (1770-1) recommends a target of -24 LKFS. The EBU R-128 specification (1770-2) recommends a target of -23 LKFS.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audionormalizationsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                audio_normalization_settings_property = medialive.CfnChannel.AudioNormalizationSettingsProperty(
                    algorithm="algorithm",
                    algorithm_control="algorithmControl",
                    target_lkfs=123
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if algorithm is not None:
                self._values["algorithm"] = algorithm
            if algorithm_control is not None:
                self._values["algorithm_control"] = algorithm_control
            if target_lkfs is not None:
                self._values["target_lkfs"] = target_lkfs

        @builtins.property
        def algorithm(self) -> typing.Optional[builtins.str]:
            '''The audio normalization algorithm to use.

            itu17701 conforms to the CALM Act specification. itu17702 conforms to the EBU R-128 specification.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audionormalizationsettings.html#cfn-medialive-channel-audionormalizationsettings-algorithm
            '''
            result = self._values.get("algorithm")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def algorithm_control(self) -> typing.Optional[builtins.str]:
            '''When set to correctAudio, the output audio is corrected using the chosen algorithm.

            If set to measureOnly, the audio is measured but not adjusted.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audionormalizationsettings.html#cfn-medialive-channel-audionormalizationsettings-algorithmcontrol
            '''
            result = self._values.get("algorithm_control")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def target_lkfs(self) -> typing.Optional[jsii.Number]:
            '''The Target LKFS(loudness) to adjust volume to.

            If no value is entered, a default value is used according to the chosen algorithm. The CALM Act (1770-1) recommends a target of -24 LKFS. The EBU R-128 specification (1770-2) recommends a target of -23 LKFS.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audionormalizationsettings.html#cfn-medialive-channel-audionormalizationsettings-targetlkfs
            '''
            result = self._values.get("target_lkfs")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AudioNormalizationSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.AudioOnlyHlsSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "audio_group_id": "audioGroupId",
            "audio_only_image": "audioOnlyImage",
            "audio_track_type": "audioTrackType",
            "segment_type": "segmentType",
        },
    )
    class AudioOnlyHlsSettingsProperty:
        def __init__(
            self,
            *,
            audio_group_id: typing.Optional[builtins.str] = None,
            audio_only_image: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputLocationProperty"]] = None,
            audio_track_type: typing.Optional[builtins.str] = None,
            segment_type: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The configuration of an audio-only HLS output.

            The parent of this entity is HlsSettings.

            :param audio_group_id: Specifies the group that the audio rendition belongs to.
            :param audio_only_image: Used with an audio-only stream. It must be a .jpg or .png file. If given, this image is used as the cover art for the audio-only output. Ideally, it should be formatted for an iPhone screen for two reasons. The iPhone does not resize the image; instead, it crops a centered image on the top/bottom and left/right. Additionally, this image file gets saved bit-for-bit into every 10-second segment file, so it increases bandwidth by {image file size} * {segment count} * {user count.}.
            :param audio_track_type: Four types of audio-only tracks are supported: Audio-Only Variant Stream The client can play back this audio-only stream instead of video in low-bandwidth scenarios. Represented as an EXT-X-STREAM-INF in the HLS manifest. Alternate Audio, Auto Select, Default Alternate rendition that the client should try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES, AUTOSELECT=YES Alternate Audio, Auto Select, Not Default Alternate rendition that the client might try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YES Alternate Audio, not Auto Select Alternate rendition that the client will not try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=NO.
            :param segment_type: Specifies the segment type.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioonlyhlssettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                audio_only_hls_settings_property = medialive.CfnChannel.AudioOnlyHlsSettingsProperty(
                    audio_group_id="audioGroupId",
                    audio_only_image=medialive.CfnChannel.InputLocationProperty(
                        password_param="passwordParam",
                        uri="uri",
                        username="username"
                    ),
                    audio_track_type="audioTrackType",
                    segment_type="segmentType"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if audio_group_id is not None:
                self._values["audio_group_id"] = audio_group_id
            if audio_only_image is not None:
                self._values["audio_only_image"] = audio_only_image
            if audio_track_type is not None:
                self._values["audio_track_type"] = audio_track_type
            if segment_type is not None:
                self._values["segment_type"] = segment_type

        @builtins.property
        def audio_group_id(self) -> typing.Optional[builtins.str]:
            '''Specifies the group that the audio rendition belongs to.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioonlyhlssettings.html#cfn-medialive-channel-audioonlyhlssettings-audiogroupid
            '''
            result = self._values.get("audio_group_id")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def audio_only_image(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputLocationProperty"]]:
            '''Used with an audio-only stream.

            It must be a .jpg or .png file. If given, this image is used as the cover art for the audio-only output. Ideally, it should be formatted for an iPhone screen for two reasons. The iPhone does not resize the image; instead, it crops a centered image on the top/bottom and left/right. Additionally, this image file gets saved bit-for-bit into every 10-second segment file, so it increases bandwidth by {image file size} * {segment count} * {user count.}.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioonlyhlssettings.html#cfn-medialive-channel-audioonlyhlssettings-audioonlyimage
            '''
            result = self._values.get("audio_only_image")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputLocationProperty"]], result)

        @builtins.property
        def audio_track_type(self) -> typing.Optional[builtins.str]:
            '''Four types of audio-only tracks are supported: Audio-Only Variant Stream The client can play back this audio-only stream instead of video in low-bandwidth scenarios.

            Represented as an EXT-X-STREAM-INF in the HLS manifest. Alternate Audio, Auto Select, Default Alternate rendition that the client should try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES, AUTOSELECT=YES Alternate Audio, Auto Select, Not Default Alternate rendition that the client might try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YES Alternate Audio, not Auto Select Alternate rendition that the client will not try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=NO.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioonlyhlssettings.html#cfn-medialive-channel-audioonlyhlssettings-audiotracktype
            '''
            result = self._values.get("audio_track_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def segment_type(self) -> typing.Optional[builtins.str]:
            '''Specifies the segment type.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioonlyhlssettings.html#cfn-medialive-channel-audioonlyhlssettings-segmenttype
            '''
            result = self._values.get("segment_type")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AudioOnlyHlsSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.AudioPidSelectionProperty",
        jsii_struct_bases=[],
        name_mapping={"pid": "pid"},
    )
    class AudioPidSelectionProperty:
        def __init__(self, *, pid: typing.Optional[jsii.Number] = None) -> None:
            '''Used to extract audio by The PID.

            The parent of this entity is AudioSelectorSettings.

            :param pid: Select the audio by this PID.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiopidselection.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                audio_pid_selection_property = medialive.CfnChannel.AudioPidSelectionProperty(
                    pid=123
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if pid is not None:
                self._values["pid"] = pid

        @builtins.property
        def pid(self) -> typing.Optional[jsii.Number]:
            '''Select the audio by this PID.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiopidselection.html#cfn-medialive-channel-audiopidselection-pid
            '''
            result = self._values.get("pid")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AudioPidSelectionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.AudioSelectorProperty",
        jsii_struct_bases=[],
        name_mapping={"name": "name", "selector_settings": "selectorSettings"},
    )
    class AudioSelectorProperty:
        def __init__(
            self,
            *,
            name: typing.Optional[builtins.str] = None,
            selector_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioSelectorSettingsProperty"]] = None,
        ) -> None:
            '''Information about one audio to extract from the input.

            The parent of this entity is InputSettings.

            :param name: A name for this AudioSelector.
            :param selector_settings: Information about the specific audio to extract from the input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselector.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                audio_selector_property = medialive.CfnChannel.AudioSelectorProperty(
                    name="name",
                    selector_settings=medialive.CfnChannel.AudioSelectorSettingsProperty(
                        audio_hls_rendition_selection=medialive.CfnChannel.AudioHlsRenditionSelectionProperty(
                            group_id="groupId",
                            name="name"
                        ),
                        audio_language_selection=medialive.CfnChannel.AudioLanguageSelectionProperty(
                            language_code="languageCode",
                            language_selection_policy="languageSelectionPolicy"
                        ),
                        audio_pid_selection=medialive.CfnChannel.AudioPidSelectionProperty(
                            pid=123
                        ),
                        audio_track_selection=medialive.CfnChannel.AudioTrackSelectionProperty(
                            tracks=[medialive.CfnChannel.AudioTrackProperty(
                                track=123
                            )]
                        )
                    )
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if name is not None:
                self._values["name"] = name
            if selector_settings is not None:
                self._values["selector_settings"] = selector_settings

        @builtins.property
        def name(self) -> typing.Optional[builtins.str]:
            '''A name for this AudioSelector.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselector.html#cfn-medialive-channel-audioselector-name
            '''
            result = self._values.get("name")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def selector_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioSelectorSettingsProperty"]]:
            '''Information about the specific audio to extract from the input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselector.html#cfn-medialive-channel-audioselector-selectorsettings
            '''
            result = self._values.get("selector_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioSelectorSettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AudioSelectorProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.AudioSelectorSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "audio_hls_rendition_selection": "audioHlsRenditionSelection",
            "audio_language_selection": "audioLanguageSelection",
            "audio_pid_selection": "audioPidSelection",
            "audio_track_selection": "audioTrackSelection",
        },
    )
    class AudioSelectorSettingsProperty:
        def __init__(
            self,
            *,
            audio_hls_rendition_selection: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioHlsRenditionSelectionProperty"]] = None,
            audio_language_selection: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioLanguageSelectionProperty"]] = None,
            audio_pid_selection: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioPidSelectionProperty"]] = None,
            audio_track_selection: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioTrackSelectionProperty"]] = None,
        ) -> None:
            '''Information about the audio to extract from the input.

            The parent of this entity is AudioSelector.

            :param audio_hls_rendition_selection: Selector for HLS audio rendition.
            :param audio_language_selection: The language code of the audio to select.
            :param audio_pid_selection: The PID of the audio to select.
            :param audio_track_selection: Information about the audio track to extract.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselectorsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                audio_selector_settings_property = medialive.CfnChannel.AudioSelectorSettingsProperty(
                    audio_hls_rendition_selection=medialive.CfnChannel.AudioHlsRenditionSelectionProperty(
                        group_id="groupId",
                        name="name"
                    ),
                    audio_language_selection=medialive.CfnChannel.AudioLanguageSelectionProperty(
                        language_code="languageCode",
                        language_selection_policy="languageSelectionPolicy"
                    ),
                    audio_pid_selection=medialive.CfnChannel.AudioPidSelectionProperty(
                        pid=123
                    ),
                    audio_track_selection=medialive.CfnChannel.AudioTrackSelectionProperty(
                        tracks=[medialive.CfnChannel.AudioTrackProperty(
                            track=123
                        )]
                    )
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if audio_hls_rendition_selection is not None:
                self._values["audio_hls_rendition_selection"] = audio_hls_rendition_selection
            if audio_language_selection is not None:
                self._values["audio_language_selection"] = audio_language_selection
            if audio_pid_selection is not None:
                self._values["audio_pid_selection"] = audio_pid_selection
            if audio_track_selection is not None:
                self._values["audio_track_selection"] = audio_track_selection

        @builtins.property
        def audio_hls_rendition_selection(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioHlsRenditionSelectionProperty"]]:
            '''Selector for HLS audio rendition.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselectorsettings.html#cfn-medialive-channel-audioselectorsettings-audiohlsrenditionselection
            '''
            result = self._values.get("audio_hls_rendition_selection")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioHlsRenditionSelectionProperty"]], result)

        @builtins.property
        def audio_language_selection(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioLanguageSelectionProperty"]]:
            '''The language code of the audio to select.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselectorsettings.html#cfn-medialive-channel-audioselectorsettings-audiolanguageselection
            '''
            result = self._values.get("audio_language_selection")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioLanguageSelectionProperty"]], result)

        @builtins.property
        def audio_pid_selection(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioPidSelectionProperty"]]:
            '''The PID of the audio to select.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselectorsettings.html#cfn-medialive-channel-audioselectorsettings-audiopidselection
            '''
            result = self._values.get("audio_pid_selection")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioPidSelectionProperty"]], result)

        @builtins.property
        def audio_track_selection(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioTrackSelectionProperty"]]:
            '''Information about the audio track to extract.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselectorsettings.html#cfn-medialive-channel-audioselectorsettings-audiotrackselection
            '''
            result = self._values.get("audio_track_selection")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioTrackSelectionProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AudioSelectorSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.AudioSilenceFailoverSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "audio_selector_name": "audioSelectorName",
            "audio_silence_threshold_msec": "audioSilenceThresholdMsec",
        },
    )
    class AudioSilenceFailoverSettingsProperty:
        def __init__(
            self,
            *,
            audio_selector_name: typing.Optional[builtins.str] = None,
            audio_silence_threshold_msec: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''MediaLive will perform a failover if audio is not detected in this input for the specified period.

            The parent of this entity is FailoverConditionSettings.

            :param audio_selector_name: The name of the audio selector in the input that MediaLive should monitor to detect silence. Select your most important rendition. If you didn't create an audio selector in this input, leave blank.
            :param audio_silence_threshold_msec: The amount of time (in milliseconds) that the active input must be silent before automatic input failover occurs. Silence is defined as audio loss or audio quieter than -50 dBFS.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiosilencefailoversettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                audio_silence_failover_settings_property = medialive.CfnChannel.AudioSilenceFailoverSettingsProperty(
                    audio_selector_name="audioSelectorName",
                    audio_silence_threshold_msec=123
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if audio_selector_name is not None:
                self._values["audio_selector_name"] = audio_selector_name
            if audio_silence_threshold_msec is not None:
                self._values["audio_silence_threshold_msec"] = audio_silence_threshold_msec

        @builtins.property
        def audio_selector_name(self) -> typing.Optional[builtins.str]:
            '''The name of the audio selector in the input that MediaLive should monitor to detect silence.

            Select your most important rendition. If you didn't create an audio selector in this input, leave blank.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiosilencefailoversettings.html#cfn-medialive-channel-audiosilencefailoversettings-audioselectorname
            '''
            result = self._values.get("audio_selector_name")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def audio_silence_threshold_msec(self) -> typing.Optional[jsii.Number]:
            '''The amount of time (in milliseconds) that the active input must be silent before automatic input failover occurs.

            Silence is defined as audio loss or audio quieter than -50 dBFS.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiosilencefailoversettings.html#cfn-medialive-channel-audiosilencefailoversettings-audiosilencethresholdmsec
            '''
            result = self._values.get("audio_silence_threshold_msec")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AudioSilenceFailoverSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.AudioTrackProperty",
        jsii_struct_bases=[],
        name_mapping={"track": "track"},
    )
    class AudioTrackProperty:
        def __init__(self, *, track: typing.Optional[jsii.Number] = None) -> None:
            '''Information about one audio track to extract. You can select multiple tracks.

            The parent of this entity is AudioTrackSelection.

            :param track: 1-based integer value that maps to a specific audio track.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiotrack.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                audio_track_property = medialive.CfnChannel.AudioTrackProperty(
                    track=123
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if track is not None:
                self._values["track"] = track

        @builtins.property
        def track(self) -> typing.Optional[jsii.Number]:
            '''1-based integer value that maps to a specific audio track.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiotrack.html#cfn-medialive-channel-audiotrack-track
            '''
            result = self._values.get("track")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AudioTrackProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.AudioTrackSelectionProperty",
        jsii_struct_bases=[],
        name_mapping={"tracks": "tracks"},
    )
    class AudioTrackSelectionProperty:
        def __init__(
            self,
            *,
            tracks: typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.Sequence[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioTrackProperty"]]]] = None,
        ) -> None:
            '''Information about the audio track to extract.

            The parent of this entity is AudioSelectorSettings.

            :param tracks: Selects one or more unique audio tracks from within a source.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiotrackselection.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                audio_track_selection_property = medialive.CfnChannel.AudioTrackSelectionProperty(
                    tracks=[medialive.CfnChannel.AudioTrackProperty(
                        track=123
                    )]
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if tracks is not None:
                self._values["tracks"] = tracks

        @builtins.property
        def tracks(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioTrackProperty"]]]]:
            '''Selects one or more unique audio tracks from within a source.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiotrackselection.html#cfn-medialive-channel-audiotrackselection-tracks
            '''
            result = self._values.get("tracks")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioTrackProperty"]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AudioTrackSelectionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.AudioWatermarkSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"nielsen_watermarks_settings": "nielsenWatermarksSettings"},
    )
    class AudioWatermarkSettingsProperty:
        def __init__(
            self,
            *,
            nielsen_watermarks_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.NielsenWatermarksSettingsProperty"]] = None,
        ) -> None:
            '''Audio Watermark Settings.

            The parent of this entity is AudioDescription.

            :param nielsen_watermarks_settings: Settings to configure Nielsen Watermarks in the audio encode.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiowatermarksettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                audio_watermark_settings_property = medialive.CfnChannel.AudioWatermarkSettingsProperty(
                    nielsen_watermarks_settings=medialive.CfnChannel.NielsenWatermarksSettingsProperty(
                        nielsen_cbet_settings=medialive.CfnChannel.NielsenCBETProperty(
                            cbet_check_digit_string="cbetCheckDigitString",
                            cbet_stepaside="cbetStepaside",
                            csid="csid"
                        ),
                        nielsen_distribution_type="nielsenDistributionType",
                        nielsen_naes_ii_nw_settings=medialive.CfnChannel.NielsenNaesIiNwProperty(
                            check_digit_string="checkDigitString",
                            sid=123
                        )
                    )
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if nielsen_watermarks_settings is not None:
                self._values["nielsen_watermarks_settings"] = nielsen_watermarks_settings

        @builtins.property
        def nielsen_watermarks_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.NielsenWatermarksSettingsProperty"]]:
            '''Settings to configure Nielsen Watermarks in the audio encode.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiowatermarksettings.html#cfn-medialive-channel-audiowatermarksettings-nielsenwatermarkssettings
            '''
            result = self._values.get("nielsen_watermarks_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.NielsenWatermarksSettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AudioWatermarkSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.AutomaticInputFailoverSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "error_clear_time_msec": "errorClearTimeMsec",
            "failover_conditions": "failoverConditions",
            "input_preference": "inputPreference",
            "secondary_input_id": "secondaryInputId",
        },
    )
    class AutomaticInputFailoverSettingsProperty:
        def __init__(
            self,
            *,
            error_clear_time_msec: typing.Optional[jsii.Number] = None,
            failover_conditions: typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.Sequence[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.FailoverConditionProperty"]]]] = None,
            input_preference: typing.Optional[builtins.str] = None,
            secondary_input_id: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Settings to configure the conditions that will define the input as unhealthy and that will make MediaLive fail over to the other input in the input failover pair.

            The parent of this entity is InputAttachment.

            :param error_clear_time_msec: This clear time defines the requirement a recovered input must meet to be considered healthy. The input must have no failover conditions for this length of time. Enter a time in milliseconds. This value is particularly important if the input_preference for the failover pair is set to PRIMARY_INPUT_PREFERRED, because after this time, MediaLive will switch back to the primary input.
            :param failover_conditions: A list of failover conditions. If any of these conditions occur, MediaLive will perform a failover to the other input.
            :param input_preference: Input preference when deciding which input to make active when a previously failed input has recovered.
            :param secondary_input_id: The input ID of the secondary input in the automatic input failover pair.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-automaticinputfailoversettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                automatic_input_failover_settings_property = medialive.CfnChannel.AutomaticInputFailoverSettingsProperty(
                    error_clear_time_msec=123,
                    failover_conditions=[medialive.CfnChannel.FailoverConditionProperty(
                        failover_condition_settings=medialive.CfnChannel.FailoverConditionSettingsProperty(
                            audio_silence_settings=medialive.CfnChannel.AudioSilenceFailoverSettingsProperty(
                                audio_selector_name="audioSelectorName",
                                audio_silence_threshold_msec=123
                            ),
                            input_loss_settings=medialive.CfnChannel.InputLossFailoverSettingsProperty(
                                input_loss_threshold_msec=123
                            ),
                            video_black_settings=medialive.CfnChannel.VideoBlackFailoverSettingsProperty(
                                black_detect_threshold=123,
                                video_black_threshold_msec=123
                            )
                        )
                    )],
                    input_preference="inputPreference",
                    secondary_input_id="secondaryInputId"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if error_clear_time_msec is not None:
                self._values["error_clear_time_msec"] = error_clear_time_msec
            if failover_conditions is not None:
                self._values["failover_conditions"] = failover_conditions
            if input_preference is not None:
                self._values["input_preference"] = input_preference
            if secondary_input_id is not None:
                self._values["secondary_input_id"] = secondary_input_id

        @builtins.property
        def error_clear_time_msec(self) -> typing.Optional[jsii.Number]:
            '''This clear time defines the requirement a recovered input must meet to be considered healthy.

            The input must have no failover conditions for this length of time. Enter a time in milliseconds. This value is particularly important if the input_preference for the failover pair is set to PRIMARY_INPUT_PREFERRED, because after this time, MediaLive will switch back to the primary input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-automaticinputfailoversettings.html#cfn-medialive-channel-automaticinputfailoversettings-errorcleartimemsec
            '''
            result = self._values.get("error_clear_time_msec")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def failover_conditions(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.FailoverConditionProperty"]]]]:
            '''A list of failover conditions.

            If any of these conditions occur, MediaLive will perform a failover to the other input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-automaticinputfailoversettings.html#cfn-medialive-channel-automaticinputfailoversettings-failoverconditions
            '''
            result = self._values.get("failover_conditions")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.FailoverConditionProperty"]]]], result)

        @builtins.property
        def input_preference(self) -> typing.Optional[builtins.str]:
            '''Input preference when deciding which input to make active when a previously failed input has recovered.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-automaticinputfailoversettings.html#cfn-medialive-channel-automaticinputfailoversettings-inputpreference
            '''
            result = self._values.get("input_preference")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def secondary_input_id(self) -> typing.Optional[builtins.str]:
            '''The input ID of the secondary input in the automatic input failover pair.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-automaticinputfailoversettings.html#cfn-medialive-channel-automaticinputfailoversettings-secondaryinputid
            '''
            result = self._values.get("secondary_input_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AutomaticInputFailoverSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.AvailBlankingProperty",
        jsii_struct_bases=[],
        name_mapping={"avail_blanking_image": "availBlankingImage", "state": "state"},
    )
    class AvailBlankingProperty:
        def __init__(
            self,
            *,
            avail_blanking_image: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputLocationProperty"]] = None,
            state: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The configuration of ad avail blanking in the output.

            The parent of this entity is EncoderSettings.

            :param avail_blanking_image: The blanking image to be used. Keep empty for solid black. Only .bmp and .png images are supported.
            :param state: When set to enabled, the video, audio, and captions are blanked when insertion metadata is added.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availblanking.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                avail_blanking_property = medialive.CfnChannel.AvailBlankingProperty(
                    avail_blanking_image=medialive.CfnChannel.InputLocationProperty(
                        password_param="passwordParam",
                        uri="uri",
                        username="username"
                    ),
                    state="state"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if avail_blanking_image is not None:
                self._values["avail_blanking_image"] = avail_blanking_image
            if state is not None:
                self._values["state"] = state

        @builtins.property
        def avail_blanking_image(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputLocationProperty"]]:
            '''The blanking image to be used.

            Keep empty for solid black. Only .bmp and .png images are supported.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availblanking.html#cfn-medialive-channel-availblanking-availblankingimage
            '''
            result = self._values.get("avail_blanking_image")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputLocationProperty"]], result)

        @builtins.property
        def state(self) -> typing.Optional[builtins.str]:
            '''When set to enabled, the video, audio, and captions are blanked when insertion metadata is added.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availblanking.html#cfn-medialive-channel-availblanking-state
            '''
            result = self._values.get("state")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AvailBlankingProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.AvailConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={"avail_settings": "availSettings"},
    )
    class AvailConfigurationProperty:
        def __init__(
            self,
            *,
            avail_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AvailSettingsProperty"]] = None,
        ) -> None:
            '''The setup of ad avail handling in the output.

            The parent of this entity is EncoderSettings.

            :param avail_settings: The setup of ad avail handling in the output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                avail_configuration_property = medialive.CfnChannel.AvailConfigurationProperty(
                    avail_settings=medialive.CfnChannel.AvailSettingsProperty(
                        scte35_splice_insert=medialive.CfnChannel.Scte35SpliceInsertProperty(
                            ad_avail_offset=123,
                            no_regional_blackout_flag="noRegionalBlackoutFlag",
                            web_delivery_allowed_flag="webDeliveryAllowedFlag"
                        ),
                        scte35_time_signal_apos=medialive.CfnChannel.Scte35TimeSignalAposProperty(
                            ad_avail_offset=123,
                            no_regional_blackout_flag="noRegionalBlackoutFlag",
                            web_delivery_allowed_flag="webDeliveryAllowedFlag"
                        )
                    )
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if avail_settings is not None:
                self._values["avail_settings"] = avail_settings

        @builtins.property
        def avail_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AvailSettingsProperty"]]:
            '''The setup of ad avail handling in the output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availconfiguration.html#cfn-medialive-channel-availconfiguration-availsettings
            '''
            result = self._values.get("avail_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AvailSettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AvailConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.AvailSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "scte35_splice_insert": "scte35SpliceInsert",
            "scte35_time_signal_apos": "scte35TimeSignalApos",
        },
    )
    class AvailSettingsProperty:
        def __init__(
            self,
            *,
            scte35_splice_insert: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Scte35SpliceInsertProperty"]] = None,
            scte35_time_signal_apos: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Scte35TimeSignalAposProperty"]] = None,
        ) -> None:
            '''The settings for the ad avail setup in the output.

            The parent of this entity is AvailConfiguration.

            :param scte35_splice_insert: The setup for SCTE-35 splice insert handling.
            :param scte35_time_signal_apos: The setup for SCTE-35 time signal APOS handling.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                avail_settings_property = medialive.CfnChannel.AvailSettingsProperty(
                    scte35_splice_insert=medialive.CfnChannel.Scte35SpliceInsertProperty(
                        ad_avail_offset=123,
                        no_regional_blackout_flag="noRegionalBlackoutFlag",
                        web_delivery_allowed_flag="webDeliveryAllowedFlag"
                    ),
                    scte35_time_signal_apos=medialive.CfnChannel.Scte35TimeSignalAposProperty(
                        ad_avail_offset=123,
                        no_regional_blackout_flag="noRegionalBlackoutFlag",
                        web_delivery_allowed_flag="webDeliveryAllowedFlag"
                    )
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if scte35_splice_insert is not None:
                self._values["scte35_splice_insert"] = scte35_splice_insert
            if scte35_time_signal_apos is not None:
                self._values["scte35_time_signal_apos"] = scte35_time_signal_apos

        @builtins.property
        def scte35_splice_insert(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Scte35SpliceInsertProperty"]]:
            '''The setup for SCTE-35 splice insert handling.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availsettings.html#cfn-medialive-channel-availsettings-scte35spliceinsert
            '''
            result = self._values.get("scte35_splice_insert")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Scte35SpliceInsertProperty"]], result)

        @builtins.property
        def scte35_time_signal_apos(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Scte35TimeSignalAposProperty"]]:
            '''The setup for SCTE-35 time signal APOS handling.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availsettings.html#cfn-medialive-channel-availsettings-scte35timesignalapos
            '''
            result = self._values.get("scte35_time_signal_apos")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Scte35TimeSignalAposProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "AvailSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.BlackoutSlateProperty",
        jsii_struct_bases=[],
        name_mapping={
            "blackout_slate_image": "blackoutSlateImage",
            "network_end_blackout": "networkEndBlackout",
            "network_end_blackout_image": "networkEndBlackoutImage",
            "network_id": "networkId",
            "state": "state",
        },
    )
    class BlackoutSlateProperty:
        def __init__(
            self,
            *,
            blackout_slate_image: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputLocationProperty"]] = None,
            network_end_blackout: typing.Optional[builtins.str] = None,
            network_end_blackout_image: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputLocationProperty"]] = None,
            network_id: typing.Optional[builtins.str] = None,
            state: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The settings for a blackout slate.

            The parent of this entity is EncoderSettings.

            :param blackout_slate_image: The blackout slate image to be used. Keep empty for solid black. Only .bmp and .png images are supported.
            :param network_end_blackout: Setting to enabled causes MediaLive to blackout the video, audio, and captions, and raise the "Network Blackout Image" slate when an SCTE104/35 Network End Segmentation Descriptor is encountered. The blackout is lifted when the Network Start Segmentation Descriptor is encountered. The Network End and Network Start descriptors must contain a network ID that matches the value entered in Network ID.
            :param network_end_blackout_image: The path to the local file to use as the Network End Blackout image. The image is scaled to fill the entire output raster.
            :param network_id: Provides a Network ID that matches EIDR ID format (for example, "10.XXXX/XXXX-XXXX-XXXX-XXXX-XXXX-C").
            :param state: When set to enabled, this causes video, audio, and captions to be blanked when indicated by program metadata.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                blackout_slate_property = medialive.CfnChannel.BlackoutSlateProperty(
                    blackout_slate_image=medialive.CfnChannel.InputLocationProperty(
                        password_param="passwordParam",
                        uri="uri",
                        username="username"
                    ),
                    network_end_blackout="networkEndBlackout",
                    network_end_blackout_image=medialive.CfnChannel.InputLocationProperty(
                        password_param="passwordParam",
                        uri="uri",
                        username="username"
                    ),
                    network_id="networkId",
                    state="state"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if blackout_slate_image is not None:
                self._values["blackout_slate_image"] = blackout_slate_image
            if network_end_blackout is not None:
                self._values["network_end_blackout"] = network_end_blackout
            if network_end_blackout_image is not None:
                self._values["network_end_blackout_image"] = network_end_blackout_image
            if network_id is not None:
                self._values["network_id"] = network_id
            if state is not None:
                self._values["state"] = state

        @builtins.property
        def blackout_slate_image(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputLocationProperty"]]:
            '''The blackout slate image to be used.

            Keep empty for solid black. Only .bmp and .png images are supported.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html#cfn-medialive-channel-blackoutslate-blackoutslateimage
            '''
            result = self._values.get("blackout_slate_image")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputLocationProperty"]], result)

        @builtins.property
        def network_end_blackout(self) -> typing.Optional[builtins.str]:
            '''Setting to enabled causes MediaLive to blackout the video, audio, and captions, and raise the "Network Blackout Image" slate when an SCTE104/35 Network End Segmentation Descriptor is encountered.

            The blackout is lifted when the Network Start Segmentation Descriptor is encountered. The Network End and Network Start descriptors must contain a network ID that matches the value entered in Network ID.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html#cfn-medialive-channel-blackoutslate-networkendblackout
            '''
            result = self._values.get("network_end_blackout")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def network_end_blackout_image(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputLocationProperty"]]:
            '''The path to the local file to use as the Network End Blackout image.

            The image is scaled to fill the entire output raster.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html#cfn-medialive-channel-blackoutslate-networkendblackoutimage
            '''
            result = self._values.get("network_end_blackout_image")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputLocationProperty"]], result)

        @builtins.property
        def network_id(self) -> typing.Optional[builtins.str]:
            '''Provides a Network ID that matches EIDR ID format (for example, "10.XXXX/XXXX-XXXX-XXXX-XXXX-XXXX-C").

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html#cfn-medialive-channel-blackoutslate-networkid
            '''
            result = self._values.get("network_id")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def state(self) -> typing.Optional[builtins.str]:
            '''When set to enabled, this causes video, audio, and captions to be blanked when indicated by program metadata.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html#cfn-medialive-channel-blackoutslate-state
            '''
            result = self._values.get("state")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BlackoutSlateProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.BurnInDestinationSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "alignment": "alignment",
            "background_color": "backgroundColor",
            "background_opacity": "backgroundOpacity",
            "font": "font",
            "font_color": "fontColor",
            "font_opacity": "fontOpacity",
            "font_resolution": "fontResolution",
            "font_size": "fontSize",
            "outline_color": "outlineColor",
            "outline_size": "outlineSize",
            "shadow_color": "shadowColor",
            "shadow_opacity": "shadowOpacity",
            "shadow_x_offset": "shadowXOffset",
            "shadow_y_offset": "shadowYOffset",
            "teletext_grid_control": "teletextGridControl",
            "x_position": "xPosition",
            "y_position": "yPosition",
        },
    )
    class BurnInDestinationSettingsProperty:
        def __init__(
            self,
            *,
            alignment: typing.Optional[builtins.str] = None,
            background_color: typing.Optional[builtins.str] = None,
            background_opacity: typing.Optional[jsii.Number] = None,
            font: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputLocationProperty"]] = None,
            font_color: typing.Optional[builtins.str] = None,
            font_opacity: typing.Optional[jsii.Number] = None,
            font_resolution: typing.Optional[jsii.Number] = None,
            font_size: typing.Optional[builtins.str] = None,
            outline_color: typing.Optional[builtins.str] = None,
            outline_size: typing.Optional[jsii.Number] = None,
            shadow_color: typing.Optional[builtins.str] = None,
            shadow_opacity: typing.Optional[jsii.Number] = None,
            shadow_x_offset: typing.Optional[jsii.Number] = None,
            shadow_y_offset: typing.Optional[jsii.Number] = None,
            teletext_grid_control: typing.Optional[builtins.str] = None,
            x_position: typing.Optional[jsii.Number] = None,
            y_position: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''The settings for burn-in captions in the output.

            The parent of this entity is CaptionDestinationSettings.

            :param alignment: If no explicit xPosition or yPosition is provided, setting alignment to centered places the captions at the bottom center of the output. Similarly, setting a left alignment aligns captions to the bottom left of the output. If x and y positions are specified in conjunction with the alignment parameter, the font is justified (either left or centered) relative to those coordinates. Selecting "smart" justification left-justifies live subtitles and center-justifies pre-recorded subtitles. All burn-in and DVB-Sub font settings must match.
            :param background_color: Specifies the color of the rectangle behind the captions. All burn-in and DVB-Sub font settings must match.
            :param background_opacity: Specifies the opacity of the background rectangle. 255 is opaque; 0 is transparent. Keeping this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
            :param font: The external font file that is used for captions burn-in. The file extension must be .ttf or .tte. Although you can select output fonts for many different types of input captions, embedded, STL, and Teletext sources use a strict grid system. Using external fonts with these captions sources could cause an unexpected display of proportional fonts. All burn-in and DVB-Sub font settings must match.
            :param font_color: Specifies the color of the burned-in captions. This option is not valid for source captions that are STL, 608/embedded, or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
            :param font_opacity: Specifies the opacity of the burned-in captions. 255 is opaque; 0 is transparent. All burn-in and DVB-Sub font settings must match.
            :param font_resolution: The font resolution in DPI (dots per inch). The default is 96 dpi. All burn-in and DVB-Sub font settings must match.
            :param font_size: When set to auto, fontSize scales depending on the size of the output. Providing a positive integer specifies the exact font size in points. All burn-in and DVB-Sub font settings must match.
            :param outline_color: Specifies the font outline color. This option is not valid for source captions that are either 608/embedded or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
            :param outline_size: Specifies font outline size in pixels. This option is not valid for source captions that are either 608/embedded or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
            :param shadow_color: Specifies the color of the shadow cast by the captions. All burn-in and DVB-Sub font settings must match.
            :param shadow_opacity: Specifies the opacity of the shadow. 255 is opaque; 0 is transparent. Keeping this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
            :param shadow_x_offset: Specifies the horizontal offset of the shadow that is relative to the captions in pixels. A value of -2 would result in a shadow offset 2 pixels to the left. All burn-in and DVB-Sub font settings must match.
            :param shadow_y_offset: Specifies the vertical offset of the shadow that is relative to the captions in pixels. A value of -2 would result in a shadow offset 2 pixels above the text. All burn-in and DVB-Sub font settings must match.
            :param teletext_grid_control: Controls whether a fixed grid size is used to generate the output subtitles bitmap. This applies only to Teletext inputs and DVB-Sub/Burn-in outputs.
            :param x_position: Specifies the horizontal position of the captions relative to the left side of the output in pixels. A value of 10 would result in the captions starting 10 pixels from the left of the output. If no explicit xPosition is provided, the horizontal captions position is determined by the alignment parameter. All burn-in and DVB-Sub font settings must match.
            :param y_position: Specifies the vertical position of the captions relative to the top of the output in pixels. A value of 10 would result in the captions starting 10 pixels from the top of the output. If no explicit yPosition is provided, the captions are positioned towards the bottom of the output. All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                burn_in_destination_settings_property = medialive.CfnChannel.BurnInDestinationSettingsProperty(
                    alignment="alignment",
                    background_color="backgroundColor",
                    background_opacity=123,
                    font=medialive.CfnChannel.InputLocationProperty(
                        password_param="passwordParam",
                        uri="uri",
                        username="username"
                    ),
                    font_color="fontColor",
                    font_opacity=123,
                    font_resolution=123,
                    font_size="fontSize",
                    outline_color="outlineColor",
                    outline_size=123,
                    shadow_color="shadowColor",
                    shadow_opacity=123,
                    shadow_xOffset=123,
                    shadow_yOffset=123,
                    teletext_grid_control="teletextGridControl",
                    x_position=123,
                    y_position=123
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if alignment is not None:
                self._values["alignment"] = alignment
            if background_color is not None:
                self._values["background_color"] = background_color
            if background_opacity is not None:
                self._values["background_opacity"] = background_opacity
            if font is not None:
                self._values["font"] = font
            if font_color is not None:
                self._values["font_color"] = font_color
            if font_opacity is not None:
                self._values["font_opacity"] = font_opacity
            if font_resolution is not None:
                self._values["font_resolution"] = font_resolution
            if font_size is not None:
                self._values["font_size"] = font_size
            if outline_color is not None:
                self._values["outline_color"] = outline_color
            if outline_size is not None:
                self._values["outline_size"] = outline_size
            if shadow_color is not None:
                self._values["shadow_color"] = shadow_color
            if shadow_opacity is not None:
                self._values["shadow_opacity"] = shadow_opacity
            if shadow_x_offset is not None:
                self._values["shadow_x_offset"] = shadow_x_offset
            if shadow_y_offset is not None:
                self._values["shadow_y_offset"] = shadow_y_offset
            if teletext_grid_control is not None:
                self._values["teletext_grid_control"] = teletext_grid_control
            if x_position is not None:
                self._values["x_position"] = x_position
            if y_position is not None:
                self._values["y_position"] = y_position

        @builtins.property
        def alignment(self) -> typing.Optional[builtins.str]:
            '''If no explicit xPosition or yPosition is provided, setting alignment to centered places the captions at the bottom center of the output.

            Similarly, setting a left alignment aligns captions to the bottom left of the output. If x and y positions are specified in conjunction with the alignment parameter, the font is justified (either left or centered) relative to those coordinates. Selecting "smart" justification left-justifies live subtitles and center-justifies pre-recorded subtitles. All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-alignment
            '''
            result = self._values.get("alignment")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def background_color(self) -> typing.Optional[builtins.str]:
            '''Specifies the color of the rectangle behind the captions.

            All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-backgroundcolor
            '''
            result = self._values.get("background_color")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def background_opacity(self) -> typing.Optional[jsii.Number]:
            '''Specifies the opacity of the background rectangle.

            255 is opaque; 0 is transparent. Keeping this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-backgroundopacity
            '''
            result = self._values.get("background_opacity")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def font(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputLocationProperty"]]:
            '''The external font file that is used for captions burn-in.

            The file extension must be .ttf or .tte. Although you can select output fonts for many different types of input captions, embedded, STL, and Teletext sources use a strict grid system. Using external fonts with these captions sources could cause an unexpected display of proportional fonts. All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-font
            '''
            result = self._values.get("font")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputLocationProperty"]], result)

        @builtins.property
        def font_color(self) -> typing.Optional[builtins.str]:
            '''Specifies the color of the burned-in captions.

            This option is not valid for source captions that are STL, 608/embedded, or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-fontcolor
            '''
            result = self._values.get("font_color")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def font_opacity(self) -> typing.Optional[jsii.Number]:
            '''Specifies the opacity of the burned-in captions.

            255 is opaque; 0 is transparent. All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-fontopacity
            '''
            result = self._values.get("font_opacity")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def font_resolution(self) -> typing.Optional[jsii.Number]:
            '''The font resolution in DPI (dots per inch).

            The default is 96 dpi. All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-fontresolution
            '''
            result = self._values.get("font_resolution")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def font_size(self) -> typing.Optional[builtins.str]:
            '''When set to auto, fontSize scales depending on the size of the output.

            Providing a positive integer specifies the exact font size in points. All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-fontsize
            '''
            result = self._values.get("font_size")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def outline_color(self) -> typing.Optional[builtins.str]:
            '''Specifies the font outline color.

            This option is not valid for source captions that are either 608/embedded or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-outlinecolor
            '''
            result = self._values.get("outline_color")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def outline_size(self) -> typing.Optional[jsii.Number]:
            '''Specifies font outline size in pixels.

            This option is not valid for source captions that are either 608/embedded or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-outlinesize
            '''
            result = self._values.get("outline_size")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def shadow_color(self) -> typing.Optional[builtins.str]:
            '''Specifies the color of the shadow cast by the captions.

            All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-shadowcolor
            '''
            result = self._values.get("shadow_color")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def shadow_opacity(self) -> typing.Optional[jsii.Number]:
            '''Specifies the opacity of the shadow.

            255 is opaque; 0 is transparent. Keeping this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-shadowopacity
            '''
            result = self._values.get("shadow_opacity")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def shadow_x_offset(self) -> typing.Optional[jsii.Number]:
            '''Specifies the horizontal offset of the shadow that is relative to the captions in pixels.

            A value of -2 would result in a shadow offset 2 pixels to the left. All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-shadowxoffset
            '''
            result = self._values.get("shadow_x_offset")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def shadow_y_offset(self) -> typing.Optional[jsii.Number]:
            '''Specifies the vertical offset of the shadow that is relative to the captions in pixels.

            A value of -2 would result in a shadow offset 2 pixels above the text. All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-shadowyoffset
            '''
            result = self._values.get("shadow_y_offset")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def teletext_grid_control(self) -> typing.Optional[builtins.str]:
            '''Controls whether a fixed grid size is used to generate the output subtitles bitmap.

            This applies only to Teletext inputs and DVB-Sub/Burn-in outputs.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-teletextgridcontrol
            '''
            result = self._values.get("teletext_grid_control")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def x_position(self) -> typing.Optional[jsii.Number]:
            '''Specifies the horizontal position of the captions relative to the left side of the output in pixels.

            A value of 10 would result in the captions starting 10 pixels from the left of the output. If no explicit xPosition is provided, the horizontal captions position is determined by the alignment parameter. All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-xposition
            '''
            result = self._values.get("x_position")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def y_position(self) -> typing.Optional[jsii.Number]:
            '''Specifies the vertical position of the captions relative to the top of the output in pixels.

            A value of 10 would result in the captions starting 10 pixels from the top of the output. If no explicit yPosition is provided, the captions are positioned towards the bottom of the output. All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-yposition
            '''
            result = self._values.get("y_position")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "BurnInDestinationSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.CaptionDescriptionProperty",
        jsii_struct_bases=[],
        name_mapping={
            "caption_selector_name": "captionSelectorName",
            "destination_settings": "destinationSettings",
            "language_code": "languageCode",
            "language_description": "languageDescription",
            "name": "name",
        },
    )
    class CaptionDescriptionProperty:
        def __init__(
            self,
            *,
            caption_selector_name: typing.Optional[builtins.str] = None,
            destination_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.CaptionDestinationSettingsProperty"]] = None,
            language_code: typing.Optional[builtins.str] = None,
            language_description: typing.Optional[builtins.str] = None,
            name: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The encoding information for output captions.

            The parent of this entity is EncoderSettings.

            :param caption_selector_name: Specifies which input captions selector to use as a captions source when generating output captions. This field should match a captionSelector name.
            :param destination_settings: Additional settings for a captions destination that depend on the destination type.
            :param language_code: An ISO 639-2 three-digit code. For more information, see http://www.loc.gov/standards/iso639-2/.
            :param language_description: Human-readable information to indicate the captions that are available for players (for example, English or Spanish).
            :param name: The name of the captions description. The name is used to associate a captions description with an output. Names must be unique within a channel.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                caption_description_property = medialive.CfnChannel.CaptionDescriptionProperty(
                    caption_selector_name="captionSelectorName",
                    destination_settings=medialive.CfnChannel.CaptionDestinationSettingsProperty(
                        arib_destination_settings=medialive.CfnChannel.AribDestinationSettingsProperty(),
                        burn_in_destination_settings=medialive.CfnChannel.BurnInDestinationSettingsProperty(
                            alignment="alignment",
                            background_color="backgroundColor",
                            background_opacity=123,
                            font=medialive.CfnChannel.InputLocationProperty(
                                password_param="passwordParam",
                                uri="uri",
                                username="username"
                            ),
                            font_color="fontColor",
                            font_opacity=123,
                            font_resolution=123,
                            font_size="fontSize",
                            outline_color="outlineColor",
                            outline_size=123,
                            shadow_color="shadowColor",
                            shadow_opacity=123,
                            shadow_xOffset=123,
                            shadow_yOffset=123,
                            teletext_grid_control="teletextGridControl",
                            x_position=123,
                            y_position=123
                        ),
                        dvb_sub_destination_settings=medialive.CfnChannel.DvbSubDestinationSettingsProperty(
                            alignment="alignment",
                            background_color="backgroundColor",
                            background_opacity=123,
                            font=medialive.CfnChannel.InputLocationProperty(
                                password_param="passwordParam",
                                uri="uri",
                                username="username"
                            ),
                            font_color="fontColor",
                            font_opacity=123,
                            font_resolution=123,
                            font_size="fontSize",
                            outline_color="outlineColor",
                            outline_size=123,
                            shadow_color="shadowColor",
                            shadow_opacity=123,
                            shadow_xOffset=123,
                            shadow_yOffset=123,
                            teletext_grid_control="teletextGridControl",
                            x_position=123,
                            y_position=123
                        ),
                        ebu_tt_dDestination_settings=medialive.CfnChannel.EbuTtDDestinationSettingsProperty(
                            copyright_holder="copyrightHolder",
                            fill_line_gap="fillLineGap",
                            font_family="fontFamily",
                            style_control="styleControl"
                        ),
                        embedded_destination_settings=medialive.CfnChannel.EmbeddedDestinationSettingsProperty(),
                        embedded_plus_scte20_destination_settings=medialive.CfnChannel.EmbeddedPlusScte20DestinationSettingsProperty(),
                        rtmp_caption_info_destination_settings=medialive.CfnChannel.RtmpCaptionInfoDestinationSettingsProperty(),
                        scte20_plus_embedded_destination_settings=medialive.CfnChannel.Scte20PlusEmbeddedDestinationSettingsProperty(),
                        scte27_destination_settings=medialive.CfnChannel.Scte27DestinationSettingsProperty(),
                        smpte_tt_destination_settings=medialive.CfnChannel.SmpteTtDestinationSettingsProperty(),
                        teletext_destination_settings=medialive.CfnChannel.TeletextDestinationSettingsProperty(),
                        ttml_destination_settings=medialive.CfnChannel.TtmlDestinationSettingsProperty(
                            style_control="styleControl"
                        ),
                        webvtt_destination_settings=medialive.CfnChannel.WebvttDestinationSettingsProperty(
                            style_control="styleControl"
                        )
                    ),
                    language_code="languageCode",
                    language_description="languageDescription",
                    name="name"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if caption_selector_name is not None:
                self._values["caption_selector_name"] = caption_selector_name
            if destination_settings is not None:
                self._values["destination_settings"] = destination_settings
            if language_code is not None:
                self._values["language_code"] = language_code
            if language_description is not None:
                self._values["language_description"] = language_description
            if name is not None:
                self._values["name"] = name

        @builtins.property
        def caption_selector_name(self) -> typing.Optional[builtins.str]:
            '''Specifies which input captions selector to use as a captions source when generating output captions.

            This field should match a captionSelector name.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-captionselectorname
            '''
            result = self._values.get("caption_selector_name")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def destination_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.CaptionDestinationSettingsProperty"]]:
            '''Additional settings for a captions destination that depend on the destination type.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-destinationsettings
            '''
            result = self._values.get("destination_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.CaptionDestinationSettingsProperty"]], result)

        @builtins.property
        def language_code(self) -> typing.Optional[builtins.str]:
            '''An ISO 639-2 three-digit code.

            For more information, see http://www.loc.gov/standards/iso639-2/.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-languagecode
            '''
            result = self._values.get("language_code")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def language_description(self) -> typing.Optional[builtins.str]:
            '''Human-readable information to indicate the captions that are available for players (for example, English or Spanish).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-languagedescription
            '''
            result = self._values.get("language_description")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def name(self) -> typing.Optional[builtins.str]:
            '''The name of the captions description.

            The name is used to associate a captions description with an output. Names must be unique within a channel.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-name
            '''
            result = self._values.get("name")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CaptionDescriptionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.CaptionDestinationSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "arib_destination_settings": "aribDestinationSettings",
            "burn_in_destination_settings": "burnInDestinationSettings",
            "dvb_sub_destination_settings": "dvbSubDestinationSettings",
            "ebu_tt_d_destination_settings": "ebuTtDDestinationSettings",
            "embedded_destination_settings": "embeddedDestinationSettings",
            "embedded_plus_scte20_destination_settings": "embeddedPlusScte20DestinationSettings",
            "rtmp_caption_info_destination_settings": "rtmpCaptionInfoDestinationSettings",
            "scte20_plus_embedded_destination_settings": "scte20PlusEmbeddedDestinationSettings",
            "scte27_destination_settings": "scte27DestinationSettings",
            "smpte_tt_destination_settings": "smpteTtDestinationSettings",
            "teletext_destination_settings": "teletextDestinationSettings",
            "ttml_destination_settings": "ttmlDestinationSettings",
            "webvtt_destination_settings": "webvttDestinationSettings",
        },
    )
    class CaptionDestinationSettingsProperty:
        def __init__(
            self,
            *,
            arib_destination_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AribDestinationSettingsProperty"]] = None,
            burn_in_destination_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.BurnInDestinationSettingsProperty"]] = None,
            dvb_sub_destination_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.DvbSubDestinationSettingsProperty"]] = None,
            ebu_tt_d_destination_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.EbuTtDDestinationSettingsProperty"]] = None,
            embedded_destination_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.EmbeddedDestinationSettingsProperty"]] = None,
            embedded_plus_scte20_destination_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.EmbeddedPlusScte20DestinationSettingsProperty"]] = None,
            rtmp_caption_info_destination_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.RtmpCaptionInfoDestinationSettingsProperty"]] = None,
            scte20_plus_embedded_destination_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Scte20PlusEmbeddedDestinationSettingsProperty"]] = None,
            scte27_destination_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Scte27DestinationSettingsProperty"]] = None,
            smpte_tt_destination_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.SmpteTtDestinationSettingsProperty"]] = None,
            teletext_destination_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.TeletextDestinationSettingsProperty"]] = None,
            ttml_destination_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.TtmlDestinationSettingsProperty"]] = None,
            webvtt_destination_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.WebvttDestinationSettingsProperty"]] = None,
        ) -> None:
            '''The configuration of one captions encode in the output.

            The parent of this entity is CaptionDescription.

            :param arib_destination_settings: The configuration of one ARIB captions encode in the output.
            :param burn_in_destination_settings: The configuration of one burn-in captions encode in the output.
            :param dvb_sub_destination_settings: The configuration of one DVB Sub captions encode in the output.
            :param ebu_tt_d_destination_settings: Settings for EBU-TT captions in the output.
            :param embedded_destination_settings: The configuration of one embedded captions encode in the output.
            :param embedded_plus_scte20_destination_settings: The configuration of one embedded plus SCTE-20 captions encode in the output.
            :param rtmp_caption_info_destination_settings: The configuration of one RTMPCaptionInfo captions encode in the output.
            :param scte20_plus_embedded_destination_settings: The configuration of one SCTE20 plus embedded captions encode in the output.
            :param scte27_destination_settings: The configuration of one SCTE-27 captions encode in the output.
            :param smpte_tt_destination_settings: The configuration of one SMPTE-TT captions encode in the output.
            :param teletext_destination_settings: The configuration of one Teletext captions encode in the output.
            :param ttml_destination_settings: The configuration of one TTML captions encode in the output.
            :param webvtt_destination_settings: The configuration of one WebVTT captions encode in the output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                caption_destination_settings_property = medialive.CfnChannel.CaptionDestinationSettingsProperty(
                    arib_destination_settings=medialive.CfnChannel.AribDestinationSettingsProperty(),
                    burn_in_destination_settings=medialive.CfnChannel.BurnInDestinationSettingsProperty(
                        alignment="alignment",
                        background_color="backgroundColor",
                        background_opacity=123,
                        font=medialive.CfnChannel.InputLocationProperty(
                            password_param="passwordParam",
                            uri="uri",
                            username="username"
                        ),
                        font_color="fontColor",
                        font_opacity=123,
                        font_resolution=123,
                        font_size="fontSize",
                        outline_color="outlineColor",
                        outline_size=123,
                        shadow_color="shadowColor",
                        shadow_opacity=123,
                        shadow_xOffset=123,
                        shadow_yOffset=123,
                        teletext_grid_control="teletextGridControl",
                        x_position=123,
                        y_position=123
                    ),
                    dvb_sub_destination_settings=medialive.CfnChannel.DvbSubDestinationSettingsProperty(
                        alignment="alignment",
                        background_color="backgroundColor",
                        background_opacity=123,
                        font=medialive.CfnChannel.InputLocationProperty(
                            password_param="passwordParam",
                            uri="uri",
                            username="username"
                        ),
                        font_color="fontColor",
                        font_opacity=123,
                        font_resolution=123,
                        font_size="fontSize",
                        outline_color="outlineColor",
                        outline_size=123,
                        shadow_color="shadowColor",
                        shadow_opacity=123,
                        shadow_xOffset=123,
                        shadow_yOffset=123,
                        teletext_grid_control="teletextGridControl",
                        x_position=123,
                        y_position=123
                    ),
                    ebu_tt_dDestination_settings=medialive.CfnChannel.EbuTtDDestinationSettingsProperty(
                        copyright_holder="copyrightHolder",
                        fill_line_gap="fillLineGap",
                        font_family="fontFamily",
                        style_control="styleControl"
                    ),
                    embedded_destination_settings=medialive.CfnChannel.EmbeddedDestinationSettingsProperty(),
                    embedded_plus_scte20_destination_settings=medialive.CfnChannel.EmbeddedPlusScte20DestinationSettingsProperty(),
                    rtmp_caption_info_destination_settings=medialive.CfnChannel.RtmpCaptionInfoDestinationSettingsProperty(),
                    scte20_plus_embedded_destination_settings=medialive.CfnChannel.Scte20PlusEmbeddedDestinationSettingsProperty(),
                    scte27_destination_settings=medialive.CfnChannel.Scte27DestinationSettingsProperty(),
                    smpte_tt_destination_settings=medialive.CfnChannel.SmpteTtDestinationSettingsProperty(),
                    teletext_destination_settings=medialive.CfnChannel.TeletextDestinationSettingsProperty(),
                    ttml_destination_settings=medialive.CfnChannel.TtmlDestinationSettingsProperty(
                        style_control="styleControl"
                    ),
                    webvtt_destination_settings=medialive.CfnChannel.WebvttDestinationSettingsProperty(
                        style_control="styleControl"
                    )
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if arib_destination_settings is not None:
                self._values["arib_destination_settings"] = arib_destination_settings
            if burn_in_destination_settings is not None:
                self._values["burn_in_destination_settings"] = burn_in_destination_settings
            if dvb_sub_destination_settings is not None:
                self._values["dvb_sub_destination_settings"] = dvb_sub_destination_settings
            if ebu_tt_d_destination_settings is not None:
                self._values["ebu_tt_d_destination_settings"] = ebu_tt_d_destination_settings
            if embedded_destination_settings is not None:
                self._values["embedded_destination_settings"] = embedded_destination_settings
            if embedded_plus_scte20_destination_settings is not None:
                self._values["embedded_plus_scte20_destination_settings"] = embedded_plus_scte20_destination_settings
            if rtmp_caption_info_destination_settings is not None:
                self._values["rtmp_caption_info_destination_settings"] = rtmp_caption_info_destination_settings
            if scte20_plus_embedded_destination_settings is not None:
                self._values["scte20_plus_embedded_destination_settings"] = scte20_plus_embedded_destination_settings
            if scte27_destination_settings is not None:
                self._values["scte27_destination_settings"] = scte27_destination_settings
            if smpte_tt_destination_settings is not None:
                self._values["smpte_tt_destination_settings"] = smpte_tt_destination_settings
            if teletext_destination_settings is not None:
                self._values["teletext_destination_settings"] = teletext_destination_settings
            if ttml_destination_settings is not None:
                self._values["ttml_destination_settings"] = ttml_destination_settings
            if webvtt_destination_settings is not None:
                self._values["webvtt_destination_settings"] = webvtt_destination_settings

        @builtins.property
        def arib_destination_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AribDestinationSettingsProperty"]]:
            '''The configuration of one ARIB captions encode in the output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-aribdestinationsettings
            '''
            result = self._values.get("arib_destination_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AribDestinationSettingsProperty"]], result)

        @builtins.property
        def burn_in_destination_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.BurnInDestinationSettingsProperty"]]:
            '''The configuration of one burn-in captions encode in the output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-burnindestinationsettings
            '''
            result = self._values.get("burn_in_destination_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.BurnInDestinationSettingsProperty"]], result)

        @builtins.property
        def dvb_sub_destination_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.DvbSubDestinationSettingsProperty"]]:
            '''The configuration of one DVB Sub captions encode in the output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-dvbsubdestinationsettings
            '''
            result = self._values.get("dvb_sub_destination_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.DvbSubDestinationSettingsProperty"]], result)

        @builtins.property
        def ebu_tt_d_destination_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.EbuTtDDestinationSettingsProperty"]]:
            '''Settings for EBU-TT captions in the output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-ebuttddestinationsettings
            '''
            result = self._values.get("ebu_tt_d_destination_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.EbuTtDDestinationSettingsProperty"]], result)

        @builtins.property
        def embedded_destination_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.EmbeddedDestinationSettingsProperty"]]:
            '''The configuration of one embedded captions encode in the output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-embeddeddestinationsettings
            '''
            result = self._values.get("embedded_destination_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.EmbeddedDestinationSettingsProperty"]], result)

        @builtins.property
        def embedded_plus_scte20_destination_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.EmbeddedPlusScte20DestinationSettingsProperty"]]:
            '''The configuration of one embedded plus SCTE-20 captions encode in the output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-embeddedplusscte20destinationsettings
            '''
            result = self._values.get("embedded_plus_scte20_destination_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.EmbeddedPlusScte20DestinationSettingsProperty"]], result)

        @builtins.property
        def rtmp_caption_info_destination_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.RtmpCaptionInfoDestinationSettingsProperty"]]:
            '''The configuration of one RTMPCaptionInfo captions encode in the output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-rtmpcaptioninfodestinationsettings
            '''
            result = self._values.get("rtmp_caption_info_destination_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.RtmpCaptionInfoDestinationSettingsProperty"]], result)

        @builtins.property
        def scte20_plus_embedded_destination_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Scte20PlusEmbeddedDestinationSettingsProperty"]]:
            '''The configuration of one SCTE20 plus embedded captions encode in the output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-scte20plusembeddeddestinationsettings
            '''
            result = self._values.get("scte20_plus_embedded_destination_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Scte20PlusEmbeddedDestinationSettingsProperty"]], result)

        @builtins.property
        def scte27_destination_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Scte27DestinationSettingsProperty"]]:
            '''The configuration of one SCTE-27 captions encode in the output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-scte27destinationsettings
            '''
            result = self._values.get("scte27_destination_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Scte27DestinationSettingsProperty"]], result)

        @builtins.property
        def smpte_tt_destination_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.SmpteTtDestinationSettingsProperty"]]:
            '''The configuration of one SMPTE-TT captions encode in the output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-smptettdestinationsettings
            '''
            result = self._values.get("smpte_tt_destination_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.SmpteTtDestinationSettingsProperty"]], result)

        @builtins.property
        def teletext_destination_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.TeletextDestinationSettingsProperty"]]:
            '''The configuration of one Teletext captions encode in the output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-teletextdestinationsettings
            '''
            result = self._values.get("teletext_destination_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.TeletextDestinationSettingsProperty"]], result)

        @builtins.property
        def ttml_destination_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.TtmlDestinationSettingsProperty"]]:
            '''The configuration of one TTML captions encode in the output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-ttmldestinationsettings
            '''
            result = self._values.get("ttml_destination_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.TtmlDestinationSettingsProperty"]], result)

        @builtins.property
        def webvtt_destination_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.WebvttDestinationSettingsProperty"]]:
            '''The configuration of one WebVTT captions encode in the output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-webvttdestinationsettings
            '''
            result = self._values.get("webvtt_destination_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.WebvttDestinationSettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CaptionDestinationSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.CaptionLanguageMappingProperty",
        jsii_struct_bases=[],
        name_mapping={
            "caption_channel": "captionChannel",
            "language_code": "languageCode",
            "language_description": "languageDescription",
        },
    )
    class CaptionLanguageMappingProperty:
        def __init__(
            self,
            *,
            caption_channel: typing.Optional[jsii.Number] = None,
            language_code: typing.Optional[builtins.str] = None,
            language_description: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Maps a captions channel to an ISO 693-2 language code (http://www.loc.gov/standards/iso639-2), with an optional description.

            The parent of this entity is HlsGroupSettings.

            :param caption_channel: The closed caption channel being described by this CaptionLanguageMapping. Each channel mapping must have a unique channel number (maximum of 4).
            :param language_code: A three-character ISO 639-2 language code (see http://www.loc.gov/standards/iso639-2).
            :param language_description: The textual description of language.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionlanguagemapping.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                caption_language_mapping_property = medialive.CfnChannel.CaptionLanguageMappingProperty(
                    caption_channel=123,
                    language_code="languageCode",
                    language_description="languageDescription"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if caption_channel is not None:
                self._values["caption_channel"] = caption_channel
            if language_code is not None:
                self._values["language_code"] = language_code
            if language_description is not None:
                self._values["language_description"] = language_description

        @builtins.property
        def caption_channel(self) -> typing.Optional[jsii.Number]:
            '''The closed caption channel being described by this CaptionLanguageMapping.

            Each channel mapping must have a unique channel number (maximum of 4).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionlanguagemapping.html#cfn-medialive-channel-captionlanguagemapping-captionchannel
            '''
            result = self._values.get("caption_channel")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def language_code(self) -> typing.Optional[builtins.str]:
            '''A three-character ISO 639-2 language code (see http://www.loc.gov/standards/iso639-2).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionlanguagemapping.html#cfn-medialive-channel-captionlanguagemapping-languagecode
            '''
            result = self._values.get("language_code")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def language_description(self) -> typing.Optional[builtins.str]:
            '''The textual description of language.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionlanguagemapping.html#cfn-medialive-channel-captionlanguagemapping-languagedescription
            '''
            result = self._values.get("language_description")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CaptionLanguageMappingProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.CaptionRectangleProperty",
        jsii_struct_bases=[],
        name_mapping={
            "height": "height",
            "left_offset": "leftOffset",
            "top_offset": "topOffset",
            "width": "width",
        },
    )
    class CaptionRectangleProperty:
        def __init__(
            self,
            *,
            height: typing.Optional[jsii.Number] = None,
            left_offset: typing.Optional[jsii.Number] = None,
            top_offset: typing.Optional[jsii.Number] = None,
            width: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''Settings to configure the caption rectangle for an output captions that will be created using this Teletext source captions.

            The parent of this entity is TeletextSourceSettings.

            :param height: See the description in leftOffset. For height, specify the entire height of the rectangle as a percentage of the underlying frame height. For example, "80" means the rectangle height is 80% of the underlying frame height. The topOffset and rectangleHeight must add up to 100% or less. This field corresponds to tts:extent - Y in the TTML standard.
            :param left_offset: Applies only if you plan to convert these source captions to EBU-TT-D or TTML in an output. (Make sure to leave the default if you don't have either of these formats in the output.) You can define a display rectangle for the captions that is smaller than the underlying video frame. You define the rectangle by specifying the position of the left edge, top edge, bottom edge, and right edge of the rectangle, all within the underlying video frame. The units for the measurements are percentages. If you specify a value for one of these fields, you must specify a value for all of them. For leftOffset, specify the position of the left edge of the rectangle, as a percentage of the underlying frame width, and relative to the left edge of the frame. For example, "10" means the measurement is 10% of the underlying frame width. The rectangle left edge starts at that position from the left edge of the frame. This field corresponds to tts:origin - X in the TTML standard.
            :param top_offset: See the description in leftOffset. For topOffset, specify the position of the top edge of the rectangle, as a percentage of the underlying frame height, and relative to the top edge of the frame. For example, "10" means the measurement is 10% of the underlying frame height. The rectangle top edge starts at that position from the top edge of the frame. This field corresponds to tts:origin - Y in the TTML standard.
            :param width: See the description in leftOffset. For width, specify the entire width of the rectangle as a percentage of the underlying frame width. For example, "80" means the rectangle width is 80% of the underlying frame width. The leftOffset and rectangleWidth must add up to 100% or less. This field corresponds to tts:extent - X in the TTML standard.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionrectangle.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                caption_rectangle_property = medialive.CfnChannel.CaptionRectangleProperty(
                    height=123,
                    left_offset=123,
                    top_offset=123,
                    width=123
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if height is not None:
                self._values["height"] = height
            if left_offset is not None:
                self._values["left_offset"] = left_offset
            if top_offset is not None:
                self._values["top_offset"] = top_offset
            if width is not None:
                self._values["width"] = width

        @builtins.property
        def height(self) -> typing.Optional[jsii.Number]:
            '''See the description in leftOffset.

            For height, specify the entire height of the rectangle as a percentage of the underlying frame height. For example, "80" means the rectangle height is 80% of the underlying frame height. The topOffset and rectangleHeight must add up to 100% or less. This field corresponds to tts:extent - Y in the TTML standard.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionrectangle.html#cfn-medialive-channel-captionrectangle-height
            '''
            result = self._values.get("height")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def left_offset(self) -> typing.Optional[jsii.Number]:
            '''Applies only if you plan to convert these source captions to EBU-TT-D or TTML in an output.

            (Make sure to leave the default if you don't have either of these formats in the output.) You can define a display rectangle for the captions that is smaller than the underlying video frame. You define the rectangle by specifying the position of the left edge, top edge, bottom edge, and right edge of the rectangle, all within the underlying video frame. The units for the measurements are percentages. If you specify a value for one of these fields, you must specify a value for all of them.

            For leftOffset, specify the position of the left edge of the rectangle, as a percentage of the underlying frame width, and relative to the left edge of the frame. For example, "10" means the measurement is 10% of the underlying frame width. The rectangle left edge starts at that position from the left edge of the frame. This field corresponds to tts:origin - X in the TTML standard.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionrectangle.html#cfn-medialive-channel-captionrectangle-leftoffset
            '''
            result = self._values.get("left_offset")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def top_offset(self) -> typing.Optional[jsii.Number]:
            '''See the description in leftOffset.

            For topOffset, specify the position of the top edge of the rectangle, as a percentage of the underlying frame height, and relative to the top edge of the frame. For example, "10" means the measurement is 10% of the underlying frame height. The rectangle top edge starts at that position from the top edge of the frame. This field corresponds to tts:origin - Y in the TTML standard.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionrectangle.html#cfn-medialive-channel-captionrectangle-topoffset
            '''
            result = self._values.get("top_offset")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def width(self) -> typing.Optional[jsii.Number]:
            '''See the description in leftOffset.

            For width, specify the entire width of the rectangle as a percentage of the underlying frame width. For example, "80" means the rectangle width is 80% of the underlying frame width. The leftOffset and rectangleWidth must add up to 100% or less. This field corresponds to tts:extent - X in the TTML standard.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionrectangle.html#cfn-medialive-channel-captionrectangle-width
            '''
            result = self._values.get("width")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CaptionRectangleProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.CaptionSelectorProperty",
        jsii_struct_bases=[],
        name_mapping={
            "language_code": "languageCode",
            "name": "name",
            "selector_settings": "selectorSettings",
        },
    )
    class CaptionSelectorProperty:
        def __init__(
            self,
            *,
            language_code: typing.Optional[builtins.str] = None,
            name: typing.Optional[builtins.str] = None,
            selector_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.CaptionSelectorSettingsProperty"]] = None,
        ) -> None:
            '''Information about one caption to extract from the input.

            The parent of this entity is InputSettings.

            :param language_code: When specified, this field indicates the three-letter language code of the captions track to extract from the source.
            :param name: The name identifier for a captions selector. This name is used to associate this captions selector with one or more captions descriptions. Names must be unique within a channel.
            :param selector_settings: Information about the specific audio to extract from the input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselector.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                caption_selector_property = medialive.CfnChannel.CaptionSelectorProperty(
                    language_code="languageCode",
                    name="name",
                    selector_settings=medialive.CfnChannel.CaptionSelectorSettingsProperty(
                        ancillary_source_settings=medialive.CfnChannel.AncillarySourceSettingsProperty(
                            source_ancillary_channel_number=123
                        ),
                        arib_source_settings=medialive.CfnChannel.AribSourceSettingsProperty(),
                        dvb_sub_source_settings=medialive.CfnChannel.DvbSubSourceSettingsProperty(
                            ocr_language="ocrLanguage",
                            pid=123
                        ),
                        embedded_source_settings=medialive.CfnChannel.EmbeddedSourceSettingsProperty(
                            convert608_to708="convert608To708",
                            scte20_detection="scte20Detection",
                            source608_channel_number=123,
                            source608_track_number=123
                        ),
                        scte20_source_settings=medialive.CfnChannel.Scte20SourceSettingsProperty(
                            convert608_to708="convert608To708",
                            source608_channel_number=123
                        ),
                        scte27_source_settings=medialive.CfnChannel.Scte27SourceSettingsProperty(
                            ocr_language="ocrLanguage",
                            pid=123
                        ),
                        teletext_source_settings=medialive.CfnChannel.TeletextSourceSettingsProperty(
                            output_rectangle=medialive.CfnChannel.CaptionRectangleProperty(
                                height=123,
                                left_offset=123,
                                top_offset=123,
                                width=123
                            ),
                            page_number="pageNumber"
                        )
                    )
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if language_code is not None:
                self._values["language_code"] = language_code
            if name is not None:
                self._values["name"] = name
            if selector_settings is not None:
                self._values["selector_settings"] = selector_settings

        @builtins.property
        def language_code(self) -> typing.Optional[builtins.str]:
            '''When specified, this field indicates the three-letter language code of the captions track to extract from the source.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselector.html#cfn-medialive-channel-captionselector-languagecode
            '''
            result = self._values.get("language_code")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def name(self) -> typing.Optional[builtins.str]:
            '''The name identifier for a captions selector.

            This name is used to associate this captions selector with one or more captions descriptions. Names must be unique within a channel.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselector.html#cfn-medialive-channel-captionselector-name
            '''
            result = self._values.get("name")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def selector_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.CaptionSelectorSettingsProperty"]]:
            '''Information about the specific audio to extract from the input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselector.html#cfn-medialive-channel-captionselector-selectorsettings
            '''
            result = self._values.get("selector_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.CaptionSelectorSettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CaptionSelectorProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.CaptionSelectorSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "ancillary_source_settings": "ancillarySourceSettings",
            "arib_source_settings": "aribSourceSettings",
            "dvb_sub_source_settings": "dvbSubSourceSettings",
            "embedded_source_settings": "embeddedSourceSettings",
            "scte20_source_settings": "scte20SourceSettings",
            "scte27_source_settings": "scte27SourceSettings",
            "teletext_source_settings": "teletextSourceSettings",
        },
    )
    class CaptionSelectorSettingsProperty:
        def __init__(
            self,
            *,
            ancillary_source_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AncillarySourceSettingsProperty"]] = None,
            arib_source_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AribSourceSettingsProperty"]] = None,
            dvb_sub_source_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.DvbSubSourceSettingsProperty"]] = None,
            embedded_source_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.EmbeddedSourceSettingsProperty"]] = None,
            scte20_source_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Scte20SourceSettingsProperty"]] = None,
            scte27_source_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Scte27SourceSettingsProperty"]] = None,
            teletext_source_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.TeletextSourceSettingsProperty"]] = None,
        ) -> None:
            '''Captions Selector Settings.

            The parent of this entity is CaptionSelector.

            :param ancillary_source_settings: Information about the ancillary captions to extract from the input.
            :param arib_source_settings: Information about the ARIB captions to extract from the input.
            :param dvb_sub_source_settings: Information about the DVB Sub captions to extract from the input.
            :param embedded_source_settings: Information about the embedded captions to extract from the input.
            :param scte20_source_settings: Information about the SCTE-20 captions to extract from the input.
            :param scte27_source_settings: Information about the SCTE-27 captions to extract from the input.
            :param teletext_source_settings: Information about the Teletext captions to extract from the input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                caption_selector_settings_property = medialive.CfnChannel.CaptionSelectorSettingsProperty(
                    ancillary_source_settings=medialive.CfnChannel.AncillarySourceSettingsProperty(
                        source_ancillary_channel_number=123
                    ),
                    arib_source_settings=medialive.CfnChannel.AribSourceSettingsProperty(),
                    dvb_sub_source_settings=medialive.CfnChannel.DvbSubSourceSettingsProperty(
                        ocr_language="ocrLanguage",
                        pid=123
                    ),
                    embedded_source_settings=medialive.CfnChannel.EmbeddedSourceSettingsProperty(
                        convert608_to708="convert608To708",
                        scte20_detection="scte20Detection",
                        source608_channel_number=123,
                        source608_track_number=123
                    ),
                    scte20_source_settings=medialive.CfnChannel.Scte20SourceSettingsProperty(
                        convert608_to708="convert608To708",
                        source608_channel_number=123
                    ),
                    scte27_source_settings=medialive.CfnChannel.Scte27SourceSettingsProperty(
                        ocr_language="ocrLanguage",
                        pid=123
                    ),
                    teletext_source_settings=medialive.CfnChannel.TeletextSourceSettingsProperty(
                        output_rectangle=medialive.CfnChannel.CaptionRectangleProperty(
                            height=123,
                            left_offset=123,
                            top_offset=123,
                            width=123
                        ),
                        page_number="pageNumber"
                    )
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if ancillary_source_settings is not None:
                self._values["ancillary_source_settings"] = ancillary_source_settings
            if arib_source_settings is not None:
                self._values["arib_source_settings"] = arib_source_settings
            if dvb_sub_source_settings is not None:
                self._values["dvb_sub_source_settings"] = dvb_sub_source_settings
            if embedded_source_settings is not None:
                self._values["embedded_source_settings"] = embedded_source_settings
            if scte20_source_settings is not None:
                self._values["scte20_source_settings"] = scte20_source_settings
            if scte27_source_settings is not None:
                self._values["scte27_source_settings"] = scte27_source_settings
            if teletext_source_settings is not None:
                self._values["teletext_source_settings"] = teletext_source_settings

        @builtins.property
        def ancillary_source_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AncillarySourceSettingsProperty"]]:
            '''Information about the ancillary captions to extract from the input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-ancillarysourcesettings
            '''
            result = self._values.get("ancillary_source_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AncillarySourceSettingsProperty"]], result)

        @builtins.property
        def arib_source_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AribSourceSettingsProperty"]]:
            '''Information about the ARIB captions to extract from the input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-aribsourcesettings
            '''
            result = self._values.get("arib_source_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AribSourceSettingsProperty"]], result)

        @builtins.property
        def dvb_sub_source_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.DvbSubSourceSettingsProperty"]]:
            '''Information about the DVB Sub captions to extract from the input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-dvbsubsourcesettings
            '''
            result = self._values.get("dvb_sub_source_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.DvbSubSourceSettingsProperty"]], result)

        @builtins.property
        def embedded_source_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.EmbeddedSourceSettingsProperty"]]:
            '''Information about the embedded captions to extract from the input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-embeddedsourcesettings
            '''
            result = self._values.get("embedded_source_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.EmbeddedSourceSettingsProperty"]], result)

        @builtins.property
        def scte20_source_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Scte20SourceSettingsProperty"]]:
            '''Information about the SCTE-20 captions to extract from the input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-scte20sourcesettings
            '''
            result = self._values.get("scte20_source_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Scte20SourceSettingsProperty"]], result)

        @builtins.property
        def scte27_source_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Scte27SourceSettingsProperty"]]:
            '''Information about the SCTE-27 captions to extract from the input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-scte27sourcesettings
            '''
            result = self._values.get("scte27_source_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Scte27SourceSettingsProperty"]], result)

        @builtins.property
        def teletext_source_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.TeletextSourceSettingsProperty"]]:
            '''Information about the Teletext captions to extract from the input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-teletextsourcesettings
            '''
            result = self._values.get("teletext_source_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.TeletextSourceSettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CaptionSelectorSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.CdiInputSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={"resolution": "resolution"},
    )
    class CdiInputSpecificationProperty:
        def __init__(self, *, resolution: typing.Optional[builtins.str] = None) -> None:
            '''The input specification for this channel.

            It specifies the key characteristics of CDI inputs for this channel, when those characteristics are different from other inputs.

            This entity is at the top level in the channel.

            :param resolution: Maximum CDI input resolution.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cdiinputspecification.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                cdi_input_specification_property = medialive.CfnChannel.CdiInputSpecificationProperty(
                    resolution="resolution"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if resolution is not None:
                self._values["resolution"] = resolution

        @builtins.property
        def resolution(self) -> typing.Optional[builtins.str]:
            '''Maximum CDI input resolution.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cdiinputspecification.html#cfn-medialive-channel-cdiinputspecification-resolution
            '''
            result = self._values.get("resolution")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "CdiInputSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.ColorSpacePassthroughSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={},
    )
    class ColorSpacePassthroughSettingsProperty:
        def __init__(self) -> None:
            '''Passthrough applies no color space conversion to the output.

            The parents of this entity are H264ColorSpaceSettings and H265ColorSpaceSettings.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-colorspacepassthroughsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                color_space_passthrough_settings_property = medialive.CfnChannel.ColorSpacePassthroughSettingsProperty()
            '''
            self._values: typing.Dict[str, typing.Any] = {}

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "ColorSpacePassthroughSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.DvbNitSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "network_id": "networkId",
            "network_name": "networkName",
            "rep_interval": "repInterval",
        },
    )
    class DvbNitSettingsProperty:
        def __init__(
            self,
            *,
            network_id: typing.Optional[jsii.Number] = None,
            network_name: typing.Optional[builtins.str] = None,
            rep_interval: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''The configuration of DVB NIT.

            The parent of this entity is M2tsSettings.

            :param network_id: The numeric value placed in the Network Information Table (NIT).
            :param network_name: The network name text placed in the networkNameDescriptor inside the Network Information Table (NIT). The maximum length is 256 characters.
            :param rep_interval: The number of milliseconds between instances of this table in the output transport stream.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbnitsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                dvb_nit_settings_property = medialive.CfnChannel.DvbNitSettingsProperty(
                    network_id=123,
                    network_name="networkName",
                    rep_interval=123
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if network_id is not None:
                self._values["network_id"] = network_id
            if network_name is not None:
                self._values["network_name"] = network_name
            if rep_interval is not None:
                self._values["rep_interval"] = rep_interval

        @builtins.property
        def network_id(self) -> typing.Optional[jsii.Number]:
            '''The numeric value placed in the Network Information Table (NIT).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbnitsettings.html#cfn-medialive-channel-dvbnitsettings-networkid
            '''
            result = self._values.get("network_id")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def network_name(self) -> typing.Optional[builtins.str]:
            '''The network name text placed in the networkNameDescriptor inside the Network Information Table (NIT).

            The maximum length is 256 characters.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbnitsettings.html#cfn-medialive-channel-dvbnitsettings-networkname
            '''
            result = self._values.get("network_name")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def rep_interval(self) -> typing.Optional[jsii.Number]:
            '''The number of milliseconds between instances of this table in the output transport stream.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbnitsettings.html#cfn-medialive-channel-dvbnitsettings-repinterval
            '''
            result = self._values.get("rep_interval")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DvbNitSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.DvbSdtSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "output_sdt": "outputSdt",
            "rep_interval": "repInterval",
            "service_name": "serviceName",
            "service_provider_name": "serviceProviderName",
        },
    )
    class DvbSdtSettingsProperty:
        def __init__(
            self,
            *,
            output_sdt: typing.Optional[builtins.str] = None,
            rep_interval: typing.Optional[jsii.Number] = None,
            service_name: typing.Optional[builtins.str] = None,
            service_provider_name: typing.Optional[builtins.str] = None,
        ) -> None:
            '''A DVB Service Description Table (SDT).

            The parent of this entity is M2tsSettings.

            :param output_sdt: Selects a method of inserting SDT information into an output stream. The sdtFollow setting copies SDT information from input stream to output stream. The sdtFollowIfPresent setting copies SDT information from input stream to output stream if SDT information is present in the input. Otherwise, it falls back on the user-defined values. The sdtManual setting means that the user will enter the SDT information. The sdtNone setting means that the output stream will not contain SDT information.
            :param rep_interval: The number of milliseconds between instances of this table in the output transport stream.
            :param service_name: The service name placed in the serviceDescriptor in the Service Description Table (SDT). The maximum length is 256 characters.
            :param service_provider_name: The service provider name placed in the serviceDescriptor in the Service Description Table (SDT). The maximum length is 256 characters.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsdtsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                dvb_sdt_settings_property = medialive.CfnChannel.DvbSdtSettingsProperty(
                    output_sdt="outputSdt",
                    rep_interval=123,
                    service_name="serviceName",
                    service_provider_name="serviceProviderName"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if output_sdt is not None:
                self._values["output_sdt"] = output_sdt
            if rep_interval is not None:
                self._values["rep_interval"] = rep_interval
            if service_name is not None:
                self._values["service_name"] = service_name
            if service_provider_name is not None:
                self._values["service_provider_name"] = service_provider_name

        @builtins.property
        def output_sdt(self) -> typing.Optional[builtins.str]:
            '''Selects a method of inserting SDT information into an output stream.

            The sdtFollow setting copies SDT information from input stream to output stream. The sdtFollowIfPresent setting copies SDT information from input stream to output stream if SDT information is present in the input. Otherwise, it falls back on the user-defined values. The sdtManual setting means that the user will enter the SDT information. The sdtNone setting means that the output stream will not contain SDT information.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsdtsettings.html#cfn-medialive-channel-dvbsdtsettings-outputsdt
            '''
            result = self._values.get("output_sdt")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def rep_interval(self) -> typing.Optional[jsii.Number]:
            '''The number of milliseconds between instances of this table in the output transport stream.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsdtsettings.html#cfn-medialive-channel-dvbsdtsettings-repinterval
            '''
            result = self._values.get("rep_interval")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def service_name(self) -> typing.Optional[builtins.str]:
            '''The service name placed in the serviceDescriptor in the Service Description Table (SDT).

            The maximum length is 256 characters.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsdtsettings.html#cfn-medialive-channel-dvbsdtsettings-servicename
            '''
            result = self._values.get("service_name")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def service_provider_name(self) -> typing.Optional[builtins.str]:
            '''The service provider name placed in the serviceDescriptor in the Service Description Table (SDT).

            The maximum length is 256 characters.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsdtsettings.html#cfn-medialive-channel-dvbsdtsettings-serviceprovidername
            '''
            result = self._values.get("service_provider_name")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DvbSdtSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.DvbSubDestinationSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "alignment": "alignment",
            "background_color": "backgroundColor",
            "background_opacity": "backgroundOpacity",
            "font": "font",
            "font_color": "fontColor",
            "font_opacity": "fontOpacity",
            "font_resolution": "fontResolution",
            "font_size": "fontSize",
            "outline_color": "outlineColor",
            "outline_size": "outlineSize",
            "shadow_color": "shadowColor",
            "shadow_opacity": "shadowOpacity",
            "shadow_x_offset": "shadowXOffset",
            "shadow_y_offset": "shadowYOffset",
            "teletext_grid_control": "teletextGridControl",
            "x_position": "xPosition",
            "y_position": "yPosition",
        },
    )
    class DvbSubDestinationSettingsProperty:
        def __init__(
            self,
            *,
            alignment: typing.Optional[builtins.str] = None,
            background_color: typing.Optional[builtins.str] = None,
            background_opacity: typing.Optional[jsii.Number] = None,
            font: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputLocationProperty"]] = None,
            font_color: typing.Optional[builtins.str] = None,
            font_opacity: typing.Optional[jsii.Number] = None,
            font_resolution: typing.Optional[jsii.Number] = None,
            font_size: typing.Optional[builtins.str] = None,
            outline_color: typing.Optional[builtins.str] = None,
            outline_size: typing.Optional[jsii.Number] = None,
            shadow_color: typing.Optional[builtins.str] = None,
            shadow_opacity: typing.Optional[jsii.Number] = None,
            shadow_x_offset: typing.Optional[jsii.Number] = None,
            shadow_y_offset: typing.Optional[jsii.Number] = None,
            teletext_grid_control: typing.Optional[builtins.str] = None,
            x_position: typing.Optional[jsii.Number] = None,
            y_position: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''The settings for DVB Sub captions in the output.

            The parent of this entity is CaptionDestinationSettings.

            :param alignment: If no explicit xPosition or yPosition is provided, setting the alignment to centered places the captions at the bottom center of the output. Similarly, setting a left alignment aligns captions to the bottom left of the output. If x and y positions are specified in conjunction with the alignment parameter, the font is justified (either left or centered) relative to those coordinates. Selecting "smart" justification left-justifies live subtitles and center-justifies pre-recorded subtitles. This option is not valid for source captions that are STL or 608/embedded. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
            :param background_color: Specifies the color of the rectangle behind the captions. All burn-in and DVB-Sub font settings must match.
            :param background_opacity: Specifies the opacity of the background rectangle. 255 is opaque; 0 is transparent. Keeping this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
            :param font: The external font file that is used for captions burn-in. The file extension must be .ttf or .tte. Although you can select output fonts for many different types of input captions, embedded, STL, and Teletext sources use a strict grid system. Using external fonts with these captions sources could cause an unexpected display of proportional fonts. All burn-in and DVB-Sub font settings must match.
            :param font_color: Specifies the color of the burned-in captions. This option is not valid for source captions that are STL, 608/embedded, or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
            :param font_opacity: Specifies the opacity of the burned-in captions. 255 is opaque; 0 is transparent. All burn-in and DVB-Sub font settings must match.
            :param font_resolution: The font resolution in DPI (dots per inch). The default is 96 dpi. All burn-in and DVB-Sub font settings must match.
            :param font_size: When set to auto, fontSize scales depending on the size of the output. Providing a positive integer specifies the exact font size in points. All burn-in and DVB-Sub font settings must match.
            :param outline_color: Specifies the font outline color. This option is not valid for source captions that are either 608/embedded or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
            :param outline_size: Specifies the font outline size in pixels. This option is not valid for source captions that are either 608/embedded or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
            :param shadow_color: Specifies the color of the shadow that is cast by the captions. All burn-in and DVB-Sub font settings must match.
            :param shadow_opacity: Specifies the opacity of the shadow. 255 is opaque; 0 is transparent. Keeping this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
            :param shadow_x_offset: Specifies the horizontal offset of the shadow relative to the captions in pixels. A value of -2 would result in a shadow offset 2 pixels to the left. All burn-in and DVB-Sub font settings must match.
            :param shadow_y_offset: Specifies the vertical offset of the shadow relative to the captions in pixels. A value of -2 would result in a shadow offset 2 pixels above the text. All burn-in and DVB-Sub font settings must match.
            :param teletext_grid_control: Controls whether a fixed grid size is used to generate the output subtitles bitmap. This applies to only Teletext inputs and DVB-Sub/Burn-in outputs.
            :param x_position: Specifies the horizontal position of the captions relative to the left side of the output in pixels. A value of 10 would result in the captions starting 10 pixels from the left of the output. If no explicit xPosition is provided, the horizontal captions position is determined by the alignment parameter. This option is not valid for source captions that are STL, 608/embedded, or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.
            :param y_position: Specifies the vertical position of the captions relative to the top of the output in pixels. A value of 10 would result in the captions starting 10 pixels from the top of the output. If no explicit yPosition is provided, the captions are positioned towards the bottom of the output. This option is not valid for source captions that are STL, 608/embedded, or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                dvb_sub_destination_settings_property = medialive.CfnChannel.DvbSubDestinationSettingsProperty(
                    alignment="alignment",
                    background_color="backgroundColor",
                    background_opacity=123,
                    font=medialive.CfnChannel.InputLocationProperty(
                        password_param="passwordParam",
                        uri="uri",
                        username="username"
                    ),
                    font_color="fontColor",
                    font_opacity=123,
                    font_resolution=123,
                    font_size="fontSize",
                    outline_color="outlineColor",
                    outline_size=123,
                    shadow_color="shadowColor",
                    shadow_opacity=123,
                    shadow_xOffset=123,
                    shadow_yOffset=123,
                    teletext_grid_control="teletextGridControl",
                    x_position=123,
                    y_position=123
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if alignment is not None:
                self._values["alignment"] = alignment
            if background_color is not None:
                self._values["background_color"] = background_color
            if background_opacity is not None:
                self._values["background_opacity"] = background_opacity
            if font is not None:
                self._values["font"] = font
            if font_color is not None:
                self._values["font_color"] = font_color
            if font_opacity is not None:
                self._values["font_opacity"] = font_opacity
            if font_resolution is not None:
                self._values["font_resolution"] = font_resolution
            if font_size is not None:
                self._values["font_size"] = font_size
            if outline_color is not None:
                self._values["outline_color"] = outline_color
            if outline_size is not None:
                self._values["outline_size"] = outline_size
            if shadow_color is not None:
                self._values["shadow_color"] = shadow_color
            if shadow_opacity is not None:
                self._values["shadow_opacity"] = shadow_opacity
            if shadow_x_offset is not None:
                self._values["shadow_x_offset"] = shadow_x_offset
            if shadow_y_offset is not None:
                self._values["shadow_y_offset"] = shadow_y_offset
            if teletext_grid_control is not None:
                self._values["teletext_grid_control"] = teletext_grid_control
            if x_position is not None:
                self._values["x_position"] = x_position
            if y_position is not None:
                self._values["y_position"] = y_position

        @builtins.property
        def alignment(self) -> typing.Optional[builtins.str]:
            '''If no explicit xPosition or yPosition is provided, setting the alignment to centered places the captions at the bottom center of the output.

            Similarly, setting a left alignment aligns captions to the bottom left of the output. If x and y positions are specified in conjunction with the alignment parameter, the font is justified (either left or centered) relative to those coordinates. Selecting "smart" justification left-justifies live subtitles and center-justifies pre-recorded subtitles. This option is not valid for source captions that are STL or 608/embedded. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-alignment
            '''
            result = self._values.get("alignment")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def background_color(self) -> typing.Optional[builtins.str]:
            '''Specifies the color of the rectangle behind the captions.

            All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-backgroundcolor
            '''
            result = self._values.get("background_color")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def background_opacity(self) -> typing.Optional[jsii.Number]:
            '''Specifies the opacity of the background rectangle.

            255 is opaque; 0 is transparent. Keeping this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-backgroundopacity
            '''
            result = self._values.get("background_opacity")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def font(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputLocationProperty"]]:
            '''The external font file that is used for captions burn-in.

            The file extension must be .ttf or .tte. Although you can select output fonts for many different types of input captions, embedded, STL, and Teletext sources use a strict grid system. Using external fonts with these captions sources could cause an unexpected display of proportional fonts. All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-font
            '''
            result = self._values.get("font")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputLocationProperty"]], result)

        @builtins.property
        def font_color(self) -> typing.Optional[builtins.str]:
            '''Specifies the color of the burned-in captions.

            This option is not valid for source captions that are STL, 608/embedded, or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-fontcolor
            '''
            result = self._values.get("font_color")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def font_opacity(self) -> typing.Optional[jsii.Number]:
            '''Specifies the opacity of the burned-in captions.

            255 is opaque; 0 is transparent. All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-fontopacity
            '''
            result = self._values.get("font_opacity")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def font_resolution(self) -> typing.Optional[jsii.Number]:
            '''The font resolution in DPI (dots per inch).

            The default is 96 dpi. All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-fontresolution
            '''
            result = self._values.get("font_resolution")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def font_size(self) -> typing.Optional[builtins.str]:
            '''When set to auto, fontSize scales depending on the size of the output.

            Providing a positive integer specifies the exact font size in points. All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-fontsize
            '''
            result = self._values.get("font_size")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def outline_color(self) -> typing.Optional[builtins.str]:
            '''Specifies the font outline color.

            This option is not valid for source captions that are either 608/embedded or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-outlinecolor
            '''
            result = self._values.get("outline_color")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def outline_size(self) -> typing.Optional[jsii.Number]:
            '''Specifies the font outline size in pixels.

            This option is not valid for source captions that are either 608/embedded or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-outlinesize
            '''
            result = self._values.get("outline_size")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def shadow_color(self) -> typing.Optional[builtins.str]:
            '''Specifies the color of the shadow that is cast by the captions.

            All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-shadowcolor
            '''
            result = self._values.get("shadow_color")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def shadow_opacity(self) -> typing.Optional[jsii.Number]:
            '''Specifies the opacity of the shadow.

            255 is opaque; 0 is transparent. Keeping this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-shadowopacity
            '''
            result = self._values.get("shadow_opacity")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def shadow_x_offset(self) -> typing.Optional[jsii.Number]:
            '''Specifies the horizontal offset of the shadow relative to the captions in pixels.

            A value of -2 would result in a shadow offset 2 pixels to the left. All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-shadowxoffset
            '''
            result = self._values.get("shadow_x_offset")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def shadow_y_offset(self) -> typing.Optional[jsii.Number]:
            '''Specifies the vertical offset of the shadow relative to the captions in pixels.

            A value of -2 would result in a shadow offset 2 pixels above the text. All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-shadowyoffset
            '''
            result = self._values.get("shadow_y_offset")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def teletext_grid_control(self) -> typing.Optional[builtins.str]:
            '''Controls whether a fixed grid size is used to generate the output subtitles bitmap.

            This applies to only Teletext inputs and DVB-Sub/Burn-in outputs.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-teletextgridcontrol
            '''
            result = self._values.get("teletext_grid_control")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def x_position(self) -> typing.Optional[jsii.Number]:
            '''Specifies the horizontal position of the captions relative to the left side of the output in pixels.

            A value of 10 would result in the captions starting 10 pixels from the left of the output. If no explicit xPosition is provided, the horizontal captions position is determined by the alignment parameter. This option is not valid for source captions that are STL, 608/embedded, or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-xposition
            '''
            result = self._values.get("x_position")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def y_position(self) -> typing.Optional[jsii.Number]:
            '''Specifies the vertical position of the captions relative to the top of the output in pixels.

            A value of 10 would result in the captions starting 10 pixels from the top of the output. If no explicit yPosition is provided, the captions are positioned towards the bottom of the output. This option is not valid for source captions that are STL, 608/embedded, or Teletext. These source settings are already pre-defined by the captions stream. All burn-in and DVB-Sub font settings must match.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-yposition
            '''
            result = self._values.get("y_position")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DvbSubDestinationSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.DvbSubSourceSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"ocr_language": "ocrLanguage", "pid": "pid"},
    )
    class DvbSubSourceSettingsProperty:
        def __init__(
            self,
            *,
            ocr_language: typing.Optional[builtins.str] = None,
            pid: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''Information about the DVB Sub captions to extract from the input.

            The parent of this entity is CaptionSelectorSettings.

            :param ocr_language: If you will configure a WebVTT caption description that references this caption selector, use this field to provide the language to consider when translating the image-based source to text.
            :param pid: When using DVB-Sub with burn-in or SMPTE-TT, use this PID for the source content. It is unused for DVB-Sub passthrough. All DVB-Sub content is passed through, regardless of selectors.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubsourcesettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                dvb_sub_source_settings_property = medialive.CfnChannel.DvbSubSourceSettingsProperty(
                    ocr_language="ocrLanguage",
                    pid=123
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if ocr_language is not None:
                self._values["ocr_language"] = ocr_language
            if pid is not None:
                self._values["pid"] = pid

        @builtins.property
        def ocr_language(self) -> typing.Optional[builtins.str]:
            '''If you will configure a WebVTT caption description that references this caption selector, use this field to provide the language to consider when translating the image-based source to text.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubsourcesettings.html#cfn-medialive-channel-dvbsubsourcesettings-ocrlanguage
            '''
            result = self._values.get("ocr_language")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def pid(self) -> typing.Optional[jsii.Number]:
            '''When using DVB-Sub with burn-in or SMPTE-TT, use this PID for the source content.

            It is unused for DVB-Sub passthrough. All DVB-Sub content is passed through, regardless of selectors.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubsourcesettings.html#cfn-medialive-channel-dvbsubsourcesettings-pid
            '''
            result = self._values.get("pid")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DvbSubSourceSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.DvbTdtSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"rep_interval": "repInterval"},
    )
    class DvbTdtSettingsProperty:
        def __init__(
            self,
            *,
            rep_interval: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''The DVB Time and Date Table (TDT).

            The parent of this entity is M2tsSettings.

            :param rep_interval: The number of milliseconds between instances of this table in the output transport stream.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbtdtsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                dvb_tdt_settings_property = medialive.CfnChannel.DvbTdtSettingsProperty(
                    rep_interval=123
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if rep_interval is not None:
                self._values["rep_interval"] = rep_interval

        @builtins.property
        def rep_interval(self) -> typing.Optional[jsii.Number]:
            '''The number of milliseconds between instances of this table in the output transport stream.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbtdtsettings.html#cfn-medialive-channel-dvbtdtsettings-repinterval
            '''
            result = self._values.get("rep_interval")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "DvbTdtSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.Eac3SettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "attenuation_control": "attenuationControl",
            "bitrate": "bitrate",
            "bitstream_mode": "bitstreamMode",
            "coding_mode": "codingMode",
            "dc_filter": "dcFilter",
            "dialnorm": "dialnorm",
            "drc_line": "drcLine",
            "drc_rf": "drcRf",
            "lfe_control": "lfeControl",
            "lfe_filter": "lfeFilter",
            "lo_ro_center_mix_level": "loRoCenterMixLevel",
            "lo_ro_surround_mix_level": "loRoSurroundMixLevel",
            "lt_rt_center_mix_level": "ltRtCenterMixLevel",
            "lt_rt_surround_mix_level": "ltRtSurroundMixLevel",
            "metadata_control": "metadataControl",
            "passthrough_control": "passthroughControl",
            "phase_control": "phaseControl",
            "stereo_downmix": "stereoDownmix",
            "surround_ex_mode": "surroundExMode",
            "surround_mode": "surroundMode",
        },
    )
    class Eac3SettingsProperty:
        def __init__(
            self,
            *,
            attenuation_control: typing.Optional[builtins.str] = None,
            bitrate: typing.Optional[jsii.Number] = None,
            bitstream_mode: typing.Optional[builtins.str] = None,
            coding_mode: typing.Optional[builtins.str] = None,
            dc_filter: typing.Optional[builtins.str] = None,
            dialnorm: typing.Optional[jsii.Number] = None,
            drc_line: typing.Optional[builtins.str] = None,
            drc_rf: typing.Optional[builtins.str] = None,
            lfe_control: typing.Optional[builtins.str] = None,
            lfe_filter: typing.Optional[builtins.str] = None,
            lo_ro_center_mix_level: typing.Optional[jsii.Number] = None,
            lo_ro_surround_mix_level: typing.Optional[jsii.Number] = None,
            lt_rt_center_mix_level: typing.Optional[jsii.Number] = None,
            lt_rt_surround_mix_level: typing.Optional[jsii.Number] = None,
            metadata_control: typing.Optional[builtins.str] = None,
            passthrough_control: typing.Optional[builtins.str] = None,
            phase_control: typing.Optional[builtins.str] = None,
            stereo_downmix: typing.Optional[builtins.str] = None,
            surround_ex_mode: typing.Optional[builtins.str] = None,
            surround_mode: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The settings for an EAC3 audio encode in the output.

            The parent of this entity is AudioCodecSettings.

            :param attenuation_control: When set to attenuate3Db, applies a 3 dB attenuation to the surround channels. Used only for the 3/2 coding mode.
            :param bitrate: The average bitrate in bits/second. Valid bitrates depend on the coding mode.
            :param bitstream_mode: Specifies the bitstream mode (bsmod) for the emitted E-AC-3 stream. For more information, see ATSC A/52-2012 (Annex E).
            :param coding_mode: The Dolby Digital Plus coding mode. This mode determines the number of channels.
            :param dc_filter: When set to enabled, activates a DC highpass filter for all input channels.
            :param dialnorm: Sets the dialnorm for the output. If blank and the input audio is Dolby Digital Plus, dialnorm will be passed through.
            :param drc_line: Sets the Dolby dynamic range compression profile.
            :param drc_rf: Sets the profile for heavy Dolby dynamic range compression, ensuring that the instantaneous signal peaks do not exceed specified levels.
            :param lfe_control: When encoding 3/2 audio, setting to lfe enables the LFE channel.
            :param lfe_filter: When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding. Valid only with a codingMode32 coding mode.
            :param lo_ro_center_mix_level: The Left only/Right only center mix level. Used only for the 3/2 coding mode.
            :param lo_ro_surround_mix_level: The Left only/Right only surround mix level. Used only for a 3/2 coding mode.
            :param lt_rt_center_mix_level: The Left total/Right total center mix level. Used only for a 3/2 coding mode.
            :param lt_rt_surround_mix_level: The Left total/Right total surround mix level. Used only for the 3/2 coding mode.
            :param metadata_control: When set to followInput, encoder metadata is sourced from the DD, DD+, or DolbyE decoder that supplies this audio data. If the audio is not supplied from one of these streams, then the static metadata settings are used.
            :param passthrough_control: When set to whenPossible, input DD+ audio will be passed through if it is present on the input. This detection is dynamic over the life of the transcode. Inputs that alternate between DD+ and non-DD+ content will have a consistent DD+ output as the system alternates between passthrough and encoding.
            :param phase_control: When set to shift90Degrees, applies a 90-degree phase shift to the surround channels. Used only for a 3/2 coding mode.
            :param stereo_downmix: A stereo downmix preference. Used only for the 3/2 coding mode.
            :param surround_ex_mode: When encoding 3/2 audio, sets whether an extra center back surround channel is matrix encoded into the left and right surround channels.
            :param surround_mode: When encoding 2/0 audio, sets whether Dolby Surround is matrix-encoded into the two channels.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                eac3_settings_property = medialive.CfnChannel.Eac3SettingsProperty(
                    attenuation_control="attenuationControl",
                    bitrate=123,
                    bitstream_mode="bitstreamMode",
                    coding_mode="codingMode",
                    dc_filter="dcFilter",
                    dialnorm=123,
                    drc_line="drcLine",
                    drc_rf="drcRf",
                    lfe_control="lfeControl",
                    lfe_filter="lfeFilter",
                    lo_ro_center_mix_level=123,
                    lo_ro_surround_mix_level=123,
                    lt_rt_center_mix_level=123,
                    lt_rt_surround_mix_level=123,
                    metadata_control="metadataControl",
                    passthrough_control="passthroughControl",
                    phase_control="phaseControl",
                    stereo_downmix="stereoDownmix",
                    surround_ex_mode="surroundExMode",
                    surround_mode="surroundMode"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if attenuation_control is not None:
                self._values["attenuation_control"] = attenuation_control
            if bitrate is not None:
                self._values["bitrate"] = bitrate
            if bitstream_mode is not None:
                self._values["bitstream_mode"] = bitstream_mode
            if coding_mode is not None:
                self._values["coding_mode"] = coding_mode
            if dc_filter is not None:
                self._values["dc_filter"] = dc_filter
            if dialnorm is not None:
                self._values["dialnorm"] = dialnorm
            if drc_line is not None:
                self._values["drc_line"] = drc_line
            if drc_rf is not None:
                self._values["drc_rf"] = drc_rf
            if lfe_control is not None:
                self._values["lfe_control"] = lfe_control
            if lfe_filter is not None:
                self._values["lfe_filter"] = lfe_filter
            if lo_ro_center_mix_level is not None:
                self._values["lo_ro_center_mix_level"] = lo_ro_center_mix_level
            if lo_ro_surround_mix_level is not None:
                self._values["lo_ro_surround_mix_level"] = lo_ro_surround_mix_level
            if lt_rt_center_mix_level is not None:
                self._values["lt_rt_center_mix_level"] = lt_rt_center_mix_level
            if lt_rt_surround_mix_level is not None:
                self._values["lt_rt_surround_mix_level"] = lt_rt_surround_mix_level
            if metadata_control is not None:
                self._values["metadata_control"] = metadata_control
            if passthrough_control is not None:
                self._values["passthrough_control"] = passthrough_control
            if phase_control is not None:
                self._values["phase_control"] = phase_control
            if stereo_downmix is not None:
                self._values["stereo_downmix"] = stereo_downmix
            if surround_ex_mode is not None:
                self._values["surround_ex_mode"] = surround_ex_mode
            if surround_mode is not None:
                self._values["surround_mode"] = surround_mode

        @builtins.property
        def attenuation_control(self) -> typing.Optional[builtins.str]:
            '''When set to attenuate3Db, applies a 3 dB attenuation to the surround channels.

            Used only for the 3/2 coding mode.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-attenuationcontrol
            '''
            result = self._values.get("attenuation_control")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def bitrate(self) -> typing.Optional[jsii.Number]:
            '''The average bitrate in bits/second.

            Valid bitrates depend on the coding mode.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-bitrate
            '''
            result = self._values.get("bitrate")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def bitstream_mode(self) -> typing.Optional[builtins.str]:
            '''Specifies the bitstream mode (bsmod) for the emitted E-AC-3 stream.

            For more information, see ATSC A/52-2012 (Annex E).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-bitstreammode
            '''
            result = self._values.get("bitstream_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def coding_mode(self) -> typing.Optional[builtins.str]:
            '''The Dolby Digital Plus coding mode.

            This mode determines the number of channels.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-codingmode
            '''
            result = self._values.get("coding_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def dc_filter(self) -> typing.Optional[builtins.str]:
            '''When set to enabled, activates a DC highpass filter for all input channels.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-dcfilter
            '''
            result = self._values.get("dc_filter")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def dialnorm(self) -> typing.Optional[jsii.Number]:
            '''Sets the dialnorm for the output.

            If blank and the input audio is Dolby Digital Plus, dialnorm will be passed through.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-dialnorm
            '''
            result = self._values.get("dialnorm")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def drc_line(self) -> typing.Optional[builtins.str]:
            '''Sets the Dolby dynamic range compression profile.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-drcline
            '''
            result = self._values.get("drc_line")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def drc_rf(self) -> typing.Optional[builtins.str]:
            '''Sets the profile for heavy Dolby dynamic range compression, ensuring that the instantaneous signal peaks do not exceed specified levels.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-drcrf
            '''
            result = self._values.get("drc_rf")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def lfe_control(self) -> typing.Optional[builtins.str]:
            '''When encoding 3/2 audio, setting to lfe enables the LFE channel.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-lfecontrol
            '''
            result = self._values.get("lfe_control")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def lfe_filter(self) -> typing.Optional[builtins.str]:
            '''When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding.

            Valid only with a codingMode32 coding mode.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-lfefilter
            '''
            result = self._values.get("lfe_filter")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def lo_ro_center_mix_level(self) -> typing.Optional[jsii.Number]:
            '''The Left only/Right only center mix level.

            Used only for the 3/2 coding mode.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-lorocentermixlevel
            '''
            result = self._values.get("lo_ro_center_mix_level")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def lo_ro_surround_mix_level(self) -> typing.Optional[jsii.Number]:
            '''The Left only/Right only surround mix level.

            Used only for a 3/2 coding mode.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-lorosurroundmixlevel
            '''
            result = self._values.get("lo_ro_surround_mix_level")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def lt_rt_center_mix_level(self) -> typing.Optional[jsii.Number]:
            '''The Left total/Right total center mix level.

            Used only for a 3/2 coding mode.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-ltrtcentermixlevel
            '''
            result = self._values.get("lt_rt_center_mix_level")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def lt_rt_surround_mix_level(self) -> typing.Optional[jsii.Number]:
            '''The Left total/Right total surround mix level.

            Used only for the 3/2 coding mode.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-ltrtsurroundmixlevel
            '''
            result = self._values.get("lt_rt_surround_mix_level")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def metadata_control(self) -> typing.Optional[builtins.str]:
            '''When set to followInput, encoder metadata is sourced from the DD, DD+, or DolbyE decoder that supplies this audio data.

            If the audio is not supplied from one of these streams, then the static metadata settings are used.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-metadatacontrol
            '''
            result = self._values.get("metadata_control")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def passthrough_control(self) -> typing.Optional[builtins.str]:
            '''When set to whenPossible, input DD+ audio will be passed through if it is present on the input.

            This detection is dynamic over the life of the transcode. Inputs that alternate between DD+ and non-DD+ content will have a consistent DD+ output as the system alternates between passthrough and encoding.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-passthroughcontrol
            '''
            result = self._values.get("passthrough_control")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def phase_control(self) -> typing.Optional[builtins.str]:
            '''When set to shift90Degrees, applies a 90-degree phase shift to the surround channels.

            Used only for a 3/2 coding mode.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-phasecontrol
            '''
            result = self._values.get("phase_control")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def stereo_downmix(self) -> typing.Optional[builtins.str]:
            '''A stereo downmix preference.

            Used only for the 3/2 coding mode.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-stereodownmix
            '''
            result = self._values.get("stereo_downmix")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def surround_ex_mode(self) -> typing.Optional[builtins.str]:
            '''When encoding 3/2 audio, sets whether an extra center back surround channel is matrix encoded into the left and right surround channels.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-surroundexmode
            '''
            result = self._values.get("surround_ex_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def surround_mode(self) -> typing.Optional[builtins.str]:
            '''When encoding 2/0 audio, sets whether Dolby Surround is matrix-encoded into the two channels.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-surroundmode
            '''
            result = self._values.get("surround_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "Eac3SettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.EbuTtDDestinationSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "copyright_holder": "copyrightHolder",
            "fill_line_gap": "fillLineGap",
            "font_family": "fontFamily",
            "style_control": "styleControl",
        },
    )
    class EbuTtDDestinationSettingsProperty:
        def __init__(
            self,
            *,
            copyright_holder: typing.Optional[builtins.str] = None,
            fill_line_gap: typing.Optional[builtins.str] = None,
            font_family: typing.Optional[builtins.str] = None,
            style_control: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Settings for EBU-TT captions in the output.

            The parent of this entity is CaptionDestinationSettings.

            :param copyright_holder: Applies only if you plan to convert these source captions to EBU-TT-D or TTML in an output. Complete this field if you want to include the name of the copyright holder in the copyright metadata tag in the TTML
            :param fill_line_gap: Specifies how to handle the gap between the lines (in multi-line captions). - enabled: Fill with the captions background color (as specified in the input captions). - disabled: Leave the gap unfilled.
            :param font_family: Specifies the font family to include in the font data attached to the EBU-TT captions. Valid only if styleControl is set to include. If you leave this field empty, the font family is set to "monospaced". (If styleControl is set to exclude, the font family is always set to "monospaced".) You specify only the font family. All other style information (color, bold, position and so on) is copied from the input captions. The size is always set to 100% to allow the downstream player to choose the size. - Enter a list of font families, as a comma-separated list of font names, in order of preference. The name can be a font family (such as “Arial”), or a generic font family (such as “serif”), or “default” (to let the downstream player choose the font). - Leave blank to set the family to “monospace”.
            :param style_control: Specifies the style information (font color, font position, and so on) to include in the font data that is attached to the EBU-TT captions. - include: Take the style information (font color, font position, and so on) from the source captions and include that information in the font data attached to the EBU-TT captions. This option is valid only if the source captions are Embedded or Teletext. - exclude: In the font data attached to the EBU-TT captions, set the font family to "monospaced". Do not include any other style information.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ebuttddestinationsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                ebu_tt_dDestination_settings_property = medialive.CfnChannel.EbuTtDDestinationSettingsProperty(
                    copyright_holder="copyrightHolder",
                    fill_line_gap="fillLineGap",
                    font_family="fontFamily",
                    style_control="styleControl"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if copyright_holder is not None:
                self._values["copyright_holder"] = copyright_holder
            if fill_line_gap is not None:
                self._values["fill_line_gap"] = fill_line_gap
            if font_family is not None:
                self._values["font_family"] = font_family
            if style_control is not None:
                self._values["style_control"] = style_control

        @builtins.property
        def copyright_holder(self) -> typing.Optional[builtins.str]:
            '''Applies only if you plan to convert these source captions to EBU-TT-D or TTML in an output.

            Complete this field if you want to include the name of the copyright holder in the copyright metadata tag in the TTML

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ebuttddestinationsettings.html#cfn-medialive-channel-ebuttddestinationsettings-copyrightholder
            '''
            result = self._values.get("copyright_holder")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def fill_line_gap(self) -> typing.Optional[builtins.str]:
            '''Specifies how to handle the gap between the lines (in multi-line captions).

            - enabled: Fill with the captions background color (as specified in the input captions).
            - disabled: Leave the gap unfilled.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ebuttddestinationsettings.html#cfn-medialive-channel-ebuttddestinationsettings-filllinegap
            '''
            result = self._values.get("fill_line_gap")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def font_family(self) -> typing.Optional[builtins.str]:
            '''Specifies the font family to include in the font data attached to the EBU-TT captions.

            Valid only if styleControl is set to include. If you leave this field empty, the font family is set to "monospaced". (If styleControl is set to exclude, the font family is always set to "monospaced".) You specify only the font family. All other style information (color, bold, position and so on) is copied from the input captions. The size is always set to 100% to allow the downstream player to choose the size. - Enter a list of font families, as a comma-separated list of font names, in order of preference. The name can be a font family (such as “Arial”), or a generic font family (such as “serif”), or “default” (to let the downstream player choose the font).

            - Leave blank to set the family to “monospace”.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ebuttddestinationsettings.html#cfn-medialive-channel-ebuttddestinationsettings-fontfamily
            '''
            result = self._values.get("font_family")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def style_control(self) -> typing.Optional[builtins.str]:
            '''Specifies the style information (font color, font position, and so on) to include in the font data that is attached to the EBU-TT captions.

            - include: Take the style information (font color, font position, and so on) from the source captions and include that information in the font data attached to the EBU-TT captions. This option is valid only if the source captions are Embedded or Teletext.
            - exclude: In the font data attached to the EBU-TT captions, set the font family to "monospaced". Do not include any other style information.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ebuttddestinationsettings.html#cfn-medialive-channel-ebuttddestinationsettings-stylecontrol
            '''
            result = self._values.get("style_control")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "EbuTtDDestinationSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.EmbeddedDestinationSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={},
    )
    class EmbeddedDestinationSettingsProperty:
        def __init__(self) -> None:
            '''The configuration of embedded captions in the output.

            The parent of this entity is CaptionDestinationSettings.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddeddestinationsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                embedded_destination_settings_property = medialive.CfnChannel.EmbeddedDestinationSettingsProperty()
            '''
            self._values: typing.Dict[str, typing.Any] = {}

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "EmbeddedDestinationSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.EmbeddedPlusScte20DestinationSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={},
    )
    class EmbeddedPlusScte20DestinationSettingsProperty:
        def __init__(self) -> None:
            '''The settings for embedded plus SCTE-20 captions in the output.

            The parent of this entity is CaptionDestinationSettings.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddedplusscte20destinationsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                embedded_plus_scte20_destination_settings_property = medialive.CfnChannel.EmbeddedPlusScte20DestinationSettingsProperty()
            '''
            self._values: typing.Dict[str, typing.Any] = {}

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "EmbeddedPlusScte20DestinationSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.EmbeddedSourceSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "convert608_to708": "convert608To708",
            "scte20_detection": "scte20Detection",
            "source608_channel_number": "source608ChannelNumber",
            "source608_track_number": "source608TrackNumber",
        },
    )
    class EmbeddedSourceSettingsProperty:
        def __init__(
            self,
            *,
            convert608_to708: typing.Optional[builtins.str] = None,
            scte20_detection: typing.Optional[builtins.str] = None,
            source608_channel_number: typing.Optional[jsii.Number] = None,
            source608_track_number: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''Information about the embedded captions to extract from the input.

            The parent of this entity is CaptionSelectorSettings.

            :param convert608_to708: If this is upconvert, 608 data is both passed through the "608 compatibility bytes" fields of the 708 wrapper as well as translated into 708. If 708 data is present in the source content, it is discarded.
            :param scte20_detection: Set to "auto" to handle streams with intermittent or non-aligned SCTE-20 and embedded captions.
            :param source608_channel_number: Specifies the 608/708 channel number within the video track from which to extract captions. This is unused for passthrough.
            :param source608_track_number: This field is unused and deprecated.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddedsourcesettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                embedded_source_settings_property = medialive.CfnChannel.EmbeddedSourceSettingsProperty(
                    convert608_to708="convert608To708",
                    scte20_detection="scte20Detection",
                    source608_channel_number=123,
                    source608_track_number=123
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if convert608_to708 is not None:
                self._values["convert608_to708"] = convert608_to708
            if scte20_detection is not None:
                self._values["scte20_detection"] = scte20_detection
            if source608_channel_number is not None:
                self._values["source608_channel_number"] = source608_channel_number
            if source608_track_number is not None:
                self._values["source608_track_number"] = source608_track_number

        @builtins.property
        def convert608_to708(self) -> typing.Optional[builtins.str]:
            '''If this is upconvert, 608 data is both passed through the "608 compatibility bytes" fields of the 708 wrapper as well as translated into 708.

            If 708 data is present in the source content, it is discarded.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddedsourcesettings.html#cfn-medialive-channel-embeddedsourcesettings-convert608to708
            '''
            result = self._values.get("convert608_to708")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def scte20_detection(self) -> typing.Optional[builtins.str]:
            '''Set to "auto" to handle streams with intermittent or non-aligned SCTE-20 and embedded captions.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddedsourcesettings.html#cfn-medialive-channel-embeddedsourcesettings-scte20detection
            '''
            result = self._values.get("scte20_detection")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def source608_channel_number(self) -> typing.Optional[jsii.Number]:
            '''Specifies the 608/708 channel number within the video track from which to extract captions.

            This is unused for passthrough.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddedsourcesettings.html#cfn-medialive-channel-embeddedsourcesettings-source608channelnumber
            '''
            result = self._values.get("source608_channel_number")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def source608_track_number(self) -> typing.Optional[jsii.Number]:
            '''This field is unused and deprecated.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddedsourcesettings.html#cfn-medialive-channel-embeddedsourcesettings-source608tracknumber
            '''
            result = self._values.get("source608_track_number")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "EmbeddedSourceSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.EncoderSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "audio_descriptions": "audioDescriptions",
            "avail_blanking": "availBlanking",
            "avail_configuration": "availConfiguration",
            "blackout_slate": "blackoutSlate",
            "caption_descriptions": "captionDescriptions",
            "feature_activations": "featureActivations",
            "global_configuration": "globalConfiguration",
            "motion_graphics_configuration": "motionGraphicsConfiguration",
            "nielsen_configuration": "nielsenConfiguration",
            "output_groups": "outputGroups",
            "timecode_config": "timecodeConfig",
            "video_descriptions": "videoDescriptions",
        },
    )
    class EncoderSettingsProperty:
        def __init__(
            self,
            *,
            audio_descriptions: typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.Sequence[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioDescriptionProperty"]]]] = None,
            avail_blanking: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AvailBlankingProperty"]] = None,
            avail_configuration: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AvailConfigurationProperty"]] = None,
            blackout_slate: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.BlackoutSlateProperty"]] = None,
            caption_descriptions: typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.Sequence[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.CaptionDescriptionProperty"]]]] = None,
            feature_activations: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.FeatureActivationsProperty"]] = None,
            global_configuration: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.GlobalConfigurationProperty"]] = None,
            motion_graphics_configuration: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.MotionGraphicsConfigurationProperty"]] = None,
            nielsen_configuration: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.NielsenConfigurationProperty"]] = None,
            output_groups: typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.Sequence[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputGroupProperty"]]]] = None,
            timecode_config: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.TimecodeConfigProperty"]] = None,
            video_descriptions: typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.Sequence[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.VideoDescriptionProperty"]]]] = None,
        ) -> None:
            '''The settings for the encoding of outputs.

            This entity is at the top level in the channel.

            :param audio_descriptions: The encoding information for output audio.
            :param avail_blanking: The settings for ad avail blanking.
            :param avail_configuration: The configuration settings for the ad avail handling.
            :param blackout_slate: The settings for the blackout slate.
            :param caption_descriptions: The encoding information for output captions.
            :param feature_activations: Settings to enable specific features.
            :param global_configuration: The configuration settings that apply to the entire channel.
            :param motion_graphics_configuration: Settings to enable and configure the motion graphics overlay feature in the channel.
            :param nielsen_configuration: The settings to configure Nielsen watermarks.
            :param output_groups: The settings for the output groups in the channel.
            :param timecode_config: Contains settings used to acquire and adjust timecode information from the inputs.
            :param video_descriptions: The encoding information for output videos.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                encoder_settings_property = medialive.CfnChannel.EncoderSettingsProperty(
                    audio_descriptions=[medialive.CfnChannel.AudioDescriptionProperty(
                        audio_normalization_settings=medialive.CfnChannel.AudioNormalizationSettingsProperty(
                            algorithm="algorithm",
                            algorithm_control="algorithmControl",
                            target_lkfs=123
                        ),
                        audio_selector_name="audioSelectorName",
                        audio_type="audioType",
                        audio_type_control="audioTypeControl",
                        audio_watermarking_settings=medialive.CfnChannel.AudioWatermarkSettingsProperty(
                            nielsen_watermarks_settings=medialive.CfnChannel.NielsenWatermarksSettingsProperty(
                                nielsen_cbet_settings=medialive.CfnChannel.NielsenCBETProperty(
                                    cbet_check_digit_string="cbetCheckDigitString",
                                    cbet_stepaside="cbetStepaside",
                                    csid="csid"
                                ),
                                nielsen_distribution_type="nielsenDistributionType",
                                nielsen_naes_ii_nw_settings=medialive.CfnChannel.NielsenNaesIiNwProperty(
                                    check_digit_string="checkDigitString",
                                    sid=123
                                )
                            )
                        ),
                        codec_settings=medialive.CfnChannel.AudioCodecSettingsProperty(
                            aac_settings=medialive.CfnChannel.AacSettingsProperty(
                                bitrate=123,
                                coding_mode="codingMode",
                                input_type="inputType",
                                profile="profile",
                                rate_control_mode="rateControlMode",
                                raw_format="rawFormat",
                                sample_rate=123,
                                spec="spec",
                                vbr_quality="vbrQuality"
                            ),
                            ac3_settings=medialive.CfnChannel.Ac3SettingsProperty(
                                bitrate=123,
                                bitstream_mode="bitstreamMode",
                                coding_mode="codingMode",
                                dialnorm=123,
                                drc_profile="drcProfile",
                                lfe_filter="lfeFilter",
                                metadata_control="metadataControl"
                            ),
                            eac3_settings=medialive.CfnChannel.Eac3SettingsProperty(
                                attenuation_control="attenuationControl",
                                bitrate=123,
                                bitstream_mode="bitstreamMode",
                                coding_mode="codingMode",
                                dc_filter="dcFilter",
                                dialnorm=123,
                                drc_line="drcLine",
                                drc_rf="drcRf",
                                lfe_control="lfeControl",
                                lfe_filter="lfeFilter",
                                lo_ro_center_mix_level=123,
                                lo_ro_surround_mix_level=123,
                                lt_rt_center_mix_level=123,
                                lt_rt_surround_mix_level=123,
                                metadata_control="metadataControl",
                                passthrough_control="passthroughControl",
                                phase_control="phaseControl",
                                stereo_downmix="stereoDownmix",
                                surround_ex_mode="surroundExMode",
                                surround_mode="surroundMode"
                            ),
                            mp2_settings=medialive.CfnChannel.Mp2SettingsProperty(
                                bitrate=123,
                                coding_mode="codingMode",
                                sample_rate=123
                            ),
                            pass_through_settings=medialive.CfnChannel.PassThroughSettingsProperty(),
                            wav_settings=medialive.CfnChannel.WavSettingsProperty(
                                bit_depth=123,
                                coding_mode="codingMode",
                                sample_rate=123
                            )
                        ),
                        language_code="languageCode",
                        language_code_control="languageCodeControl",
                        name="name",
                        remix_settings=medialive.CfnChannel.RemixSettingsProperty(
                            channel_mappings=[medialive.CfnChannel.AudioChannelMappingProperty(
                                input_channel_levels=[medialive.CfnChannel.InputChannelLevelProperty(
                                    gain=123,
                                    input_channel=123
                                )],
                                output_channel=123
                            )],
                            channels_in=123,
                            channels_out=123
                        ),
                        stream_name="streamName"
                    )],
                    avail_blanking=medialive.CfnChannel.AvailBlankingProperty(
                        avail_blanking_image=medialive.CfnChannel.InputLocationProperty(
                            password_param="passwordParam",
                            uri="uri",
                            username="username"
                        ),
                        state="state"
                    ),
                    avail_configuration=medialive.CfnChannel.AvailConfigurationProperty(
                        avail_settings=medialive.CfnChannel.AvailSettingsProperty(
                            scte35_splice_insert=medialive.CfnChannel.Scte35SpliceInsertProperty(
                                ad_avail_offset=123,
                                no_regional_blackout_flag="noRegionalBlackoutFlag",
                                web_delivery_allowed_flag="webDeliveryAllowedFlag"
                            ),
                            scte35_time_signal_apos=medialive.CfnChannel.Scte35TimeSignalAposProperty(
                                ad_avail_offset=123,
                                no_regional_blackout_flag="noRegionalBlackoutFlag",
                                web_delivery_allowed_flag="webDeliveryAllowedFlag"
                            )
                        )
                    ),
                    blackout_slate=medialive.CfnChannel.BlackoutSlateProperty(
                        blackout_slate_image=medialive.CfnChannel.InputLocationProperty(
                            password_param="passwordParam",
                            uri="uri",
                            username="username"
                        ),
                        network_end_blackout="networkEndBlackout",
                        network_end_blackout_image=medialive.CfnChannel.InputLocationProperty(
                            password_param="passwordParam",
                            uri="uri",
                            username="username"
                        ),
                        network_id="networkId",
                        state="state"
                    ),
                    caption_descriptions=[medialive.CfnChannel.CaptionDescriptionProperty(
                        caption_selector_name="captionSelectorName",
                        destination_settings=medialive.CfnChannel.CaptionDestinationSettingsProperty(
                            arib_destination_settings=medialive.CfnChannel.AribDestinationSettingsProperty(),
                            burn_in_destination_settings=medialive.CfnChannel.BurnInDestinationSettingsProperty(
                                alignment="alignment",
                                background_color="backgroundColor",
                                background_opacity=123,
                                font=medialive.CfnChannel.InputLocationProperty(
                                    password_param="passwordParam",
                                    uri="uri",
                                    username="username"
                                ),
                                font_color="fontColor",
                                font_opacity=123,
                                font_resolution=123,
                                font_size="fontSize",
                                outline_color="outlineColor",
                                outline_size=123,
                                shadow_color="shadowColor",
                                shadow_opacity=123,
                                shadow_xOffset=123,
                                shadow_yOffset=123,
                                teletext_grid_control="teletextGridControl",
                                x_position=123,
                                y_position=123
                            ),
                            dvb_sub_destination_settings=medialive.CfnChannel.DvbSubDestinationSettingsProperty(
                                alignment="alignment",
                                background_color="backgroundColor",
                                background_opacity=123,
                                font=medialive.CfnChannel.InputLocationProperty(
                                    password_param="passwordParam",
                                    uri="uri",
                                    username="username"
                                ),
                                font_color="fontColor",
                                font_opacity=123,
                                font_resolution=123,
                                font_size="fontSize",
                                outline_color="outlineColor",
                                outline_size=123,
                                shadow_color="shadowColor",
                                shadow_opacity=123,
                                shadow_xOffset=123,
                                shadow_yOffset=123,
                                teletext_grid_control="teletextGridControl",
                                x_position=123,
                                y_position=123
                            ),
                            ebu_tt_dDestination_settings=medialive.CfnChannel.EbuTtDDestinationSettingsProperty(
                                copyright_holder="copyrightHolder",
                                fill_line_gap="fillLineGap",
                                font_family="fontFamily",
                                style_control="styleControl"
                            ),
                            embedded_destination_settings=medialive.CfnChannel.EmbeddedDestinationSettingsProperty(),
                            embedded_plus_scte20_destination_settings=medialive.CfnChannel.EmbeddedPlusScte20DestinationSettingsProperty(),
                            rtmp_caption_info_destination_settings=medialive.CfnChannel.RtmpCaptionInfoDestinationSettingsProperty(),
                            scte20_plus_embedded_destination_settings=medialive.CfnChannel.Scte20PlusEmbeddedDestinationSettingsProperty(),
                            scte27_destination_settings=medialive.CfnChannel.Scte27DestinationSettingsProperty(),
                            smpte_tt_destination_settings=medialive.CfnChannel.SmpteTtDestinationSettingsProperty(),
                            teletext_destination_settings=medialive.CfnChannel.TeletextDestinationSettingsProperty(),
                            ttml_destination_settings=medialive.CfnChannel.TtmlDestinationSettingsProperty(
                                style_control="styleControl"
                            ),
                            webvtt_destination_settings=medialive.CfnChannel.WebvttDestinationSettingsProperty(
                                style_control="styleControl"
                            )
                        ),
                        language_code="languageCode",
                        language_description="languageDescription",
                        name="name"
                    )],
                    feature_activations=medialive.CfnChannel.FeatureActivationsProperty(
                        input_prepare_schedule_actions="inputPrepareScheduleActions"
                    ),
                    global_configuration=medialive.CfnChannel.GlobalConfigurationProperty(
                        initial_audio_gain=123,
                        input_end_action="inputEndAction",
                        input_loss_behavior=medialive.CfnChannel.InputLossBehaviorProperty(
                            black_frame_msec=123,
                            input_loss_image_color="inputLossImageColor",
                            input_loss_image_slate=medialive.CfnChannel.InputLocationProperty(
                                password_param="passwordParam",
                                uri="uri",
                                username="username"
                            ),
                            input_loss_image_type="inputLossImageType",
                            repeat_frame_msec=123
                        ),
                        output_locking_mode="outputLockingMode",
                        output_timing_source="outputTimingSource",
                        support_low_framerate_inputs="supportLowFramerateInputs"
                    ),
                    motion_graphics_configuration=medialive.CfnChannel.MotionGraphicsConfigurationProperty(
                        motion_graphics_insertion="motionGraphicsInsertion",
                        motion_graphics_settings=medialive.CfnChannel.MotionGraphicsSettingsProperty(
                            html_motion_graphics_settings=medialive.CfnChannel.HtmlMotionGraphicsSettingsProperty()
                        )
                    ),
                    nielsen_configuration=medialive.CfnChannel.NielsenConfigurationProperty(
                        distributor_id="distributorId",
                        nielsen_pcm_to_id3_tagging="nielsenPcmToId3Tagging"
                    ),
                    output_groups=[medialive.CfnChannel.OutputGroupProperty(
                        name="name",
                        output_group_settings=medialive.CfnChannel.OutputGroupSettingsProperty(
                            archive_group_settings=medialive.CfnChannel.ArchiveGroupSettingsProperty(
                                archive_cdn_settings=medialive.CfnChannel.ArchiveCdnSettingsProperty(
                                    archive_s3_settings=medialive.CfnChannel.ArchiveS3SettingsProperty(
                                        canned_acl="cannedAcl"
                                    )
                                ),
                                destination=medialive.CfnChannel.OutputLocationRefProperty(
                                    destination_ref_id="destinationRefId"
                                ),
                                rollover_interval=123
                            ),
                            frame_capture_group_settings=medialive.CfnChannel.FrameCaptureGroupSettingsProperty(
                                destination=medialive.CfnChannel.OutputLocationRefProperty(
                                    destination_ref_id="destinationRefId"
                                ),
                                frame_capture_cdn_settings=medialive.CfnChannel.FrameCaptureCdnSettingsProperty(
                                    frame_capture_s3_settings=medialive.CfnChannel.FrameCaptureS3SettingsProperty(
                                        canned_acl="cannedAcl"
                                    )
                                )
                            ),
                            hls_group_settings=medialive.CfnChannel.HlsGroupSettingsProperty(
                                ad_markers=["adMarkers"],
                                base_url_content="baseUrlContent",
                                base_url_content1="baseUrlContent1",
                                base_url_manifest="baseUrlManifest",
                                base_url_manifest1="baseUrlManifest1",
                                caption_language_mappings=[medialive.CfnChannel.CaptionLanguageMappingProperty(
                                    caption_channel=123,
                                    language_code="languageCode",
                                    language_description="languageDescription"
                                )],
                                caption_language_setting="captionLanguageSetting",
                                client_cache="clientCache",
                                codec_specification="codecSpecification",
                                constant_iv="constantIv",
                                destination=medialive.CfnChannel.OutputLocationRefProperty(
                                    destination_ref_id="destinationRefId"
                                ),
                                directory_structure="directoryStructure",
                                discontinuity_tags="discontinuityTags",
                                encryption_type="encryptionType",
                                hls_cdn_settings=medialive.CfnChannel.HlsCdnSettingsProperty(
                                    hls_akamai_settings=medialive.CfnChannel.HlsAkamaiSettingsProperty(
                                        connection_retry_interval=123,
                                        filecache_duration=123,
                                        http_transfer_mode="httpTransferMode",
                                        num_retries=123,
                                        restart_delay=123,
                                        salt="salt",
                                        token="token"
                                    ),
                                    hls_basic_put_settings=medialive.CfnChannel.HlsBasicPutSettingsProperty(
                                        connection_retry_interval=123,
                                        filecache_duration=123,
                                        num_retries=123,
                                        restart_delay=123
                                    ),
                                    hls_media_store_settings=medialive.CfnChannel.HlsMediaStoreSettingsProperty(
                                        connection_retry_interval=123,
                                        filecache_duration=123,
                                        media_store_storage_class="mediaStoreStorageClass",
                                        num_retries=123,
                                        restart_delay=123
                                    ),
                                    hls_s3_settings=medialive.CfnChannel.HlsS3SettingsProperty(
                                        canned_acl="cannedAcl"
                                    ),
                                    hls_webdav_settings=medialive.CfnChannel.HlsWebdavSettingsProperty(
                                        connection_retry_interval=123,
                                        filecache_duration=123,
                                        http_transfer_mode="httpTransferMode",
                                        num_retries=123,
                                        restart_delay=123
                                    )
                                ),
                                hls_id3_segment_tagging="hlsId3SegmentTagging",
                                i_frame_only_playlists="iFrameOnlyPlaylists",
                                incomplete_segment_behavior="incompleteSegmentBehavior",
                                index_nSegments=123,
                                input_loss_action="inputLossAction",
                                iv_in_manifest="ivInManifest",
                                iv_source="ivSource",
                                keep_segments=123,
                                key_format="keyFormat",
                                key_format_versions="keyFormatVersions",
                                key_provider_settings=medialive.CfnChannel.KeyProviderSettingsProperty(
                                    static_key_settings=medialive.CfnChannel.StaticKeySettingsProperty(
                                        key_provider_server=medialive.CfnChannel.InputLocationProperty(
                                            password_param="passwordParam",
                                            uri="uri",
                                            username="username"
                                        ),
                                        static_key_value="staticKeyValue"
                                    )
                                ),
                                manifest_compression="manifestCompression",
                                manifest_duration_format="manifestDurationFormat",
                                min_segment_length=123,
                                mode="mode",
                                output_selection="outputSelection",
                                program_date_time="programDateTime",
                                program_date_time_clock="programDateTimeClock",
                                program_date_time_period=123,
                                redundant_manifest="redundantManifest",
                                segmentation_mode="segmentationMode",
                                segment_length=123,
                                segments_per_subdirectory=123,
                                stream_inf_resolution="streamInfResolution",
                                timed_metadata_id3_frame="timedMetadataId3Frame",
                                timed_metadata_id3_period=123,
                                timestamp_delta_milliseconds=123,
                                ts_file_mode="tsFileMode"
                            ),
                            media_package_group_settings=medialive.CfnChannel.MediaPackageGroupSettingsProperty(
                                destination=medialive.CfnChannel.OutputLocationRefProperty(
                                    destination_ref_id="destinationRefId"
                                )
                            ),
                            ms_smooth_group_settings=medialive.CfnChannel.MsSmoothGroupSettingsProperty(
                                acquisition_point_id="acquisitionPointId",
                                audio_only_timecode_control="audioOnlyTimecodeControl",
                                certificate_mode="certificateMode",
                                connection_retry_interval=123,
                                destination=medialive.CfnChannel.OutputLocationRefProperty(
                                    destination_ref_id="destinationRefId"
                                ),
                                event_id="eventId",
                                event_id_mode="eventIdMode",
                                event_stop_behavior="eventStopBehavior",
                                filecache_duration=123,
                                fragment_length=123,
                                input_loss_action="inputLossAction",
                                num_retries=123,
                                restart_delay=123,
                                segmentation_mode="segmentationMode",
                                send_delay_ms=123,
                                sparse_track_type="sparseTrackType",
                                stream_manifest_behavior="streamManifestBehavior",
                                timestamp_offset="timestampOffset",
                                timestamp_offset_mode="timestampOffsetMode"
                            ),
                            multiplex_group_settings=medialive.CfnChannel.MultiplexGroupSettingsProperty(),
                            rtmp_group_settings=medialive.CfnChannel.RtmpGroupSettingsProperty(
                                ad_markers=["adMarkers"],
                                authentication_scheme="authenticationScheme",
                                cache_full_behavior="cacheFullBehavior",
                                cache_length=123,
                                caption_data="captionData",
                                input_loss_action="inputLossAction",
                                restart_delay=123
                            ),
                            udp_group_settings=medialive.CfnChannel.UdpGroupSettingsProperty(
                                input_loss_action="inputLossAction",
                                timed_metadata_id3_frame="timedMetadataId3Frame",
                                timed_metadata_id3_period=123
                            )
                        ),
                        outputs=[medialive.CfnChannel.OutputProperty(
                            audio_description_names=["audioDescriptionNames"],
                            caption_description_names=["captionDescriptionNames"],
                            output_name="outputName",
                            output_settings=medialive.CfnChannel.OutputSettingsProperty(
                                archive_output_settings=medialive.CfnChannel.ArchiveOutputSettingsProperty(
                                    container_settings=medialive.CfnChannel.ArchiveContainerSettingsProperty(
                                        m2_ts_settings=medialive.CfnChannel.M2tsSettingsProperty(
                                            absent_input_audio_behavior="absentInputAudioBehavior",
                                            arib="arib",
                                            arib_captions_pid="aribCaptionsPid",
                                            arib_captions_pid_control="aribCaptionsPidControl",
                                            audio_buffer_model="audioBufferModel",
                                            audio_frames_per_pes=123,
                                            audio_pids="audioPids",
                                            audio_stream_type="audioStreamType",
                                            bitrate=123,
                                            buffer_model="bufferModel",
                                            cc_descriptor="ccDescriptor",
                                            dvb_nit_settings=medialive.CfnChannel.DvbNitSettingsProperty(
                                                network_id=123,
                                                network_name="networkName",
                                                rep_interval=123
                                            ),
                                            dvb_sdt_settings=medialive.CfnChannel.DvbSdtSettingsProperty(
                                                output_sdt="outputSdt",
                                                rep_interval=123,
                                                service_name="serviceName",
                                                service_provider_name="serviceProviderName"
                                            ),
                                            dvb_sub_pids="dvbSubPids",
                                            dvb_tdt_settings=medialive.CfnChannel.DvbTdtSettingsProperty(
                                                rep_interval=123
                                            ),
                                            dvb_teletext_pid="dvbTeletextPid",
                                            ebif="ebif",
                                            ebp_audio_interval="ebpAudioInterval",
                                            ebp_lookahead_ms=123,
                                            ebp_placement="ebpPlacement",
                                            ecm_pid="ecmPid",
                                            es_rate_in_pes="esRateInPes",
                                            etv_platform_pid="etvPlatformPid",
                                            etv_signal_pid="etvSignalPid",
                                            fragment_time=123,
                                            klv="klv",
                                            klv_data_pids="klvDataPids",
                                            nielsen_id3_behavior="nielsenId3Behavior",
                                            null_packet_bitrate=123,
                                            pat_interval=123,
                                            pcr_control="pcrControl",
                                            pcr_period=123,
                                            pcr_pid="pcrPid",
                                            pmt_interval=123,
                                            pmt_pid="pmtPid",
                                            program_num=123,
                                            rate_mode="rateMode",
                                            scte27_pids="scte27Pids",
                                            scte35_control="scte35Control",
                                            scte35_pid="scte35Pid",
                                            segmentation_markers="segmentationMarkers",
                                            segmentation_style="segmentationStyle",
                                            segmentation_time=123,
                                            timed_metadata_behavior="timedMetadataBehavior",
                                            timed_metadata_pid="timedMetadataPid",
                                            transport_stream_id=123,
                                            video_pid="videoPid"
                                        ),
                                        raw_settings=medialive.CfnChannel.RawSettingsProperty()
                                    ),
                                    extension="extension",
                                    name_modifier="nameModifier"
                                ),
                                frame_capture_output_settings=medialive.CfnChannel.FrameCaptureOutputSettingsProperty(
                                    name_modifier="nameModifier"
                                ),
                                hls_output_settings=medialive.CfnChannel.HlsOutputSettingsProperty(
                                    h265_packaging_type="h265PackagingType",
                                    hls_settings=medialive.CfnChannel.HlsSettingsProperty(
                                        audio_only_hls_settings=medialive.CfnChannel.AudioOnlyHlsSettingsProperty(
                                            audio_group_id="audioGroupId",
                                            audio_only_image=medialive.CfnChannel.InputLocationProperty(
                                                password_param="passwordParam",
                                                uri="uri",
                                                username="username"
                                            ),
                                            audio_track_type="audioTrackType",
                                            segment_type="segmentType"
                                        ),
                                        fmp4_hls_settings=medialive.CfnChannel.Fmp4HlsSettingsProperty(
                                            audio_rendition_sets="audioRenditionSets",
                                            nielsen_id3_behavior="nielsenId3Behavior",
                                            timed_metadata_behavior="timedMetadataBehavior"
                                        ),
                                        frame_capture_hls_settings=medialive.CfnChannel.FrameCaptureHlsSettingsProperty(),
                                        standard_hls_settings=medialive.CfnChannel.StandardHlsSettingsProperty(
                                            audio_rendition_sets="audioRenditionSets",
                                            m3_u8_settings=medialive.CfnChannel.M3u8SettingsProperty(
                                                audio_frames_per_pes=123,
                                                audio_pids="audioPids",
                                                ecm_pid="ecmPid",
                                                nielsen_id3_behavior="nielsenId3Behavior",
                                                pat_interval=123,
                                                pcr_control="pcrControl",
                                                pcr_period=123,
                                                pcr_pid="pcrPid",
                                                pmt_interval=123,
                                                pmt_pid="pmtPid",
                                                program_num=123,
                                                scte35_behavior="scte35Behavior",
                                                scte35_pid="scte35Pid",
                                                timed_metadata_behavior="timedMetadataBehavior",
                                                timed_metadata_pid="timedMetadataPid",
                                                transport_stream_id=123,
                                                video_pid="videoPid"
                                            )
                                        )
                                    ),
                                    name_modifier="nameModifier",
                                    segment_modifier="segmentModifier"
                                ),
                                media_package_output_settings=medialive.CfnChannel.MediaPackageOutputSettingsProperty(),
                                ms_smooth_output_settings=medialive.CfnChannel.MsSmoothOutputSettingsProperty(
                                    h265_packaging_type="h265PackagingType",
                                    name_modifier="nameModifier"
                                ),
                                multiplex_output_settings=medialive.CfnChannel.MultiplexOutputSettingsProperty(
                                    destination=medialive.CfnChannel.OutputLocationRefProperty(
                                        destination_ref_id="destinationRefId"
                                    )
                                ),
                                rtmp_output_settings=medialive.CfnChannel.RtmpOutputSettingsProperty(
                                    certificate_mode="certificateMode",
                                    connection_retry_interval=123,
                                    destination=medialive.CfnChannel.OutputLocationRefProperty(
                                        destination_ref_id="destinationRefId"
                                    ),
                                    num_retries=123
                                ),
                                udp_output_settings=medialive.CfnChannel.UdpOutputSettingsProperty(
                                    buffer_msec=123,
                                    container_settings=medialive.CfnChannel.UdpContainerSettingsProperty(
                                        m2_ts_settings=medialive.CfnChannel.M2tsSettingsProperty(
                                            absent_input_audio_behavior="absentInputAudioBehavior",
                                            arib="arib",
                                            arib_captions_pid="aribCaptionsPid",
                                            arib_captions_pid_control="aribCaptionsPidControl",
                                            audio_buffer_model="audioBufferModel",
                                            audio_frames_per_pes=123,
                                            audio_pids="audioPids",
                                            audio_stream_type="audioStreamType",
                                            bitrate=123,
                                            buffer_model="bufferModel",
                                            cc_descriptor="ccDescriptor",
                                            dvb_nit_settings=medialive.CfnChannel.DvbNitSettingsProperty(
                                                network_id=123,
                                                network_name="networkName",
                                                rep_interval=123
                                            ),
                                            dvb_sdt_settings=medialive.CfnChannel.DvbSdtSettingsProperty(
                                                output_sdt="outputSdt",
                                                rep_interval=123,
                                                service_name="serviceName",
                                                service_provider_name="serviceProviderName"
                                            ),
                                            dvb_sub_pids="dvbSubPids",
                                            dvb_tdt_settings=medialive.CfnChannel.DvbTdtSettingsProperty(
                                                rep_interval=123
                                            ),
                                            dvb_teletext_pid="dvbTeletextPid",
                                            ebif="ebif",
                                            ebp_audio_interval="ebpAudioInterval",
                                            ebp_lookahead_ms=123,
                                            ebp_placement="ebpPlacement",
                                            ecm_pid="ecmPid",
                                            es_rate_in_pes="esRateInPes",
                                            etv_platform_pid="etvPlatformPid",
                                            etv_signal_pid="etvSignalPid",
                                            fragment_time=123,
                                            klv="klv",
                                            klv_data_pids="klvDataPids",
                                            nielsen_id3_behavior="nielsenId3Behavior",
                                            null_packet_bitrate=123,
                                            pat_interval=123,
                                            pcr_control="pcrControl",
                                            pcr_period=123,
                                            pcr_pid="pcrPid",
                                            pmt_interval=123,
                                            pmt_pid="pmtPid",
                                            program_num=123,
                                            rate_mode="rateMode",
                                            scte27_pids="scte27Pids",
                                            scte35_control="scte35Control",
                                            scte35_pid="scte35Pid",
                                            segmentation_markers="segmentationMarkers",
                                            segmentation_style="segmentationStyle",
                                            segmentation_time=123,
                                            timed_metadata_behavior="timedMetadataBehavior",
                                            timed_metadata_pid="timedMetadataPid",
                                            transport_stream_id=123,
                                            video_pid="videoPid"
                                        )
                                    ),
                                    destination=medialive.CfnChannel.OutputLocationRefProperty(
                                        destination_ref_id="destinationRefId"
                                    ),
                                    fec_output_settings=medialive.CfnChannel.FecOutputSettingsProperty(
                                        column_depth=123,
                                        include_fec="includeFec",
                                        row_length=123
                                    )
                                )
                            ),
                            video_description_name="videoDescriptionName"
                        )]
                    )],
                    timecode_config=medialive.CfnChannel.TimecodeConfigProperty(
                        source="source",
                        sync_threshold=123
                    ),
                    video_descriptions=[medialive.CfnChannel.VideoDescriptionProperty(
                        codec_settings=medialive.CfnChannel.VideoCodecSettingsProperty(
                            frame_capture_settings=medialive.CfnChannel.FrameCaptureSettingsProperty(
                                capture_interval=123,
                                capture_interval_units="captureIntervalUnits"
                            ),
                            h264_settings=medialive.CfnChannel.H264SettingsProperty(
                                adaptive_quantization="adaptiveQuantization",
                                afd_signaling="afdSignaling",
                                bitrate=123,
                                buf_fill_pct=123,
                                buf_size=123,
                                color_metadata="colorMetadata",
                                color_space_settings=medialive.CfnChannel.H264ColorSpaceSettingsProperty(
                                    color_space_passthrough_settings=medialive.CfnChannel.ColorSpacePassthroughSettingsProperty(),
                                    rec601_settings=medialive.CfnChannel.Rec601SettingsProperty(),
                                    rec709_settings=medialive.CfnChannel.Rec709SettingsProperty()
                                ),
                                entropy_encoding="entropyEncoding",
                                filter_settings=medialive.CfnChannel.H264FilterSettingsProperty(
                                    temporal_filter_settings=medialive.CfnChannel.TemporalFilterSettingsProperty(
                                        post_filter_sharpening="postFilterSharpening",
                                        strength="strength"
                                    )
                                ),
                                fixed_afd="fixedAfd",
                                flicker_aq="flickerAq",
                                force_field_pictures="forceFieldPictures",
                                framerate_control="framerateControl",
                                framerate_denominator=123,
                                framerate_numerator=123,
                                gop_bReference="gopBReference",
                                gop_closed_cadence=123,
                                gop_num_bFrames=123,
                                gop_size=123,
                                gop_size_units="gopSizeUnits",
                                level="level",
                                look_ahead_rate_control="lookAheadRateControl",
                                max_bitrate=123,
                                min_iInterval=123,
                                num_ref_frames=123,
                                par_control="parControl",
                                par_denominator=123,
                                par_numerator=123,
                                profile="profile",
                                quality_level="qualityLevel",
                                qvbr_quality_level=123,
                                rate_control_mode="rateControlMode",
                                scan_type="scanType",
                                scene_change_detect="sceneChangeDetect",
                                slices=123,
                                softness=123,
                                spatial_aq="spatialAq",
                                subgop_length="subgopLength",
                                syntax="syntax",
                                temporal_aq="temporalAq",
                                timecode_insertion="timecodeInsertion"
                            ),
                            h265_settings=medialive.CfnChannel.H265SettingsProperty(
                                adaptive_quantization="adaptiveQuantization",
                                afd_signaling="afdSignaling",
                                alternative_transfer_function="alternativeTransferFunction",
                                bitrate=123,
                                buf_size=123,
                                color_metadata="colorMetadata",
                                color_space_settings=medialive.CfnChannel.H265ColorSpaceSettingsProperty(
                                    color_space_passthrough_settings=medialive.CfnChannel.ColorSpacePassthroughSettingsProperty(),
                                    hdr10_settings=medialive.CfnChannel.Hdr10SettingsProperty(
                                        max_cll=123,
                                        max_fall=123
                                    ),
                                    rec601_settings=medialive.CfnChannel.Rec601SettingsProperty(),
                                    rec709_settings=medialive.CfnChannel.Rec709SettingsProperty()
                                ),
                                filter_settings=medialive.CfnChannel.H265FilterSettingsProperty(
                                    temporal_filter_settings=medialive.CfnChannel.TemporalFilterSettingsProperty(
                                        post_filter_sharpening="postFilterSharpening",
                                        strength="strength"
                                    )
                                ),
                                fixed_afd="fixedAfd",
                                flicker_aq="flickerAq",
                                framerate_denominator=123,
                                framerate_numerator=123,
                                gop_closed_cadence=123,
                                gop_size=123,
                                gop_size_units="gopSizeUnits",
                                level="level",
                                look_ahead_rate_control="lookAheadRateControl",
                                max_bitrate=123,
                                min_iInterval=123,
                                par_denominator=123,
                                par_numerator=123,
                                profile="profile",
                                qvbr_quality_level=123,
                                rate_control_mode="rateControlMode",
                                scan_type="scanType",
                                scene_change_detect="sceneChangeDetect",
                                slices=123,
                                tier="tier",
                                timecode_insertion="timecodeInsertion"
                            ),
                            mpeg2_settings=medialive.CfnChannel.Mpeg2SettingsProperty(
                                adaptive_quantization="adaptiveQuantization",
                                afd_signaling="afdSignaling",
                                color_metadata="colorMetadata",
                                color_space="colorSpace",
                                display_aspect_ratio="displayAspectRatio",
                                filter_settings=medialive.CfnChannel.Mpeg2FilterSettingsProperty(
                                    temporal_filter_settings=medialive.CfnChannel.TemporalFilterSettingsProperty(
                                        post_filter_sharpening="postFilterSharpening",
                                        strength="strength"
                                    )
                                ),
                                fixed_afd="fixedAfd",
                                framerate_denominator=123,
                                framerate_numerator=123,
                                gop_closed_cadence=123,
                                gop_num_bFrames=123,
                                gop_size=123,
                                gop_size_units="gopSizeUnits",
                                scan_type="scanType",
                                subgop_length="subgopLength",
                                timecode_insertion="timecodeInsertion"
                            )
                        ),
                        height=123,
                        name="name",
                        respond_to_afd="respondToAfd",
                        scaling_behavior="scalingBehavior",
                        sharpness=123,
                        width=123
                    )]
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if audio_descriptions is not None:
                self._values["audio_descriptions"] = audio_descriptions
            if avail_blanking is not None:
                self._values["avail_blanking"] = avail_blanking
            if avail_configuration is not None:
                self._values["avail_configuration"] = avail_configuration
            if blackout_slate is not None:
                self._values["blackout_slate"] = blackout_slate
            if caption_descriptions is not None:
                self._values["caption_descriptions"] = caption_descriptions
            if feature_activations is not None:
                self._values["feature_activations"] = feature_activations
            if global_configuration is not None:
                self._values["global_configuration"] = global_configuration
            if motion_graphics_configuration is not None:
                self._values["motion_graphics_configuration"] = motion_graphics_configuration
            if nielsen_configuration is not None:
                self._values["nielsen_configuration"] = nielsen_configuration
            if output_groups is not None:
                self._values["output_groups"] = output_groups
            if timecode_config is not None:
                self._values["timecode_config"] = timecode_config
            if video_descriptions is not None:
                self._values["video_descriptions"] = video_descriptions

        @builtins.property
        def audio_descriptions(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioDescriptionProperty"]]]]:
            '''The encoding information for output audio.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-audiodescriptions
            '''
            result = self._values.get("audio_descriptions")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioDescriptionProperty"]]]], result)

        @builtins.property
        def avail_blanking(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AvailBlankingProperty"]]:
            '''The settings for ad avail blanking.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-availblanking
            '''
            result = self._values.get("avail_blanking")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AvailBlankingProperty"]], result)

        @builtins.property
        def avail_configuration(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AvailConfigurationProperty"]]:
            '''The configuration settings for the ad avail handling.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-availconfiguration
            '''
            result = self._values.get("avail_configuration")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AvailConfigurationProperty"]], result)

        @builtins.property
        def blackout_slate(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.BlackoutSlateProperty"]]:
            '''The settings for the blackout slate.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-blackoutslate
            '''
            result = self._values.get("blackout_slate")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.BlackoutSlateProperty"]], result)

        @builtins.property
        def caption_descriptions(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.CaptionDescriptionProperty"]]]]:
            '''The encoding information for output captions.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-captiondescriptions
            '''
            result = self._values.get("caption_descriptions")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.CaptionDescriptionProperty"]]]], result)

        @builtins.property
        def feature_activations(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.FeatureActivationsProperty"]]:
            '''Settings to enable specific features.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-featureactivations
            '''
            result = self._values.get("feature_activations")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.FeatureActivationsProperty"]], result)

        @builtins.property
        def global_configuration(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.GlobalConfigurationProperty"]]:
            '''The configuration settings that apply to the entire channel.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-globalconfiguration
            '''
            result = self._values.get("global_configuration")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.GlobalConfigurationProperty"]], result)

        @builtins.property
        def motion_graphics_configuration(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.MotionGraphicsConfigurationProperty"]]:
            '''Settings to enable and configure the motion graphics overlay feature in the channel.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-motiongraphicsconfiguration
            '''
            result = self._values.get("motion_graphics_configuration")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.MotionGraphicsConfigurationProperty"]], result)

        @builtins.property
        def nielsen_configuration(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.NielsenConfigurationProperty"]]:
            '''The settings to configure Nielsen watermarks.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-nielsenconfiguration
            '''
            result = self._values.get("nielsen_configuration")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.NielsenConfigurationProperty"]], result)

        @builtins.property
        def output_groups(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputGroupProperty"]]]]:
            '''The settings for the output groups in the channel.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-outputgroups
            '''
            result = self._values.get("output_groups")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputGroupProperty"]]]], result)

        @builtins.property
        def timecode_config(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.TimecodeConfigProperty"]]:
            '''Contains settings used to acquire and adjust timecode information from the inputs.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-timecodeconfig
            '''
            result = self._values.get("timecode_config")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.TimecodeConfigProperty"]], result)

        @builtins.property
        def video_descriptions(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.VideoDescriptionProperty"]]]]:
            '''The encoding information for output videos.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-videodescriptions
            '''
            result = self._values.get("video_descriptions")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.VideoDescriptionProperty"]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "EncoderSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.FailoverConditionProperty",
        jsii_struct_bases=[],
        name_mapping={"failover_condition_settings": "failoverConditionSettings"},
    )
    class FailoverConditionProperty:
        def __init__(
            self,
            *,
            failover_condition_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.FailoverConditionSettingsProperty"]] = None,
        ) -> None:
            '''Failover Condition settings. There can be multiple failover conditions inside AutomaticInputFailoverSettings.

            The parent of this entity is AutomaticInputFailoverSettings.

            :param failover_condition_settings: Settings for a specific failover condition.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-failovercondition.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                failover_condition_property = medialive.CfnChannel.FailoverConditionProperty(
                    failover_condition_settings=medialive.CfnChannel.FailoverConditionSettingsProperty(
                        audio_silence_settings=medialive.CfnChannel.AudioSilenceFailoverSettingsProperty(
                            audio_selector_name="audioSelectorName",
                            audio_silence_threshold_msec=123
                        ),
                        input_loss_settings=medialive.CfnChannel.InputLossFailoverSettingsProperty(
                            input_loss_threshold_msec=123
                        ),
                        video_black_settings=medialive.CfnChannel.VideoBlackFailoverSettingsProperty(
                            black_detect_threshold=123,
                            video_black_threshold_msec=123
                        )
                    )
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if failover_condition_settings is not None:
                self._values["failover_condition_settings"] = failover_condition_settings

        @builtins.property
        def failover_condition_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.FailoverConditionSettingsProperty"]]:
            '''Settings for a specific failover condition.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-failovercondition.html#cfn-medialive-channel-failovercondition-failoverconditionsettings
            '''
            result = self._values.get("failover_condition_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.FailoverConditionSettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FailoverConditionProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.FailoverConditionSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "audio_silence_settings": "audioSilenceSettings",
            "input_loss_settings": "inputLossSettings",
            "video_black_settings": "videoBlackSettings",
        },
    )
    class FailoverConditionSettingsProperty:
        def __init__(
            self,
            *,
            audio_silence_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioSilenceFailoverSettingsProperty"]] = None,
            input_loss_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputLossFailoverSettingsProperty"]] = None,
            video_black_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.VideoBlackFailoverSettingsProperty"]] = None,
        ) -> None:
            '''Settings for one failover condition.

            The parent of this entity is FailoverCondition.

            :param audio_silence_settings: MediaLive will perform a failover if the specified audio selector is silent for the specified period.
            :param input_loss_settings: MediaLive will perform a failover if content is not detected in this input for the specified period.
            :param video_black_settings: MediaLive will perform a failover if content is considered black for the specified period.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-failoverconditionsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                failover_condition_settings_property = medialive.CfnChannel.FailoverConditionSettingsProperty(
                    audio_silence_settings=medialive.CfnChannel.AudioSilenceFailoverSettingsProperty(
                        audio_selector_name="audioSelectorName",
                        audio_silence_threshold_msec=123
                    ),
                    input_loss_settings=medialive.CfnChannel.InputLossFailoverSettingsProperty(
                        input_loss_threshold_msec=123
                    ),
                    video_black_settings=medialive.CfnChannel.VideoBlackFailoverSettingsProperty(
                        black_detect_threshold=123,
                        video_black_threshold_msec=123
                    )
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if audio_silence_settings is not None:
                self._values["audio_silence_settings"] = audio_silence_settings
            if input_loss_settings is not None:
                self._values["input_loss_settings"] = input_loss_settings
            if video_black_settings is not None:
                self._values["video_black_settings"] = video_black_settings

        @builtins.property
        def audio_silence_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioSilenceFailoverSettingsProperty"]]:
            '''MediaLive will perform a failover if the specified audio selector is silent for the specified period.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-failoverconditionsettings.html#cfn-medialive-channel-failoverconditionsettings-audiosilencesettings
            '''
            result = self._values.get("audio_silence_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioSilenceFailoverSettingsProperty"]], result)

        @builtins.property
        def input_loss_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputLossFailoverSettingsProperty"]]:
            '''MediaLive will perform a failover if content is not detected in this input for the specified period.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-failoverconditionsettings.html#cfn-medialive-channel-failoverconditionsettings-inputlosssettings
            '''
            result = self._values.get("input_loss_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputLossFailoverSettingsProperty"]], result)

        @builtins.property
        def video_black_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.VideoBlackFailoverSettingsProperty"]]:
            '''MediaLive will perform a failover if content is considered black for the specified period.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-failoverconditionsettings.html#cfn-medialive-channel-failoverconditionsettings-videoblacksettings
            '''
            result = self._values.get("video_black_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.VideoBlackFailoverSettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FailoverConditionSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.FeatureActivationsProperty",
        jsii_struct_bases=[],
        name_mapping={"input_prepare_schedule_actions": "inputPrepareScheduleActions"},
    )
    class FeatureActivationsProperty:
        def __init__(
            self,
            *,
            input_prepare_schedule_actions: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Settings to enable specific features. You can't configure these features until you have enabled them in the channel.

            The parent of this entity is EncoderSettings.

            :param input_prepare_schedule_actions: Enables the Input Prepare feature. You can create Input Prepare actions in the schedule only if this feature is enabled. If you disable the feature on an existing schedule, make sure that you first delete all input prepare actions from the schedule.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-featureactivations.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                feature_activations_property = medialive.CfnChannel.FeatureActivationsProperty(
                    input_prepare_schedule_actions="inputPrepareScheduleActions"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if input_prepare_schedule_actions is not None:
                self._values["input_prepare_schedule_actions"] = input_prepare_schedule_actions

        @builtins.property
        def input_prepare_schedule_actions(self) -> typing.Optional[builtins.str]:
            '''Enables the Input Prepare feature.

            You can create Input Prepare actions in the schedule only if this feature is enabled.
            If you disable the feature on an existing schedule, make sure that you first delete all input prepare actions from the schedule.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-featureactivations.html#cfn-medialive-channel-featureactivations-inputpreparescheduleactions
            '''
            result = self._values.get("input_prepare_schedule_actions")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FeatureActivationsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.FecOutputSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "column_depth": "columnDepth",
            "include_fec": "includeFec",
            "row_length": "rowLength",
        },
    )
    class FecOutputSettingsProperty:
        def __init__(
            self,
            *,
            column_depth: typing.Optional[jsii.Number] = None,
            include_fec: typing.Optional[builtins.str] = None,
            row_length: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''The settings for FEC.

            The parent of this entity is UdpOutputSettings.

            :param column_depth: The parameter D from SMPTE 2022-1. The height of the FEC protection matrix. The number of transport stream packets per column error correction packet. The number must be between 4 and 20, inclusive.
            :param include_fec: Enables column only or column and row-based FEC.
            :param row_length: The parameter L from SMPTE 2022-1. The width of the FEC protection matrix. Must be between 1 and 20, inclusive. If only Column FEC is used, then larger values increase robustness. If Row FEC is used, then this is the number of transport stream packets per row error correction packet, and the value must be between 4 and 20, inclusive, if includeFec is columnAndRow. If includeFec is column, this value must be 1 to 20, inclusive.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-fecoutputsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                fec_output_settings_property = medialive.CfnChannel.FecOutputSettingsProperty(
                    column_depth=123,
                    include_fec="includeFec",
                    row_length=123
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if column_depth is not None:
                self._values["column_depth"] = column_depth
            if include_fec is not None:
                self._values["include_fec"] = include_fec
            if row_length is not None:
                self._values["row_length"] = row_length

        @builtins.property
        def column_depth(self) -> typing.Optional[jsii.Number]:
            '''The parameter D from SMPTE 2022-1.

            The height of the FEC protection matrix. The number of transport stream packets per column error correction packet. The number must be between 4 and 20, inclusive.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-fecoutputsettings.html#cfn-medialive-channel-fecoutputsettings-columndepth
            '''
            result = self._values.get("column_depth")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def include_fec(self) -> typing.Optional[builtins.str]:
            '''Enables column only or column and row-based FEC.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-fecoutputsettings.html#cfn-medialive-channel-fecoutputsettings-includefec
            '''
            result = self._values.get("include_fec")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def row_length(self) -> typing.Optional[jsii.Number]:
            '''The parameter L from SMPTE 2022-1.

            The width of the FEC protection matrix. Must be between 1 and 20, inclusive. If only Column FEC is used, then larger values increase robustness. If Row FEC is used, then this is the number of transport stream packets per row error correction packet, and the value must be between 4 and 20, inclusive, if includeFec is columnAndRow. If includeFec is column, this value must be 1 to 20, inclusive.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-fecoutputsettings.html#cfn-medialive-channel-fecoutputsettings-rowlength
            '''
            result = self._values.get("row_length")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FecOutputSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.Fmp4HlsSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "audio_rendition_sets": "audioRenditionSets",
            "nielsen_id3_behavior": "nielsenId3Behavior",
            "timed_metadata_behavior": "timedMetadataBehavior",
        },
    )
    class Fmp4HlsSettingsProperty:
        def __init__(
            self,
            *,
            audio_rendition_sets: typing.Optional[builtins.str] = None,
            nielsen_id3_behavior: typing.Optional[builtins.str] = None,
            timed_metadata_behavior: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Settings for the fMP4 containers.

            The parent of this entity is HlsSettings.

            :param audio_rendition_sets: List all the audio groups that are used with the video output stream. Input all the audio GROUP-IDs that are associated to the video, separate by ','.
            :param nielsen_id3_behavior: If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an equivalent ID3 tag will be inserted in the output.
            :param timed_metadata_behavior: When set to passthrough, timed metadata is passed through from input to output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-fmp4hlssettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                fmp4_hls_settings_property = medialive.CfnChannel.Fmp4HlsSettingsProperty(
                    audio_rendition_sets="audioRenditionSets",
                    nielsen_id3_behavior="nielsenId3Behavior",
                    timed_metadata_behavior="timedMetadataBehavior"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if audio_rendition_sets is not None:
                self._values["audio_rendition_sets"] = audio_rendition_sets
            if nielsen_id3_behavior is not None:
                self._values["nielsen_id3_behavior"] = nielsen_id3_behavior
            if timed_metadata_behavior is not None:
                self._values["timed_metadata_behavior"] = timed_metadata_behavior

        @builtins.property
        def audio_rendition_sets(self) -> typing.Optional[builtins.str]:
            '''List all the audio groups that are used with the video output stream.

            Input all the audio GROUP-IDs that are associated to the video, separate by ','.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-fmp4hlssettings.html#cfn-medialive-channel-fmp4hlssettings-audiorenditionsets
            '''
            result = self._values.get("audio_rendition_sets")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def nielsen_id3_behavior(self) -> typing.Optional[builtins.str]:
            '''If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an equivalent ID3 tag will be inserted in the output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-fmp4hlssettings.html#cfn-medialive-channel-fmp4hlssettings-nielsenid3behavior
            '''
            result = self._values.get("nielsen_id3_behavior")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def timed_metadata_behavior(self) -> typing.Optional[builtins.str]:
            '''When set to passthrough, timed metadata is passed through from input to output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-fmp4hlssettings.html#cfn-medialive-channel-fmp4hlssettings-timedmetadatabehavior
            '''
            result = self._values.get("timed_metadata_behavior")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "Fmp4HlsSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.FrameCaptureCdnSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"frame_capture_s3_settings": "frameCaptureS3Settings"},
    )
    class FrameCaptureCdnSettingsProperty:
        def __init__(
            self,
            *,
            frame_capture_s3_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.FrameCaptureS3SettingsProperty"]] = None,
        ) -> None:
            '''Settings to configure the destination of a Frame Capture output.

            The parent of this entity is FrameCaptureGroupSettings.

            :param frame_capture_s3_settings: Sets up Amazon S3 as the destination for this Frame Capture output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecapturecdnsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                frame_capture_cdn_settings_property = medialive.CfnChannel.FrameCaptureCdnSettingsProperty(
                    frame_capture_s3_settings=medialive.CfnChannel.FrameCaptureS3SettingsProperty(
                        canned_acl="cannedAcl"
                    )
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if frame_capture_s3_settings is not None:
                self._values["frame_capture_s3_settings"] = frame_capture_s3_settings

        @builtins.property
        def frame_capture_s3_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.FrameCaptureS3SettingsProperty"]]:
            '''Sets up Amazon S3 as the destination for this Frame Capture output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecapturecdnsettings.html#cfn-medialive-channel-framecapturecdnsettings-framecaptures3settings
            '''
            result = self._values.get("frame_capture_s3_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.FrameCaptureS3SettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FrameCaptureCdnSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.FrameCaptureGroupSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "destination": "destination",
            "frame_capture_cdn_settings": "frameCaptureCdnSettings",
        },
    )
    class FrameCaptureGroupSettingsProperty:
        def __init__(
            self,
            *,
            destination: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputLocationRefProperty"]] = None,
            frame_capture_cdn_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.FrameCaptureCdnSettingsProperty"]] = None,
        ) -> None:
            '''The settings for a frame capture output group.

            The parent of this entity is OutputGroupSettings.

            :param destination: The destination for the frame capture files. The destination is either the URI for an Amazon S3 bucket and object, plus a file name prefix (for example, s3ssl://sportsDelivery/highlights/20180820/curling_) or the URI for a MediaStore container, plus a file name prefix (for example, mediastoressl://sportsDelivery/20180820/curling_). The final file names consist of the prefix from the destination field (for example, "curling_") + name modifier + the counter (5 digits, starting from 00001) + extension (which is always .jpg). For example, curlingLow.00001.jpg.
            :param frame_capture_cdn_settings: Settings to configure the destination of a Frame Capture output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecapturegroupsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                frame_capture_group_settings_property = medialive.CfnChannel.FrameCaptureGroupSettingsProperty(
                    destination=medialive.CfnChannel.OutputLocationRefProperty(
                        destination_ref_id="destinationRefId"
                    ),
                    frame_capture_cdn_settings=medialive.CfnChannel.FrameCaptureCdnSettingsProperty(
                        frame_capture_s3_settings=medialive.CfnChannel.FrameCaptureS3SettingsProperty(
                            canned_acl="cannedAcl"
                        )
                    )
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if destination is not None:
                self._values["destination"] = destination
            if frame_capture_cdn_settings is not None:
                self._values["frame_capture_cdn_settings"] = frame_capture_cdn_settings

        @builtins.property
        def destination(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputLocationRefProperty"]]:
            '''The destination for the frame capture files.

            The destination is either the URI for an Amazon S3 bucket and object, plus a file name prefix (for example, s3ssl://sportsDelivery/highlights/20180820/curling_) or the URI for a MediaStore container, plus a file name prefix (for example, mediastoressl://sportsDelivery/20180820/curling_). The final file names consist of the prefix from the destination field (for example, "curling_") + name modifier + the counter (5 digits, starting from 00001) + extension (which is always .jpg). For example, curlingLow.00001.jpg.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecapturegroupsettings.html#cfn-medialive-channel-framecapturegroupsettings-destination
            '''
            result = self._values.get("destination")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputLocationRefProperty"]], result)

        @builtins.property
        def frame_capture_cdn_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.FrameCaptureCdnSettingsProperty"]]:
            '''Settings to configure the destination of a Frame Capture output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecapturegroupsettings.html#cfn-medialive-channel-framecapturegroupsettings-framecapturecdnsettings
            '''
            result = self._values.get("frame_capture_cdn_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.FrameCaptureCdnSettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FrameCaptureGroupSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.FrameCaptureHlsSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={},
    )
    class FrameCaptureHlsSettingsProperty:
        def __init__(self) -> None:
            '''Settings for a frame capture output in an HLS output group.

            The parent of this entity is HlsSettings.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecapturehlssettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                frame_capture_hls_settings_property = medialive.CfnChannel.FrameCaptureHlsSettingsProperty()
            '''
            self._values: typing.Dict[str, typing.Any] = {}

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FrameCaptureHlsSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.FrameCaptureOutputSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"name_modifier": "nameModifier"},
    )
    class FrameCaptureOutputSettingsProperty:
        def __init__(
            self,
            *,
            name_modifier: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The frame capture output settings.

            The parent of this entity is OutputSettings.

            :param name_modifier: Required if the output group contains more than one output. This modifier forms part of the output file name.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecaptureoutputsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                frame_capture_output_settings_property = medialive.CfnChannel.FrameCaptureOutputSettingsProperty(
                    name_modifier="nameModifier"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if name_modifier is not None:
                self._values["name_modifier"] = name_modifier

        @builtins.property
        def name_modifier(self) -> typing.Optional[builtins.str]:
            '''Required if the output group contains more than one output.

            This modifier forms part of the output file name.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecaptureoutputsettings.html#cfn-medialive-channel-framecaptureoutputsettings-namemodifier
            '''
            result = self._values.get("name_modifier")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FrameCaptureOutputSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.FrameCaptureS3SettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"canned_acl": "cannedAcl"},
    )
    class FrameCaptureS3SettingsProperty:
        def __init__(self, *, canned_acl: typing.Optional[builtins.str] = None) -> None:
            '''Sets up Amazon S3 as the destination for this Frame Capture output.

            The parent of this entity is FrameCaptureCdnSettings.

            :param canned_acl: Specify the canned ACL to apply to each S3 request. Defaults to none.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecaptures3settings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                frame_capture_s3_settings_property = medialive.CfnChannel.FrameCaptureS3SettingsProperty(
                    canned_acl="cannedAcl"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if canned_acl is not None:
                self._values["canned_acl"] = canned_acl

        @builtins.property
        def canned_acl(self) -> typing.Optional[builtins.str]:
            '''Specify the canned ACL to apply to each S3 request.

            Defaults to none.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecaptures3settings.html#cfn-medialive-channel-framecaptures3settings-cannedacl
            '''
            result = self._values.get("canned_acl")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FrameCaptureS3SettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.FrameCaptureSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "capture_interval": "captureInterval",
            "capture_interval_units": "captureIntervalUnits",
        },
    )
    class FrameCaptureSettingsProperty:
        def __init__(
            self,
            *,
            capture_interval: typing.Optional[jsii.Number] = None,
            capture_interval_units: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The frame capture settings.

            The parent of this entity is VideoCodecSettings.

            :param capture_interval: The frequency, in seconds, for capturing frames for inclusion in the output. For example, "10" means capture a frame every 10 seconds.
            :param capture_interval_units: Unit for the frame capture interval.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecapturesettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                frame_capture_settings_property = medialive.CfnChannel.FrameCaptureSettingsProperty(
                    capture_interval=123,
                    capture_interval_units="captureIntervalUnits"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if capture_interval is not None:
                self._values["capture_interval"] = capture_interval
            if capture_interval_units is not None:
                self._values["capture_interval_units"] = capture_interval_units

        @builtins.property
        def capture_interval(self) -> typing.Optional[jsii.Number]:
            '''The frequency, in seconds, for capturing frames for inclusion in the output.

            For example, "10" means capture a frame every 10 seconds.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecapturesettings.html#cfn-medialive-channel-framecapturesettings-captureinterval
            '''
            result = self._values.get("capture_interval")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def capture_interval_units(self) -> typing.Optional[builtins.str]:
            '''Unit for the frame capture interval.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecapturesettings.html#cfn-medialive-channel-framecapturesettings-captureintervalunits
            '''
            result = self._values.get("capture_interval_units")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "FrameCaptureSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.GlobalConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "initial_audio_gain": "initialAudioGain",
            "input_end_action": "inputEndAction",
            "input_loss_behavior": "inputLossBehavior",
            "output_locking_mode": "outputLockingMode",
            "output_timing_source": "outputTimingSource",
            "support_low_framerate_inputs": "supportLowFramerateInputs",
        },
    )
    class GlobalConfigurationProperty:
        def __init__(
            self,
            *,
            initial_audio_gain: typing.Optional[jsii.Number] = None,
            input_end_action: typing.Optional[builtins.str] = None,
            input_loss_behavior: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputLossBehaviorProperty"]] = None,
            output_locking_mode: typing.Optional[builtins.str] = None,
            output_timing_source: typing.Optional[builtins.str] = None,
            support_low_framerate_inputs: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The configuration settings that apply to the entire channel.

            The parent of this entity is EncoderSettings.

            :param initial_audio_gain: The value to set the initial audio gain for the channel.
            :param input_end_action: Indicates the action to take when the current input completes (for example, end-of-file). When switchAndLoopInputs is configured, MediaLive restarts at the beginning of the first input. When "none" is configured, MediaLive transcodes either black, a solid color, or a user-specified slate images per the "Input Loss Behavior" configuration until the next input switch occurs (which is controlled through the Channel Schedule API).
            :param input_loss_behavior: The settings for system actions when the input is lost.
            :param output_locking_mode: Indicates how MediaLive pipelines are synchronized. PIPELINELOCKING - MediaLive attempts to synchronize the output of each pipeline to the other. EPOCHLOCKING - MediaLive attempts to synchronize the output of each pipeline to the Unix epoch.
            :param output_timing_source: Indicates whether the rate of frames emitted by the Live encoder should be paced by its system clock (which optionally might be locked to another source through NTP) or should be locked to the clock of the source that is providing the input stream.
            :param support_low_framerate_inputs: Adjusts the video input buffer for streams with very low video frame rates. This is commonly set to enabled for music channels with less than one video frame per second.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-globalconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                global_configuration_property = medialive.CfnChannel.GlobalConfigurationProperty(
                    initial_audio_gain=123,
                    input_end_action="inputEndAction",
                    input_loss_behavior=medialive.CfnChannel.InputLossBehaviorProperty(
                        black_frame_msec=123,
                        input_loss_image_color="inputLossImageColor",
                        input_loss_image_slate=medialive.CfnChannel.InputLocationProperty(
                            password_param="passwordParam",
                            uri="uri",
                            username="username"
                        ),
                        input_loss_image_type="inputLossImageType",
                        repeat_frame_msec=123
                    ),
                    output_locking_mode="outputLockingMode",
                    output_timing_source="outputTimingSource",
                    support_low_framerate_inputs="supportLowFramerateInputs"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if initial_audio_gain is not None:
                self._values["initial_audio_gain"] = initial_audio_gain
            if input_end_action is not None:
                self._values["input_end_action"] = input_end_action
            if input_loss_behavior is not None:
                self._values["input_loss_behavior"] = input_loss_behavior
            if output_locking_mode is not None:
                self._values["output_locking_mode"] = output_locking_mode
            if output_timing_source is not None:
                self._values["output_timing_source"] = output_timing_source
            if support_low_framerate_inputs is not None:
                self._values["support_low_framerate_inputs"] = support_low_framerate_inputs

        @builtins.property
        def initial_audio_gain(self) -> typing.Optional[jsii.Number]:
            '''The value to set the initial audio gain for the channel.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-globalconfiguration.html#cfn-medialive-channel-globalconfiguration-initialaudiogain
            '''
            result = self._values.get("initial_audio_gain")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def input_end_action(self) -> typing.Optional[builtins.str]:
            '''Indicates the action to take when the current input completes (for example, end-of-file).

            When switchAndLoopInputs is configured, MediaLive restarts at the beginning of the first input. When "none" is configured, MediaLive transcodes either black, a solid color, or a user-specified slate images per the "Input Loss Behavior" configuration until the next input switch occurs (which is controlled through the Channel Schedule API).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-globalconfiguration.html#cfn-medialive-channel-globalconfiguration-inputendaction
            '''
            result = self._values.get("input_end_action")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def input_loss_behavior(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputLossBehaviorProperty"]]:
            '''The settings for system actions when the input is lost.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-globalconfiguration.html#cfn-medialive-channel-globalconfiguration-inputlossbehavior
            '''
            result = self._values.get("input_loss_behavior")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputLossBehaviorProperty"]], result)

        @builtins.property
        def output_locking_mode(self) -> typing.Optional[builtins.str]:
            '''Indicates how MediaLive pipelines are synchronized.

            PIPELINELOCKING - MediaLive attempts to synchronize the output of each pipeline to the other. EPOCHLOCKING - MediaLive attempts to synchronize the output of each pipeline to the Unix epoch.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-globalconfiguration.html#cfn-medialive-channel-globalconfiguration-outputlockingmode
            '''
            result = self._values.get("output_locking_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def output_timing_source(self) -> typing.Optional[builtins.str]:
            '''Indicates whether the rate of frames emitted by the Live encoder should be paced by its system clock (which optionally might be locked to another source through NTP) or should be locked to the clock of the source that is providing the input stream.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-globalconfiguration.html#cfn-medialive-channel-globalconfiguration-outputtimingsource
            '''
            result = self._values.get("output_timing_source")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def support_low_framerate_inputs(self) -> typing.Optional[builtins.str]:
            '''Adjusts the video input buffer for streams with very low video frame rates.

            This is commonly set to enabled for music channels with less than one video frame per second.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-globalconfiguration.html#cfn-medialive-channel-globalconfiguration-supportlowframerateinputs
            '''
            result = self._values.get("support_low_framerate_inputs")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "GlobalConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.H264ColorSpaceSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "color_space_passthrough_settings": "colorSpacePassthroughSettings",
            "rec601_settings": "rec601Settings",
            "rec709_settings": "rec709Settings",
        },
    )
    class H264ColorSpaceSettingsProperty:
        def __init__(
            self,
            *,
            color_space_passthrough_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.ColorSpacePassthroughSettingsProperty"]] = None,
            rec601_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Rec601SettingsProperty"]] = None,
            rec709_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Rec709SettingsProperty"]] = None,
        ) -> None:
            '''Settings for configuring color space in an H264 video encode.

            The parent of this entity is H264Settings.

            :param color_space_passthrough_settings: Passthrough applies no color space conversion to the output.
            :param rec601_settings: Settings to configure the handling of Rec601 color space.
            :param rec709_settings: Settings to configure the handling of Rec709 color space.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264colorspacesettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                h264_color_space_settings_property = medialive.CfnChannel.H264ColorSpaceSettingsProperty(
                    color_space_passthrough_settings=medialive.CfnChannel.ColorSpacePassthroughSettingsProperty(),
                    rec601_settings=medialive.CfnChannel.Rec601SettingsProperty(),
                    rec709_settings=medialive.CfnChannel.Rec709SettingsProperty()
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if color_space_passthrough_settings is not None:
                self._values["color_space_passthrough_settings"] = color_space_passthrough_settings
            if rec601_settings is not None:
                self._values["rec601_settings"] = rec601_settings
            if rec709_settings is not None:
                self._values["rec709_settings"] = rec709_settings

        @builtins.property
        def color_space_passthrough_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.ColorSpacePassthroughSettingsProperty"]]:
            '''Passthrough applies no color space conversion to the output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264colorspacesettings.html#cfn-medialive-channel-h264colorspacesettings-colorspacepassthroughsettings
            '''
            result = self._values.get("color_space_passthrough_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.ColorSpacePassthroughSettingsProperty"]], result)

        @builtins.property
        def rec601_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Rec601SettingsProperty"]]:
            '''Settings to configure the handling of Rec601 color space.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264colorspacesettings.html#cfn-medialive-channel-h264colorspacesettings-rec601settings
            '''
            result = self._values.get("rec601_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Rec601SettingsProperty"]], result)

        @builtins.property
        def rec709_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Rec709SettingsProperty"]]:
            '''Settings to configure the handling of Rec709 color space.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264colorspacesettings.html#cfn-medialive-channel-h264colorspacesettings-rec709settings
            '''
            result = self._values.get("rec709_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Rec709SettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "H264ColorSpaceSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.H264FilterSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"temporal_filter_settings": "temporalFilterSettings"},
    )
    class H264FilterSettingsProperty:
        def __init__(
            self,
            *,
            temporal_filter_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.TemporalFilterSettingsProperty"]] = None,
        ) -> None:
            '''Settings to configure video filters that apply to the H264 codec.

            The parent of this entity is H264Settings.

            :param temporal_filter_settings: Settings for applying the temporal filter to the video.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264filtersettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                h264_filter_settings_property = medialive.CfnChannel.H264FilterSettingsProperty(
                    temporal_filter_settings=medialive.CfnChannel.TemporalFilterSettingsProperty(
                        post_filter_sharpening="postFilterSharpening",
                        strength="strength"
                    )
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if temporal_filter_settings is not None:
                self._values["temporal_filter_settings"] = temporal_filter_settings

        @builtins.property
        def temporal_filter_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.TemporalFilterSettingsProperty"]]:
            '''Settings for applying the temporal filter to the video.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264filtersettings.html#cfn-medialive-channel-h264filtersettings-temporalfiltersettings
            '''
            result = self._values.get("temporal_filter_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.TemporalFilterSettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "H264FilterSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.H264SettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "adaptive_quantization": "adaptiveQuantization",
            "afd_signaling": "afdSignaling",
            "bitrate": "bitrate",
            "buf_fill_pct": "bufFillPct",
            "buf_size": "bufSize",
            "color_metadata": "colorMetadata",
            "color_space_settings": "colorSpaceSettings",
            "entropy_encoding": "entropyEncoding",
            "filter_settings": "filterSettings",
            "fixed_afd": "fixedAfd",
            "flicker_aq": "flickerAq",
            "force_field_pictures": "forceFieldPictures",
            "framerate_control": "framerateControl",
            "framerate_denominator": "framerateDenominator",
            "framerate_numerator": "framerateNumerator",
            "gop_b_reference": "gopBReference",
            "gop_closed_cadence": "gopClosedCadence",
            "gop_num_b_frames": "gopNumBFrames",
            "gop_size": "gopSize",
            "gop_size_units": "gopSizeUnits",
            "level": "level",
            "look_ahead_rate_control": "lookAheadRateControl",
            "max_bitrate": "maxBitrate",
            "min_i_interval": "minIInterval",
            "num_ref_frames": "numRefFrames",
            "par_control": "parControl",
            "par_denominator": "parDenominator",
            "par_numerator": "parNumerator",
            "profile": "profile",
            "quality_level": "qualityLevel",
            "qvbr_quality_level": "qvbrQualityLevel",
            "rate_control_mode": "rateControlMode",
            "scan_type": "scanType",
            "scene_change_detect": "sceneChangeDetect",
            "slices": "slices",
            "softness": "softness",
            "spatial_aq": "spatialAq",
            "subgop_length": "subgopLength",
            "syntax": "syntax",
            "temporal_aq": "temporalAq",
            "timecode_insertion": "timecodeInsertion",
        },
    )
    class H264SettingsProperty:
        def __init__(
            self,
            *,
            adaptive_quantization: typing.Optional[builtins.str] = None,
            afd_signaling: typing.Optional[builtins.str] = None,
            bitrate: typing.Optional[jsii.Number] = None,
            buf_fill_pct: typing.Optional[jsii.Number] = None,
            buf_size: typing.Optional[jsii.Number] = None,
            color_metadata: typing.Optional[builtins.str] = None,
            color_space_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.H264ColorSpaceSettingsProperty"]] = None,
            entropy_encoding: typing.Optional[builtins.str] = None,
            filter_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.H264FilterSettingsProperty"]] = None,
            fixed_afd: typing.Optional[builtins.str] = None,
            flicker_aq: typing.Optional[builtins.str] = None,
            force_field_pictures: typing.Optional[builtins.str] = None,
            framerate_control: typing.Optional[builtins.str] = None,
            framerate_denominator: typing.Optional[jsii.Number] = None,
            framerate_numerator: typing.Optional[jsii.Number] = None,
            gop_b_reference: typing.Optional[builtins.str] = None,
            gop_closed_cadence: typing.Optional[jsii.Number] = None,
            gop_num_b_frames: typing.Optional[jsii.Number] = None,
            gop_size: typing.Optional[jsii.Number] = None,
            gop_size_units: typing.Optional[builtins.str] = None,
            level: typing.Optional[builtins.str] = None,
            look_ahead_rate_control: typing.Optional[builtins.str] = None,
            max_bitrate: typing.Optional[jsii.Number] = None,
            min_i_interval: typing.Optional[jsii.Number] = None,
            num_ref_frames: typing.Optional[jsii.Number] = None,
            par_control: typing.Optional[builtins.str] = None,
            par_denominator: typing.Optional[jsii.Number] = None,
            par_numerator: typing.Optional[jsii.Number] = None,
            profile: typing.Optional[builtins.str] = None,
            quality_level: typing.Optional[builtins.str] = None,
            qvbr_quality_level: typing.Optional[jsii.Number] = None,
            rate_control_mode: typing.Optional[builtins.str] = None,
            scan_type: typing.Optional[builtins.str] = None,
            scene_change_detect: typing.Optional[builtins.str] = None,
            slices: typing.Optional[jsii.Number] = None,
            softness: typing.Optional[jsii.Number] = None,
            spatial_aq: typing.Optional[builtins.str] = None,
            subgop_length: typing.Optional[builtins.str] = None,
            syntax: typing.Optional[builtins.str] = None,
            temporal_aq: typing.Optional[builtins.str] = None,
            timecode_insertion: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The settings for the H.264 codec in the output.

            The parent of this entity is VideoCodecSettings.

            :param adaptive_quantization: The adaptive quantization. This allows intra-frame quantizers to vary to improve visual quality.
            :param afd_signaling: Indicates that AFD values will be written into the output stream. If afdSignaling is auto, the system tries to preserve the input AFD value (in cases where multiple AFD values are valid). If set to fixed, the AFD value is the value configured in the fixedAfd parameter.
            :param bitrate: The average bitrate in bits/second. This is required when the rate control mode is VBR or CBR. It isn't used for QVBR. In a Microsoft Smooth output group, each output must have a unique value when its bitrate is rounded down to the nearest multiple of 1000.
            :param buf_fill_pct: The percentage of the buffer that should initially be filled (HRD buffer model).
            :param buf_size: The size of the buffer (HRD buffer model) in bits/second.
            :param color_metadata: Includes color space metadata in the output.
            :param color_space_settings: Settings to configure the color space handling for the video.
            :param entropy_encoding: The entropy encoding mode. Use cabac (must be in Main or High profile) or cavlc.
            :param filter_settings: Optional filters that you can apply to an encode.
            :param fixed_afd: A four-bit AFD value to write on all frames of video in the output stream. Valid only when afdSignaling is set to Fixed.
            :param flicker_aq: If set to enabled, adjusts the quantization within each frame to reduce flicker or pop on I-frames.
            :param force_field_pictures: This setting applies only when scan type is "interlaced." It controls whether coding is performed on a field basis or on a frame basis. (When the video is progressive, the coding is always performed on a frame basis.) enabled: Force MediaLive to code on a field basis, so that odd and even sets of fields are coded separately. disabled: Code the two sets of fields separately (on a field basis) or together (on a frame basis using PAFF), depending on what is most appropriate for the content.
            :param framerate_control: Indicates how the output video frame rate is specified. If you select "specified," the output video frame rate is determined by framerateNumerator and framerateDenominator. If you select "initializeFromSource," the output video frame rate is set equal to the input video frame rate of the first input.
            :param framerate_denominator: The frame rate denominator.
            :param framerate_numerator: The frame rate numerator. The frame rate is a fraction, for example, 24000/1001 = 23.976 fps.
            :param gop_b_reference: If enabled, uses reference B frames for GOP structures that have B frames > 1.
            :param gop_closed_cadence: The frequency of closed GOPs. In streaming applications, we recommend that you set this to 1 so that a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
            :param gop_num_b_frames: The number of B-frames between reference frames.
            :param gop_size: The GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits. The value must be greater than zero.
            :param gop_size_units: Indicates if the gopSize is specified in frames or seconds. If seconds, the system converts the gopSize into a frame count at runtime.
            :param level: The H.264 level.
            :param look_ahead_rate_control: The amount of lookahead. A value of low can decrease latency and memory usage, while high can produce better quality for certain content.
            :param max_bitrate: For QVBR: See the tooltip for Quality level. For VBR: Set the maximum bitrate in order to accommodate expected spikes in the complexity of the video.
            :param min_i_interval: Meaningful only if sceneChangeDetect is set to enabled. This setting enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting the I-interval. The normal cadence resumes for the next GOP. Note that the maximum GOP stretch = GOP size + Min-I-interval - 1.
            :param num_ref_frames: The number of reference frames to use. The encoder might use more than requested if you use B-frames or interlaced encoding.
            :param par_control: Indicates how the output pixel aspect ratio is specified. If "specified" is selected, the output video pixel aspect ratio is determined by parNumerator and parDenominator. If "initializeFromSource" is selected, the output pixels aspect ratio will be set equal to the input video pixel aspect ratio of the first input.
            :param par_denominator: The Pixel Aspect Ratio denominator.
            :param par_numerator: The Pixel Aspect Ratio numerator.
            :param profile: An H.264 profile.
            :param quality_level: Leave as STANDARD_QUALITY or choose a different value (which might result in additional costs to run the channel). - ENHANCED_QUALITY: Produces a slightly better video quality without an increase in the bitrate. Has an effect only when the Rate control mode is QVBR or CBR. If this channel is in a MediaLive multiplex, the value must be ENHANCED_QUALITY. - STANDARD_QUALITY: Valid for any Rate control mode.
            :param qvbr_quality_level: Controls the target quality for the video encode. This applies only when the rate control mode is QVBR. Set values for the QVBR quality level field and Max bitrate field that suit your most important viewing devices. Recommended values are: - Primary screen: Quality level: 8 to 10. Max bitrate: 4M - PC or tablet: Quality level: 7. Max bitrate: 1.5M to 3M - Smartphone: Quality level: 6. Max bitrate: 1M to 1.5M.
            :param rate_control_mode: The rate control mode. QVBR: The quality will match the specified quality level except when it is constrained by the maximum bitrate. We recommend this if you or your viewers pay for bandwidth. VBR: The quality and bitrate vary, depending on the video complexity. We recommend this instead of QVBR if you want to maintain a specific average bitrate over the duration of the channel. CBR: The quality varies, depending on the video complexity. We recommend this only if you distribute your assets to devices that can't handle variable bitrates.
            :param scan_type: Sets the scan type of the output to progressive or top-field-first interlaced.
            :param scene_change_detect: The scene change detection. On: inserts I-frames when the scene change is detected. Off: does not force an I-frame when the scene change is detected.
            :param slices: The number of slices per picture. The number must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures. This field is optional. If you don't specify a value, MediaLive chooses the number of slices based on the encode resolution.
            :param softness: Softness. Selects a quantizer matrix. Larger values reduce high-frequency content in the encoded image.
            :param spatial_aq: If set to enabled, adjusts quantization within each frame based on the spatial variation of content complexity.
            :param subgop_length: If set to fixed, uses gopNumBFrames B-frames per sub-GOP. If set to dynamic, optimizes the number of B-frames used for each sub-GOP to improve visual quality.
            :param syntax: Produces a bitstream that is compliant with SMPTE RP-2027.
            :param temporal_aq: If set to enabled, adjusts quantization within each frame based on the temporal variation of content complexity.
            :param timecode_insertion: Determines how timecodes should be inserted into the video elementary stream. disabled: don't include timecodes. picTimingSei: pass through picture timing SEI messages from the source specified in Timecode Config.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                h264_settings_property = medialive.CfnChannel.H264SettingsProperty(
                    adaptive_quantization="adaptiveQuantization",
                    afd_signaling="afdSignaling",
                    bitrate=123,
                    buf_fill_pct=123,
                    buf_size=123,
                    color_metadata="colorMetadata",
                    color_space_settings=medialive.CfnChannel.H264ColorSpaceSettingsProperty(
                        color_space_passthrough_settings=medialive.CfnChannel.ColorSpacePassthroughSettingsProperty(),
                        rec601_settings=medialive.CfnChannel.Rec601SettingsProperty(),
                        rec709_settings=medialive.CfnChannel.Rec709SettingsProperty()
                    ),
                    entropy_encoding="entropyEncoding",
                    filter_settings=medialive.CfnChannel.H264FilterSettingsProperty(
                        temporal_filter_settings=medialive.CfnChannel.TemporalFilterSettingsProperty(
                            post_filter_sharpening="postFilterSharpening",
                            strength="strength"
                        )
                    ),
                    fixed_afd="fixedAfd",
                    flicker_aq="flickerAq",
                    force_field_pictures="forceFieldPictures",
                    framerate_control="framerateControl",
                    framerate_denominator=123,
                    framerate_numerator=123,
                    gop_bReference="gopBReference",
                    gop_closed_cadence=123,
                    gop_num_bFrames=123,
                    gop_size=123,
                    gop_size_units="gopSizeUnits",
                    level="level",
                    look_ahead_rate_control="lookAheadRateControl",
                    max_bitrate=123,
                    min_iInterval=123,
                    num_ref_frames=123,
                    par_control="parControl",
                    par_denominator=123,
                    par_numerator=123,
                    profile="profile",
                    quality_level="qualityLevel",
                    qvbr_quality_level=123,
                    rate_control_mode="rateControlMode",
                    scan_type="scanType",
                    scene_change_detect="sceneChangeDetect",
                    slices=123,
                    softness=123,
                    spatial_aq="spatialAq",
                    subgop_length="subgopLength",
                    syntax="syntax",
                    temporal_aq="temporalAq",
                    timecode_insertion="timecodeInsertion"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if adaptive_quantization is not None:
                self._values["adaptive_quantization"] = adaptive_quantization
            if afd_signaling is not None:
                self._values["afd_signaling"] = afd_signaling
            if bitrate is not None:
                self._values["bitrate"] = bitrate
            if buf_fill_pct is not None:
                self._values["buf_fill_pct"] = buf_fill_pct
            if buf_size is not None:
                self._values["buf_size"] = buf_size
            if color_metadata is not None:
                self._values["color_metadata"] = color_metadata
            if color_space_settings is not None:
                self._values["color_space_settings"] = color_space_settings
            if entropy_encoding is not None:
                self._values["entropy_encoding"] = entropy_encoding
            if filter_settings is not None:
                self._values["filter_settings"] = filter_settings
            if fixed_afd is not None:
                self._values["fixed_afd"] = fixed_afd
            if flicker_aq is not None:
                self._values["flicker_aq"] = flicker_aq
            if force_field_pictures is not None:
                self._values["force_field_pictures"] = force_field_pictures
            if framerate_control is not None:
                self._values["framerate_control"] = framerate_control
            if framerate_denominator is not None:
                self._values["framerate_denominator"] = framerate_denominator
            if framerate_numerator is not None:
                self._values["framerate_numerator"] = framerate_numerator
            if gop_b_reference is not None:
                self._values["gop_b_reference"] = gop_b_reference
            if gop_closed_cadence is not None:
                self._values["gop_closed_cadence"] = gop_closed_cadence
            if gop_num_b_frames is not None:
                self._values["gop_num_b_frames"] = gop_num_b_frames
            if gop_size is not None:
                self._values["gop_size"] = gop_size
            if gop_size_units is not None:
                self._values["gop_size_units"] = gop_size_units
            if level is not None:
                self._values["level"] = level
            if look_ahead_rate_control is not None:
                self._values["look_ahead_rate_control"] = look_ahead_rate_control
            if max_bitrate is not None:
                self._values["max_bitrate"] = max_bitrate
            if min_i_interval is not None:
                self._values["min_i_interval"] = min_i_interval
            if num_ref_frames is not None:
                self._values["num_ref_frames"] = num_ref_frames
            if par_control is not None:
                self._values["par_control"] = par_control
            if par_denominator is not None:
                self._values["par_denominator"] = par_denominator
            if par_numerator is not None:
                self._values["par_numerator"] = par_numerator
            if profile is not None:
                self._values["profile"] = profile
            if quality_level is not None:
                self._values["quality_level"] = quality_level
            if qvbr_quality_level is not None:
                self._values["qvbr_quality_level"] = qvbr_quality_level
            if rate_control_mode is not None:
                self._values["rate_control_mode"] = rate_control_mode
            if scan_type is not None:
                self._values["scan_type"] = scan_type
            if scene_change_detect is not None:
                self._values["scene_change_detect"] = scene_change_detect
            if slices is not None:
                self._values["slices"] = slices
            if softness is not None:
                self._values["softness"] = softness
            if spatial_aq is not None:
                self._values["spatial_aq"] = spatial_aq
            if subgop_length is not None:
                self._values["subgop_length"] = subgop_length
            if syntax is not None:
                self._values["syntax"] = syntax
            if temporal_aq is not None:
                self._values["temporal_aq"] = temporal_aq
            if timecode_insertion is not None:
                self._values["timecode_insertion"] = timecode_insertion

        @builtins.property
        def adaptive_quantization(self) -> typing.Optional[builtins.str]:
            '''The adaptive quantization.

            This allows intra-frame quantizers to vary to improve visual quality.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-adaptivequantization
            '''
            result = self._values.get("adaptive_quantization")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def afd_signaling(self) -> typing.Optional[builtins.str]:
            '''Indicates that AFD values will be written into the output stream.

            If afdSignaling is auto, the system tries to preserve the input AFD value (in cases where multiple AFD values are valid). If set to fixed, the AFD value is the value configured in the fixedAfd parameter.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-afdsignaling
            '''
            result = self._values.get("afd_signaling")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def bitrate(self) -> typing.Optional[jsii.Number]:
            '''The average bitrate in bits/second.

            This is required when the rate control mode is VBR or CBR. It isn't used for QVBR. In a Microsoft Smooth output group, each output must have a unique value when its bitrate is rounded down to the nearest multiple of 1000.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-bitrate
            '''
            result = self._values.get("bitrate")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def buf_fill_pct(self) -> typing.Optional[jsii.Number]:
            '''The percentage of the buffer that should initially be filled (HRD buffer model).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-buffillpct
            '''
            result = self._values.get("buf_fill_pct")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def buf_size(self) -> typing.Optional[jsii.Number]:
            '''The size of the buffer (HRD buffer model) in bits/second.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-bufsize
            '''
            result = self._values.get("buf_size")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def color_metadata(self) -> typing.Optional[builtins.str]:
            '''Includes color space metadata in the output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-colormetadata
            '''
            result = self._values.get("color_metadata")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def color_space_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.H264ColorSpaceSettingsProperty"]]:
            '''Settings to configure the color space handling for the video.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-colorspacesettings
            '''
            result = self._values.get("color_space_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.H264ColorSpaceSettingsProperty"]], result)

        @builtins.property
        def entropy_encoding(self) -> typing.Optional[builtins.str]:
            '''The entropy encoding mode.

            Use cabac (must be in Main or High profile) or cavlc.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-entropyencoding
            '''
            result = self._values.get("entropy_encoding")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def filter_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.H264FilterSettingsProperty"]]:
            '''Optional filters that you can apply to an encode.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-filtersettings
            '''
            result = self._values.get("filter_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.H264FilterSettingsProperty"]], result)

        @builtins.property
        def fixed_afd(self) -> typing.Optional[builtins.str]:
            '''A four-bit AFD value to write on all frames of video in the output stream.

            Valid only when afdSignaling is set to Fixed.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-fixedafd
            '''
            result = self._values.get("fixed_afd")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def flicker_aq(self) -> typing.Optional[builtins.str]:
            '''If set to enabled, adjusts the quantization within each frame to reduce flicker or pop on I-frames.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-flickeraq
            '''
            result = self._values.get("flicker_aq")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def force_field_pictures(self) -> typing.Optional[builtins.str]:
            '''This setting applies only when scan type is "interlaced." It controls whether coding is performed on a field basis or on a frame basis. (When the video is progressive, the coding is always performed on a frame basis.) enabled: Force MediaLive to code on a field basis, so that odd and even sets of fields are coded separately. disabled: Code the two sets of fields separately (on a field basis) or together (on a frame basis using PAFF), depending on what is most appropriate for the content.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-forcefieldpictures
            '''
            result = self._values.get("force_field_pictures")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def framerate_control(self) -> typing.Optional[builtins.str]:
            '''Indicates how the output video frame rate is specified.

            If you select "specified," the output video frame rate is determined by framerateNumerator and framerateDenominator. If you select "initializeFromSource," the output video frame rate is set equal to the input video frame rate of the first input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-frameratecontrol
            '''
            result = self._values.get("framerate_control")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def framerate_denominator(self) -> typing.Optional[jsii.Number]:
            '''The frame rate denominator.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-frameratedenominator
            '''
            result = self._values.get("framerate_denominator")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def framerate_numerator(self) -> typing.Optional[jsii.Number]:
            '''The frame rate numerator.

            The frame rate is a fraction, for example, 24000/1001 = 23.976 fps.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-frameratenumerator
            '''
            result = self._values.get("framerate_numerator")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def gop_b_reference(self) -> typing.Optional[builtins.str]:
            '''If enabled, uses reference B frames for GOP structures that have B frames > 1.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-gopbreference
            '''
            result = self._values.get("gop_b_reference")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def gop_closed_cadence(self) -> typing.Optional[jsii.Number]:
            '''The frequency of closed GOPs.

            In streaming applications, we recommend that you set this to 1 so that a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-gopclosedcadence
            '''
            result = self._values.get("gop_closed_cadence")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def gop_num_b_frames(self) -> typing.Optional[jsii.Number]:
            '''The number of B-frames between reference frames.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-gopnumbframes
            '''
            result = self._values.get("gop_num_b_frames")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def gop_size(self) -> typing.Optional[jsii.Number]:
            '''The GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits.

            The value must be greater than zero.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-gopsize
            '''
            result = self._values.get("gop_size")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def gop_size_units(self) -> typing.Optional[builtins.str]:
            '''Indicates if the gopSize is specified in frames or seconds.

            If seconds, the system converts the gopSize into a frame count at runtime.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-gopsizeunits
            '''
            result = self._values.get("gop_size_units")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def level(self) -> typing.Optional[builtins.str]:
            '''The H.264 level.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-level
            '''
            result = self._values.get("level")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def look_ahead_rate_control(self) -> typing.Optional[builtins.str]:
            '''The amount of lookahead.

            A value of low can decrease latency and memory usage, while high can produce better quality for certain content.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-lookaheadratecontrol
            '''
            result = self._values.get("look_ahead_rate_control")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def max_bitrate(self) -> typing.Optional[jsii.Number]:
            '''For QVBR: See the tooltip for Quality level.

            For VBR: Set the maximum bitrate in order to accommodate expected spikes in the complexity of the video.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-maxbitrate
            '''
            result = self._values.get("max_bitrate")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def min_i_interval(self) -> typing.Optional[jsii.Number]:
            '''Meaningful only if sceneChangeDetect is set to enabled.

            This setting enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting the I-interval. The normal cadence resumes for the next GOP. Note that the maximum GOP stretch = GOP size + Min-I-interval - 1.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-miniinterval
            '''
            result = self._values.get("min_i_interval")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def num_ref_frames(self) -> typing.Optional[jsii.Number]:
            '''The number of reference frames to use.

            The encoder might use more than requested if you use B-frames or interlaced encoding.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-numrefframes
            '''
            result = self._values.get("num_ref_frames")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def par_control(self) -> typing.Optional[builtins.str]:
            '''Indicates how the output pixel aspect ratio is specified.

            If "specified" is selected, the output video pixel aspect ratio is determined by parNumerator and parDenominator. If "initializeFromSource" is selected, the output pixels aspect ratio will be set equal to the input video pixel aspect ratio of the first input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-parcontrol
            '''
            result = self._values.get("par_control")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def par_denominator(self) -> typing.Optional[jsii.Number]:
            '''The Pixel Aspect Ratio denominator.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-pardenominator
            '''
            result = self._values.get("par_denominator")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def par_numerator(self) -> typing.Optional[jsii.Number]:
            '''The Pixel Aspect Ratio numerator.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-parnumerator
            '''
            result = self._values.get("par_numerator")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def profile(self) -> typing.Optional[builtins.str]:
            '''An H.264 profile.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-profile
            '''
            result = self._values.get("profile")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def quality_level(self) -> typing.Optional[builtins.str]:
            '''Leave as STANDARD_QUALITY or choose a different value (which might result in additional costs to run the channel).

            - ENHANCED_QUALITY: Produces a slightly better video quality without an increase in the bitrate. Has an effect only when the Rate control mode is QVBR or CBR. If this channel is in a MediaLive multiplex, the value must be ENHANCED_QUALITY.
            - STANDARD_QUALITY: Valid for any Rate control mode.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-qualitylevel
            '''
            result = self._values.get("quality_level")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def qvbr_quality_level(self) -> typing.Optional[jsii.Number]:
            '''Controls the target quality for the video encode.

            This applies only when the rate control mode is QVBR. Set values for the QVBR quality level field and Max bitrate field that suit your most important viewing devices. Recommended values are: - Primary screen: Quality level: 8 to 10. Max bitrate: 4M - PC or tablet: Quality level: 7. Max bitrate: 1.5M to 3M - Smartphone: Quality level: 6. Max bitrate: 1M to 1.5M.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-qvbrqualitylevel
            '''
            result = self._values.get("qvbr_quality_level")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def rate_control_mode(self) -> typing.Optional[builtins.str]:
            '''The rate control mode.

            QVBR: The quality will match the specified quality level except when it is constrained by the maximum bitrate. We recommend this if you or your viewers pay for bandwidth. VBR: The quality and bitrate vary, depending on the video complexity. We recommend this instead of QVBR if you want to maintain a specific average bitrate over the duration of the channel. CBR: The quality varies, depending on the video complexity. We recommend this only if you distribute your assets to devices that can't handle variable bitrates.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-ratecontrolmode
            '''
            result = self._values.get("rate_control_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def scan_type(self) -> typing.Optional[builtins.str]:
            '''Sets the scan type of the output to progressive or top-field-first interlaced.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-scantype
            '''
            result = self._values.get("scan_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def scene_change_detect(self) -> typing.Optional[builtins.str]:
            '''The scene change detection.

            On: inserts I-frames when the scene change is detected. Off: does not force an I-frame when the scene change is detected.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-scenechangedetect
            '''
            result = self._values.get("scene_change_detect")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def slices(self) -> typing.Optional[jsii.Number]:
            '''The number of slices per picture.

            The number must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures. This field is optional. If you don't specify a value, MediaLive chooses the number of slices based on the encode resolution.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-slices
            '''
            result = self._values.get("slices")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def softness(self) -> typing.Optional[jsii.Number]:
            '''Softness.

            Selects a quantizer matrix. Larger values reduce high-frequency content in the encoded image.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-softness
            '''
            result = self._values.get("softness")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def spatial_aq(self) -> typing.Optional[builtins.str]:
            '''If set to enabled, adjusts quantization within each frame based on the spatial variation of content complexity.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-spatialaq
            '''
            result = self._values.get("spatial_aq")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def subgop_length(self) -> typing.Optional[builtins.str]:
            '''If set to fixed, uses gopNumBFrames B-frames per sub-GOP.

            If set to dynamic, optimizes the number of B-frames used for each sub-GOP to improve visual quality.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-subgoplength
            '''
            result = self._values.get("subgop_length")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def syntax(self) -> typing.Optional[builtins.str]:
            '''Produces a bitstream that is compliant with SMPTE RP-2027.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-syntax
            '''
            result = self._values.get("syntax")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def temporal_aq(self) -> typing.Optional[builtins.str]:
            '''If set to enabled, adjusts quantization within each frame based on the temporal variation of content complexity.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-temporalaq
            '''
            result = self._values.get("temporal_aq")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def timecode_insertion(self) -> typing.Optional[builtins.str]:
            '''Determines how timecodes should be inserted into the video elementary stream.

            disabled: don't include timecodes. picTimingSei: pass through picture timing SEI messages from the source specified in Timecode Config.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-timecodeinsertion
            '''
            result = self._values.get("timecode_insertion")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "H264SettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.H265ColorSpaceSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "color_space_passthrough_settings": "colorSpacePassthroughSettings",
            "hdr10_settings": "hdr10Settings",
            "rec601_settings": "rec601Settings",
            "rec709_settings": "rec709Settings",
        },
    )
    class H265ColorSpaceSettingsProperty:
        def __init__(
            self,
            *,
            color_space_passthrough_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.ColorSpacePassthroughSettingsProperty"]] = None,
            hdr10_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Hdr10SettingsProperty"]] = None,
            rec601_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Rec601SettingsProperty"]] = None,
            rec709_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Rec709SettingsProperty"]] = None,
        ) -> None:
            '''H265 Color Space Settings.

            The parent of this entity is H265Settings.

            :param color_space_passthrough_settings: Passthrough applies no color space conversion to the output.
            :param hdr10_settings: Settings to configure the handling of HDR10 color space.
            :param rec601_settings: Settings to configure the handling of Rec601 color space.
            :param rec709_settings: Settings to configure the handling of Rec709 color space.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265colorspacesettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                h265_color_space_settings_property = medialive.CfnChannel.H265ColorSpaceSettingsProperty(
                    color_space_passthrough_settings=medialive.CfnChannel.ColorSpacePassthroughSettingsProperty(),
                    hdr10_settings=medialive.CfnChannel.Hdr10SettingsProperty(
                        max_cll=123,
                        max_fall=123
                    ),
                    rec601_settings=medialive.CfnChannel.Rec601SettingsProperty(),
                    rec709_settings=medialive.CfnChannel.Rec709SettingsProperty()
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if color_space_passthrough_settings is not None:
                self._values["color_space_passthrough_settings"] = color_space_passthrough_settings
            if hdr10_settings is not None:
                self._values["hdr10_settings"] = hdr10_settings
            if rec601_settings is not None:
                self._values["rec601_settings"] = rec601_settings
            if rec709_settings is not None:
                self._values["rec709_settings"] = rec709_settings

        @builtins.property
        def color_space_passthrough_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.ColorSpacePassthroughSettingsProperty"]]:
            '''Passthrough applies no color space conversion to the output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265colorspacesettings.html#cfn-medialive-channel-h265colorspacesettings-colorspacepassthroughsettings
            '''
            result = self._values.get("color_space_passthrough_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.ColorSpacePassthroughSettingsProperty"]], result)

        @builtins.property
        def hdr10_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Hdr10SettingsProperty"]]:
            '''Settings to configure the handling of HDR10 color space.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265colorspacesettings.html#cfn-medialive-channel-h265colorspacesettings-hdr10settings
            '''
            result = self._values.get("hdr10_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Hdr10SettingsProperty"]], result)

        @builtins.property
        def rec601_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Rec601SettingsProperty"]]:
            '''Settings to configure the handling of Rec601 color space.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265colorspacesettings.html#cfn-medialive-channel-h265colorspacesettings-rec601settings
            '''
            result = self._values.get("rec601_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Rec601SettingsProperty"]], result)

        @builtins.property
        def rec709_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Rec709SettingsProperty"]]:
            '''Settings to configure the handling of Rec709 color space.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265colorspacesettings.html#cfn-medialive-channel-h265colorspacesettings-rec709settings
            '''
            result = self._values.get("rec709_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Rec709SettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "H265ColorSpaceSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.H265FilterSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"temporal_filter_settings": "temporalFilterSettings"},
    )
    class H265FilterSettingsProperty:
        def __init__(
            self,
            *,
            temporal_filter_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.TemporalFilterSettingsProperty"]] = None,
        ) -> None:
            '''Settings to configure video filters that apply to the H265 codec.

            The parent of this entity is H265Settings.

            :param temporal_filter_settings: Settings for applying the temporal filter to the video.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265filtersettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                h265_filter_settings_property = medialive.CfnChannel.H265FilterSettingsProperty(
                    temporal_filter_settings=medialive.CfnChannel.TemporalFilterSettingsProperty(
                        post_filter_sharpening="postFilterSharpening",
                        strength="strength"
                    )
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if temporal_filter_settings is not None:
                self._values["temporal_filter_settings"] = temporal_filter_settings

        @builtins.property
        def temporal_filter_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.TemporalFilterSettingsProperty"]]:
            '''Settings for applying the temporal filter to the video.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265filtersettings.html#cfn-medialive-channel-h265filtersettings-temporalfiltersettings
            '''
            result = self._values.get("temporal_filter_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.TemporalFilterSettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "H265FilterSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.H265SettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "adaptive_quantization": "adaptiveQuantization",
            "afd_signaling": "afdSignaling",
            "alternative_transfer_function": "alternativeTransferFunction",
            "bitrate": "bitrate",
            "buf_size": "bufSize",
            "color_metadata": "colorMetadata",
            "color_space_settings": "colorSpaceSettings",
            "filter_settings": "filterSettings",
            "fixed_afd": "fixedAfd",
            "flicker_aq": "flickerAq",
            "framerate_denominator": "framerateDenominator",
            "framerate_numerator": "framerateNumerator",
            "gop_closed_cadence": "gopClosedCadence",
            "gop_size": "gopSize",
            "gop_size_units": "gopSizeUnits",
            "level": "level",
            "look_ahead_rate_control": "lookAheadRateControl",
            "max_bitrate": "maxBitrate",
            "min_i_interval": "minIInterval",
            "par_denominator": "parDenominator",
            "par_numerator": "parNumerator",
            "profile": "profile",
            "qvbr_quality_level": "qvbrQualityLevel",
            "rate_control_mode": "rateControlMode",
            "scan_type": "scanType",
            "scene_change_detect": "sceneChangeDetect",
            "slices": "slices",
            "tier": "tier",
            "timecode_insertion": "timecodeInsertion",
        },
    )
    class H265SettingsProperty:
        def __init__(
            self,
            *,
            adaptive_quantization: typing.Optional[builtins.str] = None,
            afd_signaling: typing.Optional[builtins.str] = None,
            alternative_transfer_function: typing.Optional[builtins.str] = None,
            bitrate: typing.Optional[jsii.Number] = None,
            buf_size: typing.Optional[jsii.Number] = None,
            color_metadata: typing.Optional[builtins.str] = None,
            color_space_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.H265ColorSpaceSettingsProperty"]] = None,
            filter_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.H265FilterSettingsProperty"]] = None,
            fixed_afd: typing.Optional[builtins.str] = None,
            flicker_aq: typing.Optional[builtins.str] = None,
            framerate_denominator: typing.Optional[jsii.Number] = None,
            framerate_numerator: typing.Optional[jsii.Number] = None,
            gop_closed_cadence: typing.Optional[jsii.Number] = None,
            gop_size: typing.Optional[jsii.Number] = None,
            gop_size_units: typing.Optional[builtins.str] = None,
            level: typing.Optional[builtins.str] = None,
            look_ahead_rate_control: typing.Optional[builtins.str] = None,
            max_bitrate: typing.Optional[jsii.Number] = None,
            min_i_interval: typing.Optional[jsii.Number] = None,
            par_denominator: typing.Optional[jsii.Number] = None,
            par_numerator: typing.Optional[jsii.Number] = None,
            profile: typing.Optional[builtins.str] = None,
            qvbr_quality_level: typing.Optional[jsii.Number] = None,
            rate_control_mode: typing.Optional[builtins.str] = None,
            scan_type: typing.Optional[builtins.str] = None,
            scene_change_detect: typing.Optional[builtins.str] = None,
            slices: typing.Optional[jsii.Number] = None,
            tier: typing.Optional[builtins.str] = None,
            timecode_insertion: typing.Optional[builtins.str] = None,
        ) -> None:
            '''H265 Settings.

            The parent of this entity is VideoCodecSettings.

            :param adaptive_quantization: Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.
            :param afd_signaling: Indicates that AFD values will be written into the output stream. If afdSignaling is "auto", the system will try to preserve the input AFD value (in cases where multiple AFD values are valid). If set to "fixed", the AFD value will be the value configured in the fixedAfd parameter.
            :param alternative_transfer_function: Whether or not EML should insert an Alternative Transfer Function SEI message to support backwards compatibility with non-HDR decoders and displays.
            :param bitrate: Average bitrate in bits/second. Required when the rate control mode is VBR or CBR. Not used for QVBR. In an MS Smooth output group, each output must have a unique value when its bitrate is rounded down to the nearest multiple of 1000.
            :param buf_size: Size of buffer (HRD buffer model) in bits.
            :param color_metadata: Includes colorspace metadata in the output.
            :param color_space_settings: Color Space settings.
            :param filter_settings: Optional filters that you can apply to an encode.
            :param fixed_afd: Four bit AFD value to write on all frames of video in the output stream. Only valid when afdSignaling is set to 'Fixed'.
            :param flicker_aq: If set to enabled, adjust quantization within each frame to reduce flicker or 'pop' on I-frames.
            :param framerate_denominator: Framerate denominator.
            :param framerate_numerator: Framerate numerator - framerate is a fraction, e.g. 24000 / 1001 = 23.976 fps.
            :param gop_closed_cadence: Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
            :param gop_size: GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits. If gopSizeUnits is frames, gopSize must be an integer and must be greater than or equal to 1. If gopSizeUnits is seconds, gopSize must be greater than 0, but need not be an integer.
            :param gop_size_units: Indicates if the gopSize is specified in frames or seconds. If seconds the system will convert the gopSize into a frame count at run time.
            :param level: H.265 Level.
            :param look_ahead_rate_control: Amount of lookahead. A value of low can decrease latency and memory usage, while high can produce better quality for certain content.
            :param max_bitrate: For QVBR: See the tooltip for Quality level.
            :param min_i_interval: Only meaningful if sceneChangeDetect is set to enabled. Defaults to 5 if multiplex rate control is used. Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence resumes for the next GOP. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
            :param par_denominator: Pixel Aspect Ratio denominator.
            :param par_numerator: Pixel Aspect Ratio numerator.
            :param profile: H.265 Profile.
            :param qvbr_quality_level: Controls the target quality for the video encode. Applies only when the rate control mode is QVBR. Set values for the QVBR quality level field and Max bitrate field that suit your most important viewing devices. Recommended values are: - Primary screen: Quality level: 8 to 10. Max bitrate: 4M - PC or tablet: Quality level: 7. Max bitrate: 1.5M to 3M - Smartphone: Quality level: 6. Max bitrate: 1M to 1.5M
            :param rate_control_mode: Rate control mode. QVBR: Quality will match the specified quality level except when it is constrained by the maximum bitrate. Recommended if you or your viewers pay for bandwidth. CBR: Quality varies, depending on the video complexity. Recommended only if you distribute your assets to devices that cannot handle variable bitrates. Multiplex: This rate control mode is only supported (and is required) when the video is being delivered to a MediaLive Multiplex in which case the rate control configuration is controlled by the properties within the Multiplex Program.
            :param scan_type: Sets the scan type of the output to progressive or top-field-first interlaced.
            :param scene_change_detect: Scene change detection.
            :param slices: Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures. This field is optional; when no value is specified the encoder will choose the number of slices based on encode resolution.
            :param tier: H.265 Tier.
            :param timecode_insertion: Determines how timecodes should be inserted into the video elementary stream. - 'disabled': Do not include timecodes - 'picTimingSei': Pass through picture timing SEI messages from the source specified in Timecode Config

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                h265_settings_property = medialive.CfnChannel.H265SettingsProperty(
                    adaptive_quantization="adaptiveQuantization",
                    afd_signaling="afdSignaling",
                    alternative_transfer_function="alternativeTransferFunction",
                    bitrate=123,
                    buf_size=123,
                    color_metadata="colorMetadata",
                    color_space_settings=medialive.CfnChannel.H265ColorSpaceSettingsProperty(
                        color_space_passthrough_settings=medialive.CfnChannel.ColorSpacePassthroughSettingsProperty(),
                        hdr10_settings=medialive.CfnChannel.Hdr10SettingsProperty(
                            max_cll=123,
                            max_fall=123
                        ),
                        rec601_settings=medialive.CfnChannel.Rec601SettingsProperty(),
                        rec709_settings=medialive.CfnChannel.Rec709SettingsProperty()
                    ),
                    filter_settings=medialive.CfnChannel.H265FilterSettingsProperty(
                        temporal_filter_settings=medialive.CfnChannel.TemporalFilterSettingsProperty(
                            post_filter_sharpening="postFilterSharpening",
                            strength="strength"
                        )
                    ),
                    fixed_afd="fixedAfd",
                    flicker_aq="flickerAq",
                    framerate_denominator=123,
                    framerate_numerator=123,
                    gop_closed_cadence=123,
                    gop_size=123,
                    gop_size_units="gopSizeUnits",
                    level="level",
                    look_ahead_rate_control="lookAheadRateControl",
                    max_bitrate=123,
                    min_iInterval=123,
                    par_denominator=123,
                    par_numerator=123,
                    profile="profile",
                    qvbr_quality_level=123,
                    rate_control_mode="rateControlMode",
                    scan_type="scanType",
                    scene_change_detect="sceneChangeDetect",
                    slices=123,
                    tier="tier",
                    timecode_insertion="timecodeInsertion"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if adaptive_quantization is not None:
                self._values["adaptive_quantization"] = adaptive_quantization
            if afd_signaling is not None:
                self._values["afd_signaling"] = afd_signaling
            if alternative_transfer_function is not None:
                self._values["alternative_transfer_function"] = alternative_transfer_function
            if bitrate is not None:
                self._values["bitrate"] = bitrate
            if buf_size is not None:
                self._values["buf_size"] = buf_size
            if color_metadata is not None:
                self._values["color_metadata"] = color_metadata
            if color_space_settings is not None:
                self._values["color_space_settings"] = color_space_settings
            if filter_settings is not None:
                self._values["filter_settings"] = filter_settings
            if fixed_afd is not None:
                self._values["fixed_afd"] = fixed_afd
            if flicker_aq is not None:
                self._values["flicker_aq"] = flicker_aq
            if framerate_denominator is not None:
                self._values["framerate_denominator"] = framerate_denominator
            if framerate_numerator is not None:
                self._values["framerate_numerator"] = framerate_numerator
            if gop_closed_cadence is not None:
                self._values["gop_closed_cadence"] = gop_closed_cadence
            if gop_size is not None:
                self._values["gop_size"] = gop_size
            if gop_size_units is not None:
                self._values["gop_size_units"] = gop_size_units
            if level is not None:
                self._values["level"] = level
            if look_ahead_rate_control is not None:
                self._values["look_ahead_rate_control"] = look_ahead_rate_control
            if max_bitrate is not None:
                self._values["max_bitrate"] = max_bitrate
            if min_i_interval is not None:
                self._values["min_i_interval"] = min_i_interval
            if par_denominator is not None:
                self._values["par_denominator"] = par_denominator
            if par_numerator is not None:
                self._values["par_numerator"] = par_numerator
            if profile is not None:
                self._values["profile"] = profile
            if qvbr_quality_level is not None:
                self._values["qvbr_quality_level"] = qvbr_quality_level
            if rate_control_mode is not None:
                self._values["rate_control_mode"] = rate_control_mode
            if scan_type is not None:
                self._values["scan_type"] = scan_type
            if scene_change_detect is not None:
                self._values["scene_change_detect"] = scene_change_detect
            if slices is not None:
                self._values["slices"] = slices
            if tier is not None:
                self._values["tier"] = tier
            if timecode_insertion is not None:
                self._values["timecode_insertion"] = timecode_insertion

        @builtins.property
        def adaptive_quantization(self) -> typing.Optional[builtins.str]:
            '''Adaptive quantization.

            Allows intra-frame quantizers to vary to improve visual quality.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-adaptivequantization
            '''
            result = self._values.get("adaptive_quantization")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def afd_signaling(self) -> typing.Optional[builtins.str]:
            '''Indicates that AFD values will be written into the output stream.

            If afdSignaling is "auto", the system will try to preserve the input AFD value (in cases where multiple AFD values are valid). If set to "fixed", the AFD value will be the value configured in the fixedAfd parameter.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-afdsignaling
            '''
            result = self._values.get("afd_signaling")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def alternative_transfer_function(self) -> typing.Optional[builtins.str]:
            '''Whether or not EML should insert an Alternative Transfer Function SEI message to support backwards compatibility with non-HDR decoders and displays.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-alternativetransferfunction
            '''
            result = self._values.get("alternative_transfer_function")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def bitrate(self) -> typing.Optional[jsii.Number]:
            '''Average bitrate in bits/second.

            Required when the rate control mode is VBR or CBR. Not used for QVBR. In an MS Smooth output group, each output must have a unique value when its bitrate is rounded down to the nearest multiple of 1000.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-bitrate
            '''
            result = self._values.get("bitrate")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def buf_size(self) -> typing.Optional[jsii.Number]:
            '''Size of buffer (HRD buffer model) in bits.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-bufsize
            '''
            result = self._values.get("buf_size")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def color_metadata(self) -> typing.Optional[builtins.str]:
            '''Includes colorspace metadata in the output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-colormetadata
            '''
            result = self._values.get("color_metadata")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def color_space_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.H265ColorSpaceSettingsProperty"]]:
            '''Color Space settings.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-colorspacesettings
            '''
            result = self._values.get("color_space_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.H265ColorSpaceSettingsProperty"]], result)

        @builtins.property
        def filter_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.H265FilterSettingsProperty"]]:
            '''Optional filters that you can apply to an encode.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-filtersettings
            '''
            result = self._values.get("filter_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.H265FilterSettingsProperty"]], result)

        @builtins.property
        def fixed_afd(self) -> typing.Optional[builtins.str]:
            '''Four bit AFD value to write on all frames of video in the output stream.

            Only valid when afdSignaling is set to 'Fixed'.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-fixedafd
            '''
            result = self._values.get("fixed_afd")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def flicker_aq(self) -> typing.Optional[builtins.str]:
            '''If set to enabled, adjust quantization within each frame to reduce flicker or 'pop' on I-frames.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-flickeraq
            '''
            result = self._values.get("flicker_aq")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def framerate_denominator(self) -> typing.Optional[jsii.Number]:
            '''Framerate denominator.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-frameratedenominator
            '''
            result = self._values.get("framerate_denominator")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def framerate_numerator(self) -> typing.Optional[jsii.Number]:
            '''Framerate numerator - framerate is a fraction, e.g. 24000 / 1001 = 23.976 fps.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-frameratenumerator
            '''
            result = self._values.get("framerate_numerator")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def gop_closed_cadence(self) -> typing.Optional[jsii.Number]:
            '''Frequency of closed GOPs.

            In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-gopclosedcadence
            '''
            result = self._values.get("gop_closed_cadence")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def gop_size(self) -> typing.Optional[jsii.Number]:
            '''GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits.

            If gopSizeUnits is frames, gopSize must be an integer and must be greater than or equal to 1.
            If gopSizeUnits is seconds, gopSize must be greater than 0, but need not be an integer.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-gopsize
            '''
            result = self._values.get("gop_size")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def gop_size_units(self) -> typing.Optional[builtins.str]:
            '''Indicates if the gopSize is specified in frames or seconds.

            If seconds the system will convert the gopSize into a frame count at run time.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-gopsizeunits
            '''
            result = self._values.get("gop_size_units")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def level(self) -> typing.Optional[builtins.str]:
            '''H.265 Level.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-level
            '''
            result = self._values.get("level")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def look_ahead_rate_control(self) -> typing.Optional[builtins.str]:
            '''Amount of lookahead.

            A value of low can decrease latency and memory usage, while high can produce better quality for certain content.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-lookaheadratecontrol
            '''
            result = self._values.get("look_ahead_rate_control")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def max_bitrate(self) -> typing.Optional[jsii.Number]:
            '''For QVBR: See the tooltip for Quality level.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-maxbitrate
            '''
            result = self._values.get("max_bitrate")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def min_i_interval(self) -> typing.Optional[jsii.Number]:
            '''Only meaningful if sceneChangeDetect is set to enabled.

            Defaults to 5 if multiplex rate control is used. Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence resumes for the next GOP. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-miniinterval
            '''
            result = self._values.get("min_i_interval")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def par_denominator(self) -> typing.Optional[jsii.Number]:
            '''Pixel Aspect Ratio denominator.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-pardenominator
            '''
            result = self._values.get("par_denominator")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def par_numerator(self) -> typing.Optional[jsii.Number]:
            '''Pixel Aspect Ratio numerator.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-parnumerator
            '''
            result = self._values.get("par_numerator")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def profile(self) -> typing.Optional[builtins.str]:
            '''H.265 Profile.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-profile
            '''
            result = self._values.get("profile")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def qvbr_quality_level(self) -> typing.Optional[jsii.Number]:
            '''Controls the target quality for the video encode.

            Applies only when the rate control mode is QVBR. Set values for the QVBR quality level field and Max bitrate field that suit your most important viewing devices. Recommended values are:

            - Primary screen: Quality level: 8 to 10. Max bitrate: 4M
            - PC or tablet: Quality level: 7. Max bitrate: 1.5M to 3M
            - Smartphone: Quality level: 6. Max bitrate: 1M to 1.5M

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-qvbrqualitylevel
            '''
            result = self._values.get("qvbr_quality_level")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def rate_control_mode(self) -> typing.Optional[builtins.str]:
            '''Rate control mode.

            QVBR: Quality will match the specified quality level except when it is constrained by the
            maximum bitrate. Recommended if you or your viewers pay for bandwidth. CBR: Quality varies, depending on the video complexity. Recommended only if you distribute
            your assets to devices that cannot handle variable bitrates. Multiplex: This rate control mode is only supported (and is required) when the video is being
            delivered to a MediaLive Multiplex in which case the rate control configuration is controlled
            by the properties within the Multiplex Program.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-ratecontrolmode
            '''
            result = self._values.get("rate_control_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def scan_type(self) -> typing.Optional[builtins.str]:
            '''Sets the scan type of the output to progressive or top-field-first interlaced.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-scantype
            '''
            result = self._values.get("scan_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def scene_change_detect(self) -> typing.Optional[builtins.str]:
            '''Scene change detection.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-scenechangedetect
            '''
            result = self._values.get("scene_change_detect")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def slices(self) -> typing.Optional[jsii.Number]:
            '''Number of slices per picture.

            Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
            This field is optional; when no value is specified the encoder will choose the number of slices based on encode resolution.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-slices
            '''
            result = self._values.get("slices")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def tier(self) -> typing.Optional[builtins.str]:
            '''H.265 Tier.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-tier
            '''
            result = self._values.get("tier")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def timecode_insertion(self) -> typing.Optional[builtins.str]:
            '''Determines how timecodes should be inserted into the video elementary stream.

            - 'disabled': Do not include timecodes
            - 'picTimingSei': Pass through picture timing SEI messages from the source specified in Timecode Config

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-timecodeinsertion
            '''
            result = self._values.get("timecode_insertion")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "H265SettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.Hdr10SettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"max_cll": "maxCll", "max_fall": "maxFall"},
    )
    class Hdr10SettingsProperty:
        def __init__(
            self,
            *,
            max_cll: typing.Optional[jsii.Number] = None,
            max_fall: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''Hdr10 Settings.

            The parents of this entity are H265ColorSpaceSettings (for color space settings in the output) and VideoSelectorColorSpaceSettings (for color space settings in the input).

            :param max_cll: Maximum Content Light Level An integer metadata value defining the maximum light level, in nits, of any single pixel within an encoded HDR video stream or file.
            :param max_fall: Maximum Frame Average Light Level An integer metadata value defining the maximum average light level, in nits, for any single frame within an encoded HDR video stream or file.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hdr10settings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                hdr10_settings_property = medialive.CfnChannel.Hdr10SettingsProperty(
                    max_cll=123,
                    max_fall=123
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if max_cll is not None:
                self._values["max_cll"] = max_cll
            if max_fall is not None:
                self._values["max_fall"] = max_fall

        @builtins.property
        def max_cll(self) -> typing.Optional[jsii.Number]:
            '''Maximum Content Light Level An integer metadata value defining the maximum light level, in nits, of any single pixel within an encoded HDR video stream or file.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hdr10settings.html#cfn-medialive-channel-hdr10settings-maxcll
            '''
            result = self._values.get("max_cll")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def max_fall(self) -> typing.Optional[jsii.Number]:
            '''Maximum Frame Average Light Level An integer metadata value defining the maximum average light level, in nits, for any single frame within an encoded HDR video stream or file.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hdr10settings.html#cfn-medialive-channel-hdr10settings-maxfall
            '''
            result = self._values.get("max_fall")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "Hdr10SettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.HlsAkamaiSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "connection_retry_interval": "connectionRetryInterval",
            "filecache_duration": "filecacheDuration",
            "http_transfer_mode": "httpTransferMode",
            "num_retries": "numRetries",
            "restart_delay": "restartDelay",
            "salt": "salt",
            "token": "token",
        },
    )
    class HlsAkamaiSettingsProperty:
        def __init__(
            self,
            *,
            connection_retry_interval: typing.Optional[jsii.Number] = None,
            filecache_duration: typing.Optional[jsii.Number] = None,
            http_transfer_mode: typing.Optional[builtins.str] = None,
            num_retries: typing.Optional[jsii.Number] = None,
            restart_delay: typing.Optional[jsii.Number] = None,
            salt: typing.Optional[builtins.str] = None,
            token: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The Akamai settings in an HLS output.

            The parent of this entity is HlsCdnSettings.

            :param connection_retry_interval: The number of seconds to wait before retrying a connection to the CDN if the connection is lost.
            :param filecache_duration: The size, in seconds, of the file cache for streaming outputs.
            :param http_transfer_mode: Specifies whether to use chunked transfer encoding to Akamai. To enable this feature, contact Akamai.
            :param num_retries: The number of retry attempts that will be made before the channel is put into an error state.
            :param restart_delay: If a streaming output fails, the number of seconds to wait until a restart is initiated. A value of 0 means never restart.
            :param salt: The salt for authenticated Akamai.
            :param token: The token parameter for authenticated Akamai. If this is not specified, *gda* is used.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsakamaisettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                hls_akamai_settings_property = medialive.CfnChannel.HlsAkamaiSettingsProperty(
                    connection_retry_interval=123,
                    filecache_duration=123,
                    http_transfer_mode="httpTransferMode",
                    num_retries=123,
                    restart_delay=123,
                    salt="salt",
                    token="token"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if connection_retry_interval is not None:
                self._values["connection_retry_interval"] = connection_retry_interval
            if filecache_duration is not None:
                self._values["filecache_duration"] = filecache_duration
            if http_transfer_mode is not None:
                self._values["http_transfer_mode"] = http_transfer_mode
            if num_retries is not None:
                self._values["num_retries"] = num_retries
            if restart_delay is not None:
                self._values["restart_delay"] = restart_delay
            if salt is not None:
                self._values["salt"] = salt
            if token is not None:
                self._values["token"] = token

        @builtins.property
        def connection_retry_interval(self) -> typing.Optional[jsii.Number]:
            '''The number of seconds to wait before retrying a connection to the CDN if the connection is lost.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsakamaisettings.html#cfn-medialive-channel-hlsakamaisettings-connectionretryinterval
            '''
            result = self._values.get("connection_retry_interval")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def filecache_duration(self) -> typing.Optional[jsii.Number]:
            '''The size, in seconds, of the file cache for streaming outputs.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsakamaisettings.html#cfn-medialive-channel-hlsakamaisettings-filecacheduration
            '''
            result = self._values.get("filecache_duration")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def http_transfer_mode(self) -> typing.Optional[builtins.str]:
            '''Specifies whether to use chunked transfer encoding to Akamai.

            To enable this feature, contact Akamai.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsakamaisettings.html#cfn-medialive-channel-hlsakamaisettings-httptransfermode
            '''
            result = self._values.get("http_transfer_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def num_retries(self) -> typing.Optional[jsii.Number]:
            '''The number of retry attempts that will be made before the channel is put into an error state.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsakamaisettings.html#cfn-medialive-channel-hlsakamaisettings-numretries
            '''
            result = self._values.get("num_retries")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def restart_delay(self) -> typing.Optional[jsii.Number]:
            '''If a streaming output fails, the number of seconds to wait until a restart is initiated.

            A value of 0 means never restart.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsakamaisettings.html#cfn-medialive-channel-hlsakamaisettings-restartdelay
            '''
            result = self._values.get("restart_delay")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def salt(self) -> typing.Optional[builtins.str]:
            '''The salt for authenticated Akamai.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsakamaisettings.html#cfn-medialive-channel-hlsakamaisettings-salt
            '''
            result = self._values.get("salt")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def token(self) -> typing.Optional[builtins.str]:
            '''The token parameter for authenticated Akamai.

            If this is not specified, *gda* is used.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsakamaisettings.html#cfn-medialive-channel-hlsakamaisettings-token
            '''
            result = self._values.get("token")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "HlsAkamaiSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.HlsBasicPutSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "connection_retry_interval": "connectionRetryInterval",
            "filecache_duration": "filecacheDuration",
            "num_retries": "numRetries",
            "restart_delay": "restartDelay",
        },
    )
    class HlsBasicPutSettingsProperty:
        def __init__(
            self,
            *,
            connection_retry_interval: typing.Optional[jsii.Number] = None,
            filecache_duration: typing.Optional[jsii.Number] = None,
            num_retries: typing.Optional[jsii.Number] = None,
            restart_delay: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''The configuration of HLS Basic Put Settings.

            The parent of this entity is HlsCdnSettings.

            :param connection_retry_interval: The number of seconds to wait before retrying a connection to the CDN if the connection is lost.
            :param filecache_duration: The size, in seconds, of the file cache for streaming outputs.
            :param num_retries: The number of retry attempts that MediaLive makes before the channel is put into an error state.
            :param restart_delay: If a streaming output fails, the number of seconds to wait until a restart is initiated. A value of 0 means never restart.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsbasicputsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                hls_basic_put_settings_property = medialive.CfnChannel.HlsBasicPutSettingsProperty(
                    connection_retry_interval=123,
                    filecache_duration=123,
                    num_retries=123,
                    restart_delay=123
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if connection_retry_interval is not None:
                self._values["connection_retry_interval"] = connection_retry_interval
            if filecache_duration is not None:
                self._values["filecache_duration"] = filecache_duration
            if num_retries is not None:
                self._values["num_retries"] = num_retries
            if restart_delay is not None:
                self._values["restart_delay"] = restart_delay

        @builtins.property
        def connection_retry_interval(self) -> typing.Optional[jsii.Number]:
            '''The number of seconds to wait before retrying a connection to the CDN if the connection is lost.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsbasicputsettings.html#cfn-medialive-channel-hlsbasicputsettings-connectionretryinterval
            '''
            result = self._values.get("connection_retry_interval")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def filecache_duration(self) -> typing.Optional[jsii.Number]:
            '''The size, in seconds, of the file cache for streaming outputs.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsbasicputsettings.html#cfn-medialive-channel-hlsbasicputsettings-filecacheduration
            '''
            result = self._values.get("filecache_duration")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def num_retries(self) -> typing.Optional[jsii.Number]:
            '''The number of retry attempts that MediaLive makes before the channel is put into an error state.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsbasicputsettings.html#cfn-medialive-channel-hlsbasicputsettings-numretries
            '''
            result = self._values.get("num_retries")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def restart_delay(self) -> typing.Optional[jsii.Number]:
            '''If a streaming output fails, the number of seconds to wait until a restart is initiated.

            A value of 0 means never restart.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsbasicputsettings.html#cfn-medialive-channel-hlsbasicputsettings-restartdelay
            '''
            result = self._values.get("restart_delay")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "HlsBasicPutSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.HlsCdnSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "hls_akamai_settings": "hlsAkamaiSettings",
            "hls_basic_put_settings": "hlsBasicPutSettings",
            "hls_media_store_settings": "hlsMediaStoreSettings",
            "hls_s3_settings": "hlsS3Settings",
            "hls_webdav_settings": "hlsWebdavSettings",
        },
    )
    class HlsCdnSettingsProperty:
        def __init__(
            self,
            *,
            hls_akamai_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.HlsAkamaiSettingsProperty"]] = None,
            hls_basic_put_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.HlsBasicPutSettingsProperty"]] = None,
            hls_media_store_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.HlsMediaStoreSettingsProperty"]] = None,
            hls_s3_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.HlsS3SettingsProperty"]] = None,
            hls_webdav_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.HlsWebdavSettingsProperty"]] = None,
        ) -> None:
            '''The settings for the CDN of an HLS output.

            The parent of this entity is HlsGroupSettings.

            :param hls_akamai_settings: Sets up Akamai as the downstream system for the HLS output group.
            :param hls_basic_put_settings: The settings for Basic Put for the HLS output.
            :param hls_media_store_settings: Sets up MediaStore as the destination for the HLS output.
            :param hls_s3_settings: Sets up Amazon S3 as the destination for this HLS output.
            :param hls_webdav_settings: The settings for Web VTT captions in the HLS output group. The parent of this entity is HlsGroupSettings.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlscdnsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                hls_cdn_settings_property = medialive.CfnChannel.HlsCdnSettingsProperty(
                    hls_akamai_settings=medialive.CfnChannel.HlsAkamaiSettingsProperty(
                        connection_retry_interval=123,
                        filecache_duration=123,
                        http_transfer_mode="httpTransferMode",
                        num_retries=123,
                        restart_delay=123,
                        salt="salt",
                        token="token"
                    ),
                    hls_basic_put_settings=medialive.CfnChannel.HlsBasicPutSettingsProperty(
                        connection_retry_interval=123,
                        filecache_duration=123,
                        num_retries=123,
                        restart_delay=123
                    ),
                    hls_media_store_settings=medialive.CfnChannel.HlsMediaStoreSettingsProperty(
                        connection_retry_interval=123,
                        filecache_duration=123,
                        media_store_storage_class="mediaStoreStorageClass",
                        num_retries=123,
                        restart_delay=123
                    ),
                    hls_s3_settings=medialive.CfnChannel.HlsS3SettingsProperty(
                        canned_acl="cannedAcl"
                    ),
                    hls_webdav_settings=medialive.CfnChannel.HlsWebdavSettingsProperty(
                        connection_retry_interval=123,
                        filecache_duration=123,
                        http_transfer_mode="httpTransferMode",
                        num_retries=123,
                        restart_delay=123
                    )
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if hls_akamai_settings is not None:
                self._values["hls_akamai_settings"] = hls_akamai_settings
            if hls_basic_put_settings is not None:
                self._values["hls_basic_put_settings"] = hls_basic_put_settings
            if hls_media_store_settings is not None:
                self._values["hls_media_store_settings"] = hls_media_store_settings
            if hls_s3_settings is not None:
                self._values["hls_s3_settings"] = hls_s3_settings
            if hls_webdav_settings is not None:
                self._values["hls_webdav_settings"] = hls_webdav_settings

        @builtins.property
        def hls_akamai_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.HlsAkamaiSettingsProperty"]]:
            '''Sets up Akamai as the downstream system for the HLS output group.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlscdnsettings.html#cfn-medialive-channel-hlscdnsettings-hlsakamaisettings
            '''
            result = self._values.get("hls_akamai_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.HlsAkamaiSettingsProperty"]], result)

        @builtins.property
        def hls_basic_put_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.HlsBasicPutSettingsProperty"]]:
            '''The settings for Basic Put for the HLS output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlscdnsettings.html#cfn-medialive-channel-hlscdnsettings-hlsbasicputsettings
            '''
            result = self._values.get("hls_basic_put_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.HlsBasicPutSettingsProperty"]], result)

        @builtins.property
        def hls_media_store_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.HlsMediaStoreSettingsProperty"]]:
            '''Sets up MediaStore as the destination for the HLS output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlscdnsettings.html#cfn-medialive-channel-hlscdnsettings-hlsmediastoresettings
            '''
            result = self._values.get("hls_media_store_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.HlsMediaStoreSettingsProperty"]], result)

        @builtins.property
        def hls_s3_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.HlsS3SettingsProperty"]]:
            '''Sets up Amazon S3 as the destination for this HLS output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlscdnsettings.html#cfn-medialive-channel-hlscdnsettings-hlss3settings
            '''
            result = self._values.get("hls_s3_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.HlsS3SettingsProperty"]], result)

        @builtins.property
        def hls_webdav_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.HlsWebdavSettingsProperty"]]:
            '''The settings for Web VTT captions in the HLS output group.

            The parent of this entity is HlsGroupSettings.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlscdnsettings.html#cfn-medialive-channel-hlscdnsettings-hlswebdavsettings
            '''
            result = self._values.get("hls_webdav_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.HlsWebdavSettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "HlsCdnSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.HlsGroupSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "ad_markers": "adMarkers",
            "base_url_content": "baseUrlContent",
            "base_url_content1": "baseUrlContent1",
            "base_url_manifest": "baseUrlManifest",
            "base_url_manifest1": "baseUrlManifest1",
            "caption_language_mappings": "captionLanguageMappings",
            "caption_language_setting": "captionLanguageSetting",
            "client_cache": "clientCache",
            "codec_specification": "codecSpecification",
            "constant_iv": "constantIv",
            "destination": "destination",
            "directory_structure": "directoryStructure",
            "discontinuity_tags": "discontinuityTags",
            "encryption_type": "encryptionType",
            "hls_cdn_settings": "hlsCdnSettings",
            "hls_id3_segment_tagging": "hlsId3SegmentTagging",
            "i_frame_only_playlists": "iFrameOnlyPlaylists",
            "incomplete_segment_behavior": "incompleteSegmentBehavior",
            "index_n_segments": "indexNSegments",
            "input_loss_action": "inputLossAction",
            "iv_in_manifest": "ivInManifest",
            "iv_source": "ivSource",
            "keep_segments": "keepSegments",
            "key_format": "keyFormat",
            "key_format_versions": "keyFormatVersions",
            "key_provider_settings": "keyProviderSettings",
            "manifest_compression": "manifestCompression",
            "manifest_duration_format": "manifestDurationFormat",
            "min_segment_length": "minSegmentLength",
            "mode": "mode",
            "output_selection": "outputSelection",
            "program_date_time": "programDateTime",
            "program_date_time_clock": "programDateTimeClock",
            "program_date_time_period": "programDateTimePeriod",
            "redundant_manifest": "redundantManifest",
            "segmentation_mode": "segmentationMode",
            "segment_length": "segmentLength",
            "segments_per_subdirectory": "segmentsPerSubdirectory",
            "stream_inf_resolution": "streamInfResolution",
            "timed_metadata_id3_frame": "timedMetadataId3Frame",
            "timed_metadata_id3_period": "timedMetadataId3Period",
            "timestamp_delta_milliseconds": "timestampDeltaMilliseconds",
            "ts_file_mode": "tsFileMode",
        },
    )
    class HlsGroupSettingsProperty:
        def __init__(
            self,
            *,
            ad_markers: typing.Optional[typing.Sequence[builtins.str]] = None,
            base_url_content: typing.Optional[builtins.str] = None,
            base_url_content1: typing.Optional[builtins.str] = None,
            base_url_manifest: typing.Optional[builtins.str] = None,
            base_url_manifest1: typing.Optional[builtins.str] = None,
            caption_language_mappings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.Sequence[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.CaptionLanguageMappingProperty"]]]] = None,
            caption_language_setting: typing.Optional[builtins.str] = None,
            client_cache: typing.Optional[builtins.str] = None,
            codec_specification: typing.Optional[builtins.str] = None,
            constant_iv: typing.Optional[builtins.str] = None,
            destination: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputLocationRefProperty"]] = None,
            directory_structure: typing.Optional[builtins.str] = None,
            discontinuity_tags: typing.Optional[builtins.str] = None,
            encryption_type: typing.Optional[builtins.str] = None,
            hls_cdn_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.HlsCdnSettingsProperty"]] = None,
            hls_id3_segment_tagging: typing.Optional[builtins.str] = None,
            i_frame_only_playlists: typing.Optional[builtins.str] = None,
            incomplete_segment_behavior: typing.Optional[builtins.str] = None,
            index_n_segments: typing.Optional[jsii.Number] = None,
            input_loss_action: typing.Optional[builtins.str] = None,
            iv_in_manifest: typing.Optional[builtins.str] = None,
            iv_source: typing.Optional[builtins.str] = None,
            keep_segments: typing.Optional[jsii.Number] = None,
            key_format: typing.Optional[builtins.str] = None,
            key_format_versions: typing.Optional[builtins.str] = None,
            key_provider_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.KeyProviderSettingsProperty"]] = None,
            manifest_compression: typing.Optional[builtins.str] = None,
            manifest_duration_format: typing.Optional[builtins.str] = None,
            min_segment_length: typing.Optional[jsii.Number] = None,
            mode: typing.Optional[builtins.str] = None,
            output_selection: typing.Optional[builtins.str] = None,
            program_date_time: typing.Optional[builtins.str] = None,
            program_date_time_clock: typing.Optional[builtins.str] = None,
            program_date_time_period: typing.Optional[jsii.Number] = None,
            redundant_manifest: typing.Optional[builtins.str] = None,
            segmentation_mode: typing.Optional[builtins.str] = None,
            segment_length: typing.Optional[jsii.Number] = None,
            segments_per_subdirectory: typing.Optional[jsii.Number] = None,
            stream_inf_resolution: typing.Optional[builtins.str] = None,
            timed_metadata_id3_frame: typing.Optional[builtins.str] = None,
            timed_metadata_id3_period: typing.Optional[jsii.Number] = None,
            timestamp_delta_milliseconds: typing.Optional[jsii.Number] = None,
            ts_file_mode: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The settings for an HLS output group.

            The parent of this entity is OutputGroupSettings.

            :param ad_markers: Chooses one or more ad marker types to pass SCTE35 signals through to this group of Apple HLS outputs.
            :param base_url_content: A partial URI prefix that will be prepended to each output in the media .m3u8 file. The partial URI prefix can be used if the base manifest is delivered from a different URL than the main .m3u8 file.
            :param base_url_content1: Optional. One value per output group. This field is required only if you are completing Base URL content A, and the downstream system has notified you that the media files for pipeline 1 of all outputs are in a location different from the media files for pipeline 0.
            :param base_url_manifest: A partial URI prefix that will be prepended to each output in the media .m3u8 file. The partial URI prefix can be used if the base manifest is delivered from a different URL than the main .m3u8 file.
            :param base_url_manifest1: Optional. One value per output group. Complete this field only if you are completing Base URL manifest A, and the downstream system has notified you that the child manifest files for pipeline 1 of all outputs are in a location different from the child manifest files for pipeline 0.
            :param caption_language_mappings: A mapping of up to 4 captions channels to captions languages. This is meaningful only if captionLanguageSetting is set to "insert."
            :param caption_language_setting: Applies only to 608 embedded output captions. Insert: Include CLOSED-CAPTIONS lines in the manifest. Specify at least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for each Language Code that you specify. Make sure to specify the languages in the order in which they appear in the original source (if the source is embedded format) or the order of the captions selectors (if the source is other than embedded). Otherwise, languages in the manifest will not match properly with the output captions. None: Include the CLOSED-CAPTIONS=NONE line in the manifest. Omit: Omit any CLOSED-CAPTIONS line from the manifest.
            :param client_cache: When set to "disabled," sets the #EXT-X-ALLOW-CACHE:no tag in the manifest, which prevents clients from saving media segments for later replay.
            :param codec_specification: The specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
            :param constant_iv: Used with encryptionType. This is a 128-bit, 16-byte hex value that is represented by a 32-character text string. If ivSource is set to "explicit," this parameter is required and is used as the IV for encryption.
            :param destination: A directory or HTTP destination for the HLS segments, manifest files, and encryption keys (if enabled).
            :param directory_structure: Places segments in subdirectories.
            :param discontinuity_tags: Specifies whether to insert EXT-X-DISCONTINUITY tags in the HLS child manifests for this output group. Typically, choose Insert because these tags are required in the manifest (according to the HLS specification) and serve an important purpose. Choose Never Insert only if the downstream system is doing real-time failover (without using the MediaLive automatic failover feature) and only if that downstream system has advised you to exclude the tags.
            :param encryption_type: Encrypts the segments with the specified encryption scheme. Exclude this parameter if you don't want encryption.
            :param hls_cdn_settings: The parameters that control interactions with the CDN.
            :param hls_id3_segment_tagging: State of HLS ID3 Segment Tagging.
            :param i_frame_only_playlists: DISABLED: Don't create an I-frame-only manifest, but do create the master and media manifests (according to the Output Selection field). STANDARD: Create an I-frame-only manifest for each output that contains video, as well as the other manifests (according to the Output Selection field). The I-frame manifest contains a #EXT-X-I-FRAMES-ONLY tag to indicate it is I-frame only, and one or more #EXT-X-BYTERANGE entries identifying the I-frame position. For example, #EXT-X-BYTERANGE:160364@1461888".
            :param incomplete_segment_behavior: Specifies whether to include the final (incomplete) segment in the media output when the pipeline stops producing output because of a channel stop, a channel pause or a loss of input to the pipeline. Auto means that MediaLive decides whether to include the final segment, depending on the channel class and the types of output groups. Suppress means to never include the incomplete segment. We recommend you choose Auto and let MediaLive control the behavior.
            :param index_n_segments: Applies only if the Mode field is LIVE. Specifies the maximum number of segments in the media manifest file. After this maximum, older segments are removed from the media manifest. This number must be less than or equal to the Keep Segments field.
            :param input_loss_action: A parameter that controls output group behavior on an input loss.
            :param iv_in_manifest: Used with encryptionType. The IV (initialization vector) is a 128-bit number used in conjunction with the key for encrypting blocks. If set to "include," the IV is listed in the manifest. Otherwise, the IV is not in the manifest.
            :param iv_source: Used with encryptionType. The IV (initialization vector) is a 128-bit number used in conjunction with the key for encrypting blocks. If this setting is "followsSegmentNumber," it causes the IV to change every segment (to match the segment number). If this is set to "explicit," you must enter a constantIv value.
            :param keep_segments: Applies only if the Mode field is LIVE. Specifies the number of media segments (.ts files) to retain in the destination directory.
            :param key_format: Specifies how the key is represented in the resource identified by the URI. If the parameter is absent, an implicit value of "identity" is used. A reverse DNS string can also be specified.
            :param key_format_versions: Either a single positive integer version value or a slash-delimited list of version values (1/2/3).
            :param key_provider_settings: The key provider settings.
            :param manifest_compression: When set to gzip, compresses HLS playlist.
            :param manifest_duration_format: Indicates whether the output manifest should use a floating point or integer values for segment duration.
            :param min_segment_length: When set, minimumSegmentLength is enforced by looking ahead and back within the specified range for a nearby avail and extending the segment size if needed.
            :param mode: If "vod," all segments are indexed and kept permanently in the destination and manifest. If "live," only the number segments specified in keepSegments and indexNSegments are kept. Newer segments replace older segments, which might prevent players from rewinding all the way to the beginning of the channel. VOD mode uses HLS EXT-X-PLAYLIST-TYPE of EVENT while the channel is running, converting it to a "VOD" type manifest on completion of the stream.
            :param output_selection: MANIFESTSANDSEGMENTS: Generates manifests (the master manifest, if applicable, and media manifests) for this output group. SEGMENTSONLY: Doesn't generate any manifests for this output group.
            :param program_date_time: Includes or excludes the EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as follows: Either the program date and time are initialized using the input timecode source, or the time is initialized using the input timecode source and the date is initialized using the timestampOffset.
            :param program_date_time_clock: Specifies the algorithm used to drive the HLS EXT-X-PROGRAM-DATE-TIME clock. Options include: INITIALIZE_FROM_OUTPUT_TIMECODE: The PDT clock is initialized as a function of the first output timecode, then incremented by the EXTINF duration of each encoded segment. SYSTEM_CLOCK: The PDT clock is initialized as a function of the UTC wall clock, then incremented by the EXTINF duration of each encoded segment. If the PDT clock diverges from the wall clock by more than 500ms, it is resynchronized to the wall clock.
            :param program_date_time_period: The period of insertion of the EXT-X-PROGRAM-DATE-TIME entry, in seconds.
            :param redundant_manifest: ENABLED: The master manifest (.m3u8 file) for each pipeline includes information about both pipelines: first its own media files, then the media files of the other pipeline. This feature allows a playout device that supports stale manifest detection to switch from one manifest to the other, when the current manifest seems to be stale. There are still two destinations and two master manifests, but both master manifests reference the media files from both pipelines. DISABLED: The master manifest (.m3u8 file) for each pipeline includes information about its own pipeline only. For an HLS output group with MediaPackage as the destination, the DISABLED behavior is always followed. MediaPackage regenerates the manifests it serves to players, so a redundant manifest from MediaLive is irrelevant.
            :param segmentation_mode: useInputSegmentation has been deprecated. The configured segment size is always used.
            :param segment_length: The length of the MPEG-2 Transport Stream segments to create, in seconds. Note that segments will end on the next keyframe after this number of seconds, so the actual segment length might be longer.
            :param segments_per_subdirectory: The number of segments to write to a subdirectory before starting a new one. For this setting to have an effect, directoryStructure must be subdirectoryPerStream.
            :param stream_inf_resolution: The include or exclude RESOLUTION attribute for a video in the EXT-X-STREAM-INF tag of a variant manifest.
            :param timed_metadata_id3_frame: Indicates the ID3 frame that has the timecode.
            :param timed_metadata_id3_period: The timed metadata interval, in seconds.
            :param timestamp_delta_milliseconds: Provides an extra millisecond delta offset to fine tune the timestamps.
            :param ts_file_mode: SEGMENTEDFILES: Emits the program as segments -multiple .ts media files. SINGLEFILE: Applies only if the Mode field is VOD. Emits the program as a single .ts media file. The media manifest includes #EXT-X-BYTERANGE tags to index segments for playback. A typical use for this value is when sending the output to AWS Elemental MediaConvert, which can accept only a single media file. Playback while the channel is running is not guaranteed due to HTTP server caching.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                hls_group_settings_property = medialive.CfnChannel.HlsGroupSettingsProperty(
                    ad_markers=["adMarkers"],
                    base_url_content="baseUrlContent",
                    base_url_content1="baseUrlContent1",
                    base_url_manifest="baseUrlManifest",
                    base_url_manifest1="baseUrlManifest1",
                    caption_language_mappings=[medialive.CfnChannel.CaptionLanguageMappingProperty(
                        caption_channel=123,
                        language_code="languageCode",
                        language_description="languageDescription"
                    )],
                    caption_language_setting="captionLanguageSetting",
                    client_cache="clientCache",
                    codec_specification="codecSpecification",
                    constant_iv="constantIv",
                    destination=medialive.CfnChannel.OutputLocationRefProperty(
                        destination_ref_id="destinationRefId"
                    ),
                    directory_structure="directoryStructure",
                    discontinuity_tags="discontinuityTags",
                    encryption_type="encryptionType",
                    hls_cdn_settings=medialive.CfnChannel.HlsCdnSettingsProperty(
                        hls_akamai_settings=medialive.CfnChannel.HlsAkamaiSettingsProperty(
                            connection_retry_interval=123,
                            filecache_duration=123,
                            http_transfer_mode="httpTransferMode",
                            num_retries=123,
                            restart_delay=123,
                            salt="salt",
                            token="token"
                        ),
                        hls_basic_put_settings=medialive.CfnChannel.HlsBasicPutSettingsProperty(
                            connection_retry_interval=123,
                            filecache_duration=123,
                            num_retries=123,
                            restart_delay=123
                        ),
                        hls_media_store_settings=medialive.CfnChannel.HlsMediaStoreSettingsProperty(
                            connection_retry_interval=123,
                            filecache_duration=123,
                            media_store_storage_class="mediaStoreStorageClass",
                            num_retries=123,
                            restart_delay=123
                        ),
                        hls_s3_settings=medialive.CfnChannel.HlsS3SettingsProperty(
                            canned_acl="cannedAcl"
                        ),
                        hls_webdav_settings=medialive.CfnChannel.HlsWebdavSettingsProperty(
                            connection_retry_interval=123,
                            filecache_duration=123,
                            http_transfer_mode="httpTransferMode",
                            num_retries=123,
                            restart_delay=123
                        )
                    ),
                    hls_id3_segment_tagging="hlsId3SegmentTagging",
                    i_frame_only_playlists="iFrameOnlyPlaylists",
                    incomplete_segment_behavior="incompleteSegmentBehavior",
                    index_nSegments=123,
                    input_loss_action="inputLossAction",
                    iv_in_manifest="ivInManifest",
                    iv_source="ivSource",
                    keep_segments=123,
                    key_format="keyFormat",
                    key_format_versions="keyFormatVersions",
                    key_provider_settings=medialive.CfnChannel.KeyProviderSettingsProperty(
                        static_key_settings=medialive.CfnChannel.StaticKeySettingsProperty(
                            key_provider_server=medialive.CfnChannel.InputLocationProperty(
                                password_param="passwordParam",
                                uri="uri",
                                username="username"
                            ),
                            static_key_value="staticKeyValue"
                        )
                    ),
                    manifest_compression="manifestCompression",
                    manifest_duration_format="manifestDurationFormat",
                    min_segment_length=123,
                    mode="mode",
                    output_selection="outputSelection",
                    program_date_time="programDateTime",
                    program_date_time_clock="programDateTimeClock",
                    program_date_time_period=123,
                    redundant_manifest="redundantManifest",
                    segmentation_mode="segmentationMode",
                    segment_length=123,
                    segments_per_subdirectory=123,
                    stream_inf_resolution="streamInfResolution",
                    timed_metadata_id3_frame="timedMetadataId3Frame",
                    timed_metadata_id3_period=123,
                    timestamp_delta_milliseconds=123,
                    ts_file_mode="tsFileMode"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if ad_markers is not None:
                self._values["ad_markers"] = ad_markers
            if base_url_content is not None:
                self._values["base_url_content"] = base_url_content
            if base_url_content1 is not None:
                self._values["base_url_content1"] = base_url_content1
            if base_url_manifest is not None:
                self._values["base_url_manifest"] = base_url_manifest
            if base_url_manifest1 is not None:
                self._values["base_url_manifest1"] = base_url_manifest1
            if caption_language_mappings is not None:
                self._values["caption_language_mappings"] = caption_language_mappings
            if caption_language_setting is not None:
                self._values["caption_language_setting"] = caption_language_setting
            if client_cache is not None:
                self._values["client_cache"] = client_cache
            if codec_specification is not None:
                self._values["codec_specification"] = codec_specification
            if constant_iv is not None:
                self._values["constant_iv"] = constant_iv
            if destination is not None:
                self._values["destination"] = destination
            if directory_structure is not None:
                self._values["directory_structure"] = directory_structure
            if discontinuity_tags is not None:
                self._values["discontinuity_tags"] = discontinuity_tags
            if encryption_type is not None:
                self._values["encryption_type"] = encryption_type
            if hls_cdn_settings is not None:
                self._values["hls_cdn_settings"] = hls_cdn_settings
            if hls_id3_segment_tagging is not None:
                self._values["hls_id3_segment_tagging"] = hls_id3_segment_tagging
            if i_frame_only_playlists is not None:
                self._values["i_frame_only_playlists"] = i_frame_only_playlists
            if incomplete_segment_behavior is not None:
                self._values["incomplete_segment_behavior"] = incomplete_segment_behavior
            if index_n_segments is not None:
                self._values["index_n_segments"] = index_n_segments
            if input_loss_action is not None:
                self._values["input_loss_action"] = input_loss_action
            if iv_in_manifest is not None:
                self._values["iv_in_manifest"] = iv_in_manifest
            if iv_source is not None:
                self._values["iv_source"] = iv_source
            if keep_segments is not None:
                self._values["keep_segments"] = keep_segments
            if key_format is not None:
                self._values["key_format"] = key_format
            if key_format_versions is not None:
                self._values["key_format_versions"] = key_format_versions
            if key_provider_settings is not None:
                self._values["key_provider_settings"] = key_provider_settings
            if manifest_compression is not None:
                self._values["manifest_compression"] = manifest_compression
            if manifest_duration_format is not None:
                self._values["manifest_duration_format"] = manifest_duration_format
            if min_segment_length is not None:
                self._values["min_segment_length"] = min_segment_length
            if mode is not None:
                self._values["mode"] = mode
            if output_selection is not None:
                self._values["output_selection"] = output_selection
            if program_date_time is not None:
                self._values["program_date_time"] = program_date_time
            if program_date_time_clock is not None:
                self._values["program_date_time_clock"] = program_date_time_clock
            if program_date_time_period is not None:
                self._values["program_date_time_period"] = program_date_time_period
            if redundant_manifest is not None:
                self._values["redundant_manifest"] = redundant_manifest
            if segmentation_mode is not None:
                self._values["segmentation_mode"] = segmentation_mode
            if segment_length is not None:
                self._values["segment_length"] = segment_length
            if segments_per_subdirectory is not None:
                self._values["segments_per_subdirectory"] = segments_per_subdirectory
            if stream_inf_resolution is not None:
                self._values["stream_inf_resolution"] = stream_inf_resolution
            if timed_metadata_id3_frame is not None:
                self._values["timed_metadata_id3_frame"] = timed_metadata_id3_frame
            if timed_metadata_id3_period is not None:
                self._values["timed_metadata_id3_period"] = timed_metadata_id3_period
            if timestamp_delta_milliseconds is not None:
                self._values["timestamp_delta_milliseconds"] = timestamp_delta_milliseconds
            if ts_file_mode is not None:
                self._values["ts_file_mode"] = ts_file_mode

        @builtins.property
        def ad_markers(self) -> typing.Optional[typing.List[builtins.str]]:
            '''Chooses one or more ad marker types to pass SCTE35 signals through to this group of Apple HLS outputs.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-admarkers
            '''
            result = self._values.get("ad_markers")
            return typing.cast(typing.Optional[typing.List[builtins.str]], result)

        @builtins.property
        def base_url_content(self) -> typing.Optional[builtins.str]:
            '''A partial URI prefix that will be prepended to each output in the media .m3u8 file. The partial URI prefix can be used if the base manifest is delivered from a different URL than the main .m3u8 file.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-baseurlcontent
            '''
            result = self._values.get("base_url_content")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def base_url_content1(self) -> typing.Optional[builtins.str]:
            '''Optional.

            One value per output group. This field is required only if you are completing Base URL content A, and the downstream system has notified you that the media files for pipeline 1 of all outputs are in a location different from the media files for pipeline 0.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-baseurlcontent1
            '''
            result = self._values.get("base_url_content1")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def base_url_manifest(self) -> typing.Optional[builtins.str]:
            '''A partial URI prefix that will be prepended to each output in the media .m3u8 file. The partial URI prefix can be used if the base manifest is delivered from a different URL than the main .m3u8 file.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-baseurlmanifest
            '''
            result = self._values.get("base_url_manifest")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def base_url_manifest1(self) -> typing.Optional[builtins.str]:
            '''Optional.

            One value per output group. Complete this field only if you are completing Base URL manifest A, and the downstream system has notified you that the child manifest files for pipeline 1 of all outputs are in a location different from the child manifest files for pipeline 0.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-baseurlmanifest1
            '''
            result = self._values.get("base_url_manifest1")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def caption_language_mappings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.CaptionLanguageMappingProperty"]]]]:
            '''A mapping of up to 4 captions channels to captions languages.

            This is meaningful only if captionLanguageSetting is set to "insert."

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-captionlanguagemappings
            '''
            result = self._values.get("caption_language_mappings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.CaptionLanguageMappingProperty"]]]], result)

        @builtins.property
        def caption_language_setting(self) -> typing.Optional[builtins.str]:
            '''Applies only to 608 embedded output captions.

            Insert: Include CLOSED-CAPTIONS lines in the manifest. Specify at least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for each Language Code that you specify. Make sure to specify the languages in the order in which they appear in the original source (if the source is embedded format) or the order of the captions selectors (if the source is other than embedded). Otherwise, languages in the manifest will not match properly with the output captions. None: Include the CLOSED-CAPTIONS=NONE line in the manifest. Omit: Omit any CLOSED-CAPTIONS line from the manifest.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-captionlanguagesetting
            '''
            result = self._values.get("caption_language_setting")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def client_cache(self) -> typing.Optional[builtins.str]:
            '''When set to "disabled," sets the #EXT-X-ALLOW-CACHE:no tag in the manifest, which prevents clients from saving media segments for later replay.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-clientcache
            '''
            result = self._values.get("client_cache")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def codec_specification(self) -> typing.Optional[builtins.str]:
            '''The specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-codecspecification
            '''
            result = self._values.get("codec_specification")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def constant_iv(self) -> typing.Optional[builtins.str]:
            '''Used with encryptionType.

            This is a 128-bit, 16-byte hex value that is represented by a 32-character text string. If ivSource is set to "explicit," this parameter is required and is used as the IV for encryption.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-constantiv
            '''
            result = self._values.get("constant_iv")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def destination(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputLocationRefProperty"]]:
            '''A directory or HTTP destination for the HLS segments, manifest files, and encryption keys (if enabled).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-destination
            '''
            result = self._values.get("destination")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputLocationRefProperty"]], result)

        @builtins.property
        def directory_structure(self) -> typing.Optional[builtins.str]:
            '''Places segments in subdirectories.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-directorystructure
            '''
            result = self._values.get("directory_structure")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def discontinuity_tags(self) -> typing.Optional[builtins.str]:
            '''Specifies whether to insert EXT-X-DISCONTINUITY tags in the HLS child manifests for this output group.

            Typically, choose Insert because these tags are required in the manifest (according to the HLS specification) and serve an important purpose.
            Choose Never Insert only if the downstream system is doing real-time failover (without using the MediaLive automatic failover feature) and only if that downstream system has advised you to exclude the tags.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-discontinuitytags
            '''
            result = self._values.get("discontinuity_tags")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def encryption_type(self) -> typing.Optional[builtins.str]:
            '''Encrypts the segments with the specified encryption scheme.

            Exclude this parameter if you don't want encryption.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-encryptiontype
            '''
            result = self._values.get("encryption_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def hls_cdn_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.HlsCdnSettingsProperty"]]:
            '''The parameters that control interactions with the CDN.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-hlscdnsettings
            '''
            result = self._values.get("hls_cdn_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.HlsCdnSettingsProperty"]], result)

        @builtins.property
        def hls_id3_segment_tagging(self) -> typing.Optional[builtins.str]:
            '''State of HLS ID3 Segment Tagging.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-hlsid3segmenttagging
            '''
            result = self._values.get("hls_id3_segment_tagging")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def i_frame_only_playlists(self) -> typing.Optional[builtins.str]:
            '''DISABLED: Don't create an I-frame-only manifest, but do create the master and media manifests (according to the Output Selection field).

            STANDARD: Create an I-frame-only manifest for each output that contains video, as well as the other manifests (according to the Output Selection field). The I-frame manifest contains a #EXT-X-I-FRAMES-ONLY tag to indicate it is I-frame only, and one or more #EXT-X-BYTERANGE entries identifying the I-frame position. For example, #EXT-X-BYTERANGE:160364@1461888".

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-iframeonlyplaylists
            '''
            result = self._values.get("i_frame_only_playlists")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def incomplete_segment_behavior(self) -> typing.Optional[builtins.str]:
            '''Specifies whether to include the final (incomplete) segment in the media output when the pipeline stops producing output because of a channel stop, a channel pause or a loss of input to the pipeline.

            Auto means that MediaLive decides whether to include the final segment, depending on the channel class and the types of output groups.
            Suppress means to never include the incomplete segment. We recommend you choose Auto and let MediaLive control the behavior.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-incompletesegmentbehavior
            '''
            result = self._values.get("incomplete_segment_behavior")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def index_n_segments(self) -> typing.Optional[jsii.Number]:
            '''Applies only if the Mode field is LIVE.

            Specifies the maximum number of segments in the media manifest file. After this maximum, older segments are removed from the media manifest. This number must be less than or equal to the Keep Segments field.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-indexnsegments
            '''
            result = self._values.get("index_n_segments")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def input_loss_action(self) -> typing.Optional[builtins.str]:
            '''A parameter that controls output group behavior on an input loss.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-inputlossaction
            '''
            result = self._values.get("input_loss_action")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def iv_in_manifest(self) -> typing.Optional[builtins.str]:
            '''Used with encryptionType.

            The IV (initialization vector) is a 128-bit number used in conjunction with the key for encrypting blocks. If set to "include," the IV is listed in the manifest. Otherwise, the IV is not in the manifest.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-ivinmanifest
            '''
            result = self._values.get("iv_in_manifest")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def iv_source(self) -> typing.Optional[builtins.str]:
            '''Used with encryptionType.

            The IV (initialization vector) is a 128-bit number used in conjunction with the key for encrypting blocks. If this setting is "followsSegmentNumber," it causes the IV to change every segment (to match the segment number). If this is set to "explicit," you must enter a constantIv value.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-ivsource
            '''
            result = self._values.get("iv_source")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def keep_segments(self) -> typing.Optional[jsii.Number]:
            '''Applies only if the Mode field is LIVE.

            Specifies the number of media segments (.ts files) to retain in the destination directory.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-keepsegments
            '''
            result = self._values.get("keep_segments")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def key_format(self) -> typing.Optional[builtins.str]:
            '''Specifies how the key is represented in the resource identified by the URI.

            If the parameter is absent, an implicit value of "identity" is used. A reverse DNS string can also be specified.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-keyformat
            '''
            result = self._values.get("key_format")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def key_format_versions(self) -> typing.Optional[builtins.str]:
            '''Either a single positive integer version value or a slash-delimited list of version values (1/2/3).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-keyformatversions
            '''
            result = self._values.get("key_format_versions")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def key_provider_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.KeyProviderSettingsProperty"]]:
            '''The key provider settings.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-keyprovidersettings
            '''
            result = self._values.get("key_provider_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.KeyProviderSettingsProperty"]], result)

        @builtins.property
        def manifest_compression(self) -> typing.Optional[builtins.str]:
            '''When set to gzip, compresses HLS playlist.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-manifestcompression
            '''
            result = self._values.get("manifest_compression")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def manifest_duration_format(self) -> typing.Optional[builtins.str]:
            '''Indicates whether the output manifest should use a floating point or integer values for segment duration.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-manifestdurationformat
            '''
            result = self._values.get("manifest_duration_format")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def min_segment_length(self) -> typing.Optional[jsii.Number]:
            '''When set, minimumSegmentLength is enforced by looking ahead and back within the specified range for a nearby avail and extending the segment size if needed.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-minsegmentlength
            '''
            result = self._values.get("min_segment_length")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def mode(self) -> typing.Optional[builtins.str]:
            '''If "vod," all segments are indexed and kept permanently in the destination and manifest.

            If "live," only the number segments specified in keepSegments and indexNSegments are kept. Newer segments replace older segments, which might prevent players from rewinding all the way to the beginning of the channel. VOD mode uses HLS EXT-X-PLAYLIST-TYPE of EVENT while the channel is running, converting it to a "VOD" type manifest on completion of the stream.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-mode
            '''
            result = self._values.get("mode")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def output_selection(self) -> typing.Optional[builtins.str]:
            '''MANIFESTSANDSEGMENTS: Generates manifests (the master manifest, if applicable, and media manifests) for this output group.

            SEGMENTSONLY: Doesn't generate any manifests for this output group.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-outputselection
            '''
            result = self._values.get("output_selection")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def program_date_time(self) -> typing.Optional[builtins.str]:
            '''Includes or excludes the EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as follows: Either the program date and time are initialized using the input timecode source, or the time is initialized using the input timecode source and the date is initialized using the timestampOffset.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-programdatetime
            '''
            result = self._values.get("program_date_time")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def program_date_time_clock(self) -> typing.Optional[builtins.str]:
            '''Specifies the algorithm used to drive the HLS EXT-X-PROGRAM-DATE-TIME clock.

            Options include: INITIALIZE_FROM_OUTPUT_TIMECODE: The PDT clock is initialized as a function of the first output timecode, then incremented by the EXTINF duration of each encoded segment. SYSTEM_CLOCK: The PDT clock is initialized as a function of the UTC wall clock, then incremented by the EXTINF duration of each encoded segment. If the PDT clock diverges from the wall clock by more than 500ms, it is resynchronized to the wall clock.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-programdatetimeclock
            '''
            result = self._values.get("program_date_time_clock")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def program_date_time_period(self) -> typing.Optional[jsii.Number]:
            '''The period of insertion of the EXT-X-PROGRAM-DATE-TIME entry, in seconds.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-programdatetimeperiod
            '''
            result = self._values.get("program_date_time_period")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def redundant_manifest(self) -> typing.Optional[builtins.str]:
            '''ENABLED: The master manifest (.m3u8 file) for each pipeline includes information about both pipelines: first its own media files, then the media files of the other pipeline. This feature allows a playout device that supports stale manifest detection to switch from one manifest to the other, when the current manifest seems to be stale. There are still two destinations and two master manifests, but both master manifests reference the media files from both pipelines. DISABLED: The master manifest (.m3u8 file) for each pipeline includes information about its own pipeline only. For an HLS output group with MediaPackage as the destination, the DISABLED behavior is always followed. MediaPackage regenerates the manifests it serves to players, so a redundant manifest from MediaLive is irrelevant.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-redundantmanifest
            '''
            result = self._values.get("redundant_manifest")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def segmentation_mode(self) -> typing.Optional[builtins.str]:
            '''useInputSegmentation has been deprecated.

            The configured segment size is always used.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-segmentationmode
            '''
            result = self._values.get("segmentation_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def segment_length(self) -> typing.Optional[jsii.Number]:
            '''The length of the MPEG-2 Transport Stream segments to create, in seconds.

            Note that segments will end on the next keyframe after this number of seconds, so the actual segment length might be longer.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-segmentlength
            '''
            result = self._values.get("segment_length")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def segments_per_subdirectory(self) -> typing.Optional[jsii.Number]:
            '''The number of segments to write to a subdirectory before starting a new one.

            For this setting to have an effect, directoryStructure must be subdirectoryPerStream.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-segmentspersubdirectory
            '''
            result = self._values.get("segments_per_subdirectory")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def stream_inf_resolution(self) -> typing.Optional[builtins.str]:
            '''The include or exclude RESOLUTION attribute for a video in the EXT-X-STREAM-INF tag of a variant manifest.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-streaminfresolution
            '''
            result = self._values.get("stream_inf_resolution")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def timed_metadata_id3_frame(self) -> typing.Optional[builtins.str]:
            '''Indicates the ID3 frame that has the timecode.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-timedmetadataid3frame
            '''
            result = self._values.get("timed_metadata_id3_frame")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def timed_metadata_id3_period(self) -> typing.Optional[jsii.Number]:
            '''The timed metadata interval, in seconds.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-timedmetadataid3period
            '''
            result = self._values.get("timed_metadata_id3_period")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def timestamp_delta_milliseconds(self) -> typing.Optional[jsii.Number]:
            '''Provides an extra millisecond delta offset to fine tune the timestamps.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-timestampdeltamilliseconds
            '''
            result = self._values.get("timestamp_delta_milliseconds")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def ts_file_mode(self) -> typing.Optional[builtins.str]:
            '''SEGMENTEDFILES: Emits the program as segments -multiple .ts media files. SINGLEFILE: Applies only if the Mode field is VOD. Emits the program as a single .ts media file. The media manifest includes #EXT-X-BYTERANGE tags to index segments for playback. A typical use for this value is when sending the output to AWS Elemental MediaConvert, which can accept only a single media file. Playback while the channel is running is not guaranteed due to HTTP server caching.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-tsfilemode
            '''
            result = self._values.get("ts_file_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "HlsGroupSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.HlsInputSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "bandwidth": "bandwidth",
            "buffer_segments": "bufferSegments",
            "retries": "retries",
            "retry_interval": "retryInterval",
            "scte35_source": "scte35Source",
        },
    )
    class HlsInputSettingsProperty:
        def __init__(
            self,
            *,
            bandwidth: typing.Optional[jsii.Number] = None,
            buffer_segments: typing.Optional[jsii.Number] = None,
            retries: typing.Optional[jsii.Number] = None,
            retry_interval: typing.Optional[jsii.Number] = None,
            scte35_source: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Information about how to connect to the upstream system.

            The parent of this entity is NetworkInputSettings.

            :param bandwidth: When specified, the HLS stream with the m3u8 bandwidth that most closely matches this value is chosen. Otherwise, the highest bandwidth stream in the m3u8 is chosen. The bitrate is specified in bits per second, as in an HLS manifest.
            :param buffer_segments: When specified, reading of the HLS input begins this many buffer segments from the end (most recently written segment). When not specified, the HLS input begins with the first segment specified in the m3u8.
            :param retries: The number of consecutive times that attempts to read a manifest or segment must fail before the input is considered unavailable.
            :param retry_interval: The number of seconds between retries when an attempt to read a manifest or segment fails.
            :param scte35_source: Identifies the source for the SCTE-35 messages that MediaLive will ingest. Messages can be ingested from the content segments (in the stream) or from tags in the playlist (the HLS manifest). MediaLive ignores SCTE-35 information in the source that is not selected.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsinputsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                hls_input_settings_property = medialive.CfnChannel.HlsInputSettingsProperty(
                    bandwidth=123,
                    buffer_segments=123,
                    retries=123,
                    retry_interval=123,
                    scte35_source="scte35Source"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if bandwidth is not None:
                self._values["bandwidth"] = bandwidth
            if buffer_segments is not None:
                self._values["buffer_segments"] = buffer_segments
            if retries is not None:
                self._values["retries"] = retries
            if retry_interval is not None:
                self._values["retry_interval"] = retry_interval
            if scte35_source is not None:
                self._values["scte35_source"] = scte35_source

        @builtins.property
        def bandwidth(self) -> typing.Optional[jsii.Number]:
            '''When specified, the HLS stream with the m3u8 bandwidth that most closely matches this value is chosen.

            Otherwise, the highest bandwidth stream in the m3u8 is chosen. The bitrate is specified in bits per second, as in an HLS manifest.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsinputsettings.html#cfn-medialive-channel-hlsinputsettings-bandwidth
            '''
            result = self._values.get("bandwidth")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def buffer_segments(self) -> typing.Optional[jsii.Number]:
            '''When specified, reading of the HLS input begins this many buffer segments from the end (most recently written segment).

            When not specified, the HLS input begins with the first segment specified in the m3u8.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsinputsettings.html#cfn-medialive-channel-hlsinputsettings-buffersegments
            '''
            result = self._values.get("buffer_segments")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def retries(self) -> typing.Optional[jsii.Number]:
            '''The number of consecutive times that attempts to read a manifest or segment must fail before the input is considered unavailable.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsinputsettings.html#cfn-medialive-channel-hlsinputsettings-retries
            '''
            result = self._values.get("retries")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def retry_interval(self) -> typing.Optional[jsii.Number]:
            '''The number of seconds between retries when an attempt to read a manifest or segment fails.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsinputsettings.html#cfn-medialive-channel-hlsinputsettings-retryinterval
            '''
            result = self._values.get("retry_interval")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def scte35_source(self) -> typing.Optional[builtins.str]:
            '''Identifies the source for the SCTE-35 messages that MediaLive will ingest.

            Messages can be ingested from the content segments (in the stream) or from tags in the playlist (the HLS manifest). MediaLive ignores SCTE-35 information in the source that is not selected.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsinputsettings.html#cfn-medialive-channel-hlsinputsettings-scte35source
            '''
            result = self._values.get("scte35_source")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "HlsInputSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.HlsMediaStoreSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "connection_retry_interval": "connectionRetryInterval",
            "filecache_duration": "filecacheDuration",
            "media_store_storage_class": "mediaStoreStorageClass",
            "num_retries": "numRetries",
            "restart_delay": "restartDelay",
        },
    )
    class HlsMediaStoreSettingsProperty:
        def __init__(
            self,
            *,
            connection_retry_interval: typing.Optional[jsii.Number] = None,
            filecache_duration: typing.Optional[jsii.Number] = None,
            media_store_storage_class: typing.Optional[builtins.str] = None,
            num_retries: typing.Optional[jsii.Number] = None,
            restart_delay: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''The configuration of a MediaStore container as the destination for an HLS output.

            The parent of this entity is HlsCdnSettings.

            :param connection_retry_interval: The number of seconds to wait before retrying a connection to the CDN if the connection is lost.
            :param filecache_duration: The size, in seconds, of the file cache for streaming outputs.
            :param media_store_storage_class: When set to temporal, output files are stored in non-persistent memory for faster reading and writing.
            :param num_retries: The number of retry attempts that are made before the channel is put into an error state.
            :param restart_delay: If a streaming output fails, the number of seconds to wait until a restart is initiated. A value of 0 means never restart.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsmediastoresettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                hls_media_store_settings_property = medialive.CfnChannel.HlsMediaStoreSettingsProperty(
                    connection_retry_interval=123,
                    filecache_duration=123,
                    media_store_storage_class="mediaStoreStorageClass",
                    num_retries=123,
                    restart_delay=123
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if connection_retry_interval is not None:
                self._values["connection_retry_interval"] = connection_retry_interval
            if filecache_duration is not None:
                self._values["filecache_duration"] = filecache_duration
            if media_store_storage_class is not None:
                self._values["media_store_storage_class"] = media_store_storage_class
            if num_retries is not None:
                self._values["num_retries"] = num_retries
            if restart_delay is not None:
                self._values["restart_delay"] = restart_delay

        @builtins.property
        def connection_retry_interval(self) -> typing.Optional[jsii.Number]:
            '''The number of seconds to wait before retrying a connection to the CDN if the connection is lost.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsmediastoresettings.html#cfn-medialive-channel-hlsmediastoresettings-connectionretryinterval
            '''
            result = self._values.get("connection_retry_interval")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def filecache_duration(self) -> typing.Optional[jsii.Number]:
            '''The size, in seconds, of the file cache for streaming outputs.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsmediastoresettings.html#cfn-medialive-channel-hlsmediastoresettings-filecacheduration
            '''
            result = self._values.get("filecache_duration")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def media_store_storage_class(self) -> typing.Optional[builtins.str]:
            '''When set to temporal, output files are stored in non-persistent memory for faster reading and writing.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsmediastoresettings.html#cfn-medialive-channel-hlsmediastoresettings-mediastorestorageclass
            '''
            result = self._values.get("media_store_storage_class")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def num_retries(self) -> typing.Optional[jsii.Number]:
            '''The number of retry attempts that are made before the channel is put into an error state.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsmediastoresettings.html#cfn-medialive-channel-hlsmediastoresettings-numretries
            '''
            result = self._values.get("num_retries")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def restart_delay(self) -> typing.Optional[jsii.Number]:
            '''If a streaming output fails, the number of seconds to wait until a restart is initiated.

            A value of 0 means never restart.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsmediastoresettings.html#cfn-medialive-channel-hlsmediastoresettings-restartdelay
            '''
            result = self._values.get("restart_delay")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "HlsMediaStoreSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.HlsOutputSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "h265_packaging_type": "h265PackagingType",
            "hls_settings": "hlsSettings",
            "name_modifier": "nameModifier",
            "segment_modifier": "segmentModifier",
        },
    )
    class HlsOutputSettingsProperty:
        def __init__(
            self,
            *,
            h265_packaging_type: typing.Optional[builtins.str] = None,
            hls_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.HlsSettingsProperty"]] = None,
            name_modifier: typing.Optional[builtins.str] = None,
            segment_modifier: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The settings for an HLS output.

            The parent of this entity is OutputSettings.

            :param h265_packaging_type: Only applicable when this output is referencing an H.265 video description. Specifies whether MP4 segments should be packaged as HEV1 or HVC1.
            :param hls_settings: The settings regarding the underlying stream. These settings are different for audio-only outputs.
            :param name_modifier: A string that is concatenated to the end of the destination file name. Accepts "Format Identifiers":#formatIdentifierParameters.
            :param segment_modifier: A string that is concatenated to the end of segment file names.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsoutputsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                hls_output_settings_property = medialive.CfnChannel.HlsOutputSettingsProperty(
                    h265_packaging_type="h265PackagingType",
                    hls_settings=medialive.CfnChannel.HlsSettingsProperty(
                        audio_only_hls_settings=medialive.CfnChannel.AudioOnlyHlsSettingsProperty(
                            audio_group_id="audioGroupId",
                            audio_only_image=medialive.CfnChannel.InputLocationProperty(
                                password_param="passwordParam",
                                uri="uri",
                                username="username"
                            ),
                            audio_track_type="audioTrackType",
                            segment_type="segmentType"
                        ),
                        fmp4_hls_settings=medialive.CfnChannel.Fmp4HlsSettingsProperty(
                            audio_rendition_sets="audioRenditionSets",
                            nielsen_id3_behavior="nielsenId3Behavior",
                            timed_metadata_behavior="timedMetadataBehavior"
                        ),
                        frame_capture_hls_settings=medialive.CfnChannel.FrameCaptureHlsSettingsProperty(),
                        standard_hls_settings=medialive.CfnChannel.StandardHlsSettingsProperty(
                            audio_rendition_sets="audioRenditionSets",
                            m3_u8_settings=medialive.CfnChannel.M3u8SettingsProperty(
                                audio_frames_per_pes=123,
                                audio_pids="audioPids",
                                ecm_pid="ecmPid",
                                nielsen_id3_behavior="nielsenId3Behavior",
                                pat_interval=123,
                                pcr_control="pcrControl",
                                pcr_period=123,
                                pcr_pid="pcrPid",
                                pmt_interval=123,
                                pmt_pid="pmtPid",
                                program_num=123,
                                scte35_behavior="scte35Behavior",
                                scte35_pid="scte35Pid",
                                timed_metadata_behavior="timedMetadataBehavior",
                                timed_metadata_pid="timedMetadataPid",
                                transport_stream_id=123,
                                video_pid="videoPid"
                            )
                        )
                    ),
                    name_modifier="nameModifier",
                    segment_modifier="segmentModifier"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if h265_packaging_type is not None:
                self._values["h265_packaging_type"] = h265_packaging_type
            if hls_settings is not None:
                self._values["hls_settings"] = hls_settings
            if name_modifier is not None:
                self._values["name_modifier"] = name_modifier
            if segment_modifier is not None:
                self._values["segment_modifier"] = segment_modifier

        @builtins.property
        def h265_packaging_type(self) -> typing.Optional[builtins.str]:
            '''Only applicable when this output is referencing an H.265 video description. Specifies whether MP4 segments should be packaged as HEV1 or HVC1.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsoutputsettings.html#cfn-medialive-channel-hlsoutputsettings-h265packagingtype
            '''
            result = self._values.get("h265_packaging_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def hls_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.HlsSettingsProperty"]]:
            '''The settings regarding the underlying stream.

            These settings are different for audio-only outputs.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsoutputsettings.html#cfn-medialive-channel-hlsoutputsettings-hlssettings
            '''
            result = self._values.get("hls_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.HlsSettingsProperty"]], result)

        @builtins.property
        def name_modifier(self) -> typing.Optional[builtins.str]:
            '''A string that is concatenated to the end of the destination file name.

            Accepts "Format Identifiers":#formatIdentifierParameters.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsoutputsettings.html#cfn-medialive-channel-hlsoutputsettings-namemodifier
            '''
            result = self._values.get("name_modifier")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def segment_modifier(self) -> typing.Optional[builtins.str]:
            '''A string that is concatenated to the end of segment file names.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsoutputsettings.html#cfn-medialive-channel-hlsoutputsettings-segmentmodifier
            '''
            result = self._values.get("segment_modifier")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "HlsOutputSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.HlsS3SettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"canned_acl": "cannedAcl"},
    )
    class HlsS3SettingsProperty:
        def __init__(self, *, canned_acl: typing.Optional[builtins.str] = None) -> None:
            '''Sets up Amazon S3 as the destination for this HLS output.

            The parent of this entity is HlsCdnSettings.

            :param canned_acl: Specify the canned ACL to apply to each S3 request. Defaults to none.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlss3settings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                hls_s3_settings_property = medialive.CfnChannel.HlsS3SettingsProperty(
                    canned_acl="cannedAcl"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if canned_acl is not None:
                self._values["canned_acl"] = canned_acl

        @builtins.property
        def canned_acl(self) -> typing.Optional[builtins.str]:
            '''Specify the canned ACL to apply to each S3 request.

            Defaults to none.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlss3settings.html#cfn-medialive-channel-hlss3settings-cannedacl
            '''
            result = self._values.get("canned_acl")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "HlsS3SettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.HlsSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "audio_only_hls_settings": "audioOnlyHlsSettings",
            "fmp4_hls_settings": "fmp4HlsSettings",
            "frame_capture_hls_settings": "frameCaptureHlsSettings",
            "standard_hls_settings": "standardHlsSettings",
        },
    )
    class HlsSettingsProperty:
        def __init__(
            self,
            *,
            audio_only_hls_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioOnlyHlsSettingsProperty"]] = None,
            fmp4_hls_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Fmp4HlsSettingsProperty"]] = None,
            frame_capture_hls_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.FrameCaptureHlsSettingsProperty"]] = None,
            standard_hls_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.StandardHlsSettingsProperty"]] = None,
        ) -> None:
            '''The settings for an HLS output.

            The parent of this entity is HlsOutputSettings.

            :param audio_only_hls_settings: The settings for an audio-only output.
            :param fmp4_hls_settings: The settings for an fMP4 container.
            :param frame_capture_hls_settings: Settings for a frame capture output in an HLS output group.
            :param standard_hls_settings: The settings for a standard output (an output that is not audio-only).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlssettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                hls_settings_property = medialive.CfnChannel.HlsSettingsProperty(
                    audio_only_hls_settings=medialive.CfnChannel.AudioOnlyHlsSettingsProperty(
                        audio_group_id="audioGroupId",
                        audio_only_image=medialive.CfnChannel.InputLocationProperty(
                            password_param="passwordParam",
                            uri="uri",
                            username="username"
                        ),
                        audio_track_type="audioTrackType",
                        segment_type="segmentType"
                    ),
                    fmp4_hls_settings=medialive.CfnChannel.Fmp4HlsSettingsProperty(
                        audio_rendition_sets="audioRenditionSets",
                        nielsen_id3_behavior="nielsenId3Behavior",
                        timed_metadata_behavior="timedMetadataBehavior"
                    ),
                    frame_capture_hls_settings=medialive.CfnChannel.FrameCaptureHlsSettingsProperty(),
                    standard_hls_settings=medialive.CfnChannel.StandardHlsSettingsProperty(
                        audio_rendition_sets="audioRenditionSets",
                        m3_u8_settings=medialive.CfnChannel.M3u8SettingsProperty(
                            audio_frames_per_pes=123,
                            audio_pids="audioPids",
                            ecm_pid="ecmPid",
                            nielsen_id3_behavior="nielsenId3Behavior",
                            pat_interval=123,
                            pcr_control="pcrControl",
                            pcr_period=123,
                            pcr_pid="pcrPid",
                            pmt_interval=123,
                            pmt_pid="pmtPid",
                            program_num=123,
                            scte35_behavior="scte35Behavior",
                            scte35_pid="scte35Pid",
                            timed_metadata_behavior="timedMetadataBehavior",
                            timed_metadata_pid="timedMetadataPid",
                            transport_stream_id=123,
                            video_pid="videoPid"
                        )
                    )
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if audio_only_hls_settings is not None:
                self._values["audio_only_hls_settings"] = audio_only_hls_settings
            if fmp4_hls_settings is not None:
                self._values["fmp4_hls_settings"] = fmp4_hls_settings
            if frame_capture_hls_settings is not None:
                self._values["frame_capture_hls_settings"] = frame_capture_hls_settings
            if standard_hls_settings is not None:
                self._values["standard_hls_settings"] = standard_hls_settings

        @builtins.property
        def audio_only_hls_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioOnlyHlsSettingsProperty"]]:
            '''The settings for an audio-only output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlssettings.html#cfn-medialive-channel-hlssettings-audioonlyhlssettings
            '''
            result = self._values.get("audio_only_hls_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioOnlyHlsSettingsProperty"]], result)

        @builtins.property
        def fmp4_hls_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Fmp4HlsSettingsProperty"]]:
            '''The settings for an fMP4 container.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlssettings.html#cfn-medialive-channel-hlssettings-fmp4hlssettings
            '''
            result = self._values.get("fmp4_hls_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Fmp4HlsSettingsProperty"]], result)

        @builtins.property
        def frame_capture_hls_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.FrameCaptureHlsSettingsProperty"]]:
            '''Settings for a frame capture output in an HLS output group.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlssettings.html#cfn-medialive-channel-hlssettings-framecapturehlssettings
            '''
            result = self._values.get("frame_capture_hls_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.FrameCaptureHlsSettingsProperty"]], result)

        @builtins.property
        def standard_hls_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.StandardHlsSettingsProperty"]]:
            '''The settings for a standard output (an output that is not audio-only).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlssettings.html#cfn-medialive-channel-hlssettings-standardhlssettings
            '''
            result = self._values.get("standard_hls_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.StandardHlsSettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "HlsSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.HlsWebdavSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "connection_retry_interval": "connectionRetryInterval",
            "filecache_duration": "filecacheDuration",
            "http_transfer_mode": "httpTransferMode",
            "num_retries": "numRetries",
            "restart_delay": "restartDelay",
        },
    )
    class HlsWebdavSettingsProperty:
        def __init__(
            self,
            *,
            connection_retry_interval: typing.Optional[jsii.Number] = None,
            filecache_duration: typing.Optional[jsii.Number] = None,
            http_transfer_mode: typing.Optional[builtins.str] = None,
            num_retries: typing.Optional[jsii.Number] = None,
            restart_delay: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''The configuration of a WebDav server as the downstream system for an HLS output.

            The parent of this entity is HlsCdnSettings.

            :param connection_retry_interval: The number of seconds to wait before retrying a connection to the CDN if the connection is lost.
            :param filecache_duration: The size, in seconds, of the file cache for streaming outputs.
            :param http_transfer_mode: Specifies whether to use chunked transfer encoding to WebDAV.
            :param num_retries: The number of retry attempts that are made before the channel is put into an error state.
            :param restart_delay: If a streaming output fails, the number of seconds to wait until a restart is initiated. A value of 0 means never restart.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlswebdavsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                hls_webdav_settings_property = medialive.CfnChannel.HlsWebdavSettingsProperty(
                    connection_retry_interval=123,
                    filecache_duration=123,
                    http_transfer_mode="httpTransferMode",
                    num_retries=123,
                    restart_delay=123
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if connection_retry_interval is not None:
                self._values["connection_retry_interval"] = connection_retry_interval
            if filecache_duration is not None:
                self._values["filecache_duration"] = filecache_duration
            if http_transfer_mode is not None:
                self._values["http_transfer_mode"] = http_transfer_mode
            if num_retries is not None:
                self._values["num_retries"] = num_retries
            if restart_delay is not None:
                self._values["restart_delay"] = restart_delay

        @builtins.property
        def connection_retry_interval(self) -> typing.Optional[jsii.Number]:
            '''The number of seconds to wait before retrying a connection to the CDN if the connection is lost.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlswebdavsettings.html#cfn-medialive-channel-hlswebdavsettings-connectionretryinterval
            '''
            result = self._values.get("connection_retry_interval")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def filecache_duration(self) -> typing.Optional[jsii.Number]:
            '''The size, in seconds, of the file cache for streaming outputs.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlswebdavsettings.html#cfn-medialive-channel-hlswebdavsettings-filecacheduration
            '''
            result = self._values.get("filecache_duration")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def http_transfer_mode(self) -> typing.Optional[builtins.str]:
            '''Specifies whether to use chunked transfer encoding to WebDAV.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlswebdavsettings.html#cfn-medialive-channel-hlswebdavsettings-httptransfermode
            '''
            result = self._values.get("http_transfer_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def num_retries(self) -> typing.Optional[jsii.Number]:
            '''The number of retry attempts that are made before the channel is put into an error state.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlswebdavsettings.html#cfn-medialive-channel-hlswebdavsettings-numretries
            '''
            result = self._values.get("num_retries")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def restart_delay(self) -> typing.Optional[jsii.Number]:
            '''If a streaming output fails, the number of seconds to wait until a restart is initiated.

            A value of 0 means never restart.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlswebdavsettings.html#cfn-medialive-channel-hlswebdavsettings-restartdelay
            '''
            result = self._values.get("restart_delay")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "HlsWebdavSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.HtmlMotionGraphicsSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={},
    )
    class HtmlMotionGraphicsSettingsProperty:
        def __init__(self) -> None:
            '''Settings to configure the motion graphics overlay to use an HTML asset.

            The parent of this entity is MotionGraphicsSetting.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-htmlmotiongraphicssettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                html_motion_graphics_settings_property = medialive.CfnChannel.HtmlMotionGraphicsSettingsProperty()
            '''
            self._values: typing.Dict[str, typing.Any] = {}

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "HtmlMotionGraphicsSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.InputAttachmentProperty",
        jsii_struct_bases=[],
        name_mapping={
            "automatic_input_failover_settings": "automaticInputFailoverSettings",
            "input_attachment_name": "inputAttachmentName",
            "input_id": "inputId",
            "input_settings": "inputSettings",
        },
    )
    class InputAttachmentProperty:
        def __init__(
            self,
            *,
            automatic_input_failover_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AutomaticInputFailoverSettingsProperty"]] = None,
            input_attachment_name: typing.Optional[builtins.str] = None,
            input_id: typing.Optional[builtins.str] = None,
            input_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputSettingsProperty"]] = None,
        ) -> None:
            '''An input to attach to this channel.

            This entity is at the top level in the channel.

            :param automatic_input_failover_settings: Settings to implement automatic input failover in this input.
            :param input_attachment_name: A name for the attachment. This is required if you want to use this input in an input switch action.
            :param input_id: The ID of the input to attach.
            :param input_settings: Information about the content to extract from the input and about the general handling of the content.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputattachment.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                input_attachment_property = medialive.CfnChannel.InputAttachmentProperty(
                    automatic_input_failover_settings=medialive.CfnChannel.AutomaticInputFailoverSettingsProperty(
                        error_clear_time_msec=123,
                        failover_conditions=[medialive.CfnChannel.FailoverConditionProperty(
                            failover_condition_settings=medialive.CfnChannel.FailoverConditionSettingsProperty(
                                audio_silence_settings=medialive.CfnChannel.AudioSilenceFailoverSettingsProperty(
                                    audio_selector_name="audioSelectorName",
                                    audio_silence_threshold_msec=123
                                ),
                                input_loss_settings=medialive.CfnChannel.InputLossFailoverSettingsProperty(
                                    input_loss_threshold_msec=123
                                ),
                                video_black_settings=medialive.CfnChannel.VideoBlackFailoverSettingsProperty(
                                    black_detect_threshold=123,
                                    video_black_threshold_msec=123
                                )
                            )
                        )],
                        input_preference="inputPreference",
                        secondary_input_id="secondaryInputId"
                    ),
                    input_attachment_name="inputAttachmentName",
                    input_id="inputId",
                    input_settings=medialive.CfnChannel.InputSettingsProperty(
                        audio_selectors=[medialive.CfnChannel.AudioSelectorProperty(
                            name="name",
                            selector_settings=medialive.CfnChannel.AudioSelectorSettingsProperty(
                                audio_hls_rendition_selection=medialive.CfnChannel.AudioHlsRenditionSelectionProperty(
                                    group_id="groupId",
                                    name="name"
                                ),
                                audio_language_selection=medialive.CfnChannel.AudioLanguageSelectionProperty(
                                    language_code="languageCode",
                                    language_selection_policy="languageSelectionPolicy"
                                ),
                                audio_pid_selection=medialive.CfnChannel.AudioPidSelectionProperty(
                                    pid=123
                                ),
                                audio_track_selection=medialive.CfnChannel.AudioTrackSelectionProperty(
                                    tracks=[medialive.CfnChannel.AudioTrackProperty(
                                        track=123
                                    )]
                                )
                            )
                        )],
                        caption_selectors=[medialive.CfnChannel.CaptionSelectorProperty(
                            language_code="languageCode",
                            name="name",
                            selector_settings=medialive.CfnChannel.CaptionSelectorSettingsProperty(
                                ancillary_source_settings=medialive.CfnChannel.AncillarySourceSettingsProperty(
                                    source_ancillary_channel_number=123
                                ),
                                arib_source_settings=medialive.CfnChannel.AribSourceSettingsProperty(),
                                dvb_sub_source_settings=medialive.CfnChannel.DvbSubSourceSettingsProperty(
                                    ocr_language="ocrLanguage",
                                    pid=123
                                ),
                                embedded_source_settings=medialive.CfnChannel.EmbeddedSourceSettingsProperty(
                                    convert608_to708="convert608To708",
                                    scte20_detection="scte20Detection",
                                    source608_channel_number=123,
                                    source608_track_number=123
                                ),
                                scte20_source_settings=medialive.CfnChannel.Scte20SourceSettingsProperty(
                                    convert608_to708="convert608To708",
                                    source608_channel_number=123
                                ),
                                scte27_source_settings=medialive.CfnChannel.Scte27SourceSettingsProperty(
                                    ocr_language="ocrLanguage",
                                    pid=123
                                ),
                                teletext_source_settings=medialive.CfnChannel.TeletextSourceSettingsProperty(
                                    output_rectangle=medialive.CfnChannel.CaptionRectangleProperty(
                                        height=123,
                                        left_offset=123,
                                        top_offset=123,
                                        width=123
                                    ),
                                    page_number="pageNumber"
                                )
                            )
                        )],
                        deblock_filter="deblockFilter",
                        denoise_filter="denoiseFilter",
                        filter_strength=123,
                        input_filter="inputFilter",
                        network_input_settings=medialive.CfnChannel.NetworkInputSettingsProperty(
                            hls_input_settings=medialive.CfnChannel.HlsInputSettingsProperty(
                                bandwidth=123,
                                buffer_segments=123,
                                retries=123,
                                retry_interval=123,
                                scte35_source="scte35Source"
                            ),
                            server_validation="serverValidation"
                        ),
                        scte35_pid=123,
                        smpte2038_data_preference="smpte2038DataPreference",
                        source_end_behavior="sourceEndBehavior",
                        video_selector=medialive.CfnChannel.VideoSelectorProperty(
                            color_space="colorSpace",
                            color_space_settings=medialive.CfnChannel.VideoSelectorColorSpaceSettingsProperty(
                                hdr10_settings=medialive.CfnChannel.Hdr10SettingsProperty(
                                    max_cll=123,
                                    max_fall=123
                                )
                            ),
                            color_space_usage="colorSpaceUsage",
                            selector_settings=medialive.CfnChannel.VideoSelectorSettingsProperty(
                                video_selector_pid=medialive.CfnChannel.VideoSelectorPidProperty(
                                    pid=123
                                ),
                                video_selector_program_id=medialive.CfnChannel.VideoSelectorProgramIdProperty(
                                    program_id=123
                                )
                            )
                        )
                    )
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if automatic_input_failover_settings is not None:
                self._values["automatic_input_failover_settings"] = automatic_input_failover_settings
            if input_attachment_name is not None:
                self._values["input_attachment_name"] = input_attachment_name
            if input_id is not None:
                self._values["input_id"] = input_id
            if input_settings is not None:
                self._values["input_settings"] = input_settings

        @builtins.property
        def automatic_input_failover_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AutomaticInputFailoverSettingsProperty"]]:
            '''Settings to implement automatic input failover in this input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputattachment.html#cfn-medialive-channel-inputattachment-automaticinputfailoversettings
            '''
            result = self._values.get("automatic_input_failover_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AutomaticInputFailoverSettingsProperty"]], result)

        @builtins.property
        def input_attachment_name(self) -> typing.Optional[builtins.str]:
            '''A name for the attachment.

            This is required if you want to use this input in an input switch action.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputattachment.html#cfn-medialive-channel-inputattachment-inputattachmentname
            '''
            result = self._values.get("input_attachment_name")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def input_id(self) -> typing.Optional[builtins.str]:
            '''The ID of the input to attach.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputattachment.html#cfn-medialive-channel-inputattachment-inputid
            '''
            result = self._values.get("input_id")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def input_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputSettingsProperty"]]:
            '''Information about the content to extract from the input and about the general handling of the content.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputattachment.html#cfn-medialive-channel-inputattachment-inputsettings
            '''
            result = self._values.get("input_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputSettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "InputAttachmentProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.InputChannelLevelProperty",
        jsii_struct_bases=[],
        name_mapping={"gain": "gain", "input_channel": "inputChannel"},
    )
    class InputChannelLevelProperty:
        def __init__(
            self,
            *,
            gain: typing.Optional[jsii.Number] = None,
            input_channel: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''The setting to remix the audio.

            The parent of this entity is AudioChannelMappings.

            :param gain: The remixing value. Units are in dB, and acceptable values are within the range from -60 (mute) to 6 dB.
            :param input_channel: The index of the input channel that is used as a source.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputchannellevel.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                input_channel_level_property = medialive.CfnChannel.InputChannelLevelProperty(
                    gain=123,
                    input_channel=123
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if gain is not None:
                self._values["gain"] = gain
            if input_channel is not None:
                self._values["input_channel"] = input_channel

        @builtins.property
        def gain(self) -> typing.Optional[jsii.Number]:
            '''The remixing value.

            Units are in dB, and acceptable values are within the range from -60 (mute) to 6 dB.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputchannellevel.html#cfn-medialive-channel-inputchannellevel-gain
            '''
            result = self._values.get("gain")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def input_channel(self) -> typing.Optional[jsii.Number]:
            '''The index of the input channel that is used as a source.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputchannellevel.html#cfn-medialive-channel-inputchannellevel-inputchannel
            '''
            result = self._values.get("input_channel")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "InputChannelLevelProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.InputLocationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "password_param": "passwordParam",
            "uri": "uri",
            "username": "username",
        },
    )
    class InputLocationProperty:
        def __init__(
            self,
            *,
            password_param: typing.Optional[builtins.str] = None,
            uri: typing.Optional[builtins.str] = None,
            username: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The input location.

            The parent of this entity is InputLossBehavior.

            :param password_param: The password parameter that holds the password for accessing the downstream system. This applies only if the downstream system requires credentials.
            :param uri: The URI should be a path to a file that is accessible to the Live system (for example, an http:// URI) depending on the output type. For example, an RTMP destination should have a URI similar to rtmp://fmsserver/live.
            :param username: The user name to connect to the downstream system. This applies only if the downstream system requires credentials.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlocation.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                input_location_property = medialive.CfnChannel.InputLocationProperty(
                    password_param="passwordParam",
                    uri="uri",
                    username="username"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if password_param is not None:
                self._values["password_param"] = password_param
            if uri is not None:
                self._values["uri"] = uri
            if username is not None:
                self._values["username"] = username

        @builtins.property
        def password_param(self) -> typing.Optional[builtins.str]:
            '''The password parameter that holds the password for accessing the downstream system.

            This applies only if the downstream system requires credentials.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlocation.html#cfn-medialive-channel-inputlocation-passwordparam
            '''
            result = self._values.get("password_param")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def uri(self) -> typing.Optional[builtins.str]:
            '''The URI should be a path to a file that is accessible to the Live system (for example, an http:// URI) depending on the output type.

            For example, an RTMP destination should have a URI similar to rtmp://fmsserver/live.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlocation.html#cfn-medialive-channel-inputlocation-uri
            '''
            result = self._values.get("uri")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def username(self) -> typing.Optional[builtins.str]:
            '''The user name to connect to the downstream system.

            This applies only if the downstream system requires credentials.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlocation.html#cfn-medialive-channel-inputlocation-username
            '''
            result = self._values.get("username")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "InputLocationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.InputLossBehaviorProperty",
        jsii_struct_bases=[],
        name_mapping={
            "black_frame_msec": "blackFrameMsec",
            "input_loss_image_color": "inputLossImageColor",
            "input_loss_image_slate": "inputLossImageSlate",
            "input_loss_image_type": "inputLossImageType",
            "repeat_frame_msec": "repeatFrameMsec",
        },
    )
    class InputLossBehaviorProperty:
        def __init__(
            self,
            *,
            black_frame_msec: typing.Optional[jsii.Number] = None,
            input_loss_image_color: typing.Optional[builtins.str] = None,
            input_loss_image_slate: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputLocationProperty"]] = None,
            input_loss_image_type: typing.Optional[builtins.str] = None,
            repeat_frame_msec: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''The configuration of channel behavior when the input is lost.

            The parent of this entity is GlobalConfiguration.

            :param black_frame_msec: On input loss, the number of milliseconds to substitute black into the output before switching to the frame specified by inputLossImageType. A value x, where 0 <= x <= 1,000,000 and a value of 1,000,000, is interpreted as infinite.
            :param input_loss_image_color: When the input loss image type is "color," this field specifies the color to use. Value: 6 hex characters that represent the values of RGB.
            :param input_loss_image_slate: When the input loss image type is "slate," these fields specify the parameters for accessing the slate.
            :param input_loss_image_type: Indicates whether to substitute a solid color or a slate into the output after the input loss exceeds blackFrameMsec.
            :param repeat_frame_msec: On input loss, the number of milliseconds to repeat the previous picture before substituting black into the output. A value x, where 0 <= x <= 1,000,000 and a value of 1,000,000, is interpreted as infinite.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlossbehavior.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                input_loss_behavior_property = medialive.CfnChannel.InputLossBehaviorProperty(
                    black_frame_msec=123,
                    input_loss_image_color="inputLossImageColor",
                    input_loss_image_slate=medialive.CfnChannel.InputLocationProperty(
                        password_param="passwordParam",
                        uri="uri",
                        username="username"
                    ),
                    input_loss_image_type="inputLossImageType",
                    repeat_frame_msec=123
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if black_frame_msec is not None:
                self._values["black_frame_msec"] = black_frame_msec
            if input_loss_image_color is not None:
                self._values["input_loss_image_color"] = input_loss_image_color
            if input_loss_image_slate is not None:
                self._values["input_loss_image_slate"] = input_loss_image_slate
            if input_loss_image_type is not None:
                self._values["input_loss_image_type"] = input_loss_image_type
            if repeat_frame_msec is not None:
                self._values["repeat_frame_msec"] = repeat_frame_msec

        @builtins.property
        def black_frame_msec(self) -> typing.Optional[jsii.Number]:
            '''On input loss, the number of milliseconds to substitute black into the output before switching to the frame specified by inputLossImageType.

            A value x, where 0 <= x <= 1,000,000 and a value of 1,000,000, is interpreted as infinite.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlossbehavior.html#cfn-medialive-channel-inputlossbehavior-blackframemsec
            '''
            result = self._values.get("black_frame_msec")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def input_loss_image_color(self) -> typing.Optional[builtins.str]:
            '''When the input loss image type is "color," this field specifies the color to use.

            Value: 6 hex characters that represent the values of RGB.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlossbehavior.html#cfn-medialive-channel-inputlossbehavior-inputlossimagecolor
            '''
            result = self._values.get("input_loss_image_color")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def input_loss_image_slate(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputLocationProperty"]]:
            '''When the input loss image type is "slate," these fields specify the parameters for accessing the slate.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlossbehavior.html#cfn-medialive-channel-inputlossbehavior-inputlossimageslate
            '''
            result = self._values.get("input_loss_image_slate")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.InputLocationProperty"]], result)

        @builtins.property
        def input_loss_image_type(self) -> typing.Optional[builtins.str]:
            '''Indicates whether to substitute a solid color or a slate into the output after the input loss exceeds blackFrameMsec.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlossbehavior.html#cfn-medialive-channel-inputlossbehavior-inputlossimagetype
            '''
            result = self._values.get("input_loss_image_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def repeat_frame_msec(self) -> typing.Optional[jsii.Number]:
            '''On input loss, the number of milliseconds to repeat the previous picture before substituting black into the output.

            A value x, where 0 <= x <= 1,000,000 and a value of 1,000,000, is interpreted as infinite.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlossbehavior.html#cfn-medialive-channel-inputlossbehavior-repeatframemsec
            '''
            result = self._values.get("repeat_frame_msec")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "InputLossBehaviorProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.InputLossFailoverSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"input_loss_threshold_msec": "inputLossThresholdMsec"},
    )
    class InputLossFailoverSettingsProperty:
        def __init__(
            self,
            *,
            input_loss_threshold_msec: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''MediaLive will perform a failover if content is not detected in this input for the specified period.

            The parent of this entity is FailoverConditionSettings.

            :param input_loss_threshold_msec: The amount of time (in milliseconds) that no input is detected. After that time, an input failover will occur.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlossfailoversettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                input_loss_failover_settings_property = medialive.CfnChannel.InputLossFailoverSettingsProperty(
                    input_loss_threshold_msec=123
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if input_loss_threshold_msec is not None:
                self._values["input_loss_threshold_msec"] = input_loss_threshold_msec

        @builtins.property
        def input_loss_threshold_msec(self) -> typing.Optional[jsii.Number]:
            '''The amount of time (in milliseconds) that no input is detected.

            After that time, an input failover will occur.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlossfailoversettings.html#cfn-medialive-channel-inputlossfailoversettings-inputlossthresholdmsec
            '''
            result = self._values.get("input_loss_threshold_msec")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "InputLossFailoverSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.InputSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "audio_selectors": "audioSelectors",
            "caption_selectors": "captionSelectors",
            "deblock_filter": "deblockFilter",
            "denoise_filter": "denoiseFilter",
            "filter_strength": "filterStrength",
            "input_filter": "inputFilter",
            "network_input_settings": "networkInputSettings",
            "scte35_pid": "scte35Pid",
            "smpte2038_data_preference": "smpte2038DataPreference",
            "source_end_behavior": "sourceEndBehavior",
            "video_selector": "videoSelector",
        },
    )
    class InputSettingsProperty:
        def __init__(
            self,
            *,
            audio_selectors: typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.Sequence[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioSelectorProperty"]]]] = None,
            caption_selectors: typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.Sequence[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.CaptionSelectorProperty"]]]] = None,
            deblock_filter: typing.Optional[builtins.str] = None,
            denoise_filter: typing.Optional[builtins.str] = None,
            filter_strength: typing.Optional[jsii.Number] = None,
            input_filter: typing.Optional[builtins.str] = None,
            network_input_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.NetworkInputSettingsProperty"]] = None,
            scte35_pid: typing.Optional[jsii.Number] = None,
            smpte2038_data_preference: typing.Optional[builtins.str] = None,
            source_end_behavior: typing.Optional[builtins.str] = None,
            video_selector: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.VideoSelectorProperty"]] = None,
        ) -> None:
            '''Information about extracting content from the input and about handling the content.

            The parent of this entity is InputAttachment.

            :param audio_selectors: Information about the specific audio to extract from the input. The parent of this entity is InputSettings.
            :param caption_selectors: Information about the specific captions to extract from the input.
            :param deblock_filter: Enables or disables the deblock filter when filtering.
            :param denoise_filter: Enables or disables the denoise filter when filtering.
            :param filter_strength: Adjusts the magnitude of filtering from 1 (minimal) to 5 (strongest).
            :param input_filter: Turns on the filter for this input. MPEG-2 inputs have the deblocking filter enabled by default. 1) auto - filtering is applied depending on input type/quality 2) disabled - no filtering is applied to the input 3) forced - filtering is applied regardless of the input type.
            :param network_input_settings: Information about how to connect to the upstream system.
            :param scte35_pid: ``CfnChannel.InputSettingsProperty.Scte35Pid``.
            :param smpte2038_data_preference: Specifies whether to extract applicable ancillary data from a SMPTE-2038 source in this input. Applicable data types are captions, timecode, AFD, and SCTE-104 messages. - PREFER: Extract from SMPTE-2038 if present in this input, otherwise extract from another source (if any). - IGNORE: Never extract any ancillary data from SMPTE-2038.
            :param source_end_behavior: The loop input if it is a file.
            :param video_selector: Information about one video to extract from the input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                input_settings_property = medialive.CfnChannel.InputSettingsProperty(
                    audio_selectors=[medialive.CfnChannel.AudioSelectorProperty(
                        name="name",
                        selector_settings=medialive.CfnChannel.AudioSelectorSettingsProperty(
                            audio_hls_rendition_selection=medialive.CfnChannel.AudioHlsRenditionSelectionProperty(
                                group_id="groupId",
                                name="name"
                            ),
                            audio_language_selection=medialive.CfnChannel.AudioLanguageSelectionProperty(
                                language_code="languageCode",
                                language_selection_policy="languageSelectionPolicy"
                            ),
                            audio_pid_selection=medialive.CfnChannel.AudioPidSelectionProperty(
                                pid=123
                            ),
                            audio_track_selection=medialive.CfnChannel.AudioTrackSelectionProperty(
                                tracks=[medialive.CfnChannel.AudioTrackProperty(
                                    track=123
                                )]
                            )
                        )
                    )],
                    caption_selectors=[medialive.CfnChannel.CaptionSelectorProperty(
                        language_code="languageCode",
                        name="name",
                        selector_settings=medialive.CfnChannel.CaptionSelectorSettingsProperty(
                            ancillary_source_settings=medialive.CfnChannel.AncillarySourceSettingsProperty(
                                source_ancillary_channel_number=123
                            ),
                            arib_source_settings=medialive.CfnChannel.AribSourceSettingsProperty(),
                            dvb_sub_source_settings=medialive.CfnChannel.DvbSubSourceSettingsProperty(
                                ocr_language="ocrLanguage",
                                pid=123
                            ),
                            embedded_source_settings=medialive.CfnChannel.EmbeddedSourceSettingsProperty(
                                convert608_to708="convert608To708",
                                scte20_detection="scte20Detection",
                                source608_channel_number=123,
                                source608_track_number=123
                            ),
                            scte20_source_settings=medialive.CfnChannel.Scte20SourceSettingsProperty(
                                convert608_to708="convert608To708",
                                source608_channel_number=123
                            ),
                            scte27_source_settings=medialive.CfnChannel.Scte27SourceSettingsProperty(
                                ocr_language="ocrLanguage",
                                pid=123
                            ),
                            teletext_source_settings=medialive.CfnChannel.TeletextSourceSettingsProperty(
                                output_rectangle=medialive.CfnChannel.CaptionRectangleProperty(
                                    height=123,
                                    left_offset=123,
                                    top_offset=123,
                                    width=123
                                ),
                                page_number="pageNumber"
                            )
                        )
                    )],
                    deblock_filter="deblockFilter",
                    denoise_filter="denoiseFilter",
                    filter_strength=123,
                    input_filter="inputFilter",
                    network_input_settings=medialive.CfnChannel.NetworkInputSettingsProperty(
                        hls_input_settings=medialive.CfnChannel.HlsInputSettingsProperty(
                            bandwidth=123,
                            buffer_segments=123,
                            retries=123,
                            retry_interval=123,
                            scte35_source="scte35Source"
                        ),
                        server_validation="serverValidation"
                    ),
                    scte35_pid=123,
                    smpte2038_data_preference="smpte2038DataPreference",
                    source_end_behavior="sourceEndBehavior",
                    video_selector=medialive.CfnChannel.VideoSelectorProperty(
                        color_space="colorSpace",
                        color_space_settings=medialive.CfnChannel.VideoSelectorColorSpaceSettingsProperty(
                            hdr10_settings=medialive.CfnChannel.Hdr10SettingsProperty(
                                max_cll=123,
                                max_fall=123
                            )
                        ),
                        color_space_usage="colorSpaceUsage",
                        selector_settings=medialive.CfnChannel.VideoSelectorSettingsProperty(
                            video_selector_pid=medialive.CfnChannel.VideoSelectorPidProperty(
                                pid=123
                            ),
                            video_selector_program_id=medialive.CfnChannel.VideoSelectorProgramIdProperty(
                                program_id=123
                            )
                        )
                    )
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if audio_selectors is not None:
                self._values["audio_selectors"] = audio_selectors
            if caption_selectors is not None:
                self._values["caption_selectors"] = caption_selectors
            if deblock_filter is not None:
                self._values["deblock_filter"] = deblock_filter
            if denoise_filter is not None:
                self._values["denoise_filter"] = denoise_filter
            if filter_strength is not None:
                self._values["filter_strength"] = filter_strength
            if input_filter is not None:
                self._values["input_filter"] = input_filter
            if network_input_settings is not None:
                self._values["network_input_settings"] = network_input_settings
            if scte35_pid is not None:
                self._values["scte35_pid"] = scte35_pid
            if smpte2038_data_preference is not None:
                self._values["smpte2038_data_preference"] = smpte2038_data_preference
            if source_end_behavior is not None:
                self._values["source_end_behavior"] = source_end_behavior
            if video_selector is not None:
                self._values["video_selector"] = video_selector

        @builtins.property
        def audio_selectors(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioSelectorProperty"]]]]:
            '''Information about the specific audio to extract from the input.

            The parent of this entity is InputSettings.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-audioselectors
            '''
            result = self._values.get("audio_selectors")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.AudioSelectorProperty"]]]], result)

        @builtins.property
        def caption_selectors(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.CaptionSelectorProperty"]]]]:
            '''Information about the specific captions to extract from the input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-captionselectors
            '''
            result = self._values.get("caption_selectors")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.CaptionSelectorProperty"]]]], result)

        @builtins.property
        def deblock_filter(self) -> typing.Optional[builtins.str]:
            '''Enables or disables the deblock filter when filtering.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-deblockfilter
            '''
            result = self._values.get("deblock_filter")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def denoise_filter(self) -> typing.Optional[builtins.str]:
            '''Enables or disables the denoise filter when filtering.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-denoisefilter
            '''
            result = self._values.get("denoise_filter")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def filter_strength(self) -> typing.Optional[jsii.Number]:
            '''Adjusts the magnitude of filtering from 1 (minimal) to 5 (strongest).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-filterstrength
            '''
            result = self._values.get("filter_strength")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def input_filter(self) -> typing.Optional[builtins.str]:
            '''Turns on the filter for this input.

            MPEG-2 inputs have the deblocking filter enabled by default. 1) auto - filtering is applied depending on input type/quality 2) disabled - no filtering is applied to the input 3) forced - filtering is applied regardless of the input type.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-inputfilter
            '''
            result = self._values.get("input_filter")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def network_input_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.NetworkInputSettingsProperty"]]:
            '''Information about how to connect to the upstream system.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-networkinputsettings
            '''
            result = self._values.get("network_input_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.NetworkInputSettingsProperty"]], result)

        @builtins.property
        def scte35_pid(self) -> typing.Optional[jsii.Number]:
            '''``CfnChannel.InputSettingsProperty.Scte35Pid``.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-scte35pid
            '''
            result = self._values.get("scte35_pid")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def smpte2038_data_preference(self) -> typing.Optional[builtins.str]:
            '''Specifies whether to extract applicable ancillary data from a SMPTE-2038 source in this input.

            Applicable data types are captions, timecode, AFD, and SCTE-104 messages.

            - PREFER: Extract from SMPTE-2038 if present in this input, otherwise extract from another source (if any).
            - IGNORE: Never extract any ancillary data from SMPTE-2038.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-smpte2038datapreference
            '''
            result = self._values.get("smpte2038_data_preference")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def source_end_behavior(self) -> typing.Optional[builtins.str]:
            '''The loop input if it is a file.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-sourceendbehavior
            '''
            result = self._values.get("source_end_behavior")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def video_selector(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.VideoSelectorProperty"]]:
            '''Information about one video to extract from the input.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-videoselector
            '''
            result = self._values.get("video_selector")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.VideoSelectorProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "InputSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.InputSpecificationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "codec": "codec",
            "maximum_bitrate": "maximumBitrate",
            "resolution": "resolution",
        },
    )
    class InputSpecificationProperty:
        def __init__(
            self,
            *,
            codec: typing.Optional[builtins.str] = None,
            maximum_bitrate: typing.Optional[builtins.str] = None,
            resolution: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The input specification for this channel.

            It specifies the key characteristics of the inputs for this channel: the maximum bitrate, the resolution, and the codec.

            This entity is at the top level in the channel.

            :param codec: The codec to include in the input specification for this channel.
            :param maximum_bitrate: The maximum input bitrate for any input attached to this channel.
            :param resolution: The resolution for any input attached to this channel.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputspecification.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                input_specification_property = medialive.CfnChannel.InputSpecificationProperty(
                    codec="codec",
                    maximum_bitrate="maximumBitrate",
                    resolution="resolution"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if codec is not None:
                self._values["codec"] = codec
            if maximum_bitrate is not None:
                self._values["maximum_bitrate"] = maximum_bitrate
            if resolution is not None:
                self._values["resolution"] = resolution

        @builtins.property
        def codec(self) -> typing.Optional[builtins.str]:
            '''The codec to include in the input specification for this channel.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputspecification.html#cfn-medialive-channel-inputspecification-codec
            '''
            result = self._values.get("codec")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def maximum_bitrate(self) -> typing.Optional[builtins.str]:
            '''The maximum input bitrate for any input attached to this channel.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputspecification.html#cfn-medialive-channel-inputspecification-maximumbitrate
            '''
            result = self._values.get("maximum_bitrate")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def resolution(self) -> typing.Optional[builtins.str]:
            '''The resolution for any input attached to this channel.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputspecification.html#cfn-medialive-channel-inputspecification-resolution
            '''
            result = self._values.get("resolution")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "InputSpecificationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.KeyProviderSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"static_key_settings": "staticKeySettings"},
    )
    class KeyProviderSettingsProperty:
        def __init__(
            self,
            *,
            static_key_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.StaticKeySettingsProperty"]] = None,
        ) -> None:
            '''The configuration of key provider settings.

            The parent of this entity is HlsGroupSettings.

            :param static_key_settings: The configuration of static key settings.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-keyprovidersettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                key_provider_settings_property = medialive.CfnChannel.KeyProviderSettingsProperty(
                    static_key_settings=medialive.CfnChannel.StaticKeySettingsProperty(
                        key_provider_server=medialive.CfnChannel.InputLocationProperty(
                            password_param="passwordParam",
                            uri="uri",
                            username="username"
                        ),
                        static_key_value="staticKeyValue"
                    )
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if static_key_settings is not None:
                self._values["static_key_settings"] = static_key_settings

        @builtins.property
        def static_key_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.StaticKeySettingsProperty"]]:
            '''The configuration of static key settings.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-keyprovidersettings.html#cfn-medialive-channel-keyprovidersettings-statickeysettings
            '''
            result = self._values.get("static_key_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.StaticKeySettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "KeyProviderSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.M2tsSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "absent_input_audio_behavior": "absentInputAudioBehavior",
            "arib": "arib",
            "arib_captions_pid": "aribCaptionsPid",
            "arib_captions_pid_control": "aribCaptionsPidControl",
            "audio_buffer_model": "audioBufferModel",
            "audio_frames_per_pes": "audioFramesPerPes",
            "audio_pids": "audioPids",
            "audio_stream_type": "audioStreamType",
            "bitrate": "bitrate",
            "buffer_model": "bufferModel",
            "cc_descriptor": "ccDescriptor",
            "dvb_nit_settings": "dvbNitSettings",
            "dvb_sdt_settings": "dvbSdtSettings",
            "dvb_sub_pids": "dvbSubPids",
            "dvb_tdt_settings": "dvbTdtSettings",
            "dvb_teletext_pid": "dvbTeletextPid",
            "ebif": "ebif",
            "ebp_audio_interval": "ebpAudioInterval",
            "ebp_lookahead_ms": "ebpLookaheadMs",
            "ebp_placement": "ebpPlacement",
            "ecm_pid": "ecmPid",
            "es_rate_in_pes": "esRateInPes",
            "etv_platform_pid": "etvPlatformPid",
            "etv_signal_pid": "etvSignalPid",
            "fragment_time": "fragmentTime",
            "klv": "klv",
            "klv_data_pids": "klvDataPids",
            "nielsen_id3_behavior": "nielsenId3Behavior",
            "null_packet_bitrate": "nullPacketBitrate",
            "pat_interval": "patInterval",
            "pcr_control": "pcrControl",
            "pcr_period": "pcrPeriod",
            "pcr_pid": "pcrPid",
            "pmt_interval": "pmtInterval",
            "pmt_pid": "pmtPid",
            "program_num": "programNum",
            "rate_mode": "rateMode",
            "scte27_pids": "scte27Pids",
            "scte35_control": "scte35Control",
            "scte35_pid": "scte35Pid",
            "segmentation_markers": "segmentationMarkers",
            "segmentation_style": "segmentationStyle",
            "segmentation_time": "segmentationTime",
            "timed_metadata_behavior": "timedMetadataBehavior",
            "timed_metadata_pid": "timedMetadataPid",
            "transport_stream_id": "transportStreamId",
            "video_pid": "videoPid",
        },
    )
    class M2tsSettingsProperty:
        def __init__(
            self,
            *,
            absent_input_audio_behavior: typing.Optional[builtins.str] = None,
            arib: typing.Optional[builtins.str] = None,
            arib_captions_pid: typing.Optional[builtins.str] = None,
            arib_captions_pid_control: typing.Optional[builtins.str] = None,
            audio_buffer_model: typing.Optional[builtins.str] = None,
            audio_frames_per_pes: typing.Optional[jsii.Number] = None,
            audio_pids: typing.Optional[builtins.str] = None,
            audio_stream_type: typing.Optional[builtins.str] = None,
            bitrate: typing.Optional[jsii.Number] = None,
            buffer_model: typing.Optional[builtins.str] = None,
            cc_descriptor: typing.Optional[builtins.str] = None,
            dvb_nit_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.DvbNitSettingsProperty"]] = None,
            dvb_sdt_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.DvbSdtSettingsProperty"]] = None,
            dvb_sub_pids: typing.Optional[builtins.str] = None,
            dvb_tdt_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.DvbTdtSettingsProperty"]] = None,
            dvb_teletext_pid: typing.Optional[builtins.str] = None,
            ebif: typing.Optional[builtins.str] = None,
            ebp_audio_interval: typing.Optional[builtins.str] = None,
            ebp_lookahead_ms: typing.Optional[jsii.Number] = None,
            ebp_placement: typing.Optional[builtins.str] = None,
            ecm_pid: typing.Optional[builtins.str] = None,
            es_rate_in_pes: typing.Optional[builtins.str] = None,
            etv_platform_pid: typing.Optional[builtins.str] = None,
            etv_signal_pid: typing.Optional[builtins.str] = None,
            fragment_time: typing.Optional[jsii.Number] = None,
            klv: typing.Optional[builtins.str] = None,
            klv_data_pids: typing.Optional[builtins.str] = None,
            nielsen_id3_behavior: typing.Optional[builtins.str] = None,
            null_packet_bitrate: typing.Optional[jsii.Number] = None,
            pat_interval: typing.Optional[jsii.Number] = None,
            pcr_control: typing.Optional[builtins.str] = None,
            pcr_period: typing.Optional[jsii.Number] = None,
            pcr_pid: typing.Optional[builtins.str] = None,
            pmt_interval: typing.Optional[jsii.Number] = None,
            pmt_pid: typing.Optional[builtins.str] = None,
            program_num: typing.Optional[jsii.Number] = None,
            rate_mode: typing.Optional[builtins.str] = None,
            scte27_pids: typing.Optional[builtins.str] = None,
            scte35_control: typing.Optional[builtins.str] = None,
            scte35_pid: typing.Optional[builtins.str] = None,
            segmentation_markers: typing.Optional[builtins.str] = None,
            segmentation_style: typing.Optional[builtins.str] = None,
            segmentation_time: typing.Optional[jsii.Number] = None,
            timed_metadata_behavior: typing.Optional[builtins.str] = None,
            timed_metadata_pid: typing.Optional[builtins.str] = None,
            transport_stream_id: typing.Optional[jsii.Number] = None,
            video_pid: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The configuration of the M2TS in the output.

            The parents of this entity are ArchiveContainerSettings and UdpContainerSettings.

            :param absent_input_audio_behavior: When set to drop, the output audio streams are removed from the program if the selected input audio stream is removed from the input. This allows the output audio configuration to dynamically change based on the input configuration. If this is set to encodeSilence, all output audio streams will output encoded silence when not connected to an active input stream.
            :param arib: When set to enabled, uses ARIB-compliant field muxing and removes video descriptor.
            :param arib_captions_pid: The PID for ARIB Captions in the transport stream. You can enter the value as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
            :param arib_captions_pid_control: If set to auto, The PID number used for ARIB Captions will be auto-selected from unused PIDs. If set to useConfigured, ARIB captions will be on the configured PID number.
            :param audio_buffer_model: When set to dvb, uses the DVB buffer model for Dolby Digital audio. When set to atsc, the ATSC model is used.
            :param audio_frames_per_pes: The number of audio frames to insert for each PES packet.
            :param audio_pids: The PID of the elementary audio streams in the transport stream. Multiple values are accepted, and can be entered in ranges or by comma separation. You can enter the value as a decimal or hexadecimal value. Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
            :param audio_stream_type: When set to atsc, uses stream type = 0x81 for AC3 and stream type = 0x87 for EAC3. When set to dvb, uses stream type = 0x06.
            :param bitrate: The output bitrate of the transport stream in bits per second. Setting to 0 lets the muxer automatically determine the appropriate bitrate.
            :param buffer_model: If set to multiplex, uses the multiplex buffer model for accurate interleaving. Setting to bufferModel to none can lead to lower latency, but low-memory devices might not be able to play back the stream without interruptions.
            :param cc_descriptor: When set to enabled, generates captionServiceDescriptor in PMT.
            :param dvb_nit_settings: Inserts a DVB Network Information Table (NIT) at the specified table repetition interval.
            :param dvb_sdt_settings: Inserts a DVB Service Description Table (SDT) at the specified table repetition interval.
            :param dvb_sub_pids: The PID for the input source DVB Subtitle data to this output. Multiple values are accepted, and can be entered in ranges and/or by comma separation. You can enter the value as a decimal or hexadecimal value. Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
            :param dvb_tdt_settings: Inserts DVB Time and Date Table (TDT) at the specified table repetition interval.
            :param dvb_teletext_pid: The PID for the input source DVB Teletext data to this output. You can enter the value as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
            :param ebif: If set to passthrough, passes any EBIF data from the input source to this output.
            :param ebp_audio_interval: When videoAndFixedIntervals is selected, audio EBP markers are added to partitions 3 and 4. The interval between these additional markers is fixed, and is slightly shorter than the video EBP marker interval. This is only available when EBP Cablelabs segmentation markers are selected. Partitions 1 and 2 always follow the video interval.
            :param ebp_lookahead_ms: When set, enforces that Encoder Boundary Points do not come within the specified time interval of each other by looking ahead at input video. If another EBP is going to come in within the specified time interval, the current EBP is not emitted, and the segment is "stretched" to the next marker. The lookahead value does not add latency to the system. The channel must be configured elsewhere to create sufficient latency to make the lookahead accurate.
            :param ebp_placement: Controls placement of EBP on audio PIDs. If set to videoAndAudioPids, EBP markers are placed on the video PID and all audio PIDs. If set to videoPid, EBP markers are placed on only the video PID.
            :param ecm_pid: This field is unused and deprecated.
            :param es_rate_in_pes: Includes or excludes the ES Rate field in the PES header.
            :param etv_platform_pid: The PID for the input source ETV Platform data to this output. You can enter it as a decimal or hexadecimal value. Valid values are 32 (or 0x20) to 8182 (or 0x1ff6).
            :param etv_signal_pid: The PID for input source ETV Signal data to this output. You can enter the value as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
            :param fragment_time: The length in seconds of each fragment. This is used only with EBP markers.
            :param klv: If set to passthrough, passes any KLV data from the input source to this output.
            :param klv_data_pids: The PID for the input source KLV data to this output. Multiple values are accepted, and can be entered in ranges or by comma separation. You can enter the value as a decimal or hexadecimal value. Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
            :param nielsen_id3_behavior: If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an equivalent ID3 tag will be inserted in the output.
            :param null_packet_bitrate: The value, in bits per second, of extra null packets to insert into the transport stream. This can be used if a downstream encryption system requires periodic null packets.
            :param pat_interval: The number of milliseconds between instances of this table in the output transport stream. Valid values are 0, 10..1000.
            :param pcr_control: When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized Elementary Stream (PES) header. This parameter is effective only when the PCR PID is the same as the video or audio elementary stream.
            :param pcr_period: The maximum time, in milliseconds, between Program Clock References (PCRs) inserted into the transport stream.
            :param pcr_pid: The PID of the Program Clock Reference (PCR) in the transport stream. When no value is given, MediaLive assigns the same value as the video PID. You can enter the value as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
            :param pmt_interval: The number of milliseconds between instances of this table in the output transport stream. Valid values are 0, 10..1000.
            :param pmt_pid: The PID for the Program Map Table (PMT) in the transport stream. You can enter the value as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
            :param program_num: The value of the program number field in the Program Map Table (PMT).
            :param rate_mode: When VBR, does not insert null packets into the transport stream to fill the specified bitrate. The bitrate setting acts as the maximum bitrate when VBR is set.
            :param scte27_pids: The PID for the input source SCTE-27 data to this output. Multiple values are accepted, and can be entered in ranges or by comma separation. You can enter the value as a decimal or hexadecimal value. Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
            :param scte35_control: Optionally passes SCTE-35 signals from the input source to this output.
            :param scte35_pid: The PID of the SCTE-35 stream in the transport stream. You can enter the value as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
            :param segmentation_markers: Inserts segmentation markers at each segmentationTime period. raiSegstart sets the Random Access Indicator bit in the adaptation field. raiAdapt sets the RAI bit and adds the current timecode in the private data bytes. psiSegstart inserts PAT and PMT tables at the start of segments. ebp adds Encoder Boundary Point information to the adaptation field as per OpenCable specification OC-SP-EBP-I01-130118. ebpLegacy adds Encoder Boundary Point information to the adaptation field using a legacy proprietary format.
            :param segmentation_style: The segmentation style parameter controls how segmentation markers are inserted into the transport stream. With avails, it is possible that segments might be truncated, which can influence where future segmentation markers are inserted. When a segmentation style of resetCadence is selected and a segment is truncated due to an avail, we will reset the segmentation cadence. This means the subsequent segment will have a duration of $segmentationTime seconds. When a segmentation style of maintainCadence is selected and a segment is truncated due to an avail, we will not reset the segmentation cadence. This means the subsequent segment will likely be truncated as well. However, all segments after that will have a duration of $segmentationTime seconds. Note that EBP lookahead is a slight exception to this rule.
            :param segmentation_time: The length, in seconds, of each segment. This is required unless markers is set to None_.
            :param timed_metadata_behavior: When set to passthrough, timed metadata is passed through from input to output.
            :param timed_metadata_pid: The PID of the timed metadata stream in the transport stream. You can enter the value as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
            :param transport_stream_id: The value of the transport stream ID field in the Program Map Table (PMT).
            :param video_pid: The PID of the elementary video stream in the transport stream. You can enter the value as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                m2ts_settings_property = medialive.CfnChannel.M2tsSettingsProperty(
                    absent_input_audio_behavior="absentInputAudioBehavior",
                    arib="arib",
                    arib_captions_pid="aribCaptionsPid",
                    arib_captions_pid_control="aribCaptionsPidControl",
                    audio_buffer_model="audioBufferModel",
                    audio_frames_per_pes=123,
                    audio_pids="audioPids",
                    audio_stream_type="audioStreamType",
                    bitrate=123,
                    buffer_model="bufferModel",
                    cc_descriptor="ccDescriptor",
                    dvb_nit_settings=medialive.CfnChannel.DvbNitSettingsProperty(
                        network_id=123,
                        network_name="networkName",
                        rep_interval=123
                    ),
                    dvb_sdt_settings=medialive.CfnChannel.DvbSdtSettingsProperty(
                        output_sdt="outputSdt",
                        rep_interval=123,
                        service_name="serviceName",
                        service_provider_name="serviceProviderName"
                    ),
                    dvb_sub_pids="dvbSubPids",
                    dvb_tdt_settings=medialive.CfnChannel.DvbTdtSettingsProperty(
                        rep_interval=123
                    ),
                    dvb_teletext_pid="dvbTeletextPid",
                    ebif="ebif",
                    ebp_audio_interval="ebpAudioInterval",
                    ebp_lookahead_ms=123,
                    ebp_placement="ebpPlacement",
                    ecm_pid="ecmPid",
                    es_rate_in_pes="esRateInPes",
                    etv_platform_pid="etvPlatformPid",
                    etv_signal_pid="etvSignalPid",
                    fragment_time=123,
                    klv="klv",
                    klv_data_pids="klvDataPids",
                    nielsen_id3_behavior="nielsenId3Behavior",
                    null_packet_bitrate=123,
                    pat_interval=123,
                    pcr_control="pcrControl",
                    pcr_period=123,
                    pcr_pid="pcrPid",
                    pmt_interval=123,
                    pmt_pid="pmtPid",
                    program_num=123,
                    rate_mode="rateMode",
                    scte27_pids="scte27Pids",
                    scte35_control="scte35Control",
                    scte35_pid="scte35Pid",
                    segmentation_markers="segmentationMarkers",
                    segmentation_style="segmentationStyle",
                    segmentation_time=123,
                    timed_metadata_behavior="timedMetadataBehavior",
                    timed_metadata_pid="timedMetadataPid",
                    transport_stream_id=123,
                    video_pid="videoPid"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if absent_input_audio_behavior is not None:
                self._values["absent_input_audio_behavior"] = absent_input_audio_behavior
            if arib is not None:
                self._values["arib"] = arib
            if arib_captions_pid is not None:
                self._values["arib_captions_pid"] = arib_captions_pid
            if arib_captions_pid_control is not None:
                self._values["arib_captions_pid_control"] = arib_captions_pid_control
            if audio_buffer_model is not None:
                self._values["audio_buffer_model"] = audio_buffer_model
            if audio_frames_per_pes is not None:
                self._values["audio_frames_per_pes"] = audio_frames_per_pes
            if audio_pids is not None:
                self._values["audio_pids"] = audio_pids
            if audio_stream_type is not None:
                self._values["audio_stream_type"] = audio_stream_type
            if bitrate is not None:
                self._values["bitrate"] = bitrate
            if buffer_model is not None:
                self._values["buffer_model"] = buffer_model
            if cc_descriptor is not None:
                self._values["cc_descriptor"] = cc_descriptor
            if dvb_nit_settings is not None:
                self._values["dvb_nit_settings"] = dvb_nit_settings
            if dvb_sdt_settings is not None:
                self._values["dvb_sdt_settings"] = dvb_sdt_settings
            if dvb_sub_pids is not None:
                self._values["dvb_sub_pids"] = dvb_sub_pids
            if dvb_tdt_settings is not None:
                self._values["dvb_tdt_settings"] = dvb_tdt_settings
            if dvb_teletext_pid is not None:
                self._values["dvb_teletext_pid"] = dvb_teletext_pid
            if ebif is not None:
                self._values["ebif"] = ebif
            if ebp_audio_interval is not None:
                self._values["ebp_audio_interval"] = ebp_audio_interval
            if ebp_lookahead_ms is not None:
                self._values["ebp_lookahead_ms"] = ebp_lookahead_ms
            if ebp_placement is not None:
                self._values["ebp_placement"] = ebp_placement
            if ecm_pid is not None:
                self._values["ecm_pid"] = ecm_pid
            if es_rate_in_pes is not None:
                self._values["es_rate_in_pes"] = es_rate_in_pes
            if etv_platform_pid is not None:
                self._values["etv_platform_pid"] = etv_platform_pid
            if etv_signal_pid is not None:
                self._values["etv_signal_pid"] = etv_signal_pid
            if fragment_time is not None:
                self._values["fragment_time"] = fragment_time
            if klv is not None:
                self._values["klv"] = klv
            if klv_data_pids is not None:
                self._values["klv_data_pids"] = klv_data_pids
            if nielsen_id3_behavior is not None:
                self._values["nielsen_id3_behavior"] = nielsen_id3_behavior
            if null_packet_bitrate is not None:
                self._values["null_packet_bitrate"] = null_packet_bitrate
            if pat_interval is not None:
                self._values["pat_interval"] = pat_interval
            if pcr_control is not None:
                self._values["pcr_control"] = pcr_control
            if pcr_period is not None:
                self._values["pcr_period"] = pcr_period
            if pcr_pid is not None:
                self._values["pcr_pid"] = pcr_pid
            if pmt_interval is not None:
                self._values["pmt_interval"] = pmt_interval
            if pmt_pid is not None:
                self._values["pmt_pid"] = pmt_pid
            if program_num is not None:
                self._values["program_num"] = program_num
            if rate_mode is not None:
                self._values["rate_mode"] = rate_mode
            if scte27_pids is not None:
                self._values["scte27_pids"] = scte27_pids
            if scte35_control is not None:
                self._values["scte35_control"] = scte35_control
            if scte35_pid is not None:
                self._values["scte35_pid"] = scte35_pid
            if segmentation_markers is not None:
                self._values["segmentation_markers"] = segmentation_markers
            if segmentation_style is not None:
                self._values["segmentation_style"] = segmentation_style
            if segmentation_time is not None:
                self._values["segmentation_time"] = segmentation_time
            if timed_metadata_behavior is not None:
                self._values["timed_metadata_behavior"] = timed_metadata_behavior
            if timed_metadata_pid is not None:
                self._values["timed_metadata_pid"] = timed_metadata_pid
            if transport_stream_id is not None:
                self._values["transport_stream_id"] = transport_stream_id
            if video_pid is not None:
                self._values["video_pid"] = video_pid

        @builtins.property
        def absent_input_audio_behavior(self) -> typing.Optional[builtins.str]:
            '''When set to drop, the output audio streams are removed from the program if the selected input audio stream is removed from the input.

            This allows the output audio configuration to dynamically change based on the input configuration. If this is set to encodeSilence, all output audio streams will output encoded silence when not connected to an active input stream.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-absentinputaudiobehavior
            '''
            result = self._values.get("absent_input_audio_behavior")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def arib(self) -> typing.Optional[builtins.str]:
            '''When set to enabled, uses ARIB-compliant field muxing and removes video descriptor.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-arib
            '''
            result = self._values.get("arib")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def arib_captions_pid(self) -> typing.Optional[builtins.str]:
            '''The PID for ARIB Captions in the transport stream.

            You can enter the value as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-aribcaptionspid
            '''
            result = self._values.get("arib_captions_pid")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def arib_captions_pid_control(self) -> typing.Optional[builtins.str]:
            '''If set to auto, The PID number used for ARIB Captions will be auto-selected from unused PIDs.

            If set to useConfigured, ARIB captions will be on the configured PID number.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-aribcaptionspidcontrol
            '''
            result = self._values.get("arib_captions_pid_control")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def audio_buffer_model(self) -> typing.Optional[builtins.str]:
            '''When set to dvb, uses the DVB buffer model for Dolby Digital audio.

            When set to atsc, the ATSC model is used.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-audiobuffermodel
            '''
            result = self._values.get("audio_buffer_model")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def audio_frames_per_pes(self) -> typing.Optional[jsii.Number]:
            '''The number of audio frames to insert for each PES packet.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-audioframesperpes
            '''
            result = self._values.get("audio_frames_per_pes")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def audio_pids(self) -> typing.Optional[builtins.str]:
            '''The PID of the elementary audio streams in the transport stream.

            Multiple values are accepted, and can be entered in ranges or by comma separation. You can enter the value as a decimal or hexadecimal value. Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-audiopids
            '''
            result = self._values.get("audio_pids")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def audio_stream_type(self) -> typing.Optional[builtins.str]:
            '''When set to atsc, uses stream type = 0x81 for AC3 and stream type = 0x87 for EAC3.

            When set to dvb, uses stream type = 0x06.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-audiostreamtype
            '''
            result = self._values.get("audio_stream_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def bitrate(self) -> typing.Optional[jsii.Number]:
            '''The output bitrate of the transport stream in bits per second.

            Setting to 0 lets the muxer automatically determine the appropriate bitrate.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-bitrate
            '''
            result = self._values.get("bitrate")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def buffer_model(self) -> typing.Optional[builtins.str]:
            '''If set to multiplex, uses the multiplex buffer model for accurate interleaving.

            Setting to bufferModel to none can lead to lower latency, but low-memory devices might not be able to play back the stream without interruptions.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-buffermodel
            '''
            result = self._values.get("buffer_model")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def cc_descriptor(self) -> typing.Optional[builtins.str]:
            '''When set to enabled, generates captionServiceDescriptor in PMT.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-ccdescriptor
            '''
            result = self._values.get("cc_descriptor")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def dvb_nit_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.DvbNitSettingsProperty"]]:
            '''Inserts a DVB Network Information Table (NIT) at the specified table repetition interval.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-dvbnitsettings
            '''
            result = self._values.get("dvb_nit_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.DvbNitSettingsProperty"]], result)

        @builtins.property
        def dvb_sdt_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.DvbSdtSettingsProperty"]]:
            '''Inserts a DVB Service Description Table (SDT) at the specified table repetition interval.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-dvbsdtsettings
            '''
            result = self._values.get("dvb_sdt_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.DvbSdtSettingsProperty"]], result)

        @builtins.property
        def dvb_sub_pids(self) -> typing.Optional[builtins.str]:
            '''The PID for the input source DVB Subtitle data to this output.

            Multiple values are accepted, and can be entered in ranges and/or by comma separation. You can enter the value as a decimal or hexadecimal value. Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-dvbsubpids
            '''
            result = self._values.get("dvb_sub_pids")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def dvb_tdt_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.DvbTdtSettingsProperty"]]:
            '''Inserts DVB Time and Date Table (TDT) at the specified table repetition interval.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-dvbtdtsettings
            '''
            result = self._values.get("dvb_tdt_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.DvbTdtSettingsProperty"]], result)

        @builtins.property
        def dvb_teletext_pid(self) -> typing.Optional[builtins.str]:
            '''The PID for the input source DVB Teletext data to this output.

            You can enter the value as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-dvbteletextpid
            '''
            result = self._values.get("dvb_teletext_pid")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def ebif(self) -> typing.Optional[builtins.str]:
            '''If set to passthrough, passes any EBIF data from the input source to this output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-ebif
            '''
            result = self._values.get("ebif")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def ebp_audio_interval(self) -> typing.Optional[builtins.str]:
            '''When videoAndFixedIntervals is selected, audio EBP markers are added to partitions 3 and 4.

            The interval between these additional markers is fixed, and is slightly shorter than the video EBP marker interval. This is only available when EBP Cablelabs segmentation markers are selected. Partitions 1 and 2 always follow the video interval.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-ebpaudiointerval
            '''
            result = self._values.get("ebp_audio_interval")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def ebp_lookahead_ms(self) -> typing.Optional[jsii.Number]:
            '''When set, enforces that Encoder Boundary Points do not come within the specified time interval of each other by looking ahead at input video.

            If another EBP is going to come in within the specified time interval, the current EBP is not emitted, and the segment is "stretched" to the next marker. The lookahead value does not add latency to the system. The channel must be configured elsewhere to create sufficient latency to make the lookahead accurate.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-ebplookaheadms
            '''
            result = self._values.get("ebp_lookahead_ms")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def ebp_placement(self) -> typing.Optional[builtins.str]:
            '''Controls placement of EBP on audio PIDs.

            If set to videoAndAudioPids, EBP markers are placed on the video PID and all audio PIDs. If set to videoPid, EBP markers are placed on only the video PID.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-ebpplacement
            '''
            result = self._values.get("ebp_placement")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def ecm_pid(self) -> typing.Optional[builtins.str]:
            '''This field is unused and deprecated.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-ecmpid
            '''
            result = self._values.get("ecm_pid")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def es_rate_in_pes(self) -> typing.Optional[builtins.str]:
            '''Includes or excludes the ES Rate field in the PES header.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-esrateinpes
            '''
            result = self._values.get("es_rate_in_pes")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def etv_platform_pid(self) -> typing.Optional[builtins.str]:
            '''The PID for the input source ETV Platform data to this output.

            You can enter it as a decimal or hexadecimal value. Valid values are 32 (or 0x20) to 8182 (or 0x1ff6).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-etvplatformpid
            '''
            result = self._values.get("etv_platform_pid")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def etv_signal_pid(self) -> typing.Optional[builtins.str]:
            '''The PID for input source ETV Signal data to this output.

            You can enter the value as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-etvsignalpid
            '''
            result = self._values.get("etv_signal_pid")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def fragment_time(self) -> typing.Optional[jsii.Number]:
            '''The length in seconds of each fragment.

            This is used only with EBP markers.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-fragmenttime
            '''
            result = self._values.get("fragment_time")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def klv(self) -> typing.Optional[builtins.str]:
            '''If set to passthrough, passes any KLV data from the input source to this output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-klv
            '''
            result = self._values.get("klv")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def klv_data_pids(self) -> typing.Optional[builtins.str]:
            '''The PID for the input source KLV data to this output.

            Multiple values are accepted, and can be entered in ranges or by comma separation. You can enter the value as a decimal or hexadecimal value. Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-klvdatapids
            '''
            result = self._values.get("klv_data_pids")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def nielsen_id3_behavior(self) -> typing.Optional[builtins.str]:
            '''If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an equivalent ID3 tag will be inserted in the output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-nielsenid3behavior
            '''
            result = self._values.get("nielsen_id3_behavior")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def null_packet_bitrate(self) -> typing.Optional[jsii.Number]:
            '''The value, in bits per second, of extra null packets to insert into the transport stream.

            This can be used if a downstream encryption system requires periodic null packets.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-nullpacketbitrate
            '''
            result = self._values.get("null_packet_bitrate")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def pat_interval(self) -> typing.Optional[jsii.Number]:
            '''The number of milliseconds between instances of this table in the output transport stream.

            Valid values are 0, 10..1000.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-patinterval
            '''
            result = self._values.get("pat_interval")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def pcr_control(self) -> typing.Optional[builtins.str]:
            '''When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized Elementary Stream (PES) header.

            This parameter is effective only when the PCR PID is the same as the video or audio elementary stream.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-pcrcontrol
            '''
            result = self._values.get("pcr_control")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def pcr_period(self) -> typing.Optional[jsii.Number]:
            '''The maximum time, in milliseconds, between Program Clock References (PCRs) inserted into the transport stream.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-pcrperiod
            '''
            result = self._values.get("pcr_period")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def pcr_pid(self) -> typing.Optional[builtins.str]:
            '''The PID of the Program Clock Reference (PCR) in the transport stream.

            When no value is given, MediaLive assigns the same value as the video PID. You can enter the value as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-pcrpid
            '''
            result = self._values.get("pcr_pid")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def pmt_interval(self) -> typing.Optional[jsii.Number]:
            '''The number of milliseconds between instances of this table in the output transport stream.

            Valid values are 0, 10..1000.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-pmtinterval
            '''
            result = self._values.get("pmt_interval")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def pmt_pid(self) -> typing.Optional[builtins.str]:
            '''The PID for the Program Map Table (PMT) in the transport stream.

            You can enter the value as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-pmtpid
            '''
            result = self._values.get("pmt_pid")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def program_num(self) -> typing.Optional[jsii.Number]:
            '''The value of the program number field in the Program Map Table (PMT).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-programnum
            '''
            result = self._values.get("program_num")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def rate_mode(self) -> typing.Optional[builtins.str]:
            '''When VBR, does not insert null packets into the transport stream to fill the specified bitrate.

            The bitrate setting acts as the maximum bitrate when VBR is set.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-ratemode
            '''
            result = self._values.get("rate_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def scte27_pids(self) -> typing.Optional[builtins.str]:
            '''The PID for the input source SCTE-27 data to this output.

            Multiple values are accepted, and can be entered in ranges or by comma separation. You can enter the value as a decimal or hexadecimal value. Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-scte27pids
            '''
            result = self._values.get("scte27_pids")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def scte35_control(self) -> typing.Optional[builtins.str]:
            '''Optionally passes SCTE-35 signals from the input source to this output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-scte35control
            '''
            result = self._values.get("scte35_control")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def scte35_pid(self) -> typing.Optional[builtins.str]:
            '''The PID of the SCTE-35 stream in the transport stream.

            You can enter the value as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-scte35pid
            '''
            result = self._values.get("scte35_pid")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def segmentation_markers(self) -> typing.Optional[builtins.str]:
            '''Inserts segmentation markers at each segmentationTime period.

            raiSegstart sets the Random Access Indicator bit in the adaptation field. raiAdapt sets the RAI bit and adds the current timecode in the private data bytes. psiSegstart inserts PAT and PMT tables at the start of segments. ebp adds Encoder Boundary Point information to the adaptation field as per OpenCable specification OC-SP-EBP-I01-130118. ebpLegacy adds Encoder Boundary Point information to the adaptation field using a legacy proprietary format.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-segmentationmarkers
            '''
            result = self._values.get("segmentation_markers")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def segmentation_style(self) -> typing.Optional[builtins.str]:
            '''The segmentation style parameter controls how segmentation markers are inserted into the transport stream.

            With avails, it is possible that segments might be truncated, which can influence where future segmentation markers are inserted. When a segmentation style of resetCadence is selected and a segment is truncated due to an avail, we will reset the segmentation cadence. This means the subsequent segment will have a duration of $segmentationTime seconds. When a segmentation style of maintainCadence is selected and a segment is truncated due to an avail, we will not reset the segmentation cadence. This means the subsequent segment will likely be truncated as well. However, all segments after that will have a duration of $segmentationTime seconds. Note that EBP lookahead is a slight exception to this rule.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-segmentationstyle
            '''
            result = self._values.get("segmentation_style")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def segmentation_time(self) -> typing.Optional[jsii.Number]:
            '''The length, in seconds, of each segment.

            This is required unless markers is set to None_.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-segmentationtime
            '''
            result = self._values.get("segmentation_time")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def timed_metadata_behavior(self) -> typing.Optional[builtins.str]:
            '''When set to passthrough, timed metadata is passed through from input to output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-timedmetadatabehavior
            '''
            result = self._values.get("timed_metadata_behavior")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def timed_metadata_pid(self) -> typing.Optional[builtins.str]:
            '''The PID of the timed metadata stream in the transport stream.

            You can enter the value as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-timedmetadatapid
            '''
            result = self._values.get("timed_metadata_pid")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def transport_stream_id(self) -> typing.Optional[jsii.Number]:
            '''The value of the transport stream ID field in the Program Map Table (PMT).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-transportstreamid
            '''
            result = self._values.get("transport_stream_id")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def video_pid(self) -> typing.Optional[builtins.str]:
            '''The PID of the elementary video stream in the transport stream.

            You can enter the value as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-videopid
            '''
            result = self._values.get("video_pid")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "M2tsSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.M3u8SettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "audio_frames_per_pes": "audioFramesPerPes",
            "audio_pids": "audioPids",
            "ecm_pid": "ecmPid",
            "nielsen_id3_behavior": "nielsenId3Behavior",
            "pat_interval": "patInterval",
            "pcr_control": "pcrControl",
            "pcr_period": "pcrPeriod",
            "pcr_pid": "pcrPid",
            "pmt_interval": "pmtInterval",
            "pmt_pid": "pmtPid",
            "program_num": "programNum",
            "scte35_behavior": "scte35Behavior",
            "scte35_pid": "scte35Pid",
            "timed_metadata_behavior": "timedMetadataBehavior",
            "timed_metadata_pid": "timedMetadataPid",
            "transport_stream_id": "transportStreamId",
            "video_pid": "videoPid",
        },
    )
    class M3u8SettingsProperty:
        def __init__(
            self,
            *,
            audio_frames_per_pes: typing.Optional[jsii.Number] = None,
            audio_pids: typing.Optional[builtins.str] = None,
            ecm_pid: typing.Optional[builtins.str] = None,
            nielsen_id3_behavior: typing.Optional[builtins.str] = None,
            pat_interval: typing.Optional[jsii.Number] = None,
            pcr_control: typing.Optional[builtins.str] = None,
            pcr_period: typing.Optional[jsii.Number] = None,
            pcr_pid: typing.Optional[builtins.str] = None,
            pmt_interval: typing.Optional[jsii.Number] = None,
            pmt_pid: typing.Optional[builtins.str] = None,
            program_num: typing.Optional[jsii.Number] = None,
            scte35_behavior: typing.Optional[builtins.str] = None,
            scte35_pid: typing.Optional[builtins.str] = None,
            timed_metadata_behavior: typing.Optional[builtins.str] = None,
            timed_metadata_pid: typing.Optional[builtins.str] = None,
            transport_stream_id: typing.Optional[jsii.Number] = None,
            video_pid: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Settings for the M3U8 container.

            The parent of this entity is StandardHlsSettings.

            :param audio_frames_per_pes: The number of audio frames to insert for each PES packet.
            :param audio_pids: The PID of the elementary audio streams in the transport stream. Multiple values are accepted, and can be entered in ranges or by comma separation. You can enter the value as a decimal or hexadecimal value.
            :param ecm_pid: This parameter is unused and deprecated.
            :param nielsen_id3_behavior: If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an equivalent ID3 tag will be inserted in the output.
            :param pat_interval: The number of milliseconds between instances of this table in the output transport stream. A value of "0" writes out the PMT once per segment file.
            :param pcr_control: When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized Elementary Stream (PES) header. This parameter is effective only when the PCR PID is the same as the video or audio elementary stream.
            :param pcr_period: The maximum time, in milliseconds, between Program Clock References (PCRs) inserted into the transport stream.
            :param pcr_pid: The PID of the Program Clock Reference (PCR) in the transport stream. When no value is given, MediaLive assigns the same value as the video PID. You can enter the value as a decimal or hexadecimal value.
            :param pmt_interval: The number of milliseconds between instances of this table in the output transport stream. A value of "0" writes out the PMT once per segment file.
            :param pmt_pid: The PID for the Program Map Table (PMT) in the transport stream. You can enter the value as a decimal or hexadecimal value.
            :param program_num: The value of the program number field in the Program Map Table (PMT).
            :param scte35_behavior: If set to passthrough, passes any SCTE-35 signals from the input source to this output.
            :param scte35_pid: The PID of the SCTE-35 stream in the transport stream. You can enter the value as a decimal or hexadecimal value.
            :param timed_metadata_behavior: When set to passthrough, timed metadata is passed through from input to output.
            :param timed_metadata_pid: The PID of the timed metadata stream in the transport stream. You can enter the value as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
            :param transport_stream_id: The value of the transport stream ID field in the Program Map Table (PMT).
            :param video_pid: The PID of the elementary video stream in the transport stream. You can enter the value as a decimal or hexadecimal value.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                m3u8_settings_property = medialive.CfnChannel.M3u8SettingsProperty(
                    audio_frames_per_pes=123,
                    audio_pids="audioPids",
                    ecm_pid="ecmPid",
                    nielsen_id3_behavior="nielsenId3Behavior",
                    pat_interval=123,
                    pcr_control="pcrControl",
                    pcr_period=123,
                    pcr_pid="pcrPid",
                    pmt_interval=123,
                    pmt_pid="pmtPid",
                    program_num=123,
                    scte35_behavior="scte35Behavior",
                    scte35_pid="scte35Pid",
                    timed_metadata_behavior="timedMetadataBehavior",
                    timed_metadata_pid="timedMetadataPid",
                    transport_stream_id=123,
                    video_pid="videoPid"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if audio_frames_per_pes is not None:
                self._values["audio_frames_per_pes"] = audio_frames_per_pes
            if audio_pids is not None:
                self._values["audio_pids"] = audio_pids
            if ecm_pid is not None:
                self._values["ecm_pid"] = ecm_pid
            if nielsen_id3_behavior is not None:
                self._values["nielsen_id3_behavior"] = nielsen_id3_behavior
            if pat_interval is not None:
                self._values["pat_interval"] = pat_interval
            if pcr_control is not None:
                self._values["pcr_control"] = pcr_control
            if pcr_period is not None:
                self._values["pcr_period"] = pcr_period
            if pcr_pid is not None:
                self._values["pcr_pid"] = pcr_pid
            if pmt_interval is not None:
                self._values["pmt_interval"] = pmt_interval
            if pmt_pid is not None:
                self._values["pmt_pid"] = pmt_pid
            if program_num is not None:
                self._values["program_num"] = program_num
            if scte35_behavior is not None:
                self._values["scte35_behavior"] = scte35_behavior
            if scte35_pid is not None:
                self._values["scte35_pid"] = scte35_pid
            if timed_metadata_behavior is not None:
                self._values["timed_metadata_behavior"] = timed_metadata_behavior
            if timed_metadata_pid is not None:
                self._values["timed_metadata_pid"] = timed_metadata_pid
            if transport_stream_id is not None:
                self._values["transport_stream_id"] = transport_stream_id
            if video_pid is not None:
                self._values["video_pid"] = video_pid

        @builtins.property
        def audio_frames_per_pes(self) -> typing.Optional[jsii.Number]:
            '''The number of audio frames to insert for each PES packet.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-audioframesperpes
            '''
            result = self._values.get("audio_frames_per_pes")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def audio_pids(self) -> typing.Optional[builtins.str]:
            '''The PID of the elementary audio streams in the transport stream.

            Multiple values are accepted, and can be entered in ranges or by comma separation. You can enter the value as a decimal or hexadecimal value.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-audiopids
            '''
            result = self._values.get("audio_pids")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def ecm_pid(self) -> typing.Optional[builtins.str]:
            '''This parameter is unused and deprecated.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-ecmpid
            '''
            result = self._values.get("ecm_pid")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def nielsen_id3_behavior(self) -> typing.Optional[builtins.str]:
            '''If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an equivalent ID3 tag will be inserted in the output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-nielsenid3behavior
            '''
            result = self._values.get("nielsen_id3_behavior")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def pat_interval(self) -> typing.Optional[jsii.Number]:
            '''The number of milliseconds between instances of this table in the output transport stream.

            A value of "0" writes out the PMT once per segment file.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-patinterval
            '''
            result = self._values.get("pat_interval")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def pcr_control(self) -> typing.Optional[builtins.str]:
            '''When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized Elementary Stream (PES) header.

            This parameter is effective only when the PCR PID is the same as the video or audio elementary stream.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-pcrcontrol
            '''
            result = self._values.get("pcr_control")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def pcr_period(self) -> typing.Optional[jsii.Number]:
            '''The maximum time, in milliseconds, between Program Clock References (PCRs) inserted into the transport stream.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-pcrperiod
            '''
            result = self._values.get("pcr_period")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def pcr_pid(self) -> typing.Optional[builtins.str]:
            '''The PID of the Program Clock Reference (PCR) in the transport stream.

            When no value is given, MediaLive assigns the same value as the video PID. You can enter the value as a decimal or hexadecimal value.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-pcrpid
            '''
            result = self._values.get("pcr_pid")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def pmt_interval(self) -> typing.Optional[jsii.Number]:
            '''The number of milliseconds between instances of this table in the output transport stream.

            A value of "0" writes out the PMT once per segment file.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-pmtinterval
            '''
            result = self._values.get("pmt_interval")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def pmt_pid(self) -> typing.Optional[builtins.str]:
            '''The PID for the Program Map Table (PMT) in the transport stream.

            You can enter the value as a decimal or hexadecimal value.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-pmtpid
            '''
            result = self._values.get("pmt_pid")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def program_num(self) -> typing.Optional[jsii.Number]:
            '''The value of the program number field in the Program Map Table (PMT).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-programnum
            '''
            result = self._values.get("program_num")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def scte35_behavior(self) -> typing.Optional[builtins.str]:
            '''If set to passthrough, passes any SCTE-35 signals from the input source to this output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-scte35behavior
            '''
            result = self._values.get("scte35_behavior")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def scte35_pid(self) -> typing.Optional[builtins.str]:
            '''The PID of the SCTE-35 stream in the transport stream.

            You can enter the value as a decimal or hexadecimal value.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-scte35pid
            '''
            result = self._values.get("scte35_pid")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def timed_metadata_behavior(self) -> typing.Optional[builtins.str]:
            '''When set to passthrough, timed metadata is passed through from input to output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-timedmetadatabehavior
            '''
            result = self._values.get("timed_metadata_behavior")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def timed_metadata_pid(self) -> typing.Optional[builtins.str]:
            '''The PID of the timed metadata stream in the transport stream.

            You can enter the value as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-timedmetadatapid
            '''
            result = self._values.get("timed_metadata_pid")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def transport_stream_id(self) -> typing.Optional[jsii.Number]:
            '''The value of the transport stream ID field in the Program Map Table (PMT).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-transportstreamid
            '''
            result = self._values.get("transport_stream_id")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def video_pid(self) -> typing.Optional[builtins.str]:
            '''The PID of the elementary video stream in the transport stream.

            You can enter the value as a decimal or hexadecimal value.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-videopid
            '''
            result = self._values.get("video_pid")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "M3u8SettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.MediaPackageGroupSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"destination": "destination"},
    )
    class MediaPackageGroupSettingsProperty:
        def __init__(
            self,
            *,
            destination: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputLocationRefProperty"]] = None,
        ) -> None:
            '''The settings for the MediaPackage group.

            The parent of this entity is OutputGroupSettings.

            :param destination: The MediaPackage channel destination.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mediapackagegroupsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                media_package_group_settings_property = medialive.CfnChannel.MediaPackageGroupSettingsProperty(
                    destination=medialive.CfnChannel.OutputLocationRefProperty(
                        destination_ref_id="destinationRefId"
                    )
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if destination is not None:
                self._values["destination"] = destination

        @builtins.property
        def destination(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputLocationRefProperty"]]:
            '''The MediaPackage channel destination.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mediapackagegroupsettings.html#cfn-medialive-channel-mediapackagegroupsettings-destination
            '''
            result = self._values.get("destination")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputLocationRefProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MediaPackageGroupSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.MediaPackageOutputDestinationSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"channel_id": "channelId"},
    )
    class MediaPackageOutputDestinationSettingsProperty:
        def __init__(self, *, channel_id: typing.Optional[builtins.str] = None) -> None:
            '''Destination settings for a MediaPackage output.

            The parent of this entity is OutputDestination.

            :param channel_id: The ID of the channel in MediaPackage that is the destination for this output group. You don't need to specify the individual inputs in MediaPackage; MediaLive handles the connection of the two MediaLive pipelines to the two MediaPackage inputs. The MediaPackage channel and MediaLive channel must be in the same Region.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mediapackageoutputdestinationsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                media_package_output_destination_settings_property = medialive.CfnChannel.MediaPackageOutputDestinationSettingsProperty(
                    channel_id="channelId"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if channel_id is not None:
                self._values["channel_id"] = channel_id

        @builtins.property
        def channel_id(self) -> typing.Optional[builtins.str]:
            '''The ID of the channel in MediaPackage that is the destination for this output group.

            You don't need to specify the individual inputs in MediaPackage; MediaLive handles the connection of the two MediaLive pipelines to the two MediaPackage inputs. The MediaPackage channel and MediaLive channel must be in the same Region.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mediapackageoutputdestinationsettings.html#cfn-medialive-channel-mediapackageoutputdestinationsettings-channelid
            '''
            result = self._values.get("channel_id")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MediaPackageOutputDestinationSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.MediaPackageOutputSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={},
    )
    class MediaPackageOutputSettingsProperty:
        def __init__(self) -> None:
            '''The settings for a MediaPackage output.

            The parent of this entity is OutputSettings.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mediapackageoutputsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                media_package_output_settings_property = medialive.CfnChannel.MediaPackageOutputSettingsProperty()
            '''
            self._values: typing.Dict[str, typing.Any] = {}

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MediaPackageOutputSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.MotionGraphicsConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "motion_graphics_insertion": "motionGraphicsInsertion",
            "motion_graphics_settings": "motionGraphicsSettings",
        },
    )
    class MotionGraphicsConfigurationProperty:
        def __init__(
            self,
            *,
            motion_graphics_insertion: typing.Optional[builtins.str] = None,
            motion_graphics_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.MotionGraphicsSettingsProperty"]] = None,
        ) -> None:
            '''Settings to enable and configure the motion graphics overlay feature in the channel.

            The parent of this entity is EncoderSettings.

            :param motion_graphics_insertion: Enables or disables the motion graphics overlay feature in the channel.
            :param motion_graphics_settings: Settings to enable and configure the motion graphics overlay feature in the channel.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-motiongraphicsconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                motion_graphics_configuration_property = medialive.CfnChannel.MotionGraphicsConfigurationProperty(
                    motion_graphics_insertion="motionGraphicsInsertion",
                    motion_graphics_settings=medialive.CfnChannel.MotionGraphicsSettingsProperty(
                        html_motion_graphics_settings=medialive.CfnChannel.HtmlMotionGraphicsSettingsProperty()
                    )
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if motion_graphics_insertion is not None:
                self._values["motion_graphics_insertion"] = motion_graphics_insertion
            if motion_graphics_settings is not None:
                self._values["motion_graphics_settings"] = motion_graphics_settings

        @builtins.property
        def motion_graphics_insertion(self) -> typing.Optional[builtins.str]:
            '''Enables or disables the motion graphics overlay feature in the channel.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-motiongraphicsconfiguration.html#cfn-medialive-channel-motiongraphicsconfiguration-motiongraphicsinsertion
            '''
            result = self._values.get("motion_graphics_insertion")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def motion_graphics_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.MotionGraphicsSettingsProperty"]]:
            '''Settings to enable and configure the motion graphics overlay feature in the channel.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-motiongraphicsconfiguration.html#cfn-medialive-channel-motiongraphicsconfiguration-motiongraphicssettings
            '''
            result = self._values.get("motion_graphics_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.MotionGraphicsSettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MotionGraphicsConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.MotionGraphicsSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"html_motion_graphics_settings": "htmlMotionGraphicsSettings"},
    )
    class MotionGraphicsSettingsProperty:
        def __init__(
            self,
            *,
            html_motion_graphics_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.HtmlMotionGraphicsSettingsProperty"]] = None,
        ) -> None:
            '''Settings to enable and configure the motion graphics overlay feature in the channel.

            The parent of this entity is MotionGraphicsConfiguration.

            :param html_motion_graphics_settings: Settings to configure the motion graphics overlay to use an HTML asset.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-motiongraphicssettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                motion_graphics_settings_property = medialive.CfnChannel.MotionGraphicsSettingsProperty(
                    html_motion_graphics_settings=medialive.CfnChannel.HtmlMotionGraphicsSettingsProperty()
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if html_motion_graphics_settings is not None:
                self._values["html_motion_graphics_settings"] = html_motion_graphics_settings

        @builtins.property
        def html_motion_graphics_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.HtmlMotionGraphicsSettingsProperty"]]:
            '''Settings to configure the motion graphics overlay to use an HTML asset.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-motiongraphicssettings.html#cfn-medialive-channel-motiongraphicssettings-htmlmotiongraphicssettings
            '''
            result = self._values.get("html_motion_graphics_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.HtmlMotionGraphicsSettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MotionGraphicsSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.Mp2SettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "bitrate": "bitrate",
            "coding_mode": "codingMode",
            "sample_rate": "sampleRate",
        },
    )
    class Mp2SettingsProperty:
        def __init__(
            self,
            *,
            bitrate: typing.Optional[jsii.Number] = None,
            coding_mode: typing.Optional[builtins.str] = None,
            sample_rate: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''The configuration for this MP2 audio.

            The parent of this entity is AudioCodecSettings.

            :param bitrate: The average bitrate in bits/second.
            :param coding_mode: The MPEG2 Audio coding mode. Valid values are codingMode10 (for mono) or codingMode20 (for stereo).
            :param sample_rate: The sample rate in Hz.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mp2settings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                mp2_settings_property = medialive.CfnChannel.Mp2SettingsProperty(
                    bitrate=123,
                    coding_mode="codingMode",
                    sample_rate=123
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if bitrate is not None:
                self._values["bitrate"] = bitrate
            if coding_mode is not None:
                self._values["coding_mode"] = coding_mode
            if sample_rate is not None:
                self._values["sample_rate"] = sample_rate

        @builtins.property
        def bitrate(self) -> typing.Optional[jsii.Number]:
            '''The average bitrate in bits/second.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mp2settings.html#cfn-medialive-channel-mp2settings-bitrate
            '''
            result = self._values.get("bitrate")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def coding_mode(self) -> typing.Optional[builtins.str]:
            '''The MPEG2 Audio coding mode.

            Valid values are codingMode10 (for mono) or codingMode20 (for stereo).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mp2settings.html#cfn-medialive-channel-mp2settings-codingmode
            '''
            result = self._values.get("coding_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def sample_rate(self) -> typing.Optional[jsii.Number]:
            '''The sample rate in Hz.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mp2settings.html#cfn-medialive-channel-mp2settings-samplerate
            '''
            result = self._values.get("sample_rate")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "Mp2SettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.Mpeg2FilterSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"temporal_filter_settings": "temporalFilterSettings"},
    )
    class Mpeg2FilterSettingsProperty:
        def __init__(
            self,
            *,
            temporal_filter_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.TemporalFilterSettingsProperty"]] = None,
        ) -> None:
            '''Settings to configure video filters that apply to the MPEG-2 codec.

            The parent of this entity is Mpeg2FilterSettings.

            :param temporal_filter_settings: Settings for applying the temporal filter to the video.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2filtersettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                mpeg2_filter_settings_property = medialive.CfnChannel.Mpeg2FilterSettingsProperty(
                    temporal_filter_settings=medialive.CfnChannel.TemporalFilterSettingsProperty(
                        post_filter_sharpening="postFilterSharpening",
                        strength="strength"
                    )
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if temporal_filter_settings is not None:
                self._values["temporal_filter_settings"] = temporal_filter_settings

        @builtins.property
        def temporal_filter_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.TemporalFilterSettingsProperty"]]:
            '''Settings for applying the temporal filter to the video.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2filtersettings.html#cfn-medialive-channel-mpeg2filtersettings-temporalfiltersettings
            '''
            result = self._values.get("temporal_filter_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.TemporalFilterSettingsProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "Mpeg2FilterSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.Mpeg2SettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "adaptive_quantization": "adaptiveQuantization",
            "afd_signaling": "afdSignaling",
            "color_metadata": "colorMetadata",
            "color_space": "colorSpace",
            "display_aspect_ratio": "displayAspectRatio",
            "filter_settings": "filterSettings",
            "fixed_afd": "fixedAfd",
            "framerate_denominator": "framerateDenominator",
            "framerate_numerator": "framerateNumerator",
            "gop_closed_cadence": "gopClosedCadence",
            "gop_num_b_frames": "gopNumBFrames",
            "gop_size": "gopSize",
            "gop_size_units": "gopSizeUnits",
            "scan_type": "scanType",
            "subgop_length": "subgopLength",
            "timecode_insertion": "timecodeInsertion",
        },
    )
    class Mpeg2SettingsProperty:
        def __init__(
            self,
            *,
            adaptive_quantization: typing.Optional[builtins.str] = None,
            afd_signaling: typing.Optional[builtins.str] = None,
            color_metadata: typing.Optional[builtins.str] = None,
            color_space: typing.Optional[builtins.str] = None,
            display_aspect_ratio: typing.Optional[builtins.str] = None,
            filter_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Mpeg2FilterSettingsProperty"]] = None,
            fixed_afd: typing.Optional[builtins.str] = None,
            framerate_denominator: typing.Optional[jsii.Number] = None,
            framerate_numerator: typing.Optional[jsii.Number] = None,
            gop_closed_cadence: typing.Optional[jsii.Number] = None,
            gop_num_b_frames: typing.Optional[jsii.Number] = None,
            gop_size: typing.Optional[jsii.Number] = None,
            gop_size_units: typing.Optional[builtins.str] = None,
            scan_type: typing.Optional[builtins.str] = None,
            subgop_length: typing.Optional[builtins.str] = None,
            timecode_insertion: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The settings for the MPEG-2 codec in the output.

            The parent of this entity is VideoCodecSetting.

            :param adaptive_quantization: Choose Off to disable adaptive quantization. Or choose another value to enable the quantizer and set its strength. The strengths are: Auto, Off, Low, Medium, High. When you enable this field, MediaLive allows intra-frame quantizers to vary, which might improve visual quality.
            :param afd_signaling: Indicates the AFD values that MediaLive will write into the video encode. If you do not know what AFD signaling is, or if your downstream system has not given you guidance, choose AUTO. AUTO: MediaLive will try to preserve the input AFD value (in cases where multiple AFD values are valid). FIXED: MediaLive will use the value you specify in fixedAFD.
            :param color_metadata: Specifies whether to include the color space metadata. The metadata describes the color space that applies to the video (the colorSpace field). We recommend that you insert the metadata.
            :param color_space: Choose the type of color space conversion to apply to the output. For detailed information on setting up both the input and the output to obtain the desired color space in the output, see the section on "MediaLive Features - Video - color space" in the MediaLive User Guide. PASSTHROUGH: Keep the color space of the input content - do not convert it. AUTO:Convert all content that is SD to rec 601, and convert all content that is HD to rec 709.
            :param display_aspect_ratio: Sets the pixel aspect ratio for the encode.
            :param filter_settings: Optionally specify a noise reduction filter, which can improve quality of compressed content. If you do not choose a filter, no filter will be applied. TEMPORAL: This filter is useful for both source content that is noisy (when it has excessive digital artifacts) and source content that is clean. When the content is noisy, the filter cleans up the source content before the encoding phase, with these two effects: First, it improves the output video quality because the content has been cleaned up. Secondly, it decreases the bandwidth because MediaLive does not waste bits on encoding noise. When the content is reasonably clean, the filter tends to decrease the bitrate.
            :param fixed_afd: Complete this field only when afdSignaling is set to FIXED. Enter the AFD value (4 bits) to write on all frames of the video encode.
            :param framerate_denominator: description": "The framerate denominator. For example, 1001. The framerate is the numerator divided by the denominator. For example, 24000 / 1001 = 23.976 FPS.
            :param framerate_numerator: The framerate numerator. For example, 24000. The framerate is the numerator divided by the denominator. For example, 24000 / 1001 = 23.976 FPS.
            :param gop_closed_cadence: MPEG2: default is open GOP.
            :param gop_num_b_frames: Relates to the GOP structure. The number of B-frames between reference frames. If you do not know what a B-frame is, use the default.
            :param gop_size: Relates to the GOP structure. The GOP size (keyframe interval) in the units specified in gopSizeUnits. If you do not know what GOP is, use the default. If gopSizeUnits is frames, then the gopSize must be an integer and must be greater than or equal to 1. If gopSizeUnits is seconds, the gopSize must be greater than 0, but does not need to be an integer.
            :param gop_size_units: Relates to the GOP structure. Specifies whether the gopSize is specified in frames or seconds. If you do not plan to change the default gopSize, leave the default. If you specify SECONDS, MediaLive will internally convert the gop size to a frame count.
            :param scan_type: Set the scan type of the output to PROGRESSIVE or INTERLACED (top field first).
            :param subgop_length: Relates to the GOP structure. If you do not know what GOP is, use the default. FIXED: Set the number of B-frames in each sub-GOP to the value in gopNumBFrames. DYNAMIC: Let MediaLive optimize the number of B-frames in each sub-GOP, to improve visual quality.
            :param timecode_insertion: Determines how MediaLive inserts timecodes in the output video. For detailed information about setting up the input and the output for a timecode, see the section on "MediaLive Features - Timecode configuration" in the MediaLive User Guide. DISABLED: do not include timecodes. GOP_TIMECODE: Include timecode metadata in the GOP header.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                mpeg2_settings_property = medialive.CfnChannel.Mpeg2SettingsProperty(
                    adaptive_quantization="adaptiveQuantization",
                    afd_signaling="afdSignaling",
                    color_metadata="colorMetadata",
                    color_space="colorSpace",
                    display_aspect_ratio="displayAspectRatio",
                    filter_settings=medialive.CfnChannel.Mpeg2FilterSettingsProperty(
                        temporal_filter_settings=medialive.CfnChannel.TemporalFilterSettingsProperty(
                            post_filter_sharpening="postFilterSharpening",
                            strength="strength"
                        )
                    ),
                    fixed_afd="fixedAfd",
                    framerate_denominator=123,
                    framerate_numerator=123,
                    gop_closed_cadence=123,
                    gop_num_bFrames=123,
                    gop_size=123,
                    gop_size_units="gopSizeUnits",
                    scan_type="scanType",
                    subgop_length="subgopLength",
                    timecode_insertion="timecodeInsertion"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if adaptive_quantization is not None:
                self._values["adaptive_quantization"] = adaptive_quantization
            if afd_signaling is not None:
                self._values["afd_signaling"] = afd_signaling
            if color_metadata is not None:
                self._values["color_metadata"] = color_metadata
            if color_space is not None:
                self._values["color_space"] = color_space
            if display_aspect_ratio is not None:
                self._values["display_aspect_ratio"] = display_aspect_ratio
            if filter_settings is not None:
                self._values["filter_settings"] = filter_settings
            if fixed_afd is not None:
                self._values["fixed_afd"] = fixed_afd
            if framerate_denominator is not None:
                self._values["framerate_denominator"] = framerate_denominator
            if framerate_numerator is not None:
                self._values["framerate_numerator"] = framerate_numerator
            if gop_closed_cadence is not None:
                self._values["gop_closed_cadence"] = gop_closed_cadence
            if gop_num_b_frames is not None:
                self._values["gop_num_b_frames"] = gop_num_b_frames
            if gop_size is not None:
                self._values["gop_size"] = gop_size
            if gop_size_units is not None:
                self._values["gop_size_units"] = gop_size_units
            if scan_type is not None:
                self._values["scan_type"] = scan_type
            if subgop_length is not None:
                self._values["subgop_length"] = subgop_length
            if timecode_insertion is not None:
                self._values["timecode_insertion"] = timecode_insertion

        @builtins.property
        def adaptive_quantization(self) -> typing.Optional[builtins.str]:
            '''Choose Off to disable adaptive quantization.

            Or choose another value to enable the quantizer and set its strength. The strengths are: Auto, Off, Low, Medium, High. When you enable this field, MediaLive allows intra-frame quantizers to vary, which might improve visual quality.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-adaptivequantization
            '''
            result = self._values.get("adaptive_quantization")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def afd_signaling(self) -> typing.Optional[builtins.str]:
            '''Indicates the AFD values that MediaLive will write into the video encode.

            If you do not know what AFD signaling is, or if your downstream system has not given you guidance, choose AUTO.
            AUTO: MediaLive will try to preserve the input AFD value (in cases where multiple AFD values are valid).
            FIXED: MediaLive will use the value you specify in fixedAFD.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-afdsignaling
            '''
            result = self._values.get("afd_signaling")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def color_metadata(self) -> typing.Optional[builtins.str]:
            '''Specifies whether to include the color space metadata.

            The metadata describes the color space that applies to the video (the colorSpace field). We recommend that you insert the metadata.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-colormetadata
            '''
            result = self._values.get("color_metadata")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def color_space(self) -> typing.Optional[builtins.str]:
            '''Choose the type of color space conversion to apply to the output.

            For detailed information on setting up both the input and the output to obtain the desired color space in the output, see the section on "MediaLive Features - Video - color space" in the MediaLive User Guide.
            PASSTHROUGH: Keep the color space of the input content - do not convert it.
            AUTO:Convert all content that is SD to rec 601, and convert all content that is HD to rec 709.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-colorspace
            '''
            result = self._values.get("color_space")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def display_aspect_ratio(self) -> typing.Optional[builtins.str]:
            '''Sets the pixel aspect ratio for the encode.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-displayaspectratio
            '''
            result = self._values.get("display_aspect_ratio")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def filter_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Mpeg2FilterSettingsProperty"]]:
            '''Optionally specify a noise reduction filter, which can improve quality of compressed content.

            If you do not choose a filter, no filter will be applied.
            TEMPORAL: This filter is useful for both source content that is noisy (when it has excessive digital artifacts) and source content that is clean.
            When the content is noisy, the filter cleans up the source content before the encoding phase, with these two effects: First, it improves the output video quality because the content has been cleaned up. Secondly, it decreases the bandwidth because MediaLive does not waste bits on encoding noise.
            When the content is reasonably clean, the filter tends to decrease the bitrate.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-filtersettings
            '''
            result = self._values.get("filter_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.Mpeg2FilterSettingsProperty"]], result)

        @builtins.property
        def fixed_afd(self) -> typing.Optional[builtins.str]:
            '''Complete this field only when afdSignaling is set to FIXED.

            Enter the AFD value (4 bits) to write on all frames of the video encode.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-fixedafd
            '''
            result = self._values.get("fixed_afd")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def framerate_denominator(self) -> typing.Optional[jsii.Number]:
            '''description": "The framerate denominator.

            For example, 1001. The framerate is the numerator divided by the denominator. For example, 24000 / 1001 = 23.976 FPS.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-frameratedenominator
            '''
            result = self._values.get("framerate_denominator")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def framerate_numerator(self) -> typing.Optional[jsii.Number]:
            '''The framerate numerator.

            For example, 24000. The framerate is the numerator divided by the denominator. For example, 24000 / 1001 = 23.976 FPS.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-frameratenumerator
            '''
            result = self._values.get("framerate_numerator")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def gop_closed_cadence(self) -> typing.Optional[jsii.Number]:
            '''MPEG2: default is open GOP.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-gopclosedcadence
            '''
            result = self._values.get("gop_closed_cadence")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def gop_num_b_frames(self) -> typing.Optional[jsii.Number]:
            '''Relates to the GOP structure.

            The number of B-frames between reference frames. If you do not know what a B-frame is, use the default.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-gopnumbframes
            '''
            result = self._values.get("gop_num_b_frames")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def gop_size(self) -> typing.Optional[jsii.Number]:
            '''Relates to the GOP structure.

            The GOP size (keyframe interval) in the units specified in gopSizeUnits. If you do not know what GOP is, use the default.
            If gopSizeUnits is frames, then the gopSize must be an integer and must be greater than or equal to 1.
            If gopSizeUnits is seconds, the gopSize must be greater than 0, but does not need to be an integer.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-gopsize
            '''
            result = self._values.get("gop_size")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def gop_size_units(self) -> typing.Optional[builtins.str]:
            '''Relates to the GOP structure.

            Specifies whether the gopSize is specified in frames or seconds. If you do not plan to change the default gopSize, leave the default. If you specify SECONDS, MediaLive will internally convert the gop size to a frame count.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-gopsizeunits
            '''
            result = self._values.get("gop_size_units")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def scan_type(self) -> typing.Optional[builtins.str]:
            '''Set the scan type of the output to PROGRESSIVE or INTERLACED (top field first).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-scantype
            '''
            result = self._values.get("scan_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def subgop_length(self) -> typing.Optional[builtins.str]:
            '''Relates to the GOP structure.

            If you do not know what GOP is, use the default.
            FIXED: Set the number of B-frames in each sub-GOP to the value in gopNumBFrames.
            DYNAMIC: Let MediaLive optimize the number of B-frames in each sub-GOP, to improve visual quality.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-subgoplength
            '''
            result = self._values.get("subgop_length")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def timecode_insertion(self) -> typing.Optional[builtins.str]:
            '''Determines how MediaLive inserts timecodes in the output video.

            For detailed information about setting up the input and the output for a timecode, see the section on "MediaLive Features - Timecode configuration" in the MediaLive User Guide.
            DISABLED: do not include timecodes.
            GOP_TIMECODE: Include timecode metadata in the GOP header.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-timecodeinsertion
            '''
            result = self._values.get("timecode_insertion")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "Mpeg2SettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.MsSmoothGroupSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "acquisition_point_id": "acquisitionPointId",
            "audio_only_timecode_control": "audioOnlyTimecodeControl",
            "certificate_mode": "certificateMode",
            "connection_retry_interval": "connectionRetryInterval",
            "destination": "destination",
            "event_id": "eventId",
            "event_id_mode": "eventIdMode",
            "event_stop_behavior": "eventStopBehavior",
            "filecache_duration": "filecacheDuration",
            "fragment_length": "fragmentLength",
            "input_loss_action": "inputLossAction",
            "num_retries": "numRetries",
            "restart_delay": "restartDelay",
            "segmentation_mode": "segmentationMode",
            "send_delay_ms": "sendDelayMs",
            "sparse_track_type": "sparseTrackType",
            "stream_manifest_behavior": "streamManifestBehavior",
            "timestamp_offset": "timestampOffset",
            "timestamp_offset_mode": "timestampOffsetMode",
        },
    )
    class MsSmoothGroupSettingsProperty:
        def __init__(
            self,
            *,
            acquisition_point_id: typing.Optional[builtins.str] = None,
            audio_only_timecode_control: typing.Optional[builtins.str] = None,
            certificate_mode: typing.Optional[builtins.str] = None,
            connection_retry_interval: typing.Optional[jsii.Number] = None,
            destination: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputLocationRefProperty"]] = None,
            event_id: typing.Optional[builtins.str] = None,
            event_id_mode: typing.Optional[builtins.str] = None,
            event_stop_behavior: typing.Optional[builtins.str] = None,
            filecache_duration: typing.Optional[jsii.Number] = None,
            fragment_length: typing.Optional[jsii.Number] = None,
            input_loss_action: typing.Optional[builtins.str] = None,
            num_retries: typing.Optional[jsii.Number] = None,
            restart_delay: typing.Optional[jsii.Number] = None,
            segmentation_mode: typing.Optional[builtins.str] = None,
            send_delay_ms: typing.Optional[jsii.Number] = None,
            sparse_track_type: typing.Optional[builtins.str] = None,
            stream_manifest_behavior: typing.Optional[builtins.str] = None,
            timestamp_offset: typing.Optional[builtins.str] = None,
            timestamp_offset_mode: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The settings for a Microsoft Smooth output group.

            The parent of this entity is OutputGroupSettings.

            :param acquisition_point_id: The value of the Acquisition Point Identity element that is used in each message placed in the sparse track. Enabled only if sparseTrackType is not "none."
            :param audio_only_timecode_control: If set to passthrough for an audio-only Microsoft Smooth output, the fragment absolute time is set to the current timecode. This option does not write timecodes to the audio elementary stream.
            :param certificate_mode: If set to verifyAuthenticity, verifies the HTTPS certificate chain to a trusted certificate authority (CA). This causes HTTPS outputs to self-signed certificates to fail.
            :param connection_retry_interval: The number of seconds to wait before retrying the connection to the IIS server if the connection is lost. Content is cached during this time, and the cache is delivered to the IIS server after the connection is re-established.
            :param destination: The Smooth Streaming publish point on an IIS server. MediaLive acts as a "Push" encoder to IIS.
            :param event_id: The Microsoft Smooth channel ID that is sent to the IIS server. Specify the ID only if eventIdMode is set to useConfigured.
            :param event_id_mode: Specifies whether to send a channel ID to the IIS server. If no channel ID is sent and the same channel is used without changing the publishing point, clients might see cached video from the previous run. Options: - "useConfigured" - use the value provided in eventId - "useTimestamp" - generate and send a channel ID based on the current timestamp - "noEventId" - do not send a channel ID to the IIS server.
            :param event_stop_behavior: When set to sendEos, sends an EOS signal to an IIS server when stopping the channel.
            :param filecache_duration: The size, in seconds, of the file cache for streaming outputs.
            :param fragment_length: The length, in seconds, of mp4 fragments to generate. The fragment length must be compatible with GOP size and frame rate.
            :param input_loss_action: A parameter that controls output group behavior on an input loss.
            :param num_retries: The number of retry attempts.
            :param restart_delay: The number of seconds before initiating a restart due to output failure, due to exhausting the numRetries on one segment, or exceeding filecacheDuration.
            :param segmentation_mode: useInputSegmentation has been deprecated. The configured segment size is always used.
            :param send_delay_ms: The number of milliseconds to delay the output from the second pipeline.
            :param sparse_track_type: If set to scte35, uses incoming SCTE-35 messages to generate a sparse track in this group of Microsoft Smooth outputs.
            :param stream_manifest_behavior: When set to send, sends a stream manifest so that the publishing point doesn't start until all streams start.
            :param timestamp_offset: The timestamp offset for the channel. Used only if timestampOffsetMode is set to useConfiguredOffset.
            :param timestamp_offset_mode: The type of timestamp date offset to use. - useEventStartDate: Use the date the channel was started as the offset - useConfiguredOffset: Use an explicitly configured date as the offset.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                ms_smooth_group_settings_property = medialive.CfnChannel.MsSmoothGroupSettingsProperty(
                    acquisition_point_id="acquisitionPointId",
                    audio_only_timecode_control="audioOnlyTimecodeControl",
                    certificate_mode="certificateMode",
                    connection_retry_interval=123,
                    destination=medialive.CfnChannel.OutputLocationRefProperty(
                        destination_ref_id="destinationRefId"
                    ),
                    event_id="eventId",
                    event_id_mode="eventIdMode",
                    event_stop_behavior="eventStopBehavior",
                    filecache_duration=123,
                    fragment_length=123,
                    input_loss_action="inputLossAction",
                    num_retries=123,
                    restart_delay=123,
                    segmentation_mode="segmentationMode",
                    send_delay_ms=123,
                    sparse_track_type="sparseTrackType",
                    stream_manifest_behavior="streamManifestBehavior",
                    timestamp_offset="timestampOffset",
                    timestamp_offset_mode="timestampOffsetMode"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if acquisition_point_id is not None:
                self._values["acquisition_point_id"] = acquisition_point_id
            if audio_only_timecode_control is not None:
                self._values["audio_only_timecode_control"] = audio_only_timecode_control
            if certificate_mode is not None:
                self._values["certificate_mode"] = certificate_mode
            if connection_retry_interval is not None:
                self._values["connection_retry_interval"] = connection_retry_interval
            if destination is not None:
                self._values["destination"] = destination
            if event_id is not None:
                self._values["event_id"] = event_id
            if event_id_mode is not None:
                self._values["event_id_mode"] = event_id_mode
            if event_stop_behavior is not None:
                self._values["event_stop_behavior"] = event_stop_behavior
            if filecache_duration is not None:
                self._values["filecache_duration"] = filecache_duration
            if fragment_length is not None:
                self._values["fragment_length"] = fragment_length
            if input_loss_action is not None:
                self._values["input_loss_action"] = input_loss_action
            if num_retries is not None:
                self._values["num_retries"] = num_retries
            if restart_delay is not None:
                self._values["restart_delay"] = restart_delay
            if segmentation_mode is not None:
                self._values["segmentation_mode"] = segmentation_mode
            if send_delay_ms is not None:
                self._values["send_delay_ms"] = send_delay_ms
            if sparse_track_type is not None:
                self._values["sparse_track_type"] = sparse_track_type
            if stream_manifest_behavior is not None:
                self._values["stream_manifest_behavior"] = stream_manifest_behavior
            if timestamp_offset is not None:
                self._values["timestamp_offset"] = timestamp_offset
            if timestamp_offset_mode is not None:
                self._values["timestamp_offset_mode"] = timestamp_offset_mode

        @builtins.property
        def acquisition_point_id(self) -> typing.Optional[builtins.str]:
            '''The value of the Acquisition Point Identity element that is used in each message placed in the sparse track.

            Enabled only if sparseTrackType is not "none."

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-acquisitionpointid
            '''
            result = self._values.get("acquisition_point_id")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def audio_only_timecode_control(self) -> typing.Optional[builtins.str]:
            '''If set to passthrough for an audio-only Microsoft Smooth output, the fragment absolute time is set to the current timecode.

            This option does not write timecodes to the audio elementary stream.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-audioonlytimecodecontrol
            '''
            result = self._values.get("audio_only_timecode_control")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def certificate_mode(self) -> typing.Optional[builtins.str]:
            '''If set to verifyAuthenticity, verifies the HTTPS certificate chain to a trusted certificate authority (CA).

            This causes HTTPS outputs to self-signed certificates to fail.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-certificatemode
            '''
            result = self._values.get("certificate_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def connection_retry_interval(self) -> typing.Optional[jsii.Number]:
            '''The number of seconds to wait before retrying the connection to the IIS server if the connection is lost.

            Content is cached during this time, and the cache is delivered to the IIS server after the connection is re-established.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-connectionretryinterval
            '''
            result = self._values.get("connection_retry_interval")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def destination(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputLocationRefProperty"]]:
            '''The Smooth Streaming publish point on an IIS server.

            MediaLive acts as a "Push" encoder to IIS.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-destination
            '''
            result = self._values.get("destination")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputLocationRefProperty"]], result)

        @builtins.property
        def event_id(self) -> typing.Optional[builtins.str]:
            '''The Microsoft Smooth channel ID that is sent to the IIS server.

            Specify the ID only if eventIdMode is set to useConfigured.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-eventid
            '''
            result = self._values.get("event_id")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def event_id_mode(self) -> typing.Optional[builtins.str]:
            '''Specifies whether to send a channel ID to the IIS server.

            If no channel ID is sent and the same channel is used without changing the publishing point, clients might see cached video from the previous run. Options: - "useConfigured" - use the value provided in eventId - "useTimestamp" - generate and send a channel ID based on the current timestamp - "noEventId" - do not send a channel ID to the IIS server.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-eventidmode
            '''
            result = self._values.get("event_id_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def event_stop_behavior(self) -> typing.Optional[builtins.str]:
            '''When set to sendEos, sends an EOS signal to an IIS server when stopping the channel.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-eventstopbehavior
            '''
            result = self._values.get("event_stop_behavior")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def filecache_duration(self) -> typing.Optional[jsii.Number]:
            '''The size, in seconds, of the file cache for streaming outputs.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-filecacheduration
            '''
            result = self._values.get("filecache_duration")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def fragment_length(self) -> typing.Optional[jsii.Number]:
            '''The length, in seconds, of mp4 fragments to generate.

            The fragment length must be compatible with GOP size and frame rate.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-fragmentlength
            '''
            result = self._values.get("fragment_length")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def input_loss_action(self) -> typing.Optional[builtins.str]:
            '''A parameter that controls output group behavior on an input loss.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-inputlossaction
            '''
            result = self._values.get("input_loss_action")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def num_retries(self) -> typing.Optional[jsii.Number]:
            '''The number of retry attempts.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-numretries
            '''
            result = self._values.get("num_retries")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def restart_delay(self) -> typing.Optional[jsii.Number]:
            '''The number of seconds before initiating a restart due to output failure, due to exhausting the numRetries on one segment, or exceeding filecacheDuration.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-restartdelay
            '''
            result = self._values.get("restart_delay")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def segmentation_mode(self) -> typing.Optional[builtins.str]:
            '''useInputSegmentation has been deprecated.

            The configured segment size is always used.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-segmentationmode
            '''
            result = self._values.get("segmentation_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def send_delay_ms(self) -> typing.Optional[jsii.Number]:
            '''The number of milliseconds to delay the output from the second pipeline.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-senddelayms
            '''
            result = self._values.get("send_delay_ms")
            return typing.cast(typing.Optional[jsii.Number], result)

        @builtins.property
        def sparse_track_type(self) -> typing.Optional[builtins.str]:
            '''If set to scte35, uses incoming SCTE-35 messages to generate a sparse track in this group of Microsoft Smooth outputs.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-sparsetracktype
            '''
            result = self._values.get("sparse_track_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def stream_manifest_behavior(self) -> typing.Optional[builtins.str]:
            '''When set to send, sends a stream manifest so that the publishing point doesn't start until all streams start.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-streammanifestbehavior
            '''
            result = self._values.get("stream_manifest_behavior")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def timestamp_offset(self) -> typing.Optional[builtins.str]:
            '''The timestamp offset for the channel.

            Used only if timestampOffsetMode is set to useConfiguredOffset.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-timestampoffset
            '''
            result = self._values.get("timestamp_offset")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def timestamp_offset_mode(self) -> typing.Optional[builtins.str]:
            '''The type of timestamp date offset to use.

            - useEventStartDate: Use the date the channel was started as the offset - useConfiguredOffset: Use an explicitly configured date as the offset.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-timestampoffsetmode
            '''
            result = self._values.get("timestamp_offset_mode")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MsSmoothGroupSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.MsSmoothOutputSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "h265_packaging_type": "h265PackagingType",
            "name_modifier": "nameModifier",
        },
    )
    class MsSmoothOutputSettingsProperty:
        def __init__(
            self,
            *,
            h265_packaging_type: typing.Optional[builtins.str] = None,
            name_modifier: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Configuration of a Microsoft Smooth output.

            The parent of this entity is OutputSettings.

            :param h265_packaging_type: Only applicable when this output is referencing an H.265 video description. Specifies whether MP4 segments should be packaged as HEV1 or HVC1.
            :param name_modifier: A string that is concatenated to the end of the destination file name. This is required for multiple outputs of the same type.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothoutputsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                ms_smooth_output_settings_property = medialive.CfnChannel.MsSmoothOutputSettingsProperty(
                    h265_packaging_type="h265PackagingType",
                    name_modifier="nameModifier"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if h265_packaging_type is not None:
                self._values["h265_packaging_type"] = h265_packaging_type
            if name_modifier is not None:
                self._values["name_modifier"] = name_modifier

        @builtins.property
        def h265_packaging_type(self) -> typing.Optional[builtins.str]:
            '''Only applicable when this output is referencing an H.265 video description. Specifies whether MP4 segments should be packaged as HEV1 or HVC1.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothoutputsettings.html#cfn-medialive-channel-mssmoothoutputsettings-h265packagingtype
            '''
            result = self._values.get("h265_packaging_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def name_modifier(self) -> typing.Optional[builtins.str]:
            '''A string that is concatenated to the end of the destination file name.

            This is required for multiple outputs of the same type.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothoutputsettings.html#cfn-medialive-channel-mssmoothoutputsettings-namemodifier
            '''
            result = self._values.get("name_modifier")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MsSmoothOutputSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.MultiplexGroupSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={},
    )
    class MultiplexGroupSettingsProperty:
        def __init__(self) -> None:
            '''The settings for a Multiplex output group.

            The parent of this entity is OutputGroupSettings.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-multiplexgroupsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                multiplex_group_settings_property = medialive.CfnChannel.MultiplexGroupSettingsProperty()
            '''
            self._values: typing.Dict[str, typing.Any] = {}

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MultiplexGroupSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.MultiplexOutputSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"destination": "destination"},
    )
    class MultiplexOutputSettingsProperty:
        def __init__(
            self,
            *,
            destination: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputLocationRefProperty"]] = None,
        ) -> None:
            '''Configuration of a Multiplex output.

            The parent of this entity is OutputSettings.

            :param destination: Destination is a Multiplex.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-multiplexoutputsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                multiplex_output_settings_property = medialive.CfnChannel.MultiplexOutputSettingsProperty(
                    destination=medialive.CfnChannel.OutputLocationRefProperty(
                        destination_ref_id="destinationRefId"
                    )
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if destination is not None:
                self._values["destination"] = destination

        @builtins.property
        def destination(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputLocationRefProperty"]]:
            '''Destination is a Multiplex.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-multiplexoutputsettings.html#cfn-medialive-channel-multiplexoutputsettings-destination
            '''
            result = self._values.get("destination")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputLocationRefProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MultiplexOutputSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.MultiplexProgramChannelDestinationSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={"multiplex_id": "multiplexId", "program_name": "programName"},
    )
    class MultiplexProgramChannelDestinationSettingsProperty:
        def __init__(
            self,
            *,
            multiplex_id: typing.Optional[builtins.str] = None,
            program_name: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Destination settings for a Multiplex output.

            The parent of this entity is OutputDestination.

            :param multiplex_id: The ID of the Multiplex that the encoder is providing output to. You do not need to specify the individual inputs to the Multiplex; MediaLive will handle the connection of the two MediaLive pipelines to the two Multiplex instances. The Multiplex must be in the same region as the Channel.
            :param program_name: The program name of the Multiplex program that the encoder is providing output to.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-multiplexprogramchanneldestinationsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                multiplex_program_channel_destination_settings_property = medialive.CfnChannel.MultiplexProgramChannelDestinationSettingsProperty(
                    multiplex_id="multiplexId",
                    program_name="programName"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if multiplex_id is not None:
                self._values["multiplex_id"] = multiplex_id
            if program_name is not None:
                self._values["program_name"] = program_name

        @builtins.property
        def multiplex_id(self) -> typing.Optional[builtins.str]:
            '''The ID of the Multiplex that the encoder is providing output to.

            You do not need to specify the individual inputs to the Multiplex; MediaLive will handle the connection of the two MediaLive pipelines to the two Multiplex instances.
            The Multiplex must be in the same region as the Channel.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-multiplexprogramchanneldestinationsettings.html#cfn-medialive-channel-multiplexprogramchanneldestinationsettings-multiplexid
            '''
            result = self._values.get("multiplex_id")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def program_name(self) -> typing.Optional[builtins.str]:
            '''The program name of the Multiplex program that the encoder is providing output to.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-multiplexprogramchanneldestinationsettings.html#cfn-medialive-channel-multiplexprogramchanneldestinationsettings-programname
            '''
            result = self._values.get("program_name")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "MultiplexProgramChannelDestinationSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.NetworkInputSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "hls_input_settings": "hlsInputSettings",
            "server_validation": "serverValidation",
        },
    )
    class NetworkInputSettingsProperty:
        def __init__(
            self,
            *,
            hls_input_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.HlsInputSettingsProperty"]] = None,
            server_validation: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Information about how to connect to the upstream system.

            The parent of this entity is InputSettings.

            :param hls_input_settings: Information about how to connect to the upstream system.
            :param server_validation: Checks HTTPS server certificates. When set to checkCryptographyOnly, cryptography in the certificate is checked, but not the server's name. Certain subdomains (notably S3 buckets that use dots in the bucket name) don't strictly match the corresponding certificate's wildcard pattern and would otherwise cause the channel to error. This setting is ignored for protocols that do not use HTTPS.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-networkinputsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                network_input_settings_property = medialive.CfnChannel.NetworkInputSettingsProperty(
                    hls_input_settings=medialive.CfnChannel.HlsInputSettingsProperty(
                        bandwidth=123,
                        buffer_segments=123,
                        retries=123,
                        retry_interval=123,
                        scte35_source="scte35Source"
                    ),
                    server_validation="serverValidation"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if hls_input_settings is not None:
                self._values["hls_input_settings"] = hls_input_settings
            if server_validation is not None:
                self._values["server_validation"] = server_validation

        @builtins.property
        def hls_input_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.HlsInputSettingsProperty"]]:
            '''Information about how to connect to the upstream system.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-networkinputsettings.html#cfn-medialive-channel-networkinputsettings-hlsinputsettings
            '''
            result = self._values.get("hls_input_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.HlsInputSettingsProperty"]], result)

        @builtins.property
        def server_validation(self) -> typing.Optional[builtins.str]:
            '''Checks HTTPS server certificates.

            When set to checkCryptographyOnly, cryptography in the certificate is checked, but not the server's name. Certain subdomains (notably S3 buckets that use dots in the bucket name) don't strictly match the corresponding certificate's wildcard pattern and would otherwise cause the channel to error. This setting is ignored for protocols that do not use HTTPS.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-networkinputsettings.html#cfn-medialive-channel-networkinputsettings-servervalidation
            '''
            result = self._values.get("server_validation")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "NetworkInputSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.NielsenCBETProperty",
        jsii_struct_bases=[],
        name_mapping={
            "cbet_check_digit_string": "cbetCheckDigitString",
            "cbet_stepaside": "cbetStepaside",
            "csid": "csid",
        },
    )
    class NielsenCBETProperty:
        def __init__(
            self,
            *,
            cbet_check_digit_string: typing.Optional[builtins.str] = None,
            cbet_stepaside: typing.Optional[builtins.str] = None,
            csid: typing.Optional[builtins.str] = None,
        ) -> None:
            '''Complete these fields only if you want to insert watermarks of type Nielsen CBET.

            The parent of this entity is NielsenWatermarksSettings

            :param cbet_check_digit_string: Enter the CBET check digits to use in the watermark.
            :param cbet_stepaside: Determines the method of CBET insertion mode when prior encoding is detected on the same layer.
            :param csid: Enter the CBET Source ID (CSID) to use in the watermark.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-nielsencbet.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                nielsen_cBETProperty = medialive.CfnChannel.NielsenCBETProperty(
                    cbet_check_digit_string="cbetCheckDigitString",
                    cbet_stepaside="cbetStepaside",
                    csid="csid"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if cbet_check_digit_string is not None:
                self._values["cbet_check_digit_string"] = cbet_check_digit_string
            if cbet_stepaside is not None:
                self._values["cbet_stepaside"] = cbet_stepaside
            if csid is not None:
                self._values["csid"] = csid

        @builtins.property
        def cbet_check_digit_string(self) -> typing.Optional[builtins.str]:
            '''Enter the CBET check digits to use in the watermark.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-nielsencbet.html#cfn-medialive-channel-nielsencbet-cbetcheckdigitstring
            '''
            result = self._values.get("cbet_check_digit_string")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def cbet_stepaside(self) -> typing.Optional[builtins.str]:
            '''Determines the method of CBET insertion mode when prior encoding is detected on the same layer.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-nielsencbet.html#cfn-medialive-channel-nielsencbet-cbetstepaside
            '''
            result = self._values.get("cbet_stepaside")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def csid(self) -> typing.Optional[builtins.str]:
            '''Enter the CBET Source ID (CSID) to use in the watermark.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-nielsencbet.html#cfn-medialive-channel-nielsencbet-csid
            '''
            result = self._values.get("csid")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "NielsenCBETProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.NielsenConfigurationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "distributor_id": "distributorId",
            "nielsen_pcm_to_id3_tagging": "nielsenPcmToId3Tagging",
        },
    )
    class NielsenConfigurationProperty:
        def __init__(
            self,
            *,
            distributor_id: typing.Optional[builtins.str] = None,
            nielsen_pcm_to_id3_tagging: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The settings to configure Nielsen watermarks.

            The parent of this entity is EncoderSettings.

            :param distributor_id: Enter the Distributor ID assigned to your organization by Nielsen.
            :param nielsen_pcm_to_id3_tagging: Enables Nielsen PCM to ID3 tagging.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-nielsenconfiguration.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                nielsen_configuration_property = medialive.CfnChannel.NielsenConfigurationProperty(
                    distributor_id="distributorId",
                    nielsen_pcm_to_id3_tagging="nielsenPcmToId3Tagging"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if distributor_id is not None:
                self._values["distributor_id"] = distributor_id
            if nielsen_pcm_to_id3_tagging is not None:
                self._values["nielsen_pcm_to_id3_tagging"] = nielsen_pcm_to_id3_tagging

        @builtins.property
        def distributor_id(self) -> typing.Optional[builtins.str]:
            '''Enter the Distributor ID assigned to your organization by Nielsen.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-nielsenconfiguration.html#cfn-medialive-channel-nielsenconfiguration-distributorid
            '''
            result = self._values.get("distributor_id")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def nielsen_pcm_to_id3_tagging(self) -> typing.Optional[builtins.str]:
            '''Enables Nielsen PCM to ID3 tagging.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-nielsenconfiguration.html#cfn-medialive-channel-nielsenconfiguration-nielsenpcmtoid3tagging
            '''
            result = self._values.get("nielsen_pcm_to_id3_tagging")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "NielsenConfigurationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.NielsenNaesIiNwProperty",
        jsii_struct_bases=[],
        name_mapping={"check_digit_string": "checkDigitString", "sid": "sid"},
    )
    class NielsenNaesIiNwProperty:
        def __init__(
            self,
            *,
            check_digit_string: typing.Optional[builtins.str] = None,
            sid: typing.Optional[jsii.Number] = None,
        ) -> None:
            '''Complete these fields only if you want to insert watermarks of type Nielsen NAES II (N2) and Nielsen NAES VI (NW).

            The parent of this entity is NielsenWatermarksSettings.

            :param check_digit_string: Enter the check digit string for the watermark.
            :param sid: Enter the Nielsen Source ID (SID) to include in the watermark.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-nielsennaesiinw.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                nielsen_naes_ii_nw_property = medialive.CfnChannel.NielsenNaesIiNwProperty(
                    check_digit_string="checkDigitString",
                    sid=123
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if check_digit_string is not None:
                self._values["check_digit_string"] = check_digit_string
            if sid is not None:
                self._values["sid"] = sid

        @builtins.property
        def check_digit_string(self) -> typing.Optional[builtins.str]:
            '''Enter the check digit string for the watermark.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-nielsennaesiinw.html#cfn-medialive-channel-nielsennaesiinw-checkdigitstring
            '''
            result = self._values.get("check_digit_string")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def sid(self) -> typing.Optional[jsii.Number]:
            '''Enter the Nielsen Source ID (SID) to include in the watermark.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-nielsennaesiinw.html#cfn-medialive-channel-nielsennaesiinw-sid
            '''
            result = self._values.get("sid")
            return typing.cast(typing.Optional[jsii.Number], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "NielsenNaesIiNwProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.NielsenWatermarksSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "nielsen_cbet_settings": "nielsenCbetSettings",
            "nielsen_distribution_type": "nielsenDistributionType",
            "nielsen_naes_ii_nw_settings": "nielsenNaesIiNwSettings",
        },
    )
    class NielsenWatermarksSettingsProperty:
        def __init__(
            self,
            *,
            nielsen_cbet_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.NielsenCBETProperty"]] = None,
            nielsen_distribution_type: typing.Optional[builtins.str] = None,
            nielsen_naes_ii_nw_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.NielsenNaesIiNwProperty"]] = None,
        ) -> None:
            '''Settings to configure Nielsen Watermarks in the audio encode.

            The parent of this entity is AudioWatermarkSettings.

            :param nielsen_cbet_settings: Complete these fields only if you want to insert watermarks of type Nielsen CBET.
            :param nielsen_distribution_type: Choose the distribution types that you want to assign to the watermarks: - PROGRAM_CONTENT - FINAL_DISTRIBUTOR.
            :param nielsen_naes_ii_nw_settings: Complete these fields only if you want to insert watermarks of type Nielsen NAES II (N2) and Nielsen NAES VI (NW).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-nielsenwatermarkssettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                nielsen_watermarks_settings_property = medialive.CfnChannel.NielsenWatermarksSettingsProperty(
                    nielsen_cbet_settings=medialive.CfnChannel.NielsenCBETProperty(
                        cbet_check_digit_string="cbetCheckDigitString",
                        cbet_stepaside="cbetStepaside",
                        csid="csid"
                    ),
                    nielsen_distribution_type="nielsenDistributionType",
                    nielsen_naes_ii_nw_settings=medialive.CfnChannel.NielsenNaesIiNwProperty(
                        check_digit_string="checkDigitString",
                        sid=123
                    )
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if nielsen_cbet_settings is not None:
                self._values["nielsen_cbet_settings"] = nielsen_cbet_settings
            if nielsen_distribution_type is not None:
                self._values["nielsen_distribution_type"] = nielsen_distribution_type
            if nielsen_naes_ii_nw_settings is not None:
                self._values["nielsen_naes_ii_nw_settings"] = nielsen_naes_ii_nw_settings

        @builtins.property
        def nielsen_cbet_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.NielsenCBETProperty"]]:
            '''Complete these fields only if you want to insert watermarks of type Nielsen CBET.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-nielsenwatermarkssettings.html#cfn-medialive-channel-nielsenwatermarkssettings-nielsencbetsettings
            '''
            result = self._values.get("nielsen_cbet_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.NielsenCBETProperty"]], result)

        @builtins.property
        def nielsen_distribution_type(self) -> typing.Optional[builtins.str]:
            '''Choose the distribution types that you want to assign to the watermarks: - PROGRAM_CONTENT - FINAL_DISTRIBUTOR.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-nielsenwatermarkssettings.html#cfn-medialive-channel-nielsenwatermarkssettings-nielsendistributiontype
            '''
            result = self._values.get("nielsen_distribution_type")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def nielsen_naes_ii_nw_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.NielsenNaesIiNwProperty"]]:
            '''Complete these fields only if you want to insert watermarks of type Nielsen NAES II (N2) and Nielsen NAES VI (NW).

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-nielsenwatermarkssettings.html#cfn-medialive-channel-nielsenwatermarkssettings-nielsennaesiinwsettings
            '''
            result = self._values.get("nielsen_naes_ii_nw_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.NielsenNaesIiNwProperty"]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "NielsenWatermarksSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.OutputDestinationProperty",
        jsii_struct_bases=[],
        name_mapping={
            "id": "id",
            "media_package_settings": "mediaPackageSettings",
            "multiplex_settings": "multiplexSettings",
            "settings": "settings",
        },
    )
    class OutputDestinationProperty:
        def __init__(
            self,
            *,
            id: typing.Optional[builtins.str] = None,
            media_package_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.Sequence[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.MediaPackageOutputDestinationSettingsProperty"]]]] = None,
            multiplex_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.MultiplexProgramChannelDestinationSettingsProperty"]] = None,
            settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.Sequence[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputDestinationSettingsProperty"]]]] = None,
        ) -> None:
            '''Configuration information for an output.

            This entity is at the top level in the channel.

            :param id: The ID for this destination.
            :param media_package_settings: The destination settings for a MediaPackage output.
            :param multiplex_settings: Destination settings for a Multiplex output; one destination for both encoders.
            :param settings: The destination settings for an output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestination.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                output_destination_property = medialive.CfnChannel.OutputDestinationProperty(
                    id="id",
                    media_package_settings=[medialive.CfnChannel.MediaPackageOutputDestinationSettingsProperty(
                        channel_id="channelId"
                    )],
                    multiplex_settings=medialive.CfnChannel.MultiplexProgramChannelDestinationSettingsProperty(
                        multiplex_id="multiplexId",
                        program_name="programName"
                    ),
                    settings=[medialive.CfnChannel.OutputDestinationSettingsProperty(
                        password_param="passwordParam",
                        stream_name="streamName",
                        url="url",
                        username="username"
                    )]
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if id is not None:
                self._values["id"] = id
            if media_package_settings is not None:
                self._values["media_package_settings"] = media_package_settings
            if multiplex_settings is not None:
                self._values["multiplex_settings"] = multiplex_settings
            if settings is not None:
                self._values["settings"] = settings

        @builtins.property
        def id(self) -> typing.Optional[builtins.str]:
            '''The ID for this destination.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestination.html#cfn-medialive-channel-outputdestination-id
            '''
            result = self._values.get("id")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def media_package_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.MediaPackageOutputDestinationSettingsProperty"]]]]:
            '''The destination settings for a MediaPackage output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestination.html#cfn-medialive-channel-outputdestination-mediapackagesettings
            '''
            result = self._values.get("media_package_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.MediaPackageOutputDestinationSettingsProperty"]]]], result)

        @builtins.property
        def multiplex_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.MultiplexProgramChannelDestinationSettingsProperty"]]:
            '''Destination settings for a Multiplex output;

            one destination for both encoders.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestination.html#cfn-medialive-channel-outputdestination-multiplexsettings
            '''
            result = self._values.get("multiplex_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.MultiplexProgramChannelDestinationSettingsProperty"]], result)

        @builtins.property
        def settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputDestinationSettingsProperty"]]]]:
            '''The destination settings for an output.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestination.html#cfn-medialive-channel-outputdestination-settings
            '''
            result = self._values.get("settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputDestinationSettingsProperty"]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "OutputDestinationProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.OutputDestinationSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "password_param": "passwordParam",
            "stream_name": "streamName",
            "url": "url",
            "username": "username",
        },
    )
    class OutputDestinationSettingsProperty:
        def __init__(
            self,
            *,
            password_param: typing.Optional[builtins.str] = None,
            stream_name: typing.Optional[builtins.str] = None,
            url: typing.Optional[builtins.str] = None,
            username: typing.Optional[builtins.str] = None,
        ) -> None:
            '''The configuration information for this output.

            The parent of this entity is OutputDestination.

            :param password_param: The password parameter that holds the password for accessing the downstream system. This password parameter applies only if the downstream system requires credentials.
            :param stream_name: The stream name for the content. This applies only to RTMP outputs.
            :param url: The URL for the destination.
            :param username: The user name to connect to the downstream system. This applies only if the downstream system requires credentials.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestinationsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                output_destination_settings_property = medialive.CfnChannel.OutputDestinationSettingsProperty(
                    password_param="passwordParam",
                    stream_name="streamName",
                    url="url",
                    username="username"
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if password_param is not None:
                self._values["password_param"] = password_param
            if stream_name is not None:
                self._values["stream_name"] = stream_name
            if url is not None:
                self._values["url"] = url
            if username is not None:
                self._values["username"] = username

        @builtins.property
        def password_param(self) -> typing.Optional[builtins.str]:
            '''The password parameter that holds the password for accessing the downstream system.

            This password parameter applies only if the downstream system requires credentials.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestinationsettings.html#cfn-medialive-channel-outputdestinationsettings-passwordparam
            '''
            result = self._values.get("password_param")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def stream_name(self) -> typing.Optional[builtins.str]:
            '''The stream name for the content.

            This applies only to RTMP outputs.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestinationsettings.html#cfn-medialive-channel-outputdestinationsettings-streamname
            '''
            result = self._values.get("stream_name")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def url(self) -> typing.Optional[builtins.str]:
            '''The URL for the destination.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestinationsettings.html#cfn-medialive-channel-outputdestinationsettings-url
            '''
            result = self._values.get("url")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def username(self) -> typing.Optional[builtins.str]:
            '''The user name to connect to the downstream system.

            This applies only if the downstream system requires credentials.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestinationsettings.html#cfn-medialive-channel-outputdestinationsettings-username
            '''
            result = self._values.get("username")
            return typing.cast(typing.Optional[builtins.str], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "OutputDestinationSettingsProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.OutputGroupProperty",
        jsii_struct_bases=[],
        name_mapping={
            "name": "name",
            "output_group_settings": "outputGroupSettings",
            "outputs": "outputs",
        },
    )
    class OutputGroupProperty:
        def __init__(
            self,
            *,
            name: typing.Optional[builtins.str] = None,
            output_group_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputGroupSettingsProperty"]] = None,
            outputs: typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.Sequence[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputProperty"]]]] = None,
        ) -> None:
            '''The settings for one output group.

            The parent of this entity is EncoderSettings.

            :param name: A custom output group name that you can optionally define. Only letters, numbers, and the underscore character are allowed. The maximum length is 32 characters.
            :param output_group_settings: The settings associated with the output group.
            :param outputs: The settings for the outputs in the output group.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroup.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                output_group_property = medialive.CfnChannel.OutputGroupProperty(
                    name="name",
                    output_group_settings=medialive.CfnChannel.OutputGroupSettingsProperty(
                        archive_group_settings=medialive.CfnChannel.ArchiveGroupSettingsProperty(
                            archive_cdn_settings=medialive.CfnChannel.ArchiveCdnSettingsProperty(
                                archive_s3_settings=medialive.CfnChannel.ArchiveS3SettingsProperty(
                                    canned_acl="cannedAcl"
                                )
                            ),
                            destination=medialive.CfnChannel.OutputLocationRefProperty(
                                destination_ref_id="destinationRefId"
                            ),
                            rollover_interval=123
                        ),
                        frame_capture_group_settings=medialive.CfnChannel.FrameCaptureGroupSettingsProperty(
                            destination=medialive.CfnChannel.OutputLocationRefProperty(
                                destination_ref_id="destinationRefId"
                            ),
                            frame_capture_cdn_settings=medialive.CfnChannel.FrameCaptureCdnSettingsProperty(
                                frame_capture_s3_settings=medialive.CfnChannel.FrameCaptureS3SettingsProperty(
                                    canned_acl="cannedAcl"
                                )
                            )
                        ),
                        hls_group_settings=medialive.CfnChannel.HlsGroupSettingsProperty(
                            ad_markers=["adMarkers"],
                            base_url_content="baseUrlContent",
                            base_url_content1="baseUrlContent1",
                            base_url_manifest="baseUrlManifest",
                            base_url_manifest1="baseUrlManifest1",
                            caption_language_mappings=[medialive.CfnChannel.CaptionLanguageMappingProperty(
                                caption_channel=123,
                                language_code="languageCode",
                                language_description="languageDescription"
                            )],
                            caption_language_setting="captionLanguageSetting",
                            client_cache="clientCache",
                            codec_specification="codecSpecification",
                            constant_iv="constantIv",
                            destination=medialive.CfnChannel.OutputLocationRefProperty(
                                destination_ref_id="destinationRefId"
                            ),
                            directory_structure="directoryStructure",
                            discontinuity_tags="discontinuityTags",
                            encryption_type="encryptionType",
                            hls_cdn_settings=medialive.CfnChannel.HlsCdnSettingsProperty(
                                hls_akamai_settings=medialive.CfnChannel.HlsAkamaiSettingsProperty(
                                    connection_retry_interval=123,
                                    filecache_duration=123,
                                    http_transfer_mode="httpTransferMode",
                                    num_retries=123,
                                    restart_delay=123,
                                    salt="salt",
                                    token="token"
                                ),
                                hls_basic_put_settings=medialive.CfnChannel.HlsBasicPutSettingsProperty(
                                    connection_retry_interval=123,
                                    filecache_duration=123,
                                    num_retries=123,
                                    restart_delay=123
                                ),
                                hls_media_store_settings=medialive.CfnChannel.HlsMediaStoreSettingsProperty(
                                    connection_retry_interval=123,
                                    filecache_duration=123,
                                    media_store_storage_class="mediaStoreStorageClass",
                                    num_retries=123,
                                    restart_delay=123
                                ),
                                hls_s3_settings=medialive.CfnChannel.HlsS3SettingsProperty(
                                    canned_acl="cannedAcl"
                                ),
                                hls_webdav_settings=medialive.CfnChannel.HlsWebdavSettingsProperty(
                                    connection_retry_interval=123,
                                    filecache_duration=123,
                                    http_transfer_mode="httpTransferMode",
                                    num_retries=123,
                                    restart_delay=123
                                )
                            ),
                            hls_id3_segment_tagging="hlsId3SegmentTagging",
                            i_frame_only_playlists="iFrameOnlyPlaylists",
                            incomplete_segment_behavior="incompleteSegmentBehavior",
                            index_nSegments=123,
                            input_loss_action="inputLossAction",
                            iv_in_manifest="ivInManifest",
                            iv_source="ivSource",
                            keep_segments=123,
                            key_format="keyFormat",
                            key_format_versions="keyFormatVersions",
                            key_provider_settings=medialive.CfnChannel.KeyProviderSettingsProperty(
                                static_key_settings=medialive.CfnChannel.StaticKeySettingsProperty(
                                    key_provider_server=medialive.CfnChannel.InputLocationProperty(
                                        password_param="passwordParam",
                                        uri="uri",
                                        username="username"
                                    ),
                                    static_key_value="staticKeyValue"
                                )
                            ),
                            manifest_compression="manifestCompression",
                            manifest_duration_format="manifestDurationFormat",
                            min_segment_length=123,
                            mode="mode",
                            output_selection="outputSelection",
                            program_date_time="programDateTime",
                            program_date_time_clock="programDateTimeClock",
                            program_date_time_period=123,
                            redundant_manifest="redundantManifest",
                            segmentation_mode="segmentationMode",
                            segment_length=123,
                            segments_per_subdirectory=123,
                            stream_inf_resolution="streamInfResolution",
                            timed_metadata_id3_frame="timedMetadataId3Frame",
                            timed_metadata_id3_period=123,
                            timestamp_delta_milliseconds=123,
                            ts_file_mode="tsFileMode"
                        ),
                        media_package_group_settings=medialive.CfnChannel.MediaPackageGroupSettingsProperty(
                            destination=medialive.CfnChannel.OutputLocationRefProperty(
                                destination_ref_id="destinationRefId"
                            )
                        ),
                        ms_smooth_group_settings=medialive.CfnChannel.MsSmoothGroupSettingsProperty(
                            acquisition_point_id="acquisitionPointId",
                            audio_only_timecode_control="audioOnlyTimecodeControl",
                            certificate_mode="certificateMode",
                            connection_retry_interval=123,
                            destination=medialive.CfnChannel.OutputLocationRefProperty(
                                destination_ref_id="destinationRefId"
                            ),
                            event_id="eventId",
                            event_id_mode="eventIdMode",
                            event_stop_behavior="eventStopBehavior",
                            filecache_duration=123,
                            fragment_length=123,
                            input_loss_action="inputLossAction",
                            num_retries=123,
                            restart_delay=123,
                            segmentation_mode="segmentationMode",
                            send_delay_ms=123,
                            sparse_track_type="sparseTrackType",
                            stream_manifest_behavior="streamManifestBehavior",
                            timestamp_offset="timestampOffset",
                            timestamp_offset_mode="timestampOffsetMode"
                        ),
                        multiplex_group_settings=medialive.CfnChannel.MultiplexGroupSettingsProperty(),
                        rtmp_group_settings=medialive.CfnChannel.RtmpGroupSettingsProperty(
                            ad_markers=["adMarkers"],
                            authentication_scheme="authenticationScheme",
                            cache_full_behavior="cacheFullBehavior",
                            cache_length=123,
                            caption_data="captionData",
                            input_loss_action="inputLossAction",
                            restart_delay=123
                        ),
                        udp_group_settings=medialive.CfnChannel.UdpGroupSettingsProperty(
                            input_loss_action="inputLossAction",
                            timed_metadata_id3_frame="timedMetadataId3Frame",
                            timed_metadata_id3_period=123
                        )
                    ),
                    outputs=[medialive.CfnChannel.OutputProperty(
                        audio_description_names=["audioDescriptionNames"],
                        caption_description_names=["captionDescriptionNames"],
                        output_name="outputName",
                        output_settings=medialive.CfnChannel.OutputSettingsProperty(
                            archive_output_settings=medialive.CfnChannel.ArchiveOutputSettingsProperty(
                                container_settings=medialive.CfnChannel.ArchiveContainerSettingsProperty(
                                    m2_ts_settings=medialive.CfnChannel.M2tsSettingsProperty(
                                        absent_input_audio_behavior="absentInputAudioBehavior",
                                        arib="arib",
                                        arib_captions_pid="aribCaptionsPid",
                                        arib_captions_pid_control="aribCaptionsPidControl",
                                        audio_buffer_model="audioBufferModel",
                                        audio_frames_per_pes=123,
                                        audio_pids="audioPids",
                                        audio_stream_type="audioStreamType",
                                        bitrate=123,
                                        buffer_model="bufferModel",
                                        cc_descriptor="ccDescriptor",
                                        dvb_nit_settings=medialive.CfnChannel.DvbNitSettingsProperty(
                                            network_id=123,
                                            network_name="networkName",
                                            rep_interval=123
                                        ),
                                        dvb_sdt_settings=medialive.CfnChannel.DvbSdtSettingsProperty(
                                            output_sdt="outputSdt",
                                            rep_interval=123,
                                            service_name="serviceName",
                                            service_provider_name="serviceProviderName"
                                        ),
                                        dvb_sub_pids="dvbSubPids",
                                        dvb_tdt_settings=medialive.CfnChannel.DvbTdtSettingsProperty(
                                            rep_interval=123
                                        ),
                                        dvb_teletext_pid="dvbTeletextPid",
                                        ebif="ebif",
                                        ebp_audio_interval="ebpAudioInterval",
                                        ebp_lookahead_ms=123,
                                        ebp_placement="ebpPlacement",
                                        ecm_pid="ecmPid",
                                        es_rate_in_pes="esRateInPes",
                                        etv_platform_pid="etvPlatformPid",
                                        etv_signal_pid="etvSignalPid",
                                        fragment_time=123,
                                        klv="klv",
                                        klv_data_pids="klvDataPids",
                                        nielsen_id3_behavior="nielsenId3Behavior",
                                        null_packet_bitrate=123,
                                        pat_interval=123,
                                        pcr_control="pcrControl",
                                        pcr_period=123,
                                        pcr_pid="pcrPid",
                                        pmt_interval=123,
                                        pmt_pid="pmtPid",
                                        program_num=123,
                                        rate_mode="rateMode",
                                        scte27_pids="scte27Pids",
                                        scte35_control="scte35Control",
                                        scte35_pid="scte35Pid",
                                        segmentation_markers="segmentationMarkers",
                                        segmentation_style="segmentationStyle",
                                        segmentation_time=123,
                                        timed_metadata_behavior="timedMetadataBehavior",
                                        timed_metadata_pid="timedMetadataPid",
                                        transport_stream_id=123,
                                        video_pid="videoPid"
                                    ),
                                    raw_settings=medialive.CfnChannel.RawSettingsProperty()
                                ),
                                extension="extension",
                                name_modifier="nameModifier"
                            ),
                            frame_capture_output_settings=medialive.CfnChannel.FrameCaptureOutputSettingsProperty(
                                name_modifier="nameModifier"
                            ),
                            hls_output_settings=medialive.CfnChannel.HlsOutputSettingsProperty(
                                h265_packaging_type="h265PackagingType",
                                hls_settings=medialive.CfnChannel.HlsSettingsProperty(
                                    audio_only_hls_settings=medialive.CfnChannel.AudioOnlyHlsSettingsProperty(
                                        audio_group_id="audioGroupId",
                                        audio_only_image=medialive.CfnChannel.InputLocationProperty(
                                            password_param="passwordParam",
                                            uri="uri",
                                            username="username"
                                        ),
                                        audio_track_type="audioTrackType",
                                        segment_type="segmentType"
                                    ),
                                    fmp4_hls_settings=medialive.CfnChannel.Fmp4HlsSettingsProperty(
                                        audio_rendition_sets="audioRenditionSets",
                                        nielsen_id3_behavior="nielsenId3Behavior",
                                        timed_metadata_behavior="timedMetadataBehavior"
                                    ),
                                    frame_capture_hls_settings=medialive.CfnChannel.FrameCaptureHlsSettingsProperty(),
                                    standard_hls_settings=medialive.CfnChannel.StandardHlsSettingsProperty(
                                        audio_rendition_sets="audioRenditionSets",
                                        m3_u8_settings=medialive.CfnChannel.M3u8SettingsProperty(
                                            audio_frames_per_pes=123,
                                            audio_pids="audioPids",
                                            ecm_pid="ecmPid",
                                            nielsen_id3_behavior="nielsenId3Behavior",
                                            pat_interval=123,
                                            pcr_control="pcrControl",
                                            pcr_period=123,
                                            pcr_pid="pcrPid",
                                            pmt_interval=123,
                                            pmt_pid="pmtPid",
                                            program_num=123,
                                            scte35_behavior="scte35Behavior",
                                            scte35_pid="scte35Pid",
                                            timed_metadata_behavior="timedMetadataBehavior",
                                            timed_metadata_pid="timedMetadataPid",
                                            transport_stream_id=123,
                                            video_pid="videoPid"
                                        )
                                    )
                                ),
                                name_modifier="nameModifier",
                                segment_modifier="segmentModifier"
                            ),
                            media_package_output_settings=medialive.CfnChannel.MediaPackageOutputSettingsProperty(),
                            ms_smooth_output_settings=medialive.CfnChannel.MsSmoothOutputSettingsProperty(
                                h265_packaging_type="h265PackagingType",
                                name_modifier="nameModifier"
                            ),
                            multiplex_output_settings=medialive.CfnChannel.MultiplexOutputSettingsProperty(
                                destination=medialive.CfnChannel.OutputLocationRefProperty(
                                    destination_ref_id="destinationRefId"
                                )
                            ),
                            rtmp_output_settings=medialive.CfnChannel.RtmpOutputSettingsProperty(
                                certificate_mode="certificateMode",
                                connection_retry_interval=123,
                                destination=medialive.CfnChannel.OutputLocationRefProperty(
                                    destination_ref_id="destinationRefId"
                                ),
                                num_retries=123
                            ),
                            udp_output_settings=medialive.CfnChannel.UdpOutputSettingsProperty(
                                buffer_msec=123,
                                container_settings=medialive.CfnChannel.UdpContainerSettingsProperty(
                                    m2_ts_settings=medialive.CfnChannel.M2tsSettingsProperty(
                                        absent_input_audio_behavior="absentInputAudioBehavior",
                                        arib="arib",
                                        arib_captions_pid="aribCaptionsPid",
                                        arib_captions_pid_control="aribCaptionsPidControl",
                                        audio_buffer_model="audioBufferModel",
                                        audio_frames_per_pes=123,
                                        audio_pids="audioPids",
                                        audio_stream_type="audioStreamType",
                                        bitrate=123,
                                        buffer_model="bufferModel",
                                        cc_descriptor="ccDescriptor",
                                        dvb_nit_settings=medialive.CfnChannel.DvbNitSettingsProperty(
                                            network_id=123,
                                            network_name="networkName",
                                            rep_interval=123
                                        ),
                                        dvb_sdt_settings=medialive.CfnChannel.DvbSdtSettingsProperty(
                                            output_sdt="outputSdt",
                                            rep_interval=123,
                                            service_name="serviceName",
                                            service_provider_name="serviceProviderName"
                                        ),
                                        dvb_sub_pids="dvbSubPids",
                                        dvb_tdt_settings=medialive.CfnChannel.DvbTdtSettingsProperty(
                                            rep_interval=123
                                        ),
                                        dvb_teletext_pid="dvbTeletextPid",
                                        ebif="ebif",
                                        ebp_audio_interval="ebpAudioInterval",
                                        ebp_lookahead_ms=123,
                                        ebp_placement="ebpPlacement",
                                        ecm_pid="ecmPid",
                                        es_rate_in_pes="esRateInPes",
                                        etv_platform_pid="etvPlatformPid",
                                        etv_signal_pid="etvSignalPid",
                                        fragment_time=123,
                                        klv="klv",
                                        klv_data_pids="klvDataPids",
                                        nielsen_id3_behavior="nielsenId3Behavior",
                                        null_packet_bitrate=123,
                                        pat_interval=123,
                                        pcr_control="pcrControl",
                                        pcr_period=123,
                                        pcr_pid="pcrPid",
                                        pmt_interval=123,
                                        pmt_pid="pmtPid",
                                        program_num=123,
                                        rate_mode="rateMode",
                                        scte27_pids="scte27Pids",
                                        scte35_control="scte35Control",
                                        scte35_pid="scte35Pid",
                                        segmentation_markers="segmentationMarkers",
                                        segmentation_style="segmentationStyle",
                                        segmentation_time=123,
                                        timed_metadata_behavior="timedMetadataBehavior",
                                        timed_metadata_pid="timedMetadataPid",
                                        transport_stream_id=123,
                                        video_pid="videoPid"
                                    )
                                ),
                                destination=medialive.CfnChannel.OutputLocationRefProperty(
                                    destination_ref_id="destinationRefId"
                                ),
                                fec_output_settings=medialive.CfnChannel.FecOutputSettingsProperty(
                                    column_depth=123,
                                    include_fec="includeFec",
                                    row_length=123
                                )
                            )
                        ),
                        video_description_name="videoDescriptionName"
                    )]
                )
            '''
            self._values: typing.Dict[str, typing.Any] = {}
            if name is not None:
                self._values["name"] = name
            if output_group_settings is not None:
                self._values["output_group_settings"] = output_group_settings
            if outputs is not None:
                self._values["outputs"] = outputs

        @builtins.property
        def name(self) -> typing.Optional[builtins.str]:
            '''A custom output group name that you can optionally define.

            Only letters, numbers, and the underscore character are allowed. The maximum length is 32 characters.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroup.html#cfn-medialive-channel-outputgroup-name
            '''
            result = self._values.get("name")
            return typing.cast(typing.Optional[builtins.str], result)

        @builtins.property
        def output_group_settings(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputGroupSettingsProperty"]]:
            '''The settings associated with the output group.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroup.html#cfn-medialive-channel-outputgroup-outputgroupsettings
            '''
            result = self._values.get("output_group_settings")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputGroupSettingsProperty"]], result)

        @builtins.property
        def outputs(
            self,
        ) -> typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputProperty"]]]]:
            '''The settings for the outputs in the output group.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroup.html#cfn-medialive-channel-outputgroup-outputs
            '''
            result = self._values.get("outputs")
            return typing.cast(typing.Optional[typing.Union[aws_cdk.core.IResolvable, typing.List[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.OutputProperty"]]]], result)

        def __eq__(self, rhs: typing.Any) -> builtins.bool:
            return isinstance(rhs, self.__class__) and rhs._values == self._values

        def __ne__(self, rhs: typing.Any) -> builtins.bool:
            return not (rhs == self)

        def __repr__(self) -> str:
            return "OutputGroupProperty(%s)" % ", ".join(
                k + "=" + repr(v) for k, v in self._values.items()
            )

    @jsii.data_type(
        jsii_type="@aws-cdk/aws-medialive.CfnChannel.OutputGroupSettingsProperty",
        jsii_struct_bases=[],
        name_mapping={
            "archive_group_settings": "archiveGroupSettings",
            "frame_capture_group_settings": "frameCaptureGroupSettings",
            "hls_group_settings": "hlsGroupSettings",
            "media_package_group_settings": "mediaPackageGroupSettings",
            "ms_smooth_group_settings": "msSmoothGroupSettings",
            "multiplex_group_settings": "multiplexGroupSettings",
            "rtmp_group_settings": "rtmpGroupSettings",
            "udp_group_settings": "udpGroupSettings",
        },
    )
    class OutputGroupSettingsProperty:
        def __init__(
            self,
            *,
            archive_group_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.ArchiveGroupSettingsProperty"]] = None,
            frame_capture_group_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.FrameCaptureGroupSettingsProperty"]] = None,
            hls_group_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.HlsGroupSettingsProperty"]] = None,
            media_package_group_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.MediaPackageGroupSettingsProperty"]] = None,
            ms_smooth_group_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.MsSmoothGroupSettingsProperty"]] = None,
            multiplex_group_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.MultiplexGroupSettingsProperty"]] = None,
            rtmp_group_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.RtmpGroupSettingsProperty"]] = None,
            udp_group_settings: typing.Optional[typing.Union[aws_cdk.core.IResolvable, "CfnChannel.UdpGroupSettingsProperty"]] = None,
        ) -> None:
            '''The configuration of the output group.

            The parent of this entity is OutputGroup.

            :param archive_group_settings: The configuration of an archive output group. The parent of this entity is OutputGroupSettings.
            :param frame_capture_group_settings: The configuration of a frame capture output group.
            :param hls_group_settings: The configuration of an HLS output group.
            :param media_package_group_settings: The configuration of a MediaPackage output group.
            :param ms_smooth_group_settings: The configuration of a Microsoft Smooth output group.
            :param multiplex_group_settings: The settings for a Multiplex output group.
            :param rtmp_group_settings: The configuration of an RTMP output group.
            :param udp_group_settings: The configuration of a UDP output group.

            :link: http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroupsettings.html
            :exampleMetadata: fixture=_generated

            Example::

                # The code below shows an example of how to instantiate this type.
                # The values are placeholders you should change.
                import aws_cdk.aws_medialive as medialive
                
                output_group_settings_property = medialive.CfnChannel.OutputGroupSettingsProperty(
                    archive_group_settings=medialive.CfnChannel.ArchiveGroupSettingsProperty(
                        archive_cdn_settings=medialive.CfnChannel.ArchiveCdnSettingsProperty(
                            archive_s3_settings=medialive.CfnChannel.ArchiveS3SettingsProperty(
                                canned_acl="cannedAcl"
                            )
                        ),
                        destination=medialive.CfnChannel.OutputLocationRefProperty(
                            destination_ref_id="destinationRefId"
                        ),
                        rollover_interval=123
                    ),
                    frame_capture_group_settings=medialive.CfnChannel.FrameCaptureGroupSettingsProperty(
                        destination=medialive.CfnChannel.OutputLocationRefProperty(
                            destination_ref_id="destinationRefId"
                        ),
                        frame_capture_cdn_settings=medialive.CfnChannel.FrameCaptureCdnSettingsProperty(
                            frame_capture_s3_settings=medialive.CfnChannel.FrameCaptureS3SettingsProperty(
                                canned_acl="cannedAcl"
                            )
                        )
                    ),
                    hls_group_settings=medialive.CfnChannel.HlsGroupSettingsProperty(
                        ad_markers=["adMarkers"],
                        base_url_content="baseUrlContent",
                        base_url_content1="baseUrlContent1",
                        base_url_manifest="baseUrlManifest",
                        base_url_manifest1="baseUrlManifest1",
                        caption_language_mappings=[medialive.CfnChannel.CaptionLanguageMappingProperty(
                            caption_channel=123,
                            language_code="languageCode",
                            language_description="languageDescription"
                        )],
                        caption_language_setting="captionLanguageSetting",
                        client_cache="clientCache",
                        codec_specification="codecSpecification",
                        constant_iv="constantIv",
                        destination=medialive.CfnChannel.OutputLocationRefProperty(
                            destination_ref_id="destinationRefId"
                        ),
                        directory_structure="directoryStructure",
                        discontinuity_tags="discontinuityTags",
                        encryption_type="encryptionType",
                        hls_cdn_settings=medialive.CfnChannel.HlsCdnSettingsProperty(
                            hls_akamai_settings=medialive.CfnChannel.HlsAkamaiSettingsProperty(
                                connection_retry_interval=123,
                                filecache_duration=123,
                                http_transfer_mode="httpTransferMode",
                                num_retries=123,
                                restart_delay=123,
                                salt="salt",
                                token="token"
                            ),
                            hls_basic_put_settings=medialive.CfnChannel.HlsBasicPutSettingsProperty(
                                connection_retry_interval=123,
                                filecache_duration=123,
                                num_retries=123,
                                restart_delay=123
                            ),
                            hls_media_store_settings=medialive.CfnChannel.HlsMediaStoreSettingsProperty(
                                connection_retry_interval=123,
                                filecache_duration=123,
                                media_store_storage_class="mediaStoreStorageClass",
                                num_retries=123,
                                restart_delay=123
                            ),
                            hls_s3_settings=medialive.CfnChannel.HlsS3SettingsProperty(
                                canned_acl="cannedAcl"
                            ),
                            hls_webdav_settings=medialive.CfnChannel.HlsWebdavSettingsProperty(
                                connection_retry_interval=123,
                                filecache_duration=123,
                                http_transfer_mode="httpTransferMode",
                                num_retries=123,
                                restart_delay=123
                            )
                        ),
                        hls_id3_segment_tagging="hlsId3SegmentTagging",
                        i_frame_only_playlists="iFrameOnlyPlaylists",
                        incomplete_segment_behavior="incompleteSegmentBehavior",
                        index_nSegments=123,
                        input_loss_action="inputLossAction",
                        iv_in_manifest="ivInManifest",
                        iv_source="ivSource",
                        keep_segments=123,
                        key_format="keyFormat",
                        key_format_versions="keyFormatVersions",
                        key_provider_settings=medialive.CfnChannel.KeyProviderSettingsProperty(
                            static_key_settings=medialive.CfnChannel.StaticKeySettingsProperty(
                                key_provider_server=medialive.CfnChannel.InputLocationProperty(
                                    password_param="passwordParam",
                                    uri="uri",
                                    username="username"
                                ),
     