# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pyvorse',
 'pyvorse.core',
 'pyvorse.data',
 'pyvorse.mathematics',
 'pyvorse.pipeline',
 'pyvorse.randoms',
 'pyvorse.tests']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'pyvorse',
    'version': '1.0.4',
    'description': 'Simple essentials extension library of additions to vanilla python.',
    'long_description': '# pyvorse\n## Simple essentials extension library of additions to vanilla python.\n\n---\n\n### Includes:\n- [core]:\n  - @attribute - converts any function with (arg: str) to attribute processor\n  - w. - attribute processor to faster writing short words, dont use it in speed is important. For obvious reasons, such a word notation is guaranteed to conform to python\'s naming conventions. w.var_name = "var_name"\n  - class: basis - extended base class\n  - @throws(*exceptions_cls) - marks function with classes, that can be thrown\n  - isthrows(exception_cls) - test function to be marked with `@throws()`\n  - trycall(func, *args, **kwargs) -> tuple[result, exception] - catches exceptions in function call\n  - @safe - converts function to its copy, but automatically called inside `trycall()`, and returns tuple[result, exception]\n  - Operators - enum for @calloperators\n  - @calloperators(op: Operators = Operators.All) - converts function to object, that calls with secon operand and returns result of it function on using operator, selected in argument. Operand still can be called as function.\n  - reprint() - operand-variation of print function, can be called like `reprint - w.text_to_show`. If prints only one value, value will be returned as result.\n  - @functor - allows function to be called with self object as first argument. to work with its fields as example.\n  - class: unibox - class, that locks value inside field `.inbox`, and contains dict for metadata, and can be stopped with `.stop()`, and be test for it by `.stopped`, or `.isStopped()`\n  - copyAllProps(dest, source) - function copies all attributes from source to dest, but ignores attributes with name starting with duble underscore \'__\'\n- [data]:\n  - //ALL_FROM_SUBMODULES//\n  - [deep]\n    - deep - Implements a simplified version of javascript objects based on the "dict" class. Can be created directly or through a class of similar objects that extends "dci". Prototypal inheritance. All methods to look deeper starts with word «deep», like `.deepget(name)`. More details on the wiki.\n    - dci - empty base deepclass, use its `.extend(new_prototype: deep, *names: str)` method, that returns new deepclass object\n    - class: DeepCalss - *ignore it, nothing more then python`s class of «dci»*\n  - [positioned]\n    - class: poslist - list, based on dict. Aloows to contain skips inside.\n  - [simple]\n    - class: loop - list, but handles index overload like list is lopped\n    - class: scope - dict, but allows get-access to items like access to attributes, and attribute-like set access, but onky for keys, already present in dict. Allows to find item by number of a key (it automatically sorted in dicts). Allows getting values dynamic/ Value is a function to be called with self dict as first argument. `.getDynamic(key)` \n    - class: stack - list, extended only, no changes. `.setvalidation(validator: Callable)` - validates values on pushing to the stack. `.push(value)` and `.leftpush(value)`, `.pushes(value)` and `.leftpushes(value)`. Raises ValueError, if loses validation. `.pull()` and `.leftpull(value)` - works like default `.pop()` but without arguments, for last and first element.\n  - [smart]\n    - class: smartlist - list, but with additional methods. find, select, filtered (iter), filter, any, all, astuole, asslist, asset, foreach, mapper, reducer, sort, sliced, slicedstart, slicedend. Working with predicates and callbacks. Details on wiki.\n    - class: handle - Primitive handlers container, simplest pipeline. Objects can be used as decorators, or called with callback passed. On each step calls callback with box on first argument.\n    - class: objectAddress - Create, object `adr = objectAddress()`, write your way `adr["Configs"]["chances"]["spawn"](lambda pos: pos[SNEED])`, and use it on data structire `adr.use(CONFIGS_ROOT)`. It returns same for `CONFIGS_ROOT["Configs"]["chances"]["spawn"][SNEED]`, but can be used nultiple times and dynamically.\n  - [spiders]\n    - class: spider(seeker: Callable, worker: Callable) - spiders can work with complex data structures. Seeker selexts new node, worker does something here. Seeker and worker will be called with (struct, dot, box). Use `box.stop()` to finish spiders`s walk. But worker will be called even if you stop it in seeker. \n  - [table]\n    - class: Table - contains headers and rows. use `table[index_column][index_row]` or better `table.getitem(row:int, col:int)` for extracting values. Use `adddefaultheader(self, name: str, align: int = 0, default=None)` to add new column. You can use `.getdynamic(row:int, col:int)` to work with dynamic values. functions, that will be called with (table: Table, row:int, col:int). For example - auto-numerations. Rendering method not presented! Inherit class, and add any render you want, markdown or html for example.\n    - class: Column - saves names and align for headers. Saves default values for tables.\n    - class: Row: poslist - class represents rows in the table\n- [mathematics] - Whole default math, but with 2 new functions. `trin(n)` for triangular number and count of diagonals in any shape. `hexcount(n)` - for calculatinc number of hexagonal cells in radius from one.\n- [pipeline] - simple tools for complex piplines\n  - //ALL_FROM_SUBMODULES//\n  - [datacell]\n    - class: dcell: core.unibox - just container for value in pipeline.\n  - [mains] - Default pipline functions containers:\n    - DictionaryPipeline\n    - ListPipeline\n  - [routers] - full pipeline conveyor build. Cotains static metadata. Uses pointer to select new function, and it can be method from pipeline container.\n    - class: router - Read on wiki! Use `r.launch(cell)` or `r(cell)`. All functions in pipeline will be called with `(cell, staticmeta)`, with staticmeta from router.\n- [tests]\n  - //ALL_FROM_SUBMODULES//\n  - [exprs]\n    - iterable(o) - allows to get iterator from object, and using `o` inside for..in cycle\n    - nextable(o) - allows to use `next(o)`\n    - forable(o) - deeper version of `iterable(o)` test.\n    - instanceof(o, *cls) - alternative notation to isinstance, like `instanceof(my_num, int, float, complex)`\n    - withable(o) - allows with.. as..\n    - awithable(o) - allows async with.. as..\n    - isinrange(_list, index) - test index for a range in the index\n  - [other]\n    - hashable(o) - can be used as key for dictionary or not.\n    - haskey(o, key) - like hasattr, but tests for `o[key]`\n    - isand(o, *t) - tests o to be all of *t\n    - isor(o, *t) - tests o to be any of *t\n    - eqand(o, *t) - tests o to be equal to all of *t\n    - eqor(o, *t) - tests o to be equal to any of *t\n    - haslen(o) - can be item used in `len(o)` or not.',
    'author': 'Vladislav-Martian',
    'author_email': 'me.as.martian@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/Vladislav-Martian/pyverse',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
