# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from rlbot_action_server.models.base_model_ import Model
from rlbot_action_server.models.bot_action import BotAction  # noqa: F401,E501
from rlbot_action_server import util


class AvailableActions(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, entity_name: str=None, current_action: BotAction=None, available_actions: List[BotAction]=None):  # noqa: E501
        """AvailableActions - a model defined in Swagger

        :param entity_name: The entity_name of this AvailableActions.  # noqa: E501
        :type entity_name: str
        :param current_action: The current_action of this AvailableActions.  # noqa: E501
        :type current_action: BotAction
        :param available_actions: The available_actions of this AvailableActions.  # noqa: E501
        :type available_actions: List[BotAction]
        """
        self.swagger_types = {
            'entity_name': str,
            'current_action': BotAction,
            'available_actions': List[BotAction]
        }

        self.attribute_map = {
            'entity_name': 'entityName',
            'current_action': 'currentAction',
            'available_actions': 'availableActions'
        }
        self._entity_name = entity_name
        self._current_action = current_action
        self._available_actions = available_actions

    @classmethod
    def from_dict(cls, dikt) -> 'AvailableActions':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The AvailableActions of this AvailableActions.  # noqa: E501
        :rtype: AvailableActions
        """
        return util.deserialize_model(dikt, cls)

    @property
    def entity_name(self) -> str:
        """Gets the entity_name of this AvailableActions.

        The name of the bot or script that these actions are associated with.  # noqa: E501

        :return: The entity_name of this AvailableActions.
        :rtype: str
        """
        return self._entity_name

    @entity_name.setter
    def entity_name(self, entity_name: str):
        """Sets the entity_name of this AvailableActions.

        The name of the bot or script that these actions are associated with.  # noqa: E501

        :param entity_name: The entity_name of this AvailableActions.
        :type entity_name: str
        """

        self._entity_name = entity_name

    @property
    def current_action(self) -> BotAction:
        """Gets the current_action of this AvailableActions.


        :return: The current_action of this AvailableActions.
        :rtype: BotAction
        """
        return self._current_action

    @current_action.setter
    def current_action(self, current_action: BotAction):
        """Sets the current_action of this AvailableActions.


        :param current_action: The current_action of this AvailableActions.
        :type current_action: BotAction
        """

        self._current_action = current_action

    @property
    def available_actions(self) -> List[BotAction]:
        """Gets the available_actions of this AvailableActions.


        :return: The available_actions of this AvailableActions.
        :rtype: List[BotAction]
        """
        return self._available_actions

    @available_actions.setter
    def available_actions(self, available_actions: List[BotAction]):
        """Sets the available_actions of this AvailableActions.


        :param available_actions: The available_actions of this AvailableActions.
        :type available_actions: List[BotAction]
        """

        self._available_actions = available_actions
