# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from rlbot_action_server.models.base_model_ import Model
from rlbot_action_server.models.strategic_category import StrategicCategory  # noqa: F401,E501
from rlbot_action_server import util


class BotAction(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, description: str=None, action_type: str=None, strategic_category: StrategicCategory=None, data: Dict=None):  # noqa: E501
        """BotAction - a model defined in Swagger

        :param description: The description of this BotAction.  # noqa: E501
        :type description: str
        :param action_type: The action_type of this BotAction.  # noqa: E501
        :type action_type: str
        :param strategic_category: The strategic_category of this BotAction.  # noqa: E501
        :type strategic_category: StrategicCategory
        :param data: The data of this BotAction.  # noqa: E501
        :type data: Dict
        """
        self.swagger_types = {
            'description': str,
            'action_type': str,
            'strategic_category': StrategicCategory,
            'data': Dict
        }

        self.attribute_map = {
            'description': 'description',
            'action_type': 'actionType',
            'strategic_category': 'strategicCategory',
            'data': 'data'
        }
        self._description = description
        self._action_type = action_type
        self._strategic_category = strategic_category
        self._data = data

    @classmethod
    def from_dict(cls, dikt) -> 'BotAction':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The BotAction of this BotAction.  # noqa: E501
        :rtype: BotAction
        """
        return util.deserialize_model(dikt, cls)

    @property
    def description(self) -> str:
        """Gets the description of this BotAction.


        :return: The description of this BotAction.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str):
        """Sets the description of this BotAction.


        :param description: The description of this BotAction.
        :type description: str
        """

        self._description = description

    @property
    def action_type(self) -> str:
        """Gets the action_type of this BotAction.


        :return: The action_type of this BotAction.
        :rtype: str
        """
        return self._action_type

    @action_type.setter
    def action_type(self, action_type: str):
        """Sets the action_type of this BotAction.


        :param action_type: The action_type of this BotAction.
        :type action_type: str
        """
        if action_type is None:
            raise ValueError("Invalid value for `action_type`, must not be `None`")  # noqa: E501

        self._action_type = action_type

    @property
    def strategic_category(self) -> StrategicCategory:
        """Gets the strategic_category of this BotAction.


        :return: The strategic_category of this BotAction.
        :rtype: StrategicCategory
        """
        return self._strategic_category

    @strategic_category.setter
    def strategic_category(self, strategic_category: StrategicCategory):
        """Sets the strategic_category of this BotAction.


        :param strategic_category: The strategic_category of this BotAction.
        :type strategic_category: StrategicCategory
        """

        self._strategic_category = strategic_category

    @property
    def data(self) -> Dict:
        """Gets the data of this BotAction.


        :return: The data of this BotAction.
        :rtype: Dict
        """
        return self._data

    @data.setter
    def data(self, data: Dict):
        """Sets the data of this BotAction.


        :param data: The data of this BotAction.
        :type data: Dict
        """

        self._data = data
