import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Lifetime of cookies in seconds if session_affinity is GENERATED_COOKIE.
     *
     * If set to 0, the cookie is non-persistent and lasts
     * only until the end of the browser session (or equivalent). The
     * maximum allowed value for TTL is one day.
     *
     * When the load balancing scheme is INTERNAL, this field is not used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#affinity_cookie_ttl_sec ComputeRegionBackendService#affinity_cookie_ttl_sec}
     *
     * @stability stable
     */
    readonly affinityCookieTtlSec?: number;
    /**
     * Time for which instance will be drained (not accept new connections, but still work to finish started).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#connection_draining_timeout_sec ComputeRegionBackendService#connection_draining_timeout_sec}
     *
     * @stability stable
     */
    readonly connectionDrainingTimeoutSec?: number;
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#description ComputeRegionBackendService#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * If true, enable Cloud CDN for this RegionBackendService.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#enable_cdn ComputeRegionBackendService#enable_cdn}
     *
     * @stability stable
     */
    readonly enableCdn?: boolean | cdktf.IResolvable;
    /**
     * The set of URLs to HealthCheck resources for health checking this RegionBackendService. Currently at most one health check can be specified.
     *
     * A health check must be specified unless the backend service uses an internet
     * or serverless NEG as a backend.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#health_checks ComputeRegionBackendService#health_checks}
     *
     * @stability stable
     */
    readonly healthChecks?: string[];
    /**
     * Indicates what kind of load balancing this regional backend service will be used for.
     *
     * A backend service created for one type of load
     * balancing cannot be used with the other(s). Default value: "INTERNAL" Possible values: ["EXTERNAL", "INTERNAL", "INTERNAL_MANAGED"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#load_balancing_scheme ComputeRegionBackendService#load_balancing_scheme}
     *
     * @stability stable
     */
    readonly loadBalancingScheme?: string;
    /**
     * The load balancing algorithm used within the scope of the locality. The possible values are -.
     *
     * ROUND_ROBIN - This is a simple policy in which each healthy backend
     *              is selected in round robin order.
     *
     * LEAST_REQUEST - An O(1) algorithm which selects two random healthy
     *                hosts and picks the host which has fewer active requests.
     *
     * RING_HASH - The ring/modulo hash load balancer implements consistent
     *            hashing to backends. The algorithm has the property that the
     *            addition/removal of a host from a set of N hosts only affects
     *            1/N of the requests.
     *
     * RANDOM - The load balancer selects a random healthy host.
     *
     * ORIGINAL_DESTINATION - Backend host is selected based on the client
     *                       connection metadata, i.e., connections are opened
     *                       to the same address as the destination address of
     *                       the incoming connection before the connection
     *                       was redirected to the load balancer.
     *
     * MAGLEV - used as a drop in replacement for the ring hash load balancer.
     *         Maglev is not as stable as ring hash but has faster table lookup
     *         build times and host selection times. For more information about
     *         Maglev, refer to https://ai.google/research/pubs/pub44824
     *
     * This field is applicable only when the 'load_balancing_scheme' is set to
     * INTERNAL_MANAGED and the 'protocol' is set to HTTP, HTTPS, or HTTP2. Possible values: ["ROUND_ROBIN", "LEAST_REQUEST", "RING_HASH", "RANDOM", "ORIGINAL_DESTINATION", "MAGLEV"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#locality_lb_policy ComputeRegionBackendService#locality_lb_policy}
     *
     * @stability stable
     */
    readonly localityLbPolicy?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#name ComputeRegionBackendService#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The URL of the network to which this backend service belongs.
     *
     * This field can only be specified when the load balancing scheme is set to INTERNAL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#network ComputeRegionBackendService#network}
     *
     * @stability stable
     */
    readonly network?: string;
    /**
     * A named port on a backend instance group representing the port for communication to the backend VMs in that group.
     *
     * Required when the
     * loadBalancingScheme is EXTERNAL, INTERNAL_MANAGED, or INTERNAL_SELF_MANAGED
     * and the backends are instance groups. The named port must be defined on each
     * backend instance group. This parameter has no meaning if the backends are NEGs. API sets a
     * default of "http" if not given.
     * Must be omitted when the loadBalancingScheme is INTERNAL (Internal TCP/UDP Load Balancing).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#port_name ComputeRegionBackendService#port_name}
     *
     * @stability stable
     */
    readonly portName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#project ComputeRegionBackendService#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The protocol this RegionBackendService uses to communicate with backends.
     *
     * The default is HTTP. **NOTE**: HTTP2 is only valid for beta HTTP/2 load balancer
     * types and may result in errors if used with the GA API. Possible values: ["HTTP", "HTTPS", "HTTP2", "SSL", "TCP", "UDP", "GRPC", "UNSPECIFIED"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#protocol ComputeRegionBackendService#protocol}
     *
     * @stability stable
     */
    readonly protocol?: string;
    /**
     * The Region in which the created backend service should reside. If it is not provided, the provider region is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#region ComputeRegionBackendService#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Type of session affinity to use.
     *
     * The default is NONE. Session affinity is
     * not applicable if the protocol is UDP. Possible values: ["NONE", "CLIENT_IP", "CLIENT_IP_PORT_PROTO", "CLIENT_IP_PROTO", "GENERATED_COOKIE", "HEADER_FIELD", "HTTP_COOKIE", "CLIENT_IP_NO_DESTINATION"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#session_affinity ComputeRegionBackendService#session_affinity}
     *
     * @stability stable
     */
    readonly sessionAffinity?: string;
    /**
     * How many seconds to wait for the backend before considering it a failed request.
     *
     * Default is 30 seconds. Valid range is [1, 86400].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#timeout_sec ComputeRegionBackendService#timeout_sec}
     *
     * @stability stable
     */
    readonly timeoutSec?: number;
    /**
     * backend block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#backend ComputeRegionBackendService#backend}
     *
     * @stability stable
     */
    readonly backend?: ComputeRegionBackendServiceBackend[];
    /**
     * cdn_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#cdn_policy ComputeRegionBackendService#cdn_policy}
     *
     * @stability stable
     */
    readonly cdnPolicy?: ComputeRegionBackendServiceCdnPolicy;
    /**
     * circuit_breakers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#circuit_breakers ComputeRegionBackendService#circuit_breakers}
     *
     * @stability stable
     */
    readonly circuitBreakers?: ComputeRegionBackendServiceCircuitBreakers;
    /**
     * consistent_hash block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#consistent_hash ComputeRegionBackendService#consistent_hash}
     *
     * @stability stable
     */
    readonly consistentHash?: ComputeRegionBackendServiceConsistentHash;
    /**
     * failover_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#failover_policy ComputeRegionBackendService#failover_policy}
     *
     * @stability stable
     */
    readonly failoverPolicy?: ComputeRegionBackendServiceFailoverPolicy;
    /**
     * iap block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#iap ComputeRegionBackendService#iap}
     *
     * @stability stable
     */
    readonly iap?: ComputeRegionBackendServiceIap;
    /**
     * log_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#log_config ComputeRegionBackendService#log_config}
     *
     * @stability stable
     */
    readonly logConfig?: ComputeRegionBackendServiceLogConfig;
    /**
     * outlier_detection block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#outlier_detection ComputeRegionBackendService#outlier_detection}
     *
     * @stability stable
     */
    readonly outlierDetection?: ComputeRegionBackendServiceOutlierDetection;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#timeouts ComputeRegionBackendService#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeRegionBackendServiceTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceBackend {
    /**
     * Specifies the balancing mode for this backend. Default value: "CONNECTION" Possible values: ["UTILIZATION", "RATE", "CONNECTION"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#balancing_mode ComputeRegionBackendService#balancing_mode}
     *
     * @stability stable
     */
    readonly balancingMode?: string;
    /**
     * A multiplier applied to the group's maximum servicing capacity (based on UTILIZATION, RATE or CONNECTION).
     *
     * ~>**NOTE**: This field cannot be set for
     * INTERNAL region backend services (default loadBalancingScheme),
     * but is required for non-INTERNAL backend service. The total
     * capacity_scaler for all backends must be non-zero.
     *
     * A setting of 0 means the group is completely drained, offering
     * 0% of its available Capacity. Valid range is [0.0,1.0].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#capacity_scaler ComputeRegionBackendService#capacity_scaler}
     *
     * @stability stable
     */
    readonly capacityScaler?: number;
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#description ComputeRegionBackendService#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * This field designates whether this is a failover backend.
     *
     * More
     * than one failover backend can be configured for a given RegionBackendService.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#failover ComputeRegionBackendService#failover}
     *
     * @stability stable
     */
    readonly failover?: boolean | cdktf.IResolvable;
    /**
     * The fully-qualified URL of an Instance Group or Network Endpoint Group resource.
     *
     * In case of instance group this defines the list
     * of instances that serve traffic. Member virtual machine
     * instances from each instance group must live in the same zone as
     * the instance group itself. No two backends in a backend service
     * are allowed to use same Instance Group resource.
     *
     * For Network Endpoint Groups this defines list of endpoints. All
     * endpoints of Network Endpoint Group must be hosted on instances
     * located in the same zone as the Network Endpoint Group.
     *
     * Backend services cannot mix Instance Group and
     * Network Endpoint Group backends.
     *
     * When the 'load_balancing_scheme' is INTERNAL, only instance groups
     * are supported.
     *
     * Note that you must specify an Instance Group or Network Endpoint
     * Group resource using the fully-qualified URL, rather than a
     * partial URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#group ComputeRegionBackendService#group}
     *
     * @stability stable
     */
    readonly group: string;
    /**
     * The max number of simultaneous connections for the group.
     *
     * Can
     * be used with either CONNECTION or UTILIZATION balancing modes.
     * Cannot be set for INTERNAL backend services.
     *
     * For CONNECTION mode, either maxConnections or one
     * of maxConnectionsPerInstance or maxConnectionsPerEndpoint,
     * as appropriate for group type, must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#max_connections ComputeRegionBackendService#max_connections}
     *
     * @stability stable
     */
    readonly maxConnections?: number;
    /**
     * The max number of simultaneous connections that a single backend network endpoint can handle. Cannot be set for INTERNAL backend services.
     *
     * This is used to calculate the capacity of the group. Can be
     * used in either CONNECTION or UTILIZATION balancing modes. For
     * CONNECTION mode, either maxConnections or
     * maxConnectionsPerEndpoint must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#max_connections_per_endpoint ComputeRegionBackendService#max_connections_per_endpoint}
     *
     * @stability stable
     */
    readonly maxConnectionsPerEndpoint?: number;
    /**
     * The max number of simultaneous connections that a single backend instance can handle. Cannot be set for INTERNAL backend services.
     *
     * This is used to calculate the capacity of the group.
     * Can be used in either CONNECTION or UTILIZATION balancing modes.
     * For CONNECTION mode, either maxConnections or
     * maxConnectionsPerInstance must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#max_connections_per_instance ComputeRegionBackendService#max_connections_per_instance}
     *
     * @stability stable
     */
    readonly maxConnectionsPerInstance?: number;
    /**
     * The max requests per second (RPS) of the group. Cannot be set for INTERNAL backend services.
     *
     * Can be used with either RATE or UTILIZATION balancing modes,
     * but required if RATE mode. Either maxRate or one
     * of maxRatePerInstance or maxRatePerEndpoint, as appropriate for
     * group type, must be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#max_rate ComputeRegionBackendService#max_rate}
     *
     * @stability stable
     */
    readonly maxRate?: number;
    /**
     * The max requests per second (RPS) that a single backend network endpoint can handle.
     *
     * This is used to calculate the capacity of
     * the group. Can be used in either balancing mode. For RATE mode,
     * either maxRate or maxRatePerEndpoint must be set. Cannot be set
     * for INTERNAL backend services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#max_rate_per_endpoint ComputeRegionBackendService#max_rate_per_endpoint}
     *
     * @stability stable
     */
    readonly maxRatePerEndpoint?: number;
    /**
     * The max requests per second (RPS) that a single backend instance can handle.
     *
     * This is used to calculate the capacity of
     * the group. Can be used in either balancing mode. For RATE mode,
     * either maxRate or maxRatePerInstance must be set. Cannot be set
     * for INTERNAL backend services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#max_rate_per_instance ComputeRegionBackendService#max_rate_per_instance}
     *
     * @stability stable
     */
    readonly maxRatePerInstance?: number;
    /**
     * Used when balancingMode is UTILIZATION.
     *
     * This ratio defines the
     * CPU utilization target for the group. Valid range is [0.0, 1.0].
     * Cannot be set for INTERNAL backend services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#max_utilization ComputeRegionBackendService#max_utilization}
     *
     * @stability stable
     */
    readonly maxUtilization?: number;
}
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceCdnPolicyCacheKeyPolicy {
    /**
     * If true requests to different hosts will be cached separately.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#include_host ComputeRegionBackendService#include_host}
     *
     * @stability stable
     */
    readonly includeHost?: boolean | cdktf.IResolvable;
    /**
     * If true, http and https requests will be cached separately.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#include_protocol ComputeRegionBackendService#include_protocol}
     *
     * @stability stable
     */
    readonly includeProtocol?: boolean | cdktf.IResolvable;
    /**
     * If true, include query string parameters in the cache key according to query_string_whitelist and query_string_blacklist.
     *
     * If neither is set, the entire query
     * string will be included.
     *
     * If false, the query string will be excluded from the cache
     * key entirely.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#include_query_string ComputeRegionBackendService#include_query_string}
     *
     * @stability stable
     */
    readonly includeQueryString?: boolean | cdktf.IResolvable;
    /**
     * Names of query string parameters to exclude in cache keys.
     *
     * All other parameters will be included. Either specify
     * query_string_whitelist or query_string_blacklist, not both.
     * '&' and '=' will be percent encoded and not treated as
     * delimiters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#query_string_blacklist ComputeRegionBackendService#query_string_blacklist}
     *
     * @stability stable
     */
    readonly queryStringBlacklist?: string[];
    /**
     * Names of query string parameters to include in cache keys.
     *
     * All other parameters will be excluded. Either specify
     * query_string_whitelist or query_string_blacklist, not both.
     * '&' and '=' will be percent encoded and not treated as
     * delimiters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#query_string_whitelist ComputeRegionBackendService#query_string_whitelist}
     *
     * @stability stable
     */
    readonly queryStringWhitelist?: string[];
}
/**
 * @stability stable
 */
export declare class ComputeRegionBackendServiceCdnPolicyCacheKeyPolicyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _includeHost?;
    /**
     * @stability stable
     */
    get includeHost(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set includeHost(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIncludeHost(): void;
    /**
     * @stability stable
     */
    get includeHostInput(): boolean | cdktf.IResolvable | undefined;
    private _includeProtocol?;
    /**
     * @stability stable
     */
    get includeProtocol(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set includeProtocol(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIncludeProtocol(): void;
    /**
     * @stability stable
     */
    get includeProtocolInput(): boolean | cdktf.IResolvable | undefined;
    private _includeQueryString?;
    /**
     * @stability stable
     */
    get includeQueryString(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set includeQueryString(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIncludeQueryString(): void;
    /**
     * @stability stable
     */
    get includeQueryStringInput(): boolean | cdktf.IResolvable | undefined;
    private _queryStringBlacklist?;
    /**
     * @stability stable
     */
    get queryStringBlacklist(): string[] | undefined;
    /**
     * @stability stable
     */
    set queryStringBlacklist(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetQueryStringBlacklist(): void;
    /**
     * @stability stable
     */
    get queryStringBlacklistInput(): string[] | undefined;
    private _queryStringWhitelist?;
    /**
     * @stability stable
     */
    get queryStringWhitelist(): string[] | undefined;
    /**
     * @stability stable
     */
    set queryStringWhitelist(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetQueryStringWhitelist(): void;
    /**
     * @stability stable
     */
    get queryStringWhitelistInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceCdnPolicyNegativeCachingPolicy {
    /**
     * The HTTP status code to define a TTL against.
     *
     * Only HTTP status codes 300, 301, 308, 404, 405, 410, 421, 451 and 501
     * can be specified as values, and you cannot specify a status code more than once.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#code ComputeRegionBackendService#code}
     *
     * @stability stable
     */
    readonly code?: number;
}
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceCdnPolicy {
    /**
     * Specifies the cache setting for all responses from this backend.
     *
     * The possible values are: USE_ORIGIN_HEADERS, FORCE_CACHE_ALL and CACHE_ALL_STATIC Possible values: ["USE_ORIGIN_HEADERS", "FORCE_CACHE_ALL", "CACHE_ALL_STATIC"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#cache_mode ComputeRegionBackendService#cache_mode}
     *
     * @stability stable
     */
    readonly cacheMode?: string;
    /**
     * Specifies the maximum allowed TTL for cached content served by this origin.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#client_ttl ComputeRegionBackendService#client_ttl}
     *
     * @stability stable
     */
    readonly clientTtl?: number;
    /**
     * Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-max-age).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#default_ttl ComputeRegionBackendService#default_ttl}
     *
     * @stability stable
     */
    readonly defaultTtl?: number;
    /**
     * Specifies the maximum allowed TTL for cached content served by this origin.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#max_ttl ComputeRegionBackendService#max_ttl}
     *
     * @stability stable
     */
    readonly maxTtl?: number;
    /**
     * Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#negative_caching ComputeRegionBackendService#negative_caching}
     *
     * @stability stable
     */
    readonly negativeCaching?: boolean | cdktf.IResolvable;
    /**
     * Serve existing content from the cache (if available) when revalidating content with the origin, or when an error is encountered when refreshing the cache.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#serve_while_stale ComputeRegionBackendService#serve_while_stale}
     *
     * @stability stable
     */
    readonly serveWhileStale?: number;
    /**
     * Maximum number of seconds the response to a signed URL request will be considered fresh, defaults to 1hr (3600s).
     *
     * After this
     * time period, the response will be revalidated before
     * being served.
     *
     * When serving responses to signed URL requests, Cloud CDN will
     * internally behave as though all responses from this backend had a
     * "Cache-Control: public, max-age=[TTL]" header, regardless of any
     * existing Cache-Control header. The actual headers served in
     * responses will not be altered.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#signed_url_cache_max_age_sec ComputeRegionBackendService#signed_url_cache_max_age_sec}
     *
     * @stability stable
     */
    readonly signedUrlCacheMaxAgeSec?: number;
    /**
     * cache_key_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#cache_key_policy ComputeRegionBackendService#cache_key_policy}
     *
     * @stability stable
     */
    readonly cacheKeyPolicy?: ComputeRegionBackendServiceCdnPolicyCacheKeyPolicy;
    /**
     * negative_caching_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#negative_caching_policy ComputeRegionBackendService#negative_caching_policy}
     *
     * @stability stable
     */
    readonly negativeCachingPolicy?: ComputeRegionBackendServiceCdnPolicyNegativeCachingPolicy[];
}
/**
 * @stability stable
 */
export declare class ComputeRegionBackendServiceCdnPolicyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _cacheMode?;
    /**
     * @stability stable
     */
    get cacheMode(): string | undefined;
    /**
     * @stability stable
     */
    set cacheMode(value: string | undefined);
    /**
     * @stability stable
     */
    resetCacheMode(): void;
    /**
     * @stability stable
     */
    get cacheModeInput(): string | undefined;
    private _clientTtl?;
    /**
     * @stability stable
     */
    get clientTtl(): number | undefined;
    /**
     * @stability stable
     */
    set clientTtl(value: number | undefined);
    /**
     * @stability stable
     */
    resetClientTtl(): void;
    /**
     * @stability stable
     */
    get clientTtlInput(): number | undefined;
    private _defaultTtl?;
    /**
     * @stability stable
     */
    get defaultTtl(): number | undefined;
    /**
     * @stability stable
     */
    set defaultTtl(value: number | undefined);
    /**
     * @stability stable
     */
    resetDefaultTtl(): void;
    /**
     * @stability stable
     */
    get defaultTtlInput(): number | undefined;
    private _maxTtl?;
    /**
     * @stability stable
     */
    get maxTtl(): number | undefined;
    /**
     * @stability stable
     */
    set maxTtl(value: number | undefined);
    /**
     * @stability stable
     */
    resetMaxTtl(): void;
    /**
     * @stability stable
     */
    get maxTtlInput(): number | undefined;
    private _negativeCaching?;
    /**
     * @stability stable
     */
    get negativeCaching(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set negativeCaching(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetNegativeCaching(): void;
    /**
     * @stability stable
     */
    get negativeCachingInput(): boolean | cdktf.IResolvable | undefined;
    private _serveWhileStale?;
    /**
     * @stability stable
     */
    get serveWhileStale(): number | undefined;
    /**
     * @stability stable
     */
    set serveWhileStale(value: number | undefined);
    /**
     * @stability stable
     */
    resetServeWhileStale(): void;
    /**
     * @stability stable
     */
    get serveWhileStaleInput(): number | undefined;
    private _signedUrlCacheMaxAgeSec?;
    /**
     * @stability stable
     */
    get signedUrlCacheMaxAgeSec(): number | undefined;
    /**
     * @stability stable
     */
    set signedUrlCacheMaxAgeSec(value: number | undefined);
    /**
     * @stability stable
     */
    resetSignedUrlCacheMaxAgeSec(): void;
    /**
     * @stability stable
     */
    get signedUrlCacheMaxAgeSecInput(): number | undefined;
    private _cacheKeyPolicy?;
    private __cacheKeyPolicyOutput;
    /**
     * @stability stable
     */
    get cacheKeyPolicy(): ComputeRegionBackendServiceCdnPolicyCacheKeyPolicyOutputReference;
    /**
     * @stability stable
     */
    putCacheKeyPolicy(value: ComputeRegionBackendServiceCdnPolicyCacheKeyPolicy | undefined): void;
    /**
     * @stability stable
     */
    resetCacheKeyPolicy(): void;
    /**
     * @stability stable
     */
    get cacheKeyPolicyInput(): ComputeRegionBackendServiceCdnPolicyCacheKeyPolicy | undefined;
    private _negativeCachingPolicy?;
    /**
     * @stability stable
     */
    get negativeCachingPolicy(): ComputeRegionBackendServiceCdnPolicyNegativeCachingPolicy[] | undefined;
    /**
     * @stability stable
     */
    set negativeCachingPolicy(value: ComputeRegionBackendServiceCdnPolicyNegativeCachingPolicy[] | undefined);
    /**
     * @stability stable
     */
    resetNegativeCachingPolicy(): void;
    /**
     * @stability stable
     */
    get negativeCachingPolicyInput(): ComputeRegionBackendServiceCdnPolicyNegativeCachingPolicy[] | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceCircuitBreakers {
    /**
     * The maximum number of connections to the backend cluster. Defaults to 1024.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#max_connections ComputeRegionBackendService#max_connections}
     *
     * @stability stable
     */
    readonly maxConnections?: number;
    /**
     * The maximum number of pending requests to the backend cluster. Defaults to 1024.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#max_pending_requests ComputeRegionBackendService#max_pending_requests}
     *
     * @stability stable
     */
    readonly maxPendingRequests?: number;
    /**
     * The maximum number of parallel requests to the backend cluster. Defaults to 1024.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#max_requests ComputeRegionBackendService#max_requests}
     *
     * @stability stable
     */
    readonly maxRequests?: number;
    /**
     * Maximum requests for a single backend connection.
     *
     * This parameter
     * is respected by both the HTTP/1.1 and HTTP/2 implementations. If
     * not specified, there is no limit. Setting this parameter to 1
     * will effectively disable keep alive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#max_requests_per_connection ComputeRegionBackendService#max_requests_per_connection}
     *
     * @stability stable
     */
    readonly maxRequestsPerConnection?: number;
    /**
     * The maximum number of parallel retries to the backend cluster. Defaults to 3.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#max_retries ComputeRegionBackendService#max_retries}
     *
     * @stability stable
     */
    readonly maxRetries?: number;
}
/**
 * @stability stable
 */
export declare class ComputeRegionBackendServiceCircuitBreakersOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _maxConnections?;
    /**
     * @stability stable
     */
    get maxConnections(): number | undefined;
    /**
     * @stability stable
     */
    set maxConnections(value: number | undefined);
    /**
     * @stability stable
     */
    resetMaxConnections(): void;
    /**
     * @stability stable
     */
    get maxConnectionsInput(): number | undefined;
    private _maxPendingRequests?;
    /**
     * @stability stable
     */
    get maxPendingRequests(): number | undefined;
    /**
     * @stability stable
     */
    set maxPendingRequests(value: number | undefined);
    /**
     * @stability stable
     */
    resetMaxPendingRequests(): void;
    /**
     * @stability stable
     */
    get maxPendingRequestsInput(): number | undefined;
    private _maxRequests?;
    /**
     * @stability stable
     */
    get maxRequests(): number | undefined;
    /**
     * @stability stable
     */
    set maxRequests(value: number | undefined);
    /**
     * @stability stable
     */
    resetMaxRequests(): void;
    /**
     * @stability stable
     */
    get maxRequestsInput(): number | undefined;
    private _maxRequestsPerConnection?;
    /**
     * @stability stable
     */
    get maxRequestsPerConnection(): number | undefined;
    /**
     * @stability stable
     */
    set maxRequestsPerConnection(value: number | undefined);
    /**
     * @stability stable
     */
    resetMaxRequestsPerConnection(): void;
    /**
     * @stability stable
     */
    get maxRequestsPerConnectionInput(): number | undefined;
    private _maxRetries?;
    /**
     * @stability stable
     */
    get maxRetries(): number | undefined;
    /**
     * @stability stable
     */
    set maxRetries(value: number | undefined);
    /**
     * @stability stable
     */
    resetMaxRetries(): void;
    /**
     * @stability stable
     */
    get maxRetriesInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceConsistentHashHttpCookieTtl {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations less than one second are represented
     * with a 0 seconds field and a positive nanos field. Must
     * be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#nanos ComputeRegionBackendService#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#seconds ComputeRegionBackendService#seconds}
     *
     * @stability stable
     */
    readonly seconds: number;
}
/**
 * @stability stable
 */
export declare class ComputeRegionBackendServiceConsistentHashHttpCookieTtlOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _nanos?;
    /**
     * @stability stable
     */
    get nanos(): number | undefined;
    /**
     * @stability stable
     */
    set nanos(value: number | undefined);
    /**
     * @stability stable
     */
    resetNanos(): void;
    /**
     * @stability stable
     */
    get nanosInput(): number | undefined;
    private _seconds?;
    /**
     * @stability stable
     */
    get seconds(): number;
    /**
     * @stability stable
     */
    set seconds(value: number);
    /**
     * @stability stable
     */
    get secondsInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceConsistentHashHttpCookie {
    /**
     * Name of the cookie.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#name ComputeRegionBackendService#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Path to set for the cookie.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#path ComputeRegionBackendService#path}
     *
     * @stability stable
     */
    readonly path?: string;
    /**
     * ttl block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#ttl ComputeRegionBackendService#ttl}
     *
     * @stability stable
     */
    readonly ttl?: ComputeRegionBackendServiceConsistentHashHttpCookieTtl;
}
/**
 * @stability stable
 */
export declare class ComputeRegionBackendServiceConsistentHashHttpCookieOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string | undefined;
    /**
     * @stability stable
     */
    set path(value: string | undefined);
    /**
     * @stability stable
     */
    resetPath(): void;
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
    private _ttl?;
    private __ttlOutput;
    /**
     * @stability stable
     */
    get ttl(): ComputeRegionBackendServiceConsistentHashHttpCookieTtlOutputReference;
    /**
     * @stability stable
     */
    putTtl(value: ComputeRegionBackendServiceConsistentHashHttpCookieTtl | undefined): void;
    /**
     * @stability stable
     */
    resetTtl(): void;
    /**
     * @stability stable
     */
    get ttlInput(): ComputeRegionBackendServiceConsistentHashHttpCookieTtl | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceConsistentHash {
    /**
     * The hash based on the value of the specified header field.
     *
     * This field is applicable if the sessionAffinity is set to HEADER_FIELD.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#http_header_name ComputeRegionBackendService#http_header_name}
     *
     * @stability stable
     */
    readonly httpHeaderName?: string;
    /**
     * The minimum number of virtual nodes to use for the hash ring.
     *
     * Larger ring sizes result in more granular load
     * distributions. If the number of hosts in the load balancing pool
     * is larger than the ring size, each host will be assigned a single
     * virtual node.
     * Defaults to 1024.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#minimum_ring_size ComputeRegionBackendService#minimum_ring_size}
     *
     * @stability stable
     */
    readonly minimumRingSize?: number;
    /**
     * http_cookie block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#http_cookie ComputeRegionBackendService#http_cookie}
     *
     * @stability stable
     */
    readonly httpCookie?: ComputeRegionBackendServiceConsistentHashHttpCookie;
}
/**
 * @stability stable
 */
export declare class ComputeRegionBackendServiceConsistentHashOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _httpHeaderName?;
    /**
     * @stability stable
     */
    get httpHeaderName(): string | undefined;
    /**
     * @stability stable
     */
    set httpHeaderName(value: string | undefined);
    /**
     * @stability stable
     */
    resetHttpHeaderName(): void;
    /**
     * @stability stable
     */
    get httpHeaderNameInput(): string | undefined;
    private _minimumRingSize?;
    /**
     * @stability stable
     */
    get minimumRingSize(): number | undefined;
    /**
     * @stability stable
     */
    set minimumRingSize(value: number | undefined);
    /**
     * @stability stable
     */
    resetMinimumRingSize(): void;
    /**
     * @stability stable
     */
    get minimumRingSizeInput(): number | undefined;
    private _httpCookie?;
    private __httpCookieOutput;
    /**
     * @stability stable
     */
    get httpCookie(): ComputeRegionBackendServiceConsistentHashHttpCookieOutputReference;
    /**
     * @stability stable
     */
    putHttpCookie(value: ComputeRegionBackendServiceConsistentHashHttpCookie | undefined): void;
    /**
     * @stability stable
     */
    resetHttpCookie(): void;
    /**
     * @stability stable
     */
    get httpCookieInput(): ComputeRegionBackendServiceConsistentHashHttpCookie | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceFailoverPolicy {
    /**
     * On failover or failback, this field indicates whether connection drain will be honored.
     *
     * Setting this to true has the following effect: connections
     * to the old active pool are not drained. Connections to the new active pool
     * use the timeout of 10 min (currently fixed). Setting to false has the
     * following effect: both old and new connections will have a drain timeout
     * of 10 min.
     * This can be set to true only if the protocol is TCP.
     * The default is false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#disable_connection_drain_on_failover ComputeRegionBackendService#disable_connection_drain_on_failover}
     *
     * @stability stable
     */
    readonly disableConnectionDrainOnFailover?: boolean | cdktf.IResolvable;
    /**
     * This option is used only when no healthy VMs are detected in the primary and backup instance groups.
     *
     * When set to true, traffic is dropped. When
     * set to false, new connections are sent across all VMs in the primary group.
     * The default is false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#drop_traffic_if_unhealthy ComputeRegionBackendService#drop_traffic_if_unhealthy}
     *
     * @stability stable
     */
    readonly dropTrafficIfUnhealthy?: boolean | cdktf.IResolvable;
    /**
     * The value of the field must be in [0, 1].
     *
     * If the ratio of the healthy
     * VMs in the primary backend is at or below this number, traffic arriving
     * at the load-balanced IP will be directed to the failover backend.
     * In case where 'failoverRatio' is not set or all the VMs in the backup
     * backend are unhealthy, the traffic will be directed back to the primary
     * backend in the "force" mode, where traffic will be spread to the healthy
     * VMs with the best effort, or to all VMs when no VM is healthy.
     * This field is only used with l4 load balancing.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#failover_ratio ComputeRegionBackendService#failover_ratio}
     *
     * @stability stable
     */
    readonly failoverRatio?: number;
}
/**
 * @stability stable
 */
export declare class ComputeRegionBackendServiceFailoverPolicyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _disableConnectionDrainOnFailover?;
    /**
     * @stability stable
     */
    get disableConnectionDrainOnFailover(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set disableConnectionDrainOnFailover(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetDisableConnectionDrainOnFailover(): void;
    /**
     * @stability stable
     */
    get disableConnectionDrainOnFailoverInput(): boolean | cdktf.IResolvable | undefined;
    private _dropTrafficIfUnhealthy?;
    /**
     * @stability stable
     */
    get dropTrafficIfUnhealthy(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set dropTrafficIfUnhealthy(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetDropTrafficIfUnhealthy(): void;
    /**
     * @stability stable
     */
    get dropTrafficIfUnhealthyInput(): boolean | cdktf.IResolvable | undefined;
    private _failoverRatio?;
    /**
     * @stability stable
     */
    get failoverRatio(): number | undefined;
    /**
     * @stability stable
     */
    set failoverRatio(value: number | undefined);
    /**
     * @stability stable
     */
    resetFailoverRatio(): void;
    /**
     * @stability stable
     */
    get failoverRatioInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceIap {
    /**
     * OAuth2 Client ID for IAP.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#oauth2_client_id ComputeRegionBackendService#oauth2_client_id}
     *
     * @stability stable
     */
    readonly oauth2ClientId: string;
    /**
     * OAuth2 Client Secret for IAP.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#oauth2_client_secret ComputeRegionBackendService#oauth2_client_secret}
     *
     * @stability stable
     */
    readonly oauth2ClientSecret: string;
}
/**
 * @stability stable
 */
export declare class ComputeRegionBackendServiceIapOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _oauth2ClientId?;
    /**
     * @stability stable
     */
    get oauth2ClientId(): string;
    /**
     * @stability stable
     */
    set oauth2ClientId(value: string);
    /**
     * @stability stable
     */
    get oauth2ClientIdInput(): string | undefined;
    private _oauth2ClientSecret?;
    /**
     * @stability stable
     */
    get oauth2ClientSecret(): string;
    /**
     * @stability stable
     */
    set oauth2ClientSecret(value: string);
    /**
     * @stability stable
     */
    get oauth2ClientSecretInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceLogConfig {
    /**
     * Whether to enable logging for the load balancer traffic served by this backend service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#enable ComputeRegionBackendService#enable}
     *
     * @stability stable
     */
    readonly enable?: boolean | cdktf.IResolvable;
    /**
     * This field can only be specified if logging is enabled for this backend service.
     *
     * The value of
     * the field must be in [0, 1]. This configures the sampling rate of requests to the load balancer
     * where 1.0 means all logged requests are reported and 0.0 means no logged requests are reported.
     * The default value is 1.0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#sample_rate ComputeRegionBackendService#sample_rate}
     *
     * @stability stable
     */
    readonly sampleRate?: number;
}
/**
 * @stability stable
 */
export declare class ComputeRegionBackendServiceLogConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enable?;
    /**
     * @stability stable
     */
    get enable(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set enable(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEnable(): void;
    /**
     * @stability stable
     */
    get enableInput(): boolean | cdktf.IResolvable | undefined;
    private _sampleRate?;
    /**
     * @stability stable
     */
    get sampleRate(): number | undefined;
    /**
     * @stability stable
     */
    set sampleRate(value: number | undefined);
    /**
     * @stability stable
     */
    resetSampleRate(): void;
    /**
     * @stability stable
     */
    get sampleRateInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceOutlierDetectionBaseEjectionTime {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations
     * less than one second are represented with a 0 'seconds' field and a positive
     * 'nanos' field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#nanos ComputeRegionBackendService#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#seconds ComputeRegionBackendService#seconds}
     *
     * @stability stable
     */
    readonly seconds: number;
}
/**
 * @stability stable
 */
export declare class ComputeRegionBackendServiceOutlierDetectionBaseEjectionTimeOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _nanos?;
    /**
     * @stability stable
     */
    get nanos(): number | undefined;
    /**
     * @stability stable
     */
    set nanos(value: number | undefined);
    /**
     * @stability stable
     */
    resetNanos(): void;
    /**
     * @stability stable
     */
    get nanosInput(): number | undefined;
    private _seconds?;
    /**
     * @stability stable
     */
    get seconds(): number;
    /**
     * @stability stable
     */
    set seconds(value: number);
    /**
     * @stability stable
     */
    get secondsInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceOutlierDetectionInterval {
    /**
     * Span of time that's a fraction of a second at nanosecond resolution.
     *
     * Durations
     * less than one second are represented with a 0 'seconds' field and a positive
     * 'nanos' field. Must be from 0 to 999,999,999 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#nanos ComputeRegionBackendService#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#seconds ComputeRegionBackendService#seconds}
     *
     * @stability stable
     */
    readonly seconds: number;
}
/**
 * @stability stable
 */
export declare class ComputeRegionBackendServiceOutlierDetectionIntervalOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _nanos?;
    /**
     * @stability stable
     */
    get nanos(): number | undefined;
    /**
     * @stability stable
     */
    set nanos(value: number | undefined);
    /**
     * @stability stable
     */
    resetNanos(): void;
    /**
     * @stability stable
     */
    get nanosInput(): number | undefined;
    private _seconds?;
    /**
     * @stability stable
     */
    get seconds(): number;
    /**
     * @stability stable
     */
    set seconds(value: number);
    /**
     * @stability stable
     */
    get secondsInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceOutlierDetection {
    /**
     * Number of errors before a host is ejected from the connection pool.
     *
     * When the
     * backend host is accessed over HTTP, a 5xx return code qualifies as an error.
     * Defaults to 5.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#consecutive_errors ComputeRegionBackendService#consecutive_errors}
     *
     * @stability stable
     */
    readonly consecutiveErrors?: number;
    /**
     * The number of consecutive gateway failures (502, 503, 504 status or connection errors that are mapped to one of those status codes) before a consecutive gateway failure ejection occurs.
     *
     * Defaults to 5.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#consecutive_gateway_failure ComputeRegionBackendService#consecutive_gateway_failure}
     *
     * @stability stable
     */
    readonly consecutiveGatewayFailure?: number;
    /**
     * The percentage chance that a host will be actually ejected when an outlier status is detected through consecutive 5xx.
     *
     * This setting can be used to disable
     * ejection or to ramp it up slowly. Defaults to 100.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#enforcing_consecutive_errors ComputeRegionBackendService#enforcing_consecutive_errors}
     *
     * @stability stable
     */
    readonly enforcingConsecutiveErrors?: number;
    /**
     * The percentage chance that a host will be actually ejected when an outlier status is detected through consecutive gateway failures.
     *
     * This setting can be
     * used to disable ejection or to ramp it up slowly. Defaults to 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#enforcing_consecutive_gateway_failure ComputeRegionBackendService#enforcing_consecutive_gateway_failure}
     *
     * @stability stable
     */
    readonly enforcingConsecutiveGatewayFailure?: number;
    /**
     * The percentage chance that a host will be actually ejected when an outlier status is detected through success rate statistics.
     *
     * This setting can be used to
     * disable ejection or to ramp it up slowly. Defaults to 100.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#enforcing_success_rate ComputeRegionBackendService#enforcing_success_rate}
     *
     * @stability stable
     */
    readonly enforcingSuccessRate?: number;
    /**
     * Maximum percentage of hosts in the load balancing pool for the backend service that can be ejected. Defaults to 10%.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#max_ejection_percent ComputeRegionBackendService#max_ejection_percent}
     *
     * @stability stable
     */
    readonly maxEjectionPercent?: number;
    /**
     * The number of hosts in a cluster that must have enough request volume to detect success rate outliers.
     *
     * If the number of hosts is less than this setting, outlier
     * detection via success rate statistics is not performed for any host in the
     * cluster. Defaults to 5.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#success_rate_minimum_hosts ComputeRegionBackendService#success_rate_minimum_hosts}
     *
     * @stability stable
     */
    readonly successRateMinimumHosts?: number;
    /**
     * The minimum number of total requests that must be collected in one interval (as defined by the interval duration above) to include this host in success rate based outlier detection.
     *
     * If the volume is lower than this setting, outlier
     * detection via success rate statistics is not performed for that host. Defaults
     * to 100.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#success_rate_request_volume ComputeRegionBackendService#success_rate_request_volume}
     *
     * @stability stable
     */
    readonly successRateRequestVolume?: number;
    /**
     * This factor is used to determine the ejection threshold for success rate outlier ejection.
     *
     * The ejection threshold is the difference between the mean success
     * rate, and the product of this factor and the standard deviation of the mean
     * success rate: mean - (stdev * success_rate_stdev_factor). This factor is divided
     * by a thousand to get a double. That is, if the desired factor is 1.9, the
     * runtime value should be 1900. Defaults to 1900.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#success_rate_stdev_factor ComputeRegionBackendService#success_rate_stdev_factor}
     *
     * @stability stable
     */
    readonly successRateStdevFactor?: number;
    /**
     * base_ejection_time block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#base_ejection_time ComputeRegionBackendService#base_ejection_time}
     *
     * @stability stable
     */
    readonly baseEjectionTime?: ComputeRegionBackendServiceOutlierDetectionBaseEjectionTime;
    /**
     * interval block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#interval ComputeRegionBackendService#interval}
     *
     * @stability stable
     */
    readonly interval?: ComputeRegionBackendServiceOutlierDetectionInterval;
}
/**
 * @stability stable
 */
export declare class ComputeRegionBackendServiceOutlierDetectionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _consecutiveErrors?;
    /**
     * @stability stable
     */
    get consecutiveErrors(): number | undefined;
    /**
     * @stability stable
     */
    set consecutiveErrors(value: number | undefined);
    /**
     * @stability stable
     */
    resetConsecutiveErrors(): void;
    /**
     * @stability stable
     */
    get consecutiveErrorsInput(): number | undefined;
    private _consecutiveGatewayFailure?;
    /**
     * @stability stable
     */
    get consecutiveGatewayFailure(): number | undefined;
    /**
     * @stability stable
     */
    set consecutiveGatewayFailure(value: number | undefined);
    /**
     * @stability stable
     */
    resetConsecutiveGatewayFailure(): void;
    /**
     * @stability stable
     */
    get consecutiveGatewayFailureInput(): number | undefined;
    private _enforcingConsecutiveErrors?;
    /**
     * @stability stable
     */
    get enforcingConsecutiveErrors(): number | undefined;
    /**
     * @stability stable
     */
    set enforcingConsecutiveErrors(value: number | undefined);
    /**
     * @stability stable
     */
    resetEnforcingConsecutiveErrors(): void;
    /**
     * @stability stable
     */
    get enforcingConsecutiveErrorsInput(): number | undefined;
    private _enforcingConsecutiveGatewayFailure?;
    /**
     * @stability stable
     */
    get enforcingConsecutiveGatewayFailure(): number | undefined;
    /**
     * @stability stable
     */
    set enforcingConsecutiveGatewayFailure(value: number | undefined);
    /**
     * @stability stable
     */
    resetEnforcingConsecutiveGatewayFailure(): void;
    /**
     * @stability stable
     */
    get enforcingConsecutiveGatewayFailureInput(): number | undefined;
    private _enforcingSuccessRate?;
    /**
     * @stability stable
     */
    get enforcingSuccessRate(): number | undefined;
    /**
     * @stability stable
     */
    set enforcingSuccessRate(value: number | undefined);
    /**
     * @stability stable
     */
    resetEnforcingSuccessRate(): void;
    /**
     * @stability stable
     */
    get enforcingSuccessRateInput(): number | undefined;
    private _maxEjectionPercent?;
    /**
     * @stability stable
     */
    get maxEjectionPercent(): number | undefined;
    /**
     * @stability stable
     */
    set maxEjectionPercent(value: number | undefined);
    /**
     * @stability stable
     */
    resetMaxEjectionPercent(): void;
    /**
     * @stability stable
     */
    get maxEjectionPercentInput(): number | undefined;
    private _successRateMinimumHosts?;
    /**
     * @stability stable
     */
    get successRateMinimumHosts(): number | undefined;
    /**
     * @stability stable
     */
    set successRateMinimumHosts(value: number | undefined);
    /**
     * @stability stable
     */
    resetSuccessRateMinimumHosts(): void;
    /**
     * @stability stable
     */
    get successRateMinimumHostsInput(): number | undefined;
    private _successRateRequestVolume?;
    /**
     * @stability stable
     */
    get successRateRequestVolume(): number | undefined;
    /**
     * @stability stable
     */
    set successRateRequestVolume(value: number | undefined);
    /**
     * @stability stable
     */
    resetSuccessRateRequestVolume(): void;
    /**
     * @stability stable
     */
    get successRateRequestVolumeInput(): number | undefined;
    private _successRateStdevFactor?;
    /**
     * @stability stable
     */
    get successRateStdevFactor(): number | undefined;
    /**
     * @stability stable
     */
    set successRateStdevFactor(value: number | undefined);
    /**
     * @stability stable
     */
    resetSuccessRateStdevFactor(): void;
    /**
     * @stability stable
     */
    get successRateStdevFactorInput(): number | undefined;
    private _baseEjectionTime?;
    private __baseEjectionTimeOutput;
    /**
     * @stability stable
     */
    get baseEjectionTime(): ComputeRegionBackendServiceOutlierDetectionBaseEjectionTimeOutputReference;
    /**
     * @stability stable
     */
    putBaseEjectionTime(value: ComputeRegionBackendServiceOutlierDetectionBaseEjectionTime | undefined): void;
    /**
     * @stability stable
     */
    resetBaseEjectionTime(): void;
    /**
     * @stability stable
     */
    get baseEjectionTimeInput(): ComputeRegionBackendServiceOutlierDetectionBaseEjectionTime | undefined;
    private _interval?;
    private __intervalOutput;
    /**
     * @stability stable
     */
    get interval(): ComputeRegionBackendServiceOutlierDetectionIntervalOutputReference;
    /**
     * @stability stable
     */
    putInterval(value: ComputeRegionBackendServiceOutlierDetectionInterval | undefined): void;
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): ComputeRegionBackendServiceOutlierDetectionInterval | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionBackendServiceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#create ComputeRegionBackendService#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#delete ComputeRegionBackendService#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html#update ComputeRegionBackendService#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class ComputeRegionBackendServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html google_compute_region_backend_service}.
 *
 * @stability stable
 */
export declare class ComputeRegionBackendService extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_region_backend_service.html google_compute_region_backend_service} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeRegionBackendServiceConfig);
    private _affinityCookieTtlSec?;
    /**
     * @stability stable
     */
    get affinityCookieTtlSec(): number | undefined;
    /**
     * @stability stable
     */
    set affinityCookieTtlSec(value: number | undefined);
    /**
     * @stability stable
     */
    resetAffinityCookieTtlSec(): void;
    /**
     * @stability stable
     */
    get affinityCookieTtlSecInput(): number | undefined;
    private _connectionDrainingTimeoutSec?;
    /**
     * @stability stable
     */
    get connectionDrainingTimeoutSec(): number | undefined;
    /**
     * @stability stable
     */
    set connectionDrainingTimeoutSec(value: number | undefined);
    /**
     * @stability stable
     */
    resetConnectionDrainingTimeoutSec(): void;
    /**
     * @stability stable
     */
    get connectionDrainingTimeoutSecInput(): number | undefined;
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _enableCdn?;
    /**
     * @stability stable
     */
    get enableCdn(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set enableCdn(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEnableCdn(): void;
    /**
     * @stability stable
     */
    get enableCdnInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get fingerprint(): string;
    private _healthChecks?;
    /**
     * @stability stable
     */
    get healthChecks(): string[] | undefined;
    /**
     * @stability stable
     */
    set healthChecks(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetHealthChecks(): void;
    /**
     * @stability stable
     */
    get healthChecksInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _loadBalancingScheme?;
    /**
     * @stability stable
     */
    get loadBalancingScheme(): string | undefined;
    /**
     * @stability stable
     */
    set loadBalancingScheme(value: string | undefined);
    /**
     * @stability stable
     */
    resetLoadBalancingScheme(): void;
    /**
     * @stability stable
     */
    get loadBalancingSchemeInput(): string | undefined;
    private _localityLbPolicy?;
    /**
     * @stability stable
     */
    get localityLbPolicy(): string | undefined;
    /**
     * @stability stable
     */
    set localityLbPolicy(value: string | undefined);
    /**
     * @stability stable
     */
    resetLocalityLbPolicy(): void;
    /**
     * @stability stable
     */
    get localityLbPolicyInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _network?;
    /**
     * @stability stable
     */
    get network(): string | undefined;
    /**
     * @stability stable
     */
    set network(value: string | undefined);
    /**
     * @stability stable
     */
    resetNetwork(): void;
    /**
     * @stability stable
     */
    get networkInput(): string | undefined;
    private _portName?;
    /**
     * @stability stable
     */
    get portName(): string | undefined;
    /**
     * @stability stable
     */
    set portName(value: string | undefined);
    /**
     * @stability stable
     */
    resetPortName(): void;
    /**
     * @stability stable
     */
    get portNameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _protocol?;
    /**
     * @stability stable
     */
    get protocol(): string | undefined;
    /**
     * @stability stable
     */
    set protocol(value: string | undefined);
    /**
     * @stability stable
     */
    resetProtocol(): void;
    /**
     * @stability stable
     */
    get protocolInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _sessionAffinity?;
    /**
     * @stability stable
     */
    get sessionAffinity(): string | undefined;
    /**
     * @stability stable
     */
    set sessionAffinity(value: string | undefined);
    /**
     * @stability stable
     */
    resetSessionAffinity(): void;
    /**
     * @stability stable
     */
    get sessionAffinityInput(): string | undefined;
    private _timeoutSec?;
    /**
     * @stability stable
     */
    get timeoutSec(): number | undefined;
    /**
     * @stability stable
     */
    set timeoutSec(value: number | undefined);
    /**
     * @stability stable
     */
    resetTimeoutSec(): void;
    /**
     * @stability stable
     */
    get timeoutSecInput(): number | undefined;
    private _backend?;
    /**
     * @stability stable
     */
    get backend(): ComputeRegionBackendServiceBackend[] | undefined;
    /**
     * @stability stable
     */
    set backend(value: ComputeRegionBackendServiceBackend[] | undefined);
    /**
     * @stability stable
     */
    resetBackend(): void;
    /**
     * @stability stable
     */
    get backendInput(): ComputeRegionBackendServiceBackend[] | undefined;
    private _cdnPolicy?;
    private __cdnPolicyOutput;
    /**
     * @stability stable
     */
    get cdnPolicy(): ComputeRegionBackendServiceCdnPolicyOutputReference;
    /**
     * @stability stable
     */
    putCdnPolicy(value: ComputeRegionBackendServiceCdnPolicy | undefined): void;
    /**
     * @stability stable
     */
    resetCdnPolicy(): void;
    /**
     * @stability stable
     */
    get cdnPolicyInput(): ComputeRegionBackendServiceCdnPolicy | undefined;
    private _circuitBreakers?;
    private __circuitBreakersOutput;
    /**
     * @stability stable
     */
    get circuitBreakers(): ComputeRegionBackendServiceCircuitBreakersOutputReference;
    /**
     * @stability stable
     */
    putCircuitBreakers(value: ComputeRegionBackendServiceCircuitBreakers | undefined): void;
    /**
     * @stability stable
     */
    resetCircuitBreakers(): void;
    /**
     * @stability stable
     */
    get circuitBreakersInput(): ComputeRegionBackendServiceCircuitBreakers | undefined;
    private _consistentHash?;
    private __consistentHashOutput;
    /**
     * @stability stable
     */
    get consistentHash(): ComputeRegionBackendServiceConsistentHashOutputReference;
    /**
     * @stability stable
     */
    putConsistentHash(value: ComputeRegionBackendServiceConsistentHash | undefined): void;
    /**
     * @stability stable
     */
    resetConsistentHash(): void;
    /**
     * @stability stable
     */
    get consistentHashInput(): ComputeRegionBackendServiceConsistentHash | undefined;
    private _failoverPolicy?;
    private __failoverPolicyOutput;
    /**
     * @stability stable
     */
    get failoverPolicy(): ComputeRegionBackendServiceFailoverPolicyOutputReference;
    /**
     * @stability stable
     */
    putFailoverPolicy(value: ComputeRegionBackendServiceFailoverPolicy | undefined): void;
    /**
     * @stability stable
     */
    resetFailoverPolicy(): void;
    /**
     * @stability stable
     */
    get failoverPolicyInput(): ComputeRegionBackendServiceFailoverPolicy | undefined;
    private _iap?;
    private __iapOutput;
    /**
     * @stability stable
     */
    get iap(): ComputeRegionBackendServiceIapOutputReference;
    /**
     * @stability stable
     */
    putIap(value: ComputeRegionBackendServiceIap | undefined): void;
    /**
     * @stability stable
     */
    resetIap(): void;
    /**
     * @stability stable
     */
    get iapInput(): ComputeRegionBackendServiceIap | undefined;
    private _logConfig?;
    private __logConfigOutput;
    /**
     * @stability stable
     */
    get logConfig(): ComputeRegionBackendServiceLogConfigOutputReference;
    /**
     * @stability stable
     */
    putLogConfig(value: ComputeRegionBackendServiceLogConfig | undefined): void;
    /**
     * @stability stable
     */
    resetLogConfig(): void;
    /**
     * @stability stable
     */
    get logConfigInput(): ComputeRegionBackendServiceLogConfig | undefined;
    private _outlierDetection?;
    private __outlierDetectionOutput;
    /**
     * @stability stable
     */
    get outlierDetection(): ComputeRegionBackendServiceOutlierDetectionOutputReference;
    /**
     * @stability stable
     */
    putOutlierDetection(value: ComputeRegionBackendServiceOutlierDetection | undefined): void;
    /**
     * @stability stable
     */
    resetOutlierDetection(): void;
    /**
     * @stability stable
     */
    get outlierDetectionInput(): ComputeRegionBackendServiceOutlierDetection | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): ComputeRegionBackendServiceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeRegionBackendServiceTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeRegionBackendServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
