# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pydantic_geojson']

package_data = \
{'': ['*']}

install_requires = \
['pydantic>=1.9.0,<2.0.0']

setup_kwargs = {
    'name': 'pydantic-geojson',
    'version': '0.0.3',
    'description': 'Pydantic validation for GeoJson',
    'long_description': '[![GitHub Actions status for master branch](https://github.com/gb-libs/pydantic-geojson/actions/workflows/main.yml/badge.svg)](https://github.com/gb-libs/pydantic-geojson/actions?query=workflow%3A%22Python+package%22)\n[![Latest PyPI package version](https://badge.fury.io/py/pydantic-geojson.svg)](https://pypi.org/project/pydantic-geojson/)\n[![codecov](https://codecov.io/gh/gb-libs/pydantic-geojson/branch/master/graph/badge.svg?token=8LMKSDQTIR)](https://codecov.io/gh/gb-libs/pydantic-geojson)\n[![Downloads](https://static.pepy.tech/personalized-badge/pydantic-geojson?period=total&units=international_system&left_color=grey&right_color=blue&left_text=Downloads)](https://pepy.tech/project/pydantic-geojson)\n\npydantic-geojson 🌍\n===================\n\n\n| GeoJSON Objects    | Status |\n|--------------------|--------|\n| Point              | ✅      |\n| MultiPoint         | ✅      |\n| LineString         | ✅      |\n| MultiLineString    | ✅      |\n| Polygon            | ✅      |\n| MultiPolygon       | ✅      |\n| GeometryCollection | ✅      |\n| Feature            | ✅      |\n| FeatureCollection  | ✅      |\n\nInstallation\n------------\n\npydantic-geojson is compatible with Python 3.7 and up.\nThe recommended way to install is via [poetry](https://python-poetry.org/):\n\n```\npoetry add pydantic_geojson\n```\n\nUsing pip to install is also possible.\n\n```\npip install pydantic_geojson\n```\n\nGEOJSON\n-------\n\n[GeoJSON](https://geojson.org/) is a format for encoding a variety of geographic data structures.\n\n```\n{\n    "type": "Feature",\n    "geometry": {\n        "type": "Point",\n        "coordinates": [125.6, 10.1]\n    },\n    "properties": {\n        "name": "Dinagat Islands"\n    }\n}\n```\n\nGeoJSON supports the following geometry types: Point, LineString, Polygon,\nMultiPoint, MultiLineString, and MultiPolygon. Geometric objects with\nadditional properties are Feature objects. Sets of features are contained by\nFeatureCollection objects.\n\nExamples of using\n-----------------\n\nCustom properties:\n\n```\nfrom pydantic import BaseModel\nfrom pydantic_geojson import FeatureModel\n\n\nclass MyPropertiesModel(BaseModel):\n    name: str\n\n\nclass MyFeatureModel(FeatureModel):\n    properties: MyPropertiesModel\n\n\ndata = {\n    "type": "Feature",\n    "properties": {\n        "name": "foo name",\n    },\n    "geometry": {\n        "type": "Polygon",\n        "coordinates": [\n            [\n                [-80.724878, 35.265454],\n                [-80.722646, 35.260338]\n            ]\n        ]\n    }\n}\n\n>>> MyFeatureModel(**data)\n>>> type=\'Feature\' geometry=PolygonModel(type=\'Polygon\', coordinates=[[Coordinates(lon=-80.724878, lat=35.265454), Coordinates(lon=-80.722646, lat=35.260338)]]) properties=MyPropertiesModel(name=\'foo name\')\n```\n\nPoint\n-----\n\nSimple example data:\n\n```\nfrom pydantic_geojson import PointModel\n\ndata = {\n    "type": "Point",\n    "coordinates": [-105.01621, 39.57422]\n}\n\n>>> PointModel(**data)\n>>> type=\'Point\' coordinates=Coordinates(lon=-105.01621, lat=39.57422)\n```\n\nMultiPoint\n----------\n\nSimple example data:\n\n```\nfrom pydantic_geojson import MultiPointModel\n\ndata = {\n    "type": "MultiPoint",\n    "coordinates": [\n        [-105.01621, 39.57422],\n        [-80.666513, 35.053994]\n    ]\n}\n\n>>> PointModel(**data)\n>>> type=\'MultiPoint\' coordinates=[Coordinates(lon=-105.01621, lat=39.57422), Coordinates(lon=-80.666513, lat=35.053994)]\n```\n\nLineString\n----------\n\nSimple example data:\n\n```\nfrom pydantic_geojson import LineStringModel\n\ndata = {\n    "type": "LineString",\n    "coordinates": [\n        [-99.113159, 38.869651],\n        [-99.0802, 38.85682],\n        [-98.822021, 38.85682],\n        [-98.448486, 38.848264]\n    ]\n}\n\n>>> LineStringModel(**data)\n>>> type=\'LineString\' coordinates=[Coordinates(lon=-99.113159, lat=38.869651), Coordinates(lon=-99.0802, lat=38.85682), Coordinates(lon=-98.822021, lat=38.85682), Coordinates(lon=-98.448486, lat=38.848264)]\n```\n\nMultiLineString\n---------------\n\nSimple example data:\n\n```\nfrom pydantic_geojson import MultiLineStringModel\n\ndata = {\n    "type": "MultiLineString",\n    "coordinates": [\n        [\n            [-105.019898, 39.574997],\n            [-105.019598, 39.574898],\n            [-105.019061, 39.574782]\n        ],\n        [\n            [-105.017173, 39.574402],\n            [-105.01698, 39.574385],\n            [-105.016636, 39.574385],\n            [-105.016508, 39.574402],\n            [-105.01595, 39.57427]\n        ],\n        [\n            [-105.014276, 39.573972],\n            [-105.014126, 39.574038],\n            [-105.013825, 39.57417],\n            [-105.01331, 39.574452]\n        ]\n    ]\n}\n\n>>> MultiLineStringModel(**data)\n>>> type=\'MultiLineString\' coordinates=[[Coordinates(lon=-105.019898, lat=39.574997), Coordinates(lon=-105.019598, lat=39.574898), Coordinates(lon=-105.019061, lat=39.574782)], [Coordinates(lon=-105.017173, lat=39.574402), Coordinates(lon=-105.01698, lat=39.574385), Coordinates(lon=-105.016636, lat=39.574385), Coordinates(lon=-105.016508, lat=39.574402), Coordinates(lon=-105.01595, lat=39.57427)], [Coordinates(lon=-105.014276, lat=39.573972), Coordinates(lon=-105.014126, lat=39.574038), Coordinates(lon=-105.013825, lat=39.57417), Coordinates(lon=-105.01331, lat=39.574452)]]\n```\n\nPolygon\n-------\n\nSimple example data:\n\n```\nfrom pydantic_geojson import PolygonModel\n\ndata = {\n    "type": "Polygon",\n    "coordinates": [\n        [\n            [100, 0],\n            [101, 0],\n            [101, 1],\n            [100, 1],\n            [100, 0]\n        ]\n    ]\n}\n\n>>> PolygonModel(**data)\n>>> type=\'Polygon\' coordinates=[[Coordinates(lon=100.0, lat=0.0), Coordinates(lon=101.0, lat=0.0), Coordinates(lon=101.0, lat=1.0), Coordinates(lon=100.0, lat=1.0), Coordinates(lon=100.0, lat=0.0)]]\n```\n\nMultiPolygon\n------------\n\nSimple example data:\n\n```\nfrom pydantic_geojson import MultiPolygonModel\n\ndata = {\n    "type": "MultiPolygon",\n    "coordinates": [\n        [\n            [\n                [107, 7],\n                [108, 7],\n                [108, 8],\n                [107, 8],\n                [107, 7]\n            ]\n        ],\n        [\n            [\n                [100, 0],\n                [101, 0],\n                [101, 1],\n                [100, 1],\n                [100, 0]\n            ]\n        ]\n    ]\n}\n\n>>> MultiPolygonModel(**data)\n>>> type=\'MultiPolygon\' coordinates=[[[Coordinates(lon=107.0, lat=7.0), Coordinates(lon=108.0, lat=7.0), Coordinates(lon=108.0, lat=8.0), Coordinates(lon=107.0, lat=8.0), Coordinates(lon=107.0, lat=7.0)]], [[Coordinates(lon=100.0, lat=0.0), Coordinates(lon=101.0, lat=0.0), Coordinates(lon=101.0, lat=1.0), Coordinates(lon=100.0, lat=1.0), Coordinates(lon=100.0, lat=0.0)]]]\n```\n\nGeometryCollection\n------------------\n\nSimple example data:\n\n```\nfrom pydantic_geojson import GeometryCollectionModel\n\ndata = {\n    "type": "GeometryCollection",\n    "geometries": [\n        {\n            "type": "Point",\n            "coordinates": [-80.660805, 35.049392]\n        },\n        {\n            "type": "Polygon",\n            "coordinates": [\n                [\n                    [-80.664582, 35.044965],\n                    [-80.663874, 35.04428],\n                    [-80.662586, 35.04558],\n                    [-80.663444, 35.046036],\n                    [-80.664582, 35.044965]\n                ]\n            ]\n        },\n        {\n            "type": "LineString",\n            "coordinates": [\n                [-80.662372, 35.059509],\n                [-80.662693, 35.059263],\n                [-80.662844, 35.05893]\n            ]\n        }\n    ]\n}\n\n>>> GeometryCollectionModel(**data)\n>>> type=\'GeometryCollection\' geometries=[PointModel(type=\'Point\', coordinates=Coordinates(lon=-80.660805, lat=35.049392)), PolygonModel(type=\'Polygon\', coordinates=[[Coordinates(lon=-80.664582, lat=35.044965), Coordinates(lon=-80.663874, lat=35.04428), Coordinates(lon=-80.662586, lat=35.04558), Coordinates(lon=-80.663444, lat=35.046036), Coordinates(lon=-80.664582, lat=35.044965)]]), LineStringModel(type=\'LineString\', coordinates=[Coordinates(lon=-80.662372, lat=35.059509), Coordinates(lon=-80.662693, lat=35.059263), Coordinates(lon=-80.662844, lat=35.05893)])]\n```\n\nFeature\n-------\n\nSimple example data:\n\n```\nfrom pydantic_geojson import FeatureModel\n\ndata = {\n    "type": "Feature",\n    "geometry": {\n        "type": "Polygon",\n        "coordinates": [\n            [\n                [-80.724878, 35.265454],\n                [-80.722646, 35.260338],\n                [-80.720329, 35.260618],\n                [-80.71681, 35.255361],\n                [-80.704793, 35.268397],\n                [-82.715179, 35.267696],\n                [-80.721359, 35.267276],\n                [-80.724878, 35.265454]\n            ]\n        ]\n    }\n}\n\n>>> FeatureModel(**data)\n>>> type=\'Feature\' geometry=PolygonModel(type=\'Polygon\', coordinates=[[Coordinates(lon=-80.724878, lat=35.265454), Coordinates(lon=-80.722646, lat=35.260338), Coordinates(lon=-80.720329, lat=35.260618), Coordinates(lon=-80.71681, lat=35.255361), Coordinates(lon=-80.704793, lat=35.268397), Coordinates(lon=-82.715179, lat=35.267696), Coordinates(lon=-80.721359, lat=35.267276), Coordinates(lon=-80.724878, lat=35.265454)]])\n\n```\n\nFeatureCollection\n-----------------\n\nSimple example data:\n\n```\nfrom pydantic_geojson import FeatureCollectionModel\n\ndata = {\n    "type": "FeatureCollection",\n    "features": [\n        {\n            "type": "Feature",\n            "geometry": {\n                "type": "Point",\n                "coordinates": [-80.870885, 35.215151]\n            }\n        },\n        {\n            "type": "Feature",\n            "geometry": {\n                "type": "Polygon",\n                "coordinates": [\n                    [\n                        [-80.724878, 35.265454],\n                        [-80.722646, 35.260338],\n                        [-80.720329, 35.260618],\n                        [-80.704793, 35.268397],\n                        [-80.724878, 35.265454]\n                    ]\n                ]\n            }\n        }\n    ]\n}\n\n>>> FeatureCollectionModel(**data)\n>>> type=\'FeatureCollection\' features=[FeatureModel(type=\'Feature\', geometry=PointModel(type=\'Point\', coordinates=Coordinates(lon=-80.870885, lat=35.215151))), FeatureModel(type=\'Feature\', geometry=PolygonModel(type=\'Polygon\', coordinates=[[Coordinates(lon=-80.724878, lat=35.265454), Coordinates(lon=-80.722646, lat=35.260338), Coordinates(lon=-80.720329, lat=35.260618), Coordinates(lon=-80.704793, lat=35.268397), Coordinates(lon=-80.724878, lat=35.265454)]]))]\n\n```\n',
    'author': 'Aliaksandr Vaskevich',
    'author_email': 'vaskevic.an@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/gb-libs/pydantic-geojson',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
