# -*- encoding:utf-8 -*-
"""
    标准规范化数据工具模块
"""


def scaler_std(group):
    """
    对输入的group进行(group - group.mean()) / group.std()
            eg.
                pd.DataFrame对象

                input:
                            tsla	bidu	noah	sfun	goog	vips	aapl
                2014-07-25	223.57	226.50	15.32	12.110	589.02	21.349	97.67
                2014-07-28	224.82	225.80	16.13	12.450	590.60	21.548	99.02
                2014-07-29	225.01	220.00	16.75	12.220	585.61	21.190	98.38
                2014-07-30	228.92	219.13	16.83	11.780	587.42	21.185	98.15

                output:

                            tsla	bidu	noah	sfun	goog	vips	aapl
                2014-07-25	-0.1924	1.2047	-1.5325	2.6732	-0.4127	0.4478	-1.1364
                2014-07-28	-0.1435	1.1791	-1.3850	2.8601	-0.3942	0.4860	-1.0202
                2014-07-29	-0.1361	0.9677	-1.2721	2.7337	-0.4525	0.4172	-1.0753
                2014-07-30	0.0169	0.9360	-1.2575	2.4919	-0.4314	0.4163	-1.0951

                pd.Series对象

                input:

                2014-07-25    223.57
                2014-07-28    224.82
                2014-07-29    225.01
                2014-07-30    228.92
                2014-07-31    223.30

                output:

                2014-07-25   -0.1924
                2014-07-28   -0.1435
                2014-07-29   -0.1361
                2014-07-30    0.0169
                2014-07-31   -0.2030


                np.array

                input:
                array([[ 223.57 ,  226.5  ,   15.32 , ...,  589.02 ,   21.349,   97.67 ],
               [ 224.82 ,  225.8  ,   16.13 , ...,  590.6  ,   21.548,   99.02 ],
               [ 225.01 ,  220.   ,   16.75 , ...,  585.61 ,   21.19 ,   98.38 ],
               ...,
               [ 222.27 ,  160.88 ,   25.5  , ...,  742.74 ,   13.51 ,   98.66 ],
               [ 230.01 ,  160.25 ,   25.57 , ...,  739.77 ,   13.39 ,   97.34 ],
               [ 225.93 ,  163.09 ,   24.75 , ...,  740.92 ,   13.655,   97.76 ]])

               output:

                array([[ 0.2497,  0.264 , -0.7675, ...,  2.0348, -0.738 , -0.3652],
                       [ 0.2558,  0.2606, -0.7635, ...,  2.0425, -0.7371, -0.3587],
                       [ 0.2568,  0.2323, -0.7605, ...,  2.0181, -0.7388, -0.3618],
                       ...,
                       [ 0.2434, -0.0565, -0.7178, ...,  2.7857, -0.7763, -0.3604],
                       [ 0.2812, -0.0596, -0.7174, ...,  2.7712, -0.7769, -0.3669],
                       [ 0.2612, -0.0457, -0.7214, ...,  2.7768, -0.7756, -0.3648]])

    :param group: pd.DataFrame对象, pd.Series对象, np.array对象
    """
    return (group - group.mean()) / group.std()


def scaler_one(group):
    """
        使用序列的第一个数据进行标准化处理，即将序列转换为第一个数据为1.0开始的序列
        eg: group
            2011-07-28    9820.0
            2011-07-29    9845.0
            2011-08-01    9685.0
            2011-08-02    9653.0
            2011-08-03    9549.0
            2011-08-04    9345.0
            2011-08-05    9114.8
            2011-08-08    8766.8
            2011-08-09    8750.0
            2011-08-10    8646.0
                           ...
            2017-07-13    5864.5
            2017-07-14    5928.0
            2017-07-17    6004.5
            2017-07-18    6004.0
            2017-07-19    5966.0
            2017-07-20    5982.0
            2017-07-21    5997.0
            2017-07-24    6033.5
            2017-07-25    6261.0
            2017-07-26    6306.5

        scaler_one(group)

            2011-07-28    1.0000
            2011-07-29    1.0025
            2011-08-01    0.9863
            2011-08-02    0.9830
            2011-08-03    0.9724
            2011-08-04    0.9516
            2011-08-05    0.9282
            2011-08-08    0.8927
            2011-08-09    0.8910
            2011-08-10    0.8804
                           ...
            2017-07-13    0.5972
            2017-07-14    0.6037
            2017-07-17    0.6115
            2017-07-18    0.6114
            2017-07-19    0.6075
            2017-07-20    0.6092
            2017-07-21    0.6107
            2017-07-24    0.6144
            2017-07-25    0.6376
            2017-07-26    0.6422
    :param group: pd.DataFrame对象, pd.Series对象, np.array对象
    """
    return group / group[0]


def scaler_mm(group):
    """
    对输入的group进行(group - group.min()) / (group.max() - group.min())
            eg.
                pd.DataFrame对象

                input:
                            tsla	bidu	noah	sfun	goog	vips	aapl
                2014-07-25	223.57	226.50	15.32	12.110	589.02	21.349	97.67
                2014-07-28	224.82	225.80	16.13	12.450	590.60	21.548	99.02
                2014-07-29	225.01	220.00	16.75	12.220	585.61	21.190	98.38
                2014-07-30	228.92	219.13	16.83	11.780	587.42	21.185	98.15

                output:
                            tsla	bidu	noah	sfun	goog	vips	aapl
                2014-07-25	0.5612	0.7979	0.0973	0.9493	0.3396	0.5597	0.1718
                2014-07-28	0.5700	0.7920	0.1305	0.9913	0.3452	0.5699	0.2035
                2014-07-29	0.5713	0.7428	0.1559	0.9629	0.3276	0.5517	0.1885
                2014-07-30	0.5988	0.7354	0.1592	0.9084	0.3340	0.5514	0.1831

                pd.Series对象

                input:
                2014-07-25    223.57
                2014-07-28    224.82
                2014-07-29    225.01
                2014-07-30    228.92
                2014-07-31    223.30

                output:
                2014-07-25    0.5612
                2014-07-28    0.5700
                2014-07-29    0.5713
                2014-07-30    0.5988
                2014-07-31    0.5593


                np.array

                input:
                array([[ 223.57 ,  226.5  ,   15.32 , ...,  589.02 ,   21.349,   97.67 ],
               [ 224.82 ,  225.8  ,   16.13 , ...,  590.6  ,   21.548,   99.02 ],
               [ 225.01 ,  220.   ,   16.75 , ...,  585.61 ,   21.19 ,   98.38 ],
               ...,
               [ 222.27 ,  160.88 ,   25.5  , ...,  742.74 ,   13.51 ,   98.66 ],
               [ 230.01 ,  160.25 ,   25.57 , ...,  739.77 ,   13.39 ,   97.34 ],
               [ 225.93 ,  163.09 ,   24.75 , ...,  740.92 ,   13.655,   97.76 ]])

               output:

                array([[ 0.2838,  0.2876,  0.0141, ...,  0.7571,  0.0219,  0.1207],
                       [ 0.2854,  0.2867,  0.0151, ...,  0.7591,  0.0222,  0.1225],
                       [ 0.2857,  0.2792,  0.0159, ...,  0.7527,  0.0217,  0.1217],
                       ...,
                       [ 0.2821,  0.2026,  0.0273, ...,  0.9561,  0.0117,  0.122 ],
                       [ 0.2921,  0.2018,  0.0274, ...,  0.9523,  0.0116,  0.1203],
                       [ 0.2868,  0.2055,  0.0263, ...,  0.9538,  0.0119,  0.1209]])

    :param group: pd.DataFrame对象, pd.Series对象, np.array对象
    """
    return (group - group.min()) / (group.max() - group.min())
