# coding: utf-8

"""
    RIME Rest API

    API methods for RIME. Must be authenticated with `rime-api-key` header.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class FeatureFlagApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def feature_flag_get_enabled_feature(self, customer_name, feature, **kwargs):  # noqa: E501
        """GetEnabledFeature  # noqa: E501

        Returns whether a feature is enabled in license for a customer.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_flag_get_enabled_feature(customer_name, feature, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_name: (required)
        :param str feature: (required)
        :return: RimeGetEnabledFeatureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_flag_get_enabled_feature_with_http_info(customer_name, feature, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_flag_get_enabled_feature_with_http_info(customer_name, feature, **kwargs)  # noqa: E501
            return data

    def feature_flag_get_enabled_feature_with_http_info(self, customer_name, feature, **kwargs):  # noqa: E501
        """GetEnabledFeature  # noqa: E501

        Returns whether a feature is enabled in license for a customer.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_flag_get_enabled_feature_with_http_info(customer_name, feature, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_name: (required)
        :param str feature: (required)
        :return: RimeGetEnabledFeatureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_name', 'feature']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_flag_get_enabled_feature" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_name' is set
        if ('customer_name' not in params or
                params['customer_name'] is None):
            raise ValueError("Missing the required parameter `customer_name` when calling `feature_flag_get_enabled_feature`")  # noqa: E501
        # verify the required parameter 'feature' is set
        if ('feature' not in params or
                params['feature'] is None):
            raise ValueError("Missing the required parameter `feature` when calling `feature_flag_get_enabled_feature`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_name' in params:
            path_params['customerName'] = params['customer_name']  # noqa: E501
        if 'feature' in params:
            path_params['feature'] = params['feature']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/feature-flags/{customerName}/features/{feature}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetEnabledFeatureResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feature_flag_get_feature_flag(self, customer_name, **kwargs):  # noqa: E501
        """GetFeatureFlag  # noqa: E501

        Returns feature message with customer name This endpoint is deprecated, use `ListEnabledFeatures` or `GetLimitStatusRequest` instead.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_flag_get_feature_flag(customer_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_name: (required)
        :return: RimeGetFeatureFlagsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_flag_get_feature_flag_with_http_info(customer_name, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_flag_get_feature_flag_with_http_info(customer_name, **kwargs)  # noqa: E501
            return data

    def feature_flag_get_feature_flag_with_http_info(self, customer_name, **kwargs):  # noqa: E501
        """GetFeatureFlag  # noqa: E501

        Returns feature message with customer name This endpoint is deprecated, use `ListEnabledFeatures` or `GetLimitStatusRequest` instead.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_flag_get_feature_flag_with_http_info(customer_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_name: (required)
        :return: RimeGetFeatureFlagsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_flag_get_feature_flag" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_name' is set
        if ('customer_name' not in params or
                params['customer_name'] is None):
            raise ValueError("Missing the required parameter `customer_name` when calling `feature_flag_get_feature_flag`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_name' in params:
            path_params['customerName'] = params['customer_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/feature-flags/{customerName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetFeatureFlagsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feature_flag_get_limit_status(self, customer_name, limit, **kwargs):  # noqa: E501
        """GetLimitStatus  # noqa: E501

        Returns a license limit status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_flag_get_limit_status(customer_name, limit, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_name: (required)
        :param str limit: (required)
        :return: RimeGetLimitStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_flag_get_limit_status_with_http_info(customer_name, limit, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_flag_get_limit_status_with_http_info(customer_name, limit, **kwargs)  # noqa: E501
            return data

    def feature_flag_get_limit_status_with_http_info(self, customer_name, limit, **kwargs):  # noqa: E501
        """GetLimitStatus  # noqa: E501

        Returns a license limit status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_flag_get_limit_status_with_http_info(customer_name, limit, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_name: (required)
        :param str limit: (required)
        :return: RimeGetLimitStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_name', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_flag_get_limit_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_name' is set
        if ('customer_name' not in params or
                params['customer_name'] is None):
            raise ValueError("Missing the required parameter `customer_name` when calling `feature_flag_get_limit_status`")  # noqa: E501
        # verify the required parameter 'limit' is set
        if ('limit' not in params or
                params['limit'] is None):
            raise ValueError("Missing the required parameter `limit` when calling `feature_flag_get_limit_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_name' in params:
            path_params['customerName'] = params['customer_name']  # noqa: E501
        if 'limit' in params:
            path_params['limit'] = params['limit']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/feature-flags/{customerName}/limits/{limit}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetLimitStatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def feature_flag_list_enabled_features(self, customer_name, **kwargs):  # noqa: E501
        """ListEnabledFeatures  # noqa: E501

        Returns all features enabled in license for a customer.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_flag_list_enabled_features(customer_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_name: (required)
        :return: RimeListEnabledFeatureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.feature_flag_list_enabled_features_with_http_info(customer_name, **kwargs)  # noqa: E501
        else:
            (data) = self.feature_flag_list_enabled_features_with_http_info(customer_name, **kwargs)  # noqa: E501
            return data

    def feature_flag_list_enabled_features_with_http_info(self, customer_name, **kwargs):  # noqa: E501
        """ListEnabledFeatures  # noqa: E501

        Returns all features enabled in license for a customer.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.feature_flag_list_enabled_features_with_http_info(customer_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_name: (required)
        :return: RimeListEnabledFeatureResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method feature_flag_list_enabled_features" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_name' is set
        if ('customer_name' not in params or
                params['customer_name'] is None):
            raise ValueError("Missing the required parameter `customer_name` when calling `feature_flag_list_enabled_features`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_name' in params:
            path_params['customerName'] = params['customer_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/feature-flags/{customerName}/features', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListEnabledFeatureResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
