import { IResource } from '@aws-cdk/core';
/**
 * Represents an EventBridge Rule.
 *
 * @stability stable
 */
export interface IRule extends IResource {
    /**
     * The value of the event rule Amazon Resource Name (ARN), such as arn:aws:events:us-east-2:123456789012:rule/example.
     *
     * @stability stable
     * @attribute true
     */
    readonly ruleArn: string;
    /**
     * The name event rule.
     *
     * @stability stable
     * @attribute true
     */
    readonly ruleName: string;
}
