from setuptools import setup, find_packages

v = '0.1.1'

setup(
    name='sso-analysis-worker',
    version=v,
    packages=find_packages(),
    description="SSO Analysis Worker for brain",
    url="https://sso-scanner-mgmt.it.hs-heilbronn.de/",
    author="Maximilian Westers",
    author_email="maximilian.westers@hs-heilbronn.de",
    install_requires=[
        "psycopg~=3.0.8",
        "requests~=2.27.1",
        "selenium~=4.1.0",
        "selenium_stealth~=1.0.6",
        "webdriver_manager~=3.5.2",
        "selenium-wire~=4.6.0",
        "pyvirtualdisplay~=3.0",
        "tldextract~=3.2.0",
        "urllib3~=1.26",
    ],
    scripts=["scripts/sso-daemon"]
)

with open("version.txt", 'w') as f:
    f.write(v)
    f.write("\n# This file was autogenerated by setup.cfg")
