"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Stack = exports.StackProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ros_generated_1 = require("./ros.generated");
Object.defineProperty(exports, "StackProperty", { enumerable: true, get: function () { return ros_generated_1.RosStack; } });
/**
 * A ROS resource type:  `ALIYUN::ROS::Stack`
 */
class Stack extends ros.Resource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the properties of this ROS resource, which will be assigned to ROS resource.
     */
    /**
     * Create a new `ALIYUN::ROS::Stack`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosStack = new ros_generated_1.RosStack(this, id, {
            templateUrl: props.templateUrl,
            parameters: props.parameters,
            resourceGroupId: props.resourceGroupId,
            timeoutMins: props.timeoutMins === undefined || props.timeoutMins === null ? 60 : props.timeoutMins,
            templateVersion: props.templateVersion,
            templateBody: props.templateBody,
            templateId: props.templateId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosStack;
    }
}
exports.Stack = Stack;
//# sourceMappingURL=data:application/json;base64,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