"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TargetType = exports.SslPolicy = exports.ApplicationProtocol = exports.Protocol = exports.IpAddressType = void 0;
/**
 * What kind of addresses to allocate to the load balancer
 */
var IpAddressType;
(function (IpAddressType) {
    /**
     * Allocate IPv4 addresses
     */
    IpAddressType["IPV4"] = "ipv4";
    /**
     * Allocate both IPv4 and IPv6 addresses
     */
    IpAddressType["DUAL_STACK"] = "dualstack";
})(IpAddressType = exports.IpAddressType || (exports.IpAddressType = {}));
/**
 * Backend protocol for network load balancers and health checks
 */
var Protocol;
(function (Protocol) {
    /**
     * HTTP (ALB health checks and NLB health checks)
     */
    Protocol["HTTP"] = "HTTP";
    /**
     * HTTPS (ALB health checks and NLB health checks)
     */
    Protocol["HTTPS"] = "HTTPS";
    /**
     * TCP (NLB, NLB health checks)
     */
    Protocol["TCP"] = "TCP";
    /**
     * TLS (NLB)
     */
    Protocol["TLS"] = "TLS";
    /**
     * UDP (NLB)
     */
    Protocol["UDP"] = "UDP";
    /**
     * Listen to both TCP and UDP on the same port (NLB)
     */
    Protocol["TCP_UDP"] = "TCP_UDP";
})(Protocol = exports.Protocol || (exports.Protocol = {}));
/**
 * Load balancing protocol for application load balancers
 */
var ApplicationProtocol;
(function (ApplicationProtocol) {
    /**
     * HTTP
     */
    ApplicationProtocol["HTTP"] = "HTTP";
    /**
     * HTTPS
     */
    ApplicationProtocol["HTTPS"] = "HTTPS";
})(ApplicationProtocol = exports.ApplicationProtocol || (exports.ApplicationProtocol = {}));
/**
 * Elastic Load Balancing provides the following security policies for Application Load Balancers
 *
 * We recommend the Recommended policy for general use. You can
 * use the ForwardSecrecy policy if you require Forward Secrecy
 * (FS).
 *
 * You can use one of the TLS policies to meet compliance and security
 * standards that require disabling certain TLS protocol versions, or to
 * support legacy clients that require deprecated ciphers.
 *
 * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html
 */
var SslPolicy;
(function (SslPolicy) {
    /**
     * The recommended security policy
     */
    SslPolicy["RECOMMENDED"] = "ELBSecurityPolicy-2016-08";
    /**
     * Strong forward secrecy ciphers and TLS1.2 only
     */
    SslPolicy["FORWARD_SECRECY_TLS12_RES"] = "ELBSecurityPolicy-FS-1-2-Res-2019-08";
    /**
     * Forward secrecy ciphers and TLS1.2 only
     */
    SslPolicy["FORWARD_SECRECY_TLS12"] = "ELBSecurityPolicy-FS-1-2-2019-08";
    /**
     * Forward secrecy ciphers only with TLS1.1 and higher
     */
    SslPolicy["FORWARD_SECRECY_TLS11"] = "ELBSecurityPolicy-FS-1-1-2019-08";
    /**
     * Forward secrecy ciphers only
     */
    SslPolicy["FORWARD_SECRECY"] = "ELBSecurityPolicy-FS-2018-06";
    /**
     * TLS1.2 only and no SHA ciphers
     */
    SslPolicy["TLS12"] = "ELBSecurityPolicy-TLS-1-2-2017-01";
    /**
     * TLS1.2 only with all ciphers
     */
    SslPolicy["TLS12_EXT"] = "ELBSecurityPolicy-TLS-1-2-Ext-2018-06";
    /**
     * TLS1.1 and higher with all ciphers
     */
    SslPolicy["TLS11"] = "ELBSecurityPolicy-TLS-1-1-2017-01";
    /**
     * Support for DES-CBC3-SHA
     *
     * Do not use this security policy unless you must support a legacy client
     * that requires the DES-CBC3-SHA cipher, which is a weak cipher.
     */
    SslPolicy["LEGACY"] = "ELBSecurityPolicy-TLS-1-0-2015-04";
})(SslPolicy = exports.SslPolicy || (exports.SslPolicy = {}));
/**
 * How to interpret the load balancing target identifiers
 */
var TargetType;
(function (TargetType) {
    /**
     * Targets identified by instance ID
     */
    TargetType["INSTANCE"] = "instance";
    /**
     * Targets identified by IP address
     */
    TargetType["IP"] = "ip";
    /**
     * Target is a single Lambda Function
     */
    TargetType["LAMBDA"] = "lambda";
})(TargetType = exports.TargetType || (exports.TargetType = {}));
//# sourceMappingURL=data:application/json;base64,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