# coding: utf-8

"""
    HubDB endpoints

    HubDB is a relational data store that presents data as rows, columns, and cells in a table, much like a spreadsheet. HubDB tables can be added or modified [in the HubSpot CMS](https://knowledge.hubspot.com/cos-general/how-to-edit-hubdb-tables), but you can also use the API endpoints documented here. For more information on HubDB tables and using their data on a HubSpot site, see the [CMS developers site](https://designers.hubspot.com/docs/tools/hubdb). You can also see the [documentation for dynamic pages](https://designers.hubspot.com/docs/tutorials/how-to-build-dynamic-pages-with-hubdb) for more details about the `useForPages` field.  HubDB tables support `draft` and `live` versions and you can publish and unpublish the live version. This allows you to update data in the table, either for testing or to allow for a manual approval process, without affecting any live pages using the existing data. Draft data can be reviewed, pushed to live version, and published by a user working in HubSpot or published via the API. Draft data can also be discarded, allowing users to go back to the live version of the data without disrupting it. If a table is set to be `allowed for public access`, you can access the published version of the table and rows without any authentication.  # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from hubspot.cms.hubdb.api_client import ApiClient
from hubspot.cms.hubdb.exceptions import ApiTypeError, ApiValueError  # noqa: F401


class TablesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def archive_table(self, table_id_or_name, **kwargs):  # noqa: E501
        """Archive a table  # noqa: E501

        Archive (soft delete) an existing HubDB table. This archives both the live and draft versions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_table(table_id_or_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table to archive. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.archive_table_with_http_info(
            table_id_or_name, **kwargs
        )  # noqa: E501

    def archive_table_with_http_info(self, table_id_or_name, **kwargs):  # noqa: E501
        """Archive a table  # noqa: E501

        Archive (soft delete) an existing HubDB table. This archives both the live and draft versions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_table_with_http_info(table_id_or_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table to archive. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id_or_name"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method archive_table" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id_or_name' is set
        if self.api_client.client_side_validation and (
            "table_id_or_name" not in local_var_params
            or local_var_params["table_id_or_name"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id_or_name` when calling `archive_table`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id_or_name" in local_var_params:
            path_params["tableIdOrName"] = local_var_params[
                "table_id_or_name"
            ]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableIdOrName}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def clone_draft_table(
        self, table_id_or_name, hub_db_table_clone_request, **kwargs
    ):  # noqa: E501
        """Clone a table  # noqa: E501

        Clone an existing HubDB table. The `newName` and `newLabel` of the new table can be sent as JSON in the `body` parameter. This will create the cloned table as a `draft`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clone_draft_table(table_id_or_name, hub_db_table_clone_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table to clone. (required)
        :param HubDbTableCloneRequest hub_db_table_clone_request: JSON object with the properties newName and newLabel. You can set copyRows to false to clone the table with copying rows and default is true. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HubDbTableV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.clone_draft_table_with_http_info(
            table_id_or_name, hub_db_table_clone_request, **kwargs
        )  # noqa: E501

    def clone_draft_table_with_http_info(
        self, table_id_or_name, hub_db_table_clone_request, **kwargs
    ):  # noqa: E501
        """Clone a table  # noqa: E501

        Clone an existing HubDB table. The `newName` and `newLabel` of the new table can be sent as JSON in the `body` parameter. This will create the cloned table as a `draft`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clone_draft_table_with_http_info(table_id_or_name, hub_db_table_clone_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table to clone. (required)
        :param HubDbTableCloneRequest hub_db_table_clone_request: JSON object with the properties newName and newLabel. You can set copyRows to false to clone the table with copying rows and default is true. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HubDbTableV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id_or_name", "hub_db_table_clone_request"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method clone_draft_table" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id_or_name' is set
        if self.api_client.client_side_validation and (
            "table_id_or_name" not in local_var_params
            or local_var_params["table_id_or_name"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id_or_name` when calling `clone_draft_table`"
            )  # noqa: E501
        # verify the required parameter 'hub_db_table_clone_request' is set
        if self.api_client.client_side_validation and (
            "hub_db_table_clone_request" not in local_var_params
            or local_var_params["hub_db_table_clone_request"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `hub_db_table_clone_request` when calling `clone_draft_table`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id_or_name" in local_var_params:
            path_params["tableIdOrName"] = local_var_params[
                "table_id_or_name"
            ]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "hub_db_table_clone_request" in local_var_params:
            body_params = local_var_params["hub_db_table_clone_request"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableIdOrName}/draft/clone",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="HubDbTableV3",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_table(self, hub_db_table_v3_input, **kwargs):  # noqa: E501
        """Create a new table  # noqa: E501

        Creates a new draft HubDB table given a JSON schema. The table name and label should be unique for each account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_table(hub_db_table_v3_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param HubDbTableV3Input hub_db_table_v3_input: The JSON schema for the table being created. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HubDbTableV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.create_table_with_http_info(
            hub_db_table_v3_input, **kwargs
        )  # noqa: E501

    def create_table_with_http_info(
        self, hub_db_table_v3_input, **kwargs
    ):  # noqa: E501
        """Create a new table  # noqa: E501

        Creates a new draft HubDB table given a JSON schema. The table name and label should be unique for each account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_table_with_http_info(hub_db_table_v3_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param HubDbTableV3Input hub_db_table_v3_input: The JSON schema for the table being created. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HubDbTableV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["hub_db_table_v3_input"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_table" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'hub_db_table_v3_input' is set
        if self.api_client.client_side_validation and (
            "hub_db_table_v3_input" not in local_var_params
            or local_var_params["hub_db_table_v3_input"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `hub_db_table_v3_input` when calling `create_table`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "hub_db_table_v3_input" in local_var_params:
            body_params = local_var_params["hub_db_table_v3_input"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="HubDbTableV3",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def export_draft_table(self, table_id_or_name, **kwargs):  # noqa: E501
        """Export a draft table  # noqa: E501

        Exports the `draft` version of a table to CSV / EXCEL format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_draft_table(table_id_or_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table to export. (required)
        :param str format: The file format to export. Possible values include `CSV`, `XLSX`, and `XLS`.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.export_draft_table_with_http_info(
            table_id_or_name, **kwargs
        )  # noqa: E501

    def export_draft_table_with_http_info(
        self, table_id_or_name, **kwargs
    ):  # noqa: E501
        """Export a draft table  # noqa: E501

        Exports the `draft` version of a table to CSV / EXCEL format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_draft_table_with_http_info(table_id_or_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table to export. (required)
        :param str format: The file format to export. Possible values include `CSV`, `XLSX`, and `XLS`.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id_or_name", "format"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_draft_table" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id_or_name' is set
        if self.api_client.client_side_validation and (
            "table_id_or_name" not in local_var_params
            or local_var_params["table_id_or_name"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id_or_name` when calling `export_draft_table`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id_or_name" in local_var_params:
            path_params["tableIdOrName"] = local_var_params[
                "table_id_or_name"
            ]  # noqa: E501

        query_params = []
        if (
            "format" in local_var_params and local_var_params["format"] is not None
        ):  # noqa: E501
            query_params.append(("format", local_var_params["format"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/vnd.ms-excel", "text/csv", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableIdOrName}/draft/export",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="file",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def export_table(self, table_id_or_name, **kwargs):  # noqa: E501
        """Export a published version of a table  # noqa: E501

        Exports the `live` version of a table to CSV / EXCEL format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_table(table_id_or_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table to export. (required)
        :param str format: The file format to export. Possible values include `CSV`, `XLSX`, and `XLS`.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.export_table_with_http_info(
            table_id_or_name, **kwargs
        )  # noqa: E501

    def export_table_with_http_info(self, table_id_or_name, **kwargs):  # noqa: E501
        """Export a published version of a table  # noqa: E501

        Exports the `live` version of a table to CSV / EXCEL format.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_table_with_http_info(table_id_or_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table to export. (required)
        :param str format: The file format to export. Possible values include `CSV`, `XLSX`, and `XLS`.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id_or_name", "format"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_table" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id_or_name' is set
        if self.api_client.client_side_validation and (
            "table_id_or_name" not in local_var_params
            or local_var_params["table_id_or_name"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id_or_name` when calling `export_table`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id_or_name" in local_var_params:
            path_params["tableIdOrName"] = local_var_params[
                "table_id_or_name"
            ]  # noqa: E501

        query_params = []
        if (
            "format" in local_var_params and local_var_params["format"] is not None
        ):  # noqa: E501
            query_params.append(("format", local_var_params["format"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/vnd.ms-excel", "text/csv", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableIdOrName}/export",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="file",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_all_draft_tables(self, **kwargs):  # noqa: E501
        """Return all draft tables  # noqa: E501

        Returns the details for each draft table defined in the specified account, including column definitions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_draft_tables(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param datetime updated_after: Only return tables last updated after the specified time.
        :param datetime updated_before: Only return tables last updated before the specified time.
        :param list[str] sort: Specifies which fields to use for sorting results. Valid fields are `name`, `createdAt`, `updatedAt`, `createdBy`, `updatedBy`. `createdAt` will be used by default.
        :param datetime created_at: Only return tables created at exactly the specified time.
        :param datetime created_after: Only return tables created after the specified time.
        :param str after: The cursor token value to get the next set of results. You can get this from the `paging.next.after` JSON property of a paged response containing more results.
        :param bool archived: Specifies whether to return archived tables. Defaults to `false`.
        :param datetime created_before: Only return tables created before the specified time.
        :param datetime updated_at: Only return tables last updated at exactly the specified time.
        :param int limit: The maximum number of results to return. Default is 1000.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CollectionResponseWithTotalHubDbTableV3ForwardPaging
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_all_draft_tables_with_http_info(**kwargs)  # noqa: E501

    def get_all_draft_tables_with_http_info(self, **kwargs):  # noqa: E501
        """Return all draft tables  # noqa: E501

        Returns the details for each draft table defined in the specified account, including column definitions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_draft_tables_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param datetime updated_after: Only return tables last updated after the specified time.
        :param datetime updated_before: Only return tables last updated before the specified time.
        :param list[str] sort: Specifies which fields to use for sorting results. Valid fields are `name`, `createdAt`, `updatedAt`, `createdBy`, `updatedBy`. `createdAt` will be used by default.
        :param datetime created_at: Only return tables created at exactly the specified time.
        :param datetime created_after: Only return tables created after the specified time.
        :param str after: The cursor token value to get the next set of results. You can get this from the `paging.next.after` JSON property of a paged response containing more results.
        :param bool archived: Specifies whether to return archived tables. Defaults to `false`.
        :param datetime created_before: Only return tables created before the specified time.
        :param datetime updated_at: Only return tables last updated at exactly the specified time.
        :param int limit: The maximum number of results to return. Default is 1000.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CollectionResponseWithTotalHubDbTableV3ForwardPaging, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            "updated_after",
            "updated_before",
            "sort",
            "created_at",
            "created_after",
            "after",
            "archived",
            "created_before",
            "updated_at",
            "limit",
        ]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_draft_tables" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []
        if (
            "updated_after" in local_var_params
            and local_var_params["updated_after"] is not None
        ):  # noqa: E501
            query_params.append(
                ("updatedAfter", local_var_params["updated_after"])
            )  # noqa: E501
        if (
            "updated_before" in local_var_params
            and local_var_params["updated_before"] is not None
        ):  # noqa: E501
            query_params.append(
                ("updatedBefore", local_var_params["updated_before"])
            )  # noqa: E501
        if (
            "sort" in local_var_params and local_var_params["sort"] is not None
        ):  # noqa: E501
            query_params.append(("sort", local_var_params["sort"]))  # noqa: E501
            collection_formats["sort"] = "multi"  # noqa: E501
        if (
            "created_at" in local_var_params
            and local_var_params["created_at"] is not None
        ):  # noqa: E501
            query_params.append(
                ("createdAt", local_var_params["created_at"])
            )  # noqa: E501
        if (
            "created_after" in local_var_params
            and local_var_params["created_after"] is not None
        ):  # noqa: E501
            query_params.append(
                ("createdAfter", local_var_params["created_after"])
            )  # noqa: E501
        if (
            "after" in local_var_params and local_var_params["after"] is not None
        ):  # noqa: E501
            query_params.append(("after", local_var_params["after"]))  # noqa: E501
        if (
            "archived" in local_var_params and local_var_params["archived"] is not None
        ):  # noqa: E501
            query_params.append(
                ("archived", local_var_params["archived"])
            )  # noqa: E501
        if (
            "created_before" in local_var_params
            and local_var_params["created_before"] is not None
        ):  # noqa: E501
            query_params.append(
                ("createdBefore", local_var_params["created_before"])
            )  # noqa: E501
        if (
            "updated_at" in local_var_params
            and local_var_params["updated_at"] is not None
        ):  # noqa: E501
            query_params.append(
                ("updatedAt", local_var_params["updated_at"])
            )  # noqa: E501
        if (
            "limit" in local_var_params and local_var_params["limit"] is not None
        ):  # noqa: E501
            query_params.append(("limit", local_var_params["limit"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/draft",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="CollectionResponseWithTotalHubDbTableV3ForwardPaging",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_all_tables(self, **kwargs):  # noqa: E501
        """Get all live tables  # noqa: E501

        Returns the details for the `live` version of each table defined in an account, including column definitions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_tables(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param datetime updated_after: Only return tables last updated after the specified time.
        :param datetime updated_before: Only return tables last updated before the specified time.
        :param list[str] sort: Specifies which fields to use for sorting results. Valid fields are `name`, `createdAt`, `updatedAt`, `createdBy`, `updatedBy`. `createdAt` will be used by default.
        :param datetime created_at: Only return tables created at exactly the specified time.
        :param datetime created_after: Only return tables created after the specified time.
        :param str after: The cursor token value to get the next set of results. You can get this from the `paging.next.after` JSON property of a paged response containing more results.
        :param bool archived: Specifies whether to return archived tables. Defaults to `false`.
        :param datetime created_before: Only return tables created before the specified time.
        :param datetime updated_at: Only return tables last updated at exactly the specified time.
        :param int limit: The maximum number of results to return. Default is 1000.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CollectionResponseWithTotalHubDbTableV3ForwardPaging
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_all_tables_with_http_info(**kwargs)  # noqa: E501

    def get_all_tables_with_http_info(self, **kwargs):  # noqa: E501
        """Get all live tables  # noqa: E501

        Returns the details for the `live` version of each table defined in an account, including column definitions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_tables_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param datetime updated_after: Only return tables last updated after the specified time.
        :param datetime updated_before: Only return tables last updated before the specified time.
        :param list[str] sort: Specifies which fields to use for sorting results. Valid fields are `name`, `createdAt`, `updatedAt`, `createdBy`, `updatedBy`. `createdAt` will be used by default.
        :param datetime created_at: Only return tables created at exactly the specified time.
        :param datetime created_after: Only return tables created after the specified time.
        :param str after: The cursor token value to get the next set of results. You can get this from the `paging.next.after` JSON property of a paged response containing more results.
        :param bool archived: Specifies whether to return archived tables. Defaults to `false`.
        :param datetime created_before: Only return tables created before the specified time.
        :param datetime updated_at: Only return tables last updated at exactly the specified time.
        :param int limit: The maximum number of results to return. Default is 1000.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CollectionResponseWithTotalHubDbTableV3ForwardPaging, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            "updated_after",
            "updated_before",
            "sort",
            "created_at",
            "created_after",
            "after",
            "archived",
            "created_before",
            "updated_at",
            "limit",
        ]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_tables" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []
        if (
            "updated_after" in local_var_params
            and local_var_params["updated_after"] is not None
        ):  # noqa: E501
            query_params.append(
                ("updatedAfter", local_var_params["updated_after"])
            )  # noqa: E501
        if (
            "updated_before" in local_var_params
            and local_var_params["updated_before"] is not None
        ):  # noqa: E501
            query_params.append(
                ("updatedBefore", local_var_params["updated_before"])
            )  # noqa: E501
        if (
            "sort" in local_var_params and local_var_params["sort"] is not None
        ):  # noqa: E501
            query_params.append(("sort", local_var_params["sort"]))  # noqa: E501
            collection_formats["sort"] = "multi"  # noqa: E501
        if (
            "created_at" in local_var_params
            and local_var_params["created_at"] is not None
        ):  # noqa: E501
            query_params.append(
                ("createdAt", local_var_params["created_at"])
            )  # noqa: E501
        if (
            "created_after" in local_var_params
            and local_var_params["created_after"] is not None
        ):  # noqa: E501
            query_params.append(
                ("createdAfter", local_var_params["created_after"])
            )  # noqa: E501
        if (
            "after" in local_var_params and local_var_params["after"] is not None
        ):  # noqa: E501
            query_params.append(("after", local_var_params["after"]))  # noqa: E501
        if (
            "archived" in local_var_params and local_var_params["archived"] is not None
        ):  # noqa: E501
            query_params.append(
                ("archived", local_var_params["archived"])
            )  # noqa: E501
        if (
            "created_before" in local_var_params
            and local_var_params["created_before"] is not None
        ):  # noqa: E501
            query_params.append(
                ("createdBefore", local_var_params["created_before"])
            )  # noqa: E501
        if (
            "updated_at" in local_var_params
            and local_var_params["updated_at"] is not None
        ):  # noqa: E501
            query_params.append(
                ("updatedAt", local_var_params["updated_at"])
            )  # noqa: E501
        if (
            "limit" in local_var_params and local_var_params["limit"] is not None
        ):  # noqa: E501
            query_params.append(("limit", local_var_params["limit"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="CollectionResponseWithTotalHubDbTableV3ForwardPaging",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_draft_table_details_by_id(self, table_id_or_name, **kwargs):  # noqa: E501
        """Get details for a draft table  # noqa: E501

        Get the details for the `draft` version of a specific HubDB table. This will include the definitions for the columns in the table and the number of rows in the table.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_draft_table_details_by_id(table_id_or_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table to return. (required)
        :param bool archived: Set this to `true` to return an archived table. Defaults to `false`.
        :param bool include_foreign_ids: Set this to `true` to populate foreign ID values in the result.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HubDbTableV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_draft_table_details_by_id_with_http_info(
            table_id_or_name, **kwargs
        )  # noqa: E501

    def get_draft_table_details_by_id_with_http_info(
        self, table_id_or_name, **kwargs
    ):  # noqa: E501
        """Get details for a draft table  # noqa: E501

        Get the details for the `draft` version of a specific HubDB table. This will include the definitions for the columns in the table and the number of rows in the table.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_draft_table_details_by_id_with_http_info(table_id_or_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table to return. (required)
        :param bool archived: Set this to `true` to return an archived table. Defaults to `false`.
        :param bool include_foreign_ids: Set this to `true` to populate foreign ID values in the result.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HubDbTableV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id_or_name", "archived", "include_foreign_ids"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_draft_table_details_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id_or_name' is set
        if self.api_client.client_side_validation and (
            "table_id_or_name" not in local_var_params
            or local_var_params["table_id_or_name"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id_or_name` when calling `get_draft_table_details_by_id`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id_or_name" in local_var_params:
            path_params["tableIdOrName"] = local_var_params[
                "table_id_or_name"
            ]  # noqa: E501

        query_params = []
        if (
            "archived" in local_var_params and local_var_params["archived"] is not None
        ):  # noqa: E501
            query_params.append(
                ("archived", local_var_params["archived"])
            )  # noqa: E501
        if (
            "include_foreign_ids" in local_var_params
            and local_var_params["include_foreign_ids"] is not None
        ):  # noqa: E501
            query_params.append(
                ("includeForeignIds", local_var_params["include_foreign_ids"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableIdOrName}/draft",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="HubDbTableV3",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_table_details(self, table_id_or_name, **kwargs):  # noqa: E501
        """Get details for a live table  # noqa: E501

        Returns the details for the `live` version of the specified table. This will include the definitions for the columns in the table and the number of rows in the table. **Note:** This endpoint can be accessed without any authentication if the table is set to be allowed for public access.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_table_details(table_id_or_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table to return. (required)
        :param bool archived: Set this to `true` to return details for an archived table. Defaults to `false`.
        :param bool include_foreign_ids: Set this to `true` to populate foreign ID values in the result.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HubDbTableV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_table_details_with_http_info(
            table_id_or_name, **kwargs
        )  # noqa: E501

    def get_table_details_with_http_info(
        self, table_id_or_name, **kwargs
    ):  # noqa: E501
        """Get details for a live table  # noqa: E501

        Returns the details for the `live` version of the specified table. This will include the definitions for the columns in the table and the number of rows in the table. **Note:** This endpoint can be accessed without any authentication if the table is set to be allowed for public access.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_table_details_with_http_info(table_id_or_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table to return. (required)
        :param bool archived: Set this to `true` to return details for an archived table. Defaults to `false`.
        :param bool include_foreign_ids: Set this to `true` to populate foreign ID values in the result.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HubDbTableV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id_or_name", "archived", "include_foreign_ids"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_table_details" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id_or_name' is set
        if self.api_client.client_side_validation and (
            "table_id_or_name" not in local_var_params
            or local_var_params["table_id_or_name"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id_or_name` when calling `get_table_details`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id_or_name" in local_var_params:
            path_params["tableIdOrName"] = local_var_params[
                "table_id_or_name"
            ]  # noqa: E501

        query_params = []
        if (
            "archived" in local_var_params and local_var_params["archived"] is not None
        ):  # noqa: E501
            query_params.append(
                ("archived", local_var_params["archived"])
            )  # noqa: E501
        if (
            "include_foreign_ids" in local_var_params
            and local_var_params["include_foreign_ids"] is not None
        ):  # noqa: E501
            query_params.append(
                ("includeForeignIds", local_var_params["include_foreign_ids"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableIdOrName}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="HubDbTableV3",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def import_draft_table(self, table_id_or_name, **kwargs):  # noqa: E501
        """Import data into draft table  # noqa: E501

        Import the contents of a CSV file into an existing HubDB table. The data will always be imported into the `draft` version of the table. Use `/push-live` endpoint to push these changes to `live` version. This endpoint takes a multi-part POST request. The first part will be a set of JSON-formatted options for the import and you can specify this with the name as `config`.  The second part will be the CSV file you want to import and you can specify this with the name as `file`. Refer the overview section to check the details and format of the JSON-formatted options for the import.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_draft_table(table_id_or_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID of the destination table where data will be imported. (required)
        :param file file: The source CSV file to be imported.
        :param str config: Configuration for the import in JSON format as described above.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ImportResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.import_draft_table_with_http_info(
            table_id_or_name, **kwargs
        )  # noqa: E501

    def import_draft_table_with_http_info(
        self, table_id_or_name, **kwargs
    ):  # noqa: E501
        """Import data into draft table  # noqa: E501

        Import the contents of a CSV file into an existing HubDB table. The data will always be imported into the `draft` version of the table. Use `/push-live` endpoint to push these changes to `live` version. This endpoint takes a multi-part POST request. The first part will be a set of JSON-formatted options for the import and you can specify this with the name as `config`.  The second part will be the CSV file you want to import and you can specify this with the name as `file`. Refer the overview section to check the details and format of the JSON-formatted options for the import.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_draft_table_with_http_info(table_id_or_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID of the destination table where data will be imported. (required)
        :param file file: The source CSV file to be imported.
        :param str config: Configuration for the import in JSON format as described above.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ImportResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id_or_name", "file", "config"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_draft_table" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id_or_name' is set
        if self.api_client.client_side_validation and (
            "table_id_or_name" not in local_var_params
            or local_var_params["table_id_or_name"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id_or_name` when calling `import_draft_table`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id_or_name" in local_var_params:
            path_params["tableIdOrName"] = local_var_params[
                "table_id_or_name"
            ]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if "file" in local_var_params:
            local_var_files["file"] = local_var_params["file"]  # noqa: E501
        if "config" in local_var_params:
            form_params.append(("config", local_var_params["config"]))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["multipart/form-data"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableIdOrName}/draft/import",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="ImportResult",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def publish_draft_table(self, table_id_or_name, **kwargs):  # noqa: E501
        """Publish a table from draft  # noqa: E501

        Copies the data from draft to live version of the table and also publishes the live version. This will immediately push the data to the `live` version of the table and publishes the live version, meaning any website pages using data from the table will be updated.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.publish_draft_table(table_id_or_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table to publish. (required)
        :param bool include_foreign_ids: Set this to `true` to populate foreign ID values in the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HubDbTableV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.publish_draft_table_with_http_info(
            table_id_or_name, **kwargs
        )  # noqa: E501

    def publish_draft_table_with_http_info(
        self, table_id_or_name, **kwargs
    ):  # noqa: E501
        """Publish a table from draft  # noqa: E501

        Copies the data from draft to live version of the table and also publishes the live version. This will immediately push the data to the `live` version of the table and publishes the live version, meaning any website pages using data from the table will be updated.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.publish_draft_table_with_http_info(table_id_or_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table to publish. (required)
        :param bool include_foreign_ids: Set this to `true` to populate foreign ID values in the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HubDbTableV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id_or_name", "include_foreign_ids"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method publish_draft_table" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id_or_name' is set
        if self.api_client.client_side_validation and (
            "table_id_or_name" not in local_var_params
            or local_var_params["table_id_or_name"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id_or_name` when calling `publish_draft_table`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id_or_name" in local_var_params:
            path_params["tableIdOrName"] = local_var_params[
                "table_id_or_name"
            ]  # noqa: E501

        query_params = []
        if (
            "include_foreign_ids" in local_var_params
            and local_var_params["include_foreign_ids"] is not None
        ):  # noqa: E501
            query_params.append(
                ("includeForeignIds", local_var_params["include_foreign_ids"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableIdOrName}/draft/push-live",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="HubDbTableV3",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def reset_draft_table(self, table_id_or_name, **kwargs):  # noqa: E501
        """Reset a draft table  # noqa: E501

        Replaces the data in the `draft` version of the table with values from the `live` version. Any unpublished changes in the `draft` will be lost after this call is made.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_draft_table(table_id_or_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table to reset. (required)
        :param bool include_foreign_ids: Set this to `true` to populate foreign ID values in the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HubDbTableV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.reset_draft_table_with_http_info(
            table_id_or_name, **kwargs
        )  # noqa: E501

    def reset_draft_table_with_http_info(
        self, table_id_or_name, **kwargs
    ):  # noqa: E501
        """Reset a draft table  # noqa: E501

        Replaces the data in the `draft` version of the table with values from the `live` version. Any unpublished changes in the `draft` will be lost after this call is made.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_draft_table_with_http_info(table_id_or_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table to reset. (required)
        :param bool include_foreign_ids: Set this to `true` to populate foreign ID values in the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HubDbTableV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["table_id_or_name", "include_foreign_ids"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_draft_table" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id_or_name' is set
        if self.api_client.client_side_validation and (
            "table_id_or_name" not in local_var_params
            or local_var_params["table_id_or_name"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id_or_name` when calling `reset_draft_table`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id_or_name" in local_var_params:
            path_params["tableIdOrName"] = local_var_params[
                "table_id_or_name"
            ]  # noqa: E501

        query_params = []
        if (
            "include_foreign_ids" in local_var_params
            and local_var_params["include_foreign_ids"] is not None
        ):  # noqa: E501
            query_params.append(
                ("includeForeignIds", local_var_params["include_foreign_ids"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableIdOrName}/draft/reset",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="HubDbTableV3",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_draft_table(
        self, table_id_or_name, hub_db_table_v3_input, **kwargs
    ):  # noqa: E501
        """Update an existing table  # noqa: E501

        Update an existing HubDB table. You can use this endpoint to add or remove columns to the table. Tables updated using the endpoint will only modify the `draft` verion of the table. Use `push-live` endpoint to push all the changes to the `live` version. **Note:** You need to include all the columns in the input when you are adding/removing/updating a column. If you do not include an already existing column in the request, it will be deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_draft_table(table_id_or_name, hub_db_table_v3_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table to update. (required)
        :param HubDbTableV3Input hub_db_table_v3_input: The JSON schema for the table being updated. (required)
        :param bool include_foreign_ids: Set this to `true` to populate foreign ID values in the result.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HubDbTableV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.update_draft_table_with_http_info(
            table_id_or_name, hub_db_table_v3_input, **kwargs
        )  # noqa: E501

    def update_draft_table_with_http_info(
        self, table_id_or_name, hub_db_table_v3_input, **kwargs
    ):  # noqa: E501
        """Update an existing table  # noqa: E501

        Update an existing HubDB table. You can use this endpoint to add or remove columns to the table. Tables updated using the endpoint will only modify the `draft` verion of the table. Use `push-live` endpoint to push all the changes to the `live` version. **Note:** You need to include all the columns in the input when you are adding/removing/updating a column. If you do not include an already existing column in the request, it will be deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_draft_table_with_http_info(table_id_or_name, hub_db_table_v3_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table to update. (required)
        :param HubDbTableV3Input hub_db_table_v3_input: The JSON schema for the table being updated. (required)
        :param bool include_foreign_ids: Set this to `true` to populate foreign ID values in the result.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HubDbTableV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            "table_id_or_name",
            "hub_db_table_v3_input",
            "include_foreign_ids",
        ]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_draft_table" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id_or_name' is set
        if self.api_client.client_side_validation and (
            "table_id_or_name" not in local_var_params
            or local_var_params["table_id_or_name"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id_or_name` when calling `update_draft_table`"
            )  # noqa: E501
        # verify the required parameter 'hub_db_table_v3_input' is set
        if self.api_client.client_side_validation and (
            "hub_db_table_v3_input" not in local_var_params
            or local_var_params["hub_db_table_v3_input"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `hub_db_table_v3_input` when calling `update_draft_table`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id_or_name" in local_var_params:
            path_params["tableIdOrName"] = local_var_params[
                "table_id_or_name"
            ]  # noqa: E501

        query_params = []
        if (
            "include_foreign_ids" in local_var_params
            and local_var_params["include_foreign_ids"] is not None
        ):  # noqa: E501
            query_params.append(
                ("includeForeignIds", local_var_params["include_foreign_ids"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "hub_db_table_v3_input" in local_var_params:
            body_params = local_var_params["hub_db_table_v3_input"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableIdOrName}/draft",
            "PATCH",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="HubDbTableV3",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_table(
        self, table_id_or_name, hub_db_table_v3_live_input, **kwargs
    ):  # noqa: E501
        """Publish or unpublish a live version of a table or restore an archived table  # noqa: E501

        Use this endpoint to perform one of the following <ul><li> Publish a live version of a table (without copying table data from draft) </li><li>Un-publish a live version of a table (Leaving the data in the live version)</li><li>Restore an archived table</li></ul>  To publish a table, send `published` property in the JSON object with the value `true`. To unpublish a table, send `published` property in the JSON object with the value `false`.  To restore an archived table, send `archived` property in the JSON object with the value `false` along with the query parameter `archived=true`. When restoring an archived table, if an active table already exists with the same `name` or `label`, you will need to change the name of the archived table when restoring it using the `name` and `label` parameters with a new name and new label. When you restore a table, the table will be restored only in the `draft` version.  Examples:  Publish live version of a table:  ```     {       \"published\": true     } ``` Unpublish live version of a table: ```     {       \"published\": false     } ``` Restore a table: (send `archived=true` in query parameters) ```     {       \"archived\": false     } ``` Restore a table with a new name: (send `archived=true` in query parameters) ```     {       \"label\": \"New Table Name\",       \"name\": \"new_table_name\",       \"archived\": false     } ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_table(table_id_or_name, hub_db_table_v3_live_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table to return. (required)
        :param HubDbTableV3LiveInput hub_db_table_v3_live_input: The JSON object as described. (required)
        :param bool archived: Whether to return only results that have been archived.
        :param bool include_foreign_ids: Set this to `true` to populate foreign ID values in the result.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HubDbTableV3
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.update_table_with_http_info(
            table_id_or_name, hub_db_table_v3_live_input, **kwargs
        )  # noqa: E501

    def update_table_with_http_info(
        self, table_id_or_name, hub_db_table_v3_live_input, **kwargs
    ):  # noqa: E501
        """Publish or unpublish a live version of a table or restore an archived table  # noqa: E501

        Use this endpoint to perform one of the following <ul><li> Publish a live version of a table (without copying table data from draft) </li><li>Un-publish a live version of a table (Leaving the data in the live version)</li><li>Restore an archived table</li></ul>  To publish a table, send `published` property in the JSON object with the value `true`. To unpublish a table, send `published` property in the JSON object with the value `false`.  To restore an archived table, send `archived` property in the JSON object with the value `false` along with the query parameter `archived=true`. When restoring an archived table, if an active table already exists with the same `name` or `label`, you will need to change the name of the archived table when restoring it using the `name` and `label` parameters with a new name and new label. When you restore a table, the table will be restored only in the `draft` version.  Examples:  Publish live version of a table:  ```     {       \"published\": true     } ``` Unpublish live version of a table: ```     {       \"published\": false     } ``` Restore a table: (send `archived=true` in query parameters) ```     {       \"archived\": false     } ``` Restore a table with a new name: (send `archived=true` in query parameters) ```     {       \"label\": \"New Table Name\",       \"name\": \"new_table_name\",       \"archived\": false     } ```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_table_with_http_info(table_id_or_name, hub_db_table_v3_live_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str table_id_or_name: The ID or name of the table to return. (required)
        :param HubDbTableV3LiveInput hub_db_table_v3_live_input: The JSON object as described. (required)
        :param bool archived: Whether to return only results that have been archived.
        :param bool include_foreign_ids: Set this to `true` to populate foreign ID values in the result.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HubDbTableV3, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            "table_id_or_name",
            "hub_db_table_v3_live_input",
            "archived",
            "include_foreign_ids",
        ]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_table" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'table_id_or_name' is set
        if self.api_client.client_side_validation and (
            "table_id_or_name" not in local_var_params
            or local_var_params["table_id_or_name"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `table_id_or_name` when calling `update_table`"
            )  # noqa: E501
        # verify the required parameter 'hub_db_table_v3_live_input' is set
        if self.api_client.client_side_validation and (
            "hub_db_table_v3_live_input" not in local_var_params
            or local_var_params["hub_db_table_v3_live_input"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `hub_db_table_v3_live_input` when calling `update_table`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "table_id_or_name" in local_var_params:
            path_params["tableIdOrName"] = local_var_params[
                "table_id_or_name"
            ]  # noqa: E501

        query_params = []
        if (
            "archived" in local_var_params and local_var_params["archived"] is not None
        ):  # noqa: E501
            query_params.append(
                ("archived", local_var_params["archived"])
            )  # noqa: E501
        if (
            "include_foreign_ids" in local_var_params
            and local_var_params["include_foreign_ids"] is not None
        ):  # noqa: E501
            query_params.append(
                ("includeForeignIds", local_var_params["include_foreign_ids"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "hub_db_table_v3_live_input" in local_var_params:
            body_params = local_var_params["hub_db_table_v3_live_input"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/cms/v3/hubdb/tables/{tableIdOrName}",
            "PATCH",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="HubDbTableV3",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
