# coding: utf-8

"""
    Accounting Extension

    These APIs allow you to interact with HubSpot's Accounting Extension. It allows you to: * Specify the URLs that HubSpot will use when making webhook requests to your external accounting system. * Respond to webhook calls made to your external accounting system by HubSpot   # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from hubspot.crm.extensions.accounting.configuration import Configuration


class UpdatedContact(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "sync_action": "str",
        "updated_at": "datetime",
        "email_address": "str",
        "id": "str",
        "customer_type": "str",
    }

    attribute_map = {
        "sync_action": "syncAction",
        "updated_at": "updatedAt",
        "email_address": "emailAddress",
        "id": "id",
        "customer_type": "customerType",
    }

    def __init__(
        self,
        sync_action=None,
        updated_at=None,
        email_address=None,
        id=None,
        customer_type=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """UpdatedContact - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._sync_action = None
        self._updated_at = None
        self._email_address = None
        self._id = None
        self._customer_type = None
        self.discriminator = None

        self.sync_action = sync_action
        self.updated_at = updated_at
        self.email_address = email_address
        self.id = id
        if customer_type is not None:
            self.customer_type = customer_type

    @property
    def sync_action(self):
        """Gets the sync_action of this UpdatedContact.  # noqa: E501

        The operation to be performed.  # noqa: E501

        :return: The sync_action of this UpdatedContact.  # noqa: E501
        :rtype: str
        """
        return self._sync_action

    @sync_action.setter
    def sync_action(self, sync_action):
        """Sets the sync_action of this UpdatedContact.

        The operation to be performed.  # noqa: E501

        :param sync_action: The sync_action of this UpdatedContact.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and sync_action is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `sync_action`, must not be `None`"
            )  # noqa: E501
        allowed_values = ["CREATE", "UPDATE", "DELETE"]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and sync_action not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `sync_action` ({0}), must be one of {1}".format(  # noqa: E501
                    sync_action, allowed_values
                )
            )

        self._sync_action = sync_action

    @property
    def updated_at(self):
        """Gets the updated_at of this UpdatedContact.  # noqa: E501

        The timestamp (ISO8601 format) when the customer was updated in the external accounting system.  # noqa: E501

        :return: The updated_at of this UpdatedContact.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this UpdatedContact.

        The timestamp (ISO8601 format) when the customer was updated in the external accounting system.  # noqa: E501

        :param updated_at: The updated_at of this UpdatedContact.  # noqa: E501
        :type: datetime
        """
        if (
            self.local_vars_configuration.client_side_validation and updated_at is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `updated_at`, must not be `None`"
            )  # noqa: E501

        self._updated_at = updated_at

    @property
    def email_address(self):
        """Gets the email_address of this UpdatedContact.  # noqa: E501

        The customer's email address  # noqa: E501

        :return: The email_address of this UpdatedContact.  # noqa: E501
        :rtype: str
        """
        return self._email_address

    @email_address.setter
    def email_address(self, email_address):
        """Sets the email_address of this UpdatedContact.

        The customer's email address  # noqa: E501

        :param email_address: The email_address of this UpdatedContact.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and email_address is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `email_address`, must not be `None`"
            )  # noqa: E501

        self._email_address = email_address

    @property
    def id(self):
        """Gets the id of this UpdatedContact.  # noqa: E501

        The ID of the customer in the external accounting system.  # noqa: E501

        :return: The id of this UpdatedContact.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this UpdatedContact.

        The ID of the customer in the external accounting system.  # noqa: E501

        :param id: The id of this UpdatedContact.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and id is None
        ):  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def customer_type(self):
        """Gets the customer_type of this UpdatedContact.  # noqa: E501

        Designates the type of the customer object.  # noqa: E501

        :return: The customer_type of this UpdatedContact.  # noqa: E501
        :rtype: str
        """
        return self._customer_type

    @customer_type.setter
    def customer_type(self, customer_type):
        """Sets the customer_type of this UpdatedContact.

        Designates the type of the customer object.  # noqa: E501

        :param customer_type: The customer_type of this UpdatedContact.  # noqa: E501
        :type: str
        """
        allowed_values = ["CONTACT", "COMPANY"]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and customer_type not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `customer_type` ({0}), must be one of {1}".format(  # noqa: E501
                    customer_type, allowed_values
                )
            )

        self._customer_type = customer_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UpdatedContact):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UpdatedContact):
            return True

        return self.to_dict() != other.to_dict()
