# coding: utf-8

"""
    Files

    Upload and manage files.  # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from hubspot.files.files.api_client import ApiClient
from hubspot.files.files.exceptions import ApiTypeError, ApiValueError  # noqa: F401


class FilesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def archive(self, file_id, **kwargs):  # noqa: E501
        """Delete file  # noqa: E501

        Delete file by ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive(file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str file_id: File ID to delete (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.archive_with_http_info(file_id, **kwargs)  # noqa: E501

    def archive_with_http_info(self, file_id, **kwargs):  # noqa: E501
        """Delete file  # noqa: E501

        Delete file by ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_with_http_info(file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str file_id: File ID to delete (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["file_id"]
        all_params.extend(["async_req", "_return_http_data_only", "_preload_content", "_request_timeout"])

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method archive" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and ("file_id" not in local_var_params or local_var_params["file_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_id` when calling `archive`")  # noqa: E501

        if self.api_client.client_side_validation and "file_id" in local_var_params and not re.search(r"\d+", local_var_params["file_id"]):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `file_id` when calling `archive`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if "file_id" in local_var_params:
            path_params["fileId"] = local_var_params["file_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["*/*"])  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/files/v3/files/{fileId}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def archive_gdpr(self, file_id, **kwargs):  # noqa: E501
        """GDPR delete  # noqa: E501

        GDRP delete file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_gdpr(file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str file_id: ID of file to GDPR delete (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.archive_gdpr_with_http_info(file_id, **kwargs)  # noqa: E501

    def archive_gdpr_with_http_info(self, file_id, **kwargs):  # noqa: E501
        """GDPR delete  # noqa: E501

        GDRP delete file  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_gdpr_with_http_info(file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str file_id: ID of file to GDPR delete (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["file_id"]
        all_params.extend(["async_req", "_return_http_data_only", "_preload_content", "_request_timeout"])

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method archive_gdpr" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and ("file_id" not in local_var_params or local_var_params["file_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_id` when calling `archive_gdpr`")  # noqa: E501

        if self.api_client.client_side_validation and "file_id" in local_var_params and not re.search(r"\d+", local_var_params["file_id"]):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `file_id` when calling `archive_gdpr`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if "file_id" in local_var_params:
            path_params["fileId"] = local_var_params["file_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["*/*"])  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/files/v3/files/{fileId}/gdpr-delete",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def check_import(self, task_id, **kwargs):  # noqa: E501
        """Check import status.  # noqa: E501

        Check the status of requested import.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.check_import(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Import by URL task ID (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FileActionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.check_import_with_http_info(task_id, **kwargs)  # noqa: E501

    def check_import_with_http_info(self, task_id, **kwargs):  # noqa: E501
        """Check import status.  # noqa: E501

        Check the status of requested import.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.check_import_with_http_info(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Import by URL task ID (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FileActionResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["task_id"]
        all_params.extend(["async_req", "_return_http_data_only", "_preload_content", "_request_timeout"])

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method check_import" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'task_id' is set
        if self.api_client.client_side_validation and ("task_id" not in local_var_params or local_var_params["task_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `task_id` when calling `check_import`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "task_id" in local_var_params:
            path_params["taskId"] = local_var_params["task_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/files/v3/files/import-from-url/async/tasks/{taskId}/status",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="FileActionResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def do_search(self, **kwargs):  # noqa: E501
        """Search files  # noqa: E501

        Search through files in the file manager. Does not display hidden or archived files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.do_search(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] properties: Desired file properties in the return object.
        :param str after: The maximum offset of items for a given search is 10000. Narrow your search down if you are reaching this limit.
        :param str before:
        :param int limit: Number of items to return. Maximum limit is 100.
        :param list[str] sort: Sort files by a given field.
        :param str id: Search files by given ID.
        :param datetime created_at: Search files by time of creation.
        :param datetime updated_at: Search files by time of latest updated.
        :param str name: Search for files containing the given name.
        :param str path: Search files by path.
        :param int parent_folder_id: Search files within given folder ID.
        :param int size: Query by file size.
        :param int height: Search files by height of image or video.
        :param int width: Search files by width of image or video.
        :param str encoding: Search files with specified encoding.
        :param str type: Filter by provided file type.
        :param str extension: Search files by given extension.
        :param str url: Search for given URL
        :param bool is_usable_in_content: If true shows files that have been marked to be used in new content. It false shows files that should not be used in new content.
        :param bool allows_anonymous_access: If 'true' will show private files; if 'false' will show public files
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CollectionResponseFile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.do_search_with_http_info(**kwargs)  # noqa: E501

    def do_search_with_http_info(self, **kwargs):  # noqa: E501
        """Search files  # noqa: E501

        Search through files in the file manager. Does not display hidden or archived files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.do_search_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] properties: Desired file properties in the return object.
        :param str after: The maximum offset of items for a given search is 10000. Narrow your search down if you are reaching this limit.
        :param str before:
        :param int limit: Number of items to return. Maximum limit is 100.
        :param list[str] sort: Sort files by a given field.
        :param str id: Search files by given ID.
        :param datetime created_at: Search files by time of creation.
        :param datetime updated_at: Search files by time of latest updated.
        :param str name: Search for files containing the given name.
        :param str path: Search files by path.
        :param int parent_folder_id: Search files within given folder ID.
        :param int size: Query by file size.
        :param int height: Search files by height of image or video.
        :param int width: Search files by width of image or video.
        :param str encoding: Search files with specified encoding.
        :param str type: Filter by provided file type.
        :param str extension: Search files by given extension.
        :param str url: Search for given URL
        :param bool is_usable_in_content: If true shows files that have been marked to be used in new content. It false shows files that should not be used in new content.
        :param bool allows_anonymous_access: If 'true' will show private files; if 'false' will show public files
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CollectionResponseFile, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            "properties",
            "after",
            "before",
            "limit",
            "sort",
            "id",
            "created_at",
            "updated_at",
            "name",
            "path",
            "parent_folder_id",
            "size",
            "height",
            "width",
            "encoding",
            "type",
            "extension",
            "url",
            "is_usable_in_content",
            "allows_anonymous_access",
        ]
        all_params.extend(["async_req", "_return_http_data_only", "_preload_content", "_request_timeout"])

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method do_search" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []
        if "properties" in local_var_params and local_var_params["properties"] is not None:  # noqa: E501
            query_params.append(("properties", local_var_params["properties"]))  # noqa: E501
            collection_formats["properties"] = "multi"  # noqa: E501
        if "after" in local_var_params and local_var_params["after"] is not None:  # noqa: E501
            query_params.append(("after", local_var_params["after"]))  # noqa: E501
        if "before" in local_var_params and local_var_params["before"] is not None:  # noqa: E501
            query_params.append(("before", local_var_params["before"]))  # noqa: E501
        if "limit" in local_var_params and local_var_params["limit"] is not None:  # noqa: E501
            query_params.append(("limit", local_var_params["limit"]))  # noqa: E501
        if "sort" in local_var_params and local_var_params["sort"] is not None:  # noqa: E501
            query_params.append(("sort", local_var_params["sort"]))  # noqa: E501
            collection_formats["sort"] = "multi"  # noqa: E501
        if "id" in local_var_params and local_var_params["id"] is not None:  # noqa: E501
            query_params.append(("id", local_var_params["id"]))  # noqa: E501
        if "created_at" in local_var_params and local_var_params["created_at"] is not None:  # noqa: E501
            query_params.append(("createdAt", local_var_params["created_at"]))  # noqa: E501
        if "updated_at" in local_var_params and local_var_params["updated_at"] is not None:  # noqa: E501
            query_params.append(("updatedAt", local_var_params["updated_at"]))  # noqa: E501
        if "name" in local_var_params and local_var_params["name"] is not None:  # noqa: E501
            query_params.append(("name", local_var_params["name"]))  # noqa: E501
        if "path" in local_var_params and local_var_params["path"] is not None:  # noqa: E501
            query_params.append(("path", local_var_params["path"]))  # noqa: E501
        if "parent_folder_id" in local_var_params and local_var_params["parent_folder_id"] is not None:  # noqa: E501
            query_params.append(("parentFolderId", local_var_params["parent_folder_id"]))  # noqa: E501
        if "size" in local_var_params and local_var_params["size"] is not None:  # noqa: E501
            query_params.append(("size", local_var_params["size"]))  # noqa: E501
        if "height" in local_var_params and local_var_params["height"] is not None:  # noqa: E501
            query_params.append(("height", local_var_params["height"]))  # noqa: E501
        if "width" in local_var_params and local_var_params["width"] is not None:  # noqa: E501
            query_params.append(("width", local_var_params["width"]))  # noqa: E501
        if "encoding" in local_var_params and local_var_params["encoding"] is not None:  # noqa: E501
            query_params.append(("encoding", local_var_params["encoding"]))  # noqa: E501
        if "type" in local_var_params and local_var_params["type"] is not None:  # noqa: E501
            query_params.append(("type", local_var_params["type"]))  # noqa: E501
        if "extension" in local_var_params and local_var_params["extension"] is not None:  # noqa: E501
            query_params.append(("extension", local_var_params["extension"]))  # noqa: E501
        if "url" in local_var_params and local_var_params["url"] is not None:  # noqa: E501
            query_params.append(("url", local_var_params["url"]))  # noqa: E501
        if "is_usable_in_content" in local_var_params and local_var_params["is_usable_in_content"] is not None:  # noqa: E501
            query_params.append(("isUsableInContent", local_var_params["is_usable_in_content"]))  # noqa: E501
        if "allows_anonymous_access" in local_var_params and local_var_params["allows_anonymous_access"] is not None:  # noqa: E501
            query_params.append(("allowsAnonymousAccess", local_var_params["allows_anonymous_access"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/files/v3/files/search",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="CollectionResponseFile",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_by_id(self, file_id, **kwargs):  # noqa: E501
        """Get file.  # noqa: E501

        Get file by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_id(file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str file_id: Id of the desired file. (required)
        :param list[str] properties:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: File
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_by_id_with_http_info(file_id, **kwargs)  # noqa: E501

    def get_by_id_with_http_info(self, file_id, **kwargs):  # noqa: E501
        """Get file.  # noqa: E501

        Get file by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_id_with_http_info(file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str file_id: Id of the desired file. (required)
        :param list[str] properties:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(File, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["file_id", "properties"]
        all_params.extend(["async_req", "_return_http_data_only", "_preload_content", "_request_timeout"])

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method get_by_id" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and ("file_id" not in local_var_params or local_var_params["file_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_id` when calling `get_by_id`")  # noqa: E501

        if self.api_client.client_side_validation and "file_id" in local_var_params and not re.search(r"\d+", local_var_params["file_id"]):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `file_id` when calling `get_by_id`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if "file_id" in local_var_params:
            path_params["fileId"] = local_var_params["file_id"]  # noqa: E501

        query_params = []
        if "properties" in local_var_params and local_var_params["properties"] is not None:  # noqa: E501
            query_params.append(("properties", local_var_params["properties"]))  # noqa: E501
            collection_formats["properties"] = "multi"  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/files/v3/files/{fileId}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="File",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_signed_url(self, file_id, **kwargs):  # noqa: E501
        """Get signed URL to access private file.  # noqa: E501

        Generates signed URL that allows temporary access to a private file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_signed_url(file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str file_id: ID of file. (required)
        :param str size: For image files. This will resize the image to the desired size before sharing. Does not affect the original file, just the file served by this signed URL.
        :param int expiration_seconds: How long in seconds the link will provide access to the file.
        :param bool upscale: If size is provided, this will upscale the image to fit the size dimensions.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SignedUrl
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_signed_url_with_http_info(file_id, **kwargs)  # noqa: E501

    def get_signed_url_with_http_info(self, file_id, **kwargs):  # noqa: E501
        """Get signed URL to access private file.  # noqa: E501

        Generates signed URL that allows temporary access to a private file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_signed_url_with_http_info(file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str file_id: ID of file. (required)
        :param str size: For image files. This will resize the image to the desired size before sharing. Does not affect the original file, just the file served by this signed URL.
        :param int expiration_seconds: How long in seconds the link will provide access to the file.
        :param bool upscale: If size is provided, this will upscale the image to fit the size dimensions.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SignedUrl, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["file_id", "size", "expiration_seconds", "upscale"]
        all_params.extend(["async_req", "_return_http_data_only", "_preload_content", "_request_timeout"])

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method get_signed_url" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and ("file_id" not in local_var_params or local_var_params["file_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_id` when calling `get_signed_url`")  # noqa: E501

        if self.api_client.client_side_validation and "file_id" in local_var_params and not re.search(r"\d+", local_var_params["file_id"]):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `file_id` when calling `get_signed_url`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if "file_id" in local_var_params:
            path_params["fileId"] = local_var_params["file_id"]  # noqa: E501

        query_params = []
        if "size" in local_var_params and local_var_params["size"] is not None:  # noqa: E501
            query_params.append(("size", local_var_params["size"]))  # noqa: E501
        if "expiration_seconds" in local_var_params and local_var_params["expiration_seconds"] is not None:  # noqa: E501
            query_params.append(("expirationSeconds", local_var_params["expiration_seconds"]))  # noqa: E501
        if "upscale" in local_var_params and local_var_params["upscale"] is not None:  # noqa: E501
            query_params.append(("upscale", local_var_params["upscale"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/files/v3/files/{fileId}/signed-url",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="SignedUrl",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def import_from_url(self, import_from_url_input, **kwargs):  # noqa: E501
        """Import a file from a URL into the file manager.  # noqa: E501

        Asynchronously imports the file at the given URL into the file manager.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_from_url(import_from_url_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ImportFromUrlInput import_from_url_input: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ImportFromUrlTaskLocator
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.import_from_url_with_http_info(import_from_url_input, **kwargs)  # noqa: E501

    def import_from_url_with_http_info(self, import_from_url_input, **kwargs):  # noqa: E501
        """Import a file from a URL into the file manager.  # noqa: E501

        Asynchronously imports the file at the given URL into the file manager.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.import_from_url_with_http_info(import_from_url_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ImportFromUrlInput import_from_url_input: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ImportFromUrlTaskLocator, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["import_from_url_input"]
        all_params.extend(["async_req", "_return_http_data_only", "_preload_content", "_request_timeout"])

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method import_from_url" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'import_from_url_input' is set
        if self.api_client.client_side_validation and ("import_from_url_input" not in local_var_params or local_var_params["import_from_url_input"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `import_from_url_input` when calling `import_from_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "import_from_url_input" in local_var_params:
            body_params = local_var_params["import_from_url_input"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])  # noqa: E501  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/files/v3/files/import-from-url/async",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="ImportFromUrlTaskLocator",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def replace(self, file_id, **kwargs):  # noqa: E501
        """Replace file.  # noqa: E501

        Replace existing file data with new file data. Can be used to change image content without having to upload a new file and update all references.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace(file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str file_id: Id of the desired file. (required)
        :param str user_agent:
        :param file file: File data that will replace existing file in the file manager.
        :param str charset_hunch: Character set of given file data.
        :param str options: JSON String representing FileReplaceOptions
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: File
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.replace_with_http_info(file_id, **kwargs)  # noqa: E501

    def replace_with_http_info(self, file_id, **kwargs):  # noqa: E501
        """Replace file.  # noqa: E501

        Replace existing file data with new file data. Can be used to change image content without having to upload a new file and update all references.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_with_http_info(file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str file_id: Id of the desired file. (required)
        :param str user_agent:
        :param file file: File data that will replace existing file in the file manager.
        :param str charset_hunch: Character set of given file data.
        :param str options: JSON String representing FileReplaceOptions
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(File, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["file_id", "user_agent", "file", "charset_hunch", "options"]
        all_params.extend(["async_req", "_return_http_data_only", "_preload_content", "_request_timeout"])

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method replace" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and ("file_id" not in local_var_params or local_var_params["file_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_id` when calling `replace`")  # noqa: E501

        if self.api_client.client_side_validation and "file_id" in local_var_params and not re.search(r"\d+", local_var_params["file_id"]):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `file_id` when calling `replace`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if "file_id" in local_var_params:
            path_params["fileId"] = local_var_params["file_id"]  # noqa: E501

        query_params = []

        header_params = {}
        if "user_agent" in local_var_params:
            header_params["User-Agent"] = local_var_params["user_agent"]  # noqa: E501

        form_params = []
        local_var_files = {}
        if "file" in local_var_params:
            local_var_files["file"] = local_var_params["file"]  # noqa: E501
        if "charset_hunch" in local_var_params:
            form_params.append(("charsetHunch", local_var_params["charset_hunch"]))  # noqa: E501
        if "options" in local_var_params:
            form_params.append(("options", local_var_params["options"]))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(["multipart/form-data"])  # noqa: E501  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/files/v3/files/{fileId}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="File",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_properties(self, file_id, file_update_input, **kwargs):  # noqa: E501
        """update file properties  # noqa: E501

        Update properties of file by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_properties(file_id, file_update_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str file_id: ID of file to update (required)
        :param FileUpdateInput file_update_input: Options to update. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: File
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.update_properties_with_http_info(file_id, file_update_input, **kwargs)  # noqa: E501

    def update_properties_with_http_info(self, file_id, file_update_input, **kwargs):  # noqa: E501
        """update file properties  # noqa: E501

        Update properties of file by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_properties_with_http_info(file_id, file_update_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str file_id: ID of file to update (required)
        :param FileUpdateInput file_update_input: Options to update. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(File, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["file_id", "file_update_input"]
        all_params.extend(["async_req", "_return_http_data_only", "_preload_content", "_request_timeout"])

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method update_properties" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and ("file_id" not in local_var_params or local_var_params["file_id"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_id` when calling `update_properties`")  # noqa: E501
        # verify the required parameter 'file_update_input' is set
        if self.api_client.client_side_validation and ("file_update_input" not in local_var_params or local_var_params["file_update_input"] is None):  # noqa: E501  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_update_input` when calling `update_properties`")  # noqa: E501

        if self.api_client.client_side_validation and "file_id" in local_var_params and not re.search(r"\d+", local_var_params["file_id"]):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `file_id` when calling `update_properties`, must conform to the pattern `/\d+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if "file_id" in local_var_params:
            path_params["fileId"] = local_var_params["file_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "file_update_input" in local_var_params:
            body_params = local_var_params["file_update_input"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(["application/json"])  # noqa: E501  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/files/v3/files/{fileId}",
            "PATCH",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="File",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def upload(self, **kwargs):  # noqa: E501
        """Upload file  # noqa: E501

        Upload a single file with content specified in request body.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_agent:
        :param file file: File to be uploaded.
        :param str folder_id: Either 'folderId' or 'folderPath' is required. folderId is the ID of the folder the file will be uploaded to.
        :param str folder_path: Either 'folderPath' or 'folderId' is required. This field represents the destination folder path for the uploaded file. If a path doesn't exist, the system will try to create one.
        :param str file_name: Desired name for the uploaded file.
        :param str charset_hunch: Character set of the uploaded file.
        :param str options: JSON string representing FileUploadOptions.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: File
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.upload_with_http_info(**kwargs)  # noqa: E501

    def upload_with_http_info(self, **kwargs):  # noqa: E501
        """Upload file  # noqa: E501

        Upload a single file with content specified in request body.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user_agent:
        :param file file: File to be uploaded.
        :param str folder_id: Either 'folderId' or 'folderPath' is required. folderId is the ID of the folder the file will be uploaded to.
        :param str folder_path: Either 'folderPath' or 'folderId' is required. This field represents the destination folder path for the uploaded file. If a path doesn't exist, the system will try to create one.
        :param str file_name: Desired name for the uploaded file.
        :param str charset_hunch: Character set of the uploaded file.
        :param str options: JSON string representing FileUploadOptions.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(File, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["user_agent", "file", "folder_id", "folder_path", "file_name", "charset_hunch", "options"]
        all_params.extend(["async_req", "_return_http_data_only", "_preload_content", "_request_timeout"])

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError("Got an unexpected keyword argument '%s'" " to method upload" % key)
            local_var_params[key] = val
        del local_var_params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if "user_agent" in local_var_params:
            header_params["User-Agent"] = local_var_params["user_agent"]  # noqa: E501

        form_params = []
        local_var_files = {}
        if "file" in local_var_params:
            local_var_files["file"] = local_var_params["file"]  # noqa: E501
        if "folder_id" in local_var_params:
            form_params.append(("folderId", local_var_params["folder_id"]))  # noqa: E501
        if "folder_path" in local_var_params:
            form_params.append(("folderPath", local_var_params["folder_path"]))  # noqa: E501
        if "file_name" in local_var_params:
            form_params.append(("fileName", local_var_params["file_name"]))  # noqa: E501
        if "charset_hunch" in local_var_params:
            form_params.append(("charsetHunch", local_var_params["charset_hunch"]))  # noqa: E501
        if "options" in local_var_params:
            form_params.append(("options", local_var_params["options"]))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(["application/json", "*/*"])  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(["multipart/form-data"])  # noqa: E501  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/files/v3/files",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="File",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
