/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./email_signals/src/ts/signal_change_form.ts");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./email_signals/src/ts/components/auto_complete_input.ts":
/*!****************************************************************!*\
  !*** ./email_signals/src/ts/components/auto_complete_input.ts ***!
  \****************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
var __values = (undefined && undefined.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var dropdownListID = function (input) {
    var id = input.id;
    if (!id) {
        id = input.name;
    }
    return id + 'autocomplete-list';
};
var autocomplete = function (input, options) {
    var currentFocus = -1;
    var inputID = dropdownListID(input);
    input.addEventListener("input", function (event) {
        var e_1, _a;
        var value = event.target.value;
        closeAllLists();
        if (!value) {
            return;
        }
        var listDiv = document.createElement("DIV");
        listDiv.setAttribute("id", inputID);
        listDiv.setAttribute("class", "autocomplete-items");
        input.parentNode.appendChild(listDiv);
        try {
            for (var options_1 = __values(options), options_1_1 = options_1.next(); !options_1_1.done; options_1_1 = options_1.next()) {
                var option = options_1_1.value;
                if (option.substr(0, value.length).toUpperCase() === value.toUpperCase()) {
                    var itemDiv = document.createElement("DIV");
                    itemDiv.innerHTML = "<strong>" + option.substr(0, value.length) + "</strong>";
                    itemDiv.innerHTML += option.substr(value.length);
                    itemDiv.innerHTML += "<input type=\"hidden\" value=\"".concat(option, "\">");
                    itemDiv.addEventListener("click", function (e) {
                        input.value = e.target.querySelector("input").value;
                        closeAllLists();
                    });
                    ;
                    listDiv.appendChild(itemDiv);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (options_1_1 && !options_1_1.done && (_a = options_1.return)) _a.call(options_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
    });
    input.addEventListener("keydown", function (event) {
        var listOptions = document.getElementById(inputID);
        if (listOptions) {
            listOptions = listOptions.getElementsByTagName("div");
        }
        if (event.key == 'ArrowDown') {
            currentFocus++;
            addActive(listOptions);
        }
        else if (event.key == 'ArrowUp') {
            currentFocus--;
            addActive(listOptions);
        }
        else if (event.key == 'Enter') {
            event.preventDefault();
            console.log(currentFocus);
            console.log(listOptions);
            if (currentFocus > -1) {
                if (listOptions[currentFocus]) {
                    listOptions[currentFocus].click();
                }
            }
        }
    });
    var addActive = function (listOptions) {
        removeActive(listOptions);
        if (currentFocus >= listOptions.length) {
            currentFocus = 0;
        }
        if (currentFocus < 0) {
            currentFocus = (listOptions.length - 1);
        }
        listOptions[currentFocus].classList.add("autocomplete-active");
    };
    var removeActive = function (listOptions) {
        for (var i = 0; i < listOptions.length; i++) {
            listOptions[i].classList.remove("autocomplete-active");
        }
    };
    var closeAllLists = function () {
        var lists = document.getElementsByClassName("autocomplete-items");
        for (var i = 0; i < lists.length; i++) {
            lists[i].parentNode.removeChild(lists[i]);
        }
    };
    document.addEventListener("click", closeAllLists);
};
/* harmony default export */ __webpack_exports__["default"] = (autocomplete);


/***/ }),

/***/ "./email_signals/src/ts/signal_change_form.ts":
/*!****************************************************!*\
  !*** ./email_signals/src/ts/signal_change_form.ts ***!
  \****************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _components_auto_complete_input__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./components/auto_complete_input */ "./email_signals/src/ts/components/auto_complete_input.ts");
var __read = (undefined && undefined.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (undefined && undefined.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};

var ParamInputs = (function () {
    function ParamInputs() {
        var _this = this;
        this.inputsRegistry = {};
        this.deleteBtnsRegistry = new Set();
        this.inputRows = function () { return +document.querySelector('#id_constraints-TOTAL_FORMS').value; };
        this.addInput = function (input) {
            _this.inputsRegistry[input.name] = input;
        };
        this.deleteInput = function (input) {
            delete _this.inputsRegistry[input.name];
        };
        this.getInput = function (name) {
            return _this.inputsRegistry[name];
        };
        this.inputList = function () {
            return Object.values(_this.inputsRegistry);
        };
        this.flushRegistry = function () {
            _this.inputsRegistry = {};
            _this.deleteBtnsRegistry = new Set();
        };
        this.registerDeleteBtns = function () {
            var deleteBtns = document.querySelectorAll('.inline-deletelink');
            for (var i = 0; i < deleteBtns.length; i++) {
                var btn = deleteBtns[i];
                if (!_this.deleteBtnsRegistry.has(btn)) {
                    _this.deleteBtnsRegistry.add(btn);
                    btn.addEventListener('click', _this.rebuildAll);
                }
            }
        };
        this.addInputsToRegistry = function () {
            for (var i = 0; i < _this.inputRows(); i++) {
                var param_1 = document.querySelector("#id_constraints-".concat(i, "-param_1"));
                var param_2 = document.querySelector("#id_constraints-".concat(i, "-param_2"));
                if (param_1) {
                    _this.addInput(param_1);
                }
                if (param_2) {
                    _this.addInput(param_2);
                }
            }
        };
        this.setDeleteBtnEventListeners = function () {
            _this.deleteBtnsRegistry.forEach(function (btn) {
                btn.removeEventListener('click', _this.rebuildAll);
                btn.addEventListener('click', _this.rebuildAll);
            });
        };
        this.setNewRowEventListener = function () {
            document.querySelector('.add-row a').addEventListener('click', _this.rebuildAll);
        };
        this.rebuildAll = function () {
            _this.flushRegistry();
            _this.addInputsToRegistry();
            _this.registerDeleteBtns();
            _this.setDeleteBtnEventListeners();
        };
        this.setNewRowEventListener();
        this.rebuildAll();
    }
    return ParamInputs;
}());
var ContentTypeSetup = (function () {
    function ContentTypeSetup(inputElems) {
        var _this = this;
        this.CONTENT_TYPE_SELECT_ELEM = document.getElementById('id_content_type');
        this.MODEL_ATTRS_API_URL = document.getElementById('model_attrs_api_url').value;
        this.inputOptions = [];
        this.setInputOptions = function () {
            return _this.callApi()
                .then(function (data) {
                _this.inputOptions = _this.getAvailableInputs(data);
                _this.inputElems().forEach(function (input) {
                    Object(_components_auto_complete_input__WEBPACK_IMPORTED_MODULE_0__["default"])(input, _this.inputOptions);
                });
            });
        };
        this.getContentTypeId = function () { return _this.CONTENT_TYPE_SELECT_ELEM.value; };
        this.callApi = function () {
            var url = _this.MODEL_ATTRS_API_URL.replace('<content_type_id>', _this.getContentTypeId());
            return fetch(url)
                .then(function (response) { return response.json(); })
                .then(function (data) { return data; });
        };
        this.getAvailableInputs = function (all_inputs, prefix) {
            if (prefix === void 0) { prefix = null; }
            var options = [];
            for (var key in all_inputs) {
                var _prefix = prefix ? "".concat(prefix, ".").concat(key) : key;
                options.push(_prefix);
                if (Object.keys(all_inputs[key]).length) {
                    options.push.apply(options, __spreadArray([], __read(_this.getAvailableInputs(all_inputs[key], _prefix)), false));
                }
            }
            return options;
        };
        this.hasModelAttrsUrl = this.MODEL_ATTRS_API_URL.length > 0;
        this.inputElems = inputElems;
        this.setInputOptions();
    }
    ContentTypeSetup.prototype.setUpEventListener = function () {
        if (!this.hasModelAttrsUrl)
            return;
        this.CONTENT_TYPE_SELECT_ELEM.addEventListener('change', this.setInputOptions);
        document.querySelector('.add-row a').addEventListener('click', this.setInputOptions);
    };
    return ContentTypeSetup;
}());
setTimeout(function () {
    var paramInputs = new ParamInputs();
    new ContentTypeSetup(paramInputs.inputList).setUpEventListener();
}, 500);


/***/ })

/******/ });
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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