import { IReceiptRule } from './receipt-rule';
/**
 * An abstract action for a receipt rule.
 *
 * @stability stable
 */
export interface IReceiptRuleAction {
    /**
     * Returns the receipt rule action specification.
     *
     * @stability stable
     */
    bind(receiptRule: IReceiptRule): ReceiptRuleActionConfig;
}
/**
 * AddHeaderAction configuration.
 *
 * @stability stable
 */
export interface AddHeaderActionConfig {
    /**
     * The name of the header that you want to add to the incoming message.
     *
     * @stability stable
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-addheaderaction.html#cfn-ses-receiptrule-addheaderaction-headername
     */
    readonly headerName: string;
    /**
     * The content that you want to include in the header.
     *
     * @stability stable
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-addheaderaction.html#cfn-ses-receiptrule-addheaderaction-headervalue
     */
    readonly headerValue: string;
}
/**
 * BoundAction configuration.
 *
 * @stability stable
 */
export interface BounceActionConfig {
    /**
     * Human-readable text to include in the bounce message.
     *
     * @stability stable
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-bounceaction.html#cfn-ses-receiptrule-bounceaction-message
     */
    readonly message: string;
    /**
     * The email address of the sender of the bounced email.
     *
     * This is the address that the bounce message is sent from.
     *
     * @stability stable
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-bounceaction.html#cfn-ses-receiptrule-bounceaction-sender
     */
    readonly sender: string;
    /**
     * The SMTP reply code, as defined by RFC 5321.
     *
     * @stability stable
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-bounceaction.html#cfn-ses-receiptrule-bounceaction-smtpreplycode
     */
    readonly smtpReplyCode: string;
    /**
     * The SMTP enhanced status code, as defined by RFC 3463.
     *
     * @default - No status code.
     * @stability stable
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-bounceaction.html#cfn-ses-receiptrule-bounceaction-statuscode
     */
    readonly statusCode?: string;
    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the bounce action is taken.
     *
     * @default - No notification is sent to SNS.
     * @stability stable
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-bounceaction.html#cfn-ses-receiptrule-bounceaction-topicarn
     */
    readonly topicArn?: string;
}
/**
 * LambdaAction configuration.
 *
 * @stability stable
 */
export interface LambdaActionConfig {
    /**
     * The Amazon Resource Name (ARN) of the AWS Lambda function.
     *
     * @stability stable
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-lambdaaction.html#cfn-ses-receiptrule-lambdaaction-functionarn
     */
    readonly functionArn: string;
    /**
     * The invocation type of the AWS Lambda function.
     *
     * @default 'Event'
     * @stability stable
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-lambdaaction.html#cfn-ses-receiptrule-lambdaaction-invocationtype
     */
    readonly invocationType?: string;
    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the Lambda action is executed.
     *
     * @default - No notification is sent to SNS.
     * @stability stable
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-lambdaaction.html#cfn-ses-receiptrule-lambdaaction-topicarn
     */
    readonly topicArn?: string;
}
/**
 * S3Action configuration.
 *
 * @stability stable
 */
export interface S3ActionConfig {
    /**
     * The name of the Amazon S3 bucket that you want to send incoming mail to.
     *
     * @stability stable
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-s3action.html#cfn-ses-receiptrule-s3action-bucketname
     */
    readonly bucketName: string;
    /**
     * The customer master key that Amazon SES should use to encrypt your emails before saving them to the Amazon S3 bucket.
     *
     * @default - Emails are not encrypted.
     * @stability stable
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-s3action.html#cfn-ses-receiptrule-s3action-kmskeyarn
     */
    readonly kmsKeyArn?: string;
    /**
     * The key prefix of the Amazon S3 bucket.
     *
     * @default - No prefix.
     * @stability stable
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-s3action.html#cfn-ses-receiptrule-s3action-objectkeyprefix
     */
    readonly objectKeyPrefix?: string;
    /**
     * The ARN of the Amazon SNS topic to notify when the message is saved to the Amazon S3 bucket.
     *
     * @default - No notification is sent to SNS.
     * @stability stable
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-s3action.html#cfn-ses-receiptrule-s3action-topicarn
     */
    readonly topicArn?: string;
}
/**
 * SNSAction configuration.
 *
 * @stability stable
 */
export interface SNSActionConfig {
    /**
     * The encoding to use for the email within the Amazon SNS notification.
     *
     * @default 'UTF-8'
     * @stability stable
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-snsaction.html#cfn-ses-receiptrule-snsaction-encoding
     */
    readonly encoding?: string;
    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS topic to notify.
     *
     * @default - No notification is sent to SNS.
     * @stability stable
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-snsaction.html#cfn-ses-receiptrule-snsaction-topicarn
     */
    readonly topicArn?: string;
}
/**
 * StopAction configuration.
 *
 * @stability stable
 */
export interface StopActionConfig {
    /**
     * The scope of the StopAction.
     *
     * The only acceptable value is RuleSet.
     *
     * @stability stable
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-stopaction.html#cfn-ses-receiptrule-stopaction-scope
     */
    readonly scope: string;
    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the stop action is taken.
     *
     * @default - No notification is sent to SNS.
     * @stability stable
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-stopaction.html#cfn-ses-receiptrule-stopaction-topicarn
     */
    readonly topicArn?: string;
}
/**
 * WorkmailAction configuration.
 *
 * @stability stable
 */
export interface WorkmailActionConfig {
    /**
     * The Amazon Resource Name (ARN) of the Amazon WorkMail organization.
     *
     * @stability stable
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-workmailaction.html#cfn-ses-receiptrule-workmailaction-organizationarn
     */
    readonly organizationArn: string;
    /**
     * The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the WorkMail action is called.
     *
     * @default - No notification is sent to SNS.
     * @stability stable
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-receiptrule-workmailaction.html#cfn-ses-receiptrule-workmailaction-topicarn
     */
    readonly topicArn?: string;
}
/**
 * Properties for a receipt rule action.
 *
 * @stability stable
 */
export interface ReceiptRuleActionConfig {
    /**
     * Adds a header to the received email.
     *
     * @stability stable
     */
    readonly addHeaderAction?: AddHeaderActionConfig;
    /**
     * Rejects the received email by returning a bounce response to the sender and, optionally, publishes a notification to Amazon SNS.
     *
     * @stability stable
     */
    readonly bounceAction?: BounceActionConfig;
    /**
     * Calls an AWS Lambda function, and optionally, publishes a notification to Amazon SNS.
     *
     * @stability stable
     */
    readonly lambdaAction?: LambdaActionConfig;
    /**
     * Saves the received message to an Amazon S3 bucket and, optionally, publishes a notification to Amazon SNS.
     *
     * @stability stable
     */
    readonly s3Action?: S3ActionConfig;
    /**
     * Publishes the email content within a notification to Amazon SNS.
     *
     * @stability stable
     */
    readonly snsAction?: SNSActionConfig;
    /**
     * Terminates the evaluation of the receipt rule set and optionally publishes a notification to Amazon SNS.
     *
     * @stability stable
     */
    readonly stopAction?: StopActionConfig;
    /**
     * Calls Amazon WorkMail and, optionally, publishes a notification to Amazon SNS.
     *
     * @stability stable
     */
    readonly workmailAction?: WorkmailActionConfig;
}
