import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::LicenseManager::Grant`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html
 * @external
 */
export interface CfnGrantProps {
    /**
     * `AWS::LicenseManager::Grant.AllowedOperations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-allowedoperations
     * @external
     */
    readonly allowedOperations?: CfnGrant.AllowedOperationListProperty | cdk.IResolvable;
    /**
     * `AWS::LicenseManager::Grant.ClientToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-clienttoken
     * @external
     */
    readonly clientToken?: string;
    /**
     * `AWS::LicenseManager::Grant.Filters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-filters
     * @external
     */
    readonly filters?: CfnGrant.FilterListProperty | cdk.IResolvable;
    /**
     * `AWS::LicenseManager::Grant.GrantArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-grantarns
     * @external
     */
    readonly grantArns?: CfnGrant.ArnListProperty | cdk.IResolvable;
    /**
     * `AWS::LicenseManager::Grant.GrantedOperations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-grantedoperations
     * @external
     */
    readonly grantedOperations?: CfnGrant.AllowedOperationListProperty | cdk.IResolvable;
    /**
     * `AWS::LicenseManager::Grant.GranteePrincipalArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-granteeprincipalarn
     * @external
     */
    readonly granteePrincipalArn?: string;
    /**
     * `AWS::LicenseManager::Grant.GrantName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-grantname
     * @external
     */
    readonly grantName?: string;
    /**
     * `AWS::LicenseManager::Grant.GrantStatus`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-grantstatus
     * @external
     */
    readonly grantStatus?: string;
    /**
     * `AWS::LicenseManager::Grant.HomeRegion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-homeregion
     * @external
     */
    readonly homeRegion?: string;
    /**
     * `AWS::LicenseManager::Grant.LicenseArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-licensearn
     * @external
     */
    readonly licenseArn?: string;
    /**
     * `AWS::LicenseManager::Grant.MaxResults`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-maxresults
     * @external
     */
    readonly maxResults?: number;
    /**
     * `AWS::LicenseManager::Grant.NextToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-nexttoken
     * @external
     */
    readonly nextToken?: string;
    /**
     * `AWS::LicenseManager::Grant.ParentArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-parentarn
     * @external
     */
    readonly parentArn?: string;
    /**
     * `AWS::LicenseManager::Grant.Principals`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-principals
     * @external
     */
    readonly principals?: CfnGrant.ArnListProperty | cdk.IResolvable;
    /**
     * `AWS::LicenseManager::Grant.SourceVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-sourceversion
     * @external
     */
    readonly sourceVersion?: string;
    /**
     * `AWS::LicenseManager::Grant.Status`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-status
     * @external
     */
    readonly status?: string;
    /**
     * `AWS::LicenseManager::Grant.StatusReason`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-statusreason
     * @external
     */
    readonly statusReason?: string;
    /**
     * `AWS::LicenseManager::Grant.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-tags
     * @external
     */
    readonly tags?: CfnGrant.TagListProperty;
    /**
     * `AWS::LicenseManager::Grant.Version`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-version
     * @external
     */
    readonly version?: string;
}
/**
 * A CloudFormation `AWS::LicenseManager::Grant`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html
 * @external
 * @cloudformationResource AWS::LicenseManager::Grant
 */
export declare class CfnGrant extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::LicenseManager::Grant";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnGrant;
    /**
     * @external
     * @cloudformationAttribute GrantArn
     */
    readonly attrGrantArn: string;
    /**
     * `AWS::LicenseManager::Grant.AllowedOperations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-allowedoperations
     * @external
     */
    allowedOperations: CfnGrant.AllowedOperationListProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::LicenseManager::Grant.ClientToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-clienttoken
     * @external
     */
    clientToken: string | undefined;
    /**
     * `AWS::LicenseManager::Grant.Filters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-filters
     * @external
     */
    filters: CfnGrant.FilterListProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::LicenseManager::Grant.GrantArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-grantarns
     * @external
     */
    grantArns: CfnGrant.ArnListProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::LicenseManager::Grant.GrantedOperations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-grantedoperations
     * @external
     */
    grantedOperations: CfnGrant.AllowedOperationListProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::LicenseManager::Grant.GranteePrincipalArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-granteeprincipalarn
     * @external
     */
    granteePrincipalArn: string | undefined;
    /**
     * `AWS::LicenseManager::Grant.GrantName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-grantname
     * @external
     */
    grantName: string | undefined;
    /**
     * `AWS::LicenseManager::Grant.GrantStatus`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-grantstatus
     * @external
     */
    grantStatus: string | undefined;
    /**
     * `AWS::LicenseManager::Grant.HomeRegion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-homeregion
     * @external
     */
    homeRegion: string | undefined;
    /**
     * `AWS::LicenseManager::Grant.LicenseArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-licensearn
     * @external
     */
    licenseArn: string | undefined;
    /**
     * `AWS::LicenseManager::Grant.MaxResults`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-maxresults
     * @external
     */
    maxResults: number | undefined;
    /**
     * `AWS::LicenseManager::Grant.NextToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-nexttoken
     * @external
     */
    nextToken: string | undefined;
    /**
     * `AWS::LicenseManager::Grant.ParentArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-parentarn
     * @external
     */
    parentArn: string | undefined;
    /**
     * `AWS::LicenseManager::Grant.Principals`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-principals
     * @external
     */
    principals: CfnGrant.ArnListProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::LicenseManager::Grant.SourceVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-sourceversion
     * @external
     */
    sourceVersion: string | undefined;
    /**
     * `AWS::LicenseManager::Grant.Status`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-status
     * @external
     */
    status: string | undefined;
    /**
     * `AWS::LicenseManager::Grant.StatusReason`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-statusreason
     * @external
     */
    statusReason: string | undefined;
    /**
     * `AWS::LicenseManager::Grant.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-tags
     * @external
     */
    tags: CfnGrant.TagListProperty | undefined;
    /**
     * `AWS::LicenseManager::Grant.Version`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-version
     * @external
     */
    version: string | undefined;
    /**
     * Create a new `AWS::LicenseManager::Grant`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnGrantProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::LicenseManager::Grant`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html
 * @external
 * @cloudformationResource AWS::LicenseManager::Grant
 */
export declare namespace CfnGrant {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-grant-allowedoperationlist.html
     * @external
     */
    interface AllowedOperationListProperty {
        /**
         * `CfnGrant.AllowedOperationListProperty.AllowedOperationList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-grant-allowedoperationlist.html#cfn-licensemanager-grant-allowedoperationlist-allowedoperationlist
         * @external
         */
        readonly allowedOperationList?: string[];
    }
}
/**
 * A CloudFormation `AWS::LicenseManager::Grant`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html
 * @external
 * @cloudformationResource AWS::LicenseManager::Grant
 */
export declare namespace CfnGrant {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-grant-arnlist.html
     * @external
     */
    interface ArnListProperty {
        /**
         * `CfnGrant.ArnListProperty.ArnList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-grant-arnlist.html#cfn-licensemanager-grant-arnlist-arnlist
         * @external
         */
        readonly arnList?: string[];
    }
}
/**
 * A CloudFormation `AWS::LicenseManager::Grant`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html
 * @external
 * @cloudformationResource AWS::LicenseManager::Grant
 */
export declare namespace CfnGrant {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-grant-filter.html
     * @external
     */
    interface FilterProperty {
        /**
         * `CfnGrant.FilterProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-grant-filter.html#cfn-licensemanager-grant-filter-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnGrant.FilterProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-grant-filter.html#cfn-licensemanager-grant-filter-values
         * @external
         */
        readonly values: CfnGrant.StringListProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::LicenseManager::Grant`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html
 * @external
 * @cloudformationResource AWS::LicenseManager::Grant
 */
export declare namespace CfnGrant {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-grant-filterlist.html
     * @external
     */
    interface FilterListProperty {
        /**
         * `CfnGrant.FilterListProperty.FilterList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-grant-filterlist.html#cfn-licensemanager-grant-filterlist-filterlist
         * @external
         */
        readonly filterList?: Array<CfnGrant.FilterProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::LicenseManager::Grant`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html
 * @external
 * @cloudformationResource AWS::LicenseManager::Grant
 */
export declare namespace CfnGrant {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-grant-stringlist.html
     * @external
     */
    interface StringListProperty {
        /**
         * `CfnGrant.StringListProperty.StringList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-grant-stringlist.html#cfn-licensemanager-grant-stringlist-stringlist
         * @external
         */
        readonly stringList?: string[];
    }
}
/**
 * A CloudFormation `AWS::LicenseManager::Grant`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html
 * @external
 * @cloudformationResource AWS::LicenseManager::Grant
 */
export declare namespace CfnGrant {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-grant-taglist.html
     * @external
     */
    interface TagListProperty {
        /**
         * `CfnGrant.TagListProperty.TagList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-grant-taglist.html#cfn-licensemanager-grant-taglist-taglist
         * @external
         */
        readonly tagList?: Array<cdk.CfnTag | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::LicenseManager::License`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html
 * @external
 */
export interface CfnLicenseProps {
    /**
     * `AWS::LicenseManager::License.ConsumptionConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-consumptionconfiguration
     * @external
     */
    readonly consumptionConfiguration: CfnLicense.ConsumptionConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::LicenseManager::License.Entitlements`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-entitlements
     * @external
     */
    readonly entitlements: CfnLicense.EntitlementListProperty | cdk.IResolvable;
    /**
     * `AWS::LicenseManager::License.HomeRegion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-homeregion
     * @external
     */
    readonly homeRegion: string;
    /**
     * `AWS::LicenseManager::License.Issuer`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-issuer
     * @external
     */
    readonly issuer: CfnLicense.IssuerDataProperty | cdk.IResolvable;
    /**
     * `AWS::LicenseManager::License.Validity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-validity
     * @external
     */
    readonly validity: CfnLicense.ValidityDateFormatProperty | cdk.IResolvable;
    /**
     * `AWS::LicenseManager::License.Beneficiary`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-beneficiary
     * @external
     */
    readonly beneficiary?: string;
    /**
     * `AWS::LicenseManager::License.ClientToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-clienttoken
     * @external
     */
    readonly clientToken?: string;
    /**
     * `AWS::LicenseManager::License.Filters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-filters
     * @external
     */
    readonly filters?: CfnLicense.FilterListProperty | cdk.IResolvable;
    /**
     * `AWS::LicenseManager::License.LicenseArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-licensearns
     * @external
     */
    readonly licenseArns?: CfnLicense.ArnListProperty | cdk.IResolvable;
    /**
     * `AWS::LicenseManager::License.LicenseMetadata`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-licensemetadata
     * @external
     */
    readonly licenseMetadata?: CfnLicense.MetadataListProperty | cdk.IResolvable;
    /**
     * `AWS::LicenseManager::License.LicenseName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-licensename
     * @external
     */
    readonly licenseName?: string;
    /**
     * `AWS::LicenseManager::License.MaxResults`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-maxresults
     * @external
     */
    readonly maxResults?: number;
    /**
     * `AWS::LicenseManager::License.NextToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-nexttoken
     * @external
     */
    readonly nextToken?: string;
    /**
     * `AWS::LicenseManager::License.ProductName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-productname
     * @external
     */
    readonly productName?: string;
    /**
     * `AWS::LicenseManager::License.ProductSKU`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-productsku
     * @external
     */
    readonly productSku?: string;
    /**
     * `AWS::LicenseManager::License.SourceVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-sourceversion
     * @external
     */
    readonly sourceVersion?: string;
    /**
     * `AWS::LicenseManager::License.Status`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-status
     * @external
     */
    readonly status?: string;
    /**
     * `AWS::LicenseManager::License.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-tags
     * @external
     */
    readonly tags?: CfnLicense.TagListProperty;
    /**
     * `AWS::LicenseManager::License.Version`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-version
     * @external
     */
    readonly version?: string;
}
/**
 * A CloudFormation `AWS::LicenseManager::License`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html
 * @external
 * @cloudformationResource AWS::LicenseManager::License
 */
export declare class CfnLicense extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::LicenseManager::License";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLicense;
    /**
     * @external
     * @cloudformationAttribute LicenseArn
     */
    readonly attrLicenseArn: string;
    /**
     * `AWS::LicenseManager::License.ConsumptionConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-consumptionconfiguration
     * @external
     */
    consumptionConfiguration: CfnLicense.ConsumptionConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::LicenseManager::License.Entitlements`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-entitlements
     * @external
     */
    entitlements: CfnLicense.EntitlementListProperty | cdk.IResolvable;
    /**
     * `AWS::LicenseManager::License.HomeRegion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-homeregion
     * @external
     */
    homeRegion: string;
    /**
     * `AWS::LicenseManager::License.Issuer`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-issuer
     * @external
     */
    issuer: CfnLicense.IssuerDataProperty | cdk.IResolvable;
    /**
     * `AWS::LicenseManager::License.Validity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-validity
     * @external
     */
    validity: CfnLicense.ValidityDateFormatProperty | cdk.IResolvable;
    /**
     * `AWS::LicenseManager::License.Beneficiary`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-beneficiary
     * @external
     */
    beneficiary: string | undefined;
    /**
     * `AWS::LicenseManager::License.ClientToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-clienttoken
     * @external
     */
    clientToken: string | undefined;
    /**
     * `AWS::LicenseManager::License.Filters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-filters
     * @external
     */
    filters: CfnLicense.FilterListProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::LicenseManager::License.LicenseArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-licensearns
     * @external
     */
    licenseArns: CfnLicense.ArnListProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::LicenseManager::License.LicenseMetadata`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-licensemetadata
     * @external
     */
    licenseMetadata: CfnLicense.MetadataListProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::LicenseManager::License.LicenseName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-licensename
     * @external
     */
    licenseName: string | undefined;
    /**
     * `AWS::LicenseManager::License.MaxResults`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-maxresults
     * @external
     */
    maxResults: number | undefined;
    /**
     * `AWS::LicenseManager::License.NextToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-nexttoken
     * @external
     */
    nextToken: string | undefined;
    /**
     * `AWS::LicenseManager::License.ProductName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-productname
     * @external
     */
    productName: string | undefined;
    /**
     * `AWS::LicenseManager::License.ProductSKU`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-productsku
     * @external
     */
    productSku: string | undefined;
    /**
     * `AWS::LicenseManager::License.SourceVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-sourceversion
     * @external
     */
    sourceVersion: string | undefined;
    /**
     * `AWS::LicenseManager::License.Status`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-status
     * @external
     */
    status: string | undefined;
    /**
     * `AWS::LicenseManager::License.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-tags
     * @external
     */
    tags: CfnLicense.TagListProperty | undefined;
    /**
     * `AWS::LicenseManager::License.Version`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-version
     * @external
     */
    version: string | undefined;
    /**
     * Create a new `AWS::LicenseManager::License`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLicenseProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::LicenseManager::License`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html
 * @external
 * @cloudformationResource AWS::LicenseManager::License
 */
export declare namespace CfnLicense {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-arnlist.html
     * @external
     */
    interface ArnListProperty {
        /**
         * `CfnLicense.ArnListProperty.ArnList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-arnlist.html#cfn-licensemanager-license-arnlist-arnlist
         * @external
         */
        readonly arnList?: string[];
    }
}
/**
 * A CloudFormation `AWS::LicenseManager::License`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html
 * @external
 * @cloudformationResource AWS::LicenseManager::License
 */
export declare namespace CfnLicense {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-borrowconfiguration.html
     * @external
     */
    interface BorrowConfigurationProperty {
        /**
         * `CfnLicense.BorrowConfigurationProperty.AllowEarlyCheckIn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-borrowconfiguration.html#cfn-licensemanager-license-borrowconfiguration-allowearlycheckin
         * @external
         */
        readonly allowEarlyCheckIn: boolean | cdk.IResolvable;
        /**
         * `CfnLicense.BorrowConfigurationProperty.MaxTimeToLiveInMinutes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-borrowconfiguration.html#cfn-licensemanager-license-borrowconfiguration-maxtimetoliveinminutes
         * @external
         */
        readonly maxTimeToLiveInMinutes: number;
    }
}
/**
 * A CloudFormation `AWS::LicenseManager::License`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html
 * @external
 * @cloudformationResource AWS::LicenseManager::License
 */
export declare namespace CfnLicense {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-consumptionconfiguration.html
     * @external
     */
    interface ConsumptionConfigurationProperty {
        /**
         * `CfnLicense.ConsumptionConfigurationProperty.BorrowConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-consumptionconfiguration.html#cfn-licensemanager-license-consumptionconfiguration-borrowconfiguration
         * @external
         */
        readonly borrowConfiguration?: CfnLicense.BorrowConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnLicense.ConsumptionConfigurationProperty.ProvisionalConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-consumptionconfiguration.html#cfn-licensemanager-license-consumptionconfiguration-provisionalconfiguration
         * @external
         */
        readonly provisionalConfiguration?: CfnLicense.ProvisionalConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnLicense.ConsumptionConfigurationProperty.RenewType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-consumptionconfiguration.html#cfn-licensemanager-license-consumptionconfiguration-renewtype
         * @external
         */
        readonly renewType?: string;
    }
}
/**
 * A CloudFormation `AWS::LicenseManager::License`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html
 * @external
 * @cloudformationResource AWS::LicenseManager::License
 */
export declare namespace CfnLicense {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-entitlement.html
     * @external
     */
    interface EntitlementProperty {
        /**
         * `CfnLicense.EntitlementProperty.AllowCheckIn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-entitlement.html#cfn-licensemanager-license-entitlement-allowcheckin
         * @external
         */
        readonly allowCheckIn?: boolean | cdk.IResolvable;
        /**
         * `CfnLicense.EntitlementProperty.CheckoutRules`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-entitlement.html#cfn-licensemanager-license-entitlement-checkoutrules
         * @external
         */
        readonly checkoutRules?: CfnLicense.RuleListProperty | cdk.IResolvable;
        /**
         * `CfnLicense.EntitlementProperty.MaxCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-entitlement.html#cfn-licensemanager-license-entitlement-maxcount
         * @external
         */
        readonly maxCount?: number;
        /**
         * `CfnLicense.EntitlementProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-entitlement.html#cfn-licensemanager-license-entitlement-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnLicense.EntitlementProperty.Overage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-entitlement.html#cfn-licensemanager-license-entitlement-overage
         * @external
         */
        readonly overage?: boolean | cdk.IResolvable;
        /**
         * `CfnLicense.EntitlementProperty.Unit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-entitlement.html#cfn-licensemanager-license-entitlement-unit
         * @external
         */
        readonly unit: string;
        /**
         * `CfnLicense.EntitlementProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-entitlement.html#cfn-licensemanager-license-entitlement-value
         * @external
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::LicenseManager::License`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html
 * @external
 * @cloudformationResource AWS::LicenseManager::License
 */
export declare namespace CfnLicense {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-entitlementlist.html
     * @external
     */
    interface EntitlementListProperty {
        /**
         * `CfnLicense.EntitlementListProperty.EntitlementList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-entitlementlist.html#cfn-licensemanager-license-entitlementlist-entitlementlist
         * @external
         */
        readonly entitlementList?: Array<CfnLicense.EntitlementProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::LicenseManager::License`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html
 * @external
 * @cloudformationResource AWS::LicenseManager::License
 */
export declare namespace CfnLicense {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-filter.html
     * @external
     */
    interface FilterProperty {
        /**
         * `CfnLicense.FilterProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-filter.html#cfn-licensemanager-license-filter-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnLicense.FilterProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-filter.html#cfn-licensemanager-license-filter-values
         * @external
         */
        readonly values: CfnLicense.StringListProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::LicenseManager::License`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html
 * @external
 * @cloudformationResource AWS::LicenseManager::License
 */
export declare namespace CfnLicense {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-filterlist.html
     * @external
     */
    interface FilterListProperty {
        /**
         * `CfnLicense.FilterListProperty.FilterList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-filterlist.html#cfn-licensemanager-license-filterlist-filterlist
         * @external
         */
        readonly filterList?: Array<CfnLicense.FilterProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::LicenseManager::License`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html
 * @external
 * @cloudformationResource AWS::LicenseManager::License
 */
export declare namespace CfnLicense {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-issuerdata.html
     * @external
     */
    interface IssuerDataProperty {
        /**
         * `CfnLicense.IssuerDataProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-issuerdata.html#cfn-licensemanager-license-issuerdata-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnLicense.IssuerDataProperty.SignKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-issuerdata.html#cfn-licensemanager-license-issuerdata-signkey
         * @external
         */
        readonly signKey?: string;
    }
}
/**
 * A CloudFormation `AWS::LicenseManager::License`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html
 * @external
 * @cloudformationResource AWS::LicenseManager::License
 */
export declare namespace CfnLicense {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-metadata.html
     * @external
     */
    interface MetadataProperty {
        /**
         * `CfnLicense.MetadataProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-metadata.html#cfn-licensemanager-license-metadata-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnLicense.MetadataProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-metadata.html#cfn-licensemanager-license-metadata-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::LicenseManager::License`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html
 * @external
 * @cloudformationResource AWS::LicenseManager::License
 */
export declare namespace CfnLicense {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-metadatalist.html
     * @external
     */
    interface MetadataListProperty {
        /**
         * `CfnLicense.MetadataListProperty.MetadataList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-metadatalist.html#cfn-licensemanager-license-metadatalist-metadatalist
         * @external
         */
        readonly metadataList?: Array<CfnLicense.MetadataProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::LicenseManager::License`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html
 * @external
 * @cloudformationResource AWS::LicenseManager::License
 */
export declare namespace CfnLicense {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-provisionalconfiguration.html
     * @external
     */
    interface ProvisionalConfigurationProperty {
        /**
         * `CfnLicense.ProvisionalConfigurationProperty.MaxTimeToLiveInMinutes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-provisionalconfiguration.html#cfn-licensemanager-license-provisionalconfiguration-maxtimetoliveinminutes
         * @external
         */
        readonly maxTimeToLiveInMinutes: number;
    }
}
/**
 * A CloudFormation `AWS::LicenseManager::License`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html
 * @external
 * @cloudformationResource AWS::LicenseManager::License
 */
export declare namespace CfnLicense {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-rule.html
     * @external
     */
    interface RuleProperty {
        /**
         * `CfnLicense.RuleProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-rule.html#cfn-licensemanager-license-rule-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnLicense.RuleProperty.Unit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-rule.html#cfn-licensemanager-license-rule-unit
         * @external
         */
        readonly unit: string;
        /**
         * `CfnLicense.RuleProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-rule.html#cfn-licensemanager-license-rule-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::LicenseManager::License`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html
 * @external
 * @cloudformationResource AWS::LicenseManager::License
 */
export declare namespace CfnLicense {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-rulelist.html
     * @external
     */
    interface RuleListProperty {
        /**
         * `CfnLicense.RuleListProperty.RuleList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-rulelist.html#cfn-licensemanager-license-rulelist-rulelist
         * @external
         */
        readonly ruleList?: Array<CfnLicense.RuleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::LicenseManager::License`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html
 * @external
 * @cloudformationResource AWS::LicenseManager::License
 */
export declare namespace CfnLicense {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-stringlist.html
     * @external
     */
    interface StringListProperty {
        /**
         * `CfnLicense.StringListProperty.StringList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-stringlist.html#cfn-licensemanager-license-stringlist-stringlist
         * @external
         */
        readonly stringList?: string[];
    }
}
/**
 * A CloudFormation `AWS::LicenseManager::License`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html
 * @external
 * @cloudformationResource AWS::LicenseManager::License
 */
export declare namespace CfnLicense {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-taglist.html
     * @external
     */
    interface TagListProperty {
        /**
         * `CfnLicense.TagListProperty.TagList`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-taglist.html#cfn-licensemanager-license-taglist-taglist
         * @external
         */
        readonly tagList?: Array<cdk.CfnTag | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::LicenseManager::License`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html
 * @external
 * @cloudformationResource AWS::LicenseManager::License
 */
export declare namespace CfnLicense {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-validitydateformat.html
     * @external
     */
    interface ValidityDateFormatProperty {
        /**
         * `CfnLicense.ValidityDateFormatProperty.Begin`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-validitydateformat.html#cfn-licensemanager-license-validitydateformat-begin
         * @external
         */
        readonly begin: string;
        /**
         * `CfnLicense.ValidityDateFormatProperty.End`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-validitydateformat.html#cfn-licensemanager-license-validitydateformat-end
         * @external
         */
        readonly end: string;
    }
}
