from __future__ import annotations

from typing import TYPE_CHECKING

from poetry.repositories import Repository


if TYPE_CHECKING:
    from poetry.core.packages.package import Package


class LockfileRepository(Repository):
    """
    Special repository that distinguishes packages not only by name and version,
    but also by source type, url, etc.
    """

    def has_package(self, package: Package) -> bool:
        return any(p == package for p in self.packages)

    def remove_package(self, package: Package) -> None:
        index = None
        for i, repo_package in enumerate(self.packages):
            if repo_package == package:
                index = i
                break

        if index is not None:
            del self._packages[index]
